CREATE TABLE `access_info` (
  `user_id` int(10) unsigned NOT NULL,
  `login_period` datetime NOT NULL,
  `logout_period` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8; 

CREATE TABLE `ad_pay` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `pay_amount` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `ad_salary` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` int(10) NOT NULL,
  `date` date NOT NULL,
  `advance_amount` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `admissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `guardian` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `seat` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `bill` int(11) NOT NULL COMMENT 'ID of bills table',
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'admitted' COMMENT 'admitted or released',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `patient_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `father_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `age` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `gender` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `religion` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `village` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `post_office` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `district` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `upazila` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `admission_date` date NOT NULL,
  `admission_time` time NOT NULL,
  `disease` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `doctor_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `clearance_date` date NOT NULL,
  `clearance_time` time NOT NULL,
  `bed_no` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `phone_no` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ref_doctor_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `op_relation` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `op_pa_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `op_age` int(7) NOT NULL,
  `op_village` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `op_post_office` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `op_district` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `op_upazila` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type_of_unconscious` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name_of_operation` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name_of_witness` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `father_name_of_witness` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `village_of_witness` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `witness_district` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `witness_upazila` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `witness_date` date NOT NULL,
  `name_of_consentant` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `father_name_of_consentant` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `village_of_consentant` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `consentant_district` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `consentant_upazila` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `consentant_date` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `bank_account` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `datetime` date NOT NULL,
  `bank_name` varchar(255) NOT NULL,
  `holder_name` varchar(255) NOT NULL,
  `account_number` varchar(100) NOT NULL,
  `pre_balance` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8; 

CREATE TABLE `bank_name` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `bank_name` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `bills` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `voucher` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `pid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `details` longtext COLLATE utf8_unicode_ci NOT NULL,
  `subtotal` decimal(10,2) NOT NULL COMMENT 'Without  Vat amount',
  `vat` int(100) NOT NULL COMMENT 'Vat percentage',
  `vat_amount` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `last_paid` decimal(10,2) NOT NULL,
  `last_payment_date` date NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `bonus_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `fields` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `percentage` decimal(10,2) NOT NULL,
  `remarks` text COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `brand` (
  `id` int(45) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `name` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `trash` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `category` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `brand` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `trash` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `closing` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `opening` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `income` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `cost` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `salary_cost` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `bank` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `hand_cash` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `opening_type` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'auto',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `commission_payment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_date` date NOT NULL,
  `type` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `person_id` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `balance` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `commissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `ref` varchar(45) COLLATE utf8_unicode_ci NOT NULL COMMENT 'expression [ registration:10 or pathology:15 ]. registration -> ID = 10 and pathology -> ID = 15',
  `person` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `person_id` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT 'doctors:ID or marketer:ID or pc:ID',
  `type` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `consultancies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `doctor` varchar(45) COLLATE utf8_unicode_ci NOT NULL COMMENT 'ID of doctors table',
  `room` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'any description for patient',
  `bill` int(11) NOT NULL COMMENT 'ID of bills table',
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'pending' COMMENT 'pending or complete',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `cost` (
  `id` int(100) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `cost_field` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `amount` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `spend_by` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `trash` tinyint(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `cost_field` (
  `id` int(100) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `cost_field` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `create_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `procedure_id` int(11) NOT NULL,
  `standard` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `condition` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `deduction_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `fields` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `remarks` text COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `diagnosis` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `delivery` date NOT NULL COMMENT 'Date value',
  `pid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Test name',
  `gender` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `reference_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `group` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Test group',
  `room` varchar(110) COLLATE utf8_unicode_ci NOT NULL,
  `result` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `remarks` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Normal, High, Low etc',
  `amount` decimal(10,2) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `bill` int(11) NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `doctors` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fullName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `designation` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `degree` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `specialised` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `hospital` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mobile` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `fee` decimal(8,2) NOT NULL DEFAULT 0.00,
  `commission` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `address` text COLLATE utf8_unicode_ci NOT NULL,
  `image` text COLLATE utf8_unicode_ci NOT NULL,
  `room_no` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `due_payment` (
  `id` int(45) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `time` varchar(45) NOT NULL,
  `voucher_number` varchar(45) NOT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `prev_paid` decimal(10,2) NOT NULL,
  `prev_due` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `remission` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=latin1; 

CREATE TABLE `emergencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `bill` int(11) NOT NULL COMMENT 'ID of bills table',
  `status` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `employee` (
  `id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `emp_id` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `father_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mother_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `joining_date` date NOT NULL,
  `gender` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `date_of_birth` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `nid_no` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mobile` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `present_address` text COLLATE utf8_unicode_ci NOT NULL,
  `permanent_address` text COLLATE utf8_unicode_ci NOT NULL,
  `designation` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `remarks` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `path` text COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `group_name` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `group_name` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `incentive_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `fields` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `percentage` decimal(10,2) NOT NULL,
  `remarks` text COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `income` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `income_field` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `income_by` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` tinyint(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `income_field` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `income_field` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `code` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `investigation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `group` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `test_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `test_fee` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `room` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `journal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `ref` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT 'expression [ registration:10 or pathology:15 or pid:123456 ]. registration -> ID = 10 and pathology -> ID = 15 and pid = patient ID',
  `details` longtext COLLATE utf8_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL COMMENT 'income or cost or liability or assets',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `marketer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `create_at` date NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `mobile` varchar(24) COLLATE utf8_unicode_ci NOT NULL,
  `commission` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `address` text COLLATE utf8_unicode_ci NOT NULL,
  `img_url` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`) USING HASH
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `medicine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_name` text COLLATE utf8_unicode_ci NOT NULL,
  `product_code` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  `product_cat` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  `subcategory` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  `purchase_price` decimal(10,2) NOT NULL,
  `sale_price` decimal(10,2) NOT NULL,
  `unit` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6449 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `messages_date` varchar(20) NOT NULL,
  `messages_name` varchar(250) NOT NULL,
  `messages_mobile` varchar(50) NOT NULL,
  `messages_text` text NOT NULL,
  `messages_condition` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4; 

CREATE TABLE `meta_info` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8_unicode_ci NOT NULL,
  `meta_status` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `opening_balance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `opening_amount` decimal(10,2) NOT NULL,
  `initial_invest` decimal(10,2) NOT NULL,
  `closing_amount` decimal(10,2) NOT NULL,
  `status` varchar(150) NOT NULL COMMENT '1st : opening balance always on top',
  `trash` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1; 

CREATE TABLE `outstock` (
  `id` int(200) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `voucher_no` varchar(255) NOT NULL,
  `stock_voucher_no` varchar(255) NOT NULL,
  `reagent` varchar(255) NOT NULL,
  `quantity` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8; 

CREATE TABLE `patients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `guardian` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'JSON String. { ''relation'' : ''person name'' }',
  `gender` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `age` int(11) NOT NULL,
  `address` longtext COLLATE utf8_unicode_ci NOT NULL,
  `contact` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `pc` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fullName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mobile` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `commission` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `address` text COLLATE utf8_unicode_ci NOT NULL,
  `image` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `prescription` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` varchar(11) COLLATE utf8_unicode_ci NOT NULL,
  `date` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `symptoms` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `diagnosis` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `patient_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `medicine` text COLLATE utf8_unicode_ci NOT NULL,
  `test` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `privileges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `privilege_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `user_id` int(100) NOT NULL,
  `access` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `procedures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `parameter` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `referral_value` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'with Condition',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=latin1; 

CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `brand` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `category` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `model` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `subcategory` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `purchase_price` decimal(10,2) NOT NULL,
  `sale_price` decimal(10,2) NOT NULL,
  `unit` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `remarks` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `trash` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `purchase` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `voucher_no` varchar(45) NOT NULL,
  `category` varchar(100) NOT NULL,
  `subcategory` varchar(100) NOT NULL,
  `brand` varchar(100) NOT NULL,
  `code` varchar(255) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `purchase_price` decimal(10,2) NOT NULL,
  `quantity` int(10) unsigned NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `total_discount` decimal(10,2) NOT NULL,
  `transport_cost` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `final_due` varchar(255) NOT NULL,
  `status` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8; 

CREATE TABLE `reagent` (
  `id` int(200) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `reagent` varchar(250) NOT NULL,
  `slug` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8; 

CREATE TABLE `reagent_stock` (
  `id` int(200) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `voucher_no` varchar(255) NOT NULL,
  `reagent` varchar(255) NOT NULL,
  `quantity` varchar(255) NOT NULL,
  `expire_date` varchar(255) NOT NULL,
  `status` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4; 

CREATE TABLE `recharge_sms` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `amount` varchar(192) COLLATE utf8_unicode_ci NOT NULL,
  `sms` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `registrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8_unicode_ci NOT NULL COMMENT 'ID of patients. Connect to patients table. ',
  `type` varchar(45) COLLATE utf8_unicode_ci NOT NULL COMMENT 'admission or, consultancy or, emergency or, pathology',
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'pending' COMMENT 'pending or admitted or released or consultancy or emergency',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `remark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `remark` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `remark_id` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `salary` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `salary_amount` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `bonus` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `issue_date` date NOT NULL,
  `payment_year` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `payment_month` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `payment_type` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `bank_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `account_number` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `salary_records` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `eid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `fields` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `amounts` decimal(10,2) NOT NULL,
  `remarks` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `salary_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `basic` decimal(10,2) NOT NULL,
  `incentive` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  `deduction` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  `bonus` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `sale` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `time` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `voucher_number` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `category` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `model` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `product` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `quantity` int(10) unsigned NOT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `remission` decimal(10,2) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mobile` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `sessions` (
  `session_id` varchar(40) NOT NULL DEFAULT '0',
  `ip_address` varchar(45) NOT NULL DEFAULT '0',
  `user_agent` varchar(120) NOT NULL,
  `last_activity` int(10) unsigned NOT NULL DEFAULT 0,
  `user_data` text NOT NULL,
  PRIMARY KEY (`session_id`),
  KEY `last_activity_idx` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8; 

CREATE TABLE `sitemeta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(255) COLLATE utf8_croatian_ci NOT NULL,
  `meta_type` varchar(255) COLLATE utf8_croatian_ci NOT NULL,
  `meta_value` varchar(255) COLLATE utf8_croatian_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_croatian_ci; 

CREATE TABLE `sms_record` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `delivery_date` date NOT NULL,
  `delivery_time` time NOT NULL,
  `mobile` varchar(20) NOT NULL,
  `message` text NOT NULL,
  `total_characters` varchar(4) NOT NULL,
  `total_messages` varchar(2) NOT NULL,
  `delivery_report` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=latin1; 

CREATE TABLE `stock` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit` varchar(100) NOT NULL DEFAULT 'pcs',
  `purchase_price` decimal(10,2) NOT NULL,
  `sell_price` decimal(10,2) NOT NULL,
  `type` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8; 

CREATE TABLE `test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  `test_group` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  `test_name` varchar(252) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `test_histories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `procedure_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `patient_voucher` varchar(191) NOT NULL,
  `standerd` varchar(50) NOT NULL,
  `condition` varchar(15) NOT NULL,
  `report` varchar(50) NOT NULL,
  `remark` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1; 

CREATE TABLE `test_name` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `group_name` text COLLATE utf8_unicode_ci NOT NULL,
  `test_name` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `theme_setting` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `theme_color` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `background_pattern` text COLLATE utf8_unicode_ci NOT NULL,
  `login_background` text COLLATE utf8_unicode_ci NOT NULL,
  `google_map` text COLLATE utf8_unicode_ci NOT NULL,
  `footer` text COLLATE utf8_unicode_ci NOT NULL,
  `header` text COLLATE utf8_unicode_ci NOT NULL,
  `logo` text COLLATE utf8_unicode_ci NOT NULL,
  `menu_icon` text COLLATE utf8_unicode_ci NOT NULL,
  `social_icon` text COLLATE utf8_unicode_ci NOT NULL,
  `language` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE `transaction` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_date` date NOT NULL,
  `bank` varchar(100) NOT NULL,
  `account_number` varchar(100) NOT NULL,
  `transaction_type` varchar(100) NOT NULL,
  `source` varchar(255) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `transaction_by` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8; 

CREATE TABLE `users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `opening` datetime NOT NULL,
  `name` varchar(100) NOT NULL,
  `l_name` varchar(100) NOT NULL,
  `gender` varchar(10) NOT NULL,
  `birthday` varchar(20) NOT NULL,
  `maritial_status` varchar(100) NOT NULL,
  `position` varchar(50) NOT NULL,
  `about` text NOT NULL,
  `website` varchar(100) NOT NULL,
  `facecbook` varchar(100) NOT NULL,
  `twitter` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(128) NOT NULL,
  `privilege` varchar(100) NOT NULL,
  `image` varchar(100) NOT NULL,
  `mobile` varchar(15) NOT NULL,
  `branch` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8; 

CREATE TABLE `vat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `percentage` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `vat_id` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 
 
INSERT INTO `access_info` ( `user_id`, `login_period`, `logout_period`) VALUES 
('28', '2018-07-12 10:53:45', '0000-00-00 00:00:00'), 
('28', '2018-07-16 17:56:38', '0000-00-00 00:00:00'), 
('28', '2018-07-19 12:57:39', '2018-07-19 12:59:13'), 
('28', '2018-07-19 12:59:15', '2018-07-19 13:00:42'), 
('28', '2018-07-19 13:00:54', '0000-00-00 00:00:00'), 
('28', '2018-07-19 14:11:12', '0000-00-00 00:00:00'), 
('28', '2018-07-19 15:20:26', '0000-00-00 00:00:00'), 
('28', '2018-07-19 16:38:19', '0000-00-00 00:00:00'), 
('28', '2018-07-19 17:00:05', '0000-00-00 00:00:00'), 
('28', '2018-07-19 17:05:58', '2018-07-19 17:48:08'), 
('28', '2018-07-19 17:10:18', '0000-00-00 00:00:00'), 
('28', '2018-07-19 17:30:31', '0000-00-00 00:00:00'), 
('28', '2018-07-19 17:34:26', '0000-00-00 00:00:00'), 
('28', '2018-07-19 17:48:49', '0000-00-00 00:00:00'), 
('28', '2018-07-19 17:50:30', '0000-00-00 00:00:00'), 
('28', '2018-07-19 17:59:24', '0000-00-00 00:00:00'), 
('28', '2018-07-19 18:52:34', '0000-00-00 00:00:00'), 
('28', '2018-07-22 10:22:45', '0000-00-00 00:00:00'), 
('28', '2018-07-22 18:37:41', '0000-00-00 00:00:00'), 
('28', '2018-07-23 11:04:26', '2018-07-23 16:03:39'), 
('29', '2018-07-23 16:03:42', '2018-07-23 16:14:27'), 
('29', '2018-07-23 16:14:29', '2018-07-23 16:19:13'), 
('28', '2018-07-23 16:16:44', '0000-00-00 00:00:00'), 
('26', '2018-07-23 16:19:37', '0000-00-00 00:00:00'), 
('29', '2018-08-01 18:21:00', '0000-00-00 00:00:00'), 
('29', '2018-08-08 16:25:19', '2018-08-08 16:25:40'), 
('29', '2018-08-08 16:25:47', '2018-08-08 16:26:22'), 
('29', '2018-08-08 16:26:29', '0000-00-00 00:00:00'), 
('29', '2018-08-09 10:07:10', '0000-00-00 00:00:00'), 
('29', '2018-08-09 10:08:30', '2018-08-09 10:39:10'), 
('29', '2018-08-11 10:43:22', '2018-08-11 13:58:53'), 
('29', '2018-08-11 13:58:58', '0000-00-00 00:00:00'), 
('29', '2018-08-13 10:26:45', '2018-08-13 10:35:29'), 
('29', '2018-08-13 10:28:49', '0000-00-00 00:00:00'), 
('29', '2018-08-13 10:36:06', '2018-08-13 15:53:06'), 
('29', '2018-08-13 13:32:18', '0000-00-00 00:00:00'), 
('29', '2018-08-14 10:39:15', '2018-08-14 10:39:42'), 
('29', '2018-08-14 10:39:51', '0000-00-00 00:00:00'), 
('29', '2018-09-04 19:20:58', '0000-00-00 00:00:00'), 
('29', '2018-09-04 19:26:33', '0000-00-00 00:00:00'), 
('29', '2018-09-05 10:25:29', '0000-00-00 00:00:00'), 
('29', '2018-09-07 17:53:21', '0000-00-00 00:00:00'), 
('29', '2018-11-19 11:51:12', '0000-00-00 00:00:00'), 
('29', '2018-11-19 16:53:09', '0000-00-00 00:00:00'), 
('29', '2018-12-02 18:38:55', '2018-12-02 18:39:53'), 
('29', '2018-12-02 18:40:02', '2018-12-02 18:42:57'), 
('29', '2018-12-04 11:16:31', '0000-00-00 00:00:00'), 
('29', '2018-12-04 14:03:50', '0000-00-00 00:00:00'), 
('29', '2018-12-06 15:13:36', '2018-12-06 15:34:02'), 
('29', '2018-12-06 18:21:13', '0000-00-00 00:00:00'), 
('29', '2018-12-06 19:49:04', '2018-12-06 19:57:25'), 
('29', '2018-12-10 10:42:03', '2018-12-10 10:48:03'), 
('29', '2018-12-14 11:14:21', '2018-12-14 11:20:59'), 
('29', '2018-12-17 16:59:04', '2018-12-17 17:22:24'), 
('29', '2018-12-18 13:34:21', '0000-00-00 00:00:00'), 
('29', '2018-12-18 13:38:08', '0000-00-00 00:00:00'), 
('29', '2018-12-18 14:19:39', '0000-00-00 00:00:00'), 
('29', '2018-12-18 14:24:10', '0000-00-00 00:00:00'), 
('29', '2018-12-18 14:25:22', '0000-00-00 00:00:00'), 
('29', '2018-12-18 14:37:38', '0000-00-00 00:00:00'), 
('29', '2018-12-18 16:37:24', '0000-00-00 00:00:00'), 
('29', '2018-12-18 16:42:25', '0000-00-00 00:00:00'), 
('29', '2018-12-18 17:27:28', '2018-12-18 17:34:24'), 
('29', '2018-12-19 09:13:50', '0000-00-00 00:00:00'), 
('29', '2018-12-19 09:30:03', '0000-00-00 00:00:00'), 
('29', '2018-12-19 09:43:49', '0000-00-00 00:00:00'), 
('29', '2018-12-19 09:45:24', '0000-00-00 00:00:00'), 
('29', '2018-12-19 11:02:56', '2018-12-19 11:51:34'), 
('29', '2018-12-19 11:31:57', '0000-00-00 00:00:00'), 
('29', '2018-12-19 17:25:50', '2018-12-19 17:26:24'), 
('26', '2018-12-19 17:26:39', '2018-12-19 17:26:55'), 
('26', '2018-12-19 17:27:09', '2018-12-19 17:28:21'), 
('29', '2018-12-19 17:28:30', '2018-12-19 17:31:23'), 
('26', '2018-12-19 17:31:37', '0000-00-00 00:00:00'), 
('30', '2018-12-19 17:39:33', '0000-00-00 00:00:00'), 
('29', '2018-12-19 17:41:53', '0000-00-00 00:00:00'), 
('29', '2018-12-23 15:39:23', '0000-00-00 00:00:00'), 
('29', '2018-12-23 15:59:45', '2018-12-23 16:04:07'), 
('29', '2018-12-24 12:50:58', '2018-12-24 12:57:27'), 
('30', '2018-12-25 12:19:33', '2018-12-25 12:20:33'), 
('30', '2018-12-25 12:20:49', '2018-12-25 12:21:11'), 
('28', '2018-12-25 12:21:36', '2018-12-25 12:21:57'), 
('28', '2018-12-25 12:22:25', '2018-12-25 12:23:21'), 
('31', '2018-12-25 12:23:30', '2018-12-25 12:32:42'), 
('28', '2018-12-25 14:33:05', '2018-12-25 14:34:39'), 
('32', '2018-12-25 14:34:45', '0000-00-00 00:00:00'), 
('32', '2018-12-26 10:53:27', '2018-12-26 11:06:16'), 
('33', '2018-12-26 11:06:23', '2018-12-26 11:06:48'), 
('32', '2018-12-26 11:07:07', '2018-12-26 11:08:09'), 
('34', '2018-12-26 11:08:14', '0000-00-00 00:00:00'), 
('34', '2018-12-26 11:09:41', '0000-00-00 00:00:00'), 
('34', '2018-12-26 12:21:00', '2018-12-26 12:27:09'), 
('34', '2018-12-27 13:22:52', '2018-12-27 13:35:44'), 
('34', '2018-12-27 13:28:53', '0000-00-00 00:00:00'), 
('36', '2018-12-27 14:46:55', '0000-00-00 00:00:00'), 
('36', '2018-12-27 19:13:15', '2018-12-27 19:14:36'), 
('37', '2018-12-27 19:14:41', '0000-00-00 00:00:00'), 
('37', '2018-12-27 19:15:37', '2018-12-27 19:20:45'), 
('37', '2018-12-29 12:46:26', '2018-12-29 12:46:42'), 
('37', '2018-12-29 12:50:57', '0000-00-00 00:00:00'), 
('37', '2018-12-29 13:09:26', '2018-12-29 13:15:20'), 
('37', '2019-01-09 13:44:31', '2019-01-09 15:01:14'), 
('37', '2019-01-16 16:01:41', '0000-00-00 00:00:00'), 
('37', '2019-01-16 17:04:35', '0000-00-00 00:00:00'), 
('37', '2019-01-16 19:24:01', '2019-01-16 19:25:43'), 
('37', '2019-01-21 09:30:37', '0000-00-00 00:00:00'), 
('37', '2019-01-21 17:42:50', '0000-00-00 00:00:00'), 
('37', '2019-01-22 10:23:26', '0000-00-00 00:00:00'), 
('37', '2019-01-22 12:09:15', '0000-00-00 00:00:00'), 
('37', '2019-01-22 17:17:17', '2019-01-22 17:48:35'), 
('37', '2019-01-23 09:31:38', '0000-00-00 00:00:00'), 
('37', '2019-01-28 15:09:06', '0000-00-00 00:00:00'), 
('37', '2019-02-17 10:32:51', '2019-02-17 10:39:44'), 
('37', '2019-02-17 17:24:21', '2019-02-17 17:56:14'), 
('37', '2019-02-18 09:23:40', '0000-00-00 00:00:00'), 
('37', '2019-02-18 09:26:20', '0000-00-00 00:00:00'), 
('37', '2019-02-21 11:30:29', '0000-00-00 00:00:00'), 
('37', '2019-03-13 14:30:02', '0000-00-00 00:00:00'), 
('37', '2019-03-13 14:34:21', '0000-00-00 00:00:00'), 
('37', '2019-03-20 10:15:21', '2019-03-20 10:29:25'), 
('37', '2019-05-05 07:36:31', '2019-05-05 07:49:19'), 
('37', '2019-05-05 10:46:47', '2019-05-05 11:02:15'), 
('37', '2019-05-05 11:03:21', '0000-00-00 00:00:00'), 
('37', '2019-06-23 19:09:48', '0000-00-00 00:00:00'), 
('37', '2019-06-23 19:15:36', '0000-00-00 00:00:00'), 
('37', '2019-07-21 18:47:46', '0000-00-00 00:00:00'), 
('37', '2019-08-05 20:10:17', '2019-08-05 20:10:35'), 
('37', '2019-08-06 11:28:56', '0000-00-00 00:00:00'), 
('37', '2019-08-07 17:53:33', '0000-00-00 00:00:00'), 
('37', '2019-08-08 17:49:28', '0000-00-00 00:00:00'), 
('37', '2019-08-14 19:31:59', '0000-00-00 00:00:00'), 
('37', '2019-08-16 18:59:17', '0000-00-00 00:00:00'), 
('37', '2019-08-31 11:36:33', '0000-00-00 00:00:00'), 
('37', '2019-08-31 11:58:05', '2019-08-31 12:52:33'), 
('38', '2019-08-31 12:52:55', '2019-08-31 12:53:42'), 
('37', '2019-08-31 12:54:00', '2019-08-31 12:59:16'), 
('38', '2019-08-31 12:59:33', '2019-08-31 13:00:28'), 
('37', '2019-08-31 13:00:49', '2019-08-31 13:05:35'), 
('38', '2019-08-31 13:13:31', '2019-08-31 13:16:22'), 
('38', '2019-08-31 14:00:02', '2019-08-31 14:05:29'), 
('39', '2019-08-31 17:49:25', '0000-00-00 00:00:00'), 
('39', '2019-08-31 17:50:29', '2019-08-31 17:57:51'), 
('40', '2019-08-31 17:58:10', '2019-08-31 18:17:55'), 
('38', '2019-08-31 18:19:08', '2019-08-31 18:19:52'), 
('40', '2019-08-31 18:20:05', '2019-08-31 18:25:10'), 
('38', '2019-08-31 18:25:25', '2019-08-31 18:26:07'), 
('40', '2019-08-31 18:26:28', '0000-00-00 00:00:00'), 
('40', '2019-09-03 14:22:00', '0000-00-00 00:00:00'), 
('38', '2019-09-14 17:30:11', '2019-09-14 17:34:02'), 
('41', '2019-09-16 11:27:55', '0000-00-00 00:00:00'), 
('41', '2019-09-16 11:28:50', '2019-09-16 11:40:47'), 
('42', '2019-09-16 11:41:03', '2019-09-16 11:47:41'), 
('38', '2019-09-16 11:47:56', '2019-09-16 11:59:20'), 
('38', '2019-09-16 11:59:37', '2019-09-16 12:30:54'), 
('42', '2019-09-16 12:31:07', '2019-09-16 12:32:19'), 
('38', '2019-09-16 12:33:23', '2019-09-16 13:15:10'), 
('42', '2019-09-16 13:16:18', '0000-00-00 00:00:00'), 
('43', '2020-06-20 15:04:00', '2020-06-20 15:05:00'), 
('43', '2020-06-20 15:08:50', '0000-00-00 00:00:00'), 
('43', '2020-06-20 15:11:01', '0000-00-00 00:00:00'), 
('43', '2020-06-20 15:11:56', '0000-00-00 00:00:00'), 
('43', '2020-06-20 15:32:57', '0000-00-00 00:00:00'), 
('43', '2020-06-20 16:15:51', '0000-00-00 00:00:00'), 
('43', '2020-06-20 17:54:10', '0000-00-00 00:00:00'), 
('43', '2020-06-20 17:55:05', '2020-06-20 18:14:08'), 
('43', '2020-06-20 18:42:43', '0000-00-00 00:00:00'), 
('43', '2020-06-20 18:43:24', '2020-06-20 18:45:54'), 
('43', '2020-06-21 00:14:33', '0000-00-00 00:00:00'), 
('43', '2020-06-21 10:26:57', '0000-00-00 00:00:00'), 
('43', '2020-06-21 10:45:47', '0000-00-00 00:00:00'), 
('43', '2020-06-21 11:25:16', '0000-00-00 00:00:00'), 
('43', '2020-06-21 11:26:57', '0000-00-00 00:00:00'), 
('43', '2020-06-21 14:39:37', '0000-00-00 00:00:00'), 
('43', '2020-06-21 14:56:00', '2020-06-21 16:33:43'), 
('43', '2020-06-21 17:41:48', '0000-00-00 00:00:00'), 
('43', '2020-06-21 18:11:00', '0000-00-00 00:00:00'), 
('43', '2020-06-22 09:11:07', '0000-00-00 00:00:00'), 
('43', '2020-06-22 11:18:50', '2020-06-22 11:25:33'), 
('43', '2020-06-22 11:26:28', '2020-06-22 11:37:17'), 
('43', '2020-06-22 12:57:32', '0000-00-00 00:00:00'), 
('43', '2020-06-22 13:00:31', '0000-00-00 00:00:00'), 
('43', '2020-06-22 14:05:34', '0000-00-00 00:00:00'), 
('43', '2020-06-22 14:18:05', '0000-00-00 00:00:00'), 
('44', '2020-06-22 20:47:09', '2020-06-22 20:47:21'), 
('44', '2020-06-22 20:48:13', '2020-06-22 20:48:45'), 
('45', '2020-06-22 21:33:42', '2020-06-22 21:34:25'), 
('45', '2020-06-22 21:34:38', '2020-06-22 21:39:34'), 
('45', '2020-06-23 00:22:45', '0000-00-00 00:00:00'), 
('45', '2020-06-23 00:54:15', '0000-00-00 00:00:00'), 
('45', '2020-06-23 02:06:23', '0000-00-00 00:00:00'), 
('45', '2020-06-23 09:23:21', '0000-00-00 00:00:00'), 
('45', '2020-06-23 10:06:51', '0000-00-00 00:00:00'), 
('45', '2020-06-23 10:09:18', '0000-00-00 00:00:00'), 
('45', '2020-06-23 11:10:36', '0000-00-00 00:00:00'), 
('45', '2020-06-23 11:12:14', '0000-00-00 00:00:00'), 
('45', '2020-06-23 11:39:56', '0000-00-00 00:00:00');  



 



 



INSERT INTO `admissions` ( `id`, `date`, `pid`, `guardian`, `seat`, `bill`, `status`) VALUES 
('1', '2018-07-10', '47857', 'Ipsam vel cumque sit dicta', '', '0', 'admitted'), 
('2', '2018-07-10', '47857', 'Ipsam vel cumque sit dicta', '', '0', 'admitted'), 
('3', '2018-07-10', '00001', 'Ad consectetur harum ', '', '0', 'admitted'), 
('4', '2018-07-12', '00002', '', '', '0', 'admitted');  



 



INSERT INTO `bank_account` ( `id`, `datetime`, `bank_name`, `holder_name`, `account_number`, `pre_balance`) VALUES 
('1', '2018-05-05', 'Sonali_Bank_Limited', 'City Hospital', '458741254475511', '150000'), 
('2', '2018-05-07', 'NCC_Bank_Limited', 'emon', '154254478544144', '931532');  



INSERT INTO `bank_name` ( `id`, `date`, `bank_name`) VALUES 
('1', '2017-03-12', 'Sonali_Bank_Limited'), 
('2', '2017-03-12', 'Janata_Bank_Limited'), 
('3', '2017-03-12', 'Agrani_Bank_Limited'), 
('4', '2017-03-12', 'Rupali_Bank_Limited'), 
('5', '2017-03-12', 'AB_Bank_Limited'), 
('6', '2017-03-12', 'Jamuna_Bank_Limited'), 
('7', '2017-03-12', 'National_Bank_Limited'), 
('8', '2017-03-12', 'NCC_Bank_Limited'), 
('9', '2017-03-12', 'Prime_Bank_Limited'), 
('10', '2017-03-12', 'Standard_Bank_Limited'), 
('11', '2017-03-12', 'The_City_Bank_Limited'), 
('12', '2017-03-12', 'Trust_Bank_Limited'), 
('13', '2017-03-12', 'Islami_Bank_Bangladesh_Limited'), 
('14', '2017-03-12', 'The_City_Bank_Limited'), 
('15', '2017-03-12', 'Dutch_Bangla_Bank');  



 



INSERT INTO `bonus_structure` ( `id`, `eid`, `fields`, `percentage`, `remarks`, `status`) VALUES 
('1', '0002', 'Festival ', '1.00', 'Statisfactory', '');  



INSERT INTO `brand` ( `id`, `date`, `name`, `trash`) VALUES 
('1', '2018-07-22', 'Square', '0'), 
('3', '2018-07-22', 'SKF', '0'), 
('4', '2018-07-22', 'ACME', '0');  



INSERT INTO `category` ( `id`, `date`, `category`, `slug`, `brand`, `type`, `trash`) VALUES 
('2', '2018-07-22', 'Dextrose Anhydrous BP', 'dextrose_anhydrous_bp', '', '', '0'), 
('3', '2018-07-22', 'Anhydrous', 'anhydrous', '', '', '0');  



 



INSERT INTO `commission_payment` ( `id`, `payment_date`, `type`, `person_id`, `balance`, `paid`, `due`) VALUES 
('1', '2018-08-08', '0', '0', '0.00', '0.00', '0.00'), 
('2', '2020-06-16', '0', '0', '0.00', '15000.00', '0.00'), 
('3', '2020-06-16', '0', '0', '0.00', '14000.00', '0.00'), 
('4', '2020-06-16', '0', '0', '0.00', '7.00', '0.00'), 
('5', '2020-06-16', '0', '0', '0.00', '0.00', '0.00');  



 



INSERT INTO `consultancies` ( `id`, `date`, `pid`, `doctor`, `room`, `notes`, `bill`, `status`) VALUES 
('20', '2020-06-23', '0030', '13', '00', '', '37', 'pending');  



INSERT INTO `cost` ( `id`, `date`, `cost_field`, `description`, `amount`, `spend_by`, `trash`) VALUES 
('5', '2019-01-28', '0007', 'test', '500', 'test', '0'), 
('6', '2019-05-05', '0010', 'hjhjhjh', '50', 'trtt', '0'), 
('7', '2019-05-05', '0009', 'hghgh', '1000', 'trtt', '0'), 
('8', '0000-00-00', '0', '0', '0', '0', '0'), 
('9', '0000-00-00', '0', '0', '0', '0', '0'), 
('10', '0000-00-00', '0', '0', '0', '0', '0'), 
('11', '0000-00-00', '0', '0', '0', '0', '0'), 
('12', '2020-06-22', '0010', '', '500', '', '0');  



INSERT INTO `cost_field` ( `id`, `code`, `cost_field`) VALUES 
('1', '0001', 'Maintenance'), 
('2', '0002', 'Employee Salary'), 
('4', '0004', 'Electricity Bill'), 
('5', '0005', 'Internet Bill'), 
('6', '0006', 'Mobile Bill'), 
('7', '0007', 'House Rent'), 
('8', '0008', 'Press and Print Bill 74'), 
('9', '0009', 'Advertisement Bill'), 
('10', '0010', 'Food Bill'), 
('13', '0011', 'Employee salary');  



 



INSERT INTO `deduction_structure` ( `id`, `eid`, `fields`, `amount`, `remarks`, `status`) VALUES 
('1', '0002', 'Advanced Pay', '1000.00', '', ''), 
('2', '0002', 'Professional Tax ', '0.00', '', ''), 
('3', '0002', 'Loan', '0.00', '', ''), 
('4', '0002', 'Provisional Fund', '0.00', '', '');  



INSERT INTO `diagnosis` ( `id`, `date`, `delivery`, `pid`, `name`, `gender`, `reference_name`, `group`, `room`, `result`, `remarks`, `amount`, `cost`, `bill`, `status`) VALUES 
('4', '2018-08-11', '2018-08-11', '00002', 'X-RAY', '', '', 'Group-A', '102', '', '', '250.00', '0.00', '3', 'pending'), 
('5', '2018-08-11', '2018-08-11', '00002', 'Test-1', '', '', 'as', '8', '', '', '110.00', '0.00', '3', 'pending'), 
('6', '2018-08-13', '2018-08-13', '00003', 'X-RAY', '', '3', 'Group-A', '102', '', '', '250.00', '0.00', '4', 'pending'), 
('7', '2018-08-13', '2018-08-13', '00003', 'Sugar', '', '3', 'Bio-chemical__Exam', '102', '', '', '5000.00', '0.00', '4', 'pending'), 
('8', '2018-08-13', '2018-08-13', '00004', 'HLB 27', '', '2', 'Bio-chemical__Exam', '500', '', '', '500.00', '0.00', '5', 'pending'), 
('9', '2018-09-04', '2018-09-04', '00005', 'ABCD', '', 'Roth Mosley', 'X-RAY', '105', '', '', '600.00', '0.00', '6', 'pending'), 
('10', '2018-09-04', '2018-09-04', '00005', 'Test-1', '', 'Roth Mosley', 'as', '8', '', '', '110.00', '0.00', '6', 'pending'), 
('11', '2018-09-04', '2018-09-04', '00005', 'Tuberculin_Test', '', 'Roth Mosley', 'OTHERS_PATHOLOGY', '205', '', '', '500.00', '0.00', '6', 'pending'), 
('12', '2018-09-04', '2018-09-04', '00005', 'Sugar', '', 'Roth Mosley', 'Bio-chemical__Exam', '102', '', '', '5000.00', '0.00', '6', 'pending'), 
('13', '2018-12-18', '2018-12-18', '00006', 'TC/DC/ESR/HB%MP C/E', '', 'Roth Mosley', 'HAEMATOLOGY', '101', '', '', '500.00', '0.00', '7', 'pending'), 
('14', '2018-12-18', '2018-12-18', '00006', 'Platelet Count', '', 'Roth Mosley', 'HAEMATOLOGY', '101', '', '', '700.00', '0.00', '7', 'pending'), 
('15', '2018-12-18', '2018-12-18', '00006', 'BT/CT', '', 'Roth Mosley', 'HAEMATOLOGY', '101', '', '', '900.00', '0.00', '7', 'pending'), 
('16', '2018-12-18', '2018-12-18', '00006', 'Urea Level/ Bun', '', 'Roth Mosley', 'BIOCHEMISTRY', '101', '', '', '0.00', '0.00', '7', 'pending'), 
('17', '2018-12-18', '2018-12-18', '00006', 'BT/CT', '', 'Roth Mosley', 'HAEMATOLOGY', '101', '', '', '900.00', '0.00', '7', 'pending'), 
('18', '2018-12-18', '2018-12-18', '00006', '', '', 'Roth Mosley', '', '', '', '', '0.00', '0.00', '7', 'pending'), 
('19', '2019-06-23', '2019-06-23', '00007', 'G.T.T/P.P.B.S', '', 'Dr. Istiaq Ahmed', 'BIOCHEMISTRY', '101', '', '', '0.00', '0.00', '11', 'pending'), 
('20', '2019-06-23', '2019-06-23', '00007', 'S.Protin', '', 'Dr. Istiaq Ahmed', 'BIOCHEMISTRY', '101', '', '', '0.00', '0.00', '11', 'pending'), 
('21', '2019-06-23', '2019-06-23', '00007', 'Widal Test', '', 'Dr. Istiaq Ahmed', 'SEROLOGY', '101', '', '', '0.00', '0.00', '11', 'pending'), 
('22', '2020-06-16', '2020-06-16', '00008', 'Sputem For A.F.B', '', 'Dr.developer', 'OTHERS', '101', '', '', '0.00', '0.00', '13', 'pending'), 
('23', '2020-06-20', '2020-06-20', '00009', 'HBS', '', 'Dr. Istiaq Ahmed', 'DIGITAL ULTRASONOGRAPHY', '101', '', '', '0.00', '0.00', '14', 'pending'), 
('24', '2020-06-22', '2020-06-22', '00010', 'BT/CT', '', 'Dr.Jannatul Ferdousi Bithi', 'HAEMATOLOGY', '101', '', '', '900.00', '0.00', '16', 'pending'), 
('25', '2020-06-22', '2020-06-22', '00010', 'S.G.P.T.(ALT)', '', 'Dr.Jannatul Ferdousi Bithi', 'BIOCHEMISTRY', '101', '', '', '0.00', '0.00', '16', 'pending'), 
('26', '2020-06-22', '2020-06-22', '00010', 'S. Bilirubin', '', 'Dr.Jannatul Ferdousi Bithi', 'BIOCHEMISTRY', '101', '', '', '0.00', '0.00', '16', 'pending'), 
('27', '2020-06-22', '2020-06-22', '00011', 'BT/CT', '', 'Dr. Istiaq Ahmed', 'HAEMATOLOGY', '101', '', '', '900.00', '0.00', '20', 'pending'), 
('28', '2020-06-22', '2020-06-22', '00012', 'BT/CT', '', 'Dr. Istiaq Ahmed', 'HAEMATOLOGY', '101', '', '', '900.00', '0.00', '21', 'pending'), 
('29', '2020-06-22', '2020-06-22', '00013', 'BT/CT', '', 'Dr. Istiaq Ahmed', 'HAEMATOLOGY', '101', '', '', '900.00', '0.00', '22', 'pending'), 
('32', '2020-06-22', '2020-06-22', '00016', 'BT/CT', '', 'Dr. Humayan', 'HAEMATOLOGY', '101', '', '', '900.00', '0.00', '25', 'pending'), 
('33', '2020-06-22', '2020-06-22', '00016', 'CBC', '', 'Dr. Humayan', 'HAEMATOLOGY', '101', '', '', '400.00', '0.00', '25', 'pending'), 
('34', '2020-06-23', '2020-06-23', '00017', 'S. Bilirubin', '', 'Utpal Kumar Pal', 'BIOCHEMISTRY', '101', '', '', '0.00', '0.00', '33', 'pending');  



INSERT INTO `doctors` ( `id`, `fullName`, `designation`, `degree`, `specialised`, `hospital`, `mobile`, `phone`, `email`, `fee`, `commission`, `address`, `image`, `room_no`) VALUES 
('13', 'Rifat', 'Professor', 'MBBS.BCS(health) MPhil, medical science', 'Medicine diabetology', 'Mymensingh medical college', '01716457373', '', '', '600.00', '00', 'Muktagacha', 'public/upload/doctors/doctor-1592855888.jpg', '00'), 
('17', 'MD.Abul', 'Hussain', 'L.M.F.', 'General', 'Village doctor', '8801724452861', '', '', '0.00', '00', 'Muktagacha', '', '00'), 
('19', 'Hasimul Ahasan Suhag', 'Medical Officer', 'MBBS.BCS. (health)FCPS( final)MD(final)', 'Medicine. Cardiology', 'Sheikh mujib medical university (PG hospital)', '01949800600', '', '', '400.00', '00', 'Muktagacha', 'public/upload/doctors/doctor-1592854852.jpg', '101'), 
('20', 'Moushumi Haq Moon', 'Medical Officer', 'MBBS.BCS(health) FCPS( final)', 'Gynaecology and ops', 'Upazila health complex muktagacha', '8801768860774', '', '', '300.00', '00', 'Muktagacha', '', '202'), 
('21', 'Utpal Kumar Pal', 'Professor', 'MBBS.BCS(health) MPhil, medical science', 'Medicine diabetology', 'Mymensingh medical college', '01716457373', '', '', '600.00', '00', 'Muktagacha', 'public/upload/doctors/doctor-1592855888.jpg', '00');  



INSERT INTO `due_payment` ( `id`, `date`, `time`, `voucher_number`, `total_amount`, `prev_paid`, `prev_due`, `paid`, `due`, `remission`) VALUES 
('1', '2018-02-04', '05:26:43 PM', '2147483647', '72.00', '0.00', '0.00', '40.00', '32.00', '0.00'), 
('2', '2018-02-04', '05:26:43 PM', '2147483647', '72.00', '0.00', '0.00', '40.00', '32.00', '0.00'), 
('3', '2018-02-04', '05:32:44 PM', '2147483647', '82.00', '0.00', '0.00', '43.00', '39.00', '0.00'), 
('4', '2018-02-04', '05:32:44 PM', '2147483647', '82.00', '0.00', '0.00', '43.00', '39.00', '0.00'), 
('5', '2018-02-04', '05:34:13 PM', '2147483647', '142.00', '0.00', '0.00', '100.00', '42.00', '0.00'), 
('6', '2018-02-04', '05:39:57 PM', '2147483647', '122.00', '0.00', '0.00', '110.00', '12.00', '0.00'), 
('7', '2018-02-04', '05:42:26 PM', '2147483647', '140.00', '0.00', '0.00', '40.00', '100.00', '0.00'), 
('8', '2018-02-04', '05:45:19 PM', '2147483647', '564.00', '0.00', '0.00', '500.00', '64.00', '0.00'), 
('9', '2018-02-04', '05:46:18 PM', '2147483647', '182.00', '0.00', '0.00', '45.00', '137.00', '0.00'), 
('10', '2018-02-04', '05:51:07 PM', '18020413773', '72.00', '0.00', '0.00', '12.00', '60.00', '0.00'), 
('11', '2018-02-04', '06:35:25 PM', '18020413773', '72.00', '12.00', '60.00', '0.00', '30.00', '0.00'), 
('12', '2018-02-04', '06:36:05 PM', '18020413773', '72.00', '0.00', '30.00', '0.00', '30.00', '0.00'), 
('13', '2018-02-04', '06:37:41 PM', '18020413775', '203.00', '0.00', '0.00', '10.00', '193.00', '0.00'), 
('14', '2018-02-04', '06:38:14 PM', '18020413775', '203.00', '10.00', '193.00', '13.00', '180.00', '0.00'), 
('15', '2018-02-04', '06:47:15 PM', '18020413775', '203.00', '13.00', '180.00', '10.00', '170.00', '0.00'), 
('16', '2018-02-04', '06:48:38 PM', '18020413775', '203.00', '10.00', '170.00', '12.00', '150.00', '8.00'), 
('17', '2018-02-04', '07:03:30 PM', '18020413775', '203.00', '12.00', '150.00', '10.00', '130.00', '18.00'), 
('18', '2018-07-22', '05:05:46 PM', '1807223780', '4300.00', '0.00', '0.00', '0.00', '4300.00', '0.00'), 
('19', '2018-07-22', '05:07:09 PM', '1807223780', '4300.00', '0.00', '0.00', '0.00', '4300.00', '0.00'), 
('20', '2018-07-22', '05:08:13 PM', '1807223780', '4300.00', '0.00', '0.00', '0.00', '4300.00', '0.00'), 
('21', '2018-07-22', '05:41:18 PM', '1807220004', '150.00', '0.00', '0.00', '20.00', '130.00', '0.00'), 
('22', '2018-07-22', '05:42:43 PM', '1807220005', '10150.00', '0.00', '0.00', '0.00', '10150.00', '0.00'), 
('23', '2018-07-22', '05:44:23 PM', '1807220005', '10150.00', '0.00', '0.00', '0.00', '10150.00', '0.00'), 
('24', '2018-07-22', '06:09:38 PM', '1807220009', '150.00', '0.00', '0.00', '0.00', '150.00', '0.00'), 
('25', '2018-07-22', '06:16:01 PM', '1807220004', '150.00', '20.00', '130.00', '100.00', '30.00', '0.00'), 
('26', '2018-07-22', '06:17:42 PM', '1807220004', '150.00', '100.00', '30.00', '0.00', '30.00', '0.00'), 
('27', '2018-07-22', '06:17:51 PM', '1807220004', '150.00', '0.00', '30.00', '0.00', '0.00', '30.00'), 
('28', '2018-07-22', '06:22:43 PM', '1807220005', '10150.00', '0.00', '10150.00', '0.00', '10150.00', '0.00'), 
('29', '2018-07-22', '06:23:05 PM', '1807220005', '10150.00', '0.00', '10150.00', '0.00', '10150.00', '0.00'), 
('30', '2018-07-22', '06:25:02 PM', '1807220005', '10150.00', '0.00', '10150.00', '0.00', '10150.00', '0.00'), 
('31', '2018-07-23', '02:20:54 PM', '1807230010', '2000.00', '0.00', '0.00', '0.00', '2000.00', '0.00');  



 



INSERT INTO `employee` ( `id`, `date`, `emp_id`, `name`, `father_name`, `mother_name`, `email`, `joining_date`, `gender`, `date_of_birth`, `nid_no`, `mobile`, `present_address`, `permanent_address`, `designation`, `remarks`, `path`, `status`) VALUES 
('1', '2018-04-19', '0001', 'test', 'test father', 'test mother', 'test@gmail.com', '2018-04-19', 'Male', '', '1254785412354', '01254785475', 'test', 'test', 'Director', 'Nothing', 'public/employee/employee_61643_0001.jpg', 'active'), 
('2', '2018-07-12', '0002', 'Ranjan Chawdhury', 'Father\'s Name', 'test mother', 'teast@gmail.com', '2018-04-18', 'Male', '2018-04-01', '12547854123546', '01900552620', 'asdf', 'asdf', 'Accountant', 'asdf ', 'public/employee/employee_4321_0002.jpeg', 'active');  



INSERT INTO `group_name` ( `id`, `group_name`) VALUES 
('1', 'HAEMATOLOGY'), 
('2', 'BIOCHEMISTRY'), 
('3', 'SEROLOGY'), 
('4', 'HORMON'), 
('5', 'URINE'), 
('6', 'STOOL'), 
('7', 'DIGITAL X-RAY'), 
('8', 'DIGITAL ULTRASONOGRAPHY'), 
('9', 'OTHERS');  



INSERT INTO `incentive_structure` ( `id`, `eid`, `fields`, `percentage`, `remarks`, `status`) VALUES 
('1', '0002', 'HRA', '1.00', '', ''), 
('2', '0002', 'DA', '1.00', '', ''), 
('3', '0002', 'TA', '0.00', '', ''), 
('4', '0002', 'CCA', '0.00', '', ''), 
('5', '0002', 'Medical', '1.00', '', '');  



INSERT INTO `income` ( `id`, `date`, `income_field`, `description`, `amount`, `income_by`, `trash`) VALUES 
('3', '2019-01-28', '0004', 'Bye', '0.00', 'test', '0'), 
('4', '2020-06-16', '0003', 'test', '560.00', 'developer', '0'), 
('5', '2020-06-22', '0003', '', '100.00', '', '0');  



INSERT INTO `income_field` ( `id`, `code`, `income_field`) VALUES 
('3', '0003', 'Others'), 
('4', '0004', 'Rent');  



INSERT INTO `investigation` ( `id`, `date`, `group`, `test_name`, `test_fee`, `cost`, `room`) VALUES 
('1', '2018-12-06', 'HAEMATOLOGY', 'CBC', '400', '0.00', '101'), 
('2', '2018-12-06', 'HAEMATOLOGY', 'Platelet Count', '700', '0.00', '101'), 
('3', '2018-12-06', 'HAEMATOLOGY', 'BT/CT', '900', '0.00', '101'), 
('4', '2018-12-06', 'HAEMATOLOGY', 'PBF', '500', '300.00', '101'), 
('5', '2018-12-06', 'HAEMATOLOGY', 'Reticulacytes Count', '700', '300.00', '101'), 
('6', '2018-12-06', 'BIOCHEMISTRY', 'Fasting/Randam', '0', '0.00', '101'), 
('7', '2018-12-06', 'BIOCHEMISTRY', '2Hour After 75 Gram, Glucose', '0', '0.00', '101'), 
('8', '2018-12-06', 'BIOCHEMISTRY', 'G.T.T/P.P.B.S', '0', '0.00', '101'), 
('9', '2018-12-06', 'BIOCHEMISTRY', 'S. Bilirubin', '0', '0.00', '101'), 
('10', '2018-12-06', 'BIOCHEMISTRY', 'S.G.P.T.(ALT)', '0', '0.00', '101'), 
('11', '2018-12-06', 'BIOCHEMISTRY', 'S.G.O.T.(AST)', '0', '0.00', '101'), 
('12', '2018-12-06', 'BIOCHEMISTRY', 'AIK Phos', '0', '0.00', '101'), 
('13', '2018-12-06', 'BIOCHEMISTRY', 'S.Protin', '0', '0.00', '101'), 
('14', '2018-12-06', 'BIOCHEMISTRY', 'S.Albomin', '0', '0.00', '101'), 
('15', '2018-12-06', 'BIOCHEMISTRY', 'S.Cholesterol', '0', '0.00', '101'), 
('16', '2018-12-06', 'BIOCHEMISTRY', 'S Uric Acid', '0', '0.00', '101'), 
('17', '2018-12-06', 'BIOCHEMISTRY', 'Urea Level/ Bun', '0', '0.00', '101'), 
('18', '2018-12-06', 'BIOCHEMISTRY', 'S. Creatinine', '0', '0.00', '101'), 
('19', '2018-12-06', 'BIOCHEMISTRY', 'Lipid Profile', '0', '0.00', '101'), 
('20', '2018-12-06', 'BIOCHEMISTRY', 'Prothombin Time', '0', '0.00', '101'), 
('21', '2018-12-06', 'SEROLOGY', 'Blood For Grouping', '0', '0.00', '101'), 
('22', '2018-12-06', 'SEROLOGY', 'A.S.O Titre', '0', '0.00', '101'), 
('23', '2018-12-06', 'SEROLOGY', 'R/A Test', '0', '0.00', '101'), 
('24', '2018-12-06', 'SEROLOGY', 'TPHA', '0', '0.00', '101'), 
('25', '2018-12-06', 'SEROLOGY', 'V.D.R.L', '0', '0.00', '101'), 
('26', '2018-12-06', 'SEROLOGY', 'Widal Test', '0', '0.00', '101'), 
('27', '2018-12-06', 'SEROLOGY', 'Hbs Ag', '0', '0.00', '101'), 
('28', '2018-12-06', 'SEROLOGY', 'Hbe Ag', '0', '0.00', '101'), 
('29', '2018-12-06', 'SEROLOGY', 'Anti HCV', '0', '0.00', '101'), 
('30', '2018-12-06', 'SEROLOGY', 'HIV', '0', '0.00', '101'), 
('31', '2018-12-06', 'SEROLOGY', 'CRP', '0', '0.00', '101'), 
('32', '2018-12-06', 'SEROLOGY', 'CFT For Failaria', '0', '0.00', '101'), 
('33', '2018-12-06', 'HORMON', 'T3.T4.TSH', '0', '0.00', '101'), 
('34', '2018-12-06', 'HORMON', 'S. Prolacten', '0', '0.00', '101'), 
('35', '2018-12-06', 'URINE', 'R/E M/E', '0', '0.00', '101'), 
('36', '2018-12-06', 'URINE', 'Pregnancy Test', '0', '0.00', '101'), 
('37', '2018-12-06', 'STOOL', 'R/E M/E O BT', '0', '0.00', '101'), 
('38', '2018-12-06', 'STOOL', 'Reducing Substasnces', '0', '0.00', '101'), 
('39', '2018-12-06', 'STOOL', 'Others', '0', '0.00', '101'), 
('40', '2018-12-06', 'DIGITAL X-RAY', 'Chest P/A View', '0', '0.00', '101'), 
('41', '2018-12-06', 'DIGITAL X-RAY', 'Ba-Meal-Stomach & Duodenum', '0', '0.00', '101'), 
('42', '2018-12-06', 'DIGITAL X-RAY', 'Ba-Swallow Oesophagus', '0', '0.00', '101'), 
('43', '2018-12-06', 'DIGITAL X-RAY', 'K.U.B', '0', '0.00', '101'), 
('44', '2018-12-06', 'DIGITAL X-RAY', 'Skull B V / P.N.S', '0', '0.00', '101'), 
('45', '2018-12-06', 'DIGITAL X-RAY', 'Plain X-Ray Abdomen / C.P.D', '0', '0.00', '101'), 
('46', '2018-12-06', 'DIGITAL X-RAY', 'Cervical Spine B.V', '0', '0.00', '101'), 
('47', '2018-12-06', 'DIGITAL X-RAY', 'Lumbo-Sacral B.V', '0', '0.00', '101'), 
('48', '2018-12-06', 'DIGITAL X-RAY', 'Others', '0', '0.00', '101'), 
('49', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'HBS', '0', '0.00', '101'), 
('50', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Thyroid', '0', '0.00', '101'), 
('51', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Brdast', '0', '0.00', '101'), 
('52', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Testis', '0', '0.00', '101'), 
('53', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'K.U.B', '0', '0.00', '101'), 
('54', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Lower Abdomen', '0', '0.00', '101'), 
('55', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Pelvic Organs', '0', '0.00', '101'), 
('56', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Pregnancy Profile', '0', '0.00', '101'), 
('57', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Whole Abdomen', '0', '0.00', '101'), 
('58', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Others', '0', '0.00', '101'), 
('59', '2018-12-06', 'OTHERS', 'Semen Analysis', '0', '0.00', '101'), 
('60', '2018-12-06', 'OTHERS', 'MT Tuberculin Test', '0', '0.00', '101'), 
('61', '2018-12-06', 'OTHERS', 'Haxagon T.B', '0', '0.00', '101'), 
('62', '2018-12-06', 'OTHERS', 'IGE T.B', '0', '0.00', '101'), 
('63', '2018-12-06', 'OTHERS', 'IGG T.B', '0', '0.00', '101'), 
('64', '2018-12-06', 'OTHERS', 'IGM T.B', '0', '0.00', '101'), 
('65', '2018-12-06', 'OTHERS', 'H.V.S. G/S', '0', '0.00', '101'), 
('66', '2018-12-06', 'OTHERS', 'P/S G/S', '0', '0.00', '101'), 
('67', '2018-12-06', 'OTHERS', 'Sputem For A.F.B', '0', '0.00', '101'), 
('68', '2018-12-17', 'DIGITAL ULTRASONOGRAPHY', 'Pregnancy Profile', '400', '0.00', ''), 
('69', '2019-06-23', 'URINE', 'R/E M/E', '1000', '100.00', '10'), 
('70', '2020-06-20', 'HAEMATOLOGY', 'CBC', '400', '1.00', '1'), 
('71', '2020-06-21', 'URINE', 'R/E M/E', '150', '150.00', '01'), 
('72', '2020-06-21', 'HAEMATOLOGY', 'CBC', '400', '0.00', '201'), 
('73', '2020-06-22', 'BIOCHEMISTRY', 'S.Protin', '300', '200.00', '205'), 
('74', '2020-06-22', 'BIOCHEMISTRY', 'S.G.O.T.(AST)', '540', '350.00', '1001'), 
('75', '2020-06-22', 'BIOCHEMISTRY', 'S. Creatinine', '400', '50.00', '102');  



INSERT INTO `journal` ( `id`, `date`, `ref`, `details`, `amount`, `status`) VALUES 
('1', '2018-08-08', 'doctors:', 'commission', '0.00', 'cost'), 
('2', '2018-08-09', 'pid:00001', 'diagnosis', '100.00', 'income'), 
('3', '2018-08-11', 'pid:00001', 'diagnosis', '6000.00', 'income'), 
('4', '2018-08-11', 'pid:00002', 'diagnosis', '100.00', 'income'), 
('5', '2018-08-13', 'pid:00003', 'diagnosis', '6000.00', 'income'), 
('6', '2018-08-13', 'pid:00004', 'diagnosis', '75.00', 'income'), 
('7', '2018-09-04', 'pid:00005', 'diagnosis', '2000.00', 'income'), 
('8', '2018-12-18', 'pid:00006', 'diagnosis', '1500.00', 'income'), 
('9', '2018-12-25', '', 'consultancy', '0.00', 'income'), 
('10', '2018-12-25', '', 'consultancy', '0.00', 'income'), 
('11', '2018-12-25', '', 'consultancy', '0.00', 'income'), 
('12', '2019-06-23', 'pid:00007', 'diagnosis', '0.00', 'income'), 
('13', '2020-06-16', 'doctors:', 'commission', '15000.00', 'cost'), 
('14', '2020-06-16', 'doctors:', 'commission', '14000.00', 'cost'), 
('15', '2020-06-16', 'doctors:', 'commission', '7.00', 'cost'), 
('16', '2020-06-16', 'doctors:', 'commission', '0.00', 'cost'), 
('17', '2020-06-16', '', 'consultancy', '0.00', 'income'), 
('18', '2020-06-16', 'pid:00008', 'diagnosis', '0.00', 'income'), 
('19', '2020-06-20', 'pid:00009', 'diagnosis', '0.00', 'income'), 
('20', '2020-06-22', '', 'consultancy', '1000.00', 'income'), 
('21', '2020-06-22', 'pid:00010', 'diagnosis', '500.00', 'income'), 
('22', '2020-06-22', '', 'consultancy', '0.00', 'income'), 
('23', '2020-06-22', '', 'consultancy', '0.00', 'income'), 
('24', '2020-06-22', '', 'consultancy', '0.00', 'income'), 
('25', '2020-06-22', 'pid:00011', 'diagnosis', '1035.00', 'income'), 
('26', '2020-06-22', 'pid:00012', 'diagnosis', '500.00', 'income'), 
('27', '2020-06-22', 'pid:00013', 'diagnosis', '500.00', 'income'), 
('28', '2020-06-22', 'pid:00014', 'diagnosis', '0.00', 'income'), 
('29', '2020-06-22', 'pid:00015', 'diagnosis', '0.00', 'income'), 
('30', '2020-06-22', 'pid:00016', 'diagnosis', '1000.00', 'income'), 
('31', '2020-06-22', '', 'consultancy', '1000.00', 'income'), 
('32', '2020-06-22', '', 'consultancy', '0.00', 'income'), 
('33', '2020-06-22', '', 'consultancy', '1200.00', 'income'), 
('34', '2020-06-22', '', 'consultancy', '0.00', 'income'), 
('35', '2020-06-22', '', 'consultancy', '300.00', 'income'), 
('36', '2020-06-23', '', 'consultancy', '0.00', 'income'), 
('37', '2020-06-23', '', 'consultancy', '0.00', 'income'), 
('38', '2020-06-23', 'pid:00017', 'diagnosis', '0.00', 'income'), 
('39', '2020-06-23', '', 'consultancy', '0.00', 'income'), 
('40', '2020-06-23', '', 'consultancy', '0.00', 'income'), 
('41', '2020-06-23', '', 'consultancy', '500.00', 'income'), 
('42', '2020-06-23', '', 'consultancy', '500.00', 'income');  



INSERT INTO `marketer` ( `id`, `create_at`, `name`, `mobile`, `commission`, `address`, `img_url`) VALUES 
('2', '2018-07-10', 'Kim Gamble', '92124578960', '4', 'Qui voluptatum sit et magna aliquip in sit aute ipsum error aliquam temporibus rem atque in', 'rm628k9etre_79a.png'), 
('3', '2018-07-10', 'Cherokee Beard', '55012456871', '6', 'Fugiat et omnis tempore praesentium labore nihil est quae reprehenderit optio', 'k0a28mr8_eetr11.png'), 
('4', '2020-06-23', 'Wr7bYsaTq9', '01748022626', '40', 'MKWRkyqDQD', 'k72_4ertam67e0r.jpg'), 
('5', '2020-06-23', 'Shamim', '01910874583', '20', 'sf', '_9mrr8tea4k10e1.jpg');  



INSERT INTO `medicine` ( `id`, `product_name`, `product_code`, `product_cat`, `subcategory`, `purchase_price`, `sale_price`, `unit`, `status`) VALUES 
('1', 'Acicox 100mg', '005-0264-064', 'Capsule', 'ACI Limited', '10.00', '5.00', '100 mg', '005-0264-064'), 
('2', 'Napa 100mg', '005-0264-064', 'Capsule', 'ACI Limited', '10.00', '5.00', '100 mg', '005-0264-064'), 
('3', 'Acicox   100 mg', '005-0264-064', 'Capsule', 'ACI Limited', '0.00', '0.00', '100 mg', 'Celecoxib'), 
('4', 'Avlomox   250 mg', '005-0181-023', 'Capsule', 'ACI Limited', '3.45', '0.00', '250 mg', 'Amoxicillin'), 
('5', 'Avlomox   500 mg', '005-0258-23', 'Capsule', 'ACI Limited', '6.12', '0.00', '500 mg', 'Amoxicillin'), 
('6', 'Avlosef   250 mg', '005-0129-023', 'Capsule', 'ACI Limited', '8.02', '0.00', '250 mg', 'Cephradine'), 
('7', 'Avlosef   500 mg', '005-0130-23', 'Capsule', 'ACI Limited', '15.05', '0.00', '500 mg', 'Cephradine'), 
('8', 'Avloxin   250 mg', '005-0254-23', 'Capsule', 'ACI Limited', '0.00', '0.00', '250 mg', 'Cephalexin'), 
('9', 'Avloxin   500 mg', '005-0255-23', 'Capsule', 'ACI Limited', '10.57', '0.00', '500 mg', 'Cephalexin'), 
('10', 'Castin   375 mg', '005-0405-31', 'Capsule', 'ACI Limited', '2.52', '0.00', '375 mg', 'Carbocisteine'), 
('11', 'Cedril   500 mg', '005-0320-23', 'Capsule', 'ACI Limited', '12.09', '0.00', '500 mg', 'Cefadroxil'), 
('12', 'Cefim   200 mg', '005-0296-23', 'Capsule', 'ACI Limited', '35.11', '0.00', '200 mg', 'Cefixime'), 
('13', 'Cefdox      100 mg', '005-0336-23', 'Capsule', 'ACI Limited', '22.13', '0.00', '100 mg', 'Cefpodoxime'), 
('14', 'Fluclox    250 mg', '005-0142-23', 'Capsule', 'ACI Limited', '5.79', '0.00', '250 mg', 'Flucloxacillin'), 
('15', 'Fluclox    500 mg', '005-0259-23', 'Capsule', 'ACI Limited', '10.57', '0.00', '500 mg', 'Flucloxacillin'), 
('16', 'Impedox    100 mg', '005-0123-23', 'Capsule', 'ACI Limited', '2.17', '0.00', '100 mg', 'Doxycycline'), 
('17', 'Impetet   250 mg', '005-0022-23', 'Capsule', 'ACI Limited', '0.00', '0.00', '250 mg', 'Oxytetracycline'), 
('18', 'Ketron  SR    100 mg', '005-0418-64', 'Capsule', 'ACI Limited', '7.05', '0.00', '100 mg', 'Ketoprofen'), 
('19', 'Ketron  SR    200 mg', '005-0419-64', 'Capsule', 'ACI Limited', '10.07', '0.00', '200 mg', 'Ketoprofen'), 
('20', 'Lanz   15 mg', '005-0339-67', 'Capsule', 'ACI Limited', '3.03', '0.00', '15 mg', 'Lansoprazole'), 
('21', 'Lanz   30 mg', '005-0340-67', 'Capsule', 'ACI Limited', '5.04', '0.00', '30 mg', 'Lansoprazole'), 
('22', 'Lipigem   300 mg', '005-0421-61', 'Capsule', 'ACI Limited', '7.05', '0.00', '300 mg', 'Gemfibrozil'), 
('23', 'Odazyth   250 mg', '005-0233-23', 'Capsule', 'ACI Limited', '25.08', '0.00', '250 mg', 'Azithromycin'), 
('24', 'Xeldrin   10 mg', '005-0386-67', 'Capsule', 'ACI Limited', '2.02', '0.00', '10 mg', 'Omeprazole'), 
('25', 'Xeldrin      40 mg', '005-0319-67', 'Capsule', 'ACI Limited', '8.02', '0.00', '40 mg', 'Omeprazole'), 
('26', 'Tendia   50 mg', '005-0463-65', 'Capsule', 'ACI Limited', '7.55', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('27', 'Mobifen  SR    100 mg', '005-0573-64', 'Capsule', 'ACI Limited', '3.02', '0.00', '100 mg', 'Diclofenac Sodium'), 
('28', 'Brodil  SR   8 mg', '005-05184', 'Capsule', 'ACI Limited', '2.42', '0.00', '8 mg', 'Salbutamol'), 
('29', 'Inever  SR    40 mg', '005-0600-23', 'Capsule', 'ACI Limited', '0.00', '0.00', '40 mg', 'Propranolol Hydrochloride'), 
('30', 'Teolex  CR   300 mg', '005-06374', 'Capsule', 'ACI Limited', '3.52', '0.00', '300 mg', 'Theophylline'), 
('31', 'Teolex   400 mg', '005-06384', 'Capsule', 'ACI Limited', '4.25', '0.00', '400 mg', 'Theophylline'), 
('32', 'Mobifen  SR    75 mg', '005-0632-64', 'Capsule', 'ACI Limited', '2.52', '0.00', '75 mg', 'Diclofenac Sodium'), 
('33', 'Ambroxol  SR   75 mg', '005-063-31', 'Capsule', 'ACI Limited', '0.00', '0.00', '75 mg', 'Ambroxol'), 
('34', 'Anaxyl   250 mg', '005-06459', 'Capsule', 'ACI Limited', '0.00', '0.00', '250 mg', 'Tranexamic Acid'), 
('35', 'Gabarol      75 mg', '005-0644-046', 'Capsule', 'ACI Limited', '16.11', '0.00', '75 mg', 'Pregabalin'), 
('36', 'Gabarol      100 mg', '005-0643-046', 'Capsule', 'ACI Limited', '22.15', '0.00', '100 mg', 'Pregabalin'), 
('37', 'Gabarol      150 mg', '005-0642-046', 'Capsule', 'ACI Limited', '30.20', '0.00', '150 mg', 'Pregabalin'), 
('38', 'Pandeflu   75 mg', '005-0641-32', 'Capsule', 'ACI Limited', '151.02', '0.00', '75 mg', 'Oseltamivir'), 
('39', 'Cefim-3 DS   400 mg', '005-0670-23', 'Capsule', 'ACI Limited', '50.34', '0.00', '400 mg', 'Cefixime'), 
('40', 'Anaxyl0   500 mg', '005-06739', 'Capsule', 'ACI Limited', '15.11', '0.00', '500 mg', 'Tranexamic Acid'), 
('41', 'Abaclor   250 mg', '005-0689-23', 'Capsule', 'ACI Limited', '21.14', '0.00', '250 mg', 'Cefaclor'), 
('42', 'Abaclor0   500 mg', '005-0691-23', 'Capsule', 'ACI Limited', '40.27', '0.00', '500 mg', 'Cefaclor'), 
('43', 'Sasolin   400 mcg', '005-07019', 'Capsule', 'ACI Limited', '10.07', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('44', 'Daclin   150 mg', '005-0781-23', 'Capsule', 'ACI Limited', '8.02', '0.00', '150 mg', 'Clindamycin'), 
('45', 'Soritec   25 mg', '005-0776-71', 'Capsule', 'ACI Limited', '85.26', '0.00', '25 mg', 'Acitretin'), 
('46', 'Gabarol   50 mg', '005-0788-046', 'Capsule', 'ACI Limited', '12.04', '0.00', '50 mg', 'Pregabalin'), 
('47', 'Soritec   10 mg', '005-0800-71', 'Capsule', 'ACI Limited', '45.14', '0.00', '10 mg', 'Acitretin'), 
('48', 'Daclin   300 mg', '005-0816-23', 'Capsule', 'ACI Limited', '15.05', '0.00', '300 mg', 'Clindamycin'), 
('49', 'Tizabate   200 mg', '005-0820-61', 'Capsule', 'ACI Limited', '7.02', '0.00', '200 mg', 'Fenofibrate'), 
('50', 'Esomep   20 mg', '005-0848-067', 'Capsule', 'ACI Limited', '7.02', '0.00', '20 mg', 'Esomeprazole'), 
('51', 'Esomep   40 mg', '005-0849-067', 'Capsule', 'ACI Limited', '9.03', '0.00', '40 mg', 'Esomeprazole'), 
('52', 'Flamex SR   300 mg', '005-0850-64', 'Capsule', 'ACI Limited', '4.01', '0.00', '300 mg', 'Ibuprofen'), 
('53', 'Gabarol   25 mg', '005-0872-046', 'Capsule', 'ACI Limited', '8.02', '0.00', '25 mg', 'Pregabalin'), 
('54', 'Amantril   100 mg', '59322', 'Capsule', 'ACI Limited', '10.00', '0.00', '100 mg', 'Amantadine Hydrochloride'), 
('55', 'Radola   100 mg', '5426', 'Capsule', 'ACI Limited', '6.00', '0.00', '100 mg', 'Racecadrotil'), 
('56', 'Ornical   120 mg', '543', 'Capsule', 'ACI Limited', '55.00', '0.00', '120 mg', 'Orlistat'), 
('57', 'Insaid   25 mg', '00556-64', 'Capsule', 'ACI Limited', '1.00', '0.00', '25 mg', 'Indomethacin'), 
('58', 'Insaid SR   75 mg', '00557-64', 'Capsule', 'ACI Limited', '0.00', '0.00', '75 mg', 'Indomethacin'), 
('59', 'Cefteria   400 mg', '00581-23', 'Capsule', 'ACI Limited', '120.00', '0.00', '400 mg', 'Ceftibuten'), 
('60', 'Chrocee   200 mg', '00588-32', 'Capsule', 'ACI Limited', '35.00', '0.00', '200 mg', 'Ribavirin'), 
('61', 'Paricel   20 mg', '005116-67', 'Capsule', 'ACI Limited', '8.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('62', 'Myrox SR   75 mg', '005-0633-031', 'Capsule', 'ACI Limited', '5.04', '0.00', '75 mg', 'Ambroxol'), 
('63', 'Hexitane   1 %', '005-0003-71', 'Cream', 'ACI Limited', '90.00', '0.00', '1 %', 'Chlorhexidine Gluconate'), 
('64', 'Sibalyn   1 %', '005-0708-23', 'Cream', 'ACI Limited', '40.12', '0.00', '1 %', 'Silver Sulphadiazine'), 
('65', 'Oralon   1 %', '005-0140-71', 'Gel', 'ACI Limited', '55.17', '0.00', '1 %', 'Chlorhexidine Gluconate'), 
('66', 'Acipillin   2 gm', '005-0218-077', 'Injection', 'ACI Limited', '50.00', '0.00', '2 gm', 'Ampicillin'), 
('67', 'Avlomox   250 mg', '005-0183-023', 'Injection', 'ACI Limited', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('68', 'Avlomox   500 mg', '005-0184-23', 'Injection', 'ACI Limited', '32.10', '0.00', '500 mg', 'Amoxicillin'), 
('69', 'Water For Injection   5 ml', '005-0189-79', 'Injection', 'ACI Limited', '0.00', '0.00', '5 ml', 'Water For Injection'), 
('70', 'Thiopen  IV   1 gm', '005-0575', 'Injection', 'ACI Limited', '100.68', '0.00', '1 gm', 'Thiopentone Sodium'), 
('71', 'Thiopen  IV   500 mg', '005-0576', 'Injection', 'ACI Limited', '70.05', '0.00', '500 mg', 'Thiopentone Sodium'), 
('72', 'Odazyth  IV   500 mg', '005-0625-23', 'Injection', 'ACI Limited', '251.69', '0.00', '500 mg', 'Azithromycin'), 
('73', 'Acigan   vet   5 gm', '005-0326-077', 'Injection', 'ACI Limited', '0.00', '0.00', '5 gm', 'Gentamicin'), 
('74', 'Acimox Vet   1 gm', '593-0985-023', 'Injection', 'ACI Limited', '56.06', '0.00', '1 gm', 'Amoxicillin'), 
('75', 'Relacsn   68 %', '005-0300-60', 'Oral Solution', 'ACI Limited', '65.45', '0.00', '68 %', 'Lactulose'), 
('76', 'Acemox   30 %', '005-0324-077', 'Powder', 'ACI Limited', '267.25', '0.00', '30 %', 'Amoxicillin'), 
('77', 'Mycogard Vet Oral Powder   45 %', '593-0999-077', 'Powder', 'ACI Limited', '1200.00', '0.00', '45 %', 'Tiamulin Hydrogen Fumerate'), 
('78', 'Lacticon Dispersible Granules   10 gm', '005111-60', 'Powder', 'ACI Limited', '25.00', '0.00', '10 gm', 'Lactitol'), 
('79', 'Anaflex   250 mg', '005-0389-64', 'Suppository', 'ACI Limited', '0.00', '0.00', '250 mg', 'Naproxen'), 
('80', 'Anaflex   500 mg', '005-0390-64', 'Suppository', 'ACI Limited', '0.00', '0.00', '500 mg', 'Naproxen'), 
('81', 'Mobiefn   12.5 mg', '005-0387-64', 'Suppository', 'ACI Limited', '9.00', '0.00', '12.5 mg', 'Diclofenac Sodium'), 
('82', 'Mobifen      50 mg', '005-0388-64', 'Suppository', 'ACI Limited', '15.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('83', 'Xcel   250 mg', '005-0392-006', 'Suppository', 'ACI Limited', '5.00', '0.00', '250 mg', 'Paracetamol'), 
('84', 'Xcel   125 mg', '005-0391-006', 'Suppository', 'ACI Limited', '4.00', '0.00', '125 mg', 'Paracetamol'), 
('85', 'Xcel0   500 mg', '00544-006', 'Suppository', 'ACI Limited', '8.00', '0.00', '500 mg', 'Paracetamol'), 
('86', 'Mobifen   25 mg', '00545-64', 'Suppository', 'ACI Limited', '12.00', '0.00', '25 mg', 'Diclofenac Sodium'), 
('87', 'Sapotor.15 Suppository   1.15 gm', '00564-60', 'Suppository', 'ACI Limited', '3.00', '0.00', '1.15 gm', 'Glycerol'), 
('88', 'Sapotor.30 Suppository   2.3 gm', '00565-60', 'Suppository', 'ACI Limited', '5.00', '0.00', '2.3 gm', 'Glycerol'), 
('89', 'Acical   1250 mg', '005-0297-62', 'Tablet', 'ACI Limited', '4.01', '0.00', '1250 mg', 'Calcium Carbonate'), 
('90', 'Aciflox      200 mg', '005-0262-23', 'Tablet', 'ACI Limited', '12.00', '0.00', '200 mg', 'Sparfloxacin'), 
('91', 'Aciprin  CV    75 mg', '005-0278-26', 'Tablet', 'ACI Limited', '0.39', '0.00', '75 mg', 'Aspirin'), 
('92', 'Acira   4 mg', '005-0394-21', 'Tablet', 'ACI Limited', '0.30', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('93', 'Acitrin   10 mg', '005-0202-21', 'Tablet', 'ACI Limited', '3.01', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('94', 'Amotrex      200 mg', '005-0111-27', 'Tablet', 'ACI Limited', '0.69', '0.00', '200 mg', 'Metronidazole'), 
('95', 'Amotrex   400 mg', '005-0112-27', 'Tablet', 'ACI Limited', '1.27', '0.00', '400 mg', 'Metronidazole'), 
('96', 'Amotrex  DS   800 mg', '005-0375-27', 'Tablet', 'ACI Limited', '2.02', '0.00', '800 mg', 'Metronidazole'), 
('97', 'Anaflex   500 mg', '005-0145-64', 'Tablet', 'ACI Limited', '9.06', '0.00', '500 mg', 'Naproxen'), 
('98', 'Xcel   500 mg', '005-0071-006', 'Tablet', 'ACI Limited', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('99', 'Avloquin   250 mg', '005-0001-24', 'Tablet', 'ACI Limited', '1.22', '0.00', '250 mg', 'Chloroquine Phosphate'), 
('100', 'Buterol   10 mg', '005-03994', 'Tablet', 'ACI Limited', '1.51', '0.00', '10 mg', 'Bambuterol Hydrochloride'), 
('101', 'Buterol      20 mg', '005-04004', 'Tablet', 'ACI Limited', '3.02', '0.00', '20 mg', 'Bambuterol Hydrochloride'), 
('102', 'Brodil   2 mg', '005-01084', 'Tablet', 'ACI Limited', '0.26', '0.00', '2 mg', 'Salbutamol'), 
('103', 'Brodil   4 mg', '005-01094', 'Tablet', 'ACI Limited', '0.46', '0.00', '4 mg', 'Salbutamol'), 
('104', 'Colik   10 mg', '005-03631', 'Tablet', 'ACI Limited', '3.45', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('105', 'Cab      5 mg', '005-0251-022', 'Tablet', 'ACI Limited', '5.02', '0.00', '5 mg', 'Amlodipine'), 
('106', 'Canazole      150 mg', '005-0231', 'Tablet', 'ACI Limited', '22.15', '0.00', '150 mg', 'Fluconazole'), 
('107', 'Canazole      50 mg', '005-0230', 'Tablet', 'ACI Limited', '8.05', '0.00', '50 mg', 'Fluconazole'), 
('108', 'Cefdox      200 mg', '005-0433-23', 'Tablet', 'ACI Limited', '42.29', '0.00', '200 mg', 'Cefpodoxime'), 
('109', 'Celofen   100 mg', '005-0420-64', 'Tablet', 'ACI Limited', '4.01', '0.00', '100 mg', 'Aceclofenac'), 
('110', 'Ceplep      200 mg', '005-0358-046', 'Tablet', 'ACI Limited', '4.03', '0.00', '200 mg', 'Carbamazepine'), 
('111', 'Cerox A     250 mg', '005-0330-23', 'Tablet', 'ACI Limited', '25.17', '0.00', '250 mg', 'Cefuroxime'), 
('112', 'Cerox A   125 mg', '005-0329-23', 'Tablet', 'ACI Limited', '15.11', '0.00', '125 mg', 'Cefuroxime'), 
('113', 'Chear      25 mg', '005-02744', 'Tablet', 'ACI Limited', '3.02', '0.00', '25 mg', 'Sertraline'), 
('114', 'Chear      50 mg', '005-02674', 'Tablet', 'ACI Limited', '6.04', '0.00', '50 mg', 'Sertraline'), 
('115', 'Clorel      75 mg', '005-0316-26', 'Tablet', 'ACI Limited', '12.04', '0.00', '75 mg', 'Clopidogrel'), 
('116', 'Deslorin   5 mg', '005-0305-21', 'Tablet', 'ACI Limited', '2.51', '0.00', '5 mg', 'Desloratadine'), 
('117', 'Dexcor   .5 mg', '005-0354-72', 'Tablet', 'ACI Limited', '0.45', '0.00', '.5 mg', 'Dexamethasone'), 
('118', 'Drovin      40 mg', '005-03451', 'Tablet', 'ACI Limited', '1.77', '0.00', '40 mg', 'Drotaverine Hydrochloride'), 
('119', 'Esomep      40 mg', '005-0384-67', 'Tablet', 'ACI Limited', '8.02', '0.00', '40 mg', 'Esomeprazole'), 
('120', 'Esomep      20 mg', '005-0342-067', 'Tablet', 'ACI Limited', '5.02', '0.00', '20 mg', 'Esomeprazole'), 
('121', 'Etrax   40 mg', '005-0057-8', 'Tablet', 'ACI Limited', '1.00', '0.00', '40 mg', 'Levamisole'), 
('122', 'Ezolid   600 mg', '005-0397-023', 'Tablet', 'ACI Limited', '85.00', '0.00', '600 mg', 'Linezolid'), 
('123', 'Ezolid   400 mg', '005-0396-023', 'Tablet', 'ACI Limited', '60.00', '0.00', '400 mg', 'Linezolid'), 
('124', 'Flamex   400 mg', '005-0118-64', 'Tablet', 'ACI Limited', '1.43', '0.00', '400 mg', 'Ibuprofen'), 
('125', 'Flamex      200 mg', '005-0117-64', 'Tablet', 'ACI Limited', '0.00', '0.00', '200 mg', 'Ibuprofen'), 
('126', 'Floxabid   250 mg', '005-0132-23', 'Tablet', 'ACI Limited', '8.56', '0.00', '250 mg', 'Ciprofloxacin'), 
('127', 'Floxabid   500 mg', '005-0212-23', 'Tablet', 'ACI Limited', '15.05', '0.00', '500 mg', 'Ciprofloxacin'), 
('128', 'Floxabid   750 mg', '005-0351-23', 'Tablet', 'ACI Limited', '18.12', '0.00', '750 mg', 'Ciprofloxacin'), 
('129', 'Fluver   10 mg', '005-04307', 'Tablet', 'ACI Limited', '5.02', '0.00', '10 mg', 'Flunarizine'), 
('130', 'Fluver      5 mg', '005-04297', 'Tablet', 'ACI Limited', '3.51', '0.00', '5 mg', 'Flunarizine'), 
('131', 'Fulcinex   500 mg', '005-0062', 'Tablet', 'ACI Limited', '5.60', '0.00', '500 mg', 'Griseofulvin'), 
('132', 'Glimirid   1 mg', '005-0275', 'Tablet', 'ACI Limited', '4.51', '0.00', '1 mg', 'Glimepiride'), 
('133', 'Glimirid   2 mg', '005-0276', 'Tablet', 'ACI Limited', '8.02', '0.00', '2 mg', 'Glimepiride'), 
('134', 'Hypnoclone   7.5 mg', '005-0279-057', 'Tablet', 'ACI Limited', '4.03', '0.00', '7.5 mg', 'Zopiclone'), 
('135', 'Indever   10 mg', '005-0037-23', 'Tablet', 'ACI Limited', '0.51', '0.00', '10 mg', 'Propranolol Hydrochloride'), 
('136', 'Indever      40 mg', '005-0038-23', 'Tablet', 'ACI Limited', '1.50', '0.00', '40 mg', 'Propranolol Hydrochloride'), 
('137', 'Isart      150 mg', '005-0322-22', 'Tablet', 'ACI Limited', '9.06', '0.00', '150 mg', 'Irbesartan'), 
('138', 'Karvedil      25 mg', '005-0273-22', 'Tablet', 'ACI Limited', '8.05', '0.00', '25 mg', 'Carvedilol'), 
('139', 'Karvedil   12.5 mg', '005-0432-22', 'Tablet', 'ACI Limited', '4.03', '0.00', '12.5 mg', 'Carvedilol'), 
('140', 'Karvedil   6.25 mg', '005-0272-22', 'Tablet', 'ACI Limited', '3.02', '0.00', '6.25 mg', 'Carvedilol'), 
('141', 'Minolac   10 mg', '005-0355-064', 'Tablet', 'ACI Limited', '10.07', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('142', 'Ketron      50 mg', '005-0352-64', 'Tablet', 'ACI Limited', '3.52', '0.00', '50 mg', 'Ketoprofen'), 
('143', 'Leflox   500 mg', '005-0310-23', 'Tablet', 'ACI Limited', '15.11', '0.00', '500 mg', 'Levofloxacin'), 
('144', 'Rosatan      50 mg', '005-0346-022', 'Tablet', 'ACI Limited', '6.04', '0.00', '50 mg', 'Losartan Potassium'), 
('145', 'Lozide   80 mg', '005-0295', 'Tablet', 'ACI Limited', '7.02', '0.00', '80 mg', 'Gliclazide'), 
('146', 'Meflon   250 mg', '005-0435-24', 'Tablet', 'ACI Limited', '39.61', '0.00', '250 mg', 'Mefloquine'), 
('147', 'Metform   850 mg', '005-0293', 'Tablet', 'ACI Limited', '4.51', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('148', 'Metform   500 mg', '005-0294', 'Tablet', 'ACI Limited', '5.02', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('149', 'Mobifen      25 mg', '005-0137-64', 'Tablet', 'ACI Limited', '0.00', '0.00', '25 mg', 'Diclofenac Sodium'), 
('150', 'Mobifen      50 mg', '005-0138-64', 'Tablet', 'ACI Limited', '0.88', '0.00', '50 mg', 'Diclofenac Sodium'), 
('151', 'Moniten      20 mg', '005-0203', 'Tablet', 'ACI Limited', '1.42', '0.00', '20 mg', 'Isosorbide Mononitrate'), 
('152', 'Nortyl      25 mg', '005-03654', 'Tablet', 'ACI Limited', '0.00', '0.00', '25 mg', 'Nortriptyline'), 
('153', 'Novatac      20 mg', '005-01785', 'Tablet', 'ACI Limited', '2.27', '0.00', '20 mg', 'Famotidine'), 
('154', 'Novatac      40 mg', '005-01795', 'Tablet', 'ACI Limited', '4.13', '0.00', '40 mg', 'Famotidine'), 
('155', 'Nutrivit E     200 mg', '005-0156-78', 'Tablet', 'ACI Limited', '3.82', '0.00', '200 mg', 'Vitamin E'), 
('156', 'Nutrivit C     250 mg', '005-0155-78', 'Tablet', 'ACI Limited', '1.32', '0.00', '250 mg', 'Vitamin C'), 
('157', 'Odazyth   500 mg', '005-0257-23', 'Tablet', 'ACI Limited', '35.11', '0.00', '500 mg', 'Azithromycin'), 
('158', 'Omeflox   400 mg', '005-0368-23', 'Tablet', 'ACI Limited', '15.11', '0.00', '400 mg', 'Lomefloxacin'), 
('159', 'Osetron   8 mg', '005-03718', 'Tablet', 'ACI Limited', '10.07', '0.00', '8 mg', 'Ondansetron'), 
('160', 'Pantex      20 mg', '005-0341-67', 'Tablet', 'ACI Limited', '5.02', '0.00', '20 mg', 'Pantoprazole'), 
('161', 'Pantex   40 mg', '005-0377-67', 'Tablet', 'ACI Limited', '7.02', '0.00', '40 mg', 'Pantoprazole'), 
('162', 'Pevil   22.7 mg', '005-0359-21', 'Tablet', 'ACI Limited', '0.46', '0.00', '22.7 mg', 'Pheniramine Maleate'), 
('163', 'Progic      25 mg', '005-0373-21', 'Tablet', 'ACI Limited', '0.00', '0.00', '25 mg', 'Promethazine Hydrochloride'), 
('164', 'Prosma   1 mg', '005-0205-21', 'Tablet', 'ACI Limited', '2.01', '0.00', '1 mg', 'Ketotifen'), 
('165', 'Recol   10 mg', '005-0266-61', 'Tablet', 'ACI Limited', '10.07', '0.00', '10 mg', 'Simvastatin'), 
('166', 'Reversair   10 mg', '005-0315-044', 'Tablet', 'ACI Limited', '15.11', '0.00', '10 mg', 'Montelukast'), 
('167', 'Sedzam   10 mg', '005-03326', 'Tablet', 'ACI Limited', '2.82', '0.00', '10 mg', 'Clobazam'), 
('168', 'Sezol  DS   1 gm', '005-0236-27', 'Tablet', 'ACI Limited', '17.05', '0.00', '1 gm', 'Secnidazole'), 
('169', 'Sintel      200 mg', '005-0134-008', 'Tablet', 'ACI Limited', '0.00', '0.00', '200 mg', 'Albendazole'), 
('170', 'Sintel   400 mg', '005-0207-008', 'Tablet', 'ACI Limited', '5.02', '0.00', '400 mg', 'Albendazole'), 
('171', 'Stril      5 mg', '005-0248-22', 'Tablet', 'ACI Limited', '3.02', '0.00', '5 mg', 'Lisinopril'), 
('172', 'Stril   10 mg', '005-0249-22', 'Tablet', 'ACI Limited', '0.00', '0.00', '10 mg', 'Lisinopril'), 
('173', 'Tenoren      100 mg', '005-0056-22', 'Tablet', 'ACI Limited', '1.38', '0.00', '100 mg', 'Atenolol'), 
('174', 'Tenoren      50 mg', '005-0060-22', 'Tablet', 'ACI Limited', '0.77', '0.00', '50 mg', 'Atenolol'), 
('175', 'Tivit      100 mg', '005-0357-78', 'Tablet', 'ACI Limited', '0.75', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('176', 'Xantid      150 mg', '005-01265', 'Tablet', 'ACI Limited', '2.51', '0.00', '150 mg', 'Ranitidine'), 
('177', 'Xantid  HS   300 mg', '005-01315', 'Tablet', 'ACI Limited', '4.03', '0.00', '300 mg', 'Ranitidine'), 
('178', 'Xytrex   10 mg', '005-0277-28', 'Tablet', 'ACI Limited', '4.53', '0.00', '10 mg', 'Olanzapine'), 
('179', 'Zepam   3 mg', '005-03337', 'Tablet', 'ACI Limited', '5.02', '0.00', '3 mg', 'Bromazepam'), 
('180', 'Tynium   50 mg', '005-04721', 'Tablet', 'ACI Limited', '6.02', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('181', 'Anaflex  SR   500 mg', '005-0470-64', 'Tablet', 'ACI Limited', '14.09', '0.00', '500 mg', 'Naproxen'), 
('182', 'Diverin   10 mg', '005-04601', 'Tablet', 'ACI Limited', '2.02', '0.00', '10 mg', 'Dicycloverine Hydrochloride'), 
('183', 'Paricel      20 mg', '005-0286-67', 'Tablet', 'ACI Limited', '5.04', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('184', 'Tizadin   2 mg', '005-0311-70', 'Tablet', 'ACI Limited', '5.04', '0.00', '2 mg', 'Tizanidine'), 
('185', 'Lamitrin   50 mg', '005-0312-046', 'Tablet', 'ACI Limited', '18.05', '0.00', '50 mg', 'Lamotrigine'), 
('186', 'Atasin   10 mg', '005-0361-061', 'Tablet', 'ACI Limited', '10.07', '0.00', '10 mg', 'Atorvastatin'), 
('187', 'Vave   10 mg', '005-02898', 'Tablet', 'ACI Limited', '2.02', '0.00', '10 mg', 'Domperidone'), 
('188', 'Rosatan      25 mg', '005-0369-022', 'Tablet', 'ACI Limited', '3.52', '0.00', '25 mg', 'Losartan Potassium'), 
('189', 'Erythin   500 mg', '005-0446-23', 'Tablet', 'ACI Limited', '8.06', '0.00', '500 mg', 'Erythromycin'), 
('190', 'Inosit   500 mg', '005-0450', 'Tablet', 'ACI Limited', '5.04', '0.00', '500 mg', 'Inositol'), 
('191', 'Inosit   750 mg', '005-0451', 'Tablet', 'ACI Limited', '7.55', '0.00', '750 mg', 'Inositol'), 
('192', 'Skinabin   250 mg', '005-0281', 'Tablet', 'ACI Limited', '40.27', '0.00', '250 mg', 'Terbinafine'), 
('193', 'Solone      5 mg', '005-0458-72', 'Tablet', 'ACI Limited', '1.72', '0.00', '5 mg', 'Prednisolone'), 
('194', 'Solone      20 mg', '005-0459-72', 'Tablet', 'ACI Limited', '4.00', '0.00', '20 mg', 'Prednisolone'), 
('195', 'Demarin   600 mg', '005-0506-64', 'Tablet', 'ACI Limited', '7.05', '0.00', '600 mg', 'Oxaprozin'), 
('196', 'Rolage   60 mg', '005-05028', 'Tablet', 'ACI Limited', '10.07', '0.00', '60 mg', 'Raloxifene Hydrochloride'), 
('197', 'Diar   500 mg', '005-0578-27', 'Tablet', 'ACI Limited', '10.07', '0.00', '500 mg', 'Nitazoxanide'), 
('198', 'Canider   10 mg', '005-0579-22', 'Tablet', 'ACI Limited', '5.04', '0.00', '10 mg', 'Lercanidipine Hydrochloride'), 
('199', 'Coxia   90 mg', '005-0581-64', 'Tablet', 'ACI Limited', '12.09', '0.00', '90 mg', 'Etoricoxib'), 
('200', 'Coxia   60 mg', '005-0582-64', 'Tablet', 'ACI Limited', '7.05', '0.00', '60 mg', 'Etoricoxib'), 
('201', 'Abetis      20 mg', '005-0587-22', 'Tablet', 'ACI Limited', '8.05', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('202', 'Motoral      20 mg', '005-0590-64', 'Tablet', 'ACI Limited', '5.04', '0.00', '20 mg', 'Leflunomide'), 
('203', 'Motoral      100 mg', '005-0591-64', 'Tablet', 'ACI Limited', '20.13', '0.00', '100 mg', 'Leflunomide'), 
('204', 'Coxia20   120 mg', '005-0580-64', 'Tablet', 'ACI Limited', '14.09', '0.00', '120 mg', 'Etoricoxib'), 
('205', 'Abetis      40 mg', '005-0588-22', 'Tablet', 'ACI Limited', '15.11', '0.00', '40 mg', 'Olmesartan Medoxomil'), 
('206', 'Natrilex  SR +   1.5 mg', '005-04652', 'Tablet', 'ACI Limited', '8.86', '0.00', '1.5 mg', 'Indapamide'), 
('207', 'Meba   135 mg', '005-05521', 'Tablet', 'ACI Limited', '0.00', '0.00', '135 mg', 'Mebeverine Hydrochloride'), 
('208', 'Xcel   DISPERSABLE   120 mg', '005-0559-006', 'Tablet', 'ACI Limited', '1.28', '0.00', '120 mg', 'Paracetamol'), 
('209', 'Meflon   PLUS   250 mg', '005-0569-24', 'Tablet', 'ACI Limited', '0.00', '0.00', '250 mg', 'Mefloquine'), 
('210', 'Dicarmin      100 mg', '005-0543-8', 'Tablet', 'ACI Limited', '0.00', '0.00', '100 mg', 'Diethylcarbamazine Citrate'), 
('211', 'Tenoren      25 mg', '005-0524-22', 'Tablet', 'ACI Limited', '0.45', '0.00', '25 mg', 'Atenolol'), 
('212', 'Diverin   20 mg', '005-05251', 'Tablet', 'ACI Limited', '3.52', '0.00', '20 mg', 'Dicycloverine Hydrochloride'), 
('213', 'Brodil Levo   1 mg', '005-05314', 'Tablet', 'ACI Limited', '1.10', '0.00', '1 mg', 'Levosalbutamol'), 
('214', 'Brodil Levo   2 mg', '005-05324', 'Tablet', 'ACI Limited', '0.00', '0.00', '2 mg', 'Levosalbutamol'), 
('215', 'Flamex      200 mg', '005-0534-64', 'Tablet', 'ACI Limited', '0.88', '0.00', '200 mg', 'Dexibuprofen (S Ibuprofen)'), 
('216', 'Flamex0   300 mg', '005-0535-64', 'Tablet', 'ACI Limited', '0.00', '0.00', '300 mg', 'Dexibuprofen (S Ibuprofen)'), 
('217', 'Flamex  DX   400 mg', '005-0536-64', 'Tablet', 'ACI Limited', '5.04', '0.00', '400 mg', 'Dexibuprofen (S Ibuprofen)'), 
('218', 'Clonium   .5 mg', '005-0515-046', 'Tablet', 'ACI Limited', '4.01', '0.00', '.5 mg', 'Clonazepam'), 
('219', 'Clonium   2 mg', '005-0516-046', 'Tablet', 'ACI Limited', '6.02', '0.00', '2 mg', 'Clonazepam'), 
('220', 'Veratin   6 mg', '005-0505-8', 'Tablet', 'ACI Limited', '0.00', '0.00', '6 mg', 'Ivermectin'), 
('221', 'Probis   5 mg', '005-0493-22', 'Tablet', 'ACI Limited', '10.03', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('222', 'Alaclov   500 mg', '005-0495-32', 'Tablet', 'ACI Limited', '40.27', '0.00', '500 mg', 'Valacyclovir'), 
('223', 'Leflox   750 mg', '005-0599-23', 'Tablet', 'ACI Limited', '20.13', '0.00', '750 mg', 'Levofloxacin'), 
('224', 'Bipinor   2.5 mg', '005-0636-22', 'Tablet', 'ACI Limited', '5.04', '0.00', '2.5 mg', 'Nebivolol'), 
('225', 'Cerox A    500 mg', '005-0484-23', 'Tablet', 'ACI Limited', '45.31', '0.00', '500 mg', 'Cefuroxime'), 
('226', 'Progil      50 mg', '005-0486', 'Tablet', 'ACI Limited', '0.00', '0.00', '50 mg', 'Voriconazole'), 
('227', 'Phyton   .5 mg', '005-0487-78', 'Tablet', 'ACI Limited', '4.03', '0.00', '.5 mg', 'Mecobalamin'), 
('228', 'Acron   200 mcg', '005-0488-65', 'Tablet', 'ACI Limited', '10.07', '0.00', '200 mcg', 'Buprenorphine'), 
('229', 'Nortyl   10 mg', '005-03644', 'Tablet', 'ACI Limited', '0.00', '0.00', '10 mg', 'Nortriptyline'), 
('230', 'Oxicam      20 mg', '005-0539-64', 'Tablet', 'ACI Limited', '8.05', '0.00', '20 mg', 'Tanoxicam'), 
('231', 'Colik      20 mg', '005-05971', 'Tablet', 'ACI Limited', '6.72', '0.00', '20 mg', 'Hyoscine Butyl Bromide'), 
('232', 'Atasin      20 mg', '005-0611-061', 'Tablet', 'ACI Limited', '18.12', '0.00', '20 mg', 'Atorvastatin'), 
('233', 'Bipinor   5 mg', '005-0491-22', 'Tablet', 'ACI Limited', '8.05', '0.00', '5 mg', 'Nebivolol'), 
('234', 'Teviral   1 mg', '005-0623-32', 'Tablet', 'ACI Limited', '100.30', '0.00', '1 mg', 'Entecavir'), 
('235', 'Teviral   .5 mg', '005-0624-32', 'Tablet', 'ACI Limited', '48.32', '0.00', '.5 mg', 'Entecavir'), 
('236', 'Mastel  MR   10 mg', '005-0627-21', 'Tablet', 'ACI Limited', '6.52', '0.00', '10 mg', 'Mizolastine'), 
('237', 'Ketron D   25 mg', '005-0659-64', 'Tablet', 'ACI Limited', '4.03', '0.00', '25 mg', 'Dexketoprofen'), 
('238', 'Reversair      5 mg', '005-0658-044', 'Tablet', 'ACI Limited', '8.05', '0.00', '5 mg', 'Montelukast'), 
('239', 'Reversair   4 mg', '005-0657-044', 'Tablet', 'ACI Limited', '7.05', '0.00', '4 mg', 'Montelukast'), 
('240', 'Artica   10 mg', '005-0656-21', 'Tablet', 'ACI Limited', '1.25', '0.00', '10 mg', 'Hydroxyzine Hydrochloride'), 
('241', 'Artica   25 mg', '005-0655-21', 'Tablet', 'ACI Limited', '2.01', '0.00', '25 mg', 'Hydroxyzine Hydrochloride'), 
('242', 'Dispazinc Dispersible   20 mg', '005-0648-62', 'Tablet', 'ACI Limited', '2.01', '0.00', '20 mg', 'Zinc'), 
('243', 'Acuten   30 mg', '005-0640-006', 'Tablet', 'ACI Limited', '3.02', '0.00', '30 mg', 'Nefopam Hydrochloride'), 
('244', 'Diatag F/C   15 mg', '005-0664', 'Tablet', 'ACI Limited', '8.05', '0.00', '15 mg', 'Pioglitazone'), 
('245', 'Pactorin Retard   2.6 mg', '005-0669', 'Tablet', 'ACI Limited', '4.03', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('246', 'Alaron   10 mg', '005-0671-21', 'Tablet', 'ACI Limited', '2.50', '0.00', '10 mg', 'Loratadine'), 
('247', 'Remaquin   15 mg', '005-0674-24', 'Tablet', 'ACI Limited', '1.51', '0.00', '15 mg', 'Primaquine'), 
('248', 'Citazar0   1000 mg', '005-0682-046', 'Tablet', 'ACI Limited', '0.00', '0.00', '1000 mg', 'Levetiracetam'), 
('249', 'Citazar0   750 mg', '005-0681-046', 'Tablet', 'ACI Limited', '0.00', '0.00', '750 mg', 'Levetiracetam'), 
('250', 'Citazar0   500 mg', '005-0680-046', 'Tablet', 'ACI Limited', '25.17', '0.00', '500 mg', 'Levetiracetam'), 
('251', 'Citazar   250 mg', '005-0679-046', 'Tablet', 'ACI Limited', '15.11', '0.00', '250 mg', 'Levetiracetam'), 
('252', 'Abetis   10 mg', '005-0678-22', 'Tablet', 'ACI Limited', '5.04', '0.00', '10 mg', 'Olmesartan Medoxomil'), 
('253', 'Odazyth   250 mg', '005-0690-23', 'Tablet', 'ACI Limited', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('254', 'Conart   1 mg', '005-06942', 'Tablet', 'ACI Limited', '5.02', '0.00', '1 mg', 'Bumetanide'), 
('255', 'Diaset   25 mg', '005-0703', 'Tablet', 'ACI Limited', '10.07', '0.00', '25 mg', 'Miglitol'), 
('256', 'Diaset   50 mg', '005-0704', 'Tablet', 'ACI Limited', '15.11', '0.00', '50 mg', 'Miglitol'), 
('257', 'Diaset   100 mg', '005-0705', 'Tablet', 'ACI Limited', '0.00', '0.00', '100 mg', 'Miglitol'), 
('258', 'Liorel   10 mg', '005-0706-70', 'Tablet', 'ACI Limited', '8.05', '0.00', '10 mg', 'Baclofen'), 
('259', 'Liorel   25 mg', '005-0707-70', 'Tablet', 'ACI Limited', '0.00', '0.00', '25 mg', 'Baclofen'), 
('260', 'Parixol   700 mcg', '005-0698-025', 'Tablet', 'ACI Limited', '0.00', '0.00', '700 mcg', 'Pramipexol'), 
('261', 'Parixol   180 mcg', '005-0699-025', 'Tablet', 'ACI Limited', '6.04', '0.00', '180 mcg', 'Pramipexol'), 
('262', 'Parixol   88 mcg', '005-0700-025', 'Tablet', 'ACI Limited', '3.01', '0.00', '88 mcg', 'Pramipexol'), 
('263', 'Liorel   5 mg', '005-0713-70', 'Tablet', 'ACI Limited', '4.53', '0.00', '5 mg', 'Baclofen'), 
('264', 'Remophos   667 mg', '005-0224-62', 'Tablet', 'ACI Limited', '6.02', '0.00', '667 mg', 'Calcium Acetate'), 
('265', 'Cartine   330 mg', '005-0718', 'Tablet', 'ACI Limited', '5.04', '0.00', '330 mg', 'Levocarnitine'), 
('266', 'Antial   4 mg', '005-0728-037', 'Tablet', 'ACI Limited', '12.09', '0.00', '4 mg', 'Galantamine'), 
('267', 'Antial   8 mg', '005-0729-037', 'Tablet', 'ACI Limited', '20.14', '0.00', '8 mg', 'Galantamine'), 
('268', 'Antial   12 mg', '005-0730-025', 'Tablet', 'ACI Limited', '30.20', '0.00', '12 mg', 'Galantamine'), 
('269', 'Chear   100 mg', '005-07314', 'Tablet', 'ACI Limited', '10.07', '0.00', '100 mg', 'Sertraline'), 
('270', 'Ritch   120 mg', '005-0732-21', 'Tablet', 'ACI Limited', '7.05', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('271', 'Ritch   180 mg', '005-0733-21', 'Tablet', 'ACI Limited', '9.06', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('272', 'Acitrin-L   5 mg', '005-0737-21', 'Tablet', 'ACI Limited', '3.01', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('273', 'Ritch   60 mg', '005-0744-21', 'Tablet', 'ACI Limited', '5.04', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('274', 'Sodival   200 mg', '005-07456', 'Tablet', 'ACI Limited', '2.52', '0.00', '200 mg', 'Sodium Valproate'), 
('275', 'Tyrodin   30 mg', '005-0739-62', 'Tablet', 'ACI Limited', '45.31', '0.00', '30 mg', 'Cinacalcet'), 
('276', 'Tyrodin   60 mg', '005-0740-62', 'Tablet', 'ACI Limited', '0.00', '0.00', '60 mg', 'Cinacalcet'), 
('277', 'Tyrodin   90 mg', '005-0741-62', 'Tablet', 'ACI Limited', '0.00', '0.00', '90 mg', 'Cinacalcet'), 
('278', 'Xytrex   5 mg', '005-0742-28', 'Tablet', 'ACI Limited', '2.52', '0.00', '5 mg', 'Olanzapine'), 
('279', 'Inclaud   100 mg', '005-0755-36', 'Tablet', 'ACI Limited', '10.00', '0.00', '100 mg', 'Cilostazol'), 
('280', 'Nutrivit C   500 mg', '005-0758-78', 'Tablet', 'ACI Limited', '9.03', '0.00', '500 mg', 'Vitamin C'), 
('281', 'Nutrivit C   1 gm', '005-0759-78', 'Tablet', 'ACI Limited', '12.04', '0.00', '1 gm', 'Vitamin C'), 
('282', 'Parotin   20 mg', '005-07614', 'Tablet', 'ACI Limited', '10.07', '0.00', '20 mg', 'Paroxetine'), 
('283', 'Parotin   10 mg', '005-07604', 'Tablet', 'ACI Limited', '6.04', '0.00', '10 mg', 'Paroxetine'), 
('284', 'Atasin   40 mg', '005-0764-061', 'Tablet', 'ACI Limited', '24.16', '0.00', '40 mg', 'Atorvastatin'), 
('285', 'Lamitrin   25 mg', '005-0767-046', 'Tablet', 'ACI Limited', '10.03', '0.00', '25 mg', 'Lamotrigine'), 
('286', 'Angilat   25 mg', '005-0778-22', 'Tablet', 'ACI Limited', '1.00', '0.00', '25 mg', 'Metoprolol Tartrate'), 
('287', 'Angilat   50 mg', '005-0777-22', 'Tablet', 'ACI Limited', '1.50', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('288', 'Avintol   5 mg', '005-0780-36', 'Tablet', 'ACI Limited', '3.00', '0.00', '5 mg', 'Vinpocetine'), 
('289', 'Abixa   10 mg', '005-0779-037', 'Tablet', 'ACI Limited', '8.00', '0.00', '10 mg', 'Memantine Hydrochloride'), 
('290', 'Canazole   200 mg', '005-0792', 'Tablet', 'ACI Limited', '25.08', '0.00', '200 mg', 'Fluconazole'), 
('291', 'Xiety   .25 mg', '005-07937', 'Tablet', 'ACI Limited', '0.00', '0.00', '.25 mg', 'Alprazolam'), 
('292', 'Xiety   .5 mg', '005-07947', 'Tablet', 'ACI Limited', '0.00', '0.00', '.5 mg', 'Alprazolam'), 
('293', 'Dormilat   15 mg', '005-0802-057', 'Tablet', 'ACI Limited', '15.05', '0.00', '15 mg', 'Midazolam'), 
('294', 'Dormilat   7.5 mg', '005-0801-057', 'Tablet', 'ACI Limited', '8.02', '0.00', '7.5 mg', 'Midazolam'), 
('295', 'Febus   40 mg', '005-0809-76', 'Tablet', 'ACI Limited', '12.04', '0.00', '40 mg', 'Febuxostat'), 
('296', 'Febus   80 mg', '005-0810-76', 'Tablet', 'ACI Limited', '22.07', '0.00', '80 mg', 'Febuxostat'), 
('297', 'Abaclor 375 ER   375 mg', '005-0811-23', 'Tablet', 'ACI Limited', '30.09', '0.00', '375 mg', 'Cefaclor'), 
('298', 'Ritch Orodispersible   30 mg', '005-0812-21', 'Tablet', 'ACI Limited', '3.00', '0.00', '30 mg', 'Fexofenadine Hydrochloride'), 
('299', 'Glimirid   3 mg', '005-0817', 'Tablet', 'ACI Limited', '10.03', '0.00', '3 mg', 'Glimepiride'), 
('300', 'Glimirid   4 mg', '005-0828', 'Tablet', 'ACI Limited', '12.04', '0.00', '4 mg', 'Glimepiride'), 
('301', 'Tizabate   160 mg', '005-0819-61', 'Tablet', 'ACI Limited', '0.00', '0.00', '160 mg', 'Fenofibrate'), 
('302', 'Doxamil   25 mg', '005-0821-021', 'Tablet', 'ACI Limited', '2.01', '0.00', '25 mg', 'Doxylamine Succinate'), 
('303', 'Hemagrel   5 mg', '005-0822-26', 'Tablet', 'ACI Limited', '12.04', '0.00', '5 mg', 'Prasugrel'), 
('304', 'Hemagrel   10 mg', '005-0823-26', 'Tablet', 'ACI Limited', '20.06', '0.00', '10 mg', 'Prasugrel'), 
('305', 'Cefzil   250 mg', '005-0827-23', 'Tablet', 'ACI Limited', '0.00', '0.00', '250 mg', 'Cefprozil'), 
('306', 'Cefzil0   500 mg', '005-0828-23', 'Tablet', 'ACI Limited', '0.00', '0.00', '500 mg', 'Cefprozil'), 
('307', 'Compazine   5 mg', '005-08308', 'Tablet', 'ACI Limited', '0.00', '0.00', '5 mg', 'Prochlorperazine Maleate'), 
('308', 'Ritopar   10 mg', '005-08359', 'Tablet', 'ACI Limited', '8.00', '0.00', '10 mg', 'Ritodrine Hydrochloride'), 
('309', 'Atasin   80 mg', '005-0862-61', 'Tablet', 'ACI Limited', '40.12', '0.00', '80 mg', 'Atorvastatin'), 
('310', 'Anaxyl0   500 mg', '005-08689', 'Tablet', 'ACI Limited', '20.06', '0.00', '500 mg', 'Tranexamic Acid'), 
('311', 'Foviral   300 mg', '005-0870-32', 'Tablet', 'ACI Limited', '85.26', '0.00', '300 mg', 'Tenofovir Disoproxil Fumarate'), 
('312', 'Diamicron MR   60 mg', '005-0880', 'Tablet', 'ACI Limited', '18.05', '0.00', '60 mg', 'Gliclazide'), 
('313', 'Teolex SR  400 mg', '005-08834', 'Tablet', 'ACI Limited', '2.68', '0.00', '400 mg', 'Theophylline'), 
('314', 'Teolex SR   300 mg', '005-08844', 'Tablet', 'ACI Limited', '2.01', '0.00', '300 mg', 'Theophylline'), 
('315', 'Sodival CR   300 mg', '005-08986', 'Tablet', 'ACI Limited', '6.00', '0.00', '300 mg', 'Sodium Valproate'), 
('316', 'Sodival CR   500 mg', '005-08996', 'Tablet', 'ACI Limited', '10.00', '0.00', '500 mg', 'Sodium Valproate'), 
('317', 'Clonium   1 mg', '005-09006', 'Tablet', 'ACI Limited', '5.02', '0.00', '1 mg', 'Clonazepam'), 
('318', 'Amidron   100 mg', '005-0904-9', 'Tablet', 'ACI Limited', '5.00', '0.00', '100 mg', 'Amiodarone Hydrochloride'), 
('319', 'Amidron   200 mg', '005-0905-9', 'Tablet', 'ACI Limited', '10.00', '0.00', '200 mg', 'Amiodarone Hydrochloride'), 
('320', 'Movera   5 mg', '005-0908-39', 'Tablet', 'ACI Limited', '5.40', '0.00', '5 mg', 'Medroxyprogesterone Acetate'), 
('321', 'Movera   10 mg', '005-0909-039', 'Tablet', 'ACI Limited', '10.03', '0.00', '10 mg', 'Medroxyprogesterone Acetate'), 
('322', 'Menogia   5 mg', '005-0910-39', 'Tablet', 'ACI Limited', '5.00', '0.00', '5 mg', 'Norethisterone'), 
('323', 'e-Plan   750 mcg', '005-0912-039', 'Tablet', 'ACI Limited', '22.89', '0.00', '750 mcg', 'Levo Norgestrel'), 
('324', 'Tivion   2.5 mg', '005-09136', 'Tablet', 'ACI Limited', '20.00', '0.00', '2.5 mg', 'Tibolone'), 
('325', 'Throid   50 mcg', '005-0914-74', 'Tablet', 'ACI Limited', '1.35', '0.00', '50 mcg', 'Levothyroxine Sodium'), 
('326', 'Prelab   5 mg', '005-09159', 'Tablet', 'ACI Limited', '8.00', '0.00', '5 mg', 'Allystrenol'), 
('327', 'Litiam ER   400 mg', '005-0925-28', 'Tablet', 'ACI Limited', '5.02', '0.00', '400 mg', 'Lithium Carbonate'), 
('328', 'Rosetor   40 mg', '005-0932-61', 'Tablet', 'ACI Limited', '0.00', '0.00', '40 mg', 'Rosuvastatin'), 
('329', 'Adegra   25 mg', '005-0944-043', 'Tablet', 'ACI Limited', '20.06', '0.00', '25 mg', 'Sildenafil'), 
('330', 'Adegra   50 mg', '005-0945-043', 'Tablet', 'ACI Limited', '30.09', '0.00', '50 mg', 'Sildenafil'), 
('331', 'Adegra   100 mg', '005-0946-043', 'Tablet', 'ACI Limited', '50.15', '0.00', '100 mg', 'Sildenafil'), 
('332', 'Rosetor   20 mg', '005-0938-61', 'Tablet', 'ACI Limited', '0.00', '0.00', '20 mg', 'Rosuvastatin'), 
('333', 'Rosetor   10 mg', '005-0939-61', 'Tablet', 'ACI Limited', '18.05', '0.00', '10 mg', 'Rosuvastatin'), 
('334', 'Rosetor   5 mg', '005-0940-61', 'Tablet', 'ACI Limited', '10.03', '0.00', '5 mg', 'Rosuvastatin'), 
('335', 'Qmax   100 mg', '005-0941-28', 'Tablet', 'ACI Limited', '10.03', '0.00', '100 mg', 'Quetiapine'), 
('336', 'Qmax   25 mg', '005-0942-28', 'Tablet', 'ACI Limited', '3.01', '0.00', '25 mg', 'Quetiapine'), 
('337', 'Namitol   200 mg', '005-09547', 'Tablet', 'ACI Limited', '8.02', '0.00', '200 mg', 'Tolfenamic Acid'), 
('338', 'Probis   2.5 mg', '005-0955-22', 'Tablet', 'ACI Limited', '6.02', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('339', 'Ciaton   5 mg', '005-0959-043', 'Tablet', 'ACI Limited', '18.05', '0.00', '5 mg', 'Tadalafil'), 
('340', 'Ciaton   10 mg', '005-0960-043', 'Tablet', 'ACI Limited', '35.11', '0.00', '10 mg', 'Tadalafil'), 
('341', 'Ciaton   20 mg', '005-0961-043', 'Tablet', 'ACI Limited', '60.18', '0.00', '20 mg', 'Tadalafil'), 
('342', 'Teolex SR Tablet   200 mg', '005-09624', 'Tablet', 'ACI Limited', '1.50', '0.00', '200 mg', 'Theophylline'), 
('343', 'Avlocid M   400 mg', '005-0864-7', 'Tablet', 'ACI Limited', '0.00', '0.00', '400 mg', 'Magaldrate'), 
('344', 'Rapine F/C   15 mg', '005-09674', 'Tablet', 'ACI Limited', '8.00', '0.00', '15 mg', 'Mirtazapine'), 
('345', 'Rapine F/C   30 mg', '005-09684', 'Tablet', 'ACI Limited', '15.00', '0.00', '30 mg', 'Mirtazapine'), 
('346', 'Cefim   200 mg', '005-0970-23', 'Tablet', 'ACI Limited', '30.09', '0.00', '200 mg', 'Cefixime'), 
('347', 'Cefim-3 DS   400 mg', '005-0971-23', 'Tablet', 'ACI Limited', '50.15', '0.00', '400 mg', 'Cefixime'), 
('348', 'Acical Jr. Chewable Tablet   625 mg', '005-0972-62', 'Tablet', 'ACI Limited', '3.01', '0.00', '625 mg', 'Calcium Carbonate'), 
('349', 'Adegra   20 mg', '005-0980-043', 'Tablet', 'ACI Limited', '0.00', '0.00', '20 mg', 'Sildenafil'), 
('350', 'Diamicron MR   30 mg', '593-0466', 'Tablet', 'ACI Limited', '11.53', '0.00', '30 mg', 'Gliclazide'), 
('351', 'Somfen   5 mg', '593-09891', 'Tablet', 'ACI Limited', '0.00', '0.00', '5 mg', 'Solifenacin Succinate'), 
('352', 'Somfen   10 mg', '593-09901', 'Tablet', 'ACI Limited', '0.00', '0.00', '10 mg', 'Solifenacin Succinate'), 
('353', 'e-Plan Max   1.5 mg', '593-0993-039', 'Tablet', 'ACI Limited', '70.00', '0.00', '1.5 mg', 'Levo Norgestrel'), 
('354', 'Sitap   100 mg', '593-0995', 'Tablet', 'ACI Limited', '28.08', '0.00', '100 mg', 'Sitagliptin'), 
('355', 'Sitap   50 mg', '593-0994', 'Tablet', 'ACI Limited', '15.05', '0.00', '50 mg', 'Sitagliptin'), 
('356', 'Paricel   10 mg', '59305-67', 'Tablet', 'ACI Limited', '3.51', '0.00', '10 mg', 'Rabeprazole Sodium'), 
('357', 'Solone   10 mg', '59308-72', 'Tablet', 'ACI Limited', '2.07', '0.00', '10 mg', 'Prednisolone'), 
('358', 'Arinia   5 mg', '59309-28', 'Tablet', 'ACI Limited', '0.00', '0.00', '5 mg', 'Aripiprazole'), 
('359', 'Arinia   10 mg', '59310-28', 'Tablet', 'ACI Limited', '0.00', '0.00', '10 mg', 'Aripiprazole'), 
('360', 'Arinia   15 mg', '59311-28', 'Tablet', 'ACI Limited', '0.00', '0.00', '15 mg', 'Aripiprazole'), 
('361', 'Carbox   300 mg', '59312-046', 'Tablet', 'ACI Limited', '0.00', '0.00', '300 mg', 'Oxcarbazepine'), 
('362', 'Citalam   5 mg', '593144', 'Tablet', 'ACI Limited', '7.00', '0.00', '5 mg', 'Escitalopram'), 
('363', 'Citalam   10 mg', '593134', 'Tablet', 'ACI Limited', '12.00', '0.00', '10 mg', 'Escitalopram'), 
('364', 'Moxiflox   400 mg', '59318-23', 'Tablet', 'ACI Limited', '0.00', '0.00', '400 mg', 'Moxifloxacin'), 
('365', 'Risomax   1 mg', '59319-28', 'Tablet', 'ACI Limited', '3.00', '0.00', '1 mg', 'Risperidone'), 
('366', 'Risomax   2 mg', '59320-28', 'Tablet', 'ACI Limited', '5.00', '0.00', '2 mg', 'Risperidone'), 
('367', 'Risomax   4 mg', '59321-28', 'Tablet', 'ACI Limited', '9.00', '0.00', '4 mg', 'Risperidone'), 
('368', 'Carbox   150 mg', '59324-046', 'Tablet', 'ACI Limited', '0.00', '0.00', '150 mg', 'Oxcarbazepine'), 
('369', 'Rotacal   400 mg', '59325-62', 'Tablet', 'ACI Limited', '8.00', '0.00', '400 mg', 'Calcium Orotate'), 
('370', 'Lopenta   50 mg', '59328-065', 'Tablet', 'ACI Limited', '14.00', '0.00', '50 mg', 'Tapentadol'), 
('371', 'Lopenta   75 mg', '59329-065', 'Tablet', 'ACI Limited', '20.00', '0.00', '75 mg', 'Tapentadol'), 
('372', 'Tricalm   2 mg', '538', 'Tablet', 'ACI Limited', '5.00', '0.00', '2 mg', 'Trihexyphenidyl Hydrochloride'), 
('373', 'Acora   90 mg', '00548-26', 'Tablet', 'ACI Limited', '75.00', '0.00', '90 mg', 'Ticagrelor'), 
('374', 'Glitin   5 mg', '00547-015', 'Tablet', 'ACI Limited', '15.00', '0.00', '5 mg', 'Linagliptin'), 
('375', 'Rapine   7.5 mg', '5464', 'Tablet', 'ACI Limited', '6.00', '0.00', '7.5 mg', 'Mirtazapine'), 
('376', 'Defzort   6 mg', '00549-72', 'Tablet', 'ACI Limited', '8.00', '0.00', '6 mg', 'Deflazacort'), 
('377', 'Doximar   400 mg', '5504', 'Tablet', 'ACI Limited', '8.00', '0.00', '400 mg', 'Doxophylline'), 
('378', 'Bilicir   150 mg', '551', 'Tablet', 'ACI Limited', '11.00', '0.00', '150 mg', 'Ursodeoxycholic Acid'), 
('379', 'Bilicir   300 mg', '552', 'Tablet', 'ACI Limited', '20.00', '0.00', '300 mg', 'Ursodeoxycholic Acid'), 
('380', 'Henlix   200 mg', '00554-23', 'Tablet', 'ACI Limited', '25.00', '0.00', '200 mg', 'Rifaximin'), 
('381', 'Henlix   550 mg', '005-0105-23', 'Tablet', 'ACI Limited', '45.00', '0.00', '550 mg', 'Rifaximin'), 
('382', 'Adair   500 mcg', '5604', 'Tablet', 'ACI Limited', '15.00', '0.00', '500 mcg', 'Roflumilast'), 
('383', 'Loxetine   20 mg', '5614', 'Tablet', 'ACI Limited', '7.00', '0.00', '20 mg', 'Duloxetine'), 
('384', 'Loxetine   30 mg', '5624', 'Tablet', 'ACI Limited', '10.00', '0.00', '30 mg', 'Duloxetine'), 
('385', 'Largix   10 mg', '00566-21', 'Tablet', 'ACI Limited', '10.00', '0.00', '10 mg', 'Rupatadine'), 
('386', 'Ceftoren   200 mg', '00567-23', 'Tablet', 'ACI Limited', '150.00', '0.00', '200 mg', 'Cefditoren'), 
('387', 'Ebasten   10 mg', '00572-21', 'Tablet', 'ACI Limited', '6.00', '0.00', '10 mg', 'Ebastine'), 
('388', 'Daxetin   30 mg', '00573-014', 'Tablet', 'ACI Limited', '30.00', '0.00', '30 mg', 'Dapoxetine'), 
('389', 'Daxetin   60 mg', '00574-014', 'Tablet', 'ACI Limited', '50.00', '0.00', '60 mg', 'Dapoxetine'), 
('390', 'Tricalm   5 mg', '576', 'Tablet', 'ACI Limited', '10.00', '0.00', '5 mg', 'Trihexyphenidyl Hydrochloride'), 
('391', 'Sofomax   400 mg', '00585-32', 'Tablet', 'ACI Limited', '700.00', '0.00', '400 mg', 'Sofosbuvir'), 
('392', 'Rotacal Max   740 mg', '00586-62', 'Tablet', 'ACI Limited', '12.00', '0.00', '740 mg', 'Calcium Orotate'), 
('393', 'Anaglin   100 mg', '590', 'Tablet', 'ACI Limited', '0.00', '0.00', '100 mg', 'Canagliflozin'), 
('394', 'Doximar   200 mg', '5894', 'Tablet', 'ACI Limited', '6.00', '0.00', '200 mg', 'Doxophylline'), 
('395', 'Kofnix SR   50 mg', '005-0843-31', 'Tablet', 'ACI Limited', '0.00', '0.00', '50 mg', 'Butamirate Citrate'), 
('396', 'Aptin   50 mg', '593', 'Tablet', 'ACI Limited', '20.00', '0.00', '50 mg', 'Vildagliptin'), 
('397', 'Armoda   150 mg', '00598-01', 'Tablet', 'ACI Limited', '15.00', '0.00', '150 mg', 'Armodafinil'), 
('398', 'Armoda   250 mg', '00599-01', 'Tablet', 'ACI Limited', '25.00', '0.00', '250 mg', 'Armodafinil'), 
('399', 'Glycema   5 mg', '5101', 'Tablet', 'ACI Limited', '16.00', '0.00', '5 mg', 'Dapagliflozin'), 
('400', 'Arbitel   40 mg', '005107-022', 'Tablet', 'ACI Limited', '12.00', '0.00', '40 mg', 'Telmisartan'), 
('401', 'Arbitel   80 mg', '005108-022', 'Tablet', 'ACI Limited', '20.00', '0.00', '80 mg', 'Telmisartan'), 
('402', 'Rivaban   10 mg', '51092', 'Tablet', 'ACI Limited', '25.00', '0.00', '10 mg', 'Rivaroxaban'), 
('403', 'Rivaban   20 mg', '51102', 'Tablet', 'ACI Limited', '45.00', '0.00', '20 mg', 'Rivaroxaban'), 
('404', 'Arbitel   20 mg', '005128-022', 'Tablet', 'ACI Limited', '7.00', '0.00', '20 mg', 'Telmisartan'), 
('405', 'Glycema   10 mg', '5129', 'Tablet', 'ACI Limited', '30.00', '0.00', '10 mg', 'Dapagliflozin'), 
('406', 'Glupain   500 mg', '005-0362-064', 'Tablet', 'ACI Limited', '3.02', '0.00', '500 mg', 'Glucosamine'), 
('407', 'Defzort4   24 mg', '005145-072', 'Tablet', 'ACI Limited', '30.00', '0.00', '24 mg', 'Deflazacort'), 
('408', 'Corzil   40 mg', '005146-022', 'Tablet', 'ACI Limited', '0.00', '0.00', '40 mg', 'Azilsartan Medoxomil'), 
('409', 'Acitamol (Vet)   2 gm', '005-0949-077', 'Bolus', 'ACI Limited', '2.25', '0.00', '2 gm', 'Paracetamol'), 
('410', 'Prozin Vet   150 mg', '59300-077', 'Bolus', 'ACI Limited', '3.32', '0.00', '150 mg', 'Promethazine Hydrochloride'), 
('411', 'Acimetro-Vet   2 gm', '59301-077', 'Bolus', 'ACI Limited', '4.47', '0.00', '2 gm', 'Metronidazole'), 
('412', 'K-Pain Vet   400 mg', '59333-077', 'Bolus', 'ACI Limited', '10.00', '0.00', '400 mg', 'Ketoprofen'), 
('413', 'M-Pain Vet   100 mg', '59334-077', 'Bolus', 'ACI Limited', '6.01', '0.00', '100 mg', 'Meloxicam'), 
('414', 'Acivet Cipro   1 gm', '005114-077', 'Bolus', 'ACI Limited', '19.80', '0.00', '1 gm', 'Ciprofloxacin'), 
('415', 'Acinex (Vet)   900 mg', '005-0393-077', 'Bolus', 'ACI Limited', '0.00', '0.00', '900 mg', 'Triclabendazole'), 
('416', 'Aciphin  IM   1 gm', '005-0211-23', 'IM Injection', 'ACI Limited', '191.29', '0.00', '1 gm', 'Ceftriaxone'), 
('417', 'Aciphin  IM   500 mg', '005-0215-23', 'IM Injection', 'ACI Limited', '130.39', '0.00', '500 mg', 'Ceftriaxone'), 
('418', 'Aciphin  IM   250 mg', '005-0209-23', 'IM Injection', 'ACI Limited', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('419', 'Aciphin  IV   500 mg', '005-0210-23', 'IV Injection', 'ACI Limited', '130.39', '0.00', '500 mg', 'Ceftriaxone'), 
('420', 'Aciphin  IV   250 mg', '005-0214-23', 'IV Injection', 'ACI Limited', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('421', 'Aciphin  IV   1 gm', '005-0216-23', 'IV Injection', 'ACI Limited', '191.29', '0.00', '1 gm', 'Ceftriaxone'), 
('422', 'Aciphin  IV   2 gm', '005-0556-23', 'IV Injection', 'ACI Limited', '302.04', '0.00', '2 gm', 'Ceftriaxone'), 
('423', 'Repotyn   5 %', '005-0719-3', 'IV Infusion', 'ACI Limited', '352.38', '0.00', '5 %', 'Amino Acids (Essential)'), 
('424', 'Congesta   .025 %', '005-09292', 'Nasal Drops', 'ACI Limited', '0.00', '0.00', '.025 %', 'Oxymetazoline Hydrochloride'), 
('425', 'Congesta   .05 %', '005-09302', 'Nasal Drops', 'ACI Limited', '0.00', '0.00', '.05 %', 'Oxymetazoline Hydrochloride'), 
('426', 'Ambroxol HCl   Pellets   30 %', '005-0545-034', 'Pellets', 'ACI Limited', '0.00', '0.00', '30 %', 'Ambroxol Hydrochloride'), 
('427', 'Odazyth SR   2 gm', '005-0979-23', 'Powder For Suspension', 'ACI Limited', '250.75', '0.00', '2 gm', 'Azithromycin'), 
('428', 'Diclofenac Sodium   100 %', '005-0544-034', 'Raw Materials', 'ACI Limited', '0.00', '0.00', '100 %', 'Diclofenac Sodium'), 
('429', 'Ferrous Sulphate + Folic Acid   Pellets   62 %', '005-0441-034', 'Raw Materials', 'ACI Limited', '0.00', '0.00', '62 %', 'Ferrous Sulphate'), 
('430', 'Dermasim  VT   500 mg', '005-0290', 'Vaginal Tablet', 'ACI Limited', '60.41', '0.00', '500 mg', 'Clotrimazole'), 
('431', 'Ecoren  VT    150 mg', '005-0402', 'Vaginal Tablet', 'ACI Limited', '24.16', '0.00', '150 mg', 'Econazole Nitrate'), 
('432', 'Dermasim  VT    200 mg', '005-0628', 'Vaginal Tablet', 'ACI Limited', '20.14', '0.00', '200 mg', 'Clotrimazole'), 
('433', 'Prosma   .025 %', '005-04362', 'Eye Drops', 'ACI Limited', '95.65', '0.00', '.025 %', 'Ketotifen'), 
('434', 'Lotensin   .25 %', '005-05012', 'Eye Drops', 'ACI Limited', '0.00', '0.00', '.25 %', 'Timolol Maleate'), 
('435', 'Atier   .3 %', '005-05952', 'Eye Drops', 'ACI Limited', '65.45', '0.00', '.3 %', 'Hypromellose'), 
('436', 'Vave   10 mg', '005-07728', 'Dispersible Tablet', 'ACI Limited', '5.02', '0.00', '10 mg', 'Domperidone'), 
('437', 'Sintel DT   400 mg', '593-0983-008', 'Dispersible Tablet', 'ACI Limited', '6.02', '0.00', '400 mg', 'Albendazole'), 
('438', 'Steradin HFA   100 mcg', '005-07124', 'Inhalation Solution', 'ACI Limited', '271.84', '0.00', '100 mcg', 'Beclomethasone Dipropionate'), 
('439', 'Brodil Acucap   200 mcg', '005-08914', 'Inhalation Capsule', 'ACI Limited', '2.51', '0.00', '200 mcg', 'Salbutamol'), 
('440', 'Melonex20 Acucap   220 mcg', '005-08954', 'Inhalation Capsule', 'ACI Limited', '0.00', '0.00', '220 mcg', 'Mometasone Furoate'), 
('441', 'Melonex10 Acucap   110 mcg', '005-08964', 'Inhalation Capsule', 'ACI Limited', '0.00', '0.00', '110 mcg', 'Mometasone Furoate'), 
('442', 'Tendia ER   100 mg', '005-0695-65', 'Sr Capsule', 'ACI Limited', '14.09', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('443', 'Milk Aid   300 mg', '51061', 'Chewable Tablet', 'ACI Limited', '15.00', '0.00', '300 mg', 'Lactase'), 
('444', 'Metform  ER   1 gm', '005-0574', 'Xr Tablet', 'ACI Limited', '7.05', '0.00', '1 gm', 'Metformin Hydrochloride'), 
('445', 'Metform0   500 mg', '005-0789', 'Xr Tablet', 'ACI Limited', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('446', 'Palimax ER   6 mg', '00596-28', 'Er Tablet', 'ACI Limited', '10.00', '0.00', '6 mg', 'Paliperidone'), 
('447', 'Palimax ER   1.5 mg', '005118-28', 'Er Tablet', 'ACI Limited', '4.00', '0.00', '1.5 mg', 'Paliperidone'), 
('448', 'Palimax ER   3 mg', '005119-28', 'Er Tablet', 'ACI Limited', '7.00', '0.00', '3 mg', 'Paliperidone'), 
('449', 'Miragon PR   25 mg', '005117-01', 'Er Tablet', 'ACI Limited', '30.00', '0.00', '25 mg', 'Mirabegron'), 
('450', 'Xcel ODT   500 mg', '005-0797-006', 'Orodispersible Tablet', 'ACI Limited', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('451', 'Acitrin   10 mg', '005-0807-21', 'Orodispersible Tablet', 'ACI Limited', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('452', 'Osetron ODT   4 mg', '005-08858', 'Orodispersible Tablet', 'ACI Limited', '0.00', '0.00', '4 mg', 'Ondansetron'), 
('453', 'Floxabid  SR   1 gm', '005-0566-23', 'Sr Tablet', 'ACI Limited', '20.13', '0.00', '1 gm', 'Ciprofloxacin'), 
('454', 'Xeldrin      20 mg', '005-0489', 'Sr Tablet', 'ACI Limited', '4.03', '0.00', '20 mg', 'Omeprazole'), 
('455', 'A Clox   500 mg', '036-0086-23', 'Capsule', 'Acme Laboratories Ltd.', '5.98', '0.00', '500 mg', 'Cloxacillin'), 
('456', 'A Flox   250 mg', '036-0194-23', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('457', 'A Flox   500 mg', '036-0193-23', 'Capsule', 'Acme Laboratories Ltd.', '10.58', '0.00', '500 mg', 'Flucloxacillin'), 
('458', 'A Rifam      150 mg', '036-0180-30', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '150 mg', 'Rifampicin'), 
('459', 'A Rifam   450 mg', '036-0181-30', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '450 mg', 'Rifampicin'), 
('460', 'A Tetra   500 mg', '036-0236-23', 'Capsule', 'Acme Laboratories Ltd.', '3.39', '0.00', '500 mg', 'Tetracycline Hydrochloride'), 
('461', 'Acelex   250 mg', '036-0113-23', 'Capsule', 'Acme Laboratories Ltd.', '6.65', '0.00', '250 mg', 'Cephalexin'), 
('462', 'Acelex   500 mg', '036-0150-23', 'Capsule', 'Acme Laboratories Ltd.', '12.58', '0.00', '500 mg', 'Cephalexin'), 
('463', 'Acmecilin   250 mg', '036-0029-23', 'Capsule', 'Acme Laboratories Ltd.', '3.34', '0.00', '250 mg', 'Ampicillin'), 
('464', 'Cib      100 mg', '036-0273-064', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Celecoxib'), 
('465', 'Cib      200 mg', '036-0274-064', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Celecoxib'), 
('466', 'Doxy A     100 mg', '036-0115-23', 'Capsule', 'Acme Laboratories Ltd.', '2.20', '0.00', '100 mg', 'Doxycycline'), 
('467', 'Fix A     200 mg', '036-0268-23', 'Capsule', 'Acme Laboratories Ltd.', '30.20', '0.00', '200 mg', 'Cefixime'), 
('468', 'Lansodin   15 mg', '036-0281-67', 'Capsule', 'Acme Laboratories Ltd.', '3.52', '0.00', '15 mg', 'Lansoprazole'), 
('469', 'Lansodin   30 mg', '036-0282-67', 'Capsule', 'Acme Laboratories Ltd.', '6.04', '0.00', '30 mg', 'Lansoprazole'), 
('470', 'Lipidof      200 mg', '036-0372-61', 'Capsule', 'Acme Laboratories Ltd.', '7.04', '0.00', '200 mg', 'Fenofibrate'), 
('471', 'Lopamid   2 mg', '036-00856', 'Capsule', 'Acme Laboratories Ltd.', '1.00', '0.00', '2 mg', 'Loperamide'), 
('472', 'Moxilin   250 mg', '036-0030-023', 'Capsule', 'Acme Laboratories Ltd.', '3.62', '0.00', '250 mg', 'Amoxicillin'), 
('473', 'Moxilin   500 mg', '036-0245-23', 'Capsule', 'Acme Laboratories Ltd.', '6.77', '0.00', '500 mg', 'Amoxicillin'), 
('474', 'Oxecylin   250 mg', '036-0028-23', 'Capsule', 'Acme Laboratories Ltd.', '2.00', '0.00', '250 mg', 'Oxytetracycline'), 
('475', 'PPI      20 mg', '036-0141-67', 'Capsule', 'Acme Laboratories Ltd.', '5.01', '0.00', '20 mg', 'Omeprazole'), 
('476', 'Ppi      40 mg', '036-0242-67', 'Capsule', 'Acme Laboratories Ltd.', '8.03', '0.00', '40 mg', 'Omeprazole'), 
('477', 'Sefril   250 mg', '036-0097-023', 'Capsule', 'Acme Laboratories Ltd.', '8.03', '0.00', '250 mg', 'Cephradine'), 
('478', 'Sefril   500 mg', '036-0111-23', 'Capsule', 'Acme Laboratories Ltd.', '15.04', '0.00', '500 mg', 'Cephradine'), 
('479', 'Thenglate  TR   300 mg', '036-02354', 'Capsule', 'Acme Laboratories Ltd.', '2.94', '0.00', '300 mg', 'Theophylline'), 
('480', 'Twicef   500 mg', '036-0374-23', 'Capsule', 'Acme Laboratories Ltd.', '12.09', '0.00', '500 mg', 'Cefadroxil'), 
('481', 'Venaxin  SR    75 mg', '036-03944', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '75 mg', 'Venlafaxine'), 
('482', 'Azin   250 mg', '036-0164-23', 'Capsule', 'Acme Laboratories Ltd.', '25.08', '0.00', '250 mg', 'Azithromycin'), 
('483', 'Adinir0   300 mg', '036-0432-23', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '300 mg', 'Cefdinir'), 
('484', 'Maxima      20 mg', '036-0439-067', 'Capsule', 'Acme Laboratories Ltd.', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('485', 'Maxima      40 mg', '036-0440-067', 'Capsule', 'Acme Laboratories Ltd.', '9.03', '0.00', '40 mg', 'Esomeprazole'), 
('486', 'Fluconal      150 mg', '036-0441', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '150 mg', 'Fluconazole'), 
('487', 'Cecon  WSP   500 mg', '036-0309-78', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Vitamin C'), 
('488', 'Dolonil      50 mg', '036-0524-65', 'Capsule', 'Acme Laboratories Ltd.', '7.55', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('489', 'A Tetra   250 mg', '036-0528-23', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('490', 'Fix-A DS    400 mg', '036-0544-23', 'Capsule', 'Acme Laboratories Ltd.', '50.35', '0.00', '400 mg', 'Cefixime'), 
('491', 'Uropass   400 mcg', '036-05839', 'Capsule', 'Acme Laboratories Ltd.', '10.07', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('492', 'Alclor0   500 mg', '036-0635-23', 'Capsule', 'Acme Laboratories Ltd.', '40.12', '0.00', '500 mg', 'Cefaclor'), 
('493', 'Lincocin   300 mg', '036-0680-23', 'Capsule', 'Acme Laboratories Ltd.', '15.04', '0.00', '300 mg', 'Clindamycin'), 
('494', 'Lincocin   150 mg', '036-0679-23', 'Capsule', 'Acme Laboratories Ltd.', '8.03', '0.00', '150 mg', 'Clindamycin'), 
('495', 'Neugalin   50 mg', '036-0714-046', 'Capsule', 'Acme Laboratories Ltd.', '11.03', '0.00', '50 mg', 'Pregabalin'), 
('496', 'Neugalin   75 mg', '036-0715-046', 'Capsule', 'Acme Laboratories Ltd.', '16.04', '0.00', '75 mg', 'Pregabalin'), 
('497', 'Neugalin   150 mg', '036-0716-046', 'Capsule', 'Acme Laboratories Ltd.', '30.10', '0.00', '150 mg', 'Pregabalin'), 
('498', 'Indo-A   25 mg', '036-0727-64', 'Capsule', 'Acme Laboratories Ltd.', '1.00', '0.00', '25 mg', 'Indomethacin'), 
('499', 'Lifil-E   200 mg', '036-0794-78', 'Capsule', 'Acme Laboratories Ltd.', '4.01', '0.00', '200 mg', 'Vitamin E'), 
('500', 'Lifil-E0   400 mg', '036-0795-78', 'Capsule', 'Acme Laboratories Ltd.', '6.01', '0.00', '400 mg', 'Vitamin E'), 
('501', 'Indo-A SR   75 mg', '036-0863-64', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '75 mg', 'Indomethacin'), 
('502', 'Caltril   .25 mcg', '036-0884-78', 'Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '.25 mcg', 'Calcitriol'), 
('503', 'Codfil   300 mg', '036-0885', 'Capsule', 'Acme Laboratories Ltd.', '2.00', '0.00', '300 mg', 'Cod Liver Oil'), 
('504', 'Logibac0   400 mg', '036-0917-23', 'Capsule', 'Acme Laboratories Ltd.', '120.00', '0.00', '400 mg', 'Ceftibuten'), 
('505', 'Neugalin   25 mg', '036-0931-046', 'Capsule', 'Acme Laboratories Ltd.', '8.00', '0.00', '25 mg', 'Pregabalin'), 
('506', 'Burncare   1 %', '036-0757-23', 'Cream', 'Acme Laboratories Ltd.', '0.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('507', 'Oratics Oral Gel   200 mg', '036-0717-73', 'Gel', 'Acme Laboratories Ltd.', '40.12', '0.00', '200 mg', 'Benzocaine'), 
('508', 'Acme\'S Water For Injection   5 ml', '036-0130-79', 'Injection', 'Acme Laboratories Ltd.', '6.01', '0.00', '5 ml', 'Water For Injection'), 
('509', 'Moxilin   250 mg', '036-0131-023', 'Injection', 'Acme Laboratories Ltd.', '21.26', '0.00', '250 mg', 'Amoxicillin'), 
('510', 'Moxilin   500 mg', '036-0132-23', 'Injection', 'Acme Laboratories Ltd.', '33.70', '0.00', '500 mg', 'Amoxicillin'), 
('511', 'Azin   500 mg', '036-0551-23', 'Injection', 'Acme Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('512', 'Tulos   68 %', '036-0385-60', 'Oral Solution', 'Acme Laboratories Ltd.', '120.37', '0.00', '68 %', 'Lactulose'), 
('513', 'Ac Crop  WSP   100 %', '036-0304-077', 'Powder', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 %', 'Sodium Diacetate'), 
('514', 'Moxilin   15 %', '036-0312-077', 'Powder', 'Acme Laboratories Ltd.', '149.50', '0.00', '15 %', 'Amoxicillin'), 
('515', 'Peravet  WSP    100 %', '036-0305-077', 'Powder', 'Acme Laboratories Ltd.', '173.52', '0.00', '100 %', 'Piperazine'), 
('516', 'Scz   30 %', '036-0288-077', 'Powder', 'Acme Laboratories Ltd.', '0.00', '0.00', '30 %', 'Sulfaclozine'), 
('517', 'Stivet   500 Lac IU', '036-0251-077', 'Powder', 'Acme Laboratories Ltd.', '0.00', '0.00', '500 Lac IU', 'Colistin Sulphate'), 
('518', 'Sulpha   100 %', '036-0311-077', 'Powder', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 %', 'Sulphanilamide'), 
('519', 'Moxilin Vet   30 %', '036-0617-077', 'Powder', 'Acme Laboratories Ltd.', '0.00', '0.00', '30 %', 'Amoxicillin'), 
('520', 'Alin Vet   45 %', '036-0681-077', 'Powder', 'Acme Laboratories Ltd.', '0.00', '0.00', '45 %', 'Tiamulin Hydrogen Fumerate'), 
('521', 'Nigofon Vet   100 %', '036-0818-077', 'Powder', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 %', 'Trichlorfon'), 
('522', 'Zero Sachet   12 mg', '036-0924', 'Sachet', 'Acme Laboratories Ltd.', '0.00', '0.00', '12 mg', 'Sucralose'), 
('523', 'Cipro A   10 gm', '036-0313-077', 'Solution', 'Acme Laboratories Ltd.', '1057.11', '0.00', '10 gm', 'Ciprofloxacin'), 
('524', 'A Fenac   12.5 mg', '036-0323-64', 'Suppository', 'Acme Laboratories Ltd.', '8.07', '0.00', '12.5 mg', 'Diclofenac Sodium'), 
('525', 'A Fenac      50 mg', '036-0322-64', 'Suppository', 'Acme Laboratories Ltd.', '14.10', '0.00', '50 mg', 'Diclofenac Sodium'), 
('526', 'Dirozyl   500 mg', '036-0325-27', 'Suppository', 'Acme Laboratories Ltd.', '12.09', '0.00', '500 mg', 'Metronidazole'), 
('527', 'Don A   15 mg', '036-04128', 'Suppository', 'Acme Laboratories Ltd.', '5.03', '0.00', '15 mg', 'Domperidone'), 
('528', 'Fast   125 mg', '036-0321-006', 'Suppository', 'Acme Laboratories Ltd.', '4.03', '0.00', '125 mg', 'Paracetamol'), 
('529', 'Fast   250 mg', '036-0320-006', 'Suppository', 'Acme Laboratories Ltd.', '5.03', '0.00', '250 mg', 'Paracetamol'), 
('530', 'Indo A     100 mg', '036-0319-64', 'Suppository', 'Acme Laboratories Ltd.', '7.04', '0.00', '100 mg', 'Indomethacin'), 
('531', 'Keto A     100 mg', '036-0324-64', 'Suppository', 'Acme Laboratories Ltd.', '12.09', '0.00', '100 mg', 'Ketoprofen'), 
('532', 'Tycon   330 mg', '036-0408', 'Suppository', 'Acme Laboratories Ltd.', '60.40', '0.00', '330 mg', 'Tioconazole'), 
('533', 'Don A     30 mg', '036-04008', 'Suppository', 'Acme Laboratories Ltd.', '8.07', '0.00', '30 mg', 'Domperidone'), 
('534', 'Napro A    500 mg', '036-0362-64', 'Suppository', 'Acme Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Naproxen'), 
('535', 'Fast   500 mg', '036-0472-006', 'Suppository', 'Acme Laboratories Ltd.', '8.07', '0.00', '500 mg', 'Paracetamol'), 
('536', 'Periset   16 mg', '036-07848', 'Suppository', 'Acme Laboratories Ltd.', '0.00', '0.00', '16 mg', 'Ondansetron'), 
('537', 'Neotrax Vet   1 %', '036-0244-077', 'Syrup', 'Acme Laboratories Ltd.', '0.00', '0.00', '1 %', 'Levamisole'), 
('538', 'A B1      100 mg', '036-0159-78', 'Tablet', 'Acme Laboratories Ltd.', '0.75', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('539', 'A Cal   Chewable   625 mg', '036-0279-62', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '625 mg', 'Calcium Carbonate'), 
('540', 'A Cal   1250 mg', '036-0280-62', 'Tablet', 'Acme Laboratories Ltd.', '6.01', '0.00', '1250 mg', 'Calcium Carbonate'), 
('541', 'A Card      20 mg', '036-0298', 'Tablet', 'Acme Laboratories Ltd.', '1.43', '0.00', '20 mg', 'Isosorbide Mononitrate'), 
('542', 'A Card  SR    50 mg', '036-0300', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Isosorbide Mononitrate'), 
('543', 'A Fenac      25 mg', '036-0090-64', 'Tablet', 'Acme Laboratories Ltd.', '0.55', '0.00', '25 mg', 'Diclofenac Sodium'), 
('544', 'A Fenac      50 mg', '036-0116-64', 'Tablet', 'Acme Laboratories Ltd.', '0.84', '0.00', '50 mg', 'Diclofenac Sodium'), 
('545', 'A Fenac K     50 mg', '036-0206-64', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Potassium'), 
('546', 'A Spasm   5 mg', '036-01221', 'Tablet', 'Acme Laboratories Ltd.', '1.44', '0.00', '5 mg', 'Oxyphenonium Bromide'), 
('547', 'A Tetra   500 mg', '036-0182-23', 'Tablet', 'Acme Laboratories Ltd.', '2.30', '0.00', '500 mg', 'Tetracycline Hydrochloride'), 
('548', 'A Zyme   325 mg', '036-01541', 'Tablet', 'Acme Laboratories Ltd.', '3.51', '0.00', '325 mg', 'Pancreatin'), 
('549', 'Acemox   250 mg', '036-00692', 'Tablet', 'Acme Laboratories Ltd.', '2.00', '0.00', '250 mg', 'Acetazolamide'), 
('550', 'Amlopin   10 mg', '036-0170-022', 'Tablet', 'Acme Laboratories Ltd.', '7.02', '0.00', '10 mg', 'Amlodipine'), 
('551', 'Amlopin      5 mg', '036-0169-022', 'Tablet', 'Acme Laboratories Ltd.', '5.01', '0.00', '5 mg', 'Amlodipine'), 
('552', 'Azepam      5 mg', '036-0360-057', 'Tablet', 'Acme Laboratories Ltd.', '0.69', '0.00', '5 mg', 'Diazepam'), 
('553', 'Azin   500 mg', '036-0204-23', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('554', 'Azin   500 mg', '036-0239-23', 'Tablet', 'Acme Laboratories Ltd.', '35.11', '0.00', '500 mg', 'Azithromycin'), 
('555', 'Ben A    400 mg', '036-0173-008', 'Tablet', 'Acme Laboratories Ltd.', '5.01', '0.00', '400 mg', 'Albendazole'), 
('556', 'Cecon   250 mg', '036-0079-78', 'Tablet', 'Acme Laboratories Ltd.', '1.32', '0.00', '250 mg', 'Vitamin C'), 
('557', 'Cetizin   10 mg', '036-0205-21', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('558', 'Cinazin   15 mg', '036-0152-21', 'Tablet', 'Acme Laboratories Ltd.', '0.70', '0.00', '15 mg', 'Cinnarizine'), 
('559', 'Cinazin      25 mg', '036-0337-21', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '25 mg', 'Cinnarizine'), 
('560', 'Cipro A    500 mg', '036-0167-23', 'Tablet', 'Acme Laboratories Ltd.', '14.06', '0.00', '500 mg', 'Ciprofloxacin'), 
('561', 'Cipro A    750 mg', '036-0340-23', 'Tablet', 'Acme Laboratories Ltd.', '18.11', '0.00', '750 mg', 'Ciprofloxacin'), 
('562', 'Claricin   250 mg', '036-0190-23', 'Tablet', 'Acme Laboratories Ltd.', '25.17', '0.00', '250 mg', 'Clarithromycin'), 
('563', 'Claricin   500 mg', '036-0246-23', 'Tablet', 'Acme Laboratories Ltd.', '40.27', '0.00', '500 mg', 'Clarithromycin'), 
('564', 'Cosium   10 mg', '036-00896', 'Tablet', 'Acme Laboratories Ltd.', '3.52', '0.00', '10 mg', 'Clobazam'), 
('565', 'Dactus   2 mg', '036-0381', 'Tablet', 'Acme Laboratories Ltd.', '5.03', '0.00', '2 mg', 'Glimepiride'), 
('566', 'Daomin   500 mg', '036-0117', 'Tablet', 'Acme Laboratories Ltd.', '3.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('567', 'Daomin   850 mg', '036-0243', 'Tablet', 'Acme Laboratories Ltd.', '4.99', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('568', 'Diloxide   500 mg', '036-0093-27', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Diloxanide Furoate'), 
('569', 'Dirozyl      200 mg', '036-0091-27', 'Tablet', 'Acme Laboratories Ltd.', '0.67', '0.00', '200 mg', 'Metronidazole'), 
('570', 'Dirozyl   400 mg', '036-0051-27', 'Tablet', 'Acme Laboratories Ltd.', '1.27', '0.00', '400 mg', 'Metronidazole'), 
('571', 'Don A     10 mg', '036-02968', 'Tablet', 'Acme Laboratories Ltd.', '2.01', '0.00', '10 mg', 'Domperidone'), 
('572', 'Dot   40 mg', '036-03411', 'Tablet', 'Acme Laboratories Ltd.', '1.76', '0.00', '40 mg', 'Drotaverine Hydrochloride'), 
('573', 'E Tab      200 mg', '036-0174-78', 'Tablet', 'Acme Laboratories Ltd.', '3.27', '0.00', '200 mg', 'Vitamin E'), 
('574', 'Ecosprin0   300 mg', '036-0081-6', 'Tablet', 'Acme Laboratories Ltd.', '1.72', '0.00', '300 mg', 'Aspirin'), 
('575', 'Ecosprin      75 mg', '036-0151-26', 'Tablet', 'Acme Laboratories Ltd.', '0.63', '0.00', '75 mg', 'Aspirin'), 
('576', 'Electro K   600 mg', '036-0092-62', 'Tablet', 'Acme Laboratories Ltd.', '0.60', '0.00', '600 mg', 'Potassium Chloride'), 
('577', 'Erocin   250 mg', '036-0293-23', 'Tablet', 'Acme Laboratories Ltd.', '5.18', '0.00', '250 mg', 'Erythromycin'), 
('578', 'Erocin   500 mg', '036-0294-23', 'Tablet', 'Acme Laboratories Ltd.', '10.35', '0.00', '500 mg', 'Erythromycin'), 
('579', 'Famodin      20 mg', '036-01485', 'Tablet', 'Acme Laboratories Ltd.', '2.00', '0.00', '20 mg', 'Famotidine'), 
('580', 'Famodin      40 mg', '036-01495', 'Tablet', 'Acme Laboratories Ltd.', '4.01', '0.00', '40 mg', 'Famotidine'), 
('581', 'Fix A     200 mg', '036-0191-23', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('582', 'Floxipar      200 mg', '036-0287-23', 'Tablet', 'Acme Laboratories Ltd.', '15.61', '0.00', '200 mg', 'Sparfloxacin'), 
('583', 'Fluconal      150 mg', '036-0257', 'Tablet', 'Acme Laboratories Ltd.', '22.15', '0.00', '150 mg', 'Fluconazole'), 
('584', 'Fluconal      50 mg', '036-0207', 'Tablet', 'Acme Laboratories Ltd.', '8.07', '0.00', '50 mg', 'Fluconazole'), 
('585', 'Gliclid   80 mg', '036-0260', 'Tablet', 'Acme Laboratories Ltd.', '7.02', '0.00', '80 mg', 'Gliclazide'), 
('586', 'Gluco A     100 mg', '036-0278', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Acarbose'), 
('587', 'Gluco A     50 mg', '036-0277', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Acarbose'), 
('588', 'Gluconil   5 mg', '036-0077', 'Tablet', 'Acme Laboratories Ltd.', '0.28', '0.00', '5 mg', 'Glibenclamide'), 
('589', 'Histalex   4 mg', '036-0123-21', 'Tablet', 'Acme Laboratories Ltd.', '0.30', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('590', 'Ketifen   1 mg', '036-0156-21', 'Tablet', 'Acme Laboratories Ltd.', '2.00', '0.00', '1 mg', 'Ketotifen'), 
('591', 'Keto A     100 mg', '036-0199-64', 'Tablet', 'Acme Laboratories Ltd.', '5.53', '0.00', '100 mg', 'Ketoprofen'), 
('592', 'Keto A     50 mg', '036-0200-64', 'Tablet', 'Acme Laboratories Ltd.', '3.52', '0.00', '50 mg', 'Ketoprofen'), 
('593', 'Lamid      100 mg', '036-0336-32', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Lamivudine'), 
('594', 'Leo   250 mg', '036-0379-23', 'Tablet', 'Acme Laboratories Ltd.', '8.07', '0.00', '250 mg', 'Levofloxacin'), 
('595', 'Leo   500 mg', '036-0373-23', 'Tablet', 'Acme Laboratories Ltd.', '15.10', '0.00', '500 mg', 'Levofloxacin'), 
('596', 'Lipril   10 mg', '036-0158-22', 'Tablet', 'Acme Laboratories Ltd.', '5.53', '0.00', '10 mg', 'Lisinopril'), 
('597', 'Lipril      5 mg', '036-0157-22', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '5 mg', 'Lisinopril'), 
('598', 'Losart      50 mg', '036-0335-022', 'Tablet', 'Acme Laboratories Ltd.', '8.03', '0.00', '50 mg', 'Losartan Potassium'), 
('599', 'Losart      25 mg', '036-0334-022', 'Tablet', 'Acme Laboratories Ltd.', '4.51', '0.00', '25 mg', 'Losartan Potassium'), 
('600', 'Mebolin   50 mg', '036-0104-21', 'Tablet', 'Acme Laboratories Ltd.', '2.01', '0.00', '50 mg', 'Mebhydrolin'), 
('601', 'Monas   10 mg', '036-0316-044', 'Tablet', 'Acme Laboratories Ltd.', '15.05', '0.00', '10 mg', 'Montelukast'), 
('602', 'Monas   4 mg', '036-0318-044', 'Tablet', 'Acme Laboratories Ltd.', '6.04', '0.00', '4 mg', 'Montelukast'), 
('603', 'Monas      5 mg', '036-0317-044', 'Tablet', 'Acme Laboratories Ltd.', '8.00', '0.00', '5 mg', 'Montelukast'), 
('604', 'Naligram   500 mg', '036-0074-23', 'Tablet', 'Acme Laboratories Ltd.', '4.89', '0.00', '500 mg', 'Nalidixic Acid'), 
('605', 'Napro A     250 mg', '036-0203-64', 'Tablet', 'Acme Laboratories Ltd.', '4.03', '0.00', '250 mg', 'Naproxen'), 
('606', 'Neo Trax   40 mg', '036-0027-8', 'Tablet', 'Acme Laboratories Ltd.', '0.43', '0.00', '40 mg', 'Levamisole'), 
('607', 'Nifin   10 mg', '036-0095-22', 'Tablet', 'Acme Laboratories Ltd.', '0.35', '0.00', '10 mg', 'Nifedipine'), 
('608', 'Nutramid   10 mg', '036-00718', 'Tablet', 'Acme Laboratories Ltd.', '0.35', '0.00', '10 mg', 'Metoclopramide Hydrochloride'), 
('609', 'Nystat   5 Lac Unit', '036-0118', 'Tablet', 'Acme Laboratories Ltd.', '6.27', '0.00', '5 Lac Unit', 'Nystatin'), 
('610', 'Nystat  VT   1 Lac Unit', '036-0140', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '1 Lac Unit', 'Nystatin'), 
('611', 'Orin   10 mg', '036-0259-21', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '10 mg', 'Loratadine'), 
('612', 'Osta   10 mg', '036-03338', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Alendronic Acid'), 
('613', 'Oxecone M  Chewable   400 mg', '036-0166-7', 'Tablet', 'Acme Laboratories Ltd.', '1.00', '0.00', '400 mg', 'Magaldrate'), 
('614', 'Pitam   800 mg', '036-0303', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '800 mg', 'Piracetam'), 
('615', 'Pivam      200 mg', '036-0365-23', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Pivmecillinam'), 
('616', 'Pizo A   500 mcg', '0.5-02627', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '500 mcg', 'Pizotifen'), 
('617', 'Pizo A   1.5 mg', '036-02927', 'Tablet', 'Acme Laboratories Ltd.', '7.04', '0.00', '1.5 mg', 'Pizotifen'), 
('618', 'Profen   400 mg', '036-0231-64', 'Tablet', 'Acme Laboratories Ltd.', '1.43', '0.00', '400 mg', 'Ibuprofen'), 
('619', 'Pronil  DS   1 gm', '036-0250-27', 'Tablet', 'Acme Laboratories Ltd.', '16.11', '0.00', '1 gm', 'Secnidazole'), 
('620', 'Pronil   500 mg', '036-0249-27', 'Tablet', 'Acme Laboratories Ltd.', '8.66', '0.00', '500 mg', 'Secnidazole'), 
('621', 'Ranidin      150 mg', '036-00655', 'Tablet', 'Acme Laboratories Ltd.', '2.51', '0.00', '150 mg', 'Ranitidine'), 
('622', 'Ranidin0   300 mg', '036-01455', 'Tablet', 'Acme Laboratories Ltd.', '4.03', '0.00', '300 mg', 'Ranitidine'), 
('623', 'Rizat   10 mg', '036-03837', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Rizatriptan'), 
('624', 'Rizat      5 mg', '036-03827', 'Tablet', 'Acme Laboratories Ltd.', '30.20', '0.00', '5 mg', 'Rizatriptan'), 
('625', 'Salmolin   4 mg', '036-00944', 'Tablet', 'Acme Laboratories Ltd.', '0.46', '0.00', '4 mg', 'Salbutamol'), 
('626', 'Simvatin   10 mg', '036-0238-61', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Simvastatin'), 
('627', 'Simvatin      20 mg', '036-0248-61', 'Tablet', 'Acme Laboratories Ltd.', '18.11', '0.00', '20 mg', 'Simvastatin'), 
('628', 'Steron   .5 mg', '036-0162-72', 'Tablet', 'Acme Laboratories Ltd.', '0.91', '0.00', '.5 mg', 'Dexamethasone'), 
('629', 'Sucrol   18 mg', '036-0134', 'Tablet', 'Acme Laboratories Ltd.', '0.69', '0.00', '18 mg', 'Aspartame'), 
('630', 'Tenil   3 mg', '036-02857', 'Tablet', 'Acme Laboratories Ltd.', '5.01', '0.00', '3 mg', 'Bromazepam'), 
('631', 'Tomide   2.5 mg', '036-04052', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '2.5 mg', 'Torasemide'), 
('632', 'Vertinil   5 mg', '036-03428', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Prochlorperazine Maleate'), 
('633', 'Win   5 mg', '036-02862', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Warfarin Sodium'), 
('634', 'Zafir      20 mg', '036-02894', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Zafirlukast'), 
('635', 'Fast   500 mg', '036-0042-006', 'Tablet', 'Acme Laboratories Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('636', 'Dulox   30 mg', '036-04604', 'Tablet', 'Acme Laboratories Ltd.', '10.07', '0.00', '30 mg', 'Duloxetine'), 
('637', 'Dulox      20 mg', '036-04594', 'Tablet', 'Acme Laboratories Ltd.', '7.04', '0.00', '20 mg', 'Duloxetine'), 
('638', 'Apitac   100 mg', '036-0464-64', 'Tablet', 'Acme Laboratories Ltd.', '4.01', '0.00', '100 mg', 'Aceclofenac'), 
('639', 'MB2   .5 mg', '036-0456-78', 'Tablet', 'Acme Laboratories Ltd.', '4.03', '0.00', '.5 mg', 'Mecobalamin'), 
('640', 'Carvipress      25 mg', '036-0465-22', 'Tablet', 'Acme Laboratories Ltd.', '8.07', '0.00', '25 mg', 'Carvedilol'), 
('641', 'Kidcal   625 mg', '036-0338-62', 'Tablet', 'Acme Laboratories Ltd.', '1.51', '0.00', '625 mg', 'Calcium Carbonate'), 
('642', 'Cipro A     250 mg', '036-0155-23', 'Tablet', 'Acme Laboratories Ltd.', '8.56', '0.00', '250 mg', 'Ciprofloxacin'), 
('643', 'Dactus   1 mg', '036-0380', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '1 mg', 'Glimepiride'), 
('644', 'Napro A    500 mg', '036-0291-64', 'Tablet', 'Acme Laboratories Ltd.', '7.04', '0.00', '500 mg', 'Naproxen'), 
('645', 'Carvipress   12.5 mg', '036-0453-22', 'Tablet', 'Acme Laboratories Ltd.', '5.03', '0.00', '12.5 mg', 'Carvedilol'), 
('646', 'Carvipress   6.25 mg', '036-0452-22', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '6.25 mg', 'Carvedilol'), 
('647', 'Cp      200 mg', '036-0448-23', 'Tablet', 'Acme Laboratories Ltd.', '42.29', '0.00', '200 mg', 'Cefpodoxime'), 
('648', 'Famicef   250 mg', '036-0450-23', 'Tablet', 'Acme Laboratories Ltd.', '25.17', '0.00', '250 mg', 'Cefuroxime'), 
('649', 'Leptic   .5 mg', '036-0461-046', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '.5 mg', 'Clonazepam'), 
('650', 'Leptic   2 mg', '036-0462-046', 'Tablet', 'Acme Laboratories Ltd.', '5.01', '0.00', '2 mg', 'Clonazepam'), 
('651', 'Dclot      75 mg', '036-0437-26', 'Tablet', 'Acme Laboratories Ltd.', '10.07', '0.00', '75 mg', 'Clopidogrel'), 
('652', 'Baby Zinc      20 mg', '036-0445-62', 'Tablet', 'Acme Laboratories Ltd.', '1.76', '0.00', '20 mg', 'Zinc'), 
('653', 'Mizolam      7.5 mg', '036-0444-057', 'Tablet', 'Acme Laboratories Ltd.', '8.07', '0.00', '7.5 mg', 'Midazolam'), 
('654', 'Thenglate  SR    250 mg', '036-04244', 'Tablet', 'Acme Laboratories Ltd.', '1.76', '0.00', '250 mg', 'Theophylline'), 
('655', 'Thenglate  SR   400 mg', '036-04254', 'Tablet', 'Acme Laboratories Ltd.', '2.69', '0.00', '400 mg', 'Theophylline'), 
('656', 'Uliv      150 mg', '036-0442', 'Tablet', 'Acme Laboratories Ltd.', '12.09', '0.00', '150 mg', 'Ursodeoxycholic Acid'), 
('657', 'Uliv0   300 mg', '036-0443', 'Tablet', 'Acme Laboratories Ltd.', '20.13', '0.00', '300 mg', 'Ursodeoxycholic Acid'), 
('658', 'Lipitor   10 mg', '036-0470-061', 'Tablet', 'Acme Laboratories Ltd.', '10.07', '0.00', '10 mg', 'Atorvastatin'), 
('659', 'Lipitor      20 mg', '036-0471-061', 'Tablet', 'Acme Laboratories Ltd.', '18.11', '0.00', '20 mg', 'Atorvastatin'), 
('660', 'Sizopra   10 mg', '036-0499-28', 'Tablet', 'Acme Laboratories Ltd.', '5.03', '0.00', '10 mg', 'Aripiprazole'), 
('661', 'Sizopra   15 mg', '15-0500-28', 'Tablet', 'Acme Laboratories Ltd.', '7.04', '0.00', '15 mg', 'Aripiprazole'), 
('662', 'Angist  SR   2.6 mg', '036-0501', 'Tablet', 'Acme Laboratories Ltd.', '4.03', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('663', 'Sono   1 mg', '036-0502-057', 'Tablet', 'Acme Laboratories Ltd.', '2.01', '0.00', '1 mg', 'Eszopiclone'), 
('664', 'Sono   2 mg', '036-0503-057', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '2 mg', 'Eszopiclone'), 
('665', 'A-Clam      50 mg', '036-0498-70', 'Tablet', 'Acme Laboratories Ltd.', '4.01', '0.00', '50 mg', 'Tolperisone Hydrochloride'), 
('666', 'Dolonil  SR    100 mg', '036-0523-65', 'Tablet', 'Acme Laboratories Ltd.', '25.08', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('667', 'Hycine   10 mg', '036-05251', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('668', 'A-Metrine   125 mcg', '036-05269', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '125 mcg', 'Methyl Ergometrine Maleate'), 
('669', 'A-Phyline      100 mg', '036-05274', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Aminophylline'), 
('670', 'Tracid   500 mg', '036-04829', 'Tablet', 'Acme Laboratories Ltd.', '15.10', '0.00', '500 mg', 'Tranexamic Acid'), 
('671', 'Tinium   50 mg', '036-04901', 'Tablet', 'Acme Laboratories Ltd.', '5.01', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('672', 'Winop   10 mg', '036-0479-064', 'Tablet', 'Acme Laboratories Ltd.', '10.07', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('673', 'Muterol   10 mg', '036-04924', 'Tablet', 'Acme Laboratories Ltd.', '1.51', '0.00', '10 mg', 'Bambuterol Hydrochloride'), 
('674', 'Muterol      20 mg', '036-04934', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '20 mg', 'Bambuterol Hydrochloride'), 
('675', 'Famicef   500 mg', '036-0513-23', 'Tablet', 'Acme Laboratories Ltd.', '45.29', '0.00', '500 mg', 'Cefuroxime'), 
('676', 'Leo   750 mg', '036-0468-23', 'Tablet', 'Acme Laboratories Ltd.', '20.13', '0.00', '750 mg', 'Levofloxacin'), 
('677', 'Zero   8 mg', '036-0536', 'Tablet', 'Acme Laboratories Ltd.', '1.00', '0.00', '8 mg', 'Sucralose'), 
('678', 'Carnitor   330 mg', '036-0538', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '330 mg', 'Levocarnitine'), 
('679', 'Diasis   500 mg', '036-0562-27', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Nitazoxanide'), 
('680', 'Akupen   30 mg', '036-0559-006', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '30 mg', 'Nefopam Hydrochloride'), 
('681', 'Orinex   5 mg', '036-0558-21', 'Tablet', 'Acme Laboratories Ltd.', '2.52', '0.00', '5 mg', 'Desloratadine'), 
('682', 'Protocid   40 mg', '036-0568-67', 'Tablet', 'Acme Laboratories Ltd.', '7.00', '0.00', '40 mg', 'Pantoprazole'), 
('683', 'Salmolin-L   1 mg', '036-05644', 'Tablet', 'Acme Laboratories Ltd.', '0.91', '0.00', '1 mg', 'Levosalbutamol'), 
('684', 'Salmolin-L   2 mg', '036-05654', 'Tablet', 'Acme Laboratories Ltd.', '1.70', '0.00', '2 mg', 'Levosalbutamol'), 
('685', 'Protocid   20 mg', '036-0567-67', 'Tablet', 'Acme Laboratories Ltd.', '4.01', '0.00', '20 mg', 'Pantoprazole'), 
('686', 'Dactus   3 mg', '036-0569', 'Tablet', 'Acme Laboratories Ltd.', '7.04', '0.00', '3 mg', 'Glimepiride'), 
('687', 'Pidus   15 mg', '036-0570', 'Tablet', 'Acme Laboratories Ltd.', '8.07', '0.00', '15 mg', 'Pioglitazone'), 
('688', 'Keto-D   25 mg', '036-0571-64', 'Tablet', 'Acme Laboratories Ltd.', '4.03', '0.00', '25 mg', 'Dex-Ketoprofen Trometamol'), 
('689', 'Lacitab   2 mg', '036-0574-22', 'Tablet', 'Acme Laboratories Ltd.', '15.00', '0.00', '2 mg', 'Lacidipine'), 
('690', 'Lactitab   4 mg', '036-0575-22', 'Tablet', 'Acme Laboratories Ltd.', '6.04', '0.00', '4 mg', 'Lacidipine'), 
('691', 'Unipril   2.5 mg', '036-0578-022', 'Tablet', 'Acme Laboratories Ltd.', '5.03', '0.00', '2.5 mg', 'Ramipril'), 
('692', 'Unipril   5 mg', '036-0579-022', 'Tablet', 'Acme Laboratories Ltd.', '8.07', '0.00', '5 mg', 'Ramipril'), 
('693', 'Angirid MR   35 mg', '036-0590', 'Tablet', 'Acme Laboratories Ltd.', '5.03', '0.00', '35 mg', 'Trimetazidine Dihydrochloride'), 
('694', 'Misoclear   200 mcg', '036-05919', 'Tablet', 'Acme Laboratories Ltd.', '15.04', '0.00', '200 mcg', 'Misoprostol'), 
('695', 'Thyrolar   25 mcg', '036-0594-74', 'Tablet', 'Acme Laboratories Ltd.', '0.70', '0.00', '25 mcg', 'Levothyroxine Sodium'), 
('696', 'Thyrolar   50 mcg', '036-0595-74', 'Tablet', 'Acme Laboratories Ltd.', '1.20', '0.00', '50 mcg', 'Levothyroxine Sodium'), 
('697', 'Thyrolar   100 mcg', '036-0596-74', 'Tablet', 'Acme Laboratories Ltd.', '2.31', '0.00', '100 mcg', 'Levothyroxine Sodium'), 
('698', 'Setorib   60 mg', '036-0599-64', 'Tablet', 'Acme Laboratories Ltd.', '7.04', '0.00', '60 mg', 'Etoricoxib'), 
('699', 'Setorib   90 mg', '036-0600-64', 'Tablet', 'Acme Laboratories Ltd.', '12.09', '0.00', '90 mg', 'Etoricoxib'), 
('700', 'Setorib   120 mg', '036-0601-64', 'Tablet', 'Acme Laboratories Ltd.', '14.10', '0.00', '120 mg', 'Etoricoxib'), 
('701', 'Liptor   40 mg', '036-0618-061', 'Tablet', 'Acme Laboratories Ltd.', '24.16', '0.00', '40 mg', 'Atorvastatin'), 
('702', 'Enocam   20 mg', '036-0623-64', 'Tablet', 'Acme Laboratories Ltd.', '8.03', '0.00', '20 mg', 'Tenoxicam'), 
('703', 'Sevel   400 mg', '036-0627-62', 'Tablet', 'Acme Laboratories Ltd.', '45.13', '0.00', '400 mg', 'Sevelamer Hydrochloride'), 
('704', 'Mega Joy   20 mg', '036-0628-043', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Tadalafil'), 
('705', 'Periset   8 mg', '036-06318', 'Tablet', 'Acme Laboratories Ltd.', '10.03', '0.00', '8 mg', 'Ondansetron'), 
('706', 'Bet-A   500 mcg', '036-0647-72', 'Tablet', 'Acme Laboratories Ltd.', '0.72', '0.00', '500 mcg', 'Betamethasone'), 
('707', 'Losart   100 mg', '036-0649-022', 'Tablet', 'Acme Laboratories Ltd.', '12.03', '0.00', '100 mg', 'Losartan Potassium'), 
('708', 'Rostab   20 mg', '036-0657-61', 'Tablet', 'Acme Laboratories Ltd.', '25.08', '0.00', '20 mg', 'Rosuvastatin'), 
('709', 'Rostab   10 mg', '036-0656-61', 'Tablet', 'Acme Laboratories Ltd.', '20.07', '0.00', '10 mg', 'Rosuvastatin'), 
('710', 'Betaone   50 mg', '036-0655-22', 'Tablet', 'Acme Laboratories Ltd.', '2.00', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('711', 'Skelofen   10 mg', '036-0668-70', 'Tablet', 'Acme Laboratories Ltd.', '8.03', '0.00', '10 mg', 'Baclofen'), 
('712', 'Fluzin   10 mg', '036-06737', 'Tablet', 'Acme Laboratories Ltd.', '5.01', '0.00', '10 mg', 'Flunarizine'), 
('713', 'Fluzin   5 mg', '036-06727', 'Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '5 mg', 'Flunarizine'), 
('714', 'Versil   4 mg', '036-0671-22', 'Tablet', 'Acme Laboratories Ltd.', '12.09', '0.00', '4 mg', 'Perindopril Erbumine'), 
('715', 'Gabon   300 mg', '036-0674-046', 'Tablet', 'Acme Laboratories Ltd.', '16.04', '0.00', '300 mg', 'Gabapentin'), 
('716', 'Janvia   50 mg', '036-0675', 'Tablet', 'Acme Laboratories Ltd.', '15.04', '0.00', '50 mg', 'Sitagliptin'), 
('717', 'Janvia   100 mg', '036-0676', 'Tablet', 'Acme Laboratories Ltd.', '28.08', '0.00', '100 mg', 'Sitagliptin'), 
('718', 'Etogesic SR   600 mg', '036-0692-64', 'Tablet', 'Acme Laboratories Ltd.', '15.04', '0.00', '600 mg', 'Etodolac'), 
('719', 'Betabis   2.5 mg', '036-0693-22', 'Tablet', 'Acme Laboratories Ltd.', '6.01', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('720', 'Betabis   5 mg', '036-0694-22', 'Tablet', 'Acme Laboratories Ltd.', '10.03', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('721', 'Prasugen   5 mg', '036-0695-26', 'Tablet', 'Acme Laboratories Ltd.', '12.03', '0.00', '5 mg', 'Prasugrel'), 
('722', 'Prasugen   10 mg', '036-0696-26', 'Tablet', 'Acme Laboratories Ltd.', '20.07', '0.00', '10 mg', 'Prasugrel'), 
('723', 'Alanil   120 mg', '036-0698-21', 'Tablet', 'Acme Laboratories Ltd.', '6.52', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('724', 'Alanil   180 mg', '036-0704-21', 'Tablet', 'Acme Laboratories Ltd.', '8.03', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('725', 'Picidin   5 mg', '036-0706-025', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Procyclidine Hydrochloride'), 
('726', 'Goustat   40 mg', '036-0705-76', 'Tablet', 'Acme Laboratories Ltd.', '12.03', '0.00', '40 mg', 'Febuxostat'), 
('727', 'Pavigard   2 mg', '036-0687-61', 'Tablet', 'Acme Laboratories Ltd.', '10.03', '0.00', '2 mg', 'Pitavastatin'), 
('728', 'Vildapin   50 mg', '036-0711', 'Tablet', 'Acme Laboratories Ltd.', '15.04', '0.00', '50 mg', 'Vildagliptin'), 
('729', 'Unipril   1.25 mg', '036-0718-022', 'Tablet', 'Acme Laboratories Ltd.', '2.51', '0.00', '1.25 mg', 'Ramipril'), 
('730', 'Skelofen   5 mg', '036-0719-70', 'Tablet', 'Acme Laboratories Ltd.', '4.51', '0.00', '5 mg', 'Baclofen'), 
('731', 'Megafil   5 mg', '036-0731-043', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Tadalafil'), 
('732', 'Elodep   5 mg', '036-07614', 'Tablet', 'Acme Laboratories Ltd.', '5.52', '0.00', '5 mg', 'Escitalopram'), 
('733', 'Elodep   10 mg', '036-07624', 'Tablet', 'Acme Laboratories Ltd.', '10.03', '0.00', '10 mg', 'Escitalopram'), 
('734', 'Orbas   20 mg', '036-0763-22', 'Tablet', 'Acme Laboratories Ltd.', '8.03', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('735', 'Orbas   40 mg', '036-0764-22', 'Tablet', 'Acme Laboratories Ltd.', '15.04', '0.00', '40 mg', 'Olmesartan Medoxomil'), 
('736', 'Lacosam   50 mg', '036-0765-013', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Lacosamide'), 
('737', 'Lacosam0   100 mg', '036-0766-013', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Lacosamide'), 
('738', 'Acivir   200 mg', '036-0768-32', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Acyclovir'), 
('739', 'Acivir0   400 mg', '036-0769-32', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Acyclovir'), 
('740', 'Vinpoton   5 mg', '036-0771-36', 'Tablet', 'Acme Laboratories Ltd.', '4.01', '0.00', '5 mg', 'Vinpocetine'), 
('741', 'Gliclid MR   30 mg', '036-0772', 'Tablet', 'Acme Laboratories Ltd.', '6.01', '0.00', '30 mg', 'Gliclazide'), 
('742', 'Sizomax   1 mg', '036-0773-28', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '1 mg', 'Risperidone'), 
('743', 'Sizomax   2 mg', '036-0774-28', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '2 mg', 'Risperidone'), 
('744', 'Sizomax   4 mg', '036-0775-28', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '4 mg', 'Risperidone'), 
('745', 'A-Meb   135 mg', '036-07501', 'Tablet', 'Acme Laboratories Ltd.', '6.01', '0.00', '135 mg', 'Mebeverine Hydrochloride'), 
('746', 'Rupastin   10 mg', '036-0751-21', 'Tablet', 'Acme Laboratories Ltd.', '10.03', '0.00', '10 mg', 'Rupatadine'), 
('747', 'Acmegra   25 mg', '036-0752-043', 'Tablet', 'Acme Laboratories Ltd.', '20.07', '0.00', '25 mg', 'Sildenafil'), 
('748', 'Acmegra   50 mg', '036-0753-043', 'Tablet', 'Acme Laboratories Ltd.', '30.10', '0.00', '50 mg', 'Sildenafil'), 
('749', 'Acmegra   100 mg', '036-0754-043', 'Tablet', 'Acme Laboratories Ltd.', '50.14', '0.00', '100 mg', 'Sildenafil'), 
('750', 'Misoclear   600 mcg', '036-07569', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '600 mcg', 'Misoprostol'), 
('751', 'Ecosprin   150 mg', '036-0781-26', 'Tablet', 'Acme Laboratories Ltd.', '0.92', '0.00', '150 mg', 'Aspirin'), 
('752', 'Valtin   80 mg', '036-0782-22', 'Tablet', 'Acme Laboratories Ltd.', '9.03', '0.00', '80 mg', 'Valsartan'), 
('753', 'Valtin   160 mg', '036-0783-22', 'Tablet', 'Acme Laboratories Ltd.', '16.04', '0.00', '160 mg', 'Valsartan'), 
('754', 'Floxigem   320 mg', '036-0785-23', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '320 mg', 'Gemefloxacin'), 
('755', 'Milast-A   500 mcg', '036-07904', 'Tablet', 'Acme Laboratories Ltd.', '15.04', '0.00', '500 mcg', 'Roflumilast'), 
('756', 'Mediprist   200 mg', '036-0797-049', 'Tablet', 'Acme Laboratories Ltd.', '280.84', '0.00', '200 mg', 'Mifepristone'), 
('757', 'Ecosprin   100 mg', '036-0796-26', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Aspirin'), 
('758', 'Trasin   2 mg', '036-0802-22', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '2 mg', 'Terazosin'), 
('759', 'Trasin   5 mg', '036-0803-22', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Terazosin'), 
('760', 'Rostab   5 mg', '036-0805-61', 'Tablet', 'Acme Laboratories Ltd.', '10.03', '0.00', '5 mg', 'Rosuvastatin'), 
('761', 'Ibsan   300 mg', '036-0806-22', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '300 mg', 'Irbesartan'), 
('762', 'Betaone   25 mg', '036-0808-22', 'Tablet', 'Acme Laboratories Ltd.', '1.51', '0.00', '25 mg', 'Metoprolol Tartrate'), 
('763', 'Aximin   200 mg', '036-0814-23', 'Tablet', 'Acme Laboratories Ltd.', '20.07', '0.00', '200 mg', 'Rifaximin'), 
('764', 'Aximin   550 mg', '036-0815-23', 'Tablet', 'Acme Laboratories Ltd.', '45.13', '0.00', '550 mg', 'Rifaximin'), 
('765', 'Maxima   20 mg', '036-0854-067', 'Tablet', 'Acme Laboratories Ltd.', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('766', 'Maxima   40 mg', '036-0855-67', 'Tablet', 'Acme Laboratories Ltd.', '8.00', '0.00', '40 mg', 'Esomeprazole'), 
('767', 'Rhitin   10 mg', '036-0857-21', 'Tablet', 'Acme Laboratories Ltd.', '6.00', '0.00', '10 mg', 'Ebastine'), 
('768', 'Lino   5 mg', '036-0865-015', 'Tablet', 'Acme Laboratories Ltd.', '15.00', '0.00', '5 mg', 'Linagliptin'), 
('769', 'Cubimox   400 mg', '036-0866-23', 'Tablet', 'Acme Laboratories Ltd.', '40.00', '0.00', '400 mg', 'Moxifloxacin'), 
('770', 'Defrol   1000 IU', '036-0868-78', 'Tablet', 'Acme Laboratories Ltd.', '2.00', '0.00', '1000 IU', 'Cholecalciferol (Vit. D3)'), 
('771', 'Salmolin   2 mg', '036-08794', 'Tablet', 'Acme Laboratories Ltd.', '0.26', '0.00', '2 mg', 'Salbutamol'), 
('772', 'Fenoxilin   250 mg', '036-0880-23', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('773', 'Lactocal   300 mg', '036-0881-62', 'Tablet', 'Acme Laboratories Ltd.', '0.30', '0.00', '300 mg', 'Calcium Lactate'), 
('774', 'Fezol   2.5 mg', '036-0886', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '2.5 mg', 'Letrozole'), 
('775', 'Tibofem   2.5 mg', '036-08876', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '2.5 mg', 'Tibolone'), 
('776', 'Zilsart   40 mg', '036-0888-', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '40 mg', 'Azilsartan Medoxomil'), 
('777', 'Zilsart   80 mg', '036-0889-', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '80 mg', 'Azilsartan Medoxomil'), 
('778', 'O-Cal   740 mg', '036-0890-62', 'Tablet', 'Acme Laboratories Ltd.', '10.00', '0.00', '740 mg', 'Calcium Orotate'), 
('779', 'Cortimax   6 mg', '036-0891-72', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '6 mg', 'Deflazacort'), 
('780', 'Sevel   800 mg', '036-0893', 'Tablet', 'Acme Laboratories Ltd.', '60.00', '0.00', '800 mg', 'Sevelamer (As Carbonate)'), 
('781', 'Dophylin   400 mg', '036-08944', 'Tablet', 'Acme Laboratories Ltd.', '8.00', '0.00', '400 mg', 'Doxophylline'), 
('782', 'Duocard   5 mg', '036-0908-22', 'Tablet', 'Acme Laboratories Ltd.', '7.00', '0.00', '5 mg', 'Cilnidipine'), 
('783', 'Duocard   10 mg', '036-0909-22', 'Tablet', 'Acme Laboratories Ltd.', '9.00', '0.00', '10 mg', 'Cilnidipine'), 
('784', 'Patron   .5 mg', '036-09148', 'Tablet', 'Acme Laboratories Ltd.', '20.00', '0.00', '.5 mg', 'Palonosetron'), 
('785', 'Dophylin   200 mg', '036-09324', 'Tablet', 'Acme Laboratories Ltd.', '5.00', '0.00', '200 mg', 'Doxophylline'), 
('786', 'Thyrolar   12.5 mcg', '036-0935-74', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '12.5 mcg', 'Levothyroxine Sodium'), 
('787', 'Thyrolar   75 mcg', '036-936-74', 'Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '75 mcg', 'Levothyroxine Sodium'), 
('788', 'Solicare   5 mg', '036-09431', 'Tablet', 'Acme Laboratories Ltd.', '15.00', '0.00', '5 mg', 'Solifenacin Succinate'), 
('789', 'Solicare   10 mg', '036-09441', 'Tablet', 'Acme Laboratories Ltd.', '30.00', '0.00', '10 mg', 'Solifenacin Succinate'), 
('790', 'Benazole   600 mg', '036-0218-077', 'Bolus', 'Acme Laboratories Ltd.', '7.44', '0.00', '600 mg', 'Albendazole'), 
('791', 'Dirozyl   2 gm', '036-0419-077', 'Bolus', 'Acme Laboratories Ltd.', '0.00', '0.00', '2 gm', 'Metronidazole'), 
('792', 'Hexatin   1 gm', '036-0210-077', 'Bolus', 'Acme Laboratories Ltd.', '0.00', '0.00', '1 gm', 'Hexachlorophene'), 
('793', 'Levavet   600 mg', '036-0216-077', 'Bolus', 'Acme Laboratories Ltd.', '7.12', '0.00', '600 mg', 'Levamisole'), 
('794', 'Tetra   500 mg', '036-0219-077', 'Bolus', 'Acme Laboratories Ltd.', '3.01', '0.00', '500 mg', 'Oxytetracycline'), 
('795', 'Tetravet   1 gm', '036-0220-077', 'Bolus', 'Acme Laboratories Ltd.', '0.00', '0.00', '1 gm', 'Oxytetracycline'), 
('796', 'Fast Vet   2 gm', '036-0476-077', 'Bolus', 'Acme Laboratories Ltd.', '2.27', '0.00', '2 gm', 'Paracetamol'), 
('797', 'Sulfasol Vet   5 gm', '036-0475-077', 'Bolus', 'Acme Laboratories Ltd.', '12.03', '0.00', '5 gm', 'Sulphadimidine'), 
('798', 'Moxillin Vet   1 gm', '036-0653-077', 'Bolus', 'Acme Laboratories Ltd.', '10.03', '0.00', '1 gm', 'Amoxicillin'), 
('799', 'Steron Vet   10 mg', '036-0678-077', 'Bolus', 'Acme Laboratories Ltd.', '5.01', '0.00', '10 mg', 'Dexamethasone'), 
('800', 'Zis-Vet   200 mg', '036-0689-77', 'Bolus', 'Acme Laboratories Ltd.', '6.01', '0.00', '200 mg', 'Zinc'), 
('801', 'Met-Vet   100 mg', '036-0688-077', 'Bolus', 'Acme Laboratories Ltd.', '6.01', '0.00', '100 mg', 'Meloxicam'), 
('802', 'Keto-A Vet   400 mg', '036-0729-077', 'Bolus', 'Acme Laboratories Ltd.', '10.03', '0.00', '400 mg', 'Ketoprofen'), 
('803', 'Cipro-A Vet   750 mg', '036-0747-077', 'Bolus', 'Acme Laboratories Ltd.', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('804', 'Cipro-A Vet0   1 gm', '036-0748-077', 'Bolus', 'Acme Laboratories Ltd.', '20.07', '0.00', '1 gm', 'Ciprofloxacin'), 
('805', 'Fenazol Vet   250 mg', '036-0816-077', 'Bolus', 'Acme Laboratories Ltd.', '5.76', '0.00', '250 mg', 'Fenbendazole'), 
('806', 'Phenadryl Vet   500 mg', '036-0874-', 'Bolus', 'Acme Laboratories Ltd.', '4.00', '0.00', '500 mg', 'Diphenhydramine Hydrochloride'), 
('807', 'A-Cold Vet   100 mg', '036-0921-077', 'Bolus', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Bromhexine Hydrochloride'), 
('808', 'Trizon  IM   250 mg', '036-0228-23', 'IM Injection', 'Acme Laboratories Ltd.', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('809', 'Trizon  IV   1 gm', '036-0234-23', 'IV Injection', 'Acme Laboratories Ltd.', '143.97', '0.00', '1 gm', 'Ceftriaxone'), 
('810', 'Trizon  IV   2 gm', '036-0389-23', 'IV Injection', 'Acme Laboratories Ltd.', '261.77', '0.00', '2 gm', 'Ceftriaxone'), 
('811', 'Trizon  IV   500 mg', '036-0230-23', 'IV Injection', 'Acme Laboratories Ltd.', '130.39', '0.00', '500 mg', 'Ceftriaxone'), 
('812', 'Trizon  IV   250 mg', '036-0229-23', 'IV Injection', 'Acme Laboratories Ltd.', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('813', 'Acmecilin   500 mg', '036-0125-23', 'IV/IM Injection', 'Acme Laboratories Ltd.', '27.32', '0.00', '500 mg', 'Ampicillin'), 
('814', 'Acmecilin   250 mg', '036-0124-23', 'IV/IM Injection', 'Acme Laboratories Ltd.', '19.43', '0.00', '250 mg', 'Ampicillin'), 
('815', 'Aminoplex   5 %', '036-0726-3', 'IV Infusion', 'Acme Laboratories Ltd.', '402.72', '0.00', '5 %', 'Amino Acids (Essential)'), 
('816', 'Azolin  NS   .05 %', '036-03462', 'Nasal Drops', 'Acme Laboratories Ltd.', '45.13', '0.00', '.05 %', 'Oxymetazoline Hydrochloride'), 
('817', 'Clotrim  VT    200 mg', '036-0532', 'Vaginal Tablet', 'Acme Laboratories Ltd.', '20.13', '0.00', '200 mg', 'Clotrimazole'), 
('818', 'Clotrim   200 mg', '036-0511', 'Vaginal Suppository', 'Acme Laboratories Ltd.', '20.13', '0.00', '200 mg', 'Clotrimazole'), 
('819', 'Ascon Inhalation Aer   100 mcg', '036-03684', 'Inhalation Solution', 'Acme Laboratories Ltd.', '270.81', '0.00', '100 mcg', 'Beclomethasone Dipropionate'), 
('820', 'Ascon   250 mcg', '036-04264', 'Inhalation Solution', 'Acme Laboratories Ltd.', '320.96', '0.00', '250 mcg', 'Beclomethasone Dipropionate'), 
('821', 'Beclod      200 mcg', '036-03274', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '200 mcg', 'Beclomethasone Dipropionate'), 
('822', 'Fluticon  DPI    100 mcg', '036-03314', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '4.28', '0.00', '100 mcg', 'Fluticasone Propionate'), 
('823', 'Fluticon      50 mcg', '036-03304', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '2.52', '0.00', '50 mcg', 'Fluticasone Propionate'), 
('824', 'Fluticon   500 mcg', '036-03994', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '13.09', '0.00', '500 mcg', 'Fluticasone Propionate'), 
('825', 'Fluticon   250 mcg', '036-03984', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '8.07', '0.00', '250 mcg', 'Fluticasone Propionate'), 
('826', 'Salmerol   25 mcg', '036-03924', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '25 mcg', 'Salmeterol'), 
('827', 'Salmolin      200 mcg', '036-03284', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '2.51', '0.00', '200 mcg', 'Salbutamol'), 
('828', 'Salmolin      100 mcg', '036-03704', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mcg', 'Salbutamol'), 
('829', 'Tropium   40 mcg', '036-03614', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '40 mcg', 'Ipratropium Bromide'), 
('830', 'Topium DPI   18 mcg', '036-04744', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '5.03', '0.00', '18 mcg', 'Tiotropium'), 
('831', 'Indica DPI   75 mcg', '036-09134', 'Inhalation Capsule', 'Acme Laboratories Ltd.', '0.00', '0.00', '75 mcg', 'Indacaterol'), 
('832', 'Darifen ER   7.5 mg', '036-06199', 'Pr Tablet', 'Acme Laboratories Ltd.', '22.07', '0.00', '7.5 mg', 'Darifenacin'), 
('833', 'Darifen ER   15 mg', '036-06209', 'Pr Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '15 mg', 'Darifenacin'), 
('834', 'Lactos   300 mg', '036-0899-', 'Chewable Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '300 mg', 'Lactase'), 
('835', 'Daomin   1 gm', '036-0612', 'Xr Tablet', 'Acme Laboratories Ltd.', '7.02', '0.00', '1 gm', 'Metformin Hydrochloride'), 
('836', 'Fast XR   665 mg', '036-0660-6', 'Xr Tablet', 'Acme Laboratories Ltd.', '1.51', '0.00', '665 mg', 'Paracetamol'), 
('837', 'Daomin XR   500 mg', '036-0702', 'Xr Tablet', 'Acme Laboratories Ltd.', '5.01', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('838', 'A Fenac  SR    100 mg', '036-0307-64', 'Sr Tablet', 'Acme Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('839', 'A Fenac  SR    100 mg', '036-0144-64', 'Sr Tablet', 'Acme Laboratories Ltd.', '3.01', '0.00', '100 mg', 'Diclofenac Sodium'), 
('840', 'PPI   20 mg', '364-0015-67', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('841', 'PPI   40 mg', '364-0016-67', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Omeprazole'), 
('842', 'Maxima   20 mg', '364-0017-067', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('843', 'Maxima   40 mg', '364-0018-067', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Esomeprazole'), 
('844', 'Dolonil   50 mg', '364-0019-65', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('845', 'Azin   250 mg', '364-0020-23', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('846', 'Lifil-E   200 mg', '364-0062-78', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Vitamin E'), 
('847', 'Lifil-E0   400 mg', '364-0063-78', 'Capsule', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Vitamin E'), 
('848', 'Don-A   10 mg', '364-00018', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('849', 'Ranidin F/C   150 mg', '364-00025', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('850', 'Ranidin F/C   300 mg', '364-00035', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Ranitidine'), 
('851', 'Fast   500 mg', '364-0004-006', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('852', 'A-Cal   625 mg', '364-0006-62', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '625 mg', 'Calcium Carbonate'), 
('853', 'Cetizin   10 mg', '364-0007-21', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('854', 'Cipro-A   250 mg', '364-0008-23', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('855', 'Cipro-A   500 mg', '364-0009-23', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('856', 'Cipro-A   750 mg', '364-0010-23', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('857', 'Azin   500 mg', '364-0011-23', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('858', 'Tenoloc   100 mg', '364-0012-22', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Atenolol'), 
('859', 'Tenoloc   50 mg', '364-0013-22', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Atenolol'), 
('860', 'A-Cal   1250 mg', '364-0014-62', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('861', 'Ecosprin   75 mg', '364-0025-26', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '75 mg', 'Aspirin'), 
('862', 'Ecosprin   300 mg', '364-0026-6', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Aspirin'), 
('863', 'Monas   4 mg', '364-0028-044', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Montelukast'), 
('864', 'Monas   5 mg', '364-0029-044', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Montelukast'), 
('865', 'Tinium   50 mg', '364-00271', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('866', 'Monas   10 mg', '364-0030-044', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Montelukast'), 
('867', 'Tenil   3 mg', '364-00327', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('868', 'A-Fenac   25 mg', '364-0033-64', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Diclofenac Sodium'), 
('869', 'A-Fenac   50 mg', '364-0034-64', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('870', 'A-Fenac K   50 mg', '364-0036-64', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Potassium'), 
('871', 'Apitac   100 mg', '364-0037-64', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Aceclofenac'), 
('872', 'Baby Zinc   20 mg', '364-0038-62', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Zinc'), 
('873', 'Napro-A   250 mg', '364-0039-64', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Naproxen'), 
('874', 'Napro-A   500 mg', '364-0040-64', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Naproxen'), 
('875', 'Amlopin   5 mg', '364-0041-022', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Amlodipine'), 
('876', 'Amlopin   10 mg', '364-0042-022', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Amlodipine'), 
('877', 'Winop   10 mg', '364-0046-064', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('878', 'Dolonil SR   100 mg', '364-0047-65', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('879', 'Tracid0   500 mg', '364-00489', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('880', 'Dirozyl   200 mg', '364-0049-27', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Metronidazole'), 
('881', 'Dirozyl   400 mg', '364-0050-27', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('882', 'Fluconal   50 mg', '364-0051', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Fluconazole'), 
('883', 'Fluconal   150 mg', '364-0052', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Fluconazole'), 
('884', 'Cecon   250 mg', '364-0054-78', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('885', 'Leo   250 mg', '364-0056-23', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Levofloxacin'), 
('886', 'Leo0   500 mg', '364-0057-23', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('887', 'Leo0   750 mg', '364-0058-23', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '750 mg', 'Levofloxacin'), 
('888', 'Nidozox   500 mg', '364-0060-27', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Nitazoxanide'), 
('889', 'Misoclear   200 mcg', '364-00619', 'Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '200 mcg', 'Misoprostol'), 
('890', 'A-Fenac SR   100 mg', '364-0035-64', 'Sr Tablet', 'Acme Specialized Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('891', 'Disposible Syringe ml   10 ml', '280-00041', 'Syringe', 'Acmunio International Ltd.', '0.00', '0.00', '10 ml', 'Disposable Syringe'), 
('892', 'CADY AD Syringe   .5 ml', '280-00011', 'Syringe', 'Acmunio International Ltd.', '0.00', '0.00', '.5 ml', 'Disposable Syringe'), 
('893', 'BECKY 3 ml AD & RPF Syringe   3 ml', '280-00021', 'Syringe', 'Acmunio International Ltd.', '0.00', '0.00', '3 ml', 'Disposable Syringe'), 
('894', 'BECKY ml AD & RPF Syringe   5 ml', '280-00031', 'Syringe', 'Acmunio International Ltd.', '0.00', '0.00', '5 ml', 'Disposable Syringe'), 
('895', 'Cefatop   200 mg', '355-0069-23', 'Capsule', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('896', 'Cefufine   500 mg', '355-0066-23', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '500 mg', 'Cefuroxime'), 
('897', 'Cefufine   250 mg', '355-0067-23', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '250 mg', 'Cefuroxime'), 
('898', 'Maxtrol   20 mg', '355-0070-067', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('899', 'Atofine   20 mg', '355-0071-061', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '20 mg', 'Atorvastatin'), 
('900', 'Atofine   10 mg', '355-0072-061', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '10 mg', 'Atorvastatin'), 
('901', 'Azifine   500 mg', '355-0074-23', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('902', 'Glorinta   90 mg', '355-0075-26', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '90 mg', 'Ticagrelor'), 
('903', 'Rosufine   10 mg', '355-0076-61', 'Tablet', 'Active Fine Chemicals Ltd.', '0.00', '0.00', '10 mg', 'Rosuvastatin'), 
('904', 'J Mox   250 mg', '084-0019-023', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '2.86', '0.00', '250 mg', 'Amoxicillin'), 
('905', 'Jefenac  TR    100 mg', '084-0043-64', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('906', 'J Mox   500 mg', '084-0039-23', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '5.71', '0.00', '500 mg', 'Amoxicillin'), 
('907', 'Jedine   250 mg', '084-0053-023', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cephradine'), 
('908', 'Jedine   500 mg', '084-0054-23', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '12.50', '0.00', '500 mg', 'Cephradine'), 
('909', 'Omrazole      20 mg', '084-0058-67', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '4.50', '0.00', '20 mg', 'Omeprazole'), 
('910', 'Cefixime A     200 mg', '084-0077-23', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '25.00', '0.00', '200 mg', 'Cefixime'), 
('911', 'Somazole      20 mg', '084-0087-067', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('912', 'Oxacol   500 mg', '084-0088-23', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '9.00', '0.00', '500 mg', 'Flucloxacillin'), 
('913', 'Trigal   50 mg', '084-0093', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '7.00', '0.00', '50 mg', 'Fluconazole'), 
('914', 'Trigal   150 mg', '084-0094', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '18.00', '0.00', '150 mg', 'Fluconazole'), 
('915', 'Mucovan   75 mg', '084-0106-31', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '75 mg', 'Ambroxol'), 
('916', 'Ultradol   50 mg', '084-0127-65', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '7.50', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('917', 'Omrazol   40 mg', '084-0128-67', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '7.00', '0.00', '40 mg', 'Omeprazole'), 
('918', 'Somazole   40 mg', '084-0133-067', 'Capsule', 'Ad-din Pharmaceuticals Ltd.', '8.00', '0.00', '40 mg', 'Esomeprazole'), 
('919', 'Ultradol   100 mg', '084-0171-65', 'Suppository', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('920', 'Neofenac   50 mg', '084-0146-064', 'Suppository', 'Ad-din Pharmaceuticals Ltd.', '12.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('921', 'Neofenac   12.5 mg', '084-0145-064', 'Suppository', 'Ad-din Pharmaceuticals Ltd.', '7.50', '0.00', '12.5 mg', 'Diclofenac Sodium'), 
('922', 'Feva   250 mg', '084-0143-006', 'Suppository', 'Ad-din Pharmaceuticals Ltd.', '5.00', '0.00', '250 mg', 'Paracetamol'), 
('923', 'Feva   125 mg', '084-0142-006', 'Suppository', 'Ad-din Pharmaceuticals Ltd.', '4.00', '0.00', '125 mg', 'Paracetamol'), 
('924', 'Aldaben  DS   400 mg', '084-0028-008', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '4.00', '0.00', '400 mg', 'Albendazole'), 
('925', 'Alerjess   4 mg', '084-0030-21', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.20', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('926', 'Ciproxen   250 mg', '084-0034-23', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '7.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('927', 'Feva   500 mg', '084-0022-006', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.75', '0.00', '500 mg', 'Paracetamol'), 
('928', 'Metra   400 mg', '084-0029-27', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '1.05', '0.00', '400 mg', 'Metronidazole'), 
('929', 'Neofenac      50 mg', '084-0035-64', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.60', '0.00', '50 mg', 'Diclofenac Sodium'), 
('930', 'Ranitack      150 mg', '084-00365', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '1.50', '0.00', '150 mg', 'Ranitidine'), 
('931', 'Ciproxen   500 mg', '084-0038-23', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('932', 'Cirizin   10 mg', '084-0062-21', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('933', 'Gutset   10 mg', '084-00668', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('934', 'Calcium A   1250 mg', '084-0068-62', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.50', '0.00', '1250 mg', 'Calcium Carbonate'), 
('935', 'Fleco   100 mg', '084-0069-64', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.50', '0.00', '100 mg', 'Aceclofenac'), 
('936', 'Adrest   3 mg', '084-00737', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('937', 'Clozepam   .5 mg', '084-0074-046', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '.5 mg', 'Clonazepam'), 
('938', 'Adapen   10 mg', '084-00801', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('939', 'Cladin   10 mg', '084-0081-21', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.25', '0.00', '10 mg', 'Loratadine'), 
('940', 'Aldaben      200 mg', '084--008', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Albendazole'), 
('941', 'Cevozin      5 mg', '084-0072-21', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.00', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('942', 'Adlorin      5 mg', '084-0070-21', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.50', '0.00', '5 mg', 'Desloratadine'), 
('943', 'Toperol   200 mg', '084-0089-78', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Vitamin E'), 
('944', 'Guamin   850 mg', '084-0090', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '3.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('945', 'Onevit   100 mg', '084-0091-78', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.74', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('946', 'Sugred   80 mg', '084-0102', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '6.00', '0.00', '80 mg', 'Gliclazide'), 
('947', 'Vinzam   500 mg', '084-0108-23', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '25.00', '0.00', '500 mg', 'Azithromycin'), 
('948', 'Lacor   10 mg', '084-0110-064', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '9.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('949', 'Aslic   75 mg', '084-0112-26', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '75 mg', 'Aspirin'), 
('950', 'Avidol   6.25 mg', '084-0113-22', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '3.00', '0.00', '6.25 mg', 'Carvedilol'), 
('951', 'Cartace   2.5 mg', '084-0114-022', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '4.60', '0.00', '2.5 mg', 'Ramipril'), 
('952', 'Clogrel   75 mg', '084-0115-26', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '9.00', '0.00', '75 mg', 'Clopidogrel'), 
('953', 'Nopidin   5 mg', '084-0116-022', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '3.00', '0.00', '5 mg', 'Amlodipine'), 
('954', 'Prolol   50 mg', '084-0117-22', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '1.30', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('955', 'Ribomin   5 mg', '084-0118-79', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.23', '0.00', '5 mg', 'Riboflavin'), 
('956', 'Folate   5 mg', '084-01195', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.30', '0.00', '5 mg', 'Folic Acid'), 
('957', 'Relofen   10 mg', '084-0125-70', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '8.00', '0.00', '10 mg', 'Baclofen'), 
('958', 'Ultranax   500 mg', '084-0126-64', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '8.00', '0.00', '500 mg', 'Naproxen'), 
('959', 'Meczin   50 mg', '084-01298', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.50', '0.00', '50 mg', 'Meclizine Hydrochloride'), 
('960', 'Xofast   60 mg', '084-0131-21', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '3.50', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('961', 'Xofast   120 mg', '084-0132-21', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '6.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('962', 'Calonil   8 mg', '084-0162', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '1.00', '0.00', '8 mg', 'Sucralose'), 
('963', 'Pizobet   15 mg', '084-0137', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Pioglitazone'), 
('964', 'Vastor   10 mg', '084-0139-061', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('965', 'Nixpan   20 mg', '084-0134-67', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '3.00', '0.00', '20 mg', 'Pantoprazole'), 
('966', 'Nixpan   40 mg', '084-0135-67', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '5.00', '0.00', '40 mg', 'Pantoprazole'), 
('967', 'Glaryl   1 mg', '084-0149', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '2.50', '0.00', '1 mg', 'Glimepiride'), 
('968', 'Glaryl   2 mg', '084-0150', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '4.00', '0.00', '2 mg', 'Glimepiride'), 
('969', 'D-Met   500 mg', '084-0163', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('970', 'Atonul   50 mg', '084-0164-22', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Atenolol'), 
('971', 'Carlos   50 mg', '084-0165-022', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Losartan Potassium'), 
('972', 'Aroxia   60 mg', '084-0095-64', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '6.00', '0.00', '60 mg', 'Etoricoxib'), 
('973', 'Aroxia   90 mg', '084-0096-64', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '8.00', '0.00', '90 mg', 'Etoricoxib'), 
('974', 'Aroxia   120 mg', '084-0097-64', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '10.00', '0.00', '120 mg', 'Etoricoxib'), 
('975', 'Quiva   500 mg', '084-0098-23', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '13.00', '0.00', '500 mg', 'Levofloxacin'), 
('976', 'Tium   50 mg', '084-00991', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '3.50', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('977', 'Proxa-A   500 mg', '084-0100-27', 'Tablet', 'Ad-din Pharmaceuticals Ltd.', '9.00', '0.00', '500 mg', 'Nitazoxanide'), 
('978', 'Adrazin   100 %', '367-0015-077', 'Powder', 'Advent Pharma Ltd.', '0.00', '0.00', '100 %', 'Piperazine'), 
('979', 'Adrizol   600 mg', '367-0001-077', 'Bolus', 'Advent Pharma Ltd.', '0.00', '0.00', '600 mg', 'Albendazole'), 
('980', 'Adzyl   2 gm', '367-0002-077', 'Bolus', 'Advent Pharma Ltd.', '0.00', '0.00', '2 gm', 'Metronidazole'), 
('981', 'AD-Tetra   500 mg', '367-0003-077', 'Bolus', 'Advent Pharma Ltd.', '0.00', '0.00', '500 mg', 'Oxytetracycline'), 
('982', 'Adcet   2 gm', '367-0004-077', 'Bolus', 'Advent Pharma Ltd.', '0.00', '0.00', '2 gm', 'Paracetamol'), 
('983', 'Adprozin   150 mg', '367-0005-077', 'Bolus', 'Advent Pharma Ltd.', '0.00', '0.00', '150 mg', 'Promethazine Hydrochloride'), 
('984', 'Almolin Vet   30 %', '294-0006-077', 'Powder', 'Al-Madina Pharmaceuticals Ltd.', '235.83', '0.00', '30 %', 'Amoxicillin'), 
('985', 'Altetra   20 %', '294-0010-077', 'Powder', 'Al-Madina Pharmaceuticals Ltd.', '382.44', '0.00', '20 %', 'Oxytetracycline'), 
('986', 'Alcocci Pow Vet   30 %', '294-0019-077', 'Powder', 'Al-Madina Pharmaceuticals Ltd.', '40.62', '0.00', '30 %', 'Sulfaclozine'), 
('987', 'Alvasol   30 %', '294-0034-077', 'Powder', 'Al-Madina Pharmaceuticals Ltd.', '140.95', '0.00', '30 %', 'Levamisole'), 
('988', 'CS-Vet Plus Powder   500 Lac IU', '294-0060-077', 'Powder', 'Al-Madina Pharmaceuticals Ltd.', '710.00', '0.00', '500 Lac IU', 'Colistin Sulphate'), 
('989', 'Alcipro   Solution   10 gm', '294-0007-077', 'Solution', 'Al-Madina Pharmaceuticals Ltd.', '233.71', '0.00', '10 gm', 'Ciprofloxacin'), 
('990', 'Altetra   500 mg', '294-0009-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '3.01', '0.00', '500 mg', 'Oxytetracycline'), 
('991', 'Wormfree   600 mg', '294-0014-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '7.28', '0.00', '600 mg', 'Albendazole'), 
('992', 'Promethazine   150 mg', '294-0023-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '3.34', '0.00', '150 mg', 'Promethazine Hydrochloride'), 
('993', 'Amovet   2 gm', '294-0025-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '4.24', '0.00', '2 gm', 'Metronidazole'), 
('994', 'Alcipro   750 mg', '294-0035-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '20.01', '0.00', '750 mg', 'Ciprofloxacin'), 
('995', 'Al-molin Vet   500 mg', '294-0021-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '6.04', '0.00', '500 mg', 'Amoxicillin'), 
('996', 'Mexicam Bolus (Vet)   100 mg', '294-0047-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '6.00', '0.00', '100 mg', 'Meloxicam'), 
('997', 'Antifever Bolus (Vet)   2 gm', '294-0029-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '2.27', '0.00', '2 gm', 'Paracetamol'), 
('998', 'Sulmidine Bolus (Vet)   5 gm', '294-0031-077', 'Bolus', 'Al-Madina Pharmaceuticals Ltd.', '8.06', '0.00', '5 gm', 'Sulphadimidine'), 
('999', 'Albutil   2 mg', '096-00376', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '2 mg', 'Loperamide'), 
('1000', 'Mimox   250 mg', '096-0036-023', 'Capsule', 'Albion Laboratories Ltd.', '3.54', '0.00', '250 mg', 'Amoxicillin'), 
('1001', 'Amicap   250 mg', '096-0035-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Ampicillin'), 
('1002', 'Cefradine   500 mg', '096-0065-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('1003', 'Cephalexin   250 mg', '096-0066-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Cephalexin'), 
('1004', 'Mardox      100 mg', '096-0011-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('1005', 'Moxatid   250 mg', '096-0005-023', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('1006', 'Moxatid   500 mg', '096-0004-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('1007', 'Lotil   20 mg', '096-0067-67', 'Capsule', 'Albion Laboratories Ltd.', '2.95', '0.00', '20 mg', 'Omeprazole'), 
('1008', 'Tetracap   250 mg', '096-0034-23', 'Capsule', 'Albion Laboratories Ltd.', '0.80', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('1009', 'Albulil      100 mg', '096-0037-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('1010', 'Azithron   500 mg', '096-0103-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('1011', 'Lanzopra   15 mg', '096-0117-67', 'Capsule', 'Albion Laboratories Ltd.', '3.50', '0.00', '15 mg', 'Lansoprazole'), 
('1012', 'Fluconazole   50 mg', '096-0127', 'Capsule', 'Albion Laboratories Ltd.', '4.00', '0.00', '50 mg', 'Fluconazole'), 
('1013', 'Fluconazole   150 mg', '096-0126', 'Capsule', 'Albion Laboratories Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('1014', 'Lanzopra   30 mg', '096-0139-67', 'Capsule', 'Albion Laboratories Ltd.', '6.00', '0.00', '30 mg', 'Lansoprazole'), 
('1015', 'Cefpodoxime   100 mg', '096-0191-23', 'Capsule', 'Albion Laboratories Ltd.', '22.00', '0.00', '100 mg', 'Cefpodoxime'), 
('1016', 'Cefiac0   400 mg', '096-0143-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Cefixime'), 
('1017', 'Cepox   200 mg', '096-0148-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Cefpodoxime'), 
('1018', 'Fluoxetine   20 mg', '096-01984', 'Capsule', 'Albion Laboratories Ltd.', '2.58', '0.00', '20 mg', 'Fluoxetine'), 
('1019', 'Flurazepam   30 mg', '096-0260-057', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '30 mg', 'Flurazepam'), 
('1020', 'Esofour   20 mg', '096-0153-067', 'Capsule', 'Albion Laboratories Ltd.', '6.50', '0.00', '20 mg', 'Esomeprazole'), 
('1021', 'Pregabid   100 mg', '096-0298-046', 'Capsule', 'Albion Laboratories Ltd.', '22.00', '0.00', '100 mg', 'Pregabalin'), 
('1022', 'Pregabid   75 mg', '096-0299-046', 'Capsule', 'Albion Laboratories Ltd.', '16.07', '0.00', '75 mg', 'Pregabalin'), 
('1023', 'Cefiac   200 mg', '096-0120-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('1024', 'Pregabid   50 mg', '096-0324-046', 'Capsule', 'Albion Laboratories Ltd.', '11.00', '0.00', '50 mg', 'Pregabalin'), 
('1025', 'Cloxacillin DS   500 mg', '096-0060-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cloxacillin'), 
('1026', 'Alfux   250 mg', '096-0061-23', 'Capsule', 'Albion Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('1027', 'Pregabid   25 mg', '096-0366-046', 'Capsule', 'Albion Laboratories Ltd.', '7.50', '0.00', '25 mg', 'Pregabalin'), 
('1028', 'Indomethacin SR   75 mg', '096-0376-64', 'Capsule', 'Albion Laboratories Ltd.', '3.52', '0.00', '75 mg', 'Indomethacin'), 
('1029', 'Lowet   120 mg', '096-0382', 'Capsule', 'Albion Laboratories Ltd.', '55.00', '0.00', '120 mg', 'Orlistat'), 
('1030', 'Enofab   200 mg', '096-0391-61', 'Capsule', 'Albion Laboratories Ltd.', '7.00', '0.00', '200 mg', 'Fenofibrate'), 
('1031', 'Esofour   40 mg', '096-0399-067', 'Capsule', 'Albion Laboratories Ltd.', '9.00', '0.00', '40 mg', 'Esomeprazole'), 
('1032', 'Indomethacin   25 mg', '096-0113-64', 'Capsule', 'Albion Laboratories Ltd.', '0.60', '0.00', '25 mg', 'Indomethacin'), 
('1033', 'Burn Free   1 %', '096-0287-23', 'Cream', 'Albion Laboratories Ltd.', '35.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('1034', 'Veelac   68 %', '096-0042-60', 'Oral Solution', 'Albion Laboratories Ltd.', '0.00', '0.00', '68 %', 'Lactulose'), 
('1035', 'Sulphanilamide Vet   100 %', '096-0190-077', 'Powder', 'Albion Laboratories Ltd.', '0.00', '0.00', '100 %', 'Sulphanilamide'), 
('1036', 'Al-Lev Vet   30 %', '096-0205-077', 'Powder', 'Albion Laboratories Ltd.', '0.00', '0.00', '30 %', 'Levamisole'), 
('1037', 'Albi   30 %', '096-0270-07', 'Powder', 'Albion Laboratories Ltd.', '0.00', '0.00', '30 %', 'Sulfaclozine'), 
('1038', 'Amolium Vet   20 %', '096-0272-077', 'Powder', 'Albion Laboratories Ltd.', '196.10', '0.00', '20 %', 'Amprolium'), 
('1039', 'Nagavon Plus (Vet)   100 %', '096-0284-077', 'Powder', 'Albion Laboratories Ltd.', '35.00', '0.00', '100 %', 'Trichlorfon'), 
('1040', 'Mimox Vet   15 %', '096-0288-077', 'Powder', 'Albion Laboratories Ltd.', '0.00', '0.00', '15 %', 'Amoxicillin'), 
('1041', 'Mimox Powder Vet   30 %', '096-0315-077', 'Powder', 'Albion Laboratories Ltd.', '0.00', '0.00', '30 %', 'Amoxicillin'), 
('1042', 'tiamulin-Al Vet   45 %', '096-0318-077', 'Powder', 'Albion Laboratories Ltd.', '0.00', '0.00', '45 %', 'Tiamulin Hydrogen Fumerate'), 
('1043', 'Albi-Tasty Ispaghul   3.5 gm', '096-0266-60', 'Sachet', 'Albion Laboratories Ltd.', '4.00', '0.00', '3.5 gm', 'Ispaghula Husk'), 
('1044', 'Ciprofloxacin   500 mg', '096-0012-23', 'Tablet', 'Albion Laboratories Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('1045', 'Ciprofloxacin   250 mg', '096-0013-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('1046', 'Eryth   250 mg', '096-0007-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Erythromycin'), 
('1047', 'Eryth   500 mg', '096-0006-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('1048', 'Vitamin C     250 mg', '096-0053-78', 'Tablet', 'Albion Laboratories Ltd.', '0.82', '0.00', '250 mg', 'Vitamin C'), 
('1049', 'Boncal   1250 mg', '096-0018-62', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1050', 'Ranitidine   150 mg', '096-00925', 'Tablet', 'Albion Laboratories Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('1051', 'Rycin K   250 mg', '096-0090-23', 'Tablet', 'Albion Laboratories Ltd.', '1.54', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('1052', 'Griscofalvin   500 mg', '096-0089-23', 'Tablet', 'Albion Laboratories Ltd.', '5.56', '0.00', '500 mg', 'Phenoxymethyl Penicillin'), 
('1053', 'Domp   10 mg', '096-00938', 'Tablet', 'Albion Laboratories Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('1054', 'Alflam0   400 mg', '096-0091-64', 'Tablet', 'Albion Laboratories Ltd.', '1.42', '0.00', '400 mg', 'Ibuprofen'), 
('1055', 'Albiquin   300 mg', '096-0102-24', 'Tablet', 'Albion Laboratories Ltd.', '6.40', '0.00', '300 mg', 'Quinine Sulphate'), 
('1056', 'Albendazole-DS   400 mg', '096-0105-008', 'Tablet', 'Albion Laboratories Ltd.', '4.00', '0.00', '400 mg', 'Albendazole'), 
('1057', 'Aceclofenac   100 mg', '096-0108-64', 'Tablet', 'Albion Laboratories Ltd.', '2.50', '0.00', '100 mg', 'Aceclofenac'), 
('1058', 'Polyvit   200 mg', '096-0109-78', 'Tablet', 'Albion Laboratories Ltd.', '4.00', '0.00', '200 mg', 'Vitamin E'), 
('1059', 'Altapan   10 mg', '096-01151', 'Tablet', 'Albion Laboratories Ltd.', '1.83', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('1060', 'Nitram   5 mg', '096-0116-057', 'Tablet', 'Albion Laboratories Ltd.', '0.69', '0.00', '5 mg', 'Nitrazepam'), 
('1061', 'Pantoprazole   40 mg', '096-0128-67', 'Tablet', 'Albion Laboratories Ltd.', '5.00', '0.00', '40 mg', 'Pantoprazole'), 
('1062', 'Pantoprazole   20 mg', '096-0129-67', 'Tablet', 'Albion Laboratories Ltd.', '3.00', '0.00', '20 mg', 'Pantoprazole'), 
('1063', 'Atenolol   50 mg', '096-0130-22', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Atenolol'), 
('1064', 'Atenolol   100 mg', '096-0131-22', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Atenolol'), 
('1065', 'Losartan   25 mg', '096-0132-022', 'Tablet', 'Albion Laboratories Ltd.', '4.00', '0.00', '25 mg', 'Losartan Potassium'), 
('1066', 'Tanpot   50 mg', '096-0133-022', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Losartan Potassium'), 
('1067', 'Korac   10 mg', '096-0134-064', 'Tablet', 'Albion Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1068', 'Salbutamol   2 mg', '096-01354', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '2 mg', 'Salbutamol'), 
('1069', 'Salbutamol   4 mg', '096-01364', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '4 mg', 'Salbutamol'), 
('1070', 'Propranolol   10 mg', '096-0137-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Propranolol Hydrochloride'), 
('1071', 'Propranolol   40 mg', '096-0138-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '40 mg', 'Propranolol Hydrochloride'), 
('1072', 'Famotidine   20 mg', '096-01445', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Famotidine'), 
('1073', 'Famotidine   40 mg', '096-01455', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '40 mg', 'Famotidine'), 
('1074', 'Zium   10 mg', '096-01466', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Clobazam'), 
('1075', 'Ketoprofen   50 mg', '096-0147-64', 'Tablet', 'Albion Laboratories Ltd.', '3.50', '0.00', '50 mg', 'Ketoprofen'), 
('1076', 'Naproxen   500 mg', '096-0149-64', 'Tablet', 'Albion Laboratories Ltd.', '6.89', '0.00', '500 mg', 'Naproxen'), 
('1077', 'Naproxen   250 mg', '096-0150-64', 'Tablet', 'Albion Laboratories Ltd.', '4.00', '0.00', '250 mg', 'Naproxen'), 
('1078', 'Ketoprofen   100 mg', '096-0151-64', 'Tablet', 'Albion Laboratories Ltd.', '6.00', '0.00', '100 mg', 'Ketoprofen'), 
('1079', 'Aexidal   50 mg', '096-0152-21', 'Tablet', 'Albion Laboratories Ltd.', '2.00', '0.00', '50 mg', 'Mebhydrolin'), 
('1080', 'Etoricoxib   90 mg', '096-0164-64', 'Tablet', 'Albion Laboratories Ltd.', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('1081', 'Etoricoxib   60 mg', '096-0165-64', 'Tablet', 'Albion Laboratories Ltd.', '7.00', '0.00', '60 mg', 'Etoricoxib'), 
('1082', 'Rabeprazole   20 mg', '096-0166-67', 'Tablet', 'Albion Laboratories Ltd.', '5.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('1083', 'Amofast   10 mg', '096-0168-022', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Amlodipine'), 
('1084', 'Glibenol   5 mg', '096-0171', 'Tablet', 'Albion Laboratories Ltd.', '0.30', '0.00', '5 mg', 'Glibenclamide'), 
('1085', 'M-Fort   500 mg', '096-0172', 'Tablet', 'Albion Laboratories Ltd.', '3.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1086', 'Losartan   100 mg', '096-0173-022', 'Tablet', 'Albion Laboratories Ltd.', '10.00', '0.00', '100 mg', 'Losartan Potassium'), 
('1087', 'Diltiazem   30 mg', '096-0174-22', 'Tablet', 'Albion Laboratories Ltd.', '2.00', '0.00', '30 mg', 'Diltiazem Hydrochloride'), 
('1088', 'Diltiazem   60 mg', '096-0175-22', 'Tablet', 'Albion Laboratories Ltd.', '3.80', '0.00', '60 mg', 'Diltiazem Hydrochloride'), 
('1089', 'Allerge   120 mg', '096-0176-21', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('1090', 'Allerge   180 mg', '096-0177-21', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('1091', 'Brom   3 mg', '096-01787', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('1092', 'Etoricoxib   120 mg', '096-0179-64', 'Tablet', 'Albion Laboratories Ltd.', '14.00', '0.00', '120 mg', 'Etoricoxib'), 
('1093', 'Altovas   10 mg', '096-0180-061', 'Tablet', 'Albion Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('1094', 'Altovas   20 mg', '096-0181-061', 'Tablet', 'Albion Laboratories Ltd.', '18.00', '0.00', '20 mg', 'Atorvastatin'), 
('1095', 'Cefuxim   250 mg', '096-0182-23', 'Tablet', 'Albion Laboratories Ltd.', '7.00', '0.00', '250 mg', 'Cefuroxime'), 
('1096', 'Cefuxim   500 mg', '096-0183-23', 'Tablet', 'Albion Laboratories Ltd.', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('1097', 'Reptylin   10 mg', '096-01844', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Amitriptyline Hydrochloride'), 
('1098', 'Reptylin   25 mg', '096-01854', 'Tablet', 'Albion Laboratories Ltd.', '1.00', '0.00', '25 mg', 'Amitriptyline Hydrochloride'), 
('1099', 'Alprazol   .25 mg', '096-01867', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '.25 mg', 'Alprazolam'), 
('1100', 'M-Fort   850 mg', '096-0187', 'Tablet', 'Albion Laboratories Ltd.', '5.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('1101', 'Desloratadine   5 mg', '096-0196-21', 'Tablet', 'Albion Laboratories Ltd.', '2.50', '0.00', '5 mg', 'Desloratadine'), 
('1102', 'Albipen   10 mg', '096-0197-70', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Baclofen'), 
('1103', 'Alprazole   .5 mg', '096-01997', 'Tablet', 'Albion Laboratories Ltd.', '2.00', '0.00', '.5 mg', 'Alprazolam'), 
('1104', 'Haloperidol   5 mg', '096-0200-28', 'Tablet', 'Albion Laboratories Ltd.', '1.00', '0.00', '5 mg', 'Haloperidol'), 
('1105', 'Clonazepam   .5 mg', '096-0201-046', 'Tablet', 'Albion Laboratories Ltd.', '2.00', '0.00', '.5 mg', 'Clonazepam'), 
('1106', 'Cinnarizine   15 mg', '096-0202-21', 'Tablet', 'Albion Laboratories Ltd.', '1.00', '0.00', '15 mg', 'Cinnarizine'), 
('1107', 'Nifedipine   10 mg', '096-0203-22', 'Tablet', 'Albion Laboratories Ltd.', '0.34', '0.00', '10 mg', 'Nifedipine'), 
('1108', 'Gabapentin   300 mg', '096-0208-046', 'Tablet', 'Albion Laboratories Ltd.', '16.00', '0.00', '300 mg', 'Gabapentin'), 
('1109', 'Clonazepam   2 mg', '096-0210-046', 'Tablet', 'Albion Laboratories Ltd.', '4.00', '0.00', '2 mg', 'Clonazepam'), 
('1110', 'Glimepiride   1 mg', '096-0211', 'Tablet', 'Albion Laboratories Ltd.', '3.00', '0.00', '1 mg', 'Glimepiride'), 
('1111', 'Mebeverine   135 mg', '096-02121', 'Tablet', 'Albion Laboratories Ltd.', '6.00', '0.00', '135 mg', 'Mebeverine Hydrochloride'), 
('1112', 'Frusemide   40 mg', '096-02132', 'Tablet', 'Albion Laboratories Ltd.', '0.53', '0.00', '40 mg', 'Frusemide'), 
('1113', 'Azithromycin   500 mg', '096-0214-23', 'Tablet', 'Albion Laboratories Ltd.', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('1114', 'Aspirin   75 mg', '096-0224-26', 'Tablet', 'Albion Laboratories Ltd.', '0.50', '0.00', '75 mg', 'Aspirin'), 
('1115', 'Gabapentin   600 mg', '096-0225-046', 'Tablet', 'Albion Laboratories Ltd.', '30.00', '0.00', '600 mg', 'Gabapentin'), 
('1116', 'Lorazepam   1 mg', '096-02267', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '1 mg', 'Lorazepam'), 
('1117', 'Aspirin   300 mg', '096-0227-6', 'Tablet', 'Albion Laboratories Ltd.', '1.07', '0.00', '300 mg', 'Aspirin'), 
('1118', 'Terbinafine   250 mg', '096-0228', 'Tablet', 'Albion Laboratories Ltd.', '50.00', '0.00', '250 mg', 'Terbinafine'), 
('1119', 'Enalapril   5 mg', '096-0229-22', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Enalapril Maleate'), 
('1120', 'Enalapril   10 mg', '096-0230-22', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Enalapril Maleate'), 
('1121', 'Bisacodyl   5 mg', '096-0232-60', 'Tablet', 'Albion Laboratories Ltd.', '0.70', '0.00', '5 mg', 'Bisacodyl'), 
('1122', 'Glimepiride   2 mg', '096-0233', 'Tablet', 'Albion Laboratories Ltd.', '5.01', '0.00', '2 mg', 'Glimepiride'), 
('1123', 'Phenobarbital   30 mg', '096-0234-046', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '30 mg', 'Phenobarbitone'), 
('1124', 'Phenobarbital   60 mg', '096-0235-046', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '60 mg', 'Phenobarbitone'), 
('1125', 'Metronidazole   200 mg', '096-0257-27', 'Tablet', 'Albion Laboratories Ltd.', '0.67', '0.00', '200 mg', 'Metronidazole'), 
('1126', 'Vitamin B1   100 mg', '096-0258-78', 'Tablet', 'Albion Laboratories Ltd.', '0.74', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('1127', 'Phenobarbital   15 mg', '096-0262-046', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '15 mg', 'Phenobarbitone'), 
('1128', 'Captopril   25 mg', '096-0263-22', 'Tablet', 'Albion Laboratories Ltd.', '3.00', '0.00', '25 mg', 'Captopril'), 
('1129', 'Simvastatin   10 mg', '096-0265-61', 'Tablet', 'Albion Laboratories Ltd.', '15.00', '0.00', '10 mg', 'Simvastatin'), 
('1130', 'Verapamil   80 mg', '096-0267-22', 'Tablet', 'Albion Laboratories Ltd.', '3.00', '0.00', '80 mg', 'Verapamil Hydrochloride'), 
('1131', 'Dexibuprofen   300 mg', '096-0269-64', 'Tablet', 'Albion Laboratories Ltd.', '4.00', '0.00', '300 mg', 'Dexibuprofen (S Ibuprofen)'), 
('1132', 'Esofour   20 mg', '096-0157-067', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('1133', 'Esofour   40 mg', '096-0274-67', 'Tablet', 'Albion Laboratories Ltd.', '7.00', '0.00', '40 mg', 'Esomeprazole'), 
('1134', 'Altason   5 mg', '096-0276-72', 'Tablet', 'Albion Laboratories Ltd.', '1.14', '0.00', '5 mg', 'Prednisolone'), 
('1135', 'Altason   10 mg', '096-0277-72', 'Tablet', 'Albion Laboratories Ltd.', '2.07', '0.00', '10 mg', 'Prednisolone'), 
('1136', 'Altason   20 mg', '096-0278-72', 'Tablet', 'Albion Laboratories Ltd.', '3.73', '0.00', '20 mg', 'Prednisolone'), 
('1137', 'Dexamethasone   .5 mg', '096-0279-72', 'Tablet', 'Albion Laboratories Ltd.', '1.00', '0.00', '.5 mg', 'Dexamethasone'), 
('1138', 'Trazapin   15 mg', '096-02974', 'Tablet', 'Albion Laboratories Ltd.', '8.00', '0.00', '15 mg', 'Mirtazapine'), 
('1139', 'Amofast   5 mg', '096-0162-022', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Amlodipine'), 
('1140', 'Monkon   4 mg', '096-0301-044', 'Tablet', 'Albion Laboratories Ltd.', '7.00', '0.00', '4 mg', 'Montelukast'), 
('1141', 'Sparfloxacin   200 mg', '096-0302-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Sparfloxacin'), 
('1142', 'Epram   5 mg', '096-03064', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Escitalopram'), 
('1143', 'Rozavas   10 mg', '096-0307-61', 'Tablet', 'Albion Laboratories Ltd.', '18.00', '0.00', '10 mg', 'Rosuvastatin'), 
('1144', 'Tadalafil   20 mg', '096-0309-043', 'Tablet', 'Albion Laboratories Ltd.', '60.00', '0.00', '20 mg', 'Tadalafil'), 
('1145', 'Powergra   50 mg', '096-0310-043', 'Tablet', 'Albion Laboratories Ltd.', '30.00', '0.00', '50 mg', 'Sildenafil'), 
('1146', 'Powergra   100 mg', '096-0311-043', 'Tablet', 'Albion Laboratories Ltd.', '50.00', '0.00', '100 mg', 'Sildenafil'), 
('1147', 'Cilmox0   500 mg', '096-0102-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('1148', 'Cilmox   250 mg', '096-0101-23', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('1149', 'Epival   200 mg', '096-03196', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Sodium Valproate'), 
('1150', 'Clozapin   25 mg', '096-03204', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '25 mg', 'Clozapine'), 
('1151', 'Lithium SR   400 mg', '096-0321-28', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Lithium Carbonate'), 
('1152', 'Livacor   300 mg', '096-0322', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '300 mg', 'Ursodeoxycholic Acid'), 
('1153', 'Rislock   2 mg', '096-0323-28', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '2 mg', 'Risperidone'), 
('1154', 'Glirol   80 mg', '096-0160', 'Tablet', 'Albion Laboratories Ltd.', '6.00', '0.00', '80 mg', 'Gliclazide'), 
('1155', 'Diazepam   5 mg', '096-0163-057', 'Tablet', 'Albion Laboratories Ltd.', '0.69', '0.00', '5 mg', 'Diazepam'), 
('1156', 'Rozavas   5 mg', '096-0325-61', 'Tablet', 'Albion Laboratories Ltd.', '8.00', '0.00', '5 mg', 'Rosuvastatin'), 
('1157', 'Epram   10 mg', '096-03264', 'Tablet', 'Albion Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Escitalopram'), 
('1158', 'Olme   40 mg', '096-0327-22', 'Tablet', 'Albion Laboratories Ltd.', '15.00', '0.00', '40 mg', 'Olmesartan Medoxomil'), 
('1159', 'Olme   20 mg', '096-0328-22', 'Tablet', 'Albion Laboratories Ltd.', '8.00', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('1160', 'Livacor   150 mg', '096-0329', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '150 mg', 'Ursodeoxycholic Acid'), 
('1161', 'Rislock   4 mg', '096-0331-28', 'Tablet', 'Albion Laboratories Ltd.', '9.00', '0.00', '4 mg', 'Risperidone'), 
('1162', 'Olanza   10 mg', '096-0333-28', 'Tablet', 'Albion Laboratories Ltd.', '4.52', '0.00', '10 mg', 'Olanzapine'), 
('1163', 'Quetinil   100 mg', '096-0334-28', 'Tablet', 'Albion Laboratories Ltd.', '10.50', '0.00', '100 mg', 'Quetiapine'), 
('1164', 'Sertlin   50 mg', '096-03354', 'Tablet', 'Albion Laboratories Ltd.', '6.00', '0.00', '50 mg', 'Sertraline'), 
('1165', 'Rislock   1 mg', '096-0337-28', 'Tablet', 'Albion Laboratories Ltd.', '3.00', '0.00', '1 mg', 'Risperidone'), 
('1166', 'Epival Chrono CR   300 mg', '096-03386', 'Tablet', 'Albion Laboratories Ltd.', '7.00', '0.00', '300 mg', 'Sodium Valproate'), 
('1167', 'Epival Chrono0 CR   500 mg', '096-03396', 'Tablet', 'Albion Laboratories Ltd.', '11.00', '0.00', '500 mg', 'Sodium Valproate'), 
('1168', 'Clozapin   100 mg', '096-03424', 'Tablet', 'Albion Laboratories Ltd.', '9.55', '0.00', '100 mg', 'Clozapine'), 
('1169', 'Osteonil   150 mg', '096-0347-048', 'Tablet', 'Albion Laboratories Ltd.', '1500.00', '0.00', '150 mg', 'Ibandronic Acid'), 
('1170', 'Olme   10 mg', '096-0348-22', 'Tablet', 'Albion Laboratories Ltd.', '5.00', '0.00', '10 mg', 'Olmesartan Medoxomil'), 
('1171', 'Monkon   10 mg', '096-0349-044', 'Tablet', 'Albion Laboratories Ltd.', '15.05', '0.00', '10 mg', 'Montelukast'), 
('1172', 'Sertlin   25 mg', '096-03504', 'Tablet', 'Albion Laboratories Ltd.', '3.00', '0.00', '25 mg', 'Sertraline'), 
('1173', 'Sertlin0   100 mg', '096-03514', 'Tablet', 'Albion Laboratories Ltd.', '10.00', '0.00', '100 mg', 'Sertraline'), 
('1174', 'Quetinil   25 mg', '096-0352-28', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '25 mg', 'Quetiapine'), 
('1175', 'Olanza   5 mg', '096-0353-28', 'Tablet', 'Albion Laboratories Ltd.', '2.55', '0.00', '5 mg', 'Olanzapine'), 
('1176', 'Plator   75 mg', '096-0355-26', 'Tablet', 'Albion Laboratories Ltd.', '9.00', '0.00', '75 mg', 'Clopidogrel'), 
('1177', 'Reclevus0 F. C   50 mg', '096-0363', 'Tablet', 'Albion Laboratories Ltd.', '17.50', '0.00', '50 mg', 'Vildagliptin'), 
('1178', 'Monkon   5 mg', '096-0367-044', 'Tablet', 'Albion Laboratories Ltd.', '8.00', '0.00', '5 mg', 'Montelukast'), 
('1179', 'Isolol   2.5 mg', '096-0368-22', 'Tablet', 'Albion Laboratories Ltd.', '6.02', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('1180', 'Isolol F.C   5 mg', '096-0369-22', 'Tablet', 'Albion Laboratories Ltd.', '10.00', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('1181', 'Inco SR   1.5 mg', '096-03702', 'Tablet', 'Albion Laboratories Ltd.', '5.00', '0.00', '1.5 mg', 'Indapamide'), 
('1182', 'Bpcare   80 mg', '096-0371-22', 'Tablet', 'Albion Laboratories Ltd.', '10.00', '0.00', '80 mg', 'Valsartan'), 
('1183', 'Felo   5 mg', '096-0372-70', 'Tablet', 'Albion Laboratories Ltd.', '4.52', '0.00', '5 mg', 'Baclofen'), 
('1184', 'Bpcare   160 mg', '096-0373-22', 'Tablet', 'Albion Laboratories Ltd.', '17.50', '0.00', '160 mg', 'Valsartan'), 
('1185', 'Floxtat   40 mg', '096-0379-76', 'Tablet', 'Albion Laboratories Ltd.', '12.00', '0.00', '40 mg', 'Febuxostat'), 
('1186', 'N-Aspa   40 mg', '096-01541', 'Tablet', 'Albion Laboratories Ltd.', '1.81', '0.00', '40 mg', 'Drotaverine Hydrochloride'), 
('1187', 'Trazapin   30 mg', '096-03854', 'Tablet', 'Albion Laboratories Ltd.', '15.00', '0.00', '30 mg', 'Mirtazapine'), 
('1188', 'Cetirizine Tablet   10 mg', '096-0094-21', 'Tablet', 'Albion Laboratories Ltd.', '2.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1189', 'Trazapin   7.5 mg', '096-03884', 'Tablet', 'Albion Laboratories Ltd.', '6.00', '0.00', '7.5 mg', 'Mirtazapine'), 
('1190', 'Antevir   .5 mg', '096-0392-32', 'Tablet', 'Albion Laboratories Ltd.', '45.00', '0.00', '.5 mg', 'Entecavir'), 
('1191', 'Oxipine   300 mg', '096-0393-046', 'Tablet', 'Albion Laboratories Ltd.', '11.00', '0.00', '300 mg', 'Oxcarbazepine'), 
('1192', 'Albizox   500 mg', '096-0396-27', 'Tablet', 'Albion Laboratories Ltd.', '9.00', '0.00', '500 mg', 'Nitazoxanide'), 
('1193', 'Tysul   50 mg', '096-0411-011', 'Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('1194', 'Para-AL Vet   2 gm', '096-0188-077', 'Bolus', 'Albion Laboratories Ltd.', '2.25', '0.00', '2 gm', 'Paracetamol'), 
('1195', 'Oxytetracin   500 mg', '096-0189-077', 'Bolus', 'Albion Laboratories Ltd.', '3.00', '0.00', '500 mg', 'Oxytetracycline'), 
('1196', 'Bendol-Al   600 mg', '096-0192-077', 'Bolus', 'Albion Laboratories Ltd.', '0.00', '0.00', '600 mg', 'Albendazole'), 
('1197', 'AL-Lev Vet   600 mg', '096-0194-077', 'Bolus', 'Albion Laboratories Ltd.', '0.00', '0.00', '600 mg', 'Levamisole'), 
('1198', 'Al-Metro   2 gm', '096-0206-077', 'Bolus', 'Albion Laboratories Ltd.', '0.00', '0.00', '2 gm', 'Metronidazole'), 
('1199', 'Ciptec-Al Vet   750 mg', '096-0221-077', 'Bolus', 'Albion Laboratories Ltd.', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('1200', 'Fenbendazole   250 mg', '096-0238-077', 'Bolus', 'Albion Laboratories Ltd.', '5.75', '0.00', '250 mg', 'Fenbendazole'), 
('1201', 'Dexason-Vet   10 mg', '096-0295-077', 'Bolus', 'Albion Laboratories Ltd.', '4.38', '0.00', '10 mg', 'Dexamethasone'), 
('1202', 'Meloxicam Vet   100 mg', '096-0296-077', 'Bolus', 'Albion Laboratories Ltd.', '6.00', '0.00', '100 mg', 'Meloxicam'), 
('1203', 'Prom-Al Vet   150 mg', '096-0340-077', 'Bolus', 'Albion Laboratories Ltd.', '3.32', '0.00', '150 mg', 'Promethazine Hydrochloride'), 
('1204', 'Ciptec-Al Vet   1 gm', '096-0341-077', 'Bolus', 'Albion Laboratories Ltd.', '20.08', '0.00', '1 gm', 'Ciprofloxacin'), 
('1205', 'Mimox Vet   500 mg', '096-0357-077', 'Bolus', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('1206', 'AL-KETO VET   400 mg', '096-0375-077', 'Bolus', 'Albion Laboratories Ltd.', '9.00', '0.00', '400 mg', 'Ketoprofen'), 
('1207', 'Sulnid (Vet)   5 gm', '096-0378-077', 'Bolus', 'Albion Laboratories Ltd.', '9.68', '0.00', '5 gm', 'Sulphadimidine'), 
('1208', 'Forticef gm IM   1 gm', '096-0401-23', 'IM Injection', 'Albion Laboratories Ltd.', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('1209', 'Forticef gm IV   1 gm', '096-0404-23', 'IV Injection', 'Albion Laboratories Ltd.', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('1210', 'M-Fort XR   500 mg', '096-0215', 'Xr Tablet', 'Albion Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1211', 'Staflu   500 mg', '272-0079-23', 'Capsule', 'Alco Pharma Limited', '10.57', '0.00', '500 mg', 'Flucloxacillin'), 
('1212', 'Cepdoxim      100 mg', '272-0086-23', 'Capsule', 'Alco Pharma Limited', '20.06', '0.00', '100 mg', 'Cefpodoxime'), 
('1213', 'Coxib      100 mg', '272-0053-064', 'Capsule', 'Alco Pharma Limited', '4.06', '0.00', '100 mg', 'Celecoxib'), 
('1214', 'Coxib      200 mg', '272-0052-064', 'Capsule', 'Alco Pharma Limited', '7.07', '0.00', '200 mg', 'Celecoxib'), 
('1215', 'Darma      150 mg', '272-0126', 'Capsule', 'Alco Pharma Limited', '8.02', '0.00', '150 mg', 'Fluconazole'), 
('1216', 'Derma      50 mg', '272-0125', 'Capsule', 'Alco Pharma Limited', '0.00', '0.00', '50 mg', 'Fluconazole'), 
('1217', 'Doxcline      100 mg', '272-0128-23', 'Capsule', 'Alco Pharma Limited', '2.01', '0.00', '100 mg', 'Doxycycline'), 
('1218', 'Staflu   250 mg', '272-0049-23', 'Capsule', 'Alco Pharma Limited', '5.79', '0.00', '250 mg', 'Flucloxacillin'), 
('1219', 'Lanopra   15 mg', '272-0058-67', 'Capsule', 'Alco Pharma Limited', '0.00', '0.00', '15 mg', 'Lansoprazole'), 
('1220', 'Lanopra   30 mg', '272-0059-67', 'Capsule', 'Alco Pharma Limited', '0.00', '0.00', '30 mg', 'Lansoprazole'), 
('1221', 'Omepra      20 mg', '272-0047-67', 'Capsule', 'Alco Pharma Limited', '4.01', '0.00', '20 mg', 'Omeprazole'), 
('1222', 'Omepra      40 mg', '272-0048-67', 'Capsule', 'Alco Pharma Limited', '7.02', '0.00', '40 mg', 'Omeprazole'), 
('1223', 'Pendol      50 mg', '272-0113-65', 'Capsule', 'Alco Pharma Limited', '6.02', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('1224', 'Proladin  TR    100 mg', '272-0045-64', 'Capsule', 'Alco Pharma Limited', '3.01', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1225', 'Esopra   20 mg', '272-0240-067', 'Capsule', 'Alco Pharma Limited', '6.02', '0.00', '20 mg', 'Esomeprazole'), 
('1226', 'Esopra   40 mg', '272-0241-067', 'Capsule', 'Alco Pharma Limited', '9.03', '0.00', '40 mg', 'Esomeprazole'), 
('1227', 'Oticef   250 mg', '272-0256-23', 'Capsule', 'Alco Pharma Limited', '0.00', '0.00', '250 mg', 'Cefaclor'), 
('1228', 'Oticef   500 mg', '272-0257-23', 'Capsule', 'Alco Pharma Limited', '40.12', '0.00', '500 mg', 'Cefaclor'), 
('1229', 'Desopra   30 mg', '272-0269-67', 'Capsule', 'Alco Pharma Limited', '10.00', '0.00', '30 mg', 'Dexlansoprazole'), 
('1230', 'Maxclin   300 mg', '272-0271-23', 'Capsule', 'Alco Pharma Limited', '15.00', '0.00', '300 mg', 'Clindamycin'), 
('1231', 'Maxclin   150 mg', '272-0270-23', 'Capsule', 'Alco Pharma Limited', '8.00', '0.00', '150 mg', 'Clindamycin'), 
('1232', 'Acipra   20 mg', '272-0280-067', 'Capsule', 'Alco Pharma Limited', '0.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('1233', 'Dazine   1 %', '272-0042-23', 'Cream', 'Alco Pharma Limited', '50.15', '0.00', '1 %', 'Silver Sulphadiazine'), 
('1234', 'Water for Injection   10 ml', '272-0254-79', 'Injection', 'Alco Pharma Limited', '0.00', '0.00', '10 ml', 'Water For Injection'), 
('1235', 'Leaxe   68 %', '272-0211-60', 'Oral Solution', 'Alco Pharma Limited', '140.42', '0.00', '68 %', 'Lactulose'), 
('1236', 'Aclo   100 mg', '272-0109-64', 'Tablet', 'Alco Pharma Limited', '3.01', '0.00', '100 mg', 'Aceclofenac'), 
('1237', 'Alagra   120 mg', '272-0100-21', 'Tablet', 'Alco Pharma Limited', '6.02', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('1238', 'Alagra   30 mg', '272-0099-21', 'Tablet', 'Alco Pharma Limited', '3.01', '0.00', '30 mg', 'Fexofenadine Hydrochloride'), 
('1239', 'Alagra   180 mg', '272-0101-21', 'Tablet', 'Alco Pharma Limited', '8.53', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('1240', 'Aloquin   300 mg', '272-0074-24', 'Tablet', 'Alco Pharma Limited', '3.41', '0.00', '300 mg', 'Quinine Sulphate'), 
('1241', 'Amdin   10 mg', '272-0133-022', 'Tablet', 'Alco Pharma Limited', '6.02', '0.00', '10 mg', 'Amlodipine'), 
('1242', 'Amdin      5 mg', '272-0132-022', 'Tablet', 'Alco Pharma Limited', '4.01', '0.00', '5 mg', 'Amlodipine'), 
('1243', 'Atovin   10 mg', '272-0091-061', 'Tablet', 'Alco Pharma Limited', '10.03', '0.00', '10 mg', 'Atorvastatin'), 
('1244', 'Axetil   125 mg', '272-0111-23', 'Tablet', 'Alco Pharma Limited', '12.04', '0.00', '125 mg', 'Cefuroxime'), 
('1245', 'Axetil   250 mg', '272-0110-23', 'Tablet', 'Alco Pharma Limited', '25.08', '0.00', '250 mg', 'Cefuroxime'), 
('1246', 'B One      100 mg', '272-0127-78', 'Tablet', 'Alco Pharma Limited', '0.74', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('1247', 'Brolyt   8 mg', '272-0083-031', 'Tablet', 'Alco Pharma Limited', '1.00', '0.00', '8 mg', 'Bromhexine Hydrochloride'), 
('1248', 'Brozep   3 mg', '272-01317', 'Tablet', 'Alco Pharma Limited', '5.00', '0.00', '3 mg', 'Bromazepam'), 
('1249', 'Butastat   10 mg', '272-00011', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('1250', 'Calmi0   1250 mg', '272-0051-62', 'Tablet', 'Alco Pharma Limited', '4.01', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1251', 'Cardilock      50 mg', '272-0002-22', 'Tablet', 'Alco Pharma Limited', '0.77', '0.00', '50 mg', 'Atenolol'), 
('1252', 'Chuben DS   400 mg', '272-0032-008', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '400 mg', 'Albendazole'), 
('1253', 'Derfin   250 mg', '272-0103', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '250 mg', 'Terbinafine'), 
('1254', 'Diaprid   80 mg', '272-0084', 'Tablet', 'Alco Pharma Limited', '6.02', '0.00', '80 mg', 'Gliclazide'), 
('1255', 'Diben      5 mg', '272-0081', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '5 mg', 'Glibenclamide'), 
('1256', 'Dompi   10 mg', '272-00768', 'Tablet', 'Alco Pharma Limited', '2.01', '0.00', '10 mg', 'Domperidone'), 
('1257', 'Ery   500 mg', '272-0097-23', 'Tablet', 'Alco Pharma Limited', '10.33', '0.00', '500 mg', 'Erythromycin'), 
('1258', 'Ery   250 mg', '272-0071-23', 'Tablet', 'Alco Pharma Limited', '5.17', '0.00', '250 mg', 'Erythromycin'), 
('1259', 'Esopra      20 mg', '272-0104-067', 'Tablet', 'Alco Pharma Limited', '4.01', '0.00', '20 mg', 'Esomeprazole'), 
('1260', 'Hyquin   200 mg', '272-0085-24', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '200 mg', 'Hydroxychloroquine Sulphate'), 
('1261', 'Lamidin   100 mg', '272-0063-32', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '100 mg', 'Lamivudine'), 
('1262', 'Leflu      20 mg', '272-0094-64', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '20 mg', 'Leflunomide'), 
('1263', 'Leflu      100 mg', '272-0095-64', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '100 mg', 'Leflunomide'), 
('1264', 'Leoflox   250 mg', '272-0105-23', 'Tablet', 'Alco Pharma Limited', '7.02', '0.00', '250 mg', 'Levofloxacin'), 
('1265', 'Leoflox   500 mg', '272-0075-23', 'Tablet', 'Alco Pharma Limited', '15.05', '0.00', '500 mg', 'Levofloxacin'), 
('1266', 'Losa      50 mg', '272-0055-022', 'Tablet', 'Alco Pharma Limited', '6.02', '0.00', '50 mg', 'Losartan Potassium'), 
('1267', 'Losa      25 mg', '272-0106-022', 'Tablet', 'Alco Pharma Limited', '3.51', '0.00', '25 mg', 'Losartan Potassium'), 
('1268', 'Metmin   850 mg', '272-0080', 'Tablet', 'Alco Pharma Limited', '4.01', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('1269', 'Mokast   10 mg', '272-0090-044', 'Tablet', 'Alco Pharma Limited', '10.03', '0.00', '10 mg', 'Montelukast'), 
('1270', 'Nidraj   10 mg', '272-01367', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '10 mg', 'Zolpidem Tartrate'), 
('1271', 'Noler   10 mg', '272-0033-21', 'Tablet', 'Alco Pharma Limited', '2.51', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1272', 'Ordex   .5 mg', '272-0129-72', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '.5 mg', 'Dexamethasone'), 
('1273', 'Pantopra      20 mg', '272-0069-67', 'Tablet', 'Alco Pharma Limited', '3.01', '0.00', '20 mg', 'Pantoprazole'), 
('1274', 'Pantopra      40 mg', '272-0070-67', 'Tablet', 'Alco Pharma Limited', '5.02', '0.00', '40 mg', 'Pantoprazole'), 
('1275', 'Piolit   15 mg', '272-0089', 'Tablet', 'Alco Pharma Limited', '8.02', '0.00', '15 mg', 'Pioglitazone'), 
('1276', 'Repaglid   2 mg', '272-0088-015', 'Tablet', 'Alco Pharma Limited', '5.02', '0.00', '2 mg', 'Repaglinide'), 
('1277', 'Repaglid   1 mg', '272-0087-015', 'Tablet', 'Alco Pharma Limited', '3.01', '0.00', '1 mg', 'Repaglinide'), 
('1278', 'Roxcin      150 mg', '272-0067-23', 'Tablet', 'Alco Pharma Limited', '7.02', '0.00', '150 mg', 'Roxithromycin'), 
('1279', 'Dumaflox   750 mg', '272-0066-23', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('1280', 'Sparflox      200 mg', '272-0054-23', 'Tablet', 'Alco Pharma Limited', '16.05', '0.00', '200 mg', 'Sparfloxacin'), 
('1281', 'Leflu   10 mg', '272-0093-64', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '10 mg', 'Leflunomide'), 
('1282', 'Arinet   50 mg', '272-0174-24', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '50 mg', 'Artesunate'), 
('1283', 'Sunil   100 mg', '272-0173-64', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '100 mg', 'Sulindac'), 
('1284', 'Ecox   60 mg', '272-0167-64', 'Tablet', 'Alco Pharma Limited', '7.02', '0.00', '60 mg', 'Etoricoxib'), 
('1285', 'Ecox   90 mg', '272-0168-64', 'Tablet', 'Alco Pharma Limited', '12.04', '0.00', '90 mg', 'Etoricoxib'), 
('1286', 'Zinex   250 mg', '272-0149-23', 'Tablet', 'Alco Pharma Limited', '20.06', '0.00', '250 mg', 'Azithromycin'), 
('1287', 'Zinex   500 mg', '272-0150-23', 'Tablet', 'Alco Pharma Limited', '30.09', '0.00', '500 mg', 'Azithromycin'), 
('1288', 'Erycin   250 mg', '272--23', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '250 mg', 'Erythromycin'), 
('1289', 'Clopidol      75 mg', '272-0162-26', 'Tablet', 'Alco Pharma Limited', '10.03', '0.00', '75 mg', 'Clopidogrel'), 
('1290', 'Aloran   5 mg', '272-0123-21', 'Tablet', 'Alco Pharma Limited', '2.51', '0.00', '5 mg', 'Desloratadine'), 
('1291', 'Flampen   400 mg', '272-0143-64', 'Tablet', 'Alco Pharma Limited', '1.30', '0.00', '400 mg', 'Ibuprofen'), 
('1292', 'Linezol   400 mg', '272--023', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '400 mg', 'Linezolid'), 
('1293', 'Linezol   600 mg', '272--023', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '600 mg', 'Linezolid'), 
('1294', 'Roxcin0   300 mg', '272-0068-23', 'Tablet', 'Alco Pharma Limited', '14.04', '0.00', '300 mg', 'Roxithromycin'), 
('1295', 'Zalukast      20 mg', '272-00924', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '20 mg', 'Zafirlukast'), 
('1296', 'Malaquin0   300 mg', '272-0074-24', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '300 mg', 'Quinine Sulphate'), 
('1297', 'Napren   250 mg', '272-0158-64', 'Tablet', 'Alco Pharma Limited', '5.02', '0.00', '250 mg', 'Naproxen'), 
('1298', 'Brolyt   4 mg', '272-0082-031', 'Tablet', 'Alco Pharma Limited', '0.70', '0.00', '4 mg', 'Bromhexine Hydrochloride'), 
('1299', 'Levocet   5 mg', '272-0114-21', 'Tablet', 'Alco Pharma Limited', '2.01', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('1300', 'Ornizol   500 mg', '272--27', 'Tablet', 'Alco Pharma Limited', '6.02', '0.00', '500 mg', 'Ornidazole'), 
('1301', 'Emulyt   30 mg', '272-0190-31', 'Tablet', 'Alco Pharma Limited', '1.76', '0.00', '30 mg', 'Ambroxol'), 
('1302', 'Dip0      200 mg', '272-0177-64', 'Tablet', 'Alco Pharma Limited', '3.01', '0.00', '200 mg', 'Dexibuprofen (S Ibuprofen)'), 
('1303', 'Dip0   400 mg', '272-0178-64', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '400 mg', 'Dexibuprofen (S Ibuprofen)'), 
('1304', 'Dirin   10 mg', '272-01831', 'Tablet', 'Alco Pharma Limited', '2.01', '0.00', '10 mg', 'Dicycloverine Hydrochloride'), 
('1305', 'Eprin      75 mg', '272-0187-26', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '75 mg', 'Aspirin'), 
('1306', 'Gipid   1 mg', '272-0141', 'Tablet', 'Alco Pharma Limited', '3.01', '0.00', '1 mg', 'Glimepiride'), 
('1307', 'Gipid   2 mg', '272-0142', 'Tablet', 'Alco Pharma Limited', '5.02', '0.00', '2 mg', 'Glimepiride'), 
('1308', 'Lebrod   1 mg', '272-01944', 'Tablet', 'Alco Pharma Limited', '0.75', '0.00', '1 mg', 'Levosalbutamol'), 
('1309', 'Lebrod   2 mg', '272-01954', 'Tablet', 'Alco Pharma Limited', '1.40', '0.00', '2 mg', 'Levosalbutamol'), 
('1310', 'Zenc  DT    20 mg', '272-0206-62', 'Tablet', 'Alco Pharma Limited', '1.75', '0.00', '20 mg', 'Zinc'), 
('1311', 'Adnix   500 mg', '272-0204-27', 'Tablet', 'Alco Pharma Limited', '10.03', '0.00', '500 mg', 'Nitazoxanide'), 
('1312', 'Tolec   10 mg', '272-0210-064', 'Tablet', 'Alco Pharma Limited', '10.03', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1313', 'Tiemo   50 mg', '272-02121', 'Tablet', 'Alco Pharma Limited', '4.01', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('1314', 'Nic   2 mg', '272-0213-37', 'Tablet', 'Alco Pharma Limited', '5.02', '0.00', '2 mg', 'Nicotine'), 
('1315', 'Alagra   60 mg', '272-0216-21', 'Tablet', 'Alco Pharma Limited', '3.51', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('1316', 'Ecox   120 mg', '272-0226-64', 'Tablet', 'Alco Pharma Limited', '14.04', '0.00', '120 mg', 'Etoricoxib'), 
('1317', 'Napren0   500 mg', '272-0228-64', 'Tablet', 'Alco Pharma Limited', '9.03', '0.00', '500 mg', 'Naproxen'), 
('1318', 'Epizam.5   .5 mg', '272-0232-046', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '.5 mg', 'Clonazepam'), 
('1319', 'X-cite   50 mg', '272-0233-043', 'Tablet', 'Alco Pharma Limited', '3.09', '0.00', '50 mg', 'Sildenafil'), 
('1320', 'Viev   10 mg', '272-0234-043', 'Tablet', 'Alco Pharma Limited', '35.11', '0.00', '10 mg', 'Tadalafil'), 
('1321', 'Vertig   5 mg', '272-02357', 'Tablet', 'Alco Pharma Limited', '3.51', '0.00', '5 mg', 'Flunarizine'), 
('1322', 'Vertig   10 mg', '272-02367', 'Tablet', 'Alco Pharma Limited', '5.02', '0.00', '10 mg', 'Flunarizine'), 
('1323', 'X-Cite   100 mg', '272-0238-043', 'Tablet', 'Alco Pharma Limited', '50.15', '0.00', '100 mg', 'Sildenafil'), 
('1324', 'Viev   20 mg', '272-0239-043', 'Tablet', 'Alco Pharma Limited', '50.15', '0.00', '20 mg', 'Tadalafil'), 
('1325', 'Geminy 320   320 mg', '272-0237-23', 'Tablet', 'Alco Pharma Limited', '60.00', '0.00', '320 mg', 'Gemefloxacin'), 
('1326', 'Emiset   4 mg', '272-02618', 'Tablet', 'Alco Pharma Limited', '5.00', '0.00', '4 mg', 'Ondansetron'), 
('1327', 'Emiset 8   8 mg', '272-02628', 'Tablet', 'Alco Pharma Limited', '10.00', '0.00', '8 mg', 'Ondansetron'), 
('1328', 'Epizam   1 mg', '272-02676', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '1 mg', 'Clonazepam'), 
('1329', 'Epizam   2 mg', '272-0268-046', 'Tablet', 'Alco Pharma Limited', '6.00', '0.00', '2 mg', 'Clonazepam'), 
('1330', 'Rosvin   10 mg', '272-0265-61', 'Tablet', 'Alco Pharma Limited', '20.00', '0.00', '10 mg', 'Rosuvastatin'), 
('1331', 'Gluvil   50 mg', '272-0264', 'Tablet', 'Alco Pharma Limited', '20.00', '0.00', '50 mg', 'Vildagliptin'), 
('1332', 'Rupaler   10 mg', '272-0266-21', 'Tablet', 'Alco Pharma Limited', '10.00', '0.00', '10 mg', 'Rupatadine'), 
('1333', 'Moxiflox0   400 mg', '272-0121-23', 'Tablet', 'Alco Pharma Limited', '50.15', '0.00', '400 mg', 'Moxifloxacin'), 
('1334', 'Rosvin   5 mg', '272-0272-61', 'Tablet', 'Alco Pharma Limited', '10.00', '0.00', '5 mg', 'Rosuvastatin'), 
('1335', 'Tosma   1 mg', '272-0278-21', 'Tablet', 'Alco Pharma Limited', '2.00', '0.00', '1 mg', 'Ketotifen'), 
('1336', 'Metmin0 SR   500 mg', '272-0281-015', 'Tablet', 'Alco Pharma Limited', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1337', 'Infecef IM   250 mg', '272-0243-23', 'IM Injection', 'Alco Pharma Limited', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('1338', 'Infecef0 IM   500 mg', '272-0244-23', 'IM Injection', 'Alco Pharma Limited', '130.39', '0.00', '500 mg', 'Ceftriaxone'), 
('1339', 'Infecef gm IM   1 gm', '272-0245-23', 'IM Injection', 'Alco Pharma Limited', '190.57', '0.00', '1 gm', 'Ceftriaxone'), 
('1340', 'Infecef IV   250 mg', '272-0246-23', 'IV Injection', 'Alco Pharma Limited', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('1341', 'Infecef0 IV   500 mg', '272-0247-23', 'IV Injection', 'Alco Pharma Limited', '130.39', '0.00', '500 mg', 'Ceftriaxone'), 
('1342', 'Infecef gm IV   1 gm', '272-0248-23', 'IV Injection', 'Alco Pharma Limited', '190.57', '0.00', '1 gm', 'Ceftriaxone'), 
('1343', 'Infecef gm IV   2 gm', '272-0249-23', 'IV Injection', 'Alco Pharma Limited', '300.90', '0.00', '2 gm', 'Ceftriaxone'), 
('1344', 'Esiguard   20 mg', '373-0009-067', 'Capsule', 'Allied Pharmaceuticals Ltd.', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('1345', 'Omixen   20 mg', '373-0015-67', 'Capsule', 'Allied Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('1346', 'Alfixim   200 mg', '373-0018-23', 'Capsule', 'Allied Pharmaceuticals Ltd.', '35.00', '0.00', '200 mg', 'Cefixime'), 
('1347', 'Alfixim0   400 mg', '373-0019-23', 'Capsule', 'Allied Pharmaceuticals Ltd.', '50.00', '0.00', '400 mg', 'Cefixime'), 
('1348', 'Alfradin0   500 mg', '373-0021-23', 'Capsule', 'Allied Pharmaceuticals Ltd.', '12.50', '0.00', '500 mg', 'Cephradine'), 
('1349', 'Voltex SR   100 mg', '373-0024-64', 'Capsule', 'Allied Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1350', 'Alcefen   100 mg', '373-0001-64', 'Tablet', 'Allied Pharmaceuticals Ltd.', '4.00', '0.00', '100 mg', 'Aceclofenac'), 
('1351', 'Zylomax0   500 mg', '373-0003-23', 'Tablet', 'Allied Pharmaceuticals Ltd.', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('1352', 'Albafen   10 mg', '373-0004-70', 'Tablet', 'Allied Pharmaceuticals Ltd.', '8.00', '0.00', '10 mg', 'Baclofen'), 
('1353', 'Bactiflox0   500 mg', '373-0006-23', 'Tablet', 'Allied Pharmaceuticals Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('1354', 'Bactiflox   250 mg', '373-0007-23', 'Tablet', 'Allied Pharmaceuticals Ltd.', '8.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('1355', 'Dompidox   10 mg', '373-00088', 'Tablet', 'Allied Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('1356', 'Fexotis   120 mg', '373-0010-21', 'Tablet', 'Allied Pharmaceuticals Ltd.', '7.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('1357', 'Altorec   10 mg', '373-0011-064', 'Tablet', 'Allied Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1358', 'Levolied0   500 mg', '373-0012-23', 'Tablet', 'Allied Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('1359', 'Alproxen0   500 mg', '373-0013-64', 'Tablet', 'Allied Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Naproxen'), 
('1360', 'Alproxen   250 mg', '373-0014-64', 'Tablet', 'Allied Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Naproxen'), 
('1361', 'Ranlied   150 mg', '373-00175', 'Tablet', 'Allied Pharmaceuticals Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('1362', 'Reokast   4 mg', '373-0025-044', 'Chewable Tablet', 'Allied Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Montelukast'), 
('1363', 'Aluctin   15 mg', '192-0108-057', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Flurazepam'), 
('1364', 'Aluctin   30 mg', '192-0055-057', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '3.55', '0.00', '30 mg', 'Flurazepam'), 
('1365', 'Ambeeclox   500 mg', '192-0042-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cloxacillin'), 
('1366', 'Ambeexin   250 mg', '192-0027-023', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '3.55', '0.00', '250 mg', 'Amoxicillin'), 
('1367', 'Doxilin      100 mg', '192-0035-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '2.13', '0.00', '100 mg', 'Doxycycline'), 
('1368', 'Fluxin   250 mg', '192-0093-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '5.59', '0.00', '250 mg', 'Flucloxacillin'), 
('1369', 'Fluxin   500 mg', '192-0125-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '10.04', '0.00', '500 mg', 'Flucloxacillin'), 
('1370', 'Lap   30 mg', '192-0116-67', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '5.01', '0.00', '30 mg', 'Lansoprazole'), 
('1371', 'Mycef   500 mg', '192-0098-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '12.54', '0.00', '500 mg', 'Cephradine'), 
('1372', 'Mycin50   450 mg', '192-0045-30', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '450 mg', 'Rifampicin'), 
('1373', 'Tetram   250 mg', '192-0033-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '1.33', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('1374', 'Semicillin   250 mg', '192-0001-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Ampicillin'), 
('1375', 'Tricef M     200 mg', '192-0133-23', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('1376', 'Mycin      150 mg', '192-0041-30', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Rifampicin'), 
('1377', 'Om      20 mg', '192-0139-67', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '3.02', '0.00', '20 mg', 'Omeprazole'), 
('1378', 'Om      40 mg', '192-0140-67', 'Capsule', 'Ambee Pharmaceuticals Ltd.', '5.01', '0.00', '40 mg', 'Omeprazole'), 
('1379', 'Act   500 mg', '192-0020-006', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('1380', 'Adipin   10 mg', '192-0105-022', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Amlodipine'), 
('1381', 'Adorex   10 mg', '192-01098', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('1382', 'Afuvin   500 mg', '192-0054', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '5.32', '0.00', '500 mg', 'Griseofulvin'), 
('1383', 'Ametrol  DS   800 mg', '192-0119-27', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '800 mg', 'Metronidazole'), 
('1384', 'Aminophylline      100 mg', '192-00134', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.38', '0.00', '100 mg', 'Aminophylline'), 
('1385', 'Anetol      100 mg', '192-0057-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Atenolol'), 
('1386', 'Anetol      50 mg', '192-0068-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Atenolol'), 
('1387', 'Antac      150 mg', '192-00585', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '1.51', '0.00', '150 mg', 'Ranitidine'), 
('1388', 'Broncolin   2 mg', '192-00524', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Salbutamol'), 
('1389', 'Broncolin   4 mg', '192-00534', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Salbutamol'), 
('1390', 'C Bon   250 mg', '192-0084-78', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('1391', 'Calcitate   300 mg', '192-0080-62', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.29', '0.00', '300 mg', 'Calcium Lactate'), 
('1392', 'Capril      25 mg', '192-0069-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Captopril'), 
('1393', 'Capril      50 mg', '192-0070-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Captopril'), 
('1394', 'Actizen   10 mg', '192-0107-21', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '2.03', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1395', 'Diphedan   100 mg', '192-0017-046', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '2.01', '0.00', '100 mg', 'Phenytoin Sodium'), 
('1396', 'Dopaflex   500 mg', '192-0024-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Methyldopa'), 
('1397', 'Dopegyt   250 mg', '192-0012-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '3.09', '0.00', '250 mg', 'Methyldopa'), 
('1398', 'Ephedrine   30 mg', '192-0011', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '30 mg', 'Ephedrine Hydrochloride'), 
('1399', 'Famotac      20 mg', '192-00675', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Famotidine'), 
('1400', 'Famotac      40 mg', '192-00665', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Famotidine'), 
('1401', 'Folac   5 mg', '192-00215', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.24', '0.00', '5 mg', 'Folic Acid'), 
('1402', 'Hiflox   500 mg', '192-0072-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '8.70', '0.00', '500 mg', 'Ciprofloxacin'), 
('1403', 'Hiflox   750 mg', '192-0124-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '12.05', '0.00', '750 mg', 'Ciprofloxacin'), 
('1404', 'Hitflam      50 mg', '192-0071-64', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.84', '0.00', '50 mg', 'Diclofenac Sodium'), 
('1405', 'Cerenin   5 mg', '192-0106-36', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '3.55', '0.00', '5 mg', 'Vinpocetine'), 
('1406', 'Klion      200 mg', '192-0037-27', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Metronidazole'), 
('1407', 'Klion   400 mg', '192-0038-27', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('1408', 'Koal   300 mg', '192-00837', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Activated Charcoal'), 
('1409', 'Lopa.5   2.5 mg', '192-01047', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '2.5 mg', 'Lorazepam'), 
('1410', 'Lotas      50 mg', '192-0117-022', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '5.69', '0.00', '50 mg', 'Losartan Potassium'), 
('1411', 'Lovatin      20 mg', '192-0088-61', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Lovastatin'), 
('1412', 'Lovatin      40 mg', '192-0089-61', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Lovastatin'), 
('1413', 'MI   30 mg', '192-0103-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '30 mg', 'Diltiazem Hydrochloride'), 
('1414', 'Nalidex   500 mg', '192-0036-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '4.07', '0.00', '500 mg', 'Nalidixic Acid'), 
('1415', 'Naproxin   250 mg', '192-0050-64', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '4.26', '0.00', '250 mg', 'Naproxen'), 
('1416', 'Naproxin   500 mg', '192-0100-64', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '6.92', '0.00', '500 mg', 'Naproxen'), 
('1417', 'No Spa   40 mg', '192-00191', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '1.82', '0.00', '40 mg', 'Drotaverine Hydrochloride'), 
('1418', 'Noctin   5 mg', '192-0082-057', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.69', '0.00', '5 mg', 'Nitrazepam'), 
('1419', 'Nop.5   2.5 mg', '192-0090-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '2.5 mg', 'Lisinopril'), 
('1420', 'Nop      5 mg', '192-0091-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '3.55', '0.00', '5 mg', 'Lisinopril'), 
('1421', 'Perol      5 mg', '192-0097-28', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.51', '0.00', '5 mg', 'Haloperidol'), 
('1422', 'Prednisolone      5 mg', '192-0002-72', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.67', '0.00', '5 mg', 'Prednisolone'), 
('1423', 'Rem   3 mg', '192-01217', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '2.01', '0.00', '3 mg', 'Bromazepam'), 
('1424', 'Seduxen      5 mg', '192-0007-057', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.23', '0.00', '5 mg', 'Diazepam'), 
('1425', 'Sinumid   10 mg', '192-00511', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('1426', 'Sural   400 mg', '192-0003-30', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '1.66', '0.00', '400 mg', 'Ethambutol'), 
('1427', 'Syche      50 mg', '192-01154', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Sertraline'), 
('1428', 'Triben  DS   400 mg', '192-0062-008', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '3.35', '0.00', '400 mg', 'Albendazole'), 
('1429', 'Triben      200 mg', '192-0063-008', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Albendazole'), 
('1430', 'Trofurit      40 mg', '192-00052', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.53', '0.00', '40 mg', 'Frusemide'), 
('1431', 'Verospiron   25 mg', '192-00042', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '5.01', '0.00', '25 mg', 'Spironolactone'), 
('1432', 'A Rox      150 mg', '192-0136-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '6.53', '0.00', '150 mg', 'Roxithromycin'), 
('1433', 'A Rox0   300 mg', '192-0135-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '11.04', '0.00', '300 mg', 'Roxithromycin'), 
('1434', 'Ampine   10 mg', '192-0056-22', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Nifedipine'), 
('1435', 'Delagil   250 mg', '192-0026-24', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Chloroquine Phosphate'), 
('1436', 'Hiflox   250 mg', '192-0073-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('1437', 'Gilemal   5 mg', '192-0018', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Glibenclamide'), 
('1438', 'Lexlo   500 mg', '192-0137-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '13.05', '0.00', '500 mg', 'Levofloxacin'), 
('1439', 'Mespa   135 mg', '192-01441', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '6.02', '0.00', '135 mg', 'Mebeverine Hydrochloride'), 
('1440', 'Tindurin   25 mg', '192-0014-24', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Pyrimethamine'), 
('1441', 'Sulphadimidine   500 mg', '192-0022-023', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Sulphadimidine'), 
('1442', 'Nomigra      50 mg', '192-01287', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Sumatriptan'), 
('1443', 'Nomigran      100 mg', '192-01297', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '45.17', '0.00', '100 mg', 'Sumatriptan'), 
('1444', 'Myzid   250 mg', '192-0167-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('1445', 'Myzid   500 mg', '192-0168-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('1446', 'Arolak   10 mg', '192-0159-064', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '10.04', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1447', 'Amason0 mcg   .5 mg', '192-0162-72', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.47', '0.00', '.5 mg', 'Dexamethasone'), 
('1448', 'Lexlo   250 mg', '192-0155-23', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '8.03', '0.00', '250 mg', 'Levofloxacin'), 
('1449', 'Ambeecal   1250 mg', '192-0153-62', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '2.01', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1450', 'Morphine Sulphate   15 mg', '192-0150-65', 'Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Morphine Sulphate'), 
('1451', 'Hitflam  SR    100 mg', '192-0092-64', 'Sr Tablet', 'Ambee Pharmaceuticals Ltd.', '3.50', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1452', 'Hiflox XR   1 gm', '192-0170-23', 'Sr Tablet', 'Ambee Pharmaceuticals Ltd.', '0.00', '0.00', '1 gm', 'Ciprofloxacin'), 
('1453', 'Belocef   250 mg', '028-0036-023', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Cephradine'), 
('1454', 'Belocef   500 mg', '028-0037-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('1455', 'Gen - 3      200 mg', '028-0077-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('1456', 'Clocef   250 mg', '028-0082-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Cefaclor'), 
('1457', 'Clocef   500 mg', '028-0087-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cefaclor'), 
('1458', 'Healer      20 mg', '028-0097-67', 'Capsule', 'Amico Laboratories Ltd.', '4.00', '0.00', '20 mg', 'Omeprazole'), 
('1459', 'Monaclox F     250 mg', '028-0059-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('1460', 'Monadox      100 mg', '028-0038-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('1461', 'Monamox   500 mg', '028-0080-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('1462', 'Monamox   250 mg', '028-0055-023', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('1463', 'Monatrex   250 mg', '028-0053-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('1464', 'Monatrex  DS   500 mg', '028-0064-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Tetracycline Hydrochloride'), 
('1465', 'Novarin  SR   100 mg', '028-0085-64', 'Capsule', 'Amico Laboratories Ltd.', '2.50', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1466', 'Tramadol      50 mg', '028-0118-65', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('1467', 'Lansopril   15 mg', '028-0094-67', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '15 mg', 'Lansoprazole'), 
('1468', 'Lansopril   30 mg', '028-0091-67', 'Capsule', 'Amico Laboratories Ltd.', '5.50', '0.00', '30 mg', 'Lansoprazole'), 
('1469', 'Monaclox-F   500 mg', '028-0095-23', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('1470', 'Prazia   20 mg', '028-0209-067', 'Capsule', 'Amico Laboratories Ltd.', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('1471', 'Prazia   40 mg', '028-0210-067', 'Capsule', 'Amico Laboratories Ltd.', '10.00', '0.00', '40 mg', 'Esomeprazole'), 
('1472', 'Candid0   50 mg', '028-0211', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Fluconazole'), 
('1473', 'Candid   150 mg', '028-0212', 'Capsule', 'Amico Laboratories Ltd.', '0.00', '0.00', '150 mg', 'Fluconazole'), 
('1474', 'Amiflox   250 mg', '028-0058-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('1475', 'Amiflox   500 mg', '028-0060-23', 'Tablet', 'Amico Laboratories Ltd.', '10.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('1476', 'Amipril      25 mg', '028-0069-22', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '25 mg', 'Captopril'), 
('1477', 'Amipril      50 mg', '028-0070-22', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Captopril'), 
('1478', 'Azix   500 mg', '028-0079-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('1479', 'Clarimycin   500 mg', '028-0090-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Clarithromycin'), 
('1480', 'Dyzin   10 mg', '028-0084-21', 'Tablet', 'Amico Laboratories Ltd.', '2.75', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1481', 'Gliden   5 mg', '028-0061', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Glibenclamide'), 
('1482', 'Licazide   80 mg', '028-0076', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '80 mg', 'Gliclazide'), 
('1483', 'Hepadin      100 mg', '028-0106-32', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Lamivudine'), 
('1484', 'Ketofun   200 mg', '028-0041', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Ketoconazole'), 
('1485', 'Levin   500 mg', '028-0100-23', 'Tablet', 'Amico Laboratories Ltd.', '14.00', '0.00', '500 mg', 'Levofloxacin'), 
('1486', 'Lodin   10 mg', '028-0075-21', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Loratadine'), 
('1487', 'Losaron      50 mg', '028-0113-022', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Losartan Potassium'), 
('1488', 'Mecozol   400 mg', '028-0033-27', 'Tablet', 'Amico Laboratories Ltd.', '1.00', '0.00', '400 mg', 'Metronidazole'), 
('1489', 'Oracal   1250 mg', '028-0105-62', 'Tablet', 'Amico Laboratories Ltd.', '2.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1490', 'Panzol      20 mg', '028-0103-67', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Pantoprazole'), 
('1491', 'Panzol      40 mg', '028-0104-67', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '40 mg', 'Pantoprazole'), 
('1492', 'Para   500 mg', '028-0021-006', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('1493', 'Pheramin   4 mg', '028-0024-21', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('1494', 'Rocky      150 mg', '028-0101-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '150 mg', 'Roxithromycin'), 
('1495', 'Rocky0   300 mg', '028-0102-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '300 mg', 'Roxithromycin'), 
('1496', 'Sedapen      5 mg', '028-0022-057', 'Tablet', 'Amico Laboratories Ltd.', '0.69', '0.00', '5 mg', 'Diazepam'), 
('1497', 'Suvic   250 mg', '028-0034-78', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('1498', 'Tocomin      200 mg', '028-0116-78', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Vitamin E'), 
('1499', 'Vastin   10 mg', '028-0096-61', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Simvastatin'), 
('1500', 'Xepadon   10 mg', '028-01148', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('1501', 'Zoben   400 mg', '028-0042-008', 'Tablet', 'Amico Laboratories Ltd.', '4.50', '0.00', '400 mg', 'Albendazole'), 
('1502', 'Zorep      150 mg', '028-00395', 'Tablet', 'Amico Laboratories Ltd.', '1.50', '0.00', '150 mg', 'Ranitidine'), 
('1503', 'Relaxium.   3 mg', '028-01267', 'Tablet', 'Amico Laboratories Ltd.', '4.00', '0.00', '3 mg', 'Bromazepam'), 
('1504', 'Penjoin   500 mg', '028-0132-64', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Glucosamine'), 
('1505', 'Suvic   250 mg', '028-0133-78', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('1506', 'Isonil   5 mg', '028-00471', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Oxyphenonium Bromide'), 
('1507', 'Novarin      50 mg', '028-0044-64', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('1508', 'Panflox      200 mg', '028-0099-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Sparfloxacin'), 
('1509', 'Ribiflavine   5 mg', '028-0027-79', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Riboflavin'), 
('1510', 'Relaxium   5 mg', '028-0028-60', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Bisacodyl'), 
('1511', 'Amiflox   750 mg', '028-0098-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('1512', 'Naproxen   500 mg', '028-0135-64', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Naproxen'), 
('1513', 'Candid      50 mg', '028-0161', 'Tablet', 'Amico Laboratories Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('1514', 'Candid      150 mg', '028-0162', 'Tablet', 'Amico Laboratories Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('1515', 'Baclofen   10 mg', '028-0165-70', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Baclofen'), 
('1516', 'Ruzmet0   500 mg', '028-0168', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1517', 'Clonazepam.5   .5 mg', '028-0171-046', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '.5 mg', 'Clonazepam'), 
('1518', 'Clonazepam   2 mg', '028-0172-046', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '2 mg', 'Clonazepam'), 
('1519', 'Hybut   10 mg', '028-01731', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('1520', 'Troy   10 mg', '028-0174-064', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1521', 'Midaben   7.5 mg', '028-0177-057', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '7.5 mg', 'Midazolam'), 
('1522', 'Halazone   7.5 mg', '028-0177', 'Tablet', 'Amico Laboratories Ltd.', '1.00', '0.00', '7.5 mg', 'Halazone'), 
('1523', 'Halazone   15 mg', '028-0178', 'Tablet', 'Amico Laboratories Ltd.', '1.70', '0.00', '15 mg', 'Halazone'), 
('1524', 'Prazia   20 mg', '028-0180-067', 'Tablet', 'Amico Laboratories Ltd.', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('1525', 'Prazia   40 mg', '028-0181-67', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '40 mg', 'Esomeprazole'), 
('1526', 'Erixin   500 mg', '028-0184-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('1527', 'Mebendazole   100 mg', '028-0185-8', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Mebendazole'), 
('1528', 'Salbutamol   4 mg', '028-01864', 'Tablet', 'Amico Laboratories Ltd.', '0.46', '0.00', '4 mg', 'Salbutamol'), 
('1529', 'Ibuprofen   400 mg', '028-0187-64', 'Tablet', 'Amico Laboratories Ltd.', '1.43', '0.00', '400 mg', 'Ibuprofen'), 
('1530', 'Clofenta   100 mg', '028-0122-64', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Aceclofenac'), 
('1531', 'Amikast   5 mg', '028-0194-044', 'Tablet', 'Amico Laboratories Ltd.', '8.00', '0.00', '5 mg', 'Montelukast'), 
('1532', 'Amikast   10 mg', '028-0195-044', 'Tablet', 'Amico Laboratories Ltd.', '15.00', '0.00', '10 mg', 'Montelukast'), 
('1533', 'Atenolol   50 mg', '028-0192-22', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Atenolol'), 
('1534', 'Atenolol   100 mg', '028-0193-22', 'Tablet', 'Amico Laboratories Ltd.', '1.38', '0.00', '100 mg', 'Atenolol'), 
('1535', 'Carbamazepine   100 mg', '028-0198-046', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Carbamazepine'), 
('1536', 'Carbamazepine   200 mg', '028-0197-046', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Carbamazepine'), 
('1537', 'Folic Acid   5 mg', '028-01985', 'Tablet', 'Amico Laboratories Ltd.', '0.34', '0.00', '5 mg', 'Folic Acid'), 
('1538', 'Amifex   60 mg', '028-0200-21', 'Tablet', 'Amico Laboratories Ltd.', '3.50', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('1539', 'Amifex   120 mg', '028-0201-21', 'Tablet', 'Amico Laboratories Ltd.', '7.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('1540', 'Ketotifen   1 mg', '028-0202-21', 'Tablet', 'Amico Laboratories Ltd.', '2.50', '0.00', '1 mg', 'Ketotifen'), 
('1541', 'Misoprostol   200 mcg', '028-02039', 'Tablet', 'Amico Laboratories Ltd.', '15.00', '0.00', '200 mcg', 'Misoprostol'), 
('1542', 'Zn   20 mg', '028-0208-62', 'Tablet', 'Amico Laboratories Ltd.', '2.00', '0.00', '20 mg', 'Zinc'), 
('1543', 'AmiClean Tab.   7.5 mg', '028-02137', 'Tablet', 'Amico Laboratories Ltd.', '0.60', '0.00', '7.5 mg', 'Sodium Thiosulfate'), 
('1544', 'AmiClean Tab.   15 mg', '028-02147', 'Tablet', 'Amico Laboratories Ltd.', '0.95', '0.00', '15 mg', 'Sodium Thiosulfate'), 
('1545', 'Carbamazine   100 mg', '028-0215-8', 'Tablet', 'Amico Laboratories Ltd.', '1.30', '0.00', '100 mg', 'Diethylcarbamazine Citrate'), 
('1546', 'Lepath   250 mg', '028-0158-23', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Cefuroxime'), 
('1547', 'AmiCoxib   90 mg', '028-0219-64', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '90 mg', 'Etoricoxib'), 
('1548', 'AmiCoxib   120 mg', '028-0220-64', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '120 mg', 'Etoricoxib'), 
('1549', 'Sidor   50 mg', '028-0221-043', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Sildenafil'), 
('1550', 'Sidor Plus   100 mg', '028-0222-043', 'Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Sildenafil'), 
('1551', 'Novarin  SR    100 mg', '028-0074-64', 'Sr Tablet', 'Amico Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1552', 'Omelet   20 mg', '246-0010-67', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '5.02', '0.00', '20 mg', 'Omeprazole'), 
('1553', 'Flucolet   50 mg', '246-0013', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '8.03', '0.00', '50 mg', 'Fluconazole'), 
('1554', 'Esomo   20 mg', '246-0023-067', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '6.02', '0.00', '20 mg', 'Esomeprazole'), 
('1555', 'Esomo   40 mg', '246-0024-067', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '8.03', '0.00', '40 mg', 'Esomeprazole'), 
('1556', 'Amzith   250 mg', '246-0027-23', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '20.06', '0.00', '250 mg', 'Azithromycin'), 
('1557', 'Flucolet   150 mg', '246-0028', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '20.06', '0.00', '150 mg', 'Fluconazole'), 
('1558', 'Omelet   40 mg', '246-0030-67', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '7.02', '0.00', '40 mg', 'Omeprazole'), 
('1559', 'DFC TR   100 mg', '246-0032-64', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '2.51', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1560', 'Amucef0   400 mg', '246-0048-23', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '50.15', '0.00', '400 mg', 'Cefixime'), 
('1561', 'Amucef   200 mg', '246-0049-23', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '30.10', '0.00', '200 mg', 'Cefixime'), 
('1562', 'Amfrad0   500 mg', '246-0051-23', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '12.54', '0.00', '500 mg', 'Cephradine'), 
('1563', 'Amfrad   250 mg', '246-0052-023', 'Capsule', 'Amulet Pharmaceuticals Ltd.', '6.52', '0.00', '250 mg', 'Cephradine'), 
('1564', 'Burndel   1 %', '246-0055-23', 'Cream', 'Amulet Pharmaceuticals Ltd.', '40.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('1565', 'WFI   1 ml', '246-0073-79', 'Injection', 'Amulet Pharmaceuticals Ltd.', '0.00', '0.00', '1 ml', 'Water For Injection'), 
('1566', 'Hemolac   68 %', '246-0006-60', 'Oral Solution', 'Amulet Pharmaceuticals Ltd.', '0.00', '0.00', '68 %', 'Lactulose'), 
('1567', 'Amzith0   500 mg', '246-0007-23', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '35.11', '0.00', '500 mg', 'Azithromycin'), 
('1568', 'Amuran   150 mg', '246-00095', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('1569', 'Flocip0   500 mg', '246-0014-23', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '14.05', '0.00', '500 mg', 'Ciprofloxacin'), 
('1570', 'Xofedin   120 mg', '246-0017-21', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '6.52', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('1571', 'Xofedin80   180 mg', '246-0018-21', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '8.03', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('1572', 'DFC   50 mg', '246-0031-64', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '0.60', '0.00', '50 mg', 'Diclofenac Sodium'), 
('1573', 'Toro   10 mg', '246-0033-064', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '10.03', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1574', 'Setir   10 mg', '246-0034-21', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1575', 'Tempanil   500 mg', '246-0038-006', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('1576', 'Desolet   5 mg', '246-0040-21', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '2.51', '0.00', '5 mg', 'Desloratadine'), 
('1577', 'Montilet   10 mg', '246-0041-044', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '15.05', '0.00', '10 mg', 'Montelukast'), 
('1578', 'Nitalet   500 mg', '246-0042-27', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '10.03', '0.00', '500 mg', 'Nitazoxanide'), 
('1579', 'Coxetori   60 mg', '246-0043-64', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '7.02', '0.00', '60 mg', 'Etoricoxib'), 
('1580', 'Coxetpro   120 mg', '246-0044-64', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '14.05', '0.00', '120 mg', 'Etoricoxib'), 
('1581', 'Axefur0   500 mg', '246-0045-23', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '45.13', '0.00', '500 mg', 'Cefuroxime'), 
('1582', 'SMR Tablet   10 mg', '246-0054-70', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '8.03', '0.00', '10 mg', 'Baclofen'), 
('1583', 'Timofet   50 mg', '246-00571', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '6.02', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('1584', 'Rheunil   100 mg', '246-0016-64', 'Tablet', 'Amulet Pharmaceuticals Ltd.', '3.01', '0.00', '100 mg', 'Aceclofenac'), 
('1585', 'Cefilet0 IM   500 mg', '246-0065-23', 'IM Injection', 'Amulet Pharmaceuticals Ltd.', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('1586', 'Cefilet gm IM   1 gm', '246-0066-23', 'IM Injection', 'Amulet Pharmaceuticals Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('1587', 'Cefilet gm IV   1 gm', '246-0067-23', 'IV Injection', 'Amulet Pharmaceuticals Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('1588', 'Cefilet gm IV   2 gm', '246-0068-23', 'IV Injection', 'Amulet Pharmaceuticals Ltd.', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('1589', 'Tetracycline   250 mg', '135-0038-23', 'Capsule', 'APC Pharma Limited', '1.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('1590', 'Pemox   500 mg', '135-0052-23', 'Capsule', 'APC Pharma Limited', '6.00', '0.00', '500 mg', 'Amoxicillin'), 
('1591', 'Flutec   250 mg', '135-0060-23', 'Capsule', 'APC Pharma Limited', '5.75', '0.00', '250 mg', 'Flucloxacillin'), 
('1592', 'Flutec   500 mg', '135-0057-23', 'Capsule', 'APC Pharma Limited', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('1593', 'Omeprazole      20 mg', '135-0058-67', 'Capsule', 'APC Pharma Limited', '2.50', '0.00', '20 mg', 'Omeprazole'), 
('1594', 'Penac  TR   100 mg', '135-0064-64', 'Capsule', 'APC Pharma Limited', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1595', 'Seftec0   500 mg', '135-0084-23', 'Capsule', 'APC Pharma Limited', '12.50', '0.00', '500 mg', 'Cephradine'), 
('1596', 'Cloxacillin0   500 mg', '135-0086-23', 'Capsule', 'APC Pharma Limited', '5.50', '0.00', '500 mg', 'Cloxacillin'), 
('1597', 'Cefesta   200 mg', '135-0088-23', 'Capsule', 'APC Pharma Limited', '0.00', '0.00', '200 mg', 'Cefixime'), 
('1598', 'Trogi   2.6 mg', '135-0094', 'Capsule', 'APC Pharma Limited', '0.00', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('1599', 'Apicon   50 mg', '135-0101', 'Capsule', 'APC Pharma Limited', '0.00', '0.00', '50 mg', 'Fluconazole'), 
('1600', 'Comfort   68 %', '135-0079-60', 'Oral Solution', 'APC Pharma Limited', '72.00', '0.00', '68 %', 'Lactulose'), 
('1601', 'Apetryl   400 mg', '135-0027-27', 'Tablet', 'APC Pharma Limited', '0.75', '0.00', '400 mg', 'Metronidazole'), 
('1602', 'Ibuprofen   400 mg', '135-0048-64', 'Tablet', 'APC Pharma Limited', '1.00', '0.00', '400 mg', 'Ibuprofen'), 
('1603', 'Penac      50 mg', '135-0043-64', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('1604', 'Penamin   4 mg', '135-0047-21', 'Tablet', 'APC Pharma Limited', '0.20', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('1605', 'Phenoxymethyl   250 mg', '135-0050-23', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('1606', 'Ranitec      150 mg', '135-00425', 'Tablet', 'APC Pharma Limited', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('1607', 'Domstal   10 mg', '135-00568', 'Tablet', 'APC Pharma Limited', '2.00', '0.00', '10 mg', 'Domperidone'), 
('1608', 'Cetrizine   10 mg', '135-0055-21', 'Tablet', 'APC Pharma Limited', '2.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1609', 'Griseofulvin   500 mg', '135-0059', 'Tablet', 'APC Pharma Limited', '5.50', '0.00', '500 mg', 'Griseofulvin'), 
('1610', 'Orange C     250 mg', '135-0061-78', 'Tablet', 'APC Pharma Limited', '0.82', '0.00', '250 mg', 'Vitamin C'), 
('1611', 'Ciprotec   500 mg', '135-0041-23', 'Tablet', 'APC Pharma Limited', '8.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('1612', 'Ambuterol   10 mg', '135-00674', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '10 mg', 'Bambuterol Hydrochloride'), 
('1613', 'Calcium   1250 mg', '135-0070-62', 'Tablet', 'APC Pharma Limited', '2.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1614', 'Furotec   500 mg', '135-0073-23', 'Tablet', 'APC Pharma Limited', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('1615', 'Noworm   400 mg', '135-0076-008', 'Tablet', 'APC Pharma Limited', '3.30', '0.00', '400 mg', 'Albendazole'), 
('1616', 'Zeocin   500 mg', '135--23', 'Tablet', 'APC Pharma Limited', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('1617', 'Tablet Penac-AC   100 mg', '135-0087-64', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '100 mg', 'Aceclofenac'), 
('1618', 'Prozide   80 mg', '135-0092', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '80 mg', 'Gliclazide'), 
('1619', 'Apcard   50 mg', '135-0093-22', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '50 mg', 'Atenolol'), 
('1620', 'Metofin   850 mg', '135-0096', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('1621', 'Dexamethasone   .5 mg', '135-0099-72', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '.5 mg', 'Dexamethasone'), 
('1622', 'Apilac   10 mg', '135-0102-064', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1623', 'Slaken   10 mg', '135-0103-70', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '10 mg', 'Baclofen'), 
('1624', 'Vastas   10 mg', '135-0104-061', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '10 mg', 'Atorvastatin'), 
('1625', 'Vastas   20 mg', '135-0105-061', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '20 mg', 'Atorvastatin'), 
('1626', 'Topracid   20 mg', '135-0107-67', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '20 mg', 'Pantoprazole'), 
('1627', 'Topracid   40 mg', '135-0108-67', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '40 mg', 'Pantoprazole'), 
('1628', 'Esomepra   20 mg', '135-0109-067', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('1629', 'Esomepra   40 mg', '135-0110-67', 'Tablet', 'APC Pharma Limited', '0.00', '0.00', '40 mg', 'Esomeprazole'), 
('1630', 'Omeprazole   20 mg', '135-0082-67', 'Sached Powder', 'APC Pharma Limited', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('1631', 'Aphrin   500 mg', '170-0043-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '12.00', '0.00', '500 mg', 'Cephradine'), 
('1632', 'Apoxy   500 mg', '170-0047-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '6.73', '0.00', '500 mg', 'Amoxicillin'), 
('1633', 'Aspra      20 mg', '170-0041-67', 'Capsule', 'Apex Pharmaceuticals Ltd.', '4.00', '0.00', '20 mg', 'Omeprazole'), 
('1634', 'Dix  TR    100 mg', '170-0068-64', 'Capsule', 'Apex Pharmaceuticals Ltd.', '2.53', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1635', 'Luf   250 mg', '170-0055-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '5.50', '0.00', '250 mg', 'Flucloxacillin'), 
('1636', 'Luff   500 mg', '170-0056-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '10.00', '0.00', '500 mg', 'Flucloxacillin'), 
('1637', 'Apoxy   250 mg', '170-0033-023', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('1638', 'Tera   250 mg', '170-0028-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('1639', 'Rindocin   25 mg', '170-0034-64', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Indomethacin'), 
('1640', 'Texit      200 mg', '170-0061-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('1641', 'Trol      50 mg', '170-0062-65', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('1642', 'Zolen      50 mg', '170-0039', 'Capsule', 'Apex Pharmaceuticals Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('1643', 'Zolen      150 mg', '170-0040', 'Capsule', 'Apex Pharmaceuticals Ltd.', '18.00', '0.00', '150 mg', 'Fluconazole'), 
('1644', 'Apdox      100 mg', '170-0053-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('1645', 'Cepoxid      100 mg', '170-0121-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Cefpodoxime'), 
('1646', 'Adnor   75 mg', '170-01764', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '75 mg', 'Doxepin'), 
('1647', 'Aspra   40 mg', '170-0178-67', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Omeprazole'), 
('1648', 'Texit0   400 mg', '170-0182-23', 'Capsule', 'Apex Pharmaceuticals Ltd.', '50.00', '0.00', '400 mg', 'Cefixime'), 
('1649', 'Hemostop   500 mg', '170-01839', 'Capsule', 'Apex Pharmaceuticals Ltd.', '15.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('1650', 'Tamsol   400 mcg', '170-01979', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('1651', 'Nexe   20 mg', '170-0246-067', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('1652', 'Rabegend   20 mg', '170-0259-67', 'Capsule', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('1653', 'Nervolin   50 mg', '170-0269-046', 'Capsule', 'Apex Pharmaceuticals Ltd.', '12.00', '0.00', '50 mg', 'Pregabalin'), 
('1654', 'Nervolin   75 mg', '170-0270-046', 'Capsule', 'Apex Pharmaceuticals Ltd.', '16.00', '0.00', '75 mg', 'Pregabalin'), 
('1655', 'Water for Injection   1 ml', '170-0171-79', 'Injection', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '1 ml', 'Water For Injection'), 
('1656', 'Polycol   17 gm', '170-0073-60', 'Powder', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '17 gm', 'Poly Ethylene Glycol 3350'), 
('1657', 'Apocal   Chewable   625 mg', '170-0057-62', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '625 mg', 'Calcium Carbonate'), 
('1658', 'Montelon   4 mg', '170-0066-044', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Montelukast'), 
('1659', 'Montelon   10 mg', '170-0067-044', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Montelukast'), 
('1660', 'Preform   850 mg', '170-0042', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('1661', 'Pril.5   2.5 mg', '170-0071-022', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '2.5 mg', 'Ramipril'), 
('1662', 'Rhythm   250 mg', '170-0063-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Erythromycin'), 
('1663', 'Rhythm   500 mg', '170-0064-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('1664', 'Ribazole   400 mg', '170-0026-27', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('1665', 'Til   125 mg', '170-0058-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '125 mg', 'Cefuroxime'), 
('1666', 'Til   250 mg', '170-0059-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cefuroxime'), 
('1667', 'Nexe      20 mg', '170-0088-067', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('1668', 'Metle Tab   500 mg', '170-0089', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1669', 'Vocet   5 mg', '170-0090-21', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('1670', 'Lequin   250 mg', '170-0091-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Levofloxacin'), 
('1671', 'Lequin   500 mg', '170-0092-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('1672', 'Lox   500 mg', '170-0038-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('1673', 'Ranpex   150 mg', '170-00485', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('1674', 'Apzol   400 mg', '170-0050-008', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Albendazole'), 
('1675', 'Apeclo   100 mg', '170-0051-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '1.50', '0.00', '100 mg', 'Aceclofenac'), 
('1676', 'Apocal   1250 mg', '170-0052-62', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1677', 'Pril      5 mg', '170-0072-022', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Ramipril'), 
('1678', 'Apexid      200 mg', '170-0074-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Pivmecillinam'), 
('1679', 'Nel   600 mg', '170-0075-023', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '600 mg', 'Linezolid'), 
('1680', 'Nel   400 mg', '170-0076-023', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Linezolid'), 
('1681', 'Delot   5 mg', '170-0077-21', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Desloratadine'), 
('1682', 'Losarpex   50 mg', '170-0078-022', 'Tablet', 'Apex Pharmaceuticals Ltd.', '8.00', '0.00', '50 mg', 'Losartan Potassium'), 
('1683', 'Losarpex   25 mg', '170-0079-022', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Losartan Potassium'), 
('1684', 'Fixgut   10 mg', '170-00808', 'Tablet', 'Apex Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('1685', 'Tamol   500 mg', '170-0096-006', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('1686', 'A S A0   300 mg', '170-0097-6', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Aspirin'), 
('1687', 'A.S.A  CV    75 mg', '170-0098-26', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '75 mg', 'Aspirin'), 
('1688', 'Acorex   30 mg', '170-0105-31', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '30 mg', 'Ambroxol'), 
('1689', 'Azinil   250 mg', '170-0106-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('1690', 'Azinil   500 mg', '170-0107-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('1691', 'Diacon   80 mg', '170-0109', 'Tablet', 'Apex Pharmaceuticals Ltd.', '7.00', '0.00', '80 mg', 'Gliclazide'), 
('1692', 'Dexbru      200 mg', '170-0141-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Dexibuprofen (S Ibuprofen)'), 
('1693', 'Progend0   500 mg', '170-0144-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '8.00', '0.00', '500 mg', 'Naproxen'), 
('1694', 'Zipol      20 mg', '170-0114-62', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Zinc'), 
('1695', 'Cepoxid      200 mg', '170-0122-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '41.00', '0.00', '200 mg', 'Cefpodoxime'), 
('1696', 'Winspa   10 mg', '170-01251', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Dicycloverine Hydrochloride'), 
('1697', 'Eszo   1 mg', '170-0127-057', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '1 mg', 'Eszopiclone'), 
('1698', 'Eszo   2 mg', '170-0128-057', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Eszopiclone'), 
('1699', 'Lesal   1 mg', '170-01294', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '1 mg', 'Levosalbutamol'), 
('1700', 'Lesal   2 mg', '170-01304', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Levosalbutamol'), 
('1701', 'Zilcef   250 mg', '170-0138-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cefprozil'), 
('1702', 'Zilcef00   500 mg', '170-0139-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cefprozil'), 
('1703', 'Dexbru0   300 mg', '170-0142-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Dexibuprofen (S Ibuprofen)'), 
('1704', 'Dexbru0   400 mg', '170-0143-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Dexibuprofen (S Ibuprofen)'), 
('1705', 'Mcard      5 mg', '170-0145-022', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Amlodipine'), 
('1706', 'Niazid   500 mg', '170-0147-27', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Nitazoxanide'), 
('1707', 'Tenamic   200 mg', '170-01497', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Tolfenamic Acid'), 
('1708', 'Ranul      150 mg', '170-01355', 'Tablet', 'Apex Pharmaceuticals Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('1709', 'Flunarin      5 mg', '170-01507', 'Tablet', 'Apex Pharmaceuticals Ltd.', '3.00', '0.00', '5 mg', 'Flunarizine'), 
('1710', 'Flunarin   10 mg', '170-01517', 'Tablet', 'Apex Pharmaceuticals Ltd.', '4.00', '0.00', '10 mg', 'Flunarizine'), 
('1711', 'Kflam   10 mg', '170-0153-064', 'Tablet', 'Apex Pharmaceuticals Ltd.', '7.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1712', 'Lox   750 mg', '170-0154-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('1713', 'Pantol      20 mg', '170-0156-67', 'Tablet', 'Apex Pharmaceuticals Ltd.', '4.50', '0.00', '20 mg', 'Pantoprazole'), 
('1714', 'Eflam   90 mg', '170-0160-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('1715', 'Eflam   60 mg', '170-0159-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '7.00', '0.00', '60 mg', 'Etoricoxib'), 
('1716', 'Bacspa   10 mg', '170-0161-70', 'Tablet', 'Apex Pharmaceuticals Ltd.', '7.00', '0.00', '10 mg', 'Baclofen'), 
('1717', 'Ketronil0   50 mg', '170-0180-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Ketoprofen'), 
('1718', 'Ketronil0   100 mg', '170-0181-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Ketoprofen'), 
('1719', 'Texicam   20 mg', '170-0184-64', 'Tablet', 'Apex Pharmaceuticals Ltd.', '8.00', '0.00', '20 mg', 'Tenoxicam'), 
('1720', 'Pantrol   40 mg', '170-0187-67', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Pantoprazole'), 
('1721', 'Visnor   50 mg', '170-01881', 'Tablet', 'Apex Pharmaceuticals Ltd.', '4.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('1722', 'Zonil   500 mcg', '170-01927', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mcg', 'Pizotifen'), 
('1723', 'Zonil-TS   1.5 mg', '170-01937', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '1.5 mg', 'Pizotifen'), 
('1724', 'Rabeloc   20 mg', '170-0196-67', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('1725', 'Zapitor   10 mg', '170-0198-061', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Atorvastatin'), 
('1726', 'Nervo2   .5 mg', '170-0199-78', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '.5 mg', 'Mecobalamin'), 
('1727', 'Ascorbic   250 mg', '170-0208-78', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('1728', 'Sopnil   7.5 mg', '170-0238-057', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '7.5 mg', 'Midazolam'), 
('1729', 'Clonapex   2 mg', '170-0239-046', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Clonazepam'), 
('1730', 'Lexopam   3 mg', '170-02407', 'Tablet', 'Apex Pharmaceuticals Ltd.', '3.00', '0.00', '3 mg', 'Bromazepam'), 
('1731', 'Zapitor   20 mg', '170-0241-061', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Atorvastatin'), 
('1732', 'Nexe   40 mg', '170-0242-67', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Esomeprazole'), 
('1733', 'Bacspa   5 mg', '170-0243-70', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Baclofen'), 
('1734', 'Alafree20   120 mg', '170-0247-21', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('1735', 'Alafree80   180 mg', '170-0248-21', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('1736', 'Supergra0   50 mg', '170-0250-043', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Sildenafil'), 
('1737', 'Gemifix   320 mg', '170-0253-23', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '320 mg', 'Gemefloxacin'), 
('1738', 'Clonapex.5   .5 mg', '170-0254-046', 'Tablet', 'Apex Pharmaceuticals Ltd.', '5.00', '0.00', '.5 mg', 'Clonazepam'), 
('1739', 'Adnor 3   3 mg', '170-0257-', 'Tablet', 'Apex Pharmaceuticals Ltd.', '5.00', '0.00', '3 mg', 'Doxepin'), 
('1740', 'Xiva   400 mg', '170-02604', 'Tablet', 'Apex Pharmaceuticals Ltd.', '10.01', '0.00', '400 mg', 'Doxophylline'), 
('1741', 'Bomifix 8   8 mg', '170-02758', 'Tablet', 'Apex Pharmaceuticals Ltd.', '10.00', '0.00', '8 mg', 'Ondansetron'), 
('1742', 'Lerupa   10 mg', '170-0282-021', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Rupatadine'), 
('1743', 'Osovastmg   10 mg', '170-0283-061', 'Tablet', 'Apex Pharmaceuticals Ltd.', '20.00', '0.00', '10 mg', 'Rosuvastatin'), 
('1744', 'Cidogrel   75 mg', '170-0281-026', 'Tablet', 'Apex Pharmaceuticals Ltd.', '12.00', '0.00', '75 mg', 'Clopidogrel'), 
('1745', 'Xoricard   20 mg', '170-0280-022', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('1746', 'Nohist   10 mg', '170-0278-021', 'Tablet', 'Apex Pharmaceuticals Ltd.', '3.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1747', 'Xisrol   5 mg', '170-0279-022', 'Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('1748', 'Keptrix IV   1 gm', '170-0164-23', 'IV Injection', 'Apex Pharmaceuticals Ltd.', '185.00', '0.00', '1 gm', 'Ceftriaxone'), 
('1749', 'Keptrex IV   500 mg', '170-0165-23', 'IV Injection', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('1750', 'Keptrix IV   250 mg', '170-0166-23', 'IV Injection', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('1751', 'Keptrix G   2 gm', '170-0189-23', 'IV Injection', 'Apex Pharmaceuticals Ltd.', '290.00', '0.00', '2 gm', 'Ceftriaxone'), 
('1752', 'Flurom   .1 %', '170-02052', 'Eye Drops', 'Apex Pharmaceuticals Ltd.', '80.00', '0.00', '.1 %', 'Fluorometholone'), 
('1753', 'Aljen   .025 %', '170-02142', 'Eye Drops', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '.025 %', 'Ketotifen'), 
('1754', 'Timolol.5%   .5 %', '170-02192', 'Eye Drops', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '.5 %', 'Timolol Maleate'), 
('1755', 'Protix   10 mg', '170-01348', 'Dispersible Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('1756', 'A-One XR   665 mg', '170-0274-6', 'Xr Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '665 mg', 'Paracetamol'), 
('1757', 'Metle   500 mg', '170-0271', 'Xr Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1758', 'Apeclo SR   200 mg', '170-0252-64', 'Er Tablet', 'Apex Pharmaceuticals Ltd.', '5.00', '0.00', '200 mg', 'Aceclofenac'), 
('1759', 'Aspra  SR    20 mg', '170-0113', 'Sr Tablet', 'Apex Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('1760', 'Apcilin   250 mg', '076-0035-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Ampicillin'), 
('1761', 'Apimox   500 mg', '076-0060-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('1762', 'Apimox   250 mg', '076-0037-023', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '2.83', '0.00', '250 mg', 'Amoxicillin'), 
('1763', 'Asef   500 mg', '076-0051-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('1764', 'Atron   250 mg', '076-0018-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '1.16', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('1765', 'Cloxa   500 mg', '076-0038-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '5.71', '0.00', '500 mg', 'Cloxacillin'), 
('1766', 'Doxa      100 mg', '076-0052-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('1767', 'Hk      20 mg', '076-0062-67', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('1768', 'Hk      40 mg', '076-0063-67', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '40 mg', 'Omeprazole'), 
('1769', 'Sofa   250 mg', '076-0061-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('1770', 'Acefra   500 mg', '076--23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('1771', 'Apiclox   250 mg', '076-0016-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '2.53', '0.00', '250 mg', 'Chloramphenicol'), 
('1772', 'AX-3   200 mg', '076-0088-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('1773', 'Esmepra   20 mg', '076-0096-067', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '6.50', '0.00', '20 mg', 'Esomeprazole'), 
('1774', 'Conazole   50 mg', '076-0080', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('1775', 'Sofa0   500 mg', '076-0078-23', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('1776', 'Diclo-TR   100 mg', '076-0082-64', 'Capsule', 'Apollo Pharmaceutical Laboratories Ltd.', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1777', 'Alert   10 mg', '076-0058-21', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '2.73', '0.00', '10 mg', 'Loratadine'), 
('1778', 'Aminol      100 mg', '076-0036-22', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Atenolol'), 
('1779', 'Apigamon   500 mg', '076-0042-23', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '3.95', '0.00', '500 mg', 'Nalidixic Acid'), 
('1780', 'Aspirin0   300 mg', '076-0028-6', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '0.00', '0.00', '300 mg', 'Aspirin'), 
('1781', 'Cipro   500 mg', '076-0046-23', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '10.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('1782', 'Diclo      50 mg', '076-0045-64', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '0.40', '0.00', '50 mg', 'Diclofenac Sodium'), 
('1783', 'H2      150 mg', '076-00445', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('1784', 'Histin   4 mg', '076-0029-21', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '0.21', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('1785', 'Hylac   10 mg', '076-00261', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '1.81', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('1786', 'Ibuflam   400 mg', '076-0050-64', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '1.11', '0.00', '400 mg', 'Ibuprofen'), 
('1787', 'Promel   500 mg', '076-0027-006', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '0.53', '0.00', '500 mg', 'Paracetamol'), 
('1788', 'Promex      100 mg', '076-0031-8', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '0.71', '0.00', '100 mg', 'Mebendazole'), 
('1789', 'Protopa      20 mg', '076-0059-67', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '4.00', '0.00', '20 mg', 'Pantoprazole'), 
('1790', 'Spardon      200 mg', '076-0076-23', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '16.00', '0.00', '200 mg', 'Sparfloxacin'), 
('1791', 'Apzyl   400 mg', '076-0029-27', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '1.07', '0.00', '400 mg', 'Metronidazole'), 
('1792', 'Apozyth   500 mg', '076-0086-23', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '33.33', '0.00', '500 mg', 'Azithromycin'), 
('1793', 'Apoket   10 mg', '076-0091-064', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1794', 'Aptofen   1 mg', '076-0092-21', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '2.00', '0.00', '1 mg', 'Ketotifen'), 
('1795', 'Apedom   10 mg', '076-00688', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('1796', 'Acflam   100 mg', '076-0074-64', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '4.00', '0.00', '100 mg', 'Aceclofenac'), 
('1797', 'Levodon   500 mg', '076-0081-23', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '15.00', '0.00', '500 mg', 'Levofloxacin'), 
('1798', 'Calfeed   1250 mg', '076-0070-62', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '2.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1799', 'Albezole   400 mg', '076-0057-008', 'Tablet', 'Apollo Pharmaceutical Laboratories Ltd.', '3.80', '0.00', '400 mg', 'Albendazole'), 
('1800', 'Afix      200 mg', '143-0129-23', 'Capsule', 'Aristopharma Limited', '35.00', '0.00', '200 mg', 'Cefixime'), 
('1801', 'Anticol   15 mg', '143-0127-67', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '15 mg', 'Lansoprazole'), 
('1802', 'Anzo   30 mg', '143-0128-67', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '30 mg', 'Lansoprazole'), 
('1803', 'Aristocef   250 mg', '143-0033-23', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '250 mg', 'Cephalexin'), 
('1804', 'Aristocef   500 mg', '143-0043-23', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('1805', 'Aristodox      100 mg', '143-0048-23', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('1806', 'Aristomox   500 mg', '143-0114-23', 'Capsule', 'Aristopharma Limited', '6.75', '0.00', '500 mg', 'Amoxicillin'), 
('1807', 'Aristomox   250 mg', '143-0024-023', 'Capsule', 'Aristopharma Limited', '3.50', '0.00', '250 mg', 'Amoxicillin'), 
('1808', 'Erdon  TR    100 mg', '143-0095-64', 'Capsule', 'Aristopharma Limited', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('1809', 'Arovan      40 mg', '143-0227-22', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '40 mg', 'Valsartan'), 
('1810', 'Arovan   80 mg', '143-0228-22', 'Capsule', 'Aristopharma Limited', '10.00', '0.00', '80 mg', 'Valsartan'), 
('1811', 'Az   250 mg', '143-0112-23', 'Capsule', 'Aristopharma Limited', '25.00', '0.00', '250 mg', 'Azithromycin'), 
('1812', 'Az   500 mg', '143-0135-23', 'Capsule', 'Aristopharma Limited', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('1813', 'Diflu      50 mg', '143-0140', 'Capsule', 'Aristopharma Limited', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('1814', 'Diflu      150 mg', '143-0141', 'Capsule', 'Aristopharma Limited', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('1815', 'Extracef   250 mg', '143-0104-023', 'Capsule', 'Aristopharma Limited', '6.50', '0.00', '250 mg', 'Cephradine'), 
('1816', 'Extracef   500 mg', '143-0105-23', 'Capsule', 'Aristopharma Limited', '15.00', '0.00', '500 mg', 'Cephradine'), 
('1817', 'Gemfil   300 mg', '143-0237-61', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '300 mg', 'Gemfibrozil'), 
('1818', 'Nitrocard  SR .6   2.6 mg', '143-0235', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('1819', 'Omep   10 mg', '143-0134-67', 'Capsule', 'Aristopharma Limited', '2.00', '0.00', '10 mg', 'Omeprazole'), 
('1820', 'Omep      20 mg', '143-0119-67', 'Capsule', 'Aristopharma Limited', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('1821', 'Omep      40 mg', '143-0126-67', 'Capsule', 'Aristopharma Limited', '8.00', '0.00', '40 mg', 'Omeprazole'), 
('1822', 'Reumacap   25 mg', '143-0021-64', 'Capsule', 'Aristopharma Limited', '1.00', '0.00', '25 mg', 'Indomethacin'), 
('1823', 'Reumacap  SR   75 mg', '143-0240-64', 'Capsule', 'Aristopharma Limited', '4.00', '0.00', '75 mg', 'Indomethacin'), 
('1824', 'Stafoxin   250 mg', '143-0058-23', 'Capsule', 'Aristopharma Limited', '5.50', '0.00', '250 mg', 'Flucloxacillin'), 
('1825', 'Stafoxin   500 mg', '143-0115-23', 'Capsule', 'Aristopharma Limited', '10.00', '0.00', '500 mg', 'Flucloxacillin'), 
('1826', 'Taxetil      200 mg', '143-0276-23', 'Capsule', 'Aristopharma Limited', '40.00', '0.00', '200 mg', 'Cefpodoxime'), 
('1827', 'Taxetil      100 mg', '143-0164-23', 'Capsule', 'Aristopharma Limited', '22.00', '0.00', '100 mg', 'Cefpodoxime'), 
('1828', 'Tetracycline   250 mg', '143-0070-23', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('1829', 'Tetracycline0   500 mg', '143-0073-23', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '500 mg', 'Tetracycline Hydrochloride'), 
('1830', 'Tramacap      50 mg', '143-0122-65', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('1831', 'Hemostat   500 mg', '143-03589', 'Capsule', 'Aristopharma Limited', '20.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('1832', 'Tigicon      200 mg', '143-0360-61', 'Capsule', 'Aristopharma Limited', '7.00', '0.00', '200 mg', 'Fenofibrate'), 
('1833', 'Afix   400 mg', '143-0367-23', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '400 mg', 'Cefixime'), 
('1834', 'Nimodol0   300 mg', '143-0378-64', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '300 mg', 'Etodolac'), 
('1835', 'Emep E/C   20 mg', '143-0406-067', 'Capsule', 'Aristopharma Limited', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('1836', 'Emep E/C   40 mg', '143-0407-067', 'Capsule', 'Aristopharma Limited', '9.00', '0.00', '40 mg', 'Esomeprazole'), 
('1837', 'Neurovan   75 mg', '143-0425-046', 'Capsule', 'Aristopharma Limited', '16.00', '0.00', '75 mg', 'Pregabalin'), 
('1838', 'Neurovan   150 mg', '143-0426-046', 'Capsule', 'Aristopharma Limited', '30.00', '0.00', '150 mg', 'Pregabalin'), 
('1839', 'Antiflu   75 mg', '143-0427-32', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '75 mg', 'Oseltamivir'), 
('1840', 'Antiflu5   45 mg', '143-0432-32', 'Capsule', 'Aristopharma Limited', '0.00', '0.00', '45 mg', 'Oseltamivir'), 
('1841', 'Diflu   200 mg', '143-0445', 'Capsule', 'Aristopharma Limited', '25.00', '0.00', '200 mg', 'Fluconazole'), 
('1842', 'Clinex   300 mg', '143-0457-23', 'Capsule', 'Aristopharma Limited', '15.00', '0.00', '300 mg', 'Clindamycin'), 
('1843', 'Prostanil MR   400 mcg', '143-04669', 'Capsule', 'Aristopharma Limited', '10.00', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('1844', 'Neurovan   50 mg', '143-0492-046', 'Capsule', 'Aristopharma Limited', '12.00', '0.00', '50 mg', 'Pregabalin'), 
('1845', 'Clinex   150 mg', '143-0530-23', 'Capsule', 'Aristopharma Limited', '8.00', '0.00', '150 mg', 'Clindamycin'), 
('1846', 'Siloflo   4 mg', '143-06299', 'Capsule', 'Aristopharma Limited', '8.00', '0.00', '4 mg', 'Silodosin'), 
('1847', 'Siloflo 8   8 mg', '143-06309', 'Capsule', 'Aristopharma Limited', '15.00', '0.00', '8 mg', 'Silodosin'), 
('1848', 'Neurovan   25 mg', '143-0633-046', 'Capsule', 'Aristopharma Limited', '8.00', '0.00', '25 mg', 'Pregabalin'), 
('1849', 'Silvadazin%   1 %', '143-0091-23', 'Cream', 'Aristopharma Limited', '45.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('1850', 'Water For Injection   10 ml', '143-0205-79', 'Injection', 'Aristopharma Limited', '4.90', '0.00', '10 ml', 'Water For Injection'), 
('1851', 'Water For Injection   5 ml', '143-0204-79', 'Injection', 'Aristopharma Limited', '3.32', '0.00', '5 ml', 'Water For Injection'), 
('1852', 'Water for Injection   2 ml', '143-0503-79', 'Injection', 'Aristopharma Limited', '0.00', '0.00', '2 ml', 'Water For Injection'), 
('1853', 'Avolac   Oral   68 %', '143-0071-60', 'Oral Solution', 'Aristopharma Limited', '140.00', '0.00', '68 %', 'Lactulose'), 
('1854', 'Xpa25   125 mg', '143-0480-006', 'Suppository', 'Aristopharma Limited', '5.00', '0.00', '125 mg', 'Paracetamol'), 
('1855', 'Xpa   250 mg', '143-0481-006', 'Suppository', 'Aristopharma Limited', '6.00', '0.00', '250 mg', 'Paracetamol'), 
('1856', 'Xpa0   500 mg', '143-0482-006', 'Suppository', 'Aristopharma Limited', '9.00', '0.00', '500 mg', 'Paracetamol'), 
('1857', 'Apuldon   15 mg', '143-04838', 'Suppository', 'Aristopharma Limited', '6.00', '0.00', '15 mg', 'Domperidone'), 
('1858', 'Apuldon   30 mg', '143-04848', 'Suppository', 'Aristopharma Limited', '9.00', '0.00', '30 mg', 'Domperidone'), 
('1859', 'Reumacid   100 mg', '143-0485-64', 'Suppository', 'Aristopharma Limited', '9.00', '0.00', '100 mg', 'Indomethacin'), 
('1860', 'Tramacid   100 mg', '143-0486-65', 'Suppository', 'Aristopharma Limited', '15.00', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('1861', 'Erdon   50 mg', '143-0487-64', 'Suppository', 'Aristopharma Limited', '15.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('1862', 'Apulset   16 mg', '143-05998', 'Suppository', 'Aristopharma Limited', '15.00', '0.00', '16 mg', 'Ondansetron'), 
('1863', 'A Mycin   250 mg', '143-0061-23', 'Tablet', 'Aristopharma Limited', '5.15', '0.00', '250 mg', 'Erythromycin'), 
('1864', 'A Mycin   500 mg', '143-0078-23', 'Tablet', 'Aristopharma Limited', '9.00', '0.00', '500 mg', 'Erythromycin'), 
('1865', 'Abentel   400 mg', '143-0080-008', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '400 mg', 'Albendazole'), 
('1866', 'Acliz   50 mg', '143-02248', 'Tablet', 'Aristopharma Limited', '2.50', '0.00', '50 mg', 'Meclizine Hydrochloride'), 
('1867', 'Actine      5 mg', '143-0233', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '5 mg', 'Glipizide'), 
('1868', 'Agoxin   250 mcg', '143-0232-35', 'Tablet', 'Aristopharma Limited', '1.09', '0.00', '250 mcg', 'Digoxin'), 
('1869', 'Alexid      200 mg', '143-0184-23', 'Tablet', 'Aristopharma Limited', '15.00', '0.00', '200 mg', 'Pivmecillinam'), 
('1870', 'Alfa E     200 mg', '143-0108-78', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '200 mg', 'Vitamin E'), 
('1871', 'Ametil   5 mg', '143-00308', 'Tablet', 'Aristopharma Limited', '0.46', '0.00', '5 mg', 'Prochlorperazine Maleate'), 
('1872', 'Aplet      100 mg', '143-0256-36', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '100 mg', 'Cilostazol'), 
('1873', 'Aplet      50 mg', '143-0255-36', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '50 mg', 'Cilostazol'), 
('1874', 'Aprocin   250 mg', '143-0049-23', 'Tablet', 'Aristopharma Limited', '8.50', '0.00', '250 mg', 'Ciprofloxacin'), 
('1875', 'Aprocin   500 mg', '143-0079-23', 'Tablet', 'Aristopharma Limited', '15.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('1876', 'Aprozil   500 mg', '143-0283-23', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '500 mg', 'Cefprozil'), 
('1877', 'Apuldon   10 mg', '143-01478', 'Tablet', 'Aristopharma Limited', '2.50', '0.00', '10 mg', 'Domperidone'), 
('1878', 'Arotril   .5 mg', '143-0210-046', 'Tablet', 'Aristopharma Limited', '4.00', '0.00', '.5 mg', 'Clonazepam'), 
('1879', 'Arotril   2 mg', '143-0209-046', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '2 mg', 'Clonazepam'), 
('1880', 'Aspin      75 mg', '143-0067-26', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '75 mg', 'Aspirin'), 
('1881', 'Axim   125 mg', '143-0156-23', 'Tablet', 'Aristopharma Limited', '15.00', '0.00', '125 mg', 'Cefuroxime'), 
('1882', 'Axim   250 mg', '143-0157-23', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '250 mg', 'Cefuroxime'), 
('1883', 'Calbon   1250 mg', '143-0133-62', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('1884', 'Calcitab   300 mg', '143-0057-62', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '300 mg', 'Calcium Lactate'), 
('1885', 'Caljuven   Chewable   625 mg', '143-0146-62', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '625 mg', 'Calcium Carbonate'), 
('1886', 'Carmaz      200 mg', '143-0236-046', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '200 mg', 'Carbamazepine'), 
('1887', 'Clovul      50 mg', '143-02183', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '50 mg', 'Clomiphene Citrate'), 
('1888', 'Contine  CR    250 mg', '143-02114', 'Tablet', 'Aristopharma Limited', '1.77', '0.00', '250 mg', 'Theophylline'), 
('1889', 'Contine  CR   400 mg', '143-02124', 'Tablet', 'Aristopharma Limited', '2.98', '0.00', '400 mg', 'Theophylline'), 
('1890', 'Emep      20 mg', '143-0261-067', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('1891', 'Evalin      5 mg', '143-0015-057', 'Tablet', 'Aristopharma Limited', '0.68', '0.00', '5 mg', 'Diazepam'), 
('1892', 'Fusidate   250 mg', '143-0159-23', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '250 mg', 'Sodium Fusidate'), 
('1893', 'Giran6   16 mg', '143-0222-22', 'Tablet', 'Aristopharma Limited', '11.00', '0.00', '16 mg', 'Candesartan Cilexetil'), 
('1894', 'Giran   8 mg', '143-0221-22', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '8 mg', 'Candesartan Cilexetil'), 
('1895', 'Glucomet   850 mg', '143-0111', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('1896', 'Glucomet  XR   500 mg', '143-0282', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1897', 'Glucomet   500 mg', '143-0039', 'Tablet', 'Aristopharma Limited', '4.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('1898', 'Gluconor   1 mg', '143-0253', 'Tablet', 'Aristopharma Limited', '4.50', '0.00', '1 mg', 'Glimepiride'), 
('1899', 'Gluconor   2 mg', '143-0254', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '2 mg', 'Glimepiride'), 
('1900', 'Glucozid   80 mg', '143-0107', 'Tablet', 'Aristopharma Limited', '7.00', '0.00', '80 mg', 'Gliclazide'), 
('1901', 'Glucozon   15 mg', '143-0163', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '15 mg', 'Pioglitazone'), 
('1902', 'ISM      20 mg', '143-0077', 'Tablet', 'Aristopharma Limited', '1.20', '0.00', '20 mg', 'Isosorbide Mononitrate'), 
('1903', 'Lomeflox   400 mg', '143-0100-23', 'Tablet', 'Aristopharma Limited', '15.00', '0.00', '400 mg', 'Lomefloxacin'), 
('1904', 'TCL R     20 mg', '143-0155-061', 'Tablet', 'Aristopharma Limited', '18.00', '0.00', '20 mg', 'Atorvastatin'), 
('1905', 'Loradin   10 mg', '143-0125-21', 'Tablet', 'Aristopharma Limited', '3.00', '0.00', '10 mg', 'Loratadine'), 
('1906', 'Lumeran      150 mg', '143-00275', 'Tablet', 'Aristopharma Limited', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('1907', 'Lumeran0   300 mg', '143-00535', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '300 mg', 'Ranitidine'), 
('1908', 'Malarium   250 mg', '143-0239-24', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '250 mg', 'Mefloquine'), 
('1909', 'Mecol   .5 mg', '143-0262-78', 'Tablet', 'Aristopharma Limited', '4.00', '0.00', '.5 mg', 'Mecobalamin'), 
('1910', 'Mervan   100 mg', '143-0217-64', 'Tablet', 'Aristopharma Limited', '4.00', '0.00', '100 mg', 'Aceclofenac'), 
('1911', 'Metrodol   400 mg', '143-0220-27', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('1912', 'Musclex      50 mg', '143-0270-70', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '50 mg', 'Tolperisone Hydrochloride'), 
('1913', 'Nalix   500 mg', '143-0082-23', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '500 mg', 'Nalidixic Acid'), 
('1914', 'Napro   250 mg', '143-0056-64', 'Tablet', 'Aristopharma Limited', '4.20', '0.00', '250 mg', 'Naproxen'), 
('1915', 'Napro   500 mg', '143-0072-64', 'Tablet', 'Aristopharma Limited', '7.00', '0.00', '500 mg', 'Naproxen'), 
('1916', 'Nezox   400 mg', '143-0229-023', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '400 mg', 'Linezolid'), 
('1917', 'Nezox   600 mg', '143-0250-023', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '600 mg', 'Linezolid'), 
('1918', 'Nitrocard  SR .6   2.6 mg', '143-0274', 'Tablet', 'Aristopharma Limited', '4.00', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('1919', 'Norp   2 mg', '143-0257-22', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '2 mg', 'Lacidipine'), 
('1920', 'Norp   4 mg', '143-0258-22', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '4 mg', 'Lacidipine'), 
('1921', 'Notens   3 mg', '143-02197', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '3 mg', 'Bromazepam'), 
('1922', 'Omniflox      200 mg', '143-0110-23', 'Tablet', 'Aristopharma Limited', '18.00', '0.00', '200 mg', 'Sparfloxacin'), 
('1923', 'Optimox   400 mg', '143-0247-23', 'Tablet', 'Aristopharma Limited', '40.00', '0.00', '400 mg', 'Moxifloxacin'), 
('1924', 'Oradol   10 mg', '143-0120-064', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('1925', 'Osartan      50 mg', '143-0143-022', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '50 mg', 'Losartan Potassium'), 
('1926', 'Ovel   500 mg', '143-0260-23', 'Tablet', 'Aristopharma Limited', '15.00', '0.00', '500 mg', 'Levofloxacin'), 
('1927', 'Pinor   25 mg', '143-02234', 'Tablet', 'Aristopharma Limited', '4.00', '0.00', '25 mg', 'Imipramine Hydrochloride'), 
('1928', 'Proton P     40 mg', '143-0151-67', 'Tablet', 'Aristopharma Limited', '7.00', '0.00', '40 mg', 'Pantoprazole'), 
('1929', 'Proton P     20 mg', '143-0183-67', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '20 mg', 'Pantoprazole'), 
('1930', 'Rehaf   5 mg', '143-0249-21', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('1931', 'Rhinil   10 mg', '143-0096-21', 'Tablet', 'Aristopharma Limited', '3.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('1932', 'Soval      200 mg', '143-02266', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '200 mg', 'Sodium Valproate'), 
('1933', 'Stafen   1 mg', '143-0051-21', 'Tablet', 'Aristopharma Limited', '2.00', '0.00', '1 mg', 'Ketotifen'), 
('1934', 'TCL   10 mg', '143-0154-061', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('1935', 'Xpa   500 mg', '143-0016-006', 'Tablet', 'Aristopharma Limited', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('1936', 'Tenocard      50 mg', '143-0040-22', 'Tablet', 'Aristopharma Limited', '0.75', '0.00', '50 mg', 'Atenolol'), 
('1937', 'Terbifin   250 mg', '143-0149', 'Tablet', 'Aristopharma Limited', '50.00', '0.00', '250 mg', 'Terbinafine'), 
('1938', 'Thiobion      100 mg', '143-0065-78', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('1939', 'VC   250 mg', '143-0068-78', 'Tablet', 'Aristopharma Limited', '1.30', '0.00', '250 mg', 'Vitamin C'), 
('1940', 'Vinton      5 mg', '143-0074-36', 'Tablet', 'Aristopharma Limited', '4.00', '0.00', '5 mg', 'Vinpocetine'), 
('1941', 'Zincin   15 mg', '143-0052-21', 'Tablet', 'Aristopharma Limited', '1.00', '0.00', '15 mg', 'Cinnarizine'), 
('1942', 'Zofen   500 mcg', '143-01217', 'Tablet', 'Aristopharma Limited', '3.10', '0.00', '500 mcg', 'Pizotifen'), 
('1943', 'Zofen  TS   1.5 mg', '143-01367', 'Tablet', 'Aristopharma Limited', '7.20', '0.00', '1.5 mg', 'Pizotifen'), 
('1944', 'Axim   500 mg', '143-0296-23', 'Tablet', 'Aristopharma Limited', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('1945', 'Oralzin      20 mg', '143-0287-62', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '20 mg', 'Zinc'), 
('1946', 'Veralgin   50 mg', '143-03071', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('1947', 'Osartan      25 mg', '143-0334-022', 'Tablet', 'Aristopharma Limited', '4.50', '0.00', '25 mg', 'Losartan Potassium'), 
('1948', 'Athorel      75 mg', '143-0337-26', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '75 mg', 'Clopidogrel'), 
('1949', 'Ivactin   3 mg', '143-0325-8', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '3 mg', 'Ivermectin'), 
('1950', 'Sleepil   1 mg', '143-0344-057', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '1 mg', 'Eszopiclone'), 
('1951', 'Sleepil   2 mg', '143-0345-057', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '2 mg', 'Eszopiclone'), 
('1952', 'Nitoxin   500 mg', '143-0336-27', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '500 mg', 'Nitazoxanide'), 
('1953', 'Metacard  MR   35 mg', '143-0338', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '35 mg', 'Trimetazidine Dihydrochloride'), 
('1954', 'Asmolex L   1 mg', '143-03414', 'Tablet', 'Aristopharma Limited', '0.80', '0.00', '1 mg', 'Levosalbutamol'), 
('1955', 'Asmolex L   2 mg', '143-03424', 'Tablet', 'Aristopharma Limited', '1.50', '0.00', '2 mg', 'Levosalbutamol'), 
('1956', 'Az   250 mg', '143-0371-23', 'Tablet', 'Aristopharma Limited', '25.00', '0.00', '250 mg', 'Azithromycin'), 
('1957', 'Az   500 mg', '143-0372-23', 'Tablet', 'Aristopharma Limited', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('1958', 'Nimodol  SR    600 mg', '143-0379-64', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '600 mg', 'Etodolac'), 
('1959', 'Reumazin   500 mg', '143-0388-64', 'Tablet', 'Aristopharma Limited', '5.20', '0.00', '500 mg', 'Sulfasalazine'), 
('1960', 'Baclovan   10 mg', '143-0389-70', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '10 mg', 'Baclofen'), 
('1961', 'Vazlepe   500 mg', '143-0390-64', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '500 mg', 'Glucosamine'), 
('1962', 'Aprocin0   750 mg', '143-0392-23', 'Tablet', 'Aristopharma Limited', '18.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('1963', 'Ramilok   2.5 mg', '143-0395-022', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '2.5 mg', 'Ramipril'), 
('1964', 'Ramilok   5 mg', '143-0396-022', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '5 mg', 'Ramipril'), 
('1965', 'Xicotil F/C   20 mg', '143-0397-64', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '20 mg', 'Tenoxicam'), 
('1966', 'Xelix SR   1.5 mg', '143-03982', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '1.5 mg', 'Indapamide'), 
('1967', 'Ancor F/C   2.5 mg', '143-0399-22', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('1968', 'Ancor F/C   5 mg', '143-0400-22', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('1969', 'Afix   200 mg', '143-0401-23', 'Tablet', 'Aristopharma Limited', '35.00', '0.00', '200 mg', 'Cefixime'), 
('1970', 'Afix0   400 mg', '143-0402-23', 'Tablet', 'Aristopharma Limited', '50.00', '0.00', '400 mg', 'Cefixime'), 
('1971', 'Rabe   20 mg', '143-0405-67', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('1972', 'Epalres F/C   50 mg', '143-0410-76', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '50 mg', 'Epalrestat'), 
('1973', 'Axofen   60 mg', '143-0411-21', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('1974', 'Axofen   120 mg', '143-0412-21', 'Tablet', 'Aristopharma Limited', '7.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('1975', 'Axofen80   180 mg', '143-0413-21', 'Tablet', 'Aristopharma Limited', '9.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('1976', 'Ruvastin   5 mg', '143-0417-61', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '5 mg', 'Rosuvastatin'), 
('1977', 'Ruvastin   10 mg', '143-0418-61', 'Tablet', 'Aristopharma Limited', '20.00', '0.00', '10 mg', 'Rosuvastatin'), 
('1978', 'Montril   4 mg', '143-0419-044', 'Tablet', 'Aristopharma Limited', '7.00', '0.00', '4 mg', 'Montelukast'), 
('1979', 'Montril   5 mg', '143-0420-044', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '5 mg', 'Montelukast'), 
('1980', 'Montril   10 mg', '143-0421-044', 'Tablet', 'Aristopharma Limited', '15.00', '0.00', '10 mg', 'Montelukast'), 
('1981', 'Etovan   60 mg', '143-0428-64', 'Tablet', 'Aristopharma Limited', '7.00', '0.00', '60 mg', 'Etoricoxib'), 
('1982', 'Etovan   90 mg', '143-0429-64', 'Tablet', 'Aristopharma Limited', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('1983', 'Etovan   120 mg', '143-0430-64', 'Tablet', 'Aristopharma Limited', '14.00', '0.00', '120 mg', 'Etoricoxib'), 
('1984', 'Pilogen   5 mg', '143-0431-37', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '5 mg', 'Pilocarpine Hydrochloride'), 
('1985', 'Xolam.5 XR   .5 mg', '143-04427', 'Tablet', 'Aristopharma Limited', '2.00', '0.00', '.5 mg', 'Alprazolam'), 
('1986', 'Ancor   10 mg', '143-0444-22', 'Tablet', 'Aristopharma Limited', '16.00', '0.00', '10 mg', 'Bisoprolol Hemifumarate'), 
('1987', 'Tecavir.5   .5 mg', '143-0447-32', 'Tablet', 'Aristopharma Limited', '48.00', '0.00', '.5 mg', 'Entecavir'), 
('1988', 'Tecavir   1 mg', '143-0448-32', 'Tablet', 'Aristopharma Limited', '90.00', '0.00', '1 mg', 'Entecavir'), 
('1989', 'Ivacard   5 mg', '143-0449', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '5 mg', 'Ivabradine'), 
('1990', 'Ivacard   7.5 mg', '143-0450', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '7.5 mg', 'Ivabradine'), 
('1991', 'Dormax   7.5 mg', '143-0455-057', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '7.5 mg', 'Midazolam'), 
('1992', 'Betacard   50 mg', '143-0467-22', 'Tablet', 'Aristopharma Limited', '2.00', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('1993', 'Cortisol   5 mg', '143-0494-72', 'Tablet', 'Aristopharma Limited', '1.70', '0.00', '5 mg', 'Prednisolone'), 
('1994', 'Cortisol   10 mg', '143-0495-72', 'Tablet', 'Aristopharma Limited', '3.20', '0.00', '10 mg', 'Prednisolone'), 
('1995', 'Cortisol   20 mg', '143-0496-72', 'Tablet', 'Aristopharma Limited', '6.25', '0.00', '20 mg', 'Prednisolone'), 
('1996', 'Piramax   800 mg', '143-0504', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '800 mg', 'Piracetam'), 
('1997', 'Contine0 CR   200 mg', '143-05084', 'Tablet', 'Aristopharma Limited', '1.60', '0.00', '200 mg', 'Theophylline'), 
('1998', 'Contine CR   300 mg', '143-05094', 'Tablet', 'Aristopharma Limited', '2.35', '0.00', '300 mg', 'Theophylline'), 
('1999', 'Solifen   5 mg', '143-05121', 'Tablet', 'Aristopharma Limited', '20.00', '0.00', '5 mg', 'Solifenacin Succinate'), 
('2000', 'Febux   40 mg', '143-0513-76', 'Tablet', 'Aristopharma Limited', '12.00', '0.00', '40 mg', 'Febuxostat'), 
('2001', 'Febux   80 mg', '143-0514-76', 'Tablet', 'Aristopharma Limited', '22.00', '0.00', '80 mg', 'Febuxostat'), 
('2002', 'Arotril   1 mg', '143-05226', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '1 mg', 'Clonazepam'), 
('2003', 'Rupa   10 mg', '143-0525-21', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '10 mg', 'Rupatadine'), 
('2004', 'Pitavas   2 mg', '143-0526-61', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '2 mg', 'Pitavastatin'), 
('2005', 'Prasucard   5 mg', '143-0535-26', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '5 mg', 'Prasugrel'), 
('2006', 'Prasucard   10 mg', '143-0536-26', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '10 mg', 'Prasugrel'), 
('2007', 'Gluvan   50 mg', '143-0537', 'Tablet', 'Aristopharma Limited', '20.00', '0.00', '50 mg', 'Vildagliptin'), 
('2008', 'Lodipin   10 mg', '143-0539-022', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '10 mg', 'Amlodipine'), 
('2009', 'Tenvira   300 mg', '143-0557-32', 'Tablet', 'Aristopharma Limited', '85.00', '0.00', '300 mg', 'Tenofovir Disoproxil Fumarate'), 
('2010', 'Hepaximin   200 mg', '143-0560-23', 'Tablet', 'Aristopharma Limited', '20.00', '0.00', '200 mg', 'Rifaximin'), 
('2011', 'Hepaximin50   550 mg', '143-0561-23', 'Tablet', 'Aristopharma Limited', '45.00', '0.00', '550 mg', 'Rifaximin'), 
('2012', 'V-Gra   100 mg', '143-0570-043', 'Tablet', 'Aristopharma Limited', '50.00', '0.00', '100 mg', 'Sildenafil'), 
('2013', 'V-Gra   50 mg', '143-0571-043', 'Tablet', 'Aristopharma Limited', '30.00', '0.00', '50 mg', 'Sildenafil'), 
('2014', 'V-Gra   25 mg', '143-0572-043', 'Tablet', 'Aristopharma Limited', '16.00', '0.00', '25 mg', 'Sildenafil'), 
('2015', 'Pawar   20 mg', '143-0573-043', 'Tablet', 'Aristopharma Limited', '60.00', '0.00', '20 mg', 'Tadalafil'), 
('2016', 'Pawar   10 mg', '143-0574-043', 'Tablet', 'Aristopharma Limited', '35.00', '0.00', '10 mg', 'Tadalafil'), 
('2017', 'Pawar   5 mg', '143-0575-043', 'Tablet', 'Aristopharma Limited', '18.00', '0.00', '5 mg', 'Tadalafil'), 
('2018', 'Arolast   500 mcg', '143-05764', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '500 mcg', 'Roflumilast'), 
('2019', 'Linaglip   5 mg', '143-0592-015', 'Tablet', 'Aristopharma Limited', '20.00', '0.00', '5 mg', 'Linagliptin'), 
('2020', 'Ibandron   150 mg', '143-0593-048', 'Tablet', 'Aristopharma Limited', '1200.00', '0.00', '150 mg', 'Ibandronic Acid'), 
('2021', 'Apulset   4 mg', '143-05958', 'Tablet', 'Aristopharma Limited', '6.00', '0.00', '4 mg', 'Ondansetron'), 
('2022', 'Apulset 8   8 mg', '143-05968', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '8 mg', 'Ondansetron'), 
('2023', 'Aromatin   1 mg', '143-0607', 'Tablet', 'Aristopharma Limited', '50.00', '0.00', '1 mg', 'Anastrozol'), 
('2024', 'Thormon   50 mcg', '143-0610-74', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '50 mcg', 'Levothyroxine Sodium'), 
('2025', 'Lorenzo   2.5 mg', '143-0611', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '2.5 mg', 'Letrozole'), 
('2026', 'Docopa   400 mg', '143-06124', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '400 mg', 'Doxophylline'), 
('2027', 'Flacort   6 mg', '143-0621-72', 'Tablet', 'Aristopharma Limited', '8.00', '0.00', '6 mg', 'Deflazacort'), 
('2028', 'Presulock   20 mg', '143-0623-22', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('2029', 'Docopa   200 mg', '143-06324', 'Tablet', 'Aristopharma Limited', '5.00', '0.00', '200 mg', 'Doxophylline'), 
('2030', 'Sofo-C   400 mg', '143-0634-32', 'Tablet', 'Aristopharma Limited', '600.00', '0.00', '400 mg', 'Sofosbuvir'), 
('2031', 'Maxineb   2.5 mg', '143-0637-22', 'Tablet', 'Aristopharma Limited', '7.00', '0.00', '2.5 mg', 'Nebivolol'), 
('2032', 'Maxineb   5 mg', '143-0638-22', 'Tablet', 'Aristopharma Limited', '10.00', '0.00', '5 mg', 'Nebivolol'), 
('2033', 'Azistar   40 mg', '143-0639-22', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '40 mg', 'Azilsartan Medoxomil'), 
('2034', 'Azistar   80 mg', '143-0640-22', 'Tablet', 'Aristopharma Limited', '0.00', '0.00', '80 mg', 'Azilsartan Medoxomil'), 
('2035', 'Ticacard   90 mg', '143-0641-26', 'Tablet', 'Aristopharma Limited', '75.00', '0.00', '90 mg', 'Ticagrelor'), 
('2036', 'Beclovan   5 mg', '143-0644-70', 'Tablet', 'Aristopharma Limited', '5.50', '0.00', '5 mg', 'Baclofen'), 
('2037', 'Sonexa   4 mg', '143-0651-72', 'Tablet', 'Aristopharma Limited', '11.00', '0.00', '4 mg', 'Dexamethasone'), 
('2038', 'Apetiz   160 mg', '143-06526', 'Tablet', 'Aristopharma Limited', '90.00', '0.00', '160 mg', 'Megestrol Acetate'), 
('2039', 'Acyvir   200 mg', '143-0659-32', 'Tablet', 'Aristopharma Limited', '14.00', '0.00', '200 mg', 'Acyclovir'), 
('2040', 'Acyvir0   400 mg', '143-0660-32', 'Tablet', 'Aristopharma Limited', '22.00', '0.00', '400 mg', 'Acyclovir'), 
('2041', 'TCL-R   40 mg', '143-0665-061', 'Tablet', 'Aristopharma Limited', '24.00', '0.00', '40 mg', 'Atorvastatin'), 
('2042', 'Axon  IM   1 gm', '143-0190-23', 'IM Injection', 'Aristopharma Limited', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('2043', 'Axon  IM  mg   250 mg', '143-0186-23', 'IM Injection', 'Aristopharma Limited', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2044', 'Axon  IM   500 mg', '143-0188-23', 'IM Injection', 'Aristopharma Limited', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('2045', 'Axon  IV   1 gm', '143-0191-23', 'IV Injection', 'Aristopharma Limited', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('2046', 'Axon  IV  mg   250 mg', '143-0187-23', 'IV Injection', 'Aristopharma Limited', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2047', 'Axon  IV   500 mg', '143-0189-23', 'IV Injection', 'Aristopharma Limited', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('2048', 'Axon  IV  gm   2 gm', '143-0297-23', 'IV Injection', 'Aristopharma Limited', '0.00', '0.00', '2 gm', 'Ceftriaxone'), 
('2049', 'Afrin .05%   .05 %', '143-02252', 'Nasal Drops', 'Aristopharma Limited', '45.00', '0.00', '.05 %', 'Oxymetazoline Hydrochloride'), 
('2050', 'Afrin .025%   .025 %', '143-02862', 'Nasal Drops', 'Aristopharma Limited', '40.00', '0.00', '.025 %', 'Oxymetazoline Hydrochloride'), 
('2051', 'Afm   .1 %', '143-01672', 'Eye Drops', 'Aristopharma Limited', '0.00', '0.00', '.1 %', 'Fluorometholone'), 
('2052', 'Aristomol%   .25 %', '143-01712', 'Eye Drops', 'Aristopharma Limited', '55.00', '0.00', '.25 %', 'Timolol Maleate'), 
('2053', 'Aristomol%   .5 %', '143-01722', 'Eye Drops', 'Aristopharma Limited', '70.00', '0.00', '.5 %', 'Timolol Maleate'), 
('2054', 'Stafen .025%   .025 %', '143-03022', 'Eye Drops', 'Aristopharma Limited', '100.00', '0.00', '.025 %', 'Ketotifen'), 
('2055', 'Beclocort HFA   100 mcg', '143-04784', 'Inhalation Solution', 'Aristopharma Limited', '245.00', '0.00', '100 mcg', 'Beclomethasone Dipropionate'), 
('2056', 'Laczyme   300 mg', '143-0619-', 'Chewable Tablet', 'Aristopharma Limited', '15.00', '0.00', '300 mg', 'Lactase'), 
('2057', 'Glucomet  XR   750 mg', '143-0263', 'Xr Tablet', 'Aristopharma Limited', '8.00', '0.00', '750 mg', 'Metformin Hydrochloride'), 
('2058', 'Xolam XR   1 mg', '143-04437', 'Xr Tablet', 'Aristopharma Limited', '4.00', '0.00', '1 mg', 'Alprazolam'), 
('2059', 'Xpa XR   665 mg', '143-0446-6', 'Xr Tablet', 'Aristopharma Limited', '1.50', '0.00', '665 mg', 'Paracetamol'), 
('2060', 'Betacard XR   50 mg', '143-0468-22', 'Xr Tablet', 'Aristopharma Limited', '0.00', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('2061', 'Mervan SR   200 mg', '143-0609-64', 'Er Tablet', 'Aristopharma Limited', '0.00', '0.00', '200 mg', 'Aceclofenac'), 
('2062', 'Omep      20 mg', '143-0324', 'Sr Tablet', 'Aristopharma Limited', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('2063', 'Mesagut   400 mg', '143-0650-64', 'Dr Tablet', 'Aristopharma Limited', '7.60', '0.00', '400 mg', 'Mesalamine'), 
('2064', 'Afix   200 mg', '378-0003-23', 'Capsule', 'Aristopharma Limited, Gazipur', '35.00', '0.00', '200 mg', 'Cefixime'), 
('2065', 'Afix0   400 mg', '378-0004-23', 'Capsule', 'Aristopharma Limited, Gazipur', '50.00', '0.00', '400 mg', 'Cefixime'), 
('2066', 'Aristocef   250 mg', '378-0007-23', 'Capsule', 'Aristopharma Limited, Gazipur', '6.50', '0.00', '250 mg', 'Cephalexin'), 
('2067', 'Aristocef0   500 mg', '378-0008-23', 'Capsule', 'Aristopharma Limited, Gazipur', '15.00', '0.00', '500 mg', 'Cephalexin'), 
('2068', 'Extracef   250 mg', '378-0013-023', 'Capsule', 'Aristopharma Limited, Gazipur', '0.00', '0.00', '250 mg', 'Cephradine'), 
('2069', 'Extracef0   500 mg', '378-0014-23', 'Capsule', 'Aristopharma Limited, Gazipur', '0.00', '0.00', '500 mg', 'Cephradine'), 
('2070', 'Taxetil   100 mg', '378-0042-23', 'Capsule', 'Aristopharma Limited, Gazipur', '22.00', '0.00', '100 mg', 'Cefpodoxime'), 
('2071', 'Taxetil   200 mg', '378-0043-23', 'Capsule', 'Aristopharma Limited, Gazipur', '40.00', '0.00', '200 mg', 'Cefpodoxime'), 
('2072', 'Orbuten   400 mg', '378-0052-023', 'Capsule', 'Aristopharma Limited, Gazipur', '0.00', '0.00', '400 mg', 'Ceftibuten'), 
('2073', 'Afix   200 mg', '378-0001-23', 'Tablet', 'Aristopharma Limited, Gazipur', '35.00', '0.00', '200 mg', 'Cefixime'), 
('2074', 'Afix0   400 mg', '378-0002-23', 'Tablet', 'Aristopharma Limited, Gazipur', '50.00', '0.00', '400 mg', 'Cefixime'), 
('2075', 'Axim25   125 mg', '378-0021-23', 'Tablet', 'Aristopharma Limited, Gazipur', '15.00', '0.00', '125 mg', 'Cefuroxime'), 
('2076', 'Axim   250 mg', '378-0022-23', 'Tablet', 'Aristopharma Limited, Gazipur', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('2077', 'Axim0   500 mg', '378-0023-23', 'Tablet', 'Aristopharma Limited, Gazipur', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('2078', 'Aprozil   500 mg', '378-0028-23', 'Tablet', 'Aristopharma Limited, Gazipur', '0.00', '0.00', '500 mg', 'Cefprozil'), 
('2079', 'Axon IM   250 mg', '378-0031-23', 'IM Injection', 'Aristopharma Limited, Gazipur', '100.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2080', 'Axon0 IM   500 mg', '378-0033-23', 'IM Injection', 'Aristopharma Limited, Gazipur', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('2081', 'Axon gm IM   1 gm', '378-0035-23', 'IM Injection', 'Aristopharma Limited, Gazipur', '200.00', '0.00', '1 gm', 'Ceftriaxone'), 
('2082', 'Axon IV   250 mg', '378-0030-23', 'IV Injection', 'Aristopharma Limited, Gazipur', '100.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2083', 'Axon0 IV   500 mg', '378-0032-23', 'IV Injection', 'Aristopharma Limited, Gazipur', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('2084', 'Axon gm IV   2 gm', '378-0036-23', 'IV Injection', 'Aristopharma Limited, Gazipur', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('2085', 'Ceftazim   250 mg', '378-001-23', 'IV/IM Injection', 'Aristopharma Limited, Gazipur', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2086', 'Afixime      200 mg', '023-0095-23', 'Capsule', 'Asiatic Laboratories Ltd.', '30.00', '0.00', '200 mg', 'Cefixime'), 
('2087', 'Asidox      100 mg', '023-0052-23', 'Capsule', 'Asiatic Laboratories Ltd.', '2.00', '0.00', '100 mg', 'Doxycycline'), 
('2088', 'Clox F     250 mg', '023-0064-23', 'Capsule', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '250 mg', 'Flucloxacillin'), 
('2089', 'Clox F    500 mg', '023-0069-23', 'Capsule', 'Asiatic Laboratories Ltd.', '10.00', '0.00', '500 mg', 'Flucloxacillin'), 
('2090', 'Indocap   25 mg', '023-0047-64', 'Capsule', 'Asiatic Laboratories Ltd.', '0.60', '0.00', '25 mg', 'Indomethacin'), 
('2091', 'Licef   500 mg', '023-0081-23', 'Capsule', 'Asiatic Laboratories Ltd.', '13.96', '0.00', '500 mg', 'Cefadroxil'), 
('2092', 'Locopain  TR    100 mg', '023-0057-64', 'Capsule', 'Asiatic Laboratories Ltd.', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('2093', 'Loxyl   500 mg', '023-0055-23', 'Capsule', 'Asiatic Laboratories Ltd.', '6.76', '0.00', '500 mg', 'Amoxicillin'), 
('2094', 'Loxyl   250 mg', '023-0053-023', 'Capsule', 'Asiatic Laboratories Ltd.', '3.61', '0.00', '250 mg', 'Amoxicillin'), 
('2095', 'O      20 mg', '023-0084-67', 'Capsule', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('2096', 'O -      40 mg', '023-0085-67', 'Capsule', 'Asiatic Laboratories Ltd.', '7.00', '0.00', '40 mg', 'Omeprazole'), 
('2097', 'Tetramycin   250 mg', '023-0037-23', 'Capsule', 'Asiatic Laboratories Ltd.', '1.30', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('2098', 'Vecef   500 mg', '023-0077-23', 'Capsule', 'Asiatic Laboratories Ltd.', '12.50', '0.00', '500 mg', 'Cephradine'), 
('2099', 'Cefipod   100 mg', '023-0198-23', 'Capsule', 'Asiatic Laboratories Ltd.', '14.00', '0.00', '100 mg', 'Cefpodoxime'), 
('2100', 'Cefipod   200 mg', '023-0199-23', 'Capsule', 'Asiatic Laboratories Ltd.', '25.00', '0.00', '200 mg', 'Cefpodoxime'), 
('2101', 'Afixim0   400 mg', '023-0196-23', 'Capsule', 'Asiatic Laboratories Ltd.', '50.00', '0.00', '400 mg', 'Cefixime'), 
('2102', 'Dermicon   50 mg', '023-0236', 'Capsule', 'Asiatic Laboratories Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('2103', 'Dermicon   150 mg', '023-0237', 'Capsule', 'Asiatic Laboratories Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('2104', 'Asibalin   50 mg', '023-0280-046', 'Capsule', 'Asiatic Laboratories Ltd.', '12.00', '0.00', '50 mg', 'Pregabalin'), 
('2105', 'Asibalin   75 mg', '023-0281-046', 'Capsule', 'Asiatic Laboratories Ltd.', '16.00', '0.00', '75 mg', 'Pregabalin'), 
('2106', 'Ceftiten0   400 mg', '023-0292-23', 'Capsule', 'Asiatic Laboratories Ltd.', '120.00', '0.00', '400 mg', 'Ceftibuten'), 
('2107', 'Asiclin   150 mg', '023-0241-23', 'Capsule', 'Asiatic Laboratories Ltd.', '8.00', '0.00', '150 mg', 'Clindamycin'), 
('2108', 'Asiclin   300 mg', '023-0242-23', 'Capsule', 'Asiatic Laboratories Ltd.', '15.00', '0.00', '300 mg', 'Clindamycin'), 
('2109', 'Asibalin25   25 mg', '023-0313-046', 'Capsule', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '25 mg', 'Pregabalin'), 
('2110', 'Asilac   68 %', '023-0107-60', 'Oral Solution', 'Asiatic Laboratories Ltd.', '120.00', '0.00', '68 %', 'Lactulose'), 
('2111', 'Anaflam   400 mg', '023-0056-64', 'Tablet', 'Asiatic Laboratories Ltd.', '1.43', '0.00', '400 mg', 'Ibuprofen'), 
('2112', 'Aceptin-R   150 mg', '023-00595', 'Tablet', 'Asiatic Laboratories Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('2113', 'Asipan      20 mg', '023-01001', 'Tablet', 'Asiatic Laboratories Ltd.', '3.00', '0.00', '20 mg', 'Hyoscine Butyl Bromide'), 
('2114', 'Asitrol   10 mg', '023-0058-21', 'Tablet', 'Asiatic Laboratories Ltd.', '2.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('2115', 'Asul   4 mg', '023-00984', 'Tablet', 'Asiatic Laboratories Ltd.', '0.34', '0.00', '4 mg', 'Salbutamol'), 
('2116', 'Calfor   1250 mg', '023-0068-62', 'Tablet', 'Asiatic Laboratories Ltd.', '2.50', '0.00', '1250 mg', 'Calcium Carbonate'), 
('2117', 'Ceroxime   125 mg', '023-0102-23', 'Tablet', 'Asiatic Laboratories Ltd.', '15.00', '0.00', '125 mg', 'Cefuroxime'), 
('2118', 'Ceroxime   250 mg', '023-0103-23', 'Tablet', 'Asiatic Laboratories Ltd.', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('2119', 'Cip   500 mg', '023-0062-23', 'Tablet', 'Asiatic Laboratories Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('2120', 'Cip   750 mg', '023-0063-23', 'Tablet', 'Asiatic Laboratories Ltd.', '18.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('2121', 'Clarex   5 mg', '023-0105-21', 'Tablet', 'Asiatic Laboratories Ltd.', '2.50', '0.00', '5 mg', 'Desloratadine'), 
('2122', 'Eso      20 mg', '023-0110-067', 'Tablet', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('2123', 'Lerex   5 mg', '023-0106-21', 'Tablet', 'Asiatic Laboratories Ltd.', '2.00', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('2124', 'Liam   10 mg', '023-0109-044', 'Tablet', 'Asiatic Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Montelukast'), 
('2125', 'Locopain      50 mg', '023-0060-64', 'Tablet', 'Asiatic Laboratories Ltd.', '0.40', '0.00', '50 mg', 'Diclofenac Sodium'), 
('2126', 'Macas   500 mg', '023-0087-23', 'Tablet', 'Asiatic Laboratories Ltd.', '8.12', '0.00', '500 mg', 'Erythromycin'), 
('2127', 'P -      20 mg', '023-0093-67', 'Tablet', 'Asiatic Laboratories Ltd.', '4.00', '0.00', '20 mg', 'Pantoprazole'), 
('2128', 'P -      40 mg', '023-0094-67', 'Tablet', 'Asiatic Laboratories Ltd.', '6.00', '0.00', '40 mg', 'Pantoprazole'), 
('2129', 'Roxacine      150 mg', '023-0071-23', 'Tablet', 'Asiatic Laboratories Ltd.', '7.00', '0.00', '150 mg', 'Roxithromycin'), 
('2130', 'Roxacine0   300 mg', '023-0070-23', 'Tablet', 'Asiatic Laboratories Ltd.', '14.00', '0.00', '300 mg', 'Roxithromycin'), 
('2131', 'Starzyl      200 mg', '023-0033-27', 'Tablet', 'Asiatic Laboratories Ltd.', '0.66', '0.00', '200 mg', 'Metronidazole'), 
('2132', 'Strazyl   400 mg', '023-0048-27', 'Tablet', 'Asiatic Laboratories Ltd.', '1.02', '0.00', '400 mg', 'Metronidazole'), 
('2133', 'Tempol   500 mg', '023-0016-006', 'Tablet', 'Asiatic Laboratories Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('2134', 'Ulsec     1 gm', '023-0076-7', 'Tablet', 'Asiatic Laboratories Ltd.', '4.00', '0.00', '1 gm', 'Sucralfate'), 
('2135', 'V Cillin      200 mg', '023-0117-23', 'Tablet', 'Asiatic Laboratories Ltd.', '12.00', '0.00', '200 mg', 'Pivmecillinam'), 
('2136', 'Asiben   400 mg', '023-0119-008', 'Tablet', 'Asiatic Laboratories Ltd.', '3.80', '0.00', '400 mg', 'Albendazole'), 
('2137', 'Asaf      200 mg', '023-0075-23', 'Tablet', 'Asiatic Laboratories Ltd.', '18.75', '0.00', '200 mg', 'Sparfloxacin'), 
('2138', 'Atidon   10 mg', '023-00898', 'Tablet', 'Asiatic Laboratories Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('2139', 'Diout   850 mg', '023-0092', 'Tablet', 'Asiatic Laboratories Ltd.', '2.25', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('2140', 'Ena   100 mg', '023-0090-64', 'Tablet', 'Asiatic Laboratories Ltd.', '3.00', '0.00', '100 mg', 'Aceclofenac'), 
('2141', 'Gle   80 mg', '023-0091', 'Tablet', 'Asiatic Laboratories Ltd.', '11.00', '0.00', '80 mg', 'Gliclazide'), 
('2142', 'Asilee   500 mg', '023-0072-23', 'Tablet', 'Asiatic Laboratories Ltd.', '15.00', '0.00', '500 mg', 'Levofloxacin'), 
('2143', 'Alpam   .25 mg', '023-01357', 'Tablet', 'Asiatic Laboratories Ltd.', '1.00', '0.00', '.25 mg', 'Alprazolam'), 
('2144', 'Alpam   .5 mg', '023-01367', 'Tablet', 'Asiatic Laboratories Ltd.', '2.00', '0.00', '.5 mg', 'Alprazolam'), 
('2145', 'Lexnil   3 mg', '023-01377', 'Tablet', 'Asiatic Laboratories Ltd.', '4.00', '0.00', '3 mg', 'Bromazepam'), 
('2146', 'Asizith   250 mg', '023-0160-23', 'Tablet', 'Asiatic Laboratories Ltd.', '20.00', '0.00', '250 mg', 'Azithromycin'), 
('2147', 'Asizith   500 mg', '023-0161-23', 'Tablet', 'Asiatic Laboratories Ltd.', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('2148', 'Meclizine   50 mg', '023-01678', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Meclizine Hydrochloride'), 
('2149', 'Coflyt   8 mg', '023-0169-031', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '8 mg', 'Bromhexine Hydrochloride'), 
('2150', 'Ceroxime   500 mg', '023-0172-23', 'Tablet', 'Asiatic Laboratories Ltd.', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('2151', 'Pairox   250 mg', '023-0178-64', 'Tablet', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '250 mg', 'Naproxen'), 
('2152', 'Pairox0   500 mg', '023-0179-64', 'Tablet', 'Asiatic Laboratories Ltd.', '8.00', '0.00', '500 mg', 'Naproxen'), 
('2153', 'Ritoxib   60 mg', '023-0182-64', 'Tablet', 'Asiatic Laboratories Ltd.', '7.00', '0.00', '60 mg', 'Etoricoxib'), 
('2154', 'Ritoxib   90 mg', '023-0183-64', 'Tablet', 'Asiatic Laboratories Ltd.', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('2155', 'Ritoxib20   120 mg', '023-0184-64', 'Tablet', 'Asiatic Laboratories Ltd.', '14.00', '0.00', '120 mg', 'Etoricoxib'), 
('2156', 'Fendex      200 mg', '023-0185-64', 'Tablet', 'Asiatic Laboratories Ltd.', '3.00', '0.00', '200 mg', 'Dexibuprofen (S Ibuprofen)'), 
('2157', 'Fendex0   300 mg', '023-0186-64', 'Tablet', 'Asiatic Laboratories Ltd.', '4.00', '0.00', '300 mg', 'Dexibuprofen (S Ibuprofen)'), 
('2158', 'Fendex   400 mg', '023-0187-64', 'Tablet', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '400 mg', 'Dexibuprofen (S Ibuprofen)'), 
('2159', 'Surpime   10 mg', '023-0192-064', 'Tablet', 'Asiatic Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('2160', 'Calpress   5 mg', '023-0209-022', 'Tablet', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '5 mg', 'Amlodipine'), 
('2161', 'Calpress   10 mg', '023-0210-022', 'Tablet', 'Asiatic Laboratories Ltd.', '7.00', '0.00', '10 mg', 'Amlodipine'), 
('2162', 'Atebit   50 mg', '023-0211-22', 'Tablet', 'Asiatic Laboratories Ltd.', '0.77', '0.00', '50 mg', 'Atenolol'), 
('2163', 'Atebit   100 mg', '023-0212-22', 'Tablet', 'Asiatic Laboratories Ltd.', '1.38', '0.00', '100 mg', 'Atenolol'), 
('2164', 'Arbium   25 mg', '023-0215-022', 'Tablet', 'Asiatic Laboratories Ltd.', '3.50', '0.00', '25 mg', 'Losartan Potassium'), 
('2165', 'Arbium   50 mg', '023-0216-022', 'Tablet', 'Asiatic Laboratories Ltd.', '8.00', '0.00', '50 mg', 'Losartan Potassium'), 
('2166', 'Arbium   100 mg', '023-0217-022', 'Tablet', 'Asiatic Laboratories Ltd.', '12.00', '0.00', '100 mg', 'Losartan Potassium'), 
('2167', 'Pericard   4 mg', '023-0223-22', 'Tablet', 'Asiatic Laboratories Ltd.', '12.00', '0.00', '4 mg', 'Perindopril Erbumine'), 
('2168', 'Pericard   2 mg', '023-0224-22', 'Tablet', 'Asiatic Laboratories Ltd.', '7.00', '0.00', '2 mg', 'Perindopril Erbumine'), 
('2169', 'Atonor   10 mg', '023-0228-061', 'Tablet', 'Asiatic Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('2170', 'Atonor   20 mg', '023-0229-061', 'Tablet', 'Asiatic Laboratories Ltd.', '18.00', '0.00', '20 mg', 'Atorvastatin'), 
('2171', 'Xofena80   180 mg', '023-0233-21', 'Tablet', 'Asiatic Laboratories Ltd.', '9.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('2172', 'Xofena   120 mg', '023-0232-21', 'Tablet', 'Asiatic Laboratories Ltd.', '7.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('2173', 'Xofena   60 mg', '023-0231-21', 'Tablet', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('2174', 'Rosunor   10 mg', '023-0268-61', 'Tablet', 'Asiatic Laboratories Ltd.', '20.00', '0.00', '10 mg', 'Rosuvastatin'), 
('2175', 'Resfree   2 mg', '023-02694', 'Tablet', 'Asiatic Laboratories Ltd.', '1.70', '0.00', '2 mg', 'Levosalbutamol'), 
('2176', 'Resfree   1 mg', '023-02704', 'Tablet', 'Asiatic Laboratories Ltd.', '0.90', '0.00', '1 mg', 'Levosalbutamol'), 
('2177', 'Clogfree   75 mg', '023-0277-26', 'Tablet', 'Asiatic Laboratories Ltd.', '12.00', '0.00', '75 mg', 'Clopidogrel'), 
('2178', 'Rosunor   5 mg', '023-0278-61', 'Tablet', 'Asiatic Laboratories Ltd.', '10.00', '0.00', '5 mg', 'Rosuvastatin'), 
('2179', 'R   20 mg', '023-0279-67', 'Tablet', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('2180', 'Nebivas   5 mg', '023-0282-22', 'Tablet', 'Asiatic Laboratories Ltd.', '10.00', '0.00', '5 mg', 'Nebivolol'), 
('2181', 'Nebivas   2.5 mg', '023-0283-22', 'Tablet', 'Asiatic Laboratories Ltd.', '5.00', '0.00', '2.5 mg', 'Nebivolol'), 
('2182', 'Asiflocin   320 mg', '023-0291-23', 'Tablet', 'Asiatic Laboratories Ltd.', '65.00', '0.00', '320 mg', 'Gemefloxacin'), 
('2183', 'Doxinex   200 mg', '023-03024', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Doxophylline'), 
('2184', 'Sypam   2 mg', '023-0266-046', 'Tablet', 'Asiatic Laboratories Ltd.', '10.00', '0.00', '2 mg', 'Clonazepam'), 
('2185', 'Sypam.5   .5 mg', '023-0265-046', 'Tablet', 'Asiatic Laboratories Ltd.', '6.00', '0.00', '.5 mg', 'Clonazepam'), 
('2186', 'Sedoz   7.5 mg', '023-0264-057', 'Tablet', 'Asiatic Laboratories Ltd.', '9.50', '0.00', '7.5 mg', 'Midazolam'), 
('2187', 'Xibast   10 mg', '023-0263-21', 'Tablet', 'Asiatic Laboratories Ltd.', '6.00', '0.00', '10 mg', 'Ebastine'), 
('2188', 'Eso   40 mg', '023-0262-67', 'Tablet', 'Asiatic Laboratories Ltd.', '8.00', '0.00', '40 mg', 'Esomeprazole'), 
('2189', 'Onlit   4 mg', '023-0306-018', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '4 mg', 'Ondansetron'), 
('2190', 'Onlit 8   8 mg', '023-0309-018', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '8 mg', 'Ondansetron'), 
('2191', 'Morphine   10 mg', '023-0310-065', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Morphine Sulphate'), 
('2192', 'Floximox   400 mg', '023-0311-023', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Moxifloxacin'), 
('2193', 'Tivonum   50 mg', '023-0312-011', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('2194', 'NTZ   500 mg', '023-0314-027', 'Tablet', 'Asiatic Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Nitazoxanide'), 
('2195', 'Asixone IM   250 mg', '023-0249-23', 'IM Injection', 'Asiatic Laboratories Ltd.', '100.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2196', 'Asixone0 IM   500 mg', '023-0247-23', 'IM Injection', 'Asiatic Laboratories Ltd.', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('2197', 'Asixone gm IM   1 gm', '023-0245-23', 'IM Injection', 'Asiatic Laboratories Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('2198', 'Asixone IV   2 gm', '023-0275-23', 'IV Injection', 'Asiatic Laboratories Ltd.', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('2199', 'Asixone   250 mg', '023-0250-23', 'IV Injection', 'Asiatic Laboratories Ltd.', '100.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2200', 'Asixone0 IV   500 mg', '023-0248-23', 'IV Injection', 'Asiatic Laboratories Ltd.', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('2201', 'Asixone gm IV   1 gm', '023-0246-23', 'IV Injection', 'Asiatic Laboratories Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('2202', 'Confree   .05 %', '023-02072', 'Nasal Drops', 'Asiatic Laboratories Ltd.', '45.00', '0.00', '.05 %', 'Oxymetazoline Hydrochloride'), 
('2203', 'Confree   .025 %', '023-02082', 'Nasal Drops', 'Asiatic Laboratories Ltd.', '40.00', '0.00', '.025 %', 'Oxymetazoline Hydrochloride'), 
('2204', 'Asipine%   1 %', '023-01282', 'Eye Drops', 'Asiatic Laboratories Ltd.', '80.00', '0.00', '1 %', 'Pilocarpine Hydrochloride'), 
('2205', 'Asinol%   .5 %', '023-01292', 'Eye Drops', 'Asiatic Laboratories Ltd.', '67.00', '0.00', '.5 %', 'Timolol Maleate'), 
('2206', 'Ocutear .3%   .3 %', '023-01762', 'Eye Drops', 'Asiatic Laboratories Ltd.', '65.00', '0.00', '.3 %', 'Hypromellose'), 
('2207', 'Ocutif .025%   .025 %', '023-01892', 'Eye Drops', 'Asiatic Laboratories Ltd.', '95.00', '0.00', '.025 %', 'Ketotifen'), 
('2208', 'Flurosia   .1 %', '023-02382', 'Eye Drops', 'Asiatic Laboratories Ltd.', '100.00', '0.00', '.1 %', 'Fluorometholone'), 
('2209', 'Liam   5 mg', '023-0271-044', 'Chewable Tablet', 'Asiatic Laboratories Ltd.', '8.00', '0.00', '5 mg', 'Montelukast'), 
('2210', 'Fluc   250 mg', '326-0004-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '5.50', '0.00', '250 mg', 'Flucloxacillin'), 
('2211', 'Lexin   250 mg', '326-0018-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cephalexin'), 
('2212', 'Lexin   500 mg', '326-0019-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('2213', 'Mox   250 mg', '326-0012-023', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '3.60', '0.00', '250 mg', 'Amoxicillin'), 
('2214', 'Mox   500 mg', '326-0013-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '6.00', '0.00', '500 mg', 'Amoxicillin'), 
('2215', 'Sefty   250 mg', '326-0038-023', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cephradine'), 
('2216', 'Sefty   500 mg', '326-0039-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('2217', 'Tyclox   500 mg', '326-0023-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '5.95', '0.00', '500 mg', 'Cloxacillin'), 
('2218', 'Ometor   20 mg', '326-0036-67', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '4.00', '0.00', '20 mg', 'Omeprazole'), 
('2219', 'Ometor   40 mg', '326-0037-67', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '8.00', '0.00', '40 mg', 'Omeprazole'), 
('2220', 'Azithro   250 mg', '326-0046-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '20.00', '0.00', '250 mg', 'Azithromycin'), 
('2221', 'Dox P     100 mg', '326-0032-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '2.20', '0.00', '100 mg', 'Doxycycline'), 
('2222', 'Fluc   500 mg', '326-0028-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '10.00', '0.00', '500 mg', 'Flucloxacillin'), 
('2223', 'C-3   200 mg', '326-0053-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '35.00', '0.00', '200 mg', 'Cefixime'), 
('2224', 'Moov  SR    100 mg', '326-0048-64', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '2.50', '0.00', '100 mg', 'Diclofenac Sodium'), 
('2225', 'Flufun   50 mg', '326-0079', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('2226', 'Flufun   150 mg', '326-0078', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('2227', 'Clindacap   300 mg', '326-0121-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '15.00', '0.00', '300 mg', 'Clindamycin'), 
('2228', 'Clindacap   150 mg', '326-0120-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '8.00', '0.00', '150 mg', 'Clindamycin'), 
('2229', 'Pegamax   75 mg', '326-0119-046', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '16.00', '0.00', '75 mg', 'Pregabalin'), 
('2230', 'Pegamax   50 mg', '326-0118-046', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '11.00', '0.00', '50 mg', 'Pregabalin'), 
('2231', 'Esoz   40 mg', '326-0129-067', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '8.00', '0.00', '40 mg', 'Esomeprazole'), 
('2232', 'Esoz   20 mg', '326-0132-067', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('2233', 'C   400 mg', '326-0135-23', 'Capsule', 'Astra Biopharmaceuticals Ltd.', '50.00', '0.00', '400 mg', 'Cefixime'), 
('2234', 'Water for Injection   10 ml', '326-0083-79', 'Injection', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '10 ml', 'Water For Injection'), 
('2235', 'Gly   400 mg', '326-0015-27', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '1.14', '0.00', '400 mg', 'Metronidazole'), 
('2236', 'Reliv   500 mg', '326-0001-006', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('2237', 'Moov      50 mg', '326-0021-64', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.88', '0.00', '50 mg', 'Diclofenac Sodium'), 
('2238', 'Ciflocin0   500 mg', '326-0009-23', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '12.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('2239', 'Prozium   10 mg', '326-00036', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Clobazam'), 
('2240', 'Tyflam   400 mg', '326-0033-64', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '1.43', '0.00', '400 mg', 'Ibuprofen'), 
('2241', 'Tymin   4 mg', '326-0008-21', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.20', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('2242', 'Astac   150 mg', '326-00175', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('2243', 'Cetriz   10 mg', '326-0005-21', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '2.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('2244', 'Verben   400 mg', '326-0027-008', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '4.00', '0.00', '400 mg', 'Albendazole'), 
('2245', 'Zopi   7.5 mg', '326-0043-057', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '7.5 mg', 'Zopiclone'), 
('2246', 'Calcibo   1250 mg', '326-0030-62', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '3.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('2247', 'Domperon   10 mg', '326-00348', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('2248', 'Typan   10 mg', '326-00311', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '3.43', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('2249', 'Aceclofen   100 mg', '326-0061-64', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '3.00', '0.00', '100 mg', 'Aceclofenac'), 
('2250', 'Panoz   20 mg', '326-0062-67', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '4.00', '0.00', '20 mg', 'Pantoprazole'), 
('2251', 'Levo   500 mg', '326-0063-23', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '15.00', '0.00', '500 mg', 'Levofloxacin'), 
('2252', 'Azithro0   500 mg', '326-0066-23', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('2253', 'Deslorat   5 mg', '326-0065-21', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '3.00', '0.00', '5 mg', 'Desloratadine'), 
('2254', 'Fexon   120 mg', '326-0067-21', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '6.50', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('2255', 'Fexon80   180 mg', '326-0068-21', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '8.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('2256', 'Keprofen   50 mg', '326-0064-64', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '5.00', '0.00', '50 mg', 'Ketoprofen'), 
('2257', 'Ketoroz   10 mg', '326-0070-064', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('2258', 'Esoz   20 mg', '326-0073-067', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('2259', 'Esoz   40 mg', '326-0071-67', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Esomeprazole'), 
('2260', 'Xenap   500 mg', '326-0072-64', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Naproxen'), 
('2261', 'C   250 mg', '326-0086-23', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('2262', 'C   500 mg', '326-0087-23', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('2263', 'Baclodol   10 mg', '326-0101-70', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '8.00', '0.00', '10 mg', 'Baclofen'), 
('2264', 'Claz   80 mg', '326-0107', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '6.00', '0.00', '80 mg', 'Gliclazide'), 
('2265', 'Clozep.5   .5 mg', '326-0103-046', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '.5 mg', 'Clonazepam'), 
('2266', 'Clozep   2 mg', '326-0104-046', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Clonazepam'), 
('2267', 'Dogrel   75 mg', '326-0105-26', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '10.00', '0.00', '75 mg', 'Clopidogrel'), 
('2268', 'Lexotan   3 mg', '326-01027', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('2269', 'Loril   25 mg', '326-0108-022', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Losartan Potassium'), 
('2270', 'Loril   50 mg', '326-0109-022', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '6.00', '0.00', '50 mg', 'Losartan Potassium'), 
('2271', 'Loril   100 mg', '326-0110-022', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '10.00', '0.00', '100 mg', 'Losartan Potassium'), 
('2272', 'Metfomin0   500 mg', '326-0111', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '3.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('2273', 'Metfomin   850 mg', '326-0112', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '4.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('2274', 'Monteluk   5 mg', '326-0098-044', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '8.00', '0.00', '5 mg', 'Montelukast'), 
('2275', 'Monteluk   10 mg', '326-0099-044', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '15.00', '0.00', '10 mg', 'Montelukast'), 
('2276', 'Tadafil   5 mg', '326-0095-043', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '18.00', '0.00', '5 mg', 'Tadalafil'), 
('2277', 'Tadafil   10 mg', '326-0096-043', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '35.00', '0.00', '10 mg', 'Tadalafil'), 
('2278', 'Tadafil   20 mg', '326-0097-043', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '60.00', '0.00', '20 mg', 'Tadalafil'), 
('2279', 'Veagra   25 mg', '326-0092-043', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '20.00', '0.00', '25 mg', 'Sildenafil'), 
('2280', 'Veagra   50 mg', '326-0093-043', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '30.00', '0.00', '50 mg', 'Sildenafil'), 
('2281', 'Veagra   100 mg', '326-0094-043', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '50.00', '0.00', '100 mg', 'Sildenafil'), 
('2282', 'Puritab   15 mg', '326-0115', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Halazone'), 
('2283', 'Lodosprin   100 mg', '326-0126-26', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Aspirin'), 
('2284', 'Panozmg   40 mg', '326-0130-67', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '7.00', '0.00', '40 mg', 'Pantoprazole'), 
('2285', 'Azithro   250 mg', '326-0131-23', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '20.00', '0.00', '250 mg', 'Azithromycin'), 
('2286', 'Rixmin   200 mg', '326-0142-023', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Rifaximin'), 
('2287', 'Ketoxen   1 mg', '326-0141-021', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '1 mg', 'Ketotifen'), 
('2288', 'Asmadox0   400 mg', '326-0138-044', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Doxophylline'), 
('2289', 'Spason   50 mg', '326-0137-011', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('2290', 'Rasoz   20 mg', '326-0136-067', 'Tablet', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('2291', 'Cefaz   250 mg', '326-0133-23', 'IM Injection', 'Astra Biopharmaceuticals Ltd.', '100.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2292', 'Cefaz0   500 mg', '326-0144-023', 'IM Injection', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('2293', 'Cefaz gm   1 gm', '326-0143-023', 'IM Injection', 'Astra Biopharmaceuticals Ltd.', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('2294', 'Cefazgm   1 gm', '326-0080-23', 'IV Injection', 'Astra Biopharmaceuticals Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('2295', 'Cefazgm   2 gm', '326-0081-23', 'IV Injection', 'Astra Biopharmaceuticals Ltd.', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('2296', 'Adoxi      100 mg', '217-0032-23', 'Capsule', 'Aztec Pharmaceuticals Ltd.', '2.00', '0.00', '100 mg', 'Doxycycline'), 
('2297', 'Moxicap   250 mg', '217-0024-023', 'Capsule', 'Aztec Pharmaceuticals Ltd.', '3.00', '0.00', '250 mg', 'Amoxicillin'), 
('2298', 'TC   250 mg', '217-0029-23', 'Capsule', 'Aztec Pharmaceuticals Ltd.', '1.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('2299', 'Affen  TR    100 mg', '217-0043-64', 'Capsule', 'Aztec Pharmaceuticals Ltd.', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('2300', 'Isopen   250 mg', '217-0039-23', 'Capsule', 'Aztec Pharmaceuticals Ltd.', '5.00', '0.00', '250 mg', 'Flucloxacillin'), 
('2301', 'Ipp      20 mg', '217-0040-67', 'Capsule', 'Aztec Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('2302', 'Sometra   20 mg', '217-0057-067', 'Capsule', 'Aztec Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('2303', 'Afen      50 mg', '217-0033-64', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '0.80', '0.00', '50 mg', 'Diclofenac Sodium'), 
('2304', 'Brofen   400 mg', '217-0036-64', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '1.40', '0.00', '400 mg', 'Ibuprofen'), 
('2305', 'Cetol   500 mg', '217-0027-006', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('2306', 'Floxa   500 mg', '217-0037-23', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('2307', 'Metrona   400 mg', '217-0026-27', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '1.00', '0.00', '400 mg', 'Metronidazole'), 
('2308', 'Rantid      150 mg', '217-00345', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('2309', 'Ale  DS   400 mg', '217-0041-008', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '4.00', '0.00', '400 mg', 'Albendazole'), 
('2310', 'KTL   10 mg', '217-0054-064', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('2311', 'Tabrex0   500 mg', '217-0055-023', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('2312', 'Tuknil   20 mg', '217-0058-067', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Pantoprazole'), 
('2313', 'Midrin   500 mg', '217-0059-064', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Naproxen'), 
('2314', 'FFD   120 mg', '217-0060-021', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '0.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('2315', 'Milucast   10 mg', '217-0061-044', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Montelukast'), 
('2316', 'Juberi   10 mg', '217-0062-021', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('2317', 'DPD   10 mg', '217-0063-018', 'Tablet', 'Aztec Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('2318', 'Amicillin Trihydrate   100 %', '186-0001-034', 'Raw Materials', 'Bangladesh Antibiotic Industries Limited', '0.00', '0.00', '100 %', 'Ampicillin Trihydrate'), 
('2319', 'Amoxicillin Trihydrate   100 %', '186-0002-034', 'Raw Materials', 'Bangladesh Antibiotic Industries Limited', '0.00', '0.00', '100 %', 'Amoxicillin Trihydrate'), 
('2320', 'Cloxacillin Sodium   100 %', '186-0003-034', 'Raw Materials', 'Bangladesh Antibiotic Industries Limited', '0.00', '0.00', '100 %', 'Cloxacillin'), 
('2321', 'Flucloxacillin   100 %', '186-0004-034', 'Raw Materials', 'Bangladesh Antibiotic Industries Limited', '0.00', '0.00', '100 %', 'Flucloxacillin Sodium'), 
('2322', 'Xelopes      20 mg', '341-0042-67', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '5.02', '0.00', '20 mg', 'Omeprazole'), 
('2323', 'Liqu - E      200 mg', '341-0004-78', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '4.02', '0.00', '200 mg', 'Vitamin E'), 
('2324', 'Liquical   .25 mcg', '341-0010-78', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '10.06', '0.00', '.25 mcg', 'Calcitriol'), 
('2325', 'Lique - E      200 mg', '341--78', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Vitamin E'), 
('2326', 'Liqumint   .2 ml', '341-0054', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '7.05', '0.00', '.2 ml', 'Peppermint Oil'), 
('2327', 'Scarvit   500 mg', '341-0051-78', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Vitamin C'), 
('2328', 'Xtrapel0   50 mg', '341-0066-65', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '8.05', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('2329', 'Starcef   200 mg', '341-0079-23', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '35.11', '0.00', '200 mg', 'Cefixime'), 
('2330', 'Esoprex   20 mg', '341-0129-067', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '7.02', '0.00', '20 mg', 'Esomeprazole'), 
('2331', 'Esoprex   40 mg', '341-0130-067', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '5.00', '0.00', '40 mg', 'Esomeprazole'), 
('2332', 'Xelopes   40 mg', '341-0132-67', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '7.00', '0.00', '40 mg', 'Omeprazole'), 
('2333', 'Xeroder   50 mg', '341-0127', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '8.05', '0.00', '50 mg', 'Fluconazole'), 
('2334', 'Xeroder   150 mg', '341-0128', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '22.15', '0.00', '150 mg', 'Fluconazole'), 
('2335', 'Copeg   200 mg', '341-0118-32', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '35.00', '0.00', '200 mg', 'Ribavirin'), 
('2336', 'Regab   50 mg', '341-0163-046', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '12.04', '0.00', '50 mg', 'Pregabalin'), 
('2337', 'Regab   75 mg', '341-0164-046', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '16.05', '0.00', '75 mg', 'Pregabalin'), 
('2338', 'Paricon   1 mcg', '341-0157-74', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '45.14', '0.00', '1 mcg', 'Paricalcitol'), 
('2339', 'Cyclonix   25 mg', '341-01698', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Cyclosporine'), 
('2340', 'Cyclonix   100 mg', '341-01708', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Cyclosporine'), 
('2341', 'Regab   25 mg', '341-0159-046', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '8.00', '0.00', '25 mg', 'Pregabalin'), 
('2342', 'Lubilax   8 mcg', '341-0188-60', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '15.05', '0.00', '8 mcg', 'Lubiprostone'), 
('2343', 'Sunitix   50 mg', '341-0197', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '1800.00', '0.00', '50 mg', 'Sunitinib'), 
('2344', 'Temonix   250 mg', '341-0206', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '1300.00', '0.00', '250 mg', 'Temozolomide Hydrochloride'), 
('2345', 'Temonix   100 mg', '341-0205', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '600.00', '0.00', '100 mg', 'Temozolomide Hydrochloride'), 
('2346', 'Hydronix   500 mg', '341-0211-23', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '15.00', '0.00', '500 mg', 'Hydroxyurea'), 
('2347', 'Lubilax4   24 mcg', '341-0222-60', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '40.12', '0.00', '24 mcg', 'Lubiprostone'), 
('2348', 'Safoxol   75 mg', '341-0226-31', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '5.02', '0.00', '75 mg', 'Ambroxol'), 
('2349', 'CoQ   30 mg', '341-0235', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '8.02', '0.00', '30 mg', 'Coenzyme Q10 (Ubidecarenone)'), 
('2350', 'CoQ   60 mg', '341-0236', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '15.05', '0.00', '60 mg', 'Coenzyme Q10 (Ubidecarenone)'), 
('2351', 'Topoxin   50 mg', '341-0265', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '120.00', '0.00', '50 mg', 'Etoposide'), 
('2352', 'Starcef0   400 mg', '341-0264-23', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '50.00', '0.00', '400 mg', 'Cefixime'), 
('2353', 'Linamide   10 mg', '341-0273-', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '200.00', '0.00', '10 mg', 'Lenalidomide'), 
('2354', 'Linamide   25 mg', '341-0274-', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '400.00', '0.00', '25 mg', 'Lenalidomide'), 
('2355', 'Paloxi   500 mcg', '341-0276-', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '22.00', '0.00', '500 mcg', 'Palonosetron'), 
('2356', 'Rabepes   20 mg', '341-0284-67', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '6.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('2357', 'Crizonix   250 mg', '341-0293', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Crizotinib'), 
('2358', 'Xonimide   50 mg', '341-03056', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '15.00', '0.00', '50 mg', 'Zonisamide'), 
('2359', 'Temonix   5 mg', '341-0307', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Temozolomide Hydrochloride'), 
('2360', 'Ibrutix   140 mg', '341-0317-010', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '600.00', '0.00', '140 mg', 'Ibrutinib'), 
('2361', 'Sunitix   25 mg', '341-0323-010', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Sunitinib'), 
('2362', 'Sunitix2.5   12.5 mg', '341-0322-010', 'Capsule', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '12.5 mg', 'Sunitinib'), 
('2363', 'Water for Injection   10 ml', '341-0036-79', 'Injection', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '10 ml', 'Water For Injection'), 
('2364', 'Simpli   500 mg', '341-0058-23', 'Injection', 'Beacon Pharmaceuticals Ltd.', '461.38', '0.00', '500 mg', 'Azithromycin'), 
('2365', 'Trastunix   440 mg', '341-0217', 'Injection', 'Beacon Pharmaceuticals Ltd.', '80000.00', '0.00', '440 mg', 'Trastuzumab'), 
('2366', 'Liq - E   400 mg', '342-0045-78', 'Soft Gelatin Capsule', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Vitamin E'), 
('2367', 'Noburn   10 mg', '341-00168', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '2.01', '0.00', '10 mg', 'Domperidone'), 
('2368', 'Amlowide      5 mg', '341-0002-022', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '3.02', '0.00', '5 mg', 'Amlodipine'), 
('2369', 'Gastroloc      150 mg', '341-00275', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('2370', 'Quixin   500 mg', '341-0034-23', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '15.10', '0.00', '500 mg', 'Levofloxacin'), 
('2371', 'Xerova   10 mg', '341-0031-061', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '10.06', '0.00', '10 mg', 'Atorvastatin'), 
('2372', 'Xbac   500 mg', '341-0033-23', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '14.09', '0.00', '500 mg', 'Ciprofloxacin'), 
('2373', 'Acupain   10 mg', '341-0008-064', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '10.06', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('2374', 'Alertadin   5 mg', '341-0028-21', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '2.51', '0.00', '5 mg', 'Desloratadine'), 
('2375', 'Simpli   500 mg', '341-0006-23', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '35.11', '0.00', '500 mg', 'Azithromycin'), 
('2376', 'Fep-Junior   120 mg', '341-0013-006', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '120 mg', 'Paracetamol'), 
('2377', 'Fap   500 mg', '341-0014-006', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('2378', 'Trexonate.5   2.5 mg', '341-0017', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '5.00', '0.00', '2.5 mg', 'Methotrexate'), 
('2379', 'Folinex   15 mg', '341-00215', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Folinic Acid'), 
('2380', 'Protebon   1250 mg', '341-0022-62', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('2381', 'Protoloc      20 mg', '341-0024-67', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '4.01', '0.00', '20 mg', 'Pantoprazole'), 
('2382', 'Protoloc      40 mg', '341-0025-67', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '6.02', '0.00', '40 mg', 'Pantoprazole'), 
('2383', 'Prokind   15 mg', '341-00261', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '8.02', '0.00', '15 mg', 'Propantheline Bromide'), 
('2384', 'Cyclotox   50 mg', '341-0030', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Cyclophosphamide'), 
('2385', 'Flexibac   10 mg', '341-0035-70', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '8.05', '0.00', '10 mg', 'Baclofen'), 
('2386', 'Spasverin   60 mg', '341-00401', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '5.02', '0.00', '60 mg', 'Alverine Citrate'), 
('2387', 'Acebid   100 mg', '341-0043-64', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '4.01', '0.00', '100 mg', 'Aceclofenac'), 
('2388', 'Xbac   750 mg', '341-0044-23', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '18.11', '0.00', '750 mg', 'Ciprofloxacin'), 
('2389', 'Coxitor   60 mg', '341-0052-64', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '7.05', '0.00', '60 mg', 'Etoricoxib'), 
('2390', 'Migratol   200 mg', '341-00607', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '8.05', '0.00', '200 mg', 'Tolfenamic Acid'), 
('2391', 'Tinizol   500 mg', '341-0061-27', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Tinidazole'), 
('2392', 'Tinizol DS   1 gm', '341-0062-27', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '1 gm', 'Tinidazole'), 
('2393', 'Flexibac   5 mg', '341-0067-70', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '5.02', '0.00', '5 mg', 'Baclofen'), 
('2394', 'Bukof   50 mg', '341-0069-31', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '10.03', '0.00', '50 mg', 'Butamirate Citrate'), 
('2395', 'Cardisan   50 mg', '341-0070-022', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '8.02', '0.00', '50 mg', 'Losartan Potassium'), 
('2396', 'Anxium   10 mg', '341-00786', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Clobazam'), 
('2397', 'Gabamax   300 mg', '341-0086-046', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '16.11', '0.00', '300 mg', 'Gabapentin'), 
('2398', 'ZT   20 mg', '341-0090-62', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '1.51', '0.00', '20 mg', 'Zinc'), 
('2399', 'Tenoflex   20 mg', '341-0091-64', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '8.05', '0.00', '20 mg', 'Tenoxicam'), 
('2400', 'Xitabin   500 mg', '341-0116', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '125.00', '0.00', '500 mg', 'Capecitabine'), 
('2401', 'Imanix   100 mg', '341-0126', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '100.00', '0.00', '100 mg', 'Imatinib'), 
('2402', 'Erlonix   100 mg', '341-0124', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '550.00', '0.00', '100 mg', 'Erlotinib'), 
('2403', 'Erlonix   150 mg', '341-0125', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '700.00', '0.00', '150 mg', 'Erlotinib'), 
('2404', 'Leukin   50 mg', '341-0134', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Mercaptopurine'), 
('2405', 'Trexonate   10 mg', '341-0138', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '15.00', '0.00', '10 mg', 'Methotrexate'), 
('2406', 'Cardisan   25 mg', '341-0139-022', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Losartan Potassium'), 
('2407', 'Amekast   4 mg', '341-0142-044', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '6.02', '0.00', '4 mg', 'Montelukast'), 
('2408', 'Amekast   5 mg', '341-0143-044', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '8.02', '0.00', '5 mg', 'Montelukast'), 
('2409', 'Amekast   10 mg', '341-0144-044', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '15.05', '0.00', '10 mg', 'Montelukast'), 
('2410', 'Tivis   50 mg', '341-01451', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '5.04', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('2411', 'Tranex   500 mg', '341-01469', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('2412', 'Nomiset   8 mg', '341-01508', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '10.03', '0.00', '8 mg', 'Ondansetron'), 
('2413', 'Caviral   .5 mg', '341-0155-32', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '60.18', '0.00', '.5 mg', 'Entecavir'), 
('2414', 'Prasulet   5 mg', '341-0148-26', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '12.04', '0.00', '5 mg', 'Prasugrel'), 
('2415', 'Prasulet   10 mg', '341-0149-26', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '20.06', '0.00', '10 mg', 'Prasugrel'), 
('2416', 'Xefrim   250 mg', '341-0156-23', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '25.08', '0.00', '250 mg', 'Cefuroxime'), 
('2417', 'Gemif   320 mg', '341-0158-23', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '65.20', '0.00', '320 mg', 'Gemefloxacin'), 
('2418', 'Rupadin   10 mg', '341-0168-21', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '10.03', '0.00', '10 mg', 'Rupatadine'), 
('2419', 'Becovir   300 mg', '341-0171-32', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '85.26', '0.00', '300 mg', 'Tenofovir Disoproxil Fumarate'), 
('2420', 'Rifax   200 mg', '341-0174-23', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Rifaximin'), 
('2421', 'Lexel   2.5 mg', '341-0175', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '40.00', '0.00', '2.5 mg', 'Letrozole'), 
('2422', 'Prostalex   250 mg', '341-0176', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Flutamide'), 
('2423', 'Temolex   10 mg', '341-0178', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '8.00', '0.00', '10 mg', 'Tamoxifen'), 
('2424', 'Temolex   20 mg', '341-0179', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '16.00', '0.00', '20 mg', 'Tamoxifen'), 
('2425', 'Anstrol   1 mg', '341-0177', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '1 mg', 'Anastrozol'), 
('2426', 'Roflast   500 mcg', '341-01804', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '15.05', '0.00', '500 mcg', 'Roflumilast'), 
('2427', 'Agotin   25 mg', '341-01814', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '50.15', '0.00', '25 mg', 'Agomelatine'), 
('2428', 'Flexibac   25 mg', '341-0182-70', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '20.06', '0.00', '25 mg', 'Baclofen'), 
('2429', 'Mavelox   400 mg', '341-0183-23', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Moxifloxacin'), 
('2430', 'Vasonit   2.6 mg', '341-0187', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('2431', 'Paloxi   .5 mg', '341-01858', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '20.06', '0.00', '.5 mg', 'Palonosetron'), 
('2432', 'Xevirol   10 mg', '341-01968', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Everolimus'), 
('2433', 'Hexinor   2 mg', '341-0202', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '5.02', '0.00', '2 mg', 'Trihexyphenidyl Hydrochloride'), 
('2434', 'Soranix   200 mg', '341-0200', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '275.00', '0.00', '200 mg', 'Sorafenib'), 
('2435', 'Medrina   5 mg', '341-0198-39', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '4.70', '0.00', '5 mg', 'Medroxyprogesterone Acetate'), 
('2436', 'Alysa   5 mg', '341-01999', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '8.02', '0.00', '5 mg', 'Allystrenol'), 
('2437', 'Xevirol   5 mg', '341-02038', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '1500.00', '0.00', '5 mg', 'Everolimus'), 
('2438', 'Xentoin   100 mg', '341-0213-046', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '4.01', '0.00', '100 mg', 'Phenytoin Sodium'), 
('2439', 'Milran   50 mg', '341-02044', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '15.05', '0.00', '50 mg', 'Milnacipran Hydrochloride'), 
('2440', 'Imanix0   400 mg', '341-0210', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '300.00', '0.00', '400 mg', 'Imatinib'), 
('2441', 'Mirapin   15 mg', '341-02144', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '9.03', '0.00', '15 mg', 'Mirtazapine'), 
('2442', 'Zytix   250 mg', '341-0220-010', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '700.00', '0.00', '250 mg', 'Abiraterone Acetate'), 
('2443', 'Rifax50   550 mg', '341-0190-23', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '550 mg', 'Rifaximin'), 
('2444', 'Rabepes   20 mg', '341-0223-67', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '5.02', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('2445', 'Milran2.5   12.5 mg', '341-02244', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '6.00', '0.00', '12.5 mg', 'Milnacipran Hydrochloride'), 
('2446', 'Dapotin   30 mg', '341-0227-014', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '30.00', '0.00', '30 mg', 'Dapoxetine'), 
('2447', 'Sixvit   20 mg', '341-0242-78', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '1.30', '0.00', '20 mg', 'Pyridoxine Hydrochloride'), 
('2448', 'Xalcort   6 mg', '341-0240-72', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '8.02', '0.00', '6 mg', 'Deflazacort'), 
('2449', 'Ilodon   2 mg', '341-0238-28', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '2.01', '0.00', '2 mg', 'Iloperidone'), 
('2450', 'Ilodon 6   6 mg', '341-0239-28', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '4.01', '0.00', '6 mg', 'Iloperidone'), 
('2451', 'Protebon P   400 mg', '341-0241-62', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '8.02', '0.00', '400 mg', 'Calcium Orotate'), 
('2452', 'Gefinix   250 mg', '341-0244', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '250.00', '0.00', '250 mg', 'Gefitinib'), 
('2453', 'Hexinor   5 mg', '341-0245', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '10.03', '0.00', '5 mg', 'Trihexyphenidyl Hydrochloride'), 
('2454', 'Bical   50 mg', '341-0247', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '80.00', '0.00', '50 mg', 'Bicalutamide'), 
('2455', 'Maxtra   400 mcg', '341-02499', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('2456', 'Dasanix   100 mg', '341-0252', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '400.00', '0.00', '100 mg', 'Dasatinib'), 
('2457', 'Fludamin   10 mg', '341-0255', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Fludarabine Phosphate'), 
('2458', 'Protebon-P 740   740 mg', '341-0257-62', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '12.00', '0.00', '740 mg', 'Calcium Orotate'), 
('2459', 'Doxoven   400 mg', '341-02594', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '6.00', '0.00', '400 mg', 'Doxophylline'), 
('2460', 'Soforal   400 mg', '341-0270-32', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '600.00', '0.00', '400 mg', 'Sofosbuvir'), 
('2461', 'Daclavir   60 mg', '341-0279-', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '400.00', '0.00', '60 mg', 'Daclatasvir'), 
('2462', 'Slipaid   3 mg', '341-0280-', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '6.00', '0.00', '3 mg', 'Doxepin'), 
('2463', 'Olanor   5 mg', '341-0281-28', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '2.50', '0.00', '5 mg', 'Olanzapine'), 
('2464', 'Olanor   10 mg', '341-0282-28', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '4.50', '0.00', '10 mg', 'Olanzapine'), 
('2465', 'Arsenor   10 mg', '341-0286-', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '25.00', '0.00', '10 mg', 'Apremilast'), 
('2466', 'Tetrazin   12.5 mg', '341-0283-', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '20.00', '0.00', '12.5 mg', 'Tetrabenazine'), 
('2467', 'Slipaid 6   6 mg', '341-0289-', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '10.00', '0.00', '6 mg', 'Doxepin'), 
('2468', 'Doxoven   200 mg', '341-0288-', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '6.00', '0.00', '200 mg', 'Doxophylline'), 
('2469', 'Xalcort4   24 mg', '341-0295-72', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '30.00', '0.00', '24 mg', 'Deflazacort'), 
('2470', 'Dasanix   20 mg', '341-0271', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '80.00', '0.00', '20 mg', 'Dasatinib'), 
('2471', 'Mezest60   160 mg', '341-02996', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '90.00', '0.00', '160 mg', 'Megestrol Acetate'), 
('2472', 'Mezest   40 mg', '341-0302', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '35.00', '0.00', '40 mg', 'Megestrol Acetate'), 
('2473', 'Dasanix   50 mg', '341-0272', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Dasatinib'), 
('2474', 'Tagrix   40 mg', '341-0290', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Osimertinib'), 
('2475', 'Tagrix   80 mg', '341-0291', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '80 mg', 'Osimertinib'), 
('2476', 'Arsenor   30 mg', '341-0303-64', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '60.00', '0.00', '30 mg', 'Apremilast'), 
('2477', 'Tetrazin   25 mg', '341-0304-28', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '35.00', '0.00', '25 mg', 'Tetrabenazine'), 
('2478', 'Xitabin   150 mg', '341-0308', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Capecitabine'), 
('2479', 'ETP   25 mg', '341-03152', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '511.33', '0.00', '25 mg', 'Eltrombopag'), 
('2480', 'ETP   50 mg', '341-03162', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '909.02', '0.00', '50 mg', 'Eltrombopag'), 
('2481', 'Regonix   40 mg', '341-0310', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Regorafenib'), 
('2482', 'Tafecta   25 mg', '341-0309-32', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Tenofovir Alafenamide'), 
('2483', 'Axinix   5 mg', '341-0325-010', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Axitinib'), 
('2484', 'Axinix   1 mg', '341-0324-010', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '1 mg', 'Axitinib'), 
('2485', 'Jaktor   5 mg', '341-0320-058', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Tofacitinib'), 
('2486', 'Xerova   20 mg', '341-0032-061', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '18.11', '0.00', '20 mg', 'Atorvastatin'), 
('2487', 'Coxitor   90 mg', '341-0053-064', 'Tablet', 'Beacon Pharmaceuticals Ltd.', '12.08', '0.00', '90 mg', 'Etoricoxib'), 
('2488', 'Traxef IM   250 mg', '341-0230-23', 'IM Injection', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('2489', 'Traxef0   500 mg', '341-0231-23', 'IM Injection', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('2490', 'Traxef gm   1 gm', '341-0232-23', 'IV Injection', 'Beacon Pharmaceuticals Ltd.', '320.96', '0.00', '1 gm', 'Ceftriaxone'), 
('2491', 'Xemocid   5 %', '341-0072-3', 'IV Infusion', 'Beacon Pharmaceuticals Ltd.', '501.50', '0.00', '5 %', 'Amino Acids (Essential)'), 
('2492', 'Xtrapel  SR    100 mg', '341-0055-65', 'Sr Capsule', 'Beacon Pharmaceuticals Ltd.', '12.08', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('2493', 'Veripel   200 mg', '341-00561', 'Sr Capsule', 'Beacon Pharmaceuticals Ltd.', '9.03', '0.00', '200 mg', 'Mebeverine Hydrochloride'), 
('2494', 'Exceta   665 mg', '341-0140-6', 'Xr Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '665 mg', 'Paracetamol'), 
('2495', 'Xelopes      20 mg', '341-0012', 'Sr Tablet', 'Beacon Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('2496', 'Tetracycline   250 mg', '069-0049-23', 'Capsule', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('2497', 'Seloktil   20 mg', '069-0046-67', 'Capsule', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('2498', 'Moci   250 mg', '069-0047-023', 'Capsule', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('2499', 'Esomtric   20 mg', '069-0056-067', 'Capsule', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('2500', 'Rabtric   20 mg', '069-0065-67', 'Capsule', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('2501', 'Jovran      150 mg', '069-00475', 'Tablet', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('2502', 'Cipro B    500 mg', '069-0043-23', 'Tablet', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('2503', 'Provit E   400 mg', '069-0044-78', 'Tablet', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Vitamin E'), 
('2504', 'Sencital   10 mg', '069-00574', 'Tablet', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Escitalopram'), 
('2505', 'Moten   10 mg', '069-0062-044', 'Tablet', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Montelukast'), 
('2506', 'B-Dexa   .5 mg', '069-0061-72', 'Tablet', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '.5 mg', 'Dexamethasone'), 
('2507', 'Azirex   500 mg', '069-0060-23', 'Tablet', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('2508', 'Benz4   400 mg', '069-0058-008', 'Tablet', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Albendazole'), 
('2509', 'Beloxin   500 mg', '069-0059-23', 'Tablet', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('2510', 'Diclofenac   50 mg', '069-0066-064', 'Tablet', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('2511', 'Folic Acid   5 mg', '069-0068-045', 'Tablet', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Folic Acid'), 
('2512', 'Ketorolac   10 mg', '069-0069-064', 'Tablet', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('2513', 'Diclofenac SR   100 mg', '069-0067-064', 'Sr Tablet', 'Belsen Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('2514', 'Xtra-Mox   500 mg', '090-0039-23', 'Capsule', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('2515', 'Xtra-Mox   250 mg', '090-0040-023', 'Capsule', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('2516', 'Befen TR0   100 mg', '090-0047-64', 'Capsule', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '2.75', '0.00', '100 mg', 'Diclofenac Sodium'), 
('2517', 'Fluxizole   150 mg', '090-0051', 'Capsule', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '150 mg', 'Fluconazole'), 
('2518', 'Fluxizole   50 mg', '090-0050', 'Capsule', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '50 mg', 'Fluconazole'), 
('2519', 'Besectil   20 mg', '090-0034-67', 'Capsule', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('2520', 'Besectil   40 mg', '090-0052-67', 'Capsule', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '40 mg', 'Omeprazole'), 
('2521', 'Madnil      100 mg', '090-0020-8', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '100 mg', 'Mebendazole'), 
('2522', 'Paracetamol   500 mg', '090-0021-006', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('2523', 'Benzol      200 mg', '090-0014-27', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '200 mg', 'Metronidazole'), 
('2524', 'Befen      50 mg', '090-0028-64', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('2525', 'Beflam   400 mg', '090-0030-64', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '400 mg', 'Ibuprofen'), 
('2526', 'Bedom   10 mg', '090-00318', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('2527', 'Odazin   500 mg', '090-0037-23', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('2528', 'Alater   10 mg', '090-0042-21', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '2.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('2529', 'Aceclofar   100 mg', '090-0043-64', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '3.00', '0.00', '100 mg', 'Aceclofenac'), 
('2530', 'Ezipol   20 mg', '090-0044-067', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '4.50', '0.00', '20 mg', 'Esomeprazole'), 
('2531', 'Ezipol   40 mg', '090-0045-67', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '7.00', '0.00', '40 mg', 'Esomeprazole'), 
('2532', 'Painlac   10 mg', '090-0049-064', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('2533', 'Bedine   150 mg', '090-00335', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('2534', 'Bezol   400 mg', '090-0014-27', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('2535', 'Xloar   5 mg', '090-0055-21', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '5 mg', 'Desloratadine'), 
('2536', 'Montegol   10 mg', '090-0054-044', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '10 mg', 'Montelukast'), 
('2537', 'Etocoxet-60   60 mg', '090-0056-64', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '60 mg', 'Etoricoxib'), 
('2538', 'Etocoxet   90 mg', '090-0057-64', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '90 mg', 'Etoricoxib'), 
('2539', 'Digerab   20 mg', '090-0058-67', 'Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('2540', 'Tam-ER   665 mg', '090-0048-6', 'Xr Tablet', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '0.00', '0.00', '665 mg', 'Paracetamol'), 
('2541', 'Bencillin (Vet)   1 gm', '375-0030-023', 'Injection', 'Bengal Remedies Ltd.', '56.00', '0.00', '1 gm', 'Amoxicillin'), 
('2542', 'Water for Injection   10 ml', '375-0035-079', 'Injection', 'Bengal Remedies Ltd.', '7.00', '0.00', '10 ml', 'Water For Injection'), 
('2543', 'Relaben Bolus (Vet)   600 mg', '375-0002-077', 'Bolus', 'Bengal Remedies Ltd.', '6.38', '0.00', '600 mg', 'Albendazole'), 
('2544', 'Refenda Bolus (Vet)   250 mg', '375-0003-077', 'Bolus', 'Bengal Remedies Ltd.', '5.00', '0.00', '250 mg', 'Fenbendazole'), 
('2545', 'Remeflox C (Vet)   750 mg', '375-0008-077', 'Bolus', 'Bengal Remedies Ltd.', '15.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('2546', 'Remotet DS (Vet)   1 gm', '375-0010-077', 'Bolus', 'Bengal Remedies Ltd.', '6.00', '0.00', '1 gm', 'Oxytetracycline'), 
('2547', 'Remotet (Vet)   500 mg', '375-0011-077', 'Bolus', 'Bengal Remedies Ltd.', '3.00', '0.00', '500 mg', 'Oxytetracycline'), 
('2548', 'Remedy (Vet)   2 gm', '375-0021-077', 'Bolus', 'Bengal Remedies Ltd.', '2.25', '0.00', '2 gm', 'Paracetamol'), 
('2549', 'Remenid (Vet)   2 gm', '375-0022-077', 'Bolus', 'Bengal Remedies Ltd.', '4.50', '0.00', '2 gm', 'Metronidazole'), 
('2550', 'Belox   250 mg', '125-0011-23', 'Capsule', 'Benham Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('2551', 'Belox   500 mg', '125-0012-23', 'Capsule', 'Benham Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('2552', 'Benocef   250 mg', '125-0005-023', 'Capsule', 'Benham Pharmaceuticals Ltd.', '8.00', '0.00', '250 mg', 'Cephradine'), 
('2553', 'Benocef   500 mg', '125-0006-23', 'Capsule', 'Benham Pharmaceuticals Ltd.', '15.00', '0.00', '500 mg', 'Cephradine'), 
('2554', 'Benoxil   250 mg', '125-0007-023', 'Capsule', 'Benham Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('2555', 'Benoxil   500 mg', '125-0008-23', 'Capsule', 'Benham Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('2556', 'Exiben      200 mg', '125-0014-23', 'Capsule', 'Benham Pharmaceuticals Ltd.', '35.00', '0.00', '200 mg', 'Cefixime'), 
('2557', 'B-Clor   500 mg', '125-0035-23', 'Capsule', 'Benham Pharmaceuticals Ltd.', '37.00', '0.00', '500 mg', 'Cefaclor'), 
('2558', 'Asoben  TR   500 mg', '125-0045-78', 'Capsule', 'Benham Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Vitamin C'), 
('2559', 'Omeben      20 mg', '125--67', 'Capsule', 'Benham Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('2560', 'Esoben   20 mg', '125-0069-067', 'Capsule', 'Benham Pharmaceuticals Ltd.', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('2561', 'Esoben   40 mg', '125-0070-067', 'Capsule', 'Benham Pharmaceuticals Ltd.', '9.00', '0.00', '40 mg', 'Esomeprazole'), 
('2562', 'Omeben   40 mg', '125-0096-67', 'Capsule', 'Benham Pharmaceuticals Ltd.', '8.00', '0.00', '40 mg', 'Omeprazole'), 
('2563', 'Uropro   400 mcg', '125-00979', 'Capsule', 'Benham Pharmaceuticals Ltd.', '9.00', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('2564', 'Deonac TR   100 mg', '125-0102-64', 'Capsule', 'Benham Pharmaceuticals Ltd.', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('2565', 'Clindaben   300 mg', '125-0108-23', 'Capsule', 'Benham Pharmaceuticals Ltd.', '15.00', '0.00', '300 mg', 'Clindamycin'), 
('2566', 'Clindaben   150 mg', '125-0109-23', 'Capsule', 'Benham Pharmaceuticals Ltd.', '8.00', '0.00', '150 mg', 'Clindamycin'), 
('2567', 'Rabnil   20 mg', '125-0113-067', 'Capsule', 'Benham Pharmaceuticals Ltd.', '7.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('2568', 'Lactoben Solution   68 %', '125-0074-60', 'Oral Solution', 'Benham Pharmaceuticals Ltd.', '135.00', '0.00', '68 %', 'Lactulose'), 
('2569', 'Benprox   500 mg', '125-0015-23', 'Tablet', 'Benham Pharmaceuticals Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('2570', 'Bentid      150 mg', '125-00095', 'Tablet', 'Benham Pharmaceuticals Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('2571', 'Beonac      50 mg', '125-0013-64', 'Tablet', 'Benham Pharmaceuticals Ltd.', '0.70', '0.00', '50 mg', 'Diclofenac Sodium'), 
('2572', 'Carben   1250 mg', '125-0024-62', 'Tablet', 'Benham Pharmaceuticals Ltd.', '3.50', '0.00', '1250 mg', 'Calcium Carbonate'), 
('2573', 'Benformin   850 mg', '125-0023', 'Tablet', 'Benham Pharmaceuticals Ltd.', '5.50', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('2574', 'Benzith   500 mg', '125-0030-23', 'Tablet', 'Benham Pharmaceuticals Ltd.', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('2575', 'Ketobe   10 mg', '125-0032-064', 'Tablet', 'Benham Pharmaceuticals Ltd.', '9.94', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('2576', 'Naproben   500 mg', '125-0033-64', 'Tablet', 'Benham Pharmaceuticals Ltd.', '7.00', '0.00', '500 mg', 'Naproxen'), 
('2577', 'Benfloxin   500 mg', '125-0034-23', 'Tablet', 'Benham Pharmaceuticals Ltd.', '15.00', '0.00', '500 mg', 'Levofloxacin'), 
('2578', 'Clonaben.5   .5 mg', '125-0036-046', 'Tablet', 'Benham Pharmaceuticals Ltd.', '5.00', '0.00', '.5 mg', 'Clonazepam'), 
('2579', 'Benzopam 3   3 mg', '125-00377', 'Tablet', 'Benham Pharmaceuticals Ltd.', '5.00', '0.00', '3 mg', 'Bromazepam'), 
('2580', 'Benax   .5 mg', '125-00387', 'Tablet', 'Benham Pharmaceuticals Ltd.', '0.00', '0.00', '.5 mg', 'Alprazolam'), 
('2581', 'Benprox   750 mg', '125-0041-23', 'Tablet', 'Benham Pharmaceuticals Ltd.', '18.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('2582', 'Timoben   50 mg', '125-00441', 'Tablet', 'Benham Pharmaceuticals Ltd.', '5.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('2583', 'A-Pak   100 mg', '125-0048-64', 'Tablet', 'Benham Pharmaceuticals Ltd.', '4.00', '0.00', '100 mg', 'Aceclofenac'), 
('2584', 'Benkill   250 mg', '125-0031-23', 'Tablet', 'Benham Pharmaceuticals Ltd.', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('2585', 'Cetriben   10 mg', '125-0051-21', 'Tablet', 'Benham Pharmaceuticals Ltd.', '2.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('2586', 'Fluderm   50 mg', '125-0052', 'Tablet', 'Benham Pharmaceuticals Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('2587', 'Benidon   10 mg', '125-00538', 'Tablet', 'Benham Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('2588', 'Ketocure   1 mg', '125-0055-21', 'Tablet', 'Benham Pharmaceuticals Ltd.', '0.00', '0.00', '1 mg', 'Ketotifen'), 
('2589', 'Etoben   60 mg', '125-0057-64', 'Tablet', 'Benham Pharmaceuticals Ltd.', '6.00', '0.00', '60 mg', 'Etoricoxib'), 
('2590', 'Etoben   90 mg', '125-0058-64', 'Tablet', 'Benham Pharmaceuticals Ltd.', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('2591', 'Etoben   120 mg', '125-0059-64', 'Tablet', 'Benham Pharmaceuticals Ltd.', '14.00', '0.00', '120 mg', 'Etoricoxib'), 
('2592', 'Fluderm   150 mg', '125-0060', 'Tablet', 'Benham Pharmaceuticals Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('2593', 'Pantotop   20 mg', '125-0061-67', 'Tablet', 'Benham Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Pantoprazole'), 
('2594', 'Pantotop   40 mg', '125-0062-67', 'Tablet', 'Benham Pharmaceuticals Ltd.', '7.00', '0.00', '40 mg', 'Pantoprazole'), 
('2595', 'Benlor   5 mg', '125-0063-21', 'Tablet', 'Benham Pharmaceuticals Ltd.', '3.00', '0.00', '5 mg', 'Desloratadine'), 
('2596', 'Starfil   50 mg', '125-0064-043', 'Tablet', 'Benham Pharmaceuticals Ltd.', '35.00', '0.00', '50 mg', 'Sildenafil'), 
('2597', 'Starfil   100 mg', '125-0065-043', 'Tablet', 'Benham Pharmaceuticals Ltd.', '50.00', '0.00', '100 mg', 'Sildenafil'), 
('2598', 'X-Din   120 mg', '125-0066-21', 'Tablet', 'Benham Pharmaceuticals Ltd.', '7.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('2599', 'X-Din80   180 mg', '125-0067-21', 'Tablet', 'Benham Pharmaceuticals Ltd.', '9.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('2600', 'Clonaben   2 mg', '125-0075-046', 'Tablet', 'Benham Pharmaceuticals Ltd.', '7.00', '0.00', '2 mg', 'Clonazepam'), 
('2601', 'Mon   10 mg', '125-0072-044', 'Tablet', 'Benham Pharmaceuticals Ltd.', '15.00', '0.00', '10 mg', 'Montelukast'), 
('2602', 'Carben-O   400 mg', '125-0071-62', 'Tablet', 'Benham Pharmaceuticals Ltd.', '8.00', '0.00', '400 mg', 'Calcium Orotate'), 
('2603', 'Zuvas   10 mg', '125-0078-061', 'Tablet', 'Benham Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('2604', 'Zuvas   20 mg', '125-0079-061', 'Tablet', 'Benham Pharmaceuticals Ltd.', '18.00', '0.00', '20 mg', 'Atorvastatin'), 
('2605', 'Midorest   7.5 mg', '125-0081-057', 'Tablet', 'Benham Pharmaceuticals Ltd.', '0.00', '0.00', '7.5 mg', 'Midazolam'), 
('2606', 'Midorest   15 mg', '125-0082-057', 'Tablet', 'Benham Pharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Midazolam'), 
('2607', 'Butakof   50 mg', '125-0084-31', 'Tablet', 'Benham Pharmaceuticals Ltd.', '10.00', '0.00', '50 mg', 'Butamirate Citrate'), 
('2608', 'Ampress   5 mg', '125-0088-022', 'Tablet', 'Benham Pharmaceuticals Ltd.', '5.00', '0.00', '5 mg', 'Amlodipine'), 
('2609', 'Bacben   10 mg', '125-0089-70', 'Tablet', 'Benham Pharmaceuticals Ltd.', '8.00', '0.00', '10 mg', 'Baclofen'), 
('2610', 'Losapress   25 mg', '125-0090-022', 'Tablet', 'Benham Pharmaceuticals Ltd.', '4.05', '0.00', '25 mg', 'Losartan Potassium'), 
('2611', 'Losapress   50 mg', '125-0091-022', 'Tablet', 'Benham Pharmaceuticals Ltd.', '8.00', '0.00', '50 mg', 'Losartan Potassium'), 
('2612', 'Diglic   80 mg', '125-0092', 'Tablet', 'Benham Pharmaceuticals Ltd.', '6.50', '0.00', '80 mg', 'Gliclazide'), 
('2613', 'Sulfaben   500 mg', '125-0093-64', 'Tablet', 'Benham Pharmaceuticals Ltd.', '5.00', '0.00', '500 mg', 'Sulfasalazine'), 
('2614', 'Alodoben DS   400 mg', '125-0094-008', 'Tablet', 'Benham Pharmaceuticals Ltd.', '5.00', '0.00', '400 mg', 'Albendazole'), 
('2615', 'Mon   5 mg', '125-0098-044', 'Tablet', 'Benham Pharmaceuticals Ltd.', '8.00', '0.00', '5 mg', 'Montelukast'), 
('2616', 'Esoben   20 mg', '125-0099-067', 'Tablet', 'Benham Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('2617', 'Benformin0   500 mg', '125-0100', 'Tablet', 'Benham Pharmaceuticals Ltd.', '3.75', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('2618', 'Tolfi   200 mg', '125-01017', 'Tablet', 'Benham Pharmaceuticals Ltd.', '9.50', '0.00', '200 mg', 'Tolfenamic Acid'), 
('2619', 'Aboprost   200 mcg', '125-01069', 'Tablet', 'Benham Pharmaceuticals Ltd.', '14.50', '0.00', '200 mcg', 'Misoprostol'), 
('2620', 'Mifeben   200 mg', '125-0107-049', 'Tablet', 'Benham Pharmaceuticals Ltd.', '235.00', '0.00', '200 mg', 'Mifepristone'), 
('2621', 'Esoben   40 mg', '125-0110-67', 'Tablet', 'Benham Pharmaceuticals Ltd.', '8.00', '0.00', '40 mg', 'Esomeprazole'), 
('2622', 'Phydox   400 mg', '125-0112-044', 'Tablet', 'Benham Pharmaceuticals Ltd.', '10.00', '0.00', '400 mg', 'Doxophylline'), 
('2623', 'Ruin   10 mg', '125-0115-021', 'Tablet', 'Benham Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Rupatadine'), 
('2624', 'Nitacure   500 mg', '125-0116-027', 'Tablet', 'Benham Pharmaceuticals Ltd.', '10.00', '0.00', '500 mg', 'Nitazoxanide'), 
('2625', 'Benalgin XR   665 mg', '125-0080-6', 'Xr Tablet', 'Benham Pharmaceuticals Ltd.', '1.50', '0.00', '665 mg', 'Paracetamol'), 
('2626', 'Azithrocin   250 mg', '186-0134-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '25.00', '0.00', '250 mg', 'Azithromycin'), 
('2627', 'Cephalen   250 mg', '186-0037-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '6.73', '0.00', '250 mg', 'Cephalexin'), 
('2628', 'Cephalen   500 mg', '186-0106-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '12.60', '0.00', '500 mg', 'Cephalexin'), 
('2629', 'Cox B     100 mg', '186-0210-064', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '4.50', '0.00', '100 mg', 'Celecoxib'), 
('2630', 'Cox B     200 mg', '186-0211-064', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '200 mg', 'Celecoxib'), 
('2631', 'Decacycline   250 mg', '186-0019-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '1.32', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('2632', 'Decacycline   500 mg', '186-0206-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Tetracycline Hydrochloride'), 
('2633', 'Decapen   250 mg', '186-0021-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Ampicillin'), 
('2634', 'Eplon   10 mg', '186-0267-057', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Zaleplone'), 
('2635', 'Eplon      5 mg', '186-0266-057', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '6.00', '0.00', '5 mg', 'Zaleplone'), 
('2636', 'Fenamic   250 mg', '186-0354-64', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '2.01', '0.00', '250 mg', 'Mefenamic Acid'), 
('2637', 'Fibril   300 mg', '186-0355-61', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '7.00', '0.00', '300 mg', 'Gemfibrozil'), 
('2638', 'Flubex   500 mg', '186-0257-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('2639', 'Flubex   250 mg', '186-0217-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('2640', 'Intracef   250 mg', '186-0160-023', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '6.50', '0.00', '250 mg', 'Cephradine'), 
('2641', 'Intracef   500 mg', '186-0161-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '12.50', '0.00', '500 mg', 'Cephradine'), 
('2642', 'Lucidol      50 mg', '186-0252-65', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '7.50', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('2643', 'Megadox      100 mg', '186-0205-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '2.16', '0.00', '100 mg', 'Doxycycline'), 
('2644', 'Modipran   20 mg', '186-01194', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '2.89', '0.00', '20 mg', 'Fluoxetine'), 
('2645', 'Myconil      150 mg', '186-0059-30', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Rifampicin'), 
('2646', 'Myconil50   450 mg', '186-0060-30', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '450 mg', 'Rifampicin'), 
('2647', 'Normotil   2 mg', '186-00686', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Loperamide'), 
('2648', 'Omastin      50 mg', '186-0123', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('2649', 'Omastin      150 mg', '186-0137', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('2650', 'Primace   10 mg', '186-0351-022', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Ramipril'), 
('2651', 'Primace.5   2.5 mg', '186-0315-022', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '2.5 mg', 'Ramipril'), 
('2652', 'Primace      5 mg', '186-0314-022', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '5 mg', 'Ramipril'), 
('2653', 'Primace.25   1.25 mg', '186-0316-022', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '2.50', '0.00', '1.25 mg', 'Ramipril'), 
('2654', 'Proceptin      20 mg', '186-0098-67', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('2655', 'Protolan   15 mg', '186-0268-67', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '4.00', '0.00', '15 mg', 'Lansoprazole'), 
('2656', 'Protolan   30 mg', '186-0269-67', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '6.00', '0.00', '30 mg', 'Lansoprazole'), 
('2657', 'Triocim      200 mg', '186-0172-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '35.00', '0.00', '200 mg', 'Cefixime'), 
('2658', 'Tycil   250 mg', '186-0020-023', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('2659', 'Tycil   500 mg', '186-0195-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('2660', 'Uroflo   400 mcg', '186-03029', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('2661', 'Valcap   80 mg', '186-0295-22', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '8.50', '0.00', '80 mg', 'Valsartan'), 
('2662', 'Vercef      200 mg', '186-0378-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '42.00', '0.00', '200 mg', 'Cefpodoxime'), 
('2663', 'Xynofen  SR    100 mg', '186-0133-64', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '7.54', '0.00', '100 mg', 'Ketoprofen'), 
('2664', 'Valcap   160 mg', '186-0396-22', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '16.00', '0.00', '160 mg', 'Valsartan'), 
('2665', 'Nokof   375 mg', '186-0408-31', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '2.50', '0.00', '375 mg', 'Carbocisteine'), 
('2666', 'Lofat      200 mg', '186-0400-61', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '7.00', '0.00', '200 mg', 'Fenofibrate'), 
('2667', 'Proceptin      40 mg', '186-0419-67', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '40 mg', 'Omeprazole'), 
('2668', 'Cefida0   300 mg', '186-0437-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '45.00', '0.00', '300 mg', 'Cefdinir'), 
('2669', 'Clobex   500 mg', '186-0076-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cloxacillin'), 
('2670', 'Viracin      200 mg', '186-0428-32', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '35.00', '0.00', '200 mg', 'Ribavirin'), 
('2671', 'Oseflu   75 mg', '186-0510-32', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '150.00', '0.00', '75 mg', 'Oseltamivir'), 
('2672', 'Zilapro   500 mg', '186-0566-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '55.00', '0.00', '500 mg', 'Cefprozil'), 
('2673', 'Zilapro   250 mg', '186-0567-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '30.00', '0.00', '250 mg', 'Cefprozil'), 
('2674', 'Omastin   200 mg', '186-071', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '25.00', '0.00', '200 mg', 'Fluconazole'), 
('2675', 'Orpan   300 mg', '186-0718-64', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '300 mg', 'Etodolac'), 
('2676', 'Nervalin   75 mg', '186-0795-046', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '16.00', '0.00', '75 mg', 'Pregabalin'), 
('2677', 'Nervalin   50 mg', '186-0796-046', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '11.00', '0.00', '50 mg', 'Pregabalin'), 
('2678', 'Tranexil0   500 mg', '186-08079', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '15.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('2679', 'Clinacyn   150 mg', '186-0809-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '150 mg', 'Clindamycin'), 
('2680', 'Clinacyn   300 mg', '186-0810-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '15.00', '0.00', '300 mg', 'Clindamycin'), 
('2681', 'Opton   20 mg', '186-0817-067', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('2682', 'Opton   40 mg', '186-0818-067', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '40 mg', 'Esomeprazole'), 
('2683', 'Nervalin   25 mg', '186-0877-046', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '25 mg', 'Pregabalin'), 
('2684', 'Acifix   20 mg', '186-0905-67', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('2685', 'Triocim0   400 mg', '186-0670-23', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '50.00', '0.00', '400 mg', 'Cefixime'), 
('2686', 'D-Rise000   40000 IU', '186-0928-78', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '35.00', '0.00', '40000 IU', 'Cholecalciferol (Vit. D3)'), 
('2687', 'D-Rise00   20000 IU', '186-0929-78', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '20.00', '0.00', '20000 IU', 'Cholecalciferol (Vit. D3)'), 
('2688', 'Omastin   200 mg', '186-0717', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Fluconazole'), 
('2689', 'Vercef   100 mg', '186-0369-023', 'Capsule', 'Beximco Pharmaceuticals Ltd.', '22.00', '0.00', '100 mg', 'Cefpodoxime'), 
('2690', 'Burnsil%   1 %', '186-0349-23', 'Cream', 'Beximco Pharmaceuticals Ltd.', '45.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('2691', 'Tenafin   1 %', '186-0497-71', 'Cream', 'Beximco Pharmaceuticals Ltd.', '50.00', '0.00', '1 %', 'Butenafine'), 
('2692', 'Tycil   250 mg', '186-0227-023', 'Injection', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('2693', 'Water For Injection   10 ml', '186-0237-79', 'Injection', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '10 ml', 'Water For Injection'), 
('2694', 'Tycil   500 mg', '186-0228-23', 'Injection', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('2695', 'Water For Injection   5 ml', '186-0236-79', 'Injection', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '5 ml', 'Water For Injection'), 
('2696', 'Water for Injection   20 ml', '186-0754-79', 'Injection', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '20 ml', 'Water For Injection'), 
('2697', 'Azithrocin0 IV   500 mg', '186-0761-23', 'Injection', 'Beximco Pharmaceuticals Ltd.', '460.00', '0.00', '500 mg', 'Azithromycin'), 
('2698', 'Serelose   68 %', '186-0163-60', 'Oral Solution', 'Beximco Pharmaceuticals Ltd.', '130.00', '0.00', '68 %', 'Lactulose'), 
('2699', 'Frelax   17 gm', '186-0357-60', 'Powder', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '17 gm', 'Poly Ethylene Glycol 3350'), 
('2700', 'Neofloxin   250 mg', '186-0800-23', 'Sachet', 'Beximco Pharmaceuticals Ltd.', '12.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('2701', 'Monocast   4 mg', '186-0801-044', 'Sachet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '4 mg', 'Montelukast'), 
('2702', 'Opton Granules   20 mg', '186-0819-067', 'Sachet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('2703', 'Mucomist   600 mg', '186-0837-31', 'Sachet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '600 mg', 'Acetylcysteine'), 
('2704', 'Anxiolax   10 mg', '186-0166-057', 'Suppository', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Diazepam'), 
('2705', 'Domicet   100 mg', '186-0176-64', 'Suppository', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Indomethacin'), 
('2706', 'Filmet   500 mg', '186-0156-27', 'Suppository', 'Beximco Pharmaceuticals Ltd.', '29.89', '0.00', '500 mg', 'Metronidazole'), 
('2707', 'Lucidol   100 mg', '186-0395-65', 'Suppository', 'Beximco Pharmaceuticals Ltd.', '15.00', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('2708', 'Meclomid   10 mg', '186-01588', 'Suppository', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Metoclopramide Hydrochloride'), 
('2709', 'Napa   125 mg', '186-0152-006', 'Suppository', 'Beximco Pharmaceuticals Ltd.', '4.00', '0.00', '125 mg', 'Paracetamol'), 
('2710', 'Napa   250 mg', '186-0153-006', 'Suppository', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '250 mg', 'Paracetamol'), 
('2711', 'Napa   500 mg', '186-0374-006', 'Suppository', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '500 mg', 'Paracetamol'), 
('2712', 'Ultrafen   12.5 mg', '186-0154-64', 'Suppository', 'Beximco Pharmaceuticals Ltd.', '9.00', '0.00', '12.5 mg', 'Diclofenac Sodium'), 
('2713', 'Ultrafen      50 mg', '186-0155-64', 'Suppository', 'Beximco Pharmaceuticals Ltd.', '15.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('2714', 'Xynofen   100 mg', '186-0157-64', 'Suppository', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Ketoprofen'), 
('2715', 'Ultrafen      25 mg', '186-0523-64', 'Suppository', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Diclofenac Sodium'), 
('2716', 'Napa   60 mg', '186-0558-006', 'Suppository', 'Beximco Pharmaceuticals Ltd.', '3.50', '0.00', '60 mg', 'Paracetamol'), 
('2717', 'Ultrafen   100 mg', '186-0794-64', 'Suppository', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('2718', 'Alendon   10 mg', '186-02148', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '10 mg', 'Alendronic Acid'), 
('2719', 'Alendon   70 mg', '186-02778', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '25.00', '0.00', '70 mg', 'Alendronic Acid'), 
('2720', 'Alphatensin   250 mg', '186-0018-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Methyldopa'), 
('2721', 'Alphin  DS   400 mg', '186-0139-008', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '400 mg', 'Albendazole'), 
('2722', 'Amdocal   10 mg', '186-0125-022', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '7.00', '0.00', '10 mg', 'Amlodipine'), 
('2723', 'Anxiolax      5 mg', '186-0036-057', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Diazepam'), 
('2724', 'Arbit      150 mg', '186-0276-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '150 mg', 'Irbesartan'), 
('2725', 'Arbit      75 mg', '186-0275-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '75 mg', 'Irbesartan'), 
('2726', 'Aristocal   1250 mg', '186-0245-62', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('2727', 'Arlin   400 mg', '186-0336-023', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '60.00', '0.00', '400 mg', 'Linezolid'), 
('2728', 'Arlin   600 mg', '186-0335-023', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '85.00', '0.00', '600 mg', 'Linezolid'), 
('2729', 'Ascobex   250 mg', '186-0063-78', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.32', '0.00', '250 mg', 'Vitamin C'), 
('2730', 'Atova   10 mg', '186-0238-061', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('2731', 'Atova      20 mg', '186-0239-061', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '18.00', '0.00', '20 mg', 'Atorvastatin'), 
('2732', 'Telma   50 mg', '186-03474', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '50 mg', 'Sertraline'), 
('2733', 'Atrizin   10 mg', '186-0147-21', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('2734', 'Semastin   10 mg', '186-0178-61', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Simvastatin'), 
('2735', 'Avidro   500 mcg', '186-03207', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '500 mcg', 'Pizotifen'), 
('2736', 'Avidro.5   1.5 mg', '186-03197', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '7.00', '0.00', '1.5 mg', 'Pizotifen'), 
('2737', 'Axodin20   120 mg', '186-0383-21', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '7.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('2738', 'Axodin80   180 mg', '186-0388-21', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '9.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('2739', 'Axodin   60 mg', '186-0341-21', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('2740', 'Azithrocin   500 mg', '186-0196-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('2741', 'Avitron V     100 mg', '186-0208-78', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.75', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('2742', 'Betabex   10 mg', '186-0065-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Propranolol Hydrochloride'), 
('2743', 'Betabex      40 mg', '186-0064-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Propranolol Hydrochloride'), 
('2744', 'Bexidal   50 mg', '186-0002-21', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '50 mg', 'Mebhydrolin'), 
('2745', 'Azmasol   2 mg', '186-00714', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.26', '0.00', '2 mg', 'Salbutamol'), 
('2746', 'Calcibex   1250 mg', '186-0145-62', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('2747', 'Cardopril      25 mg', '186-0082-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.01', '0.00', '25 mg', 'Captopril'), 
('2748', 'Cardopril      50 mg', '186-0083-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '6.02', '0.00', '50 mg', 'Captopril'), 
('2749', 'Carnitab   330 mg', '186-0393', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.02', '0.00', '330 mg', 'Levocarnitine'), 
('2750', 'Telmacal   5 mg', '186-0294-36', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.02', '0.00', '5 mg', 'Vinpocetine'), 
('2751', 'Curin   5 mg', '186-0346-21', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.50', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('2752', 'Deflux   10 mg', '186-02188', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('2753', 'Diactin      5 mg', '186-0118', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.50', '0.00', '5 mg', 'Glipizide'), 
('2754', 'Diaglit   15 mg', '186-0265', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Pioglitazone'), 
('2755', 'Diapro   80 mg', '186-0203', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '7.00', '0.00', '80 mg', 'Gliclazide'), 
('2756', 'Diaryl   1 mg', '186-0297', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.50', '0.00', '1 mg', 'Glimepiride'), 
('2757', 'Diaryl   2 mg', '186-0296', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '2 mg', 'Glimepiride'), 
('2758', 'Dilapress   12.5 mg', '186-0326-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '12.5 mg', 'Carvedilol'), 
('2759', 'Dilapress      25 mg', '186-0325-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '25 mg', 'Carvedilol'), 
('2760', 'Dilapress   6.25 mg', '186-0327-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '6.25 mg', 'Carvedilol'), 
('2761', 'Enaril   10 mg', '186-0143-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Enalapril Maleate'), 
('2762', 'Enaril      5 mg', '186-0142-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.00', '0.00', '5 mg', 'Enalapril Maleate'), 
('2763', 'Epilep      200 mg', '186-0270-046', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.52', '0.00', '200 mg', 'Carbamazepine'), 
('2764', 'Epilep  CR   200 mg', '186-0282-046', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.51', '0.00', '200 mg', 'Carbamazepine'), 
('2765', 'Ethambex   400 mg', '186-0074-30', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Ethambutol'), 
('2766', 'Etrocin   250 mg', '186-0014-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.82', '0.00', '250 mg', 'Erythromycin'), 
('2767', 'Etrocin   500 mg', '186-0197-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '9.03', '0.00', '500 mg', 'Erythromycin'), 
('2768', 'Evo   250 mg', '186-0307-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '9.00', '0.00', '250 mg', 'Levofloxacin'), 
('2769', 'Evo   500 mg', '186-0306-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '16.00', '0.00', '500 mg', 'Levofloxacin'), 
('2770', 'Fertil      50 mg', '186-02813', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '50 mg', 'Clomiphene Citrate'), 
('2771', 'Filmet   400 mg', '186-0044-27', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.27', '0.00', '400 mg', 'Metronidazole'), 
('2772', 'Filmet      200 mg', '186-0043-27', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.68', '0.00', '200 mg', 'Metronidazole'), 
('2773', 'Filmet  DS   800 mg', '186-0274-27', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.01', '0.00', '800 mg', 'Metronidazole'), 
('2774', 'Frezma  SR   300 mg', '186-03504', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Theophylline'), 
('2775', 'Furalax      40 mg', '186-00292', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Frusemide'), 
('2776', 'Gastalfet   500 mg', '186-0078-7', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.02', '0.00', '500 mg', 'Sucralfate'), 
('2777', 'Glabinol      5 mg', '186-0066', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Glibenclamide'), 
('2778', 'Hypover      40 mg', '186-0093-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Verapamil Hydrochloride'), 
('2779', 'Hypover   80 mg', '186-0094-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '80 mg', 'Verapamil Hydrochloride'), 
('2780', 'Inarzin   15 mg', '186-0207-21', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.90', '0.00', '15 mg', 'Cinnarizine'), 
('2781', 'Informet   500 mg', '186-0285', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('2782', 'Informet   850 mg', '186-0284', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.50', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('2783', 'Informet  LA   500 mg', '186-0286', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('2784', 'Isofloxin   400 mg', '186-0128-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '12.05', '0.00', '400 mg', 'Pefloxacin'), 
('2785', 'Keolax   10 mg', '186-00916', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.77', '0.00', '10 mg', 'Clobazam'), 
('2786', 'Lanrox      100 mg', '186-02884', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Aminophylline'), 
('2787', 'Larnox  LA  350   350 mg', '186-02894', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.21', '0.00', '350 mg', 'Aminophylline'), 
('2788', 'Lonet      100 mg', '186-0353-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.37', '0.00', '100 mg', 'Atenolol'), 
('2789', 'Lonet      50 mg', '186-0352-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.77', '0.00', '50 mg', 'Atenolol'), 
('2790', 'Meclomid   10 mg', '186-00768', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Metoclopramide Hydrochloride'), 
('2791', 'Melphin   125 mg', '186-0032-8', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.67', '0.00', '125 mg', 'Pyrantel Pamoate'), 
('2792', 'Momento   5 mg', '186-0292-21', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.50', '0.00', '5 mg', 'Desloratadine'), 
('2793', 'Monate      20 mg', '186-0209', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.43', '0.00', '20 mg', 'Isosorbide Mononitrate'), 
('2794', 'Monocast   10 mg', '186-0338-044', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '15.00', '0.00', '10 mg', 'Montelukast'), 
('2795', 'Monocast   4 mg', '186-0340-044', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '6.00', '0.00', '4 mg', 'Montelukast'), 
('2796', 'Relentus   2 mg', '186-0255-70', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '2 mg', 'Tizanidine'), 
('2797', 'Napa   500 mg', '186-0030-006', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('2798', 'Nebactil   500 mg', '186-0075-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.08', '0.00', '500 mg', 'Nalidixic Acid'), 
('2799', 'Neocard   30 mg', '186-0100-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.00', '0.00', '30 mg', 'Diltiazem Hydrochloride'), 
('2800', 'Neocard   60 mg', '186-0101-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.80', '0.00', '60 mg', 'Diltiazem Hydrochloride'), 
('2801', 'Neoceptin R     150 mg', '186-00485', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.50', '0.00', '150 mg', 'Ranitidine'), 
('2802', 'Neoceptin R    300 mg', '186-01035', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.00', '0.00', '300 mg', 'Ranitidine'), 
('2803', 'Neofloxin   250 mg', '186-0092-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.50', '0.00', '250 mg', 'Ciprofloxacin'), 
('2804', 'Neofloxin   750 mg', '186-0247-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '18.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('2805', 'Neofloxin   500 mg', '186-0138-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '15.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('2806', 'Neoprazin   500 mg', '186-0061-30', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Pyrazinamide'), 
('2807', 'Neopril   10 mg', '186-0116-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '6.02', '0.00', '10 mg', 'Lisinopril'), 
('2808', 'Neopril      5 mg', '186-0129-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.01', '0.00', '5 mg', 'Lisinopril'), 
('2809', 'Nightus   3 mg', '186-03177', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '3 mg', 'Bromazepam'), 
('2810', 'Nisozid0   300 mg', '186-0056-30', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Isoniazid'), 
('2811', 'Nuprafen   250 mg', '186-0097-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.20', '0.00', '250 mg', 'Naproxen'), 
('2812', 'Nuprafen   500 mg', '186-0141-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '7.85', '0.00', '500 mg', 'Naproxen'), 
('2813', 'Odrel      75 mg', '186-0253-26', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '12.00', '0.00', '75 mg', 'Clopidogrel'), 
('2814', 'Onsat   8 mg', '186-03488', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '8 mg', 'Ondansetron'), 
('2815', 'Opton      20 mg', '186-0278-067', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('2816', 'Opton      40 mg', '186-0385-67', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '40 mg', 'Esomeprazole'), 
('2817', 'Pacet      100 mg', '186-0264-9', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.02', '0.00', '100 mg', 'Amiodarone Hydrochloride'), 
('2818', 'Pacet      200 mg', '186-0263-9', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.04', '0.00', '200 mg', 'Amiodarone Hydrochloride'), 
('2819', 'Premil   .5 mg', '186-0248-015', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.00', '0.00', '.5 mg', 'Repaglinide'), 
('2820', 'Premil   1 mg', '186-0249-015', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '1 mg', 'Repaglinide'), 
('2821', 'Premil   2 mg', '186-0250-015', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '2 mg', 'Repaglinide'), 
('2822', 'Pretin   10 mg', '186-0194-21', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '10 mg', 'Loratadine'), 
('2823', 'Prosan      25 mg', '186-0215-022', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.50', '0.00', '25 mg', 'Losartan Potassium'), 
('2824', 'Prosan      50 mg', '186-0216-022', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '50 mg', 'Losartan Potassium'), 
('2825', 'Prosfin      5 mg', '186-01489', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.04', '0.00', '5 mg', 'Finasteride'), 
('2826', 'Receptin A   200 mg', '186-00345', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Cimetidine'), 
('2827', 'Recur   1 mg', '186-01936', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.02', '0.00', '1 mg', 'Finasteride'), 
('2828', 'Reflon   500 mg', '186-0303-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '500 mg', 'Glucosamine'), 
('2829', 'Reumafen      200 mg', '186-0017-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.88', '0.00', '200 mg', 'Ibuprofen'), 
('2830', 'Reumafen   400 mg', '186-0050-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.43', '0.00', '400 mg', 'Ibuprofen'), 
('2831', 'Rezoven   10 mg', '186-0384-32', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '35.00', '0.00', '10 mg', 'Adefovir Dipivoxil'), 
('2832', 'Rolacin   250 mg', '186-0198-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '25.00', '0.00', '250 mg', 'Clarithromycin'), 
('2833', 'Rolacin   500 mg', '186-0200-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '40.00', '0.00', '500 mg', 'Clarithromycin'), 
('2834', 'Rostil   135 mg', '186-01401', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '7.00', '0.00', '135 mg', 'Mebeverine Hydrochloride'), 
('2835', 'Salazex   500 mg', '186-0095-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Sulfasalazine'), 
('2836', 'Sensipin   25 mg', '186-01794', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.84', '0.00', '25 mg', 'Clozapine'), 
('2837', 'Seronil   10 mg', '186-00704', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Amitriptyline Hydrochloride'), 
('2838', 'Seronil      25 mg', '186-00694', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Amitriptyline Hydrochloride'), 
('2839', 'Spanil   10 mg', '186-00331', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.45', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('2840', 'Sparlin      200 mg', '186-0243-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '15.06', '0.00', '200 mg', 'Sparfloxacin'), 
('2841', 'Spulyt   8 mg', '186-0313-031', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.00', '0.00', '8 mg', 'Bromhexine Hydrochloride'), 
('2842', 'Stopain   25 mg', '186-0040-065', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Pentazocine Hydrochloride'), 
('2843', 'Synomid   10 mg', '186-0300-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '10 mg', 'Leflunomide'), 
('2844', 'Synomid      20 mg', '186-0299-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.50', '0.00', '20 mg', 'Leflunomide'), 
('2845', 'Synomid      100 mg', '186-0298-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '20.00', '0.00', '100 mg', 'Leflunomide'), 
('2846', 'Tamona   10 mg', '186-0310', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.07', '0.00', '10 mg', 'Tamoxifen'), 
('2847', 'Tamona      20 mg', '186-0309', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '16.07', '0.00', '20 mg', 'Tamoxifen'), 
('2848', 'Taverin   40 mg', '186-03011', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.75', '0.00', '40 mg', 'Drotaverine Hydrochloride'), 
('2849', 'Terbex   250 mg', '186-0240', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '50.00', '0.00', '250 mg', 'Terbinafine'), 
('2850', 'Tofen   1 mg', '186-0084-21', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.50', '0.00', '1 mg', 'Ketotifen'), 
('2851', 'Turbocef   250 mg', '186-0124-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('2852', 'Ultracor      20 mg', '186-0113-61', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Lovastatin'), 
('2853', 'Ultracor      40 mg', '186-0114-61', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Lovastatin'), 
('2854', 'Ultrafen      25 mg', '186-0081-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.54', '0.00', '25 mg', 'Diclofenac Sodium'), 
('2855', 'Ultrafen      50 mg', '186-0079-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.83', '0.00', '50 mg', 'Diclofenac Sodium'), 
('2856', 'Uricon  CR   5 mg', '186-02901', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '6.02', '0.00', '5 mg', 'Oxybutynin Hydrochloride'), 
('2857', 'Utirol   125 mcg', '186-00629', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '125 mcg', 'Methyl Ergometrine Maleate'), 
('2858', 'Xidolac   10 mg', '186-0321-064', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('2859', 'Yamadin      20 mg', '186-01115', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.90', '0.00', '20 mg', 'Famotidine'), 
('2860', 'Yamadin      40 mg', '186-01125', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.82', '0.00', '40 mg', 'Famotidine'), 
('2861', 'Zocil      100 mg', '186-0279-36', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '12.00', '0.00', '100 mg', 'Cilostazol'), 
('2862', 'Zocil      50 mg', '186-0280-36', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '7.00', '0.00', '50 mg', 'Cilostazol'), 
('2863', 'Zolax   .5 mg', '186-02717', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.00', '0.00', '.5 mg', 'Alprazolam'), 
('2864', 'Zolmit.5   2.5 mg', '186-03867', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '25.00', '0.00', '2.5 mg', 'Zolmitriptan'), 
('2865', 'Zukast      20 mg', '186-02204', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '26.00', '0.00', '20 mg', 'Zafirlukast'), 
('2866', 'Zymet   325 mg', '186-00421', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.50', '0.00', '325 mg', 'Pancreatin'), 
('2867', 'Neopril      20 mg', '186-0115-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Lisinopril'), 
('2868', 'Diaryl   3 mg', '186-0397', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '3 mg', 'Glimepiride'), 
('2869', 'Pedrox      150 mg', '186-0401-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Roxithromycin'), 
('2870', 'Pedrox0   300 mg', '186-0402-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Roxithromycin'), 
('2871', 'Xetril   .5 mg', '186-0403-046', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '.5 mg', 'Clonazepam'), 
('2872', 'Xetril   2 mg', '186-0404-046', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '2 mg', 'Clonazepam'), 
('2873', 'Vasolax   400 mg', '186-0405-36', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '7.00', '0.00', '400 mg', 'Pentoxifylline'), 
('2874', 'Vomec   50 mg', '186-04068', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.50', '0.00', '50 mg', 'Meclizine Hydrochloride'), 
('2875', 'Dexifen      200 mg', '186-0502-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '200 mg', 'Dexibuprofen (S Ibuprofen)'), 
('2876', 'Dexifen0   300 mg', '186-0503-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.00', '0.00', '300 mg', 'Dexibuprofen (S Ibuprofen)'), 
('2877', 'Dexifen   400 mg', '186-0504-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '400 mg', 'Dexibuprofen (S Ibuprofen)'), 
('2878', 'Repitol   .25 mg', '186-0505-025', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.01', '0.00', '.25 mg', 'Ropinirole'), 
('2879', 'Repitol   2 mg', '186-0506-025', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.04', '0.00', '2 mg', 'Ropinirole'), 
('2880', 'Ovalac   500 mg', '186-0507-32', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '150.00', '0.00', '500 mg', 'Valacyclovir'), 
('2881', 'Deflux  Rapid   10 mg', '186-04998', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('2882', 'Amdocal      5 mg', '186-0126-022', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '5 mg', 'Amlodipine'), 
('2883', 'Azmasol   4 mg', '186-00854', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Salbutamol'), 
('2884', 'Melev   20 mg', '186-03664', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '9.54', '0.00', '20 mg', 'Paroxetine'), 
('2885', 'Monocast      5 mg', '186-0339-044', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '5 mg', 'Montelukast'), 
('2886', 'Neofloxin  XR   500 mg', '186-0371-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '11.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('2887', 'Odycin   400 mg', '186-0367-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '70.00', '0.00', '400 mg', 'Moxifloxacin'), 
('2888', 'Xynor   500 mg', '186-0365-27', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '6.50', '0.00', '500 mg', 'Ornidazole'), 
('2889', 'Zolfin   100 mg', '186-0372-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.00', '0.00', '100 mg', 'Aceclofenac'), 
('2890', 'Avifix   250 mg', '186-023-32', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '45.00', '0.00', '250 mg', 'Nelfinavir'), 
('2891', 'Zolax   .25 mg', '186-04437', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '.25 mg', 'Alprazolam'), 
('2892', 'Celiprol   200 mg', '186-0453-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Celiprolol Hydrochloride'), 
('2893', 'Celiprol0   400 mg', '186-0454-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Celiprolol Hydrochloride'), 
('2894', 'Ribox   60 mg', '186-0414-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '7.00', '0.00', '60 mg', 'Etoricoxib'), 
('2895', 'Ribox   90 mg', '186-0415-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('2896', 'Ezeta   10 mg', '186-0436-61', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.04', '0.00', '10 mg', 'Ezetimibe'), 
('2897', 'Flurium   10 mg', '186-04487', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '10 mg', 'Flunarizine'), 
('2898', 'Flurium      5 mg', '186-04477', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '5 mg', 'Flunarizine'), 
('2899', 'Epipen0   300 mg', '186-0413-046', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Gabapentin'), 
('2900', 'Zedex      20 mg', '186-044-62', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.50', '0.00', '20 mg', 'Zinc'), 
('2901', 'Fenamic   500 mg', '186-0424-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.82', '0.00', '500 mg', 'Mefenamic Acid'), 
('2902', 'Zoldem   10 mg', '186-04167', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Zolpidem Tartrate'), 
('2903', 'Formula E     200 mg', '186-0144-78', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.82', '0.00', '200 mg', 'Vitamin E'), 
('2904', 'Avifanz   600 mg', '186-023-32', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '200.00', '0.00', '600 mg', 'Efavirenz'), 
('2905', 'Avilam   150 mg', '186-023-32', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '20.00', '0.00', '150 mg', 'Lamivudine'), 
('2906', 'Pantobex      20 mg', '186-0439-67', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Pantoprazole'), 
('2907', 'Pantobex      40 mg', '186-0440-67', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '7.00', '0.00', '40 mg', 'Pantoprazole'), 
('2908', 'Napa  DT   500 mg', '186-0479-006', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.28', '0.00', '500 mg', 'Paracetamol'), 
('2909', 'Ivera   6 mg', '186-0513-8', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '15.00', '0.00', '6 mg', 'Ivermectin'), 
('2910', 'Emonium   50 mg', '186-05461', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('2911', 'Epipen   300 mg', '186-0528-046', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '18.00', '0.00', '300 mg', 'Gabapentin'), 
('2912', 'Purator7   17 mg', '186-0487-29', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '17 mg', 'Sodium Dichloroisocyanurate'), 
('2913', 'Purator     51 mg', '186-0488-29', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '51 mg', 'Sodium Dichloroisocyanurate'), 
('2914', 'Purator25   425 mg', '186-0489-29', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '425 mg', 'Sodium Dichloroisocyanurate'), 
('2915', 'Hemostat   250 mg', '186-04919', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Tranexamic Acid'), 
('2916', 'Hemostat   500 mg', '186-04929', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('2917', 'Memorin   5 mg', '186-0494-28', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '5 mg', 'Donepezil Hydrochloride'), 
('2918', 'Myoxin   250 mcg', '186-0498-35', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '250 mcg', 'Digoxin'), 
('2919', 'Evo   750 mg', '186-0511-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '20.00', '0.00', '750 mg', 'Levofloxacin'), 
('2920', 'Adinot   50 mg', '186-05197', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '75.00', '0.00', '50 mg', 'Naltrexone'), 
('2921', 'Bugesic   200 mcg', '186-0522-65', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '200 mcg', 'Buprenorphine'), 
('2922', 'Loverin   10 mg', '186-05241', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.01', '0.00', '10 mg', 'Dicycloverine Hydrochloride'), 
('2923', 'Roxatin      75 mg', '186-05295', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '75 mg', 'Roxatidine'), 
('2924', 'Roxatin      150 mg', '186-0525', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Roxatidine'), 
('2925', 'Nuromec   .5 mg', '186-0531-78', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '.5 mg', 'Mecobalamin'), 
('2926', 'S-Clon   1 mg', '186-0533-057', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.01', '0.00', '1 mg', 'Eszopiclone'), 
('2927', 'S-Clon   2 mg', '186-0534-057', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.01', '0.00', '2 mg', 'Eszopiclone'), 
('2928', 'Respira   1 mg', '186-05354', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.90', '0.00', '1 mg', 'Levosalbutamol'), 
('2929', 'Respira   2 mg', '186-05364', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.70', '0.00', '2 mg', 'Levosalbutamol'), 
('2930', 'Tolmus   50 mg', '186-0543-70', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '50 mg', 'Tolperisone Hydrochloride'), 
('2931', 'Concentra   5 mg', '186-05504', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Methylphenidate Hydrochloride'), 
('2932', 'Concentra SR   10 mg', '186-05514', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Methylphenidate Hydrochloride'), 
('2933', 'Spazlo      5 mg', '186-05524', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Cyclobenzaprine Hydrochloride'), 
('2934', 'C Gum   250 mg', '186-0569-78', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.80', '0.00', '250 mg', 'Vitamin C'), 
('2935', 'Adafil   10 mg', '186-0570-043', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '35.00', '0.00', '10 mg', 'Tadalafil'), 
('2936', 'Adafil   20 mg', '186-0571-043', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '60.00', '0.00', '20 mg', 'Tadalafil'), 
('2937', 'Labeta      100 mg', '186-0574-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.50', '0.00', '100 mg', 'Labetalol Hydrochloride'), 
('2938', 'Labeta      200 mg', '186-0575-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '9.00', '0.00', '200 mg', 'Labetalol Hydrochloride'), 
('2939', 'Tolmic   200 mg', '186-05767', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.03', '0.00', '200 mg', 'Tolfenamic Acid'), 
('2940', 'Ketopro   25 mg', '186-0593-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Dexketoprofen'), 
('2941', 'Nitaxide   500 mg', '186-0594-27', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '500 mg', 'Nitazoxanide'), 
('2942', 'Metoprol XL   100 mg', '186-0638-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '100 mg', 'Metoprolol Tartrate'), 
('2943', 'Peridrop   2 mg', '186-0639-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Perindopril Erbumine'), 
('2944', 'Peridrop   4 mg', '186-0640-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Perindopril Erbumine'), 
('2945', 'Metazine MR   35 mg', '186-0642', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '6.00', '0.00', '35 mg', 'Trimetazidine Dihydrochloride'), 
('2946', 'Perindrop 8   8 mg', '186-0641-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '8 mg', 'Perindopril Erbumine'), 
('2947', 'Mobicam   20 mg', '186-0643-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '20 mg', 'Tenoxicam'), 
('2948', 'Misopa   200 mcg', '186-06259', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '15.00', '0.00', '200 mcg', 'Misoprostol'), 
('2949', 'Misopa0   600 mcg', '186-06269', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '40.00', '0.00', '600 mcg', 'Misoprostol'), 
('2950', 'Misopa   100 mcg', '186-06249', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '100 mcg', 'Misoprostol'), 
('2951', 'Turbocef0   500 mg', '186-0621-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('2952', 'Rosutin   40 mg', '186-0654-61', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Rosuvastatin'), 
('2953', 'Atova   40 mg', '186-0650-061', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '24.00', '0.00', '40 mg', 'Atorvastatin'), 
('2954', 'Lospan   10 mg', '186-0675-70', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '10 mg', 'Baclofen'), 
('2955', 'Lospan   25 mg', '186-0676-70', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '16.00', '0.00', '25 mg', 'Baclofen'), 
('2956', 'Olmesan   20 mg', '186-0668-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('2957', 'Olmesan   40 mg', '186-0669-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '15.00', '0.00', '40 mg', 'Olmesartan Medoxomil'), 
('2958', 'Thalin   25 mg', '186-07022', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '25 mg', 'Chlorthalidone'), 
('2959', 'Seropam   5 mg', '186-07214', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.50', '0.00', '5 mg', 'Escitalopram'), 
('2960', 'Seropam   10 mg', '186-07224', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '10 mg', 'Escitalopram'), 
('2961', 'Dipovir   300 mg', '186-0726-32', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Tenofovir Disoproxil Fumarate'), 
('2962', 'Glipita   100 mg', '186-0711', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '25.00', '0.00', '100 mg', 'Sitagliptin'), 
('2963', 'Glipita   50 mg', '186-0710', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '13.00', '0.00', '50 mg', 'Sitagliptin'), 
('2964', 'Ribox   120 mg', '186-0713-64', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '14.00', '0.00', '120 mg', 'Etoricoxib'), 
('2965', 'ACIFIX   20 mg', '186-0712-67', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('2966', 'Prasuva   10 mg', '186-0720-26', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '20.00', '0.00', '10 mg', 'Prasugrel'), 
('2967', 'Prasuva   5 mg', '186-0719-26', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '12.00', '0.00', '5 mg', 'Prasugrel'), 
('2968', 'Carvedilol 3.125   3.125 mg', '186-0751-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '3.125 mg', 'Carvedilol'), 
('2969', 'Enegra   50 mg', '186-0781-043', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '30.00', '0.00', '50 mg', 'Sildenafil'), 
('2970', 'Enegra   100 mg', '186-0782-043', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '50.00', '0.00', '100 mg', 'Sildenafil'), 
('2971', 'Diapro MR   30 mg', '186-0769', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '7.00', '0.00', '30 mg', 'Gliclazide'), 
('2972', 'Rixamin   200 mg', '186-0798-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '25.00', '0.00', '200 mg', 'Rifaximin'), 
('2973', 'Rixamin50   550 mg', '186-0799-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '55.00', '0.00', '550 mg', 'Rifaximin'), 
('2974', 'Eburic   40 mg', '186-0767-76', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '12.00', '0.00', '40 mg', 'Febuxostat'), 
('2975', 'Calorate   400 mg', '186-0788-62', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '400 mg', 'Calcium Orotate'), 
('2976', 'Hemofix   275 mg', '186-07915', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '4.00', '0.00', '275 mg', 'Ferrous Ascorbate'), 
('2977', 'Indelix SR   1.5 mg', '186-07682', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '6.00', '0.00', '1.5 mg', 'Indapamide'), 
('2978', 'Azithrocin   250 mg', '186-0816-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '25.00', '0.00', '250 mg', 'Azithromycin'), 
('2979', 'Liveric   150 mg', '186-0826', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '11.00', '0.00', '150 mg', 'Ursodeoxycholic Acid'), 
('2980', 'Liveric   300 mg', '186-0827', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '20.00', '0.00', '300 mg', 'Ursodeoxycholic Acid'), 
('2981', 'Ibanil   150 mg', '186-0829-048', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Ibandronic Acid'), 
('2982', 'Bexipred   10 mg', '186-0842-72', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.23', '0.00', '10 mg', 'Prednisolone'), 
('2983', 'Bexipred   20 mg', '186-0843-72', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '6.28', '0.00', '20 mg', 'Prednisolone'), 
('2984', 'Femzole   2.5 mg', '186-0844', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '40.00', '0.00', '2.5 mg', 'Letrozole'), 
('2985', 'Breathlin SR   200 mg', '186-08414', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.60', '0.00', '200 mg', 'Theophylline'), 
('2986', 'Calorate 740   740 mg', '186-0847-62', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '740 mg', 'Calcium Orotate'), 
('2987', 'Citicol   500 mg', '186-0854-36', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '50.00', '0.00', '500 mg', 'Citicoline'), 
('2988', 'Synroid   50 mcg', '186-0848-74', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.60', '0.00', '50 mcg', 'Levothyroxine Sodium'), 
('2989', 'Odeson   .5 mg', '186-0849-72', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.15', '0.00', '.5 mg', 'Dexamethasone'), 
('2990', 'Norestin   5 mg', '186-0850-39', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '6.84', '0.00', '5 mg', 'Norethisterone'), 
('2991', 'Tibilon   2.5 mg', '186-08516', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '21.50', '0.00', '2.5 mg', 'Tibolone'), 
('2992', 'Diapro MR   60 mg', '186-0855', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '12.00', '0.00', '60 mg', 'Gliclazide'), 
('2993', 'Olmesan   10 mg', '186-0857-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '10 mg', 'Olmesartan Medoxomil'), 
('2994', 'Betapro   2.5 mg', '186-0871-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '6.00', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('2995', 'Betapro   5 mg', '186-0872-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('2996', 'Betapro   10 mg', '186-0873-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '16.00', '0.00', '10 mg', 'Bisoprolol Hemifumarate'), 
('2997', 'Traneta   5 mg', '186-0876-015', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '25.00', '0.00', '5 mg', 'Linagliptin'), 
('2998', 'Rosutin   20 mg', '186-0886-61', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '30.00', '0.00', '20 mg', 'Rosuvastatin'), 
('2999', 'Fixolin   400 mg', '186-08954', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '400 mg', 'Doxophylline'), 
('3000', 'Cortiflo   6 mg', '186-0896-72', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '6 mg', 'Deflazacort'), 
('3001', 'Bexipred   5 mg', '186-0897-72', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.72', '0.00', '5 mg', 'Prednisolone'), 
('3002', 'Sofovir-C   400 mg', '186-0899-32', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '350.00', '0.00', '400 mg', 'Sofosbuvir'), 
('3003', 'Nitrosol SR   2.6 mg', '186-0901', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('3004', 'Rosutin   10 mg', '186-0678-61', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '20.00', '0.00', '10 mg', 'Rosuvastatin'), 
('3005', 'Rosutin   5 mg', '186-0677-61', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '5 mg', 'Rosuvastatin'), 
('3006', 'Pericam   5 mg', '186-0364-28', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '1.50', '0.00', '5 mg', 'Olanzapine'), 
('3007', 'Pericam   10 mg', '186-0363-28', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.51', '0.00', '10 mg', 'Olanzapine'), 
('3008', 'Primace.25   1.25 mg', '186-0691-022', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.50', '0.00', '1.25 mg', 'Ramipril'), 
('3009', 'Primace   2.5 mg', '186-0692-022', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '2.5 mg', 'Ramipril'), 
('3010', 'Primace   5 mg', '186-0693-022', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '5 mg', 'Ramipril'), 
('3011', 'Primace   10 mg', '186-0494-022', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '12.00', '0.00', '10 mg', 'Ramipril'), 
('3012', 'Metoprol XL   50 mg', '186-0699-22', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('3013', 'Frenzoy.5   .5 mg', '186-0918-28', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.50', '0.00', '.5 mg', 'Flupenthixol'), 
('3014', 'Frenzoy   1 mg', '186-0919-28', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '5.00', '0.00', '1 mg', 'Flupenthixol'), 
('3015', 'Calcium Lactate   300 mg', '186-0920-62', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.71', '0.00', '300 mg', 'Calcium Lactate'), 
('3016', 'Dakovir-C   60 mg', '186-0927-32', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '300.00', '0.00', '60 mg', 'Daclatasvir'), 
('3017', 'D-Rise0   2000 IU', '186-0930-78', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '2.50', '0.00', '2000 IU', 'Cholecalciferol (Vit. D3)'), 
('3018', 'Fibropress   5 mg', '186-0940-39', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '55.00', '0.00', '5 mg', 'Ulipristal Acetate'), 
('3019', 'Tigel   90 mg', '186-0941-26', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '90 mg', 'Ticagrelor'), 
('3020', 'Vibose.2   200 mcg', '186-0948', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '6.00', '0.00', '200 mcg', 'Voglibose'), 
('3021', 'Vibose.3   300 mcg', '186-0949', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '300 mcg', 'Voglibose'), 
('3022', 'Dinogest   2 mg', '186-09506', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '50.00', '0.00', '2 mg', 'Dienogest'), 
('3023', 'Methocarbamol   750 mg', '186-0955-70', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '750 mg', 'Methocarbamol'), 
('3024', 'Methocarbamol0   500 mg', '186-0945-70', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Methocarbamol'), 
('3025', 'Gastalfet0   1 gm', '186-0956-7', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '6.00', '0.00', '1 gm', 'Sucralfate'), 
('3026', 'Tezolin   200 mg', '186-0964-23', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '500.00', '0.00', '200 mg', 'Tedizolid Phosphate'), 
('3027', 'Avilam   150 mg', '186-0332-32', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Lamivudine'), 
('3028', 'Avifanz   600 mg', '186-0331-32', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '140.00', '0.00', '600 mg', 'Efavirenz'), 
('3029', 'Avifix   250 mg', '186-0330-32', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Nelfinavir'), 
('3030', 'Duvent   10 mg', '186-0889-21', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Rupatadine'), 
('3031', 'Ivera2   12 mg', '186-05145', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '12 mg', 'Ivermectin'), 
('3032', 'Pirata0   800 mg', '186-0696', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '800 mg', 'Piracetam'), 
('3033', 'Pirata0   400 mg', '186-06953', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Piracetam'), 
('3034', 'Roxatin   150 mg', '186-05305', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Roxatidine'), 
('3035', 'Sotalol HCl   80 mg', '186-0865-9', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '80 mg', 'Sotalol Hydrochloride'), 
('3036', 'Saquinavir0   500 mg', '186-0750-61', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Saquinavir'), 
('3037', 'Zedex DT Dispersible Tablet   20 mg', '186-0882-62', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Zinc'), 
('3038', 'Acifix   10 mg', '186-0970-067', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '3.50', '0.00', '10 mg', 'Rabeprazole Sodium'), 
('3039', 'Napa One   1000 mg', '186-0976-006', 'Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '1000 mg', 'Paracetamol'), 
('3040', 'Arixon  IM   1 gm', '186-0222-23', 'IM Injection', 'Beximco Pharmaceuticals Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('3041', 'Arixon  IM   500 mg', '186-0224-23', 'IM Injection', 'Beximco Pharmaceuticals Ltd.', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('3042', 'Arixon  IM  mg   250 mg', '186-0226-23', 'IM Injection', 'Beximco Pharmaceuticals Ltd.', '100.00', '0.00', '250 mg', 'Ceftriaxone'), 
('3043', 'Arixon  IV   500 mg', '186-0223-23', 'IV Injection', 'Beximco Pharmaceuticals Ltd.', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('3044', 'Arixon  IV  mg   250 mg', '186-0225-23', 'IV Injection', 'Beximco Pharmaceuticals Ltd.', '100.00', '0.00', '250 mg', 'Ceftriaxone'), 
('3045', 'Arixon  IV   1 gm', '186-0221-23', 'IV Injection', 'Beximco Pharmaceuticals Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('3046', 'Arixon gm   2 gm', '186-0749-023', 'IV Injection', 'Beximco Pharmaceuticals Ltd.', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('3047', 'Nutrimin   5 %', '186-0679-3', 'IV Infusion', 'Beximco Pharmaceuticals Ltd.', '350.00', '0.00', '5 %', 'Amino Acids (Essential)'), 
('3048', 'Nazolin .05%   .05 %', '186-01652', 'Nasal Drops', 'Beximco Pharmaceuticals Ltd.', '130.00', '0.00', '.05 %', 'Oxymetazoline Hydrochloride'), 
('3049', 'Fosamin 3 gm   3 gm', '186-0968-23', 'Powder For Suspension', 'Beximco Pharmaceuticals Ltd.', '35.00', '0.00', '3 gm', 'Fosfomycin'), 
('3050', 'Cefalexin   100 %', '186-0181-034', 'Raw Materials', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '100 %', 'Cephalexin'), 
('3051', 'Cefradine   100 %', '186-0199-034', 'Raw Materials', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '100 %', 'Cephradine'), 
('3052', 'Celecoxib   100 %', '186-0259-034', 'Raw Materials', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '100 %', 'Celecoxib'), 
('3053', 'Cetrizine Hcl   100 %', '186-0185-034', 'Raw Materials', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '100 %', 'Cetirizine Dihydrochloride'), 
('3054', 'Ciprofloxacin   100 %', '186-0186-034', 'Raw Materials', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '100 %', 'Ciprofloxacin Hydrochloride'), 
('3055', 'Diclofenac Sodium   100 %', '186-0182-034', 'Raw Materials', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '100 %', 'Diclofenac Sodium'), 
('3056', 'Fluconazole   100 %', '186-0184-034', 'Raw Materials', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '100 %', 'Fluconazole'), 
('3057', 'Trimethoprim   100 %', '186-0187-034', 'Raw Materials', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '100 %', 'Trimethoprim'), 
('3058', 'Neosten  VT    200 mg', '186-0175', 'Vaginal Tablet', 'Beximco Pharmaceuticals Ltd.', '20.00', '0.00', '200 mg', 'Clotrimazole'), 
('3059', 'Intramol   .5 %', '186-06042', 'Eye Drops', 'Beximco Pharmaceuticals Ltd.', '70.00', '0.00', '.5 %', 'Timolol Maleate'), 
('3060', 'Tofen   .025 %', '186-06072', 'Eye Drops', 'Beximco Pharmaceuticals Ltd.', '100.00', '0.00', '.025 %', 'Ketotifen'), 
('3061', 'Hyprosol   .3 %', '186-06182', 'Eye Drops', 'Beximco Pharmaceuticals Ltd.', '65.00', '0.00', '.3 %', 'Hypromellose'), 
('3062', 'Rubalon   .1 %', '186-07572', 'Eye Drops', 'Beximco Pharmaceuticals Ltd.', '100.00', '0.00', '.1 %', 'Fluorometholone'), 
('3063', 'Alphin DT   400 mg', '186-0820-008', 'Dispersible Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Albendazole'), 
('3064', 'Mucomist DT   600 mg', '186-0836-31', 'Dispersible Tablet', 'Beximco Pharmaceuticals Ltd.', '15.00', '0.00', '600 mg', 'Acetylcysteine'), 
('3065', 'Deflux MelTab Mouth Dissolving   10 mg', '186-0188', 'Dispersible Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('3066', 'Deflux Meltab   10 mg', '186-09658', 'Dispersible Tablet', 'Beximco Pharmaceuticals Ltd.', '2.50', '0.00', '10 mg', 'Domperidone'), 
('3067', 'Decomit HFA   100 mcg', '186-05564', 'Inhalation Solution', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '100 mcg', 'Beclomethasone Dipropionate'), 
('3068', 'Flomyst25 HFA   125 mcg', '186-08684', 'Aerosol Inhalation', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '125 mcg', 'Fluticasone Propionate'), 
('3069', 'Azmasol Bexicap   200 mcg', '186-07084', 'Inhalation Capsule', 'Beximco Pharmaceuticals Ltd.', '2.50', '0.00', '200 mcg', 'Salbutamol'), 
('3070', 'Tioriva Bexicap   18 mcg', '186-08254', 'Inhalation Capsule', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '18 mcg', 'Tiotropium'), 
('3071', 'Onriva Bexicap   75 mcg', '186-08584', 'Inhalation Capsule', 'Beximco Pharmaceuticals Ltd.', '18.00', '0.00', '75 mcg', 'Indacaterol'), 
('3072', 'Bexitrol Inhalation Aerosol   25 mcg', '186-01594', 'Inhalation Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '25 mcg', 'Salmeterol'), 
('3073', 'Onriva Bexicap   150 mcg', '186-09114', 'Inhalation Capsule', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '150 mcg', 'Indacaterol'), 
('3074', 'Rostil SR   200 mg', '186-08351', 'Sr Capsule', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '200 mg', 'Mebeverine Hydrochloride'), 
('3075', 'Informet LA0   750 mg', '186-0813', 'Xr Tablet', 'Beximco Pharmaceuticals Ltd.', '7.00', '0.00', '750 mg', 'Metformin Hydrochloride'), 
('3076', 'Informet LA0   1 gm', '186-0814', 'Xr Tablet', 'Beximco Pharmaceuticals Ltd.', '8.00', '0.00', '1 gm', 'Metformin Hydrochloride'), 
('3077', 'Napa Extend   665 mg', '186-0646-006', 'Xr Tablet', 'Beximco Pharmaceuticals Ltd.', '1.51', '0.00', '665 mg', 'Paracetamol'), 
('3078', 'Bexitrol HFA   25 mcg', '186-06154', 'Inhalation Aerosol', 'Beximco Pharmaceuticals Ltd.', '210.00', '0.00', '25 mcg', 'Salmeterol'), 
('3079', 'Ultrafen  SR    100 mg', '186-0131-64', 'Sr Tablet', 'Beximco Pharmaceuticals Ltd.', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('3080', 'Neofloxin  XR   1 gm', '186-0562-23', 'Sr Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '1 gm', 'Ciprofloxacin'), 
('3081', 'Proceptin   Next   20 mg', '186-0563', 'Sr Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('3082', 'Zybex SR   150 mg', '186-0389-76', 'Sr Tablet', 'Beximco Pharmaceuticals Ltd.', '10.00', '0.00', '150 mg', 'Bupropion Hydrochloride'), 
('3083', 'Hepagurd   3 gm', '186-0946-03', 'Granules For Suspension', 'Beximco Pharmaceuticals Ltd.', '75.00', '0.00', '3 gm', 'L-Ornithine L-Aspartate'), 
('3084', 'Fosamin 3gm   3 gm', '186-0968-23', 'Granules For Suspension', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '3 gm', 'Fosfomycin'), 
('3085', 'Onsat   4 mg', '186-08458', 'Oral Soluble Film', 'Beximco Pharmaceuticals Ltd.', '12.00', '0.00', '4 mg', 'Ondansetron'), 
('3086', 'Onsat 8   8 mg', '186-08468', 'Oral Soluble Film', 'Beximco Pharmaceuticals Ltd.', '18.00', '0.00', '8 mg', 'Ondansetron'), 
('3087', 'Xidolac Meltab   10 mg', '186-0939-64', 'Mouth Dissolving Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('3088', 'Napa Meltab   160 mg', '186-0895-06', 'Mouth Dissolving Tablet', 'Beximco Pharmaceuticals Ltd.', '0.00', '0.00', '160 mg', 'Paracetamol'), 
('3089', 'Napa Rapid   500 mg', '186-0967-006', 'Rapid Tablet', 'Beximco Pharmaceuticals Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('3090', 'Tycil   250 mg', '345-0001-023', 'Capsule', 'Beximco Pharmaceuticals Ltd., Kaliakoir', '3.62', '0.00', '250 mg', 'Amoxicillin'), 
('3091', 'Tycil   500 mg', '345-0002-23', 'Capsule', 'Beximco Pharmaceuticals Ltd., Kaliakoir', '6.79', '0.00', '500 mg', 'Amoxicillin'), 
('3092', 'Clobex   500 mg', '345-0006-23', 'Capsule', 'Beximco Pharmaceuticals Ltd., Kaliakoir', '5.98', '0.00', '500 mg', 'Cloxacillin'), 
('3093', 'Flubex   250 mg', '345-0008-23', 'Capsule', 'Beximco Pharmaceuticals Ltd., Kaliakoir', '5.50', '0.00', '250 mg', 'Flucloxacillin'), 
('3094', 'Flubex   500 mg', '345-0009-23', 'Capsule', 'Beximco Pharmaceuticals Ltd., Kaliakoir', '10.50', '0.00', '500 mg', 'Flucloxacillin'), 
('3095', 'Triocim0   400 mg', '345-0670-23', 'Capsule', 'Beximco Pharmaceuticals Ltd., Kaliakoir', '0.00', '0.00', '400 mg', 'Cefixime'), 
('3096', 'Simastin   10 mg', '345-0178-61', 'Tablet', 'Beximco Pharmaceuticals Ltd., Kaliakoir', '0.00', '0.00', '10 mg', 'Simvastatin'), 
('3097', 'Turbocef   250 mg', '345-0620-23', 'Tablet', 'Beximco Pharmaceuticals Ltd., Kaliakoir', '0.00', '0.00', '250 mg', 'Cefuroxime'), 
('3098', 'Arixongm   2 gm', '345-0749-23', 'IV Injection', 'Beximco Pharmaceuticals Ltd., Kaliakoir', '0.00', '0.00', '2 gm', 'Ceftriaxone'), 
('3099', 'Napa Extend   665 mg', '345-0646-6', 'Xr Tablet', 'Beximco Pharmaceuticals Ltd., Kaliakoir', '0.00', '0.00', '665 mg', 'Paracetamol'), 
('3100', 'Ampina   250 mg', '139-0029-23', 'Capsule', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Ampicillin'), 
('3101', 'Tetracycline   250 mg', '139-0021-23', 'Capsule', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('3102', 'Jexiline   250 mg', '139-0023-23', 'Capsule', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Oxytetracycline'), 
('3103', 'Fluconazole   50 mg', '139-0032-020', 'Capsule', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Fluconazole'), 
('3104', 'Selclogen   20 mg', '139-0035-067', 'Capsule', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('3105', 'Aspirin0   300 mg', '139-0025-6', 'Tablet', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Aspirin'), 
('3106', 'Jetrazol   200 mg', '139-0026-27', 'Tablet', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Metronidazole'), 
('3107', 'Paradil   500 mg', '139-0024-006', 'Tablet', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('3108', 'Riboflavin   5 mg', '139-0028-79', 'Tablet', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Riboflavin'), 
('3109', 'Cetrigen   10 mg', '139-0030-021', 'Tablet', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('3110', 'Ciprogen0   500 mg', '139-0031-023', 'Tablet', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('3111', 'Biorolac   10 mg', '139-0033-064', 'Tablet', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('3112', 'Solagen   100 mg', '139-0034-008', 'Tablet', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Mebendazole'), 
('3113', 'Paradil Extra   65 mg +00 mg', '139-0036-006', 'Tablet', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '65 mg +00 mg', 'Caffeine + Paracetamol'), 
('3114', 'Biotid   150 mg', '139-0037-055', 'Tablet', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('3115', 'Biofenac   100 mg', '139-0038-064', 'Tablet', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Aceclofenac'), 
('3116', 'Azithrogen0   500 mg', '139-0040-023', 'Tablet', 'Biogen Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('3117', 'Amotid   250 mg', '064-0033-023', 'Capsule', 'Biopharma Ltd.', '3.61', '0.00', '250 mg', 'Amoxicillin'), 
('3118', 'Amotid   500 mg', '064-0104-23', 'Capsule', 'Biopharma Ltd.', '6.02', '0.00', '500 mg', 'Amoxicillin'), 
('3119', 'Bestcef      200 mg', '064-0128-23', 'Capsule', 'Biopharma Ltd.', '35.00', '0.00', '200 mg', 'Cefixime'), 
('3120', 'Fungata      150 mg', '064-0139', 'Capsule', 'Biopharma Ltd.', '22.08', '0.00', '150 mg', 'Fluconazole'), 
('3121', 'Fungata      50 mg', '064-0138', 'Capsule', 'Biopharma Ltd.', '8.03', '0.00', '50 mg', 'Fluconazole'), 
('3122', 'Inpro      20 mg', '064-0125-67', 'Capsule', 'Biopharma Ltd.', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('3123', 'Inpro      40 mg', '064-0120-67', 'Capsule', 'Biopharma Ltd.', '7.03', '0.00', '40 mg', 'Omeprazole'), 
('3124', 'Maczith   250 mg', '064-0149-23', 'Capsule', 'Biopharma Ltd.', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('3125', 'Revistar   250 mg', '064-0131-23', 'Capsule', 'Biopharma Ltd.', '5.52', '0.00', '250 mg', 'Flucloxacillin'), 
('3126', 'Revistar   500 mg', '064-0132-23', 'Capsule', 'Biopharma Ltd.', '10.04', '0.00', '500 mg', 'Flucloxacillin'), 
('3127', 'Sulpralex   500 mg', '064-0105-23', 'Capsule', 'Biopharma Ltd.', '12.05', '0.00', '500 mg', 'Cephalexin'), 
('3128', 'Supracef   500 mg', '064-0108-23', 'Capsule', 'Biopharma Ltd.', '12.55', '0.00', '500 mg', 'Cephradine'), 
('3129', 'Supracef   250 mg', '064-0107-023', 'Capsule', 'Biopharma Ltd.', '6.73', '0.00', '250 mg', 'Cephradine'), 
('3130', 'Supralex   250 mg', '064-0111-23', 'Capsule', 'Biopharma Ltd.', '6.52', '0.00', '250 mg', 'Cephalexin'), 
('3131', 'Volcan  TR    100 mg', '064-0196-64', 'Capsule', 'Biopharma Ltd.', '3.01', '0.00', '100 mg', 'Diclofenac Sodium'), 
('3132', 'Bestcef0   400 mg', '064-0245-23', 'Capsule', 'Biopharma Ltd.', '50.19', '0.00', '400 mg', 'Cefixime'), 
('3133', 'Dolorex   50 mg', '064-0252-65', 'Capsule', 'Biopharma Ltd.', '7.53', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('3134', 'Esocon   20 mg', '064-0264-067', 'Capsule', 'Biopharma Ltd.', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('3135', 'Esocon   40 mg', '064-0265-067', 'Capsule', 'Biopharma Ltd.', '9.00', '0.00', '40 mg', 'Esomeprazole'), 
('3136', 'Top-SR   100 mg', '064-0297-64', 'Capsule', 'Biopharma Ltd.', '7.00', '0.00', '100 mg', 'Ketoprofen'), 
('3137', 'Ambroxol SR   75 mg', '064-0304-31', 'Capsule', 'Biopharma Ltd.', '5.00', '0.00', '75 mg', 'Ambroxol'), 
('3138', 'Bionex0   500 mg', '064-03379', 'Capsule', 'Biopharma Ltd.', '16.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('3139', 'Lasocon   30 mg', '064-0339-67', 'Capsule', 'Biopharma Ltd.', '6.00', '0.00', '30 mg', 'Lansoprazole'), 
('3140', 'Riboclin   150 mg', '064-0360-23', 'Capsule', 'Biopharma Ltd.', '8.00', '0.00', '150 mg', 'Clindamycin'), 
('3141', 'Lirica   75 mg', '064-0363-046', 'Capsule', 'Biopharma Ltd.', '16.00', '0.00', '75 mg', 'Pregabalin'), 
('3142', 'Riboclin   300 mg', '064-0404-23', 'Capsule', 'Biopharma Ltd.', '15.00', '0.00', '300 mg', 'Clindamycin'), 
('3143', 'Eziflo   400 mcg', '064-04129', 'Capsule', 'Biopharma Ltd.', '10.00', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('3144', 'Lirica0   50 mg', '064-0413-046', 'Capsule', 'Biopharma Ltd.', '13.00', '0.00', '50 mg', 'Pregabalin'), 
('3145', 'Lirica   25 mg', '064-0442-046', 'Capsule', 'Biopharma Ltd.', '7.00', '0.00', '25 mg', 'Pregabalin'), 
('3146', 'Water for Injection   1 ml', '064-0225-79', 'Injection', 'Biopharma Ltd.', '0.00', '0.00', '1 ml', 'Water For Injection'), 
('3147', 'Maczith0   500 mg', '064-0350-23', 'Injection', 'Biopharma Ltd.', '250.00', '0.00', '500 mg', 'Azithromycin'), 
('3148', 'Lactu   68 %', '064-0114-60', 'Oral Solution', 'Biopharma Ltd.', '120.00', '0.00', '68 %', 'Lactulose'), 
('3149', 'Lis Vet   500 Lac IU', '064-0465-077', 'Powder', 'Biopharma Ltd.', '0.00', '0.00', '500 Lac IU', 'Colistin Sulphate'), 
('3150', 'Biocin   4 mg', '064-0102-21', 'Tablet', 'Biopharma Ltd.', '0.20', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('3151', 'Biopen VK     250 mg', '064-0134-23', 'Tablet', 'Biopharma Ltd.', '2.28', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('3152', 'Calm   10 mg', '064-01246', 'Tablet', 'Biopharma Ltd.', '2.76', '0.00', '10 mg', 'Clobazam'), 
('3153', 'Cevalin   250 mg', '064-0024-78', 'Tablet', 'Biopharma Ltd.', '1.31', '0.00', '250 mg', 'Vitamin C'), 
('3154', 'Cipcin   250 mg', '064-0121-23', 'Tablet', 'Biopharma Ltd.', '8.53', '0.00', '250 mg', 'Ciprofloxacin'), 
('3155', 'Cipcin   500 mg', '064-0122-23', 'Tablet', 'Biopharma Ltd.', '15.06', '0.00', '500 mg', 'Ciprofloxacin'), 
('3156', 'Cipcin   750 mg', '064-0141-23', 'Tablet', 'Biopharma Ltd.', '18.07', '0.00', '750 mg', 'Ciprofloxacin'), 
('3157', 'Clof   100 mg', '064-0174-64', 'Tablet', 'Biopharma Ltd.', '4.00', '0.00', '100 mg', 'Aceclofenac'), 
('3158', 'Emlon   10 mg', '064-0153-022', 'Tablet', 'Biopharma Ltd.', '7.00', '0.00', '10 mg', 'Amlodipine'), 
('3159', 'Emlon      5 mg', '064-0154-022', 'Tablet', 'Biopharma Ltd.', '5.00', '0.00', '5 mg', 'Amlodipine'), 
('3160', 'Erosa   250 mg', '064-0175-23', 'Tablet', 'Biopharma Ltd.', '4.52', '0.00', '250 mg', 'Erythromycin'), 
('3161', 'Erosa   500 mg', '064-0176-23', 'Tablet', 'Biopharma Ltd.', '8.03', '0.00', '500 mg', 'Erythromycin'), 
('3162', 'Esogut   10 mg', '064-01428', 'Tablet', 'Biopharma Ltd.', '2.50', '0.00', '10 mg', 'Domperidone'), 
('3163', 'Etnol      50 mg', '064-0152-22', 'Tablet', 'Biopharma Ltd.', '0.77', '0.00', '50 mg', 'Atenolol'), 
('3164', 'Etnol      100 mg', '064-0151-22', 'Tablet', 'Biopharma Ltd.', '1.38', '0.00', '100 mg', 'Atenolol'), 
('3165', 'Formet   500 mg', '064-0145', 'Tablet', 'Biopharma Ltd.', '4.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('3166', 'Formet   850 mg', '064-0146', 'Tablet', 'Biopharma Ltd.', '6.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('3167', 'Glucostat   80 mg', '064-0144', 'Tablet', 'Biopharma Ltd.', '7.00', '0.00', '80 mg', 'Gliclazide'), 
('3168', 'Lorfast   10 mg', '064-0126-21', 'Tablet', 'Biopharma Ltd.', '3.01', '0.00', '10 mg', 'Loratadine'), 
('3169', 'Mextil   125 mg', '064-0171-23', 'Tablet', 'Biopharma Ltd.', '15.06', '0.00', '125 mg', 'Cefuroxime'), 
('3170', 'Mextil   250 mg', '064-0172-23', 'Tablet', 'Biopharma Ltd.', '25.09', '0.00', '250 mg', 'Cefuroxime'), 
('3171', 'Orthocal   1250 mg', '064-0155-62', 'Tablet', 'Biopharma Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('3172', 'Salbu   2 mg', '064-00314', 'Tablet', 'Biopharma Ltd.', '0.26', '0.00', '2 mg', 'Salbutamol'), 
('3173', 'Salbu   4 mg', '064-01134', 'Tablet', 'Biopharma Ltd.', '0.34', '0.00', '4 mg', 'Salbutamol'), 
('3174', 'Top      100 mg', '064-0117-64', 'Tablet', 'Biopharma Ltd.', '6.02', '0.00', '100 mg', 'Ketoprofen'), 
('3175', 'Top      50 mg', '064-0116-64', 'Tablet', 'Biopharma Ltd.', '3.51', '0.00', '50 mg', 'Ketoprofen'), 
('3176', 'Volcan      50 mg', '064-0137-64', 'Tablet', 'Biopharma Ltd.', '0.80', '0.00', '50 mg', 'Diclofenac Sodium'), 
('3177', 'Lifcin   250 mg', '064-0179-23', 'Tablet', 'Biopharma Ltd.', '15.06', '0.00', '250 mg', 'Levofloxacin'), 
('3178', 'Lifcin   500 mg', '064-0180-23', 'Tablet', 'Biopharma Ltd.', '15.06', '0.00', '500 mg', 'Levofloxacin'), 
('3179', 'Maczith   500 mg', '064-0178-23', 'Tablet', 'Biopharma Ltd.', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('3180', 'Aceta   500 mg', '064-0021-006', 'Tablet', 'Biopharma Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('3181', 'Acin      150 mg', '064-01185', 'Tablet', 'Biopharma Ltd.', '2.50', '0.00', '150 mg', 'Ranitidine'), 
('3182', 'Acin0   300 mg', '064-01195', 'Tablet', 'Biopharma Ltd.', '3.51', '0.00', '300 mg', 'Ranitidine'), 
('3183', 'Azole   400 mg', '064-0106-008', 'Tablet', 'Biopharma Ltd.', '5.00', '0.00', '400 mg', 'Albendazole'), 
('3184', 'Biozyl   400 mg', '064-0022-27', 'Tablet', 'Biopharma Ltd.', '1.00', '0.00', '400 mg', 'Metronidazole'), 
('3185', 'Lopo      25 mg', '064-0158-022', 'Tablet', 'Biopharma Ltd.', '4.50', '0.00', '25 mg', 'Losartan Potassium'), 
('3186', 'Lopo      50 mg', '064-0159-022', 'Tablet', 'Biopharma Ltd.', '8.00', '0.00', '50 mg', 'Losartan Potassium'), 
('3187', 'Panpro      20 mg', '064-0160-67', 'Tablet', 'Biopharma Ltd.', '5.00', '0.00', '20 mg', 'Pantoprazole'), 
('3188', 'Panpro      40 mg', '064-0161-67', 'Tablet', 'Biopharma Ltd.', '6.00', '0.00', '40 mg', 'Pantoprazole'), 
('3189', 'Biovit E     200 mg', '064-0185-78', 'Tablet', 'Biopharma Ltd.', '5.00', '0.00', '200 mg', 'Vitamin E'), 
('3190', 'Avert   50 mg', '064-01878', 'Tablet', 'Biopharma Ltd.', '2.51', '0.00', '50 mg', 'Meclizine Hydrochloride'), 
('3191', 'Trova   10 mg', '064-0197-061', 'Tablet', 'Biopharma Ltd.', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('3192', 'Trova      20 mg', '064-0198-061', 'Tablet', 'Biopharma Ltd.', '18.00', '0.00', '20 mg', 'Atorvastatin'), 
('3193', 'Perilac   10 mg', '064-0192-064', 'Tablet', 'Biopharma Ltd.', '11.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('3194', 'Zinga      20 mg', '064-0202-62', 'Tablet', 'Biopharma Ltd.', '2.01', '0.00', '20 mg', 'Zinc'), 
('3195', 'Broze   3 mg', '064-02097', 'Tablet', 'Biopharma Ltd.', '5.00', '0.00', '3 mg', 'Bromazepam'), 
('3196', 'Goutex      100 mg', '064-0212-76', 'Tablet', 'Biopharma Ltd.', '4.02', '0.00', '100 mg', 'Allopurinol'), 
('3197', 'Cloma   2 mg', '064-0213-046', 'Tablet', 'Biopharma Ltd.', '6.00', '0.00', '2 mg', 'Clonazepam'), 
('3198', 'Cloma   .5 mg', '064-0214-046', 'Tablet', 'Biopharma Ltd.', '4.00', '0.00', '.5 mg', 'Clonazepam'), 
('3199', 'Lifcin   750 mg', '064-0235-23', 'Tablet', 'Biopharma Ltd.', '20.08', '0.00', '750 mg', 'Levofloxacin'), 
('3200', 'R-Pil.25   1.25 mg', '064-0236-022', 'Tablet', 'Biopharma Ltd.', '3.01', '0.00', '1.25 mg', 'Ramipril'), 
('3201', 'R-Pil.5   2.5 mg', '064-0237-022', 'Tablet', 'Biopharma Ltd.', '5.02', '0.00', '2.5 mg', 'Ramipril'), 
('3202', 'R-Pil      5 mg', '064-0238-022', 'Tablet', 'Biopharma Ltd.', '8.03', '0.00', '5 mg', 'Ramipril'), 
('3203', 'Phenoba   60 mg', '064-0239-046', 'Tablet', 'Biopharma Ltd.', '1.14', '0.00', '60 mg', 'Phenobarbitone'), 
('3204', 'Phenoba   30 mg', '064-0250-046', 'Tablet', 'Biopharma Ltd.', '0.78', '0.00', '30 mg', 'Phenobarbitone'), 
('3205', 'Mextil0   500 mg', '064-0242-23', 'Tablet', 'Biopharma Ltd.', '45.17', '0.00', '500 mg', 'Cefuroxime'), 
('3206', 'Benquil   7.5 mg', '064-0247-057', 'Tablet', 'Biopharma Ltd.', '8.00', '0.00', '7.5 mg', 'Midazolam'), 
('3207', 'Benquil   15 mg', '064-0248-057', 'Tablet', 'Biopharma Ltd.', '15.00', '0.00', '15 mg', 'Midazolam'), 
('3208', 'Cevalin0   500 mg', '064-0254-78', 'Tablet', 'Biopharma Ltd.', '0.00', '0.00', '500 mg', 'Vitamin C'), 
('3209', 'Atinid0   500 mg', '064-0255-27', 'Tablet', 'Biopharma Ltd.', '10.04', '0.00', '500 mg', 'Nitazoxanide'), 
('3210', 'Relvis   50 mg', '064-02571', 'Tablet', 'Biopharma Ltd.', '5.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('3211', 'Tolpa   50 mg', '064-0259-70', 'Tablet', 'Biopharma Ltd.', '4.00', '0.00', '50 mg', 'Tolperisone Hydrochloride'), 
('3212', 'Rinotin   5 mg', '064-0258-21', 'Tablet', 'Biopharma Ltd.', '2.01', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('3213', 'Carved   25 mg', '064-0260-22', 'Tablet', 'Biopharma Ltd.', '8.03', '0.00', '25 mg', 'Carvedilol'), 
('3214', 'Carved2.5   12.5 mg', '064-0261-22', 'Tablet', 'Biopharma Ltd.', '6.50', '0.00', '12.5 mg', 'Carvedilol'), 
('3215', 'Carved   6.25 mg', '064-0262-22', 'Tablet', 'Biopharma Ltd.', '4.50', '0.00', '6.25 mg', 'Carvedilol'), 
('3216', 'Goutex   300 mg', '064-0267-76', 'Tablet', 'Biopharma Ltd.', '8.00', '0.00', '300 mg', 'Allopurinol'), 
('3217', 'Biozyl0   800 mg', '064-0299-27', 'Tablet', 'Biopharma Ltd.', '2.00', '0.00', '800 mg', 'Metronidazole'), 
('3218', 'LOPO   100 mg', '064-0300-022', 'Tablet', 'Biopharma Ltd.', '10.00', '0.00', '100 mg', 'Losartan Potassium'), 
('3219', 'Diazine   50 mg', '064-0301-8', 'Tablet', 'Biopharma Ltd.', '0.75', '0.00', '50 mg', 'Diethylcarbamazine Citrate'), 
('3220', 'Diazine   100 mg', '064-0302-8', 'Tablet', 'Biopharma Ltd.', '1.50', '0.00', '100 mg', 'Diethylcarbamazine Citrate'), 
('3221', 'Ketorif   1 mg', '064-0305-21', 'Tablet', 'Biopharma Ltd.', '1.50', '0.00', '1 mg', 'Ketotifen'), 
('3222', 'Bacifen   10 mg', '064-0307-70', 'Tablet', 'Biopharma Ltd.', '8.00', '0.00', '10 mg', 'Baclofen'), 
('3223', 'Maczith   250 mg', '064-0309-23', 'Tablet', 'Biopharma Ltd.', '25.00', '0.00', '250 mg', 'Azithromycin'), 
('3224', 'Freegest   4 mg', '064-0334-044', 'Tablet', 'Biopharma Ltd.', '6.00', '0.00', '4 mg', 'Montelukast'), 
('3225', 'Preglit   15 mg', '064-0330', 'Tablet', 'Biopharma Ltd.', '8.00', '0.00', '15 mg', 'Pioglitazone'), 
('3226', 'Rabecon   20 mg', '064-0331-67', 'Tablet', 'Biopharma Ltd.', '5.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('3227', 'Freegest   10 mg', '064-0332-044', 'Tablet', 'Biopharma Ltd.', '15.00', '0.00', '10 mg', 'Montelukast'), 
('3228', 'Freegest   5 mg', '064-0333-044', 'Tablet', 'Biopharma Ltd.', '8.00', '0.00', '5 mg', 'Montelukast'), 
('3229', 'Ibuprofen   200 mg', '064-0335-64', 'Tablet', 'Biopharma Ltd.', '0.00', '0.00', '200 mg', 'Ibuprofen'), 
('3230', 'Glucorid   1 mg', '064-0340', 'Tablet', 'Biopharma Ltd.', '3.00', '0.00', '1 mg', 'Glimepiride'), 
('3231', 'Glucorid   2 mg', '064-0341', 'Tablet', 'Biopharma Ltd.', '5.00', '0.00', '2 mg', 'Glimepiride'), 
('3232', 'Lisiril   10 mg', '064-0342-22', 'Tablet', 'Biopharma Ltd.', '0.00', '0.00', '10 mg', 'Lisinopril'), 
('3233', 'Myocar   2.5 mg', '064-0357-22', 'Tablet', 'Biopharma Ltd.', '6.00', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('3234', 'Danston   4 mg', '064-03588', 'Tablet', 'Biopharma Ltd.', '5.00', '0.00', '4 mg', 'Ondansetron'), 
('3235', 'Clamycin0   500 mg', '064-0359-23', 'Tablet', 'Biopharma Ltd.', '40.00', '0.00', '500 mg', 'Clarithromycin'), 
('3236', 'Alerfast   120 mg', '064-0361-21', 'Tablet', 'Biopharma Ltd.', '6.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('3237', 'Gefcin   320 mg', '064-0362-23', 'Tablet', 'Biopharma Ltd.', '65.00', '0.00', '320 mg', 'Gemefloxacin'), 
('3238', 'Immense   25 mg', '064-0364-043', 'Tablet', 'Biopharma Ltd.', '18.00', '0.00', '25 mg', 'Sildenafil'), 
('3239', 'Immense   50 mg', '064-0365-043', 'Tablet', 'Biopharma Ltd.', '25.00', '0.00', '50 mg', 'Sildenafil'), 
('3240', 'Immense   100 mg', '064-0366-043', 'Tablet', 'Biopharma Ltd.', '50.00', '0.00', '100 mg', 'Sildenafil'), 
('3241', 'Penfil   10 mg', '064-0367-043', 'Tablet', 'Biopharma Ltd.', '30.00', '0.00', '10 mg', 'Tadalafil'), 
('3242', 'Penfil   20 mg', '064-0368-043', 'Tablet', 'Biopharma Ltd.', '55.00', '0.00', '20 mg', 'Tadalafil'), 
('3243', 'Edtreat   40 mg', '064-0369-043', 'Tablet', 'Biopharma Ltd.', '0.00', '0.00', '40 mg', 'Tadalafil'), 
('3244', 'UDCA   300 mg', '064-0372', 'Tablet', 'Biopharma Ltd.', '20.00', '0.00', '300 mg', 'Ursodeoxycholic Acid'), 
('3245', 'Eziflo   400 mcg', '064-03769', 'Tablet', 'Biopharma Ltd.', '0.00', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('3246', 'Neuromax   300 mg', '064-0377-046', 'Tablet', 'Biopharma Ltd.', '0.00', '0.00', '300 mg', 'Gabapentin'), 
('3247', 'Myocor   5 mg', '064-0411-22', 'Tablet', 'Biopharma Ltd.', '10.00', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('3248', 'Bestcol   10 mg', '064-0414-61', 'Tablet', 'Biopharma Ltd.', '25.00', '0.00', '10 mg', 'Rosuvastatin'), 
('3249', 'Rufecta   10 mg', '064-0415-21', 'Tablet', 'Biopharma Ltd.', '10.00', '0.00', '10 mg', 'Rupatadine'), 
('3250', 'Biocox   90 mg', '064-0423-64', 'Tablet', 'Biopharma Ltd.', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('3251', 'Trangina MR   35 mg', '064-0444', 'Tablet', 'Biopharma Ltd.', '0.00', '0.00', '35 mg', 'Trimetazidine Dihydrochloride'), 
('3252', 'Bestcol   5 mg', '064-0447-61', 'Tablet', 'Biopharma Ltd.', '8.00', '0.00', '5 mg', 'Rosuvastatin'), 
('3253', 'Bestcol   20 mg', '064-0448-61', 'Tablet', 'Biopharma Ltd.', '0.00', '0.00', '20 mg', 'Rosuvastatin'), 
('3254', 'Dialina   5 mg', '064-0450-015', 'Tablet', 'Biopharma Ltd.', '15.00', '0.00', '5 mg', 'Linagliptin'), 
('3255', 'Diavil0   50 mg', '064-0451', 'Tablet', 'Biopharma Ltd.', '20.00', '0.00', '50 mg', 'Vildagliptin'), 
('3256', 'Olvance   20 mg', '064-0453-22', 'Tablet', 'Biopharma Ltd.', '0.00', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('3257', 'Biocard SR   2.6 mg', '064-0455', 'Tablet', 'Biopharma Ltd.', '0.00', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('3258', 'Orthorate   400 mg', '064-0456-62', 'Tablet', 'Biopharma Ltd.', '8.00', '0.00', '400 mg', 'Calcium Orotate'), 
('3259', 'Doxiflo   200 mg', '064-0460-044', 'Tablet', 'Biopharma Ltd.', '6.00', '0.00', '200 mg', 'Doxophylline'), 
('3260', 'Doxiflo0   400 mg', '064-0461-044', 'Tablet', 'Biopharma Ltd.', '10.00', '0.00', '400 mg', 'Doxophylline'), 
('3261', 'Bioclop   75 mg', '064-0462-026', 'Tablet', 'Biopharma Ltd.', '0.00', '0.00', '75 mg', 'Clopidogrel'), 
('3262', 'Biomycin   500 mg', '064-0290-077', 'Bolus', 'Biopharma Ltd.', '3.00', '0.00', '500 mg', 'Oxytetracycline'), 
('3263', 'Cipcin Vet   1 gm', '064-0291-077', 'Bolus', 'Biopharma Ltd.', '20.00', '0.00', '1 gm', 'Ciprofloxacin'), 
('3264', 'Azole Vet   600 mg', '064-0292-077', 'Bolus', 'Biopharma Ltd.', '7.25', '0.00', '600 mg', 'Albendazole'), 
('3265', 'Aceta Vet   2 gm', '064-0294-077', 'Bolus', 'Biopharma Ltd.', '2.25', '0.00', '2 gm', 'Paracetamol'), 
('3266', 'Winner  IM   1 gm', '064-0215-23', 'IM Injection', 'Biopharma Ltd.', '180.68', '0.00', '1 gm', 'Ceftriaxone'), 
('3267', 'Winner  IM   500 mg', '064-0216-23', 'IM Injection', 'Biopharma Ltd.', '120.45', '0.00', '500 mg', 'Ceftriaxone'), 
('3268', 'Winner  IM  mg   250 mg', '064-0217-23', 'IM Injection', 'Biopharma Ltd.', '90.34', '0.00', '250 mg', 'Ceftriaxone'), 
('3269', 'Winner  IV   1 gm', '064-0218-23', 'IV Injection', 'Biopharma Ltd.', '180.68', '0.00', '1 gm', 'Ceftriaxone'), 
('3270', 'Winner  IV   500 mg', '064-0219-23', 'IV Injection', 'Biopharma Ltd.', '120.45', '0.00', '500 mg', 'Ceftriaxone'), 
('3271', 'Winner  IV  mg   250 mg', '064-0220-23', 'IV Injection', 'Biopharma Ltd.', '90.34', '0.00', '250 mg', 'Ceftriaxone'), 
('3272', 'WinnerG   2 gm', '064-0278-23', 'IV Injection', 'Biopharma Ltd.', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('3273', 'Amilac   5 %', '064-0288-3', 'IV Infusion', 'Biopharma Ltd.', '350.00', '0.00', '5 %', 'Amino Acids (Essential)'), 
('3274', 'Ketorif   .025 %', '064-03122', 'Eye Drops', 'Biopharma Ltd.', '100.00', '0.00', '.025 %', 'Ketotifen'), 
('3275', 'Flurone   .1 %', '064-03162', 'Eye Drops', 'Biopharma Ltd.', '100.00', '0.00', '.1 %', 'Fluorometholone'), 
('3276', 'Tearin.3   .3 %', '064-03202', 'Eye Drops', 'Biopharma Ltd.', '70.00', '0.00', '.3 %', 'Hypromellose'), 
('3277', 'Tearin.5   .5 %', '064-03212', 'Eye Drops', 'Biopharma Ltd.', '80.00', '0.00', '.5 %', 'Hypromellose'), 
('3278', 'Xilol   .5 %', '064-03222', 'Eye Drops', 'Biopharma Ltd.', '75.00', '0.00', '.5 %', 'Timolol Maleate'), 
('3279', 'Dolorex   100 mg', '064-0253-65', 'Sr Capsule', 'Biopharma Ltd.', '13.05', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('3280', 'Formet XR0   500 mg', '064-0356', 'Xr Tablet', 'Biopharma Ltd.', '6.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('3281', 'Formet gm XR   1 gm', '064-0378', 'Xr Tablet', 'Biopharma Ltd.', '7.00', '0.00', '1 gm', 'Metformin Hydrochloride'), 
('3282', 'Formet XR0   750 mg', '064-0390', 'Xr Tablet', 'Biopharma Ltd.', '0.00', '0.00', '750 mg', 'Metformin Hydrochloride'), 
('3283', 'Aceta Extend   665 mg', '064-0408-6', 'Xr Tablet', 'Biopharma Ltd.', '0.00', '0.00', '665 mg', 'Paracetamol'), 
('3284', 'Onstar ODT 8   8 mg', '064-04058', 'Orodispersible Tablet', 'Biopharma Ltd.', '10.00', '0.00', '8 mg', 'Ondansetron'), 
('3285', 'Volcan  SR    100 mg', '064-0136-64', 'Sr Tablet', 'Biopharma Ltd.', '3.01', '0.00', '100 mg', 'Diclofenac Sodium'), 
('3286', 'NAB  TR    100 mg', '057-0036-64', 'Capsule', 'Bios Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('3287', 'OLE      20 mg', '057-0037-67', 'Capsule', 'Bios Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('3288', 'Pantacef   250 mg', '057-0038-023', 'Capsule', 'Bios Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cephradine'), 
('3289', 'Pantacef   500 mg', '057-0039-23', 'Capsule', 'Bios Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('3290', 'Topxim      200 mg', '057-0041-23', 'Capsule', 'Bios Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('3291', 'Topxim   400 mg', '057-0042-23', 'Capsule', 'Bios Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Cefixime'), 
('3292', 'Gravite   1250 mg', '057-0026-62', 'Tablet', 'Bios Pharmaceuticals Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('3293', 'Beticin   10 mg', '057-0027-21', 'Tablet', 'Bios Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('3294', 'Biosnac   100 mg', '057-0028-64', 'Tablet', 'Bios Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Aceclofenac'), 
('3295', 'NAB      50 mg', '057-0029-64', 'Tablet', 'Bios Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('3296', 'Feverol   500 mg', '057-0030-006', 'Tablet', 'Bios Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('3297', 'Dysentrin   400 mg', '057-0031-27', 'Tablet', 'Bios Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('3298', 'Stomadin      150 mg', '057-00325', 'Tablet', 'Bios Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('3299', 'Ciprob   500 mg', '057-0033-23', 'Tablet', 'Bios Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('3300', 'Negovet   100 %', '085-0012-077', 'Powder', 'Bridge Pharmaceuticals Ltd.', '0.00', '0.00', '100 %', 'Trichlorfon'), 
('3301', 'Colinill Powder (Vet)   50 Lac IU', '085-0043-', 'Powder', 'Bridge Pharmaceuticals Ltd.', '0.00', '0.00', '50 Lac IU', 'Colistin Sulphate'), 
('3302', 'Paracetamol   2 gm', '085-0007-077', 'Bolus', 'Bridge Pharmaceuticals Ltd.', '0.00', '0.00', '2 gm', 'Paracetamol'), 
('3303', 'Trodavet   2 gm', '085-0008-077', 'Bolus', 'Bridge Pharmaceuticals Ltd.', '0.00', '0.00', '2 gm', 'Metronidazole'), 
('3304', 'Bre-Zol   600 mg', '085-0011-077', 'Bolus', 'Bridge Pharmaceuticals Ltd.', '0.00', '0.00', '600 mg', 'Albendazole'), 
('3305', 'Livet   1 gm', '085-0024-077', 'Bolus', 'Bridge Pharmaceuticals Ltd.', '0.00', '0.00', '1 gm', 'Oxytetracycline'), 
('3306', 'Proxacin   1 gm', '085-0037-077', 'Bolus', 'Bridge Pharmaceuticals Ltd.', '0.00', '0.00', '1 gm', 'Ciprofloxacin'), 
('3307', 'Bpclox   500 mg', '054-0014-23', 'Capsule', 'Bristol Pharma Ltd.', '0.00', '0.00', '500 mg', 'Cloxacillin'), 
('3308', 'Bpdox      100 mg', '054-0017-23', 'Capsule', 'Bristol Pharma Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('3309', 'Bpmox   250 mg', '054-0011-023', 'Capsule', 'Bristol Pharma Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('3310', 'Bpmox   500 mg', '054-0012-23', 'Capsule', 'Bristol Pharma Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('3311', 'Bptetra   250 mg', '054-0013-23', 'Capsule', 'Bristol Pharma Ltd.', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('3312', 'Dilock  TR    100 mg', '054-0023-64', 'Capsule', 'Bristol Pharma Ltd.', '2.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('3313', 'Flac   250 mg', '054-0015-23', 'Capsule', 'Bristol Pharma Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('3314', 'Flac   500 mg', '054-0016-23', 'Capsule', 'Bristol Pharma Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('3315', 'Sefrate   500 mg', '054-0026-23', 'Capsule', 'Bristol Pharma Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('3316', 'Ciprobac   500 mg', '054-0032-23', 'Capsule', 'Bristol Pharma Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('3317', 'Cefodox      100 mg', '054-0036-23', 'Capsule', 'Bristol Pharma Ltd.', '0.00', '0.00', '100 mg', 'Cefpodoxime'), 
('3318', 'Xifim      200 mg', '054-0030-23', 'Capsule', 'Bristol Pharma Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('3319', 'Loramide   2 mg', '054-00476', 'Capsule', 'Bristol Pharma Ltd.', '0.00', '0.00', '2 mg', 'Loperamide'), 
('3320', 'Indomethacin   25 mg', '054-0051-64', 'Capsule', 'Bristol Pharma Ltd.', '0.50', '0.00', '25 mg', 'Indomethacin'), 
('3321', 'Fluconazole   150 mg', '054-0076', 'Capsule', 'Bristol Pharma Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('3322', 'Fluconazole   50 mg', '054-0075', 'Capsule', 'Bristol Pharma Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('3323', 'Bpcal   1250 mg', '054-0038-62', 'Tablet', 'Bristol Pharma Ltd.', '2.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('3324', 'Ascorin   250 mg', '054-0042-78', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('3325', 'Benda  DS   400 mg', '054-0041-008', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '400 mg', 'Albendazole'), 
('3326', 'Bp Para   500 mg', '054-0040-006', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('3327', 'Bpdon   10 mg', '054-00448', 'Tablet', 'Bristol Pharma Ltd.', '1.00', '0.00', '10 mg', 'Domperidone'), 
('3328', 'Bptrol   10 mg', '054-0045-21', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('3329', 'Dilock      50 mg', '054-0034-64', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('3330', 'Metfil   400 mg', '054-0039-27', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('3331', 'Neosetin R     150 mg', '054-00315', 'Tablet', 'Bristol Pharma Ltd.', '1.50', '0.00', '150 mg', 'Ranitidine'), 
('3332', 'Uniflam   400 mg', '054-0033-64', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '400 mg', 'Ibuprofen'), 
('3333', 'Aminophylline      100 mg', '054-00464', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '100 mg', 'Aminophylline'), 
('3334', 'Griseofulvin FP   500 mg', '054-0048', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '500 mg', 'Griseofulvin'), 
('3335', 'Lopresor   50 mg', '054-0049-22', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('3336', 'Info00   500 mg', '054-0052', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('3337', 'Info-850   850 mg', '054-0053', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('3338', 'Bpxen   250 mg', '054-0054-64', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '250 mg', 'Naproxen'), 
('3339', 'Bpxen   500 mg', '054-0055-64', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '500 mg', 'Naproxen'), 
('3340', 'Acelock   100 mg', '054-0056-64', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '100 mg', 'Aceclofenac'), 
('3341', 'Hyoscine Butyl Bromide   10 mg', '054-00571', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('3342', 'Ancopan      20 mg', '054-00581', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '20 mg', 'Hyoscine Butyl Bromide'), 
('3343', 'Histalab   4 mg', '054-0059-21', 'Tablet', 'Bristol Pharma Ltd.', '0.20', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('3344', 'BP-Z   500 mg', '054-0061-23', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('3345', 'BP Zinc      20 mg', '054-0063-62', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '20 mg', 'Zinc'), 
('3346', 'Levonce   500 mg', '054-0067-23', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('3347', 'Riboflavin   5 mg', '054-0073-79', 'Tablet', 'Bristol Pharma Ltd.', '0.23', '0.00', '5 mg', 'Riboflavin'), 
('3348', 'Folic-Son   5 mg', '054-00725', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '5 mg', 'Folic Acid'), 
('3349', 'Panton-AX   40 mg', '054-0096-67', 'Tablet', 'Bristol Pharma Ltd.', '0.00', '0.00', '40 mg', 'Pantoprazole'), 
('3350', 'Etoricoxib-60   60 mg', '054-0103-064', 'Tablet', 'Bristol Pharma Ltd.', '6.00', '0.00', '60 mg', 'Etoricoxib'), 
('3351', 'Etoricoxib   90 mg', '054-0104-064', 'Tablet', 'Bristol Pharma Ltd.', '11.00', '0.00', '90 mg', 'Etoricoxib'), 
('3352', 'Etoricoxib20   120 mg', '054-0105-064', 'Tablet', 'Bristol Pharma Ltd.', '12.00', '0.00', '120 mg', 'Etoricoxib'), 
('3353', 'Omecent   20 mg', '386-0001-67', 'Capsule', 'Centeon Pharma Limited', '6.00', '0.00', '20 mg', 'Omeprazole'), 
('3354', 'Omecent   40 mg', '386-0002-67', 'Capsule', 'Centeon Pharma Limited', '8.00', '0.00', '40 mg', 'Omeprazole'), 
('3355', 'Esoflux   20 mg', '386-0003-067', 'Capsule', 'Centeon Pharma Limited', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('3356', 'Esoflux   40 mg', '386-0004-067', 'Capsule', 'Centeon Pharma Limited', '10.00', '0.00', '40 mg', 'Esomeprazole'), 
('3357', 'Centomin0   500 mg', '386-0005', 'Tablet', 'Centeon Pharma Limited', '4.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('3358', 'Centomin   850 mg', '386-0006', 'Tablet', 'Centeon Pharma Limited', '6.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('3359', 'Arizith0   500 mg', '386-0007-23', 'Tablet', 'Centeon Pharma Limited', '45.00', '0.00', '500 mg', 'Azithromycin'), 
('3360', 'Ciproton0   500 mg', '386-0008-23', 'Tablet', 'Centeon Pharma Limited', '15.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('3361', 'Domixon   10 mg', '386-00098', 'Tablet', 'Centeon Pharma Limited', '3.50', '0.00', '10 mg', 'Domperidone'), 
('3362', 'Ursoton   300 mg', '386-0010', 'Tablet', 'Centeon Pharma Limited', '30.00', '0.00', '300 mg', 'Ursodeoxycholic Acid'), 
('3363', 'Temnor   500 mg', '386-0012-006', 'Tablet', 'Centeon Pharma Limited', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('3364', 'Nproxol0   500 mg', '386-0013-64', 'Tablet', 'Centeon Pharma Limited', '15.00', '0.00', '500 mg', 'Naproxen'), 
('3365', 'Ketoplex   10 mg', '386-0014-064', 'Tablet', 'Centeon Pharma Limited', '20.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('3366', 'Centokast   10 mg', '386-0015-044', 'Tablet', 'Centeon Pharma Limited', '15.00', '0.00', '10 mg', 'Montelukast'), 
('3367', 'Cemoxin   250 mg', '060-0015-023', 'Capsule', 'Central Pharmaceutical Ltd.', '3.40', '0.00', '250 mg', 'Amoxicillin'), 
('3368', 'Centacillin   250 mg', '060-0014-23', 'Capsule', 'Central Pharmaceutical Ltd.', '0.00', '0.00', '250 mg', 'Ampicillin'), 
('3369', 'Cypor   250 mg', '060-0036-23', 'Capsule', 'Central Pharmaceutical Ltd.', '0.00', '0.00', '250 mg', 'Cephalexin'), 
('3370', 'Cypor   500 mg', '060-0047-23', 'Capsule', 'Central Pharmaceutical Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('3371', 'Doxicen      100 mg', '060-0041-23', 'Capsule', 'Central Pharmaceutical Ltd.', '1.50', '0.00', '100 mg', 'Doxycycline'), 
('3372', 'Penclox   500 mg', '060-0027-23', 'Capsule', 'Central Pharmaceutical Ltd.', '5.80', '0.00', '500 mg', 'Cloxacillin'), 
('3373', 'Cemoxin   500 mg', '060-0061-23', 'Capsule', 'Central Pharmaceutical Ltd.', '6.50', '0.00', '500 mg', 'Amoxicillin'), 
('3374', 'Isoflu   500 mg', '060-0062-23', 'Capsule', 'Central Pharmaceutical Ltd.', '10.00', '0.00', '500 mg', 'Flucloxacillin'), 
('3375', 'Flujale   50 mg', '060-0084', 'Capsule', 'Central Pharmaceutical Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('3376', 'Albazol  DS   400 mg', '060-0043-008', 'Tablet', 'Central Pharmaceutical Ltd.', '3.00', '0.00', '400 mg', 'Albendazole'), 
('3377', 'Antrin   10 mg', '060-0052-21', 'Tablet', 'Central Pharmaceutical Ltd.', '2.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('3378', 'Diclon      50 mg', '060-0050-64', 'Tablet', 'Central Pharmaceutical Ltd.', '0.50', '0.00', '50 mg', 'Diclofenac Sodium'), 
('3379', 'Neoflox   500 mg', '060-0054-23', 'Tablet', 'Central Pharmaceutical Ltd.', '12.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('3380', 'Neopep      150 mg', '060-00485', 'Tablet', 'Central Pharmaceutical Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('3381', 'Neopep0   300 mg', '060-00495', 'Tablet', 'Central Pharmaceutical Ltd.', '0.00', '0.00', '300 mg', 'Ranitidine'), 
('3382', 'Notac      40 mg', '060-00515', 'Tablet', 'Central Pharmaceutical Ltd.', '0.00', '0.00', '40 mg', 'Famotidine'), 
('3383', 'Ventol   4 mg', '060-00464', 'Tablet', 'Central Pharmaceutical Ltd.', '0.00', '0.00', '4 mg', 'Salbutamol'), 
('3384', 'Vita C     250 mg', '060-0030-78', 'Tablet', 'Central Pharmaceutical Ltd.', '1.30', '0.00', '250 mg', 'Vitamin C'), 
('3385', 'Centamol   500 mg', '060-0027-006', 'Tablet', 'Central Pharmaceutical Ltd.', '0.55', '0.00', '500 mg', 'Paracetamol'), 
('3386', 'Cedol   400 mg', '060-0021-27', 'Tablet', 'Central Pharmaceutical Ltd.', '1.00', '0.00', '400 mg', 'Metronidazole'), 
('3387', 'Iben   400 mg', '060-0060-64', 'Tablet', 'Central Pharmaceutical Ltd.', '0.00', '0.00', '400 mg', 'Ibuprofen'), 
('3388', 'Cenet   1250 mg', '060-0058-62', 'Tablet', 'Central Pharmaceutical Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('3389', 'KPR   10 mg', '060-0075-064', 'Tablet', 'Central Pharmaceutical Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('3390', 'Azitor0   500 mg', '060-0067-23', 'Tablet', 'Central Pharmaceutical Ltd.', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('3391', 'GL   80 mg', '060-0081', 'Tablet', 'Central Pharmaceutical Ltd.', '7.00', '0.00', '80 mg', 'Gliclazide'), 
('3392', 'M-Form   850 mg', '060-0082', 'Tablet', 'Central Pharmaceutical Ltd.', '5.50', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('3393', 'PC   20 mg', '060-0089-67', 'Tablet', 'Central Pharmaceutical Ltd.', '4.00', '0.00', '20 mg', 'Pantoprazole'), 
('3394', 'Via-Gram   50 mg', '060-0095-043', 'Tablet', 'Central Pharmaceutical Ltd.', '0.00', '0.00', '50 mg', 'Sildenafil'), 
('3395', 'Via-Gram   100 mg', '060-0096-043', 'Tablet', 'Central Pharmaceutical Ltd.', '0.00', '0.00', '100 mg', 'Sildenafil'), 
('3396', 'Abac   500 mg', '050-0115-23', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('3397', 'Chemosef   250 mg', '050-0074-23', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Cephalexin'), 
('3398', 'Chemoxillin   250 mg', '050-0063-023', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('3399', 'Doxi C     100 mg', '050-0062-23', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('3400', 'Omecap      20 mg', '050-0113-67', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('3401', 'Tetracycline   250 mg', '050-0072-23', 'Capsule', 'Chemist Laboratories Ltd.', '1.40', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('3402', 'Excef      200 mg', '050-0176-23', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('3403', 'Podoxi      100 mg', '050-0192-23', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Cefpodoxime'), 
('3404', 'Azithin   500 mg', '050-0200-23', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('3405', 'Lansozol   30 mg', '050-0227-67', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '30 mg', 'Lansoprazole'), 
('3406', 'C-Fenac TR   100 mg', '050-0253-64', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('3407', 'Omecap   40 mg', '050-0252-67', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '40 mg', 'Omeprazole'), 
('3408', 'Lumidol   50 mg', '050-0291-65', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('3409', 'Cadotril   100 mg', '050-03266', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Racecadrotil'), 
('3410', 'Promox0   500 mg', '050-0343-23', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('3411', 'Fluking   250 mg', '050-0346-23', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('3412', 'Fluking0   500 mg', '050-0347-23', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('3413', 'Excef   400 mg', '050-0348-23', 'Capsule', 'Chemist Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Cefixime'), 
('3414', 'Silvazin%   1 %', '050-0129-23', 'Cream', 'Chemist Laboratories Ltd.', '0.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('3415', 'Water For Injection   5 ml', '050-0006-79', 'Injection', 'Chemist Laboratories Ltd.', '0.00', '0.00', '5 ml', 'Water For Injection'), 
('3416', 'Atrium   25 mg', '050-0233-63', 'Injection', 'Chemist Laboratories Ltd.', '0.00', '0.00', '25 mg', 'Atracurium Besylate'), 
('3417', 'Water for Injection   10 ml', '050-0247-79', 'Injection', 'Chemist Laboratories Ltd.', '0.00', '0.00', '10 ml', 'Water For Injection'), 
('3418', 'Pentothal   500 mg', '050-0263', 'Injection', 'Chemist Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Thiopentone Sodium'), 
('3419', 'Pentothal IV   1 gm', '050-0264', 'Injection', 'Chemist Laboratories Ltd.', '0.00', '0.00', '1 gm', 'Thiopentone Sodium'), 
('3420', 'Dulac Oral Solution   68 %', '050-0213-60', 'Oral Solution', 'Chemist Laboratories Ltd.', '0.00', '0.00', '68 %', 'Lactulose'), 
('3421', 'Amoxycil%   10 %', '050-0133-077', 'Powder', 'Chemist Laboratories Ltd.', '112.81', '0.00', '10 %', 'Amoxicillin'), 
('3422', 'Bioclean   40 gm', '050-0137-077', 'Powder', 'Chemist Laboratories Ltd.', '0.00', '0.00', '40 gm', 'Benzalkonium Chloride'), 
('3423', 'Negotox   100 %', '050-0136-077', 'Powder', 'Chemist Laboratories Ltd.', '0.00', '0.00', '100 %', 'Trichlorfon'), 
('3424', 'Chemycin   20 %', '050-0231-077', 'Powder', 'Chemist Laboratories Ltd.', '0.00', '0.00', '20 %', 'Oxytetracycline'), 
('3425', 'Tiam Vet   45 %', '050-0254-077', 'Powder', 'Chemist Laboratories Ltd.', '0.00', '0.00', '45 %', 'Tiamulin Hydrogen Fumerate'), 
('3426', 'Piperin-WS   100 %', '050-0275-077', 'Powder', 'Chemist Laboratories Ltd.', '0.00', '0.00', '100 %', 'Piperazine'), 
('3427', 'Tylochem   20 %', '050-0162-077', 'Sachet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '20 %', 'Tylosin'), 
('3428', 'Orciflox%   10 gm', '050-0132-077', 'Solution', 'Chemist Laboratories Ltd.', '0.00', '0.00', '10 gm', 'Ciprofloxacin'), 
('3429', 'Aminophylline      100 mg', '050-00564', 'Tablet', 'Chemist Laboratories Ltd.', '0.38', '0.00', '100 mg', 'Aminophylline'), 
('3430', 'Ipin      5 mg', '050-0118-022', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Amlodipine'), 
('3431', 'Avomit   10 mg', '050-01278', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('3432', 'C Fenac      50 mg', '050-0081-64', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('3433', 'Calciton   1250 mg', '050-0149-62', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('3434', 'Cetril   10 mg', '050-0106-21', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('3435', 'Chemagyl      200 mg', '050-0020-27', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Metronidazole'), 
('3436', 'Chemagyl   400 mg', '050-0071-27', 'Tablet', 'Chemist Laboratories Ltd.', '1.10', '0.00', '400 mg', 'Metronidazole'), 
('3437', 'Chemo C     250 mg', '050-0046-78', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('3438', 'Chemofen      200 mg', '050-0059-64', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Ibuprofen'), 
('3439', 'Chemofen   400 mg', '050-0070-64', 'Tablet', 'Chemist Laboratories Ltd.', '1.40', '0.00', '400 mg', 'Ibuprofen'), 
('3440', 'Chemosef   500 mg', '050-0102-23', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('3441', 'Cipro C    500 mg', '050-0096-23', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('3442', 'Dexan   .5 mg', '050-0061-72', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '.5 mg', 'Dexamethasone'), 
('3443', 'Griseofulvin   500 mg', '050-0043', 'Tablet', 'Chemist Laboratories Ltd.', '6.50', '0.00', '500 mg', 'Griseofulvin'), 
('3444', 'Histanol   4 mg', '050-0026-21', 'Tablet', 'Chemist Laboratories Ltd.', '0.20', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('3445', 'Leucodar      50 mg', '050-0119', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Fluconazole'), 
('3446', 'Nematox  DS   400 mg', '050-0109-008', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Albendazole'), 
('3447', 'Para C   500 mg', '050-0022-006', 'Tablet', 'Chemist Laboratories Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('3448', 'Pen C     250 mg', '050-0042-23', 'Tablet', 'Chemist Laboratories Ltd.', '2.20', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('3449', 'Promox   500 mg', '050-0110-23', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('3450', 'Ranix      150 mg', '050-00895', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('3451', 'Relapan   10 mg', '050-00581', 'Tablet', 'Chemist Laboratories Ltd.', '1.80', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('3452', 'Riboflavine   5 mg', '050-0053-79', 'Tablet', 'Chemist Laboratories Ltd.', '0.20', '0.00', '5 mg', 'Riboflavin'), 
('3453', 'Sparcin      200 mg', '050-0120-23', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Sparfloxacin'), 
('3454', 'Vermitox      100 mg', '050-0028-8', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Mebendazole'), 
('3455', 'Kelac   10 mg', '050-0189-064', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('3456', 'Levocetril   5 mg', '050-0194-21', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('3457', 'Urgotin   125 mcg', '050-01819', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '125 mcg', 'Methyl Ergometrine Maleate'), 
('3458', 'Vesertan   8 mg', '050-0195-22', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '8 mg', 'Candesartan Cilexetil'), 
('3459', 'Letab   500 mg', '050-0182-23', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('3460', 'Camin      100 mg', '050-0153-8', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Diethylcarbamazine Citrate'), 
('3461', 'Bambutol   10 mg', '050-01584', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Bambuterol Hydrochloride'), 
('3462', 'Etham   400 mg', '050-0160-30', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Ethambutol'), 
('3463', 'Antivert   50 mg', '050-01638', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Meclizine Hydrochloride'), 
('3464', 'Painex   100 mg', '050-0161-64', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Aceclofenac'), 
('3465', 'Dupha   10 mg', '050-02116', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Dydrogesterone'), 
('3466', 'Prexan      5 mg', '050-0203-72', 'Tablet', 'Chemist Laboratories Ltd.', '1.15', '0.00', '5 mg', 'Prednisolone'), 
('3467', 'Migriz   5 mg', '050-01837', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Rizatriptan'), 
('3468', 'C-Bac   10 mg', '050-0232-70', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Baclofen'), 
('3469', 'Cefurxet   250 mg', '050-0230-23', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Cefuroxime'), 
('3470', 'Nospasm   40 mg', '050-02741', 'Tablet', 'Chemist Laboratories Ltd.', '1.75', '0.00', '40 mg', 'Drotaverine Hydrochloride'), 
('3471', 'Pantochem   40 mg', '050-0285-67', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '40 mg', 'Pantoprazole'), 
('3472', 'Pantochem   20 mg', '050-0286-67', 'Tablet', 'Chemist Laboratories Ltd.', '4.75', '0.00', '20 mg', 'Pantoprazole'), 
('3473', 'Exome   20 mg', '050-0287-067', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('3474', 'Nidagest   5 mg', '050-03019', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '5 mg', 'Allystrenol'), 
('3475', 'Fegra   120 mg', '050-0299-21', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('3476', 'Angitan   50 mg', '050-0319-022', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Losartan Potassium'), 
('3477', 'Menobon   2.5 mg', '050-03276', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '2.5 mg', 'Tibolone'), 
('3478', 'Ticofen   1 mg', '050-0324-21', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '1 mg', 'Ketotifen'), 
('3479', 'Tienum   50 mg', '050-02701', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('3480', 'Easycal   400 mg', '050-0335-62', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Calcium Orotate'), 
('3481', 'Mygan   200 mg', '050-03417', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Tolfenamic Acid'), 
('3482', 'Robust   20 mg', '050-0351-067', 'Tablet', 'Chemist Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('3483', 'Albencid   600 mg', '050-0134-077', 'Bolus', 'Chemist Laboratories Ltd.', '0.00', '0.00', '600 mg', 'Albendazole'), 
('3484', 'Amoxycil   500 mg', '050-0146-077', 'Bolus', 'Chemist Laboratories Ltd.', '6.21', '0.00', '500 mg', 'Amoxicillin'), 
('3485', 'Chemycin   500 mg', '050-0130-077', 'Bolus', 'Chemist Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Oxytetracycline'), 
('3486', 'Chemycin  DS   1 gm', '050-0131-077', 'Bolus', 'Chemist Laboratories Ltd.', '0.00', '0.00', '1 gm', 'Oxytetracycline'), 
('3487', 'Niclosam   1 gm', '050-0171-077', 'Bolus', 'Chemist Laboratories Ltd.', '0.00', '0.00', '1 gm', 'Niclosamide'), 
('3488', 'Para-C   2 gm', '050-0236-077', 'Bolus', 'Chemist Laboratories Ltd.', '0.00', '0.00', '2 gm', 'Paracetamol'), 
('3489', 'Orciflox   Vet   750 mg', '050-0290-077', 'Bolus', 'Chemist Laboratories Ltd.', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('3490', 'Metrodon   2 gm', '050-0295-077', 'Bolus', 'Chemist Laboratories Ltd.', '0.00', '0.00', '2 gm', 'Metronidazole'), 
('3491', 'MP Bolus   100 mg', '050-0306-077', 'Bolus', 'Chemist Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Meloxicam'), 
('3492', 'Fe-Vet   250 mg', '050-0340-077', 'Bolus', 'Chemist Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Fenbendazole'), 
('3493', 'PowercefG IM   1 gm', '050-0242-23', 'IM Injection', 'Chemist Laboratories Ltd.', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('3494', 'Powercef0 IM   500 mg', '050-0240-23', 'IM Injection', 'Chemist Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('3495', 'Powercef IM   250 mg', '050-0244-23', 'IM Injection', 'Chemist Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('3496', 'Powercef G   2 gm', '050-0245-23', 'IV Injection', 'Chemist Laboratories Ltd.', '0.00', '0.00', '2 gm', 'Ceftriaxone'), 
('3497', 'PowercefG IV   1 gm', '050-0243-23', 'IV Injection', 'Chemist Laboratories Ltd.', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('3498', 'Powercef0 IV   500 mg', '050-0241-23', 'IV Injection', 'Chemist Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('3499', 'Nasoclin   .05 %', '050-03342', 'Nasal Drops', 'Chemist Laboratories Ltd.', '0.00', '0.00', '.05 %', 'Oxymetazoline Hydrochloride'), 
('3500', 'Biopep      20 mg', '142-0064-67', 'Capsule', 'Cipla Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('3501', 'Doxyvan      100 mg', '142-0048-23', 'Capsule', 'Cipla Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('3502', 'Keflex   500 mg', '142-0058-23', 'Capsule', 'Cipla Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('3503', 'Moxyvan   500 mg', '142-0057-23', 'Capsule', 'Cipla Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('3504', 'Moxyvan   250 mg', '142-0047-023', 'Capsule', 'Cipla Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('3505', 'Neocef   500 mg', '142-0065-23', 'Capsule', 'Cipla Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('3506', 'Tetracil   250 mg', '142-0030-23', 'Capsule', 'Cipla Ltd.', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('3507', 'Amlopress      5 mg', '142-0052-022', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '5 mg', 'Amlodipine'), 
('3508', 'Ana   500 mg', '142-0025-006', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('3509', 'Antihista   4 mg', '142-0042-21', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('3510', 'Beone      100 mg', '142-0062-78', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('3511', 'Betapress      50 mg', '142-0060-22', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '50 mg', 'Atenolol'), 
('3512', 'Butol   2 mg', '142-00294', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '2 mg', 'Salbutamol'), 
('3513', 'Butol   4 mg', '142-00414', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '4 mg', 'Salbutamol'), 
('3514', 'Calcar   1250 mg', '142-0063-62', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('3515', 'Ciploxin   250 mg', '142-0049-23', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('3516', 'Ciploxin   500 mg', '142-0053-23', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('3517', 'Diapril   80 mg', '142-0059', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '80 mg', 'Gliclazide'), 
('3518', 'Dicazin   50 mg', '142-0039-8', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '50 mg', 'Diethylcarbamazine Citrate'), 
('3519', 'Diclonac      50 mg', '142-0050-64', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('3520', 'Lactate   300 mg', '142-0046-62', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '300 mg', 'Calcium Lactate'), 
('3521', 'Metroz   400 mg', '142-0028-27', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('3522', 'Neotidine      150 mg', '142-00445', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('3523', 'Riboflavine   5 mg', '142-0033-79', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '5 mg', 'Riboflavin'), 
('3524', 'Valaron   15 mg', '142-0043-21', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '15 mg', 'Cinnarizine'), 
('3525', 'Amitryl      25 mg', '142-00514', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '25 mg', 'Amitriptyline Hydrochloride'), 
('3526', 'Amitryl   10 mg', '142-00554', 'Tablet', 'Cipla Ltd.', '0.00', '0.00', '10 mg', 'Amitriptyline Hydrochloride'), 
('3527', 'Opmax   20 mg', '274-0018-67', 'Capsule', 'Concord Pharmaceuticals Ltd.', '5.02', '0.00', '20 mg', 'Omeprazole'), 
('3528', 'Esmax   20 mg', '274-0017-067', 'Capsule', 'Concord Pharmaceuticals Ltd.', '6.02', '0.00', '20 mg', 'Esomeprazole'), 
('3529', 'Esmax   40 mg', '274-0036-067', 'Capsule', 'Concord Pharmaceuticals Ltd.', '8.02', '0.00', '40 mg', 'Esomeprazole'), 
('3530', 'Opmax   40 mg', '274-0037-67', 'Capsule', 'Concord Pharmaceuticals Ltd.', '7.02', '0.00', '40 mg', 'Omeprazole'), 
('3531', 'Flunapen   50 mg', '274-0045', 'Capsule', 'Concord Pharmaceuticals Ltd.', '8.02', '0.00', '50 mg', 'Fluconazole'), 
('3532', 'Flunapen   150 mg', '274-0046', 'Capsule', 'Concord Pharmaceuticals Ltd.', '22.07', '0.00', '150 mg', 'Fluconazole'), 
('3533', 'Microcef   200 mg', '274-0060-23', 'Capsule', 'Concord Pharmaceuticals Ltd.', '30.09', '0.00', '200 mg', 'Cefixime'), 
('3534', 'Microcef0   400 mg', '274-0061-23', 'Capsule', 'Concord Pharmaceuticals Ltd.', '50.15', '0.00', '400 mg', 'Cefixime'), 
('3535', 'Sefcon0   500 mg', '274-0063-23', 'Capsule', 'Concord Pharmaceuticals Ltd.', '12.54', '0.00', '500 mg', 'Cephradine'), 
('3536', 'Doribac   250 mg', '274-0078-23', 'Capsule', 'Concord Pharmaceuticals Ltd.', '6.00', '0.00', '250 mg', 'Flucloxacillin'), 
('3537', 'Doribac0   500 mg', '274-0079-23', 'Capsule', 'Concord Pharmaceuticals Ltd.', '10.50', '0.00', '500 mg', 'Flucloxacillin'), 
('3538', 'Didol TR   100 mg', '274-0082-64', 'Capsule', 'Concord Pharmaceuticals Ltd.', '2.50', '0.00', '100 mg', 'Diclofenac Sodium'), 
('3539', 'Pregacap   75 mg', '274-0117-046', 'Capsule', 'Concord Pharmaceuticals Ltd.', '16.00', '0.00', '75 mg', 'Pregabalin'), 
('3540', 'Pregacap   50 mg', '274-0118-046', 'Capsule', 'Concord Pharmaceuticals Ltd.', '12.00', '0.00', '50 mg', 'Pregabalin'), 
('3541', 'Unirab   20 mg', '274-0122-67', 'Capsule', 'Concord Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('3542', 'Water for Injection   5 ml', '274-0096-79', 'Injection', 'Concord Pharmaceuticals Ltd.', '0.00', '0.00', '5 ml', 'Water For Injection'), 
('3543', 'Water for Injection   10 ml', '274-0097-79', 'Injection', 'Concord Pharmaceuticals Ltd.', '0.00', '0.00', '10 ml', 'Water For Injection'), 
('3544', 'Isolac   68 %', '274-0047-60', 'Oral Solution', 'Concord Pharmaceuticals Ltd.', '120.00', '0.00', '68 %', 'Lactulose'), 
('3545', 'Ribiflavine   5 mg', '274-0001-79', 'Tablet', 'Concord Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Riboflavin'), 
('3546', 'Pramax   40 mg', '274-0030-67', 'Tablet', 'Concord Pharmaceuticals Ltd.', '6.02', '0.00', '40 mg', 'Pantoprazole'), 
('3547', 'Acedol   100 mg', '274-0026-64', 'Tablet', 'Concord Pharmaceuticals Ltd.', '4.01', '0.00', '100 mg', 'Aceclofenac'), 
('3548', 'Dopagut   10 mg', '274-00158', 'Tablet', 'Concord Pharmaceuticals Ltd.', '2.01', '0.00', '10 mg', 'Domperidone'), 
('3549', 'Alatin   10 mg', '274-0029-21', 'Tablet', 'Concord Pharmaceuticals Ltd.', '2.01', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('3550', 'Maxdol   10 mg', '274-0025-064', 'Tablet', 'Concord Pharmaceuticals Ltd.', '10.03', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('3551', 'Didol   50 mg', '274-0021-64', 'Tablet', 'Concord Pharmaceuticals Ltd.', '0.80', '0.00', '50 mg', 'Diclofenac Sodium'), 
('3552', 'Macrobac   500 mg', '274-0019-23', 'Tablet', 'Concord Pharmaceuticals Ltd.', '35.11', '0.00', '500 mg', 'Azithromycin'), 
('3553', 'Radibac0   500 mg', '274-0032-23', 'Tablet', 'Concord Pharmaceuticals Ltd.', '15.05', '0.00', '500 mg', 'Levofloxacin'), 
('3554', 'X Dol   120 mg', '274-0033-64', 'Tablet', 'Concord Pharmaceuticals Ltd.', '14.04', '0.00', '120 mg', 'Etoricoxib'), 
('3555', 'Xdol   60 mg', '274-0034-64', 'Tablet', 'Concord Pharmaceuticals Ltd.', '7.02', '0.00', '60 mg', 'Etoricoxib'), 
('3556', 'Pramax   20 mg', '274-0035-67', 'Tablet', 'Concord Pharmaceuticals Ltd.', '4.01', '0.00', '20 mg', 'Pantoprazole'), 
('3557', 'Fexocon80   180 mg', '274-0038-21', 'Tablet', 'Concord Pharmaceuticals Ltd.', '8.02', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('3558', 'Gliben   80 mg', '274-0042', 'Tablet', 'Concord Pharmaceuticals Ltd.', '7.02', '0.00', '80 mg', 'Gliclazide'), 
('3559', 'Esmax   20 mg', '274-0043-067', 'Tablet', 'Concord Pharmaceuticals Ltd.', '5.02', '0.00', '20 mg', 'Esomeprazole'), 
('3560', 'Q ben DS   400 mg', '274-0044-008', 'Tablet', 'Concord Pharmaceuticals Ltd.', '4.01', '0.00', '400 mg', 'Albendazole'), 
('3561', 'Fexocon   120 mg', '274-0048-21', 'Tablet', 'Concord Pharmaceuticals Ltd.', '6.52', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('3562', 'Napier0   500 mg', '274-0049-64', 'Tablet', 'Concord Pharmaceuticals Ltd.', '7.02', '0.00', '500 mg', 'Naproxen'), 
('3563', 'Acusan   50 mg', '274-0050-022', 'Tablet', 'Concord Pharmaceuticals Ltd.', '8.02', '0.00', '50 mg', 'Losartan Potassium'), 
('3564', 'X dol   90 mg', '274-0055-64', 'Tablet', 'Concord Pharmaceuticals Ltd.', '12.04', '0.00', '90 mg', 'Etoricoxib'), 
('3565', 'Tispa   50 mg', '274-00561', 'Tablet', 'Concord Pharmaceuticals Ltd.', '5.02', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('3566', 'Polimet   850 mg', '274-0057', 'Tablet', 'Concord Pharmaceuticals Ltd.', '5.02', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('3567', 'Picocef0   500 mg', '274-0065-23', 'Tablet', 'Concord Pharmaceuticals Ltd.', '45.14', '0.00', '500 mg', 'Cefuroxime'), 
('3568', 'Optivas   10 mg', '274-0058-061', 'Tablet', 'Concord Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('3569', 'Optivas   20 mg', '274-0059-061', 'Tablet', 'Concord Pharmaceuticals Ltd.', '18.00', '0.00', '20 mg', 'Atorvastatin'), 
('3570', 'Brocast   10 mg', '274-0068-044', 'Tablet', 'Concord Pharmaceuticals Ltd.', '15.00', '0.00', '10 mg', 'Montelukast'), 
('3571', 'Picocef   250 mg', '274-0069-23', 'Tablet', 'Concord Pharmaceuticals Ltd.', '25.08', '0.00', '250 mg', 'Cefuroxime'), 
('3572', 'Acudipin   5 mg', '274-0070-022', 'Tablet', 'Concord Pharmaceuticals Ltd.', '5.00', '0.00', '5 mg', 'Amlodipine'), 
('3573', 'Acumet   50 mg', '274-0073-22', 'Tablet', 'Concord Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('3574', 'Acumet   100 mg', '274-0074-22', 'Tablet', 'Concord Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Metoprolol Tartrate'), 
('3575', 'Acubis   5 mg', '274-0075-22', 'Tablet', 'Concord Pharmaceuticals Ltd.', '10.00', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('3576', 'Acubis   2.5 mg', '274-0076-22', 'Tablet', 'Concord Pharmaceuticals Ltd.', '6.00', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('3577', 'Monocal   1250 mg', '274-0077-62', 'Tablet', 'Concord Pharmaceuticals Ltd.', '4.01', '0.00', '1250 mg', 'Calcium Carbonate'), 
('3578', 'Valosan   80 mg', '274-0083-22', 'Tablet', 'Concord Pharmaceuticals Ltd.', '7.00', '0.00', '80 mg', 'Valsartan'), 
('3579', 'Erectus   10 mg', '274-0084-043', 'Tablet', 'Concord Pharmaceuticals Ltd.', '30.00', '0.00', '10 mg', 'Tadalafil'), 
('3580', 'Erectus   20 mg', '274-0085-043', 'Tablet', 'Concord Pharmaceuticals Ltd.', '55.00', '0.00', '20 mg', 'Tadalafil'), 
('3581', 'Panagra   50 mg', '274-0086-043', 'Tablet', 'Concord Pharmaceuticals Ltd.', '25.00', '0.00', '50 mg', 'Sildenafil'), 
('3582', 'Panagra   100 mg', '274-0087-043', 'Tablet', 'Concord Pharmaceuticals Ltd.', '45.00', '0.00', '100 mg', 'Sildenafil'), 
('3583', 'Recodin   150 mg', '274-00115', 'Tablet', 'Concord Pharmaceuticals Ltd.', '1.50', '0.00', '150 mg', 'Ranitidine'), 
('3584', 'Migracon   200 mg', '274-01007', 'Tablet', 'Concord Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Tolfenamic Acid'), 
('3585', 'Monocal Gold   400 mg', '274-0105-62', 'Tablet', 'Concord Pharmaceuticals Ltd.', '8.00', '0.00', '400 mg', 'Calcium Orotate'), 
('3586', 'Dapazin   5 mg', '274-0106-', 'Tablet', 'Concord Pharmaceuticals Ltd.', '30.00', '0.00', '5 mg', 'Dapagliflozin'), 
('3587', 'Unilor   5 mg', '274-0107-21', 'Tablet', 'Concord Pharmaceuticals Ltd.', '2.50', '0.00', '5 mg', 'Desloratadine'), 
('3588', 'Rosucard   10 mg', '274-0109-61', 'Tablet', 'Concord Pharmaceuticals Ltd.', '15.00', '0.00', '10 mg', 'Rosuvastatin'), 
('3589', 'Polimet0   500 mg', '274-0110', 'Tablet', 'Concord Pharmaceuticals Ltd.', '3.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('3590', 'Pyrex Tablet   500 mg', '274-0112-006', 'Tablet', 'Concord Pharmaceuticals Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('3591', 'Novotril.5   .5 mg', '274-0114-046', 'Tablet', 'Concord Pharmaceuticals Ltd.', '0.00', '0.00', '.5 mg', 'Clonazepam'), 
('3592', 'Novotril   2 mg', '274-0115-046', 'Tablet', 'Concord Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Clonazepam'), 
('3593', 'Peacepil   3 mg', '274-01167', 'Tablet', 'Concord Pharmaceuticals Ltd.', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('3594', 'Vildaglip   50 mg', '274-0119', 'Tablet', 'Concord Pharmaceuticals Ltd.', '12.00', '0.00', '50 mg', 'Vildagliptin'), 
('3595', 'Farin   5 mg', '274-01202', 'Tablet', 'Concord Pharmaceuticals Ltd.', '3.00', '0.00', '5 mg', 'Warfarin Sodium'), 
('3596', 'Dapazin   10 mg', '274-0128', 'Tablet', 'Concord Pharmaceuticals Ltd.', '40.00', '0.00', '10 mg', 'Dapagliflozin'), 
('3597', 'Farin   1 mg', '274-01292', 'Tablet', 'Concord Pharmaceuticals Ltd.', '1.00', '0.00', '1 mg', 'Warfarin Sodium'), 
('3598', 'Farin   2 mg', '274-01302', 'Tablet', 'Concord Pharmaceuticals Ltd.', '2.00', '0.00', '2 mg', 'Warfarin Sodium'), 
('3599', 'Holicef IM   250 mg', '274-0091-23', 'IM Injection', 'Concord Pharmaceuticals Ltd.', '90.00', '0.00', '250 mg', 'Ceftriaxone'), 
('3600', 'Holicef0 IM   500 mg', '274-0092-23', 'IM Injection', 'Concord Pharmaceuticals Ltd.', '125.00', '0.00', '500 mg', 'Ceftriaxone'), 
('3601', 'Holicef gm IM   1 gm', '274-0093-23', 'IM Injection', 'Concord Pharmaceuticals Ltd.', '185.00', '0.00', '1 gm', 'Ceftriaxone'), 
('3602', 'Holicef gm IV   2 gm', '274-0088-23', 'IV Injection', 'Concord Pharmaceuticals Ltd.', '295.00', '0.00', '2 gm', 'Ceftriaxone'), 
('3603', 'Holicefgm IV   1 gm', '274-0089-23', 'IV Injection', 'Concord Pharmaceuticals Ltd.', '185.00', '0.00', '1 gm', 'Ceftriaxone'), 
('3604', 'Holicef0 IV   500 mg', '274-0090-23', 'IV Injection', 'Concord Pharmaceuticals Ltd.', '125.00', '0.00', '500 mg', 'Ceftriaxone'), 
('3605', 'Pyrex XR   665 mg', '274-0111-6', 'Xr Tablet', 'Concord Pharmaceuticals Ltd.', '1.50', '0.00', '665 mg', 'Paracetamol'), 
('3606', 'Acedol SR   200 mg', '274-0081-64', 'Er Tablet', 'Concord Pharmaceuticals Ltd.', '7.00', '0.00', '200 mg', 'Aceclofenac'), 
('3607', 'Clofen  TR    100 mg', '100-0034-64', 'Capsule', 'Cosmic Pharma Ltd.', '3.09', '0.00', '100 mg', 'Diclofenac Sodium'), 
('3608', 'Doxycin      100 mg', '100-0040-23', 'Capsule', 'Cosmic Pharma Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('3609', 'Sectil      20 mg', '100-0050-67', 'Capsule', 'Cosmic Pharma Ltd.', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('3610', 'Suprax      200 mg', '100-0065-23', 'Capsule', 'Cosmic Pharma Ltd.', '30.00', '0.00', '200 mg', 'Cefixime'), 
('3611', 'Surgeflox   250 mg', '100-0061-23', 'Capsule', 'Cosmic Pharma Ltd.', '6.18', '0.00', '250 mg', 'Flucloxacillin'), 
('3612', 'Surgeflox00   500 mg', '100-0051-23', 'Capsule', 'Cosmic Pharma Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('3613', 'Brodacef  DS   500 mg', '100-0037-23', 'Capsule', 'Cosmic Pharma Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('3614', 'Brodamox  DS   500 mg', '100-0042-23', 'Capsule', 'Cosmic Pharma Ltd.', '6.75', '0.00', '500 mg', 'Amoxicillin'), 
('3615', 'Brodamox   250 mg', '100-0019-023', 'Capsule', 'Cosmic Pharma Ltd.', '3.60', '0.00', '250 mg', 'Amoxicillin'), 
('3616', 'Zenaf   250 mg', '100-0074-023', 'Capsule', 'Cosmic Pharma Ltd.', '6.70', '0.00', '250 mg', 'Cephradine'), 
('3617', 'Zenaf   500 mg', '100-0043-23', 'Capsule', 'Cosmic Pharma Ltd.', '13.38', '0.00', '500 mg', 'Cephradine'), 
('3618', 'Azitel   500 mg', '100-0075-23', 'Capsule', 'Cosmic Pharma Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('3619', 'Fungard      50 mg', '100-0079', 'Capsule', 'Cosmic Pharma Ltd.', '8.23', '0.00', '50 mg', 'Fluconazole'), 
('3620', 'Xpotil   200 mg', '100-0089-23', 'Capsule', 'Cosmic Pharma Ltd.', '41.00', '0.00', '200 mg', 'Cefpodoxime'), 
('3621', 'Suprax-DS   400 mg', '100-0099-23', 'Capsule', 'Cosmic Pharma Ltd.', '50.00', '0.00', '400 mg', 'Cefixime'), 
('3622', 'Sectil   40 mg', '100-0103-67', 'Capsule', 'Cosmic Pharma Ltd.', '7.00', '0.00', '40 mg', 'Omeprazole'), 
('3623', 'Fungard   150 mg', '100-0114', 'Capsule', 'Cosmic Pharma Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('3624', 'Versal   20 mg', '100-0119-067', 'Capsule', 'Cosmic Pharma Ltd.', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('3625', 'Flamzin%   1 %', '100-0054-23', 'Cream', 'Cosmic Pharma Ltd.', '26.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('3626', 'Gatilac   68 %', '100-0095-60', 'Oral Solution', 'Cosmic Pharma Ltd.', '98.00', '0.00', '68 %', 'Lactulose'), 
('3627', 'Amezol   400 mg', '100-0024-27', 'Tablet', 'Cosmic Pharma Ltd.', '1.25', '0.00', '400 mg', 'Metronidazole'), 
('3628', 'Carvidol   12.5 mg', '100-0056-22', 'Tablet', 'Cosmic Pharma Ltd.', '5.15', '0.00', '12.5 mg', 'Carvedilol'), 
('3629', 'Ciprolyn   500 mg', '100-0030-23', 'Tablet', 'Cosmic Pharma Ltd.', '12.30', '0.00', '500 mg', 'Ciprofloxacin'), 
('3630', 'Clofen      50 mg', '100-0017-64', 'Tablet', 'Cosmic Pharma Ltd.', '0.77', '0.00', '50 mg', 'Diclofenac Sodium'), 
('3631', 'Colaz   400 mg', '100-0027-008', 'Tablet', 'Cosmic Pharma Ltd.', '5.00', '0.00', '400 mg', 'Albendazole'), 
('3632', 'Cozar      25 mg', '100-0059-022', 'Tablet', 'Cosmic Pharma Ltd.', '3.69', '0.00', '25 mg', 'Losartan Potassium'), 
('3633', 'Emedon   10 mg', '100-00458', 'Tablet', 'Cosmic Pharma Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('3634', 'Hypoten      5 mg', '100-0058-022', 'Tablet', 'Cosmic Pharma Ltd.', '3.60', '0.00', '5 mg', 'Amlodipine'), 
('3635', 'Ifen   400 mg', '100-0032-64', 'Tablet', 'Cosmic Pharma Ltd.', '1.41', '0.00', '400 mg', 'Ibuprofen'), 
('3636', 'Levocos   500 mg', '100-0068-23', 'Tablet', 'Cosmic Pharma Ltd.', '14.40', '0.00', '500 mg', 'Levofloxacin'), 
('3637', 'Mefalgin   250 mg', '100-0026-64', 'Tablet', 'Cosmic Pharma Ltd.', '1.80', '0.00', '250 mg', 'Mefenamic Acid'), 
('3638', 'Nova   500 mg', '100-0012-006', 'Tablet', 'Cosmic Pharma Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('3639', 'Peptidin      150 mg', '100-00185', 'Tablet', 'Cosmic Pharma Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('3640', 'Roxipar      200 mg', '100-0057-23', 'Tablet', 'Cosmic Pharma Ltd.', '0.00', '0.00', '200 mg', 'Sparfloxacin'), 
('3641', 'Suplecal   1250 mg', '100-0053-62', 'Tablet', 'Cosmic Pharma Ltd.', '3.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('3642', 'Cetzin   10 mg', '100-0041-21', 'Tablet', 'Cosmic Pharma Ltd.', '2.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('3643', 'Diabid   80 mg', '100-0049', 'Tablet', 'Cosmic Pharma Ltd.', '5.71', '0.00', '80 mg', 'Gliclazide'), 
('3644', 'Spa      20 mg', '100-00461', 'Tablet', 'Cosmic Pharma Ltd.', '0.00', '0.00', '20 mg', 'Hyoscine Butyl Bromide'), 
('3645', 'Ciprolyn   250 mg', '100-0022-23', 'Tablet', 'Cosmic Pharma Ltd.', '6.18', '0.00', '250 mg', 'Ciprofloxacin'), 
('3646', 'Clozam   10 mg', '100-00476', 'Tablet', 'Cosmic Pharma Ltd.', '0.00', '0.00', '10 mg', 'Clobazam'), 
('3647', 'Lipistor   10 mg', '100-0072-061', 'Tablet', 'Cosmic Pharma Ltd.', '0.00', '0.00', '10 mg', 'Atorvastatin'), 
('3648', 'Diglinide   1 mg', '100-0073-015', 'Tablet', 'Cosmic Pharma Ltd.', '0.00', '0.00', '1 mg', 'Repaglinide'), 
('3649', 'Mefalgin0   500 mg', '100-0086-64', 'Tablet', 'Cosmic Pharma Ltd.', '2.57', '0.00', '500 mg', 'Mefenamic Acid'), 
('3650', 'Aldomet   250 mg', '100-0093-22', 'Tablet', 'Cosmic Pharma Ltd.', '0.00', '0.00', '250 mg', 'Methyldopa'), 
('3651', 'Timopa   50 mg', '100-00971', 'Tablet', 'Cosmic Pharma Ltd.', '5.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('3652', 'Lixidol   10 mg', '100-0098-064', 'Tablet', 'Cosmic Pharma Ltd.', '3.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('3653', 'Glucil   850 mg', '100-0100', 'Tablet', 'Cosmic Pharma Ltd.', '0.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('3654', 'Meetil   5 mg', '100-01048', 'Tablet', 'Cosmic Pharma Ltd.', '0.00', '0.00', '5 mg', 'Prochlorperazine Maleate'), 
('3655', 'Azitel00   500 mg', '100-0102-23', 'Tablet', 'Cosmic Pharma Ltd.', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('3656', 'Rabium   20 mg', '100-0106-67', 'Tablet', 'Cosmic Pharma Ltd.', '5.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('3657', 'Etorgin   90 mg', '100-0108-64', 'Tablet', 'Cosmic Pharma Ltd.', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('3658', 'Etagin   120 mg', '100-0107-64', 'Tablet', 'Cosmic Pharma Ltd.', '14.00', '0.00', '120 mg', 'Etoricoxib'), 
('3659', 'Odofex80   180 mg', '100-0110-21', 'Tablet', 'Cosmic Pharma Ltd.', '9.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('3660', 'Rhinexe   5 mg', '100-0112-21', 'Tablet', 'Cosmic Pharma Ltd.', '3.00', '0.00', '5 mg', 'Desloratadine'), 
('3661', 'Breasy   5 mg', '100-0117-044', 'Tablet', 'Cosmic Pharma Ltd.', '8.00', '0.00', '5 mg', 'Montelukast'), 
('3662', 'Odofex   120 mg', '100-0116-21', 'Tablet', 'Cosmic Pharma Ltd.', '7.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('3663', 'Breasy   10 mg', '100-0118-044', 'Tablet', 'Cosmic Pharma Ltd.', '15.00', '0.00', '10 mg', 'Montelukast'), 
('3664', 'Dolonac   100 mg', '100-0078-064', 'Tablet', 'Cosmic Pharma Ltd.', '0.00', '0.00', '100 mg', 'Aceclofenac'), 
('3665', 'Versal   20 mg', '100-0105-067', 'Tablet', 'Cosmic Pharma Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('3666', 'Amoxic   250 mg', '275-0010-023', 'Capsule', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('3667', 'Cosfenac  SR    100 mg', '275-0024-64', 'Capsule', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('3668', 'Coxclox   500 mg', '275-0009-23', 'Capsule', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Cloxacillin'), 
('3669', 'Flucil   250 mg', '275-0008-23', 'Capsule', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('3670', 'Flucil   500 mg', '275-0036-23', 'Capsule', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('3671', 'Opra      20 mg', '275-0007-67', 'Capsule', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('3672', 'Lopide   2 mg', '275-00296', 'Capsule', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '2 mg', 'Loperamide'), 
('3673', 'Cosdox      100 mg', '275-0026-23', 'Capsule', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('3674', 'Amoxic   500 mg', '275-0020-23', 'Capsule', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('3675', 'Cosben   400 mg', '275-0014-008', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Albendazole'), 
('3676', 'Cpcal   1250 mg', '275-0017-62', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('3677', 'Cpdom   10 mg', '275-00188', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('3678', 'Cpflox   500 mg', '275-0011-23', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('3679', 'Cpmycin   250 mg', '275-0019-23', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Erythromycin'), 
('3680', 'Cpvit E     200 mg', '275-0022-78', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '200 mg', 'Vitamin E'), 
('3681', 'Resdil   4 mg', '275-00164', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '4 mg', 'Salbutamol'), 
('3682', 'Sucranil   80 mg', '275-0021', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '80 mg', 'Gliclazide'), 
('3683', 'Cetra   10 mg', '275-0005-21', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('3684', 'Cosflu      50 mg', '275-0033', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '50 mg', 'Fluconazole'), 
('3685', 'Cpfen   400 mg', '275-0006-64', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Ibuprofen'), 
('3686', 'Metrizol   400 mg', '275-0001-27', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('3687', 'Cpmol   500 mg', '275-0003-006', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('3688', 'Rani      150 mg', '275-00045', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('3689', 'Analgen   100 mg', '275-0034-64', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '100 mg', 'Aceclofenac'), 
('3690', 'Cosnap   250 mg', '275-0028-64', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Naproxen'), 
('3691', '20 20 mg', '275-0025-67', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '20 mg', 'Pantoprazole'), 
('3692', 'Coslev   500 mg', '275-0041-23', 'Tablet', 'Cosmo Pharma Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('3693', 'Cemox   250 mg', '073-0028-023', 'Capsule', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('3694', 'Cloxadin   500 mg', '073-0026-23', 'Capsule', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cloxacillin'), 
('3695', 'Luoxa   250 mg', '073-0031-23', 'Capsule', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('3696', 'Luoxa   500 mg', '073-0032-23', 'Capsule', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('3697', 'Cemox   500 mg', '073-0033-23', 'Capsule', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('3698', 'Albin  DS   400 mg', '073-0017-008', 'Tablet', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Albendazole'), 
('3699', 'Butamide   10 mg', '073-00241', 'Tablet', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('3700', 'Calcon   1250 mg', '073-0023-62', 'Tablet', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('3701', 'Ciporate   500 mg', '073-0027-23', 'Tablet', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('3702', 'Crystacin   4 mg', '073-0015-21', 'Tablet', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('3703', 'Crystamol   500 mg', '073-0013-006', 'Tablet', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('3704', 'Crystazol   400 mg', '073-0014-27', 'Tablet', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('3705', 'Ibupro   400 mg', '073-0030-64', 'Tablet', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Ibuprofen'), 
('3706', 'Levotal   250 mg', '073-0041-23', 'Tablet', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Levofloxacin'), 
('3707', 'Levotal   500 mg', '073-0042-23', 'Tablet', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('3708', 'Amlodol   5 mg', '073-0043-022', 'Tablet', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Amlodipine'), 
('3709', 'Azitol   500 mg', '073-0044-23', 'Tablet', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('3710', 'Metcin   500 mg', '073-0045', 'Tablet', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('3711', 'Gizid   80 mg', '073-0046', 'Tablet', 'Crystal Pharmaceuticals Ltd.', '0.00', '0.00', '80 mg', 'Gliclazide'), 
('3712', 'Flunex   500 mg', '077-0015-23', 'Capsule', 'Decent Pharma Laboratories Ltd.', '10.00', '0.00', '500 mg', 'Flucloxacillin'), 
('3713', 'Moxa   500 mg', '077-0012-23', 'Capsule', 'Decent Pharma Laboratories Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('3714', 'Moxa   250 mg', '077-0013-023', 'Capsule', 'Decent Pharma Laboratories Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('3715', 'Rad   500 mg', '077-0017-23', 'Capsule', 'Decent Pharma Laboratories Ltd.', '12.75', '0.00', '500 mg', 'Cephradine'), 
('3716', 'Defim 3      200 mg', '077-0018-23', 'Capsule', 'Decent Pharma Laboratories Ltd.', '28.00', '0.00', '200 mg', 'Cefixime'), 
('3717', 'Oxetin   20 mg', '077-00214', 'Capsule', 'Decent Pharma Laboratories Ltd.', '2.88', '0.00', '20 mg', 'Fluoxetine'), 
('3718', 'Au      20 mg', '077-0016-67', 'Capsule', 'Decent Pharma Laboratories Ltd.', '4.00', '0.00', '20 mg', 'Omeprazole'), 
('3719', 'D Cetamol   500 mg', '077-0022-006', 'Tablet', 'Decent Pharma Laboratories Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('3720', 'Demacro   500 mg', '077-0004-23', 'Tablet', 'Decent Pharma Laboratories Ltd.', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('3721', 'Peptonil      150 mg', '077-00065', 'Tablet', 'Decent Pharma Laboratories Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('3722', 'Qnol   500 mg', '077-0005-23', 'Tablet', 'Decent Pharma Laboratories Ltd.', '11.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('3723', 'Dcf      50 mg', '077-0028-64', 'Tablet', 'Decent Pharma Laboratories Ltd.', '0.60', '0.00', '50 mg', 'Diclofenac Sodium'), 
('3724', 'Ibf   400 mg', '077-0030-64', 'Tablet', 'Decent Pharma Laboratories Ltd.', '1.25', '0.00', '400 mg', 'Ibuprofen'), 
('3725', 'Decagyl   400 mg', '077-0033-27', 'Tablet', 'Decent Pharma Laboratories Ltd.', '1.00', '0.00', '400 mg', 'Metronidazole'), 
('3726', 'D-Fo   850 mg', '077-0037', 'Tablet', 'Decent Pharma Laboratories Ltd.', '2.50', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('3727', 'Flustat   10 mg', '077-0031-21', 'Tablet', 'Decent Pharma Laboratories Ltd.', '2.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('3728', 'Dedom   10 mg', '077-00338', 'Tablet', 'Decent Pharma Laboratories Ltd.', '1.90', '0.00', '10 mg', 'Domperidone'), 
('3729', 'Kilpan   10 mg', '077-0009-064', 'Tablet', 'Decent Pharma Laboratories Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('3730', 'AUP   40 mg', '077-0044-67', 'Tablet', 'Decent Pharma Laboratories Ltd.', '5.00', '0.00', '40 mg', 'Pantoprazole'), 
('3731', 'AUP   20 mg', '077-0043-67', 'Tablet', 'Decent Pharma Laboratories Ltd.', '3.00', '0.00', '20 mg', 'Pantoprazole'), 
('3732', 'Flovo   500 mg', '077-0042-23', 'Tablet', 'Decent Pharma Laboratories Ltd.', '15.00', '0.00', '500 mg', 'Levofloxacin'), 
('3733', 'Alarm   400 mg', '077-0041-008', 'Tablet', 'Decent Pharma Laboratories Ltd.', '4.00', '0.00', '400 mg', 'Albendazole'), 
('3734', 'ACF   100 mg', '077-0040-64', 'Tablet', 'Decent Pharma Laboratories Ltd.', '3.00', '0.00', '100 mg', 'Aceclofenac'), 
('3735', 'Aspel SR Cap.   500 mg', '302-0112-78', 'Capsule', 'Delta Chemicals Ltd.', '0.00', '0.00', '500 mg', 'Vitamin C'), 
('3736', 'Nitax0   500 mg', '302-015-27', 'Tablet', 'Delta Chemicals Ltd.', '0.00', '0.00', '500 mg', 'Nitazoxanide'), 
('3737', 'Paracetamol   100 %', '302-0001-034', 'Raw Materials', 'Delta Chemicals Ltd.', '0.00', '0.00', '100 %', 'Paracetamol'), 
('3738', 'Inhibita      20 mg', '048-0050-67', 'Capsule', 'Delta Pharma Limited', '4.00', '0.00', '20 mg', 'Omeprazole'), 
('3739', 'Nasida  SR   100 mg', '048-0058-64', 'Capsule', 'Delta Pharma Limited', '1.50', '0.00', '100 mg', 'Diclofenac Sodium'), 
('3740', 'Imax   40 mg', '048-0122-067', 'Capsule', 'Delta Pharma Limited', '7.00', '0.00', '40 mg', 'Esomeprazole'), 
('3741', 'Imax   20 mg', '20-0121-067', 'Capsule', 'Delta Pharma Limited', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('3742', 'Cusef   250 mg', '048-0082-023', 'Capsule', 'Delta Pharma Limited', '6.50', '0.00', '250 mg', 'Cephradine'), 
('3743', 'Cusef   500 mg', '048-0083-23', 'Capsule', 'Delta Pharma Limited', '12.50', '0.00', '500 mg', 'Cephradine'), 
('3744', 'Imadol      50 mg', '048-0093-65', 'Capsule', 'Delta Pharma Limited', '7.50', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('3745', 'Ofex      200 mg', '048-0086-23', 'Capsule', 'Delta Pharma Limited', '25.00', '0.00', '200 mg', 'Cefixime'), 
('3746', 'Fiase SR   500 mg', '048-0112-78', 'Capsule', 'Delta Pharma Limited', '0.00', '0.00', '500 mg', 'Vitamin C'), 
('3747', 'Inhibita      40 mg', '048-0111-67', 'Capsule', 'Delta Pharma Limited', '7.00', '0.00', '40 mg', 'Omeprazole'), 
('3748', 'Ofex   400 mg', '048-0157-23', 'Capsule', 'Delta Pharma Limited', '40.00', '0.00', '400 mg', 'Cefixime'), 
('3749', 'Toraxim      100 mg', '048-0155-23', 'Capsule', 'Delta Pharma Limited', '0.00', '0.00', '100 mg', 'Cefpodoxime'), 
('3750', 'Toraxim      200 mg', '048-0156-23', 'Capsule', 'Delta Pharma Limited', '0.00', '0.00', '200 mg', 'Cefpodoxime'), 
('3751', 'Dana      100 mg', '048-01749', 'Capsule', 'Delta Pharma Limited', '0.00', '0.00', '100 mg', 'Danazol'), 
('3752', 'Dana      200 mg', '048-01759', 'Capsule', 'Delta Pharma Limited', '0.00', '0.00', '200 mg', 'Danazol'), 
('3753', 'Tamsin   400 mcg', '048-01689', 'Capsule', 'Delta Pharma Limited', '10.00', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('3754', 'Farlan   50 mg', '048-0202', 'Capsule', 'Delta Pharma Limited', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('3755', 'Farlan   150 mg', '048-0203', 'Capsule', 'Delta Pharma Limited', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('3756', 'Pregadel   75 mg', '048-0206-046', 'Capsule', 'Delta Pharma Limited', '15.00', '0.00', '75 mg', 'Pregabalin'), 
('3757', 'Pregadel   150 mg', '048-0207-046', 'Capsule', 'Delta Pharma Limited', '0.00', '0.00', '150 mg', 'Pregabalin'), 
('3758', 'Pregadel   50 mg', '048-0217-046', 'Capsule', 'Delta Pharma Limited', '10.00', '0.00', '50 mg', 'Pregabalin'), 
('3759', 'D-Cephal   500 mg', '048-0240-23', 'Capsule', 'Delta Pharma Limited', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('3760', 'Lansogut   30 mg', '048-0245-67', 'Capsule', 'Delta Pharma Limited', '6.00', '0.00', '30 mg', 'Lansoprazole'), 
('3761', 'Delaflu   75 mg', '048-0249-32', 'Capsule', 'Delta Pharma Limited', '0.00', '0.00', '75 mg', 'Oseltamivir'), 
('3762', 'Cefdel   500 mg', '048-0258-23', 'Capsule', 'Delta Pharma Limited', '0.00', '0.00', '500 mg', 'Cefaclor'), 
('3763', 'Rmax   20 mg', '048-0277-67', 'Capsule', 'Delta Pharma Limited', '4.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('3764', 'Lansogut   15 mg', '048-0282-67', 'Capsule', 'Delta Pharma Limited', '0.00', '0.00', '15 mg', 'Lansoprazole'), 
('3765', 'Doxydel   100 mg', '048-0283-23', 'Capsule', 'Delta Pharma Limited', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('3766', 'Water for Injection   5 ml', '048-0193-79', 'Injection', 'Delta Pharma Limited', '0.00', '0.00', '5 ml', 'Water For Injection'), 
('3767', 'Xylose   68 %', '048-0065-60', 'Oral Solution', 'Delta Pharma Limited', '120.00', '0.00', '68 %', 'Lactulose'), 
('3768', 'Azo   500 mg', '048-0041-23', 'Tablet', 'Delta Pharma Limited', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('3769', 'Daiza      5 mg', '048-0045-057', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '5 mg', 'Diazepam'), 
('3770', 'Danidazol   400 mg', '048-0051-27', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('3771', 'Tinadin      150 mg', '048-00555', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('3772', 'Degut   10 mg', '048-00468', 'Tablet', 'Delta Pharma Limited', '2.00', '0.00', '10 mg', 'Domperidone'), 
('3773', 'DFX   500 mg', '048-0043-23', 'Tablet', 'Delta Pharma Limited', '10.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('3774', 'Depyrin   500 mg', '048-0032-006', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('3775', 'Nasida      50 mg', '048-0057-64', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('3776', 'Vomitil   5 mg', '048-00548', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '5 mg', 'Prochlorperazine Maleate'), 
('3777', 'Lecetrin   5 mg', '048-0069-21', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('3778', 'Seton   8 mg', '048-00688', 'Tablet', 'Delta Pharma Limited', '8.00', '0.00', '8 mg', 'Ondansetron'), 
('3779', 'Seton   4 mg', '048-00678', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '4 mg', 'Ondansetron'), 
('3780', 'Akinetic   5 mg', '048-0060-025', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '5 mg', 'Procyclidine Hydrochloride'), 
('3781', 'Boni   1250 mg', '048-0061-62', 'Tablet', 'Delta Pharma Limited', '3.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('3782', 'Dirusid      40 mg', '048-00622', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '40 mg', 'Frusemide'), 
('3783', 'Methotrax.5   2.5 mg', '048-0066', 'Tablet', 'Delta Pharma Limited', '5.00', '0.00', '2.5 mg', 'Methotrexate'), 
('3784', 'Eto   60 mg', '048-0123-64', 'Tablet', 'Delta Pharma Limited', '7.00', '0.00', '60 mg', 'Etoricoxib'), 
('3785', 'Olcin   750 mg', '048-0117-23', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '750 mg', 'Levofloxacin'), 
('3786', 'Inopil   2 mg', '048-0115-22', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '2 mg', 'Perindopril Erbumine'), 
('3787', 'Tino   50 mg', '048-01141', 'Tablet', 'Delta Pharma Limited', '4.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('3788', 'Scabo   6 mg', '048-0132-8', 'Tablet', 'Delta Pharma Limited', '5.00', '0.00', '6 mg', 'Ivermectin'), 
('3789', 'Lenit   330 mg', '048-0133', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '330 mg', 'Levocarnitine'), 
('3790', 'Amo      5 mg', '048-0070-022', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '5 mg', 'Amlodipine'), 
('3791', 'Amo   10 mg', '048-0071-022', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '10 mg', 'Amlodipine'), 
('3792', 'Bpnol      100 mg', '048-0091-22', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '100 mg', 'Atenolol'), 
('3793', 'Bpnol      50 mg', '048-0090-22', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '50 mg', 'Atenolol'), 
('3794', 'Brolin Retard50   350 mg', '048-00734', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '350 mg', 'Aminophylline'), 
('3795', 'Carvida   12.5 mg', '048-0075-22', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '12.5 mg', 'Carvedilol'), 
('3796', 'Carvida      25 mg', '048-0076-22', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '25 mg', 'Carvedilol'), 
('3797', 'Carvida   6.25 mg', '048-0178-22', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '6.25 mg', 'Carvedilol'), 
('3798', 'Erona   500 mg', '048-0081-23', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('3799', 'Evarin   135 mg', '048-00641', 'Tablet', 'Delta Pharma Limited', '6.00', '0.00', '135 mg', 'Mebeverine Hydrochloride'), 
('3800', 'Hyosin   10 mg', '048-00491', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('3801', 'Inopil   4 mg', '048-0077-22', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '4 mg', 'Perindopril Erbumine'), 
('3802', 'Ketotif   1 mg', '048-0079-21', 'Tablet', 'Delta Pharma Limited', '1.50', '0.00', '1 mg', 'Ketotifen'), 
('3803', 'Obid   500 mg', '048-0095', 'Tablet', 'Delta Pharma Limited', '3.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('3804', 'Obid   850 mg', '048-0096', 'Tablet', 'Delta Pharma Limited', '5.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('3805', 'Olcin   500 mg', '048-0089-23', 'Tablet', 'Delta Pharma Limited', '15.00', '0.00', '500 mg', 'Levofloxacin'), 
('3806', 'Scabo   3 mg', '048-0088-8', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '3 mg', 'Ivermectin'), 
('3807', 'Tizem   30 mg', '048-0097-22', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '30 mg', 'Diltiazem Hydrochloride'), 
('3808', 'Tizem   60 mg', '048-0098-22', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '60 mg', 'Diltiazem Hydrochloride'), 
('3809', 'Xido   80 mg', '048-0099', 'Tablet', 'Delta Pharma Limited', '7.00', '0.00', '80 mg', 'Gliclazide'), 
('3810', 'Brolin      100 mg', '048-00724', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '100 mg', 'Aminophylline'), 
('3811', 'Znkid   Dispersible   20 mg', '048-0100-62', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '20 mg', 'Zinc'), 
('3812', 'Aire   1 mg', '048-01604', 'Tablet', 'Delta Pharma Limited', '0.90', '0.00', '1 mg', 'Levosalbutamol'), 
('3813', 'Aire   2 mg', '048-01614', 'Tablet', 'Delta Pharma Limited', '1.70', '0.00', '2 mg', 'Levosalbutamol'), 
('3814', 'DFX   500 mg', '048-0106-23', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('3815', 'DFX   750 mg', '048-0118-23', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('3816', 'Perinin   .5 mg', '048-0145-78', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '.5 mg', 'Mecobalamin'), 
('3817', 'ATV   10 mg', '048-0183-061', 'Tablet', 'Delta Pharma Limited', '4.21', '0.00', '10 mg', 'Atorvastatin'), 
('3818', 'Canta   625 mg', '048-0158-62', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '625 mg', 'Calcium Carbonate'), 
('3819', 'CTZ   10 mg', '048-0038-21', 'Tablet', 'Delta Pharma Limited', '1.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('3820', 'Eto   90 mg', '048-0130-64', 'Tablet', 'Delta Pharma Limited', '10.00', '0.00', '90 mg', 'Etoricoxib'), 
('3821', 'Eto20   120 mg', '048-0131-64', 'Tablet', 'Delta Pharma Limited', '12.00', '0.00', '120 mg', 'Etoricoxib'), 
('3822', 'Flarin      5 mg', '048-01667', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '5 mg', 'Flunarizine'), 
('3823', 'Flarin   10 mg', '048-01677', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '10 mg', 'Flunarizine'), 
('3824', 'Lonapam   .5 mg', '048-0177-046', 'Tablet', 'Delta Pharma Limited', '3.00', '0.00', '.5 mg', 'Clonazepam'), 
('3825', 'Lonapam   2 mg', '048-0176-046', 'Tablet', 'Delta Pharma Limited', '5.00', '0.00', '2 mg', 'Clonazepam'), 
('3826', 'Pheno   15 mg', '048-0163-046', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '15 mg', 'Phenobarbitone'), 
('3827', 'Pheno   30 mg', '048-0164-046', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '30 mg', 'Phenobarbitone'), 
('3828', 'Pheno   60 mg', '048-0165-046', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '60 mg', 'Phenobarbitone'), 
('3829', 'Sarinex   5 mg', '048-0136-21', 'Tablet', 'Delta Pharma Limited', '2.50', '0.00', '5 mg', 'Desloratadine'), 
('3830', 'Staxim   250 mg', '048-0171-23', 'Tablet', 'Delta Pharma Limited', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('3831', 'Staxim   500 mg', '048-0172-23', 'Tablet', 'Delta Pharma Limited', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('3832', 'Stela   1 mg', '048-0134-28', 'Tablet', 'Delta Pharma Limited', '1.50', '0.00', '1 mg', 'Trifluoperazine'), 
('3833', 'Stela      5 mg', '048-0136-28', 'Tablet', 'Delta Pharma Limited', '2.50', '0.00', '5 mg', 'Trifluoperazine'), 
('3834', 'Carvida.125   3.125 mg', '048-0074-22', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '3.125 mg', 'Carvedilol'), 
('3835', 'Edac  EX    600 mg', '048-0179-64', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '600 mg', 'Etodolac'), 
('3836', 'Methotrax   10 mg', '048-0059', 'Tablet', 'Delta Pharma Limited', '15.00', '0.00', '10 mg', 'Methotrexate'), 
('3837', 'Tumic   200 mg', '048-01807', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '200 mg', 'Tolfenamic Acid'), 
('3838', 'ATV   20 mg', '048-0199-061', 'Tablet', 'Delta Pharma Limited', '10.00', '0.00', '20 mg', 'Atorvastatin'), 
('3839', 'Ket   10 mg', '048-0200-064', 'Tablet', 'Delta Pharma Limited', '5.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('3840', 'Anin   50 mg', '048-0196-022', 'Tablet', 'Delta Pharma Limited', '5.00', '0.00', '50 mg', 'Losartan Potassium'), 
('3841', 'Freten   3 mg', '048-02047', 'Tablet', 'Delta Pharma Limited', '3.00', '0.00', '3 mg', 'Bromazepam'), 
('3842', 'Liosal   10 mg', '048-0201-70', 'Tablet', 'Delta Pharma Limited', '8.00', '0.00', '10 mg', 'Baclofen'), 
('3843', 'Ebatrol   10 mg', '048-0205-21', 'Tablet', 'Delta Pharma Limited', '5.00', '0.00', '10 mg', 'Ebastine'), 
('3844', 'Demovo   500 mg', '048-0208-64', 'Tablet', 'Delta Pharma Limited', '10.00', '0.00', '500 mg', 'Naproxen'), 
('3845', 'Imax   20 mg', '048-0209-067', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('3846', 'RTV   5 mg', '048-0210-61', 'Tablet', 'Delta Pharma Limited', '6.00', '0.00', '5 mg', 'Rosuvastatin'), 
('3847', 'RTV   10 mg', '048-0211-61', 'Tablet', 'Delta Pharma Limited', '12.00', '0.00', '10 mg', 'Rosuvastatin'), 
('3848', 'ATV   40 mg', '048-0212-061', 'Tablet', 'Delta Pharma Limited', '15.00', '0.00', '40 mg', 'Atorvastatin'), 
('3849', 'PGL   5 mg', '048-0214-26', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '5 mg', 'Prasugrel'), 
('3850', 'PGL   10 mg', '048-0215-26', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '10 mg', 'Prasugrel'), 
('3851', 'Salazo   500 mg', '048-0216-64', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '500 mg', 'Sulfasalazine'), 
('3852', 'Montela   10 mg', '048-0218-044', 'Tablet', 'Delta Pharma Limited', '8.42', '0.00', '10 mg', 'Montelukast'), 
('3853', 'Delcor   2.5 mg', '048-0220-22', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('3854', 'Delcor   5 mg', '048-0221-22', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('3855', 'Riapred   20 mg', '048-0228-67', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('3856', 'Toliken   25 mg', '048-0229-28', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '25 mg', 'Quetiapine'), 
('3857', 'Tolken   100 mg', '048-0230-28', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '100 mg', 'Quetiapine'), 
('3858', 'Niagra   25 mg', '048-0231-043', 'Tablet', 'Delta Pharma Limited', '10.00', '0.00', '25 mg', 'Sildenafil'), 
('3859', 'Niagra   50 mg', '048-0232-043', 'Tablet', 'Delta Pharma Limited', '15.00', '0.00', '50 mg', 'Sildenafil'), 
('3860', 'Niagra   100 mg', '048-0233-043', 'Tablet', 'Delta Pharma Limited', '20.00', '0.00', '100 mg', 'Sildenafil'), 
('3861', 'Feel   5 mg', '048-0234-043', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '5 mg', 'Tadalafil'), 
('3862', 'Feel   10 mg', '048-0235-043', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '10 mg', 'Tadalafil'), 
('3863', 'Feel   20 mg', '048-0236-043', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '20 mg', 'Tadalafil'), 
('3864', 'D-Aciclovir   400 mg', '048-0237-32', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '400 mg', 'Acyclovir'), 
('3865', 'Delbendazole   400 mg', '048-0238-008', 'Tablet', 'Delta Pharma Limited', '5.00', '0.00', '400 mg', 'Albendazole'), 
('3866', 'Delamycin   500 mg', '048-0241-23', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '500 mg', 'Clarithromycin'), 
('3867', 'Delclog   75 mg', '048-0242-26', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '75 mg', 'Clopidogrel'), 
('3868', 'Delfex   120 mg', '048-0244-21', 'Tablet', 'Delta Pharma Limited', '5.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('3869', 'Tinadin   300 mg', '048-02465', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '300 mg', 'Ranitidine'), 
('3870', 'Dermafin   250 mg', '048-0247', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '250 mg', 'Terbinafine'), 
('3871', 'Valadel   500 mg', '048-0248-32', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '500 mg', 'Valacyclovir'), 
('3872', 'Konadel   200 mg', '048-0249', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '200 mg', 'Ketoconazole'), 
('3873', 'Delfavir   600 mg', '048-0251-32', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '600 mg', 'Efavirenz'), 
('3874', 'Linadel   600 mg', '048-0254-023', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '600 mg', 'Linezolid'), 
('3875', 'Nelidel   250 mg', '048-0257-32', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '250 mg', 'Nelfinavir'), 
('3876', 'Meera SR   50 mg', '048-0256-31', 'Tablet', 'Delta Pharma Limited', '10.00', '0.00', '50 mg', 'Butamirate Citrate'), 
('3877', 'Nebinor   2.5 mg', '048-0263-22', 'Tablet', 'Delta Pharma Limited', '7.00', '0.00', '2.5 mg', 'Nebivolol'), 
('3878', 'Nebinor   5 mg', '048-0264-22', 'Tablet', 'Delta Pharma Limited', '12.00', '0.00', '5 mg', 'Nebivolol'), 
('3879', 'Plezer   30 mg', '048-0265-014', 'Tablet', 'Delta Pharma Limited', '20.00', '0.00', '30 mg', 'Dapoxetine'), 
('3880', 'Plezer   60 mg', '048-0266-014', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '60 mg', 'Dapoxetine'), 
('3881', 'Linatin   5 mg', '048-0267-015', 'Tablet', 'Delta Pharma Limited', '15.00', '0.00', '5 mg', 'Linagliptin'), 
('3882', 'Sitalia   50 mg', '048-0268', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '50 mg', 'Sitagliptin'), 
('3883', 'Sitalia   100 mg', '048-0269', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '100 mg', 'Sitagliptin'), 
('3884', 'Febulas   40 mg', '048-0270-76', 'Tablet', 'Delta Pharma Limited', '8.00', '0.00', '40 mg', 'Febuxostat'), 
('3885', 'Febulas   80 mg', '048-0271-76', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '80 mg', 'Febuxostat'), 
('3886', 'Xtrafen   100 mg', '048-0272-64', 'Tablet', 'Delta Pharma Limited', '2.00', '0.00', '100 mg', 'Aceclofenac'), 
('3887', 'Deltolin   2 mg', '048-02734', 'Tablet', 'Delta Pharma Limited', '0.26', '0.00', '2 mg', 'Salbutamol'), 
('3888', 'Deltolin   4 mg', '048-02744', 'Tablet', 'Delta Pharma Limited', '0.46', '0.00', '4 mg', 'Salbutamol'), 
('3889', 'Anin   100 mg', '048-0279-022', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '100 mg', 'Losartan Potassium'), 
('3890', 'Deflex   60 mg', '048-0280-21', 'Tablet', 'Delta Pharma Limited', '5.00', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('3891', 'Delfex80   180 mg', '048-0281-21', 'Tablet', 'Delta Pharma Limited', '9.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('3892', 'Olmenor   20 mg', '048-0286-22', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('3893', 'Olmenor   40 mg', '048-0287-22', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '40 mg', 'Olmesartan Medoxomil'), 
('3894', 'Misodel   100 mcg', '048-02909', 'Tablet', 'Delta Pharma Limited', '8.00', '0.00', '100 mcg', 'Misoprostol'), 
('3895', 'Misodel   200 mcg', '048-02919', 'Tablet', 'Delta Pharma Limited', '15.00', '0.00', '200 mcg', 'Misoprostol'), 
('3896', 'Naprodel   250 mg', '048-0292-64', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '250 mg', 'Naproxen'), 
('3897', 'Pelican   20 mg', '048-0293-67', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '20 mg', 'Pantoprazole'), 
('3898', 'Doxobid   400 mg', '048-02944', 'Tablet', 'Delta Pharma Limited', '6.00', '0.00', '400 mg', 'Doxophylline'), 
('3899', 'Pelican   40 mg', '048-0295-67', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '40 mg', 'Pantoprazole'), 
('3900', 'Bomi L   300 mg', '048-0297-62', 'Tablet', 'Delta Pharma Limited', '0.70', '0.00', '300 mg', 'Calcium Lactate'), 
('3901', 'Reumaflex   200 mg', '048-0298-24', 'Tablet', 'Delta Pharma Limited', '10.00', '0.00', '200 mg', 'Hydroxychloroquine Sulphate'), 
('3902', 'Tofacit   5 mg', '048-03038', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '5 mg', 'Tofacitinib'), 
('3903', 'Boni Gold   400 mg', '048-0306-62', 'Tablet', 'Delta Pharma Limited', '8.00', '0.00', '400 mg', 'Calcium Orotate'), 
('3904', 'Navafil   50 mg', '048-03093', 'Tablet', 'Delta Pharma Limited', '50.00', '0.00', '50 mg', 'Avanafil'), 
('3905', 'Navafil   100 mg', '048-03103', 'Tablet', 'Delta Pharma Limited', '60.00', '0.00', '100 mg', 'Avanafil'), 
('3906', 'Nitax0   500 mg', '048-0152-27', 'Tablet', 'Delta Pharma Limited', '8.00', '0.00', '500 mg', 'Nitazoxanide'), 
('3907', 'Doxobid   200 mg', '048-0312-044', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '200 mg', 'Doxophylline'), 
('3908', 'Empazin   10 mg', '048-0313-015', 'Tablet', 'Delta Pharma Limited', '15.00', '0.00', '10 mg', 'Empagliflozin'), 
('3909', 'Empazin   25 mg', '048-0314-015', 'Tablet', 'Delta Pharma Limited', '0.00', '0.00', '25 mg', 'Empagliflozin'), 
('3910', 'Xone-3  IM  mg   250 mg', '048-0184-23', 'IM Injection', 'Delta Pharma Limited', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('3911', 'Xone-3  IM   500 mg', '048-0185-23', 'IM Injection', 'Delta Pharma Limited', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('3912', 'Xone-3  IV   500 mg', '048-0186-23', 'IV Injection', 'Delta Pharma Limited', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('3913', 'Xone-3  IV   1 gm', '048-0187-23', 'IV Injection', 'Delta Pharma Limited', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('3914', 'Xone 3 IV   2 gm', '048-0261-23', 'IV Injection', 'Delta Pharma Limited', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('3915', 'Xone-3   IV/IM   250 mg', '048-0188-23', 'IV/IM Injection', 'Delta Pharma Limited', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('3916', 'Delben   400 mg', '048-0260-008', 'Dispersible Tablet', 'Delta Pharma Limited', '6.00', '0.00', '400 mg', 'Albendazole'), 
('3917', 'Imadol      100 mg', '048-0094-65', 'Sr Capsule', 'Delta Pharma Limited', '0.00', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('3918', 'Aspel   250 mg', '048-011-78', 'Sr Capsule', 'Delta Pharma Limited', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('3919', 'Montela Chewable   4 mg', '048-0225-044', 'Chewable Tablet', 'Delta Pharma Limited', '4.00', '0.00', '4 mg', 'Montelukast'), 
('3920', 'Montela Chewable   5 mg', '048-0226-044', 'Chewable Tablet', 'Delta Pharma Limited', '6.00', '0.00', '5 mg', 'Montelukast'), 
('3921', 'Pyrenol XR   665 mg', '048-0315-006', 'Xr Tablet', 'Delta Pharma Limited', '0.00', '0.00', '665 mg', 'Paracetamol'), 
('3922', 'Xtrafen SR   200 mg', '048-0285-64', 'Er Tablet', 'Delta Pharma Limited', '0.00', '0.00', '200 mg', 'Aceclofenac'), 
('3923', 'Demox   250 mg', '268-0012-023', 'Capsule', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('3924', 'Demox   500 mg', '268-0034-23', 'Capsule', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('3925', 'Doxacin      100 mg', '268-0027-23', 'Capsule', 'Desh Pharmaceuticals Ltd.', '1.55', '0.00', '100 mg', 'Doxycycline'), 
('3926', 'Flucloxi   250 mg', '268-0047-23', 'Capsule', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('3927', 'Lazo   30 mg', '268-0067-67', 'Capsule', 'Desh Pharmaceuticals Ltd.', '5.00', '0.00', '30 mg', 'Lansoprazole'), 
('3928', 'Multicef   250 mg', '268-0056-023', 'Capsule', 'Desh Pharmaceuticals Ltd.', '8.00', '0.00', '250 mg', 'Cephradine'), 
('3929', 'Multicef   500 mg', '268-0055-23', 'Capsule', 'Desh Pharmaceuticals Ltd.', '15.00', '0.00', '500 mg', 'Cephradine'), 
('3930', 'Omnimycin   500 mg', '268-0023-23', 'Capsule', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Tetracycline Hydrochloride'), 
('3931', 'Oramycin   250 mg', '268-0024-23', 'Capsule', 'Desh Pharmaceuticals Ltd.', '1.20', '0.00', '250 mg', 'Oxytetracycline'), 
('3932', 'Randamycin   250 mg', '268-0015-23', 'Capsule', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('3933', 'Flumart      50 mg', '268-0080', 'Capsule', 'Desh Pharmaceuticals Ltd.', '5.00', '0.00', '50 mg', 'Fluconazole'), 
('3934', 'Flumart      150 mg', '268-0081', 'Capsule', 'Desh Pharmaceuticals Ltd.', '10.00', '0.00', '150 mg', 'Fluconazole'), 
('3935', 'Lardon  TR    100 mg', '268-0035-64', 'Capsule', 'Desh Pharmaceuticals Ltd.', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('3936', 'Flucloxi   500 mg', '268-0039-23', 'Capsule', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('3937', 'Roceptin      20 mg', '268-0042-67', 'Capsule', 'Desh Pharmaceuticals Ltd.', '4.00', '0.00', '20 mg', 'Omeprazole'), 
('3938', 'D-Fix      200 mg', '268-0070-23', 'Capsule', 'Desh Pharmaceuticals Ltd.', '30.00', '0.00', '200 mg', 'Cefixime'), 
('3939', 'D-Fix0   400 mg', '268-0123-023', 'Capsule', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Cefixime'), 
('3940', 'Devolac   68 %', '268-0092-60', 'Oral Solution', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '68 %', 'Lactulose'), 
('3941', 'Aldes   400 mg', '268-0059-008', 'Tablet', 'Desh Pharmaceuticals Ltd.', '4.00', '0.00', '400 mg', 'Albendazole'), 
('3942', 'Butalpen   10 mg', '268-00631', 'Tablet', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('3943', 'D Metro   400 mg', '268-0001-27', 'Tablet', 'Desh Pharmaceuticals Ltd.', '1.24', '0.00', '400 mg', 'Metronidazole'), 
('3944', 'Decal   300 mg', '268-0013-62', 'Tablet', 'Desh Pharmaceuticals Ltd.', '0.29', '0.00', '300 mg', 'Calcium Lactate'), 
('3945', 'Deflam   400 mg', '268-0031-64', 'Tablet', 'Desh Pharmaceuticals Ltd.', '1.00', '0.00', '400 mg', 'Ibuprofen'), 
('3946', 'Deflox   500 mg', '268-0025-23', 'Tablet', 'Desh Pharmaceuticals Ltd.', '12.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('3947', 'Denac      50 mg', '268-0019-64', 'Tablet', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('3948', 'Denamine   4 mg', '268-0002-21', 'Tablet', 'Desh Pharmaceuticals Ltd.', '0.12', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('3949', 'Deotrex   40 mg', '268-0007-8', 'Tablet', 'Desh Pharmaceuticals Ltd.', '0.80', '0.00', '40 mg', 'Levamisole'), 
('3950', 'Depol   500 mg', '268-0004-006', 'Tablet', 'Desh Pharmaceuticals Ltd.', '0.60', '0.00', '500 mg', 'Paracetamol'), 
('3951', 'Detac      150 mg', '268-00185', 'Tablet', 'Desh Pharmaceuticals Ltd.', '1.00', '0.00', '150 mg', 'Ranitidine'), 
('3952', 'Loratec   10 mg', '268-0068-21', 'Tablet', 'Desh Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Loratadine'), 
('3953', 'Oravet   500 mg', '268-0028-23', 'Tablet', 'Desh Pharmaceuticals Ltd.', '3.00', '0.00', '500 mg', 'Oxytetracycline'), 
('3954', 'Ventolex   4 mg', '268-00724', 'Tablet', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Salbutamol'), 
('3955', 'Zytec   10 mg', '268-0030-21', 'Tablet', 'Desh Pharmaceuticals Ltd.', '1.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('3956', 'E Rox   500 mg', '268-0084-23', 'Tablet', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('3957', 'Azilit   500 mg', '268-0082-23', 'Tablet', 'Desh Pharmaceuticals Ltd.', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('3958', 'Ostoplus   1250 mg', '268-0037-62', 'Tablet', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('3959', 'Omid   10 mg', '268-00438', 'Tablet', 'Desh Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('3960', 'Deltacort      5 mg', '268-0060-72', 'Tablet', 'Desh Pharmaceuticals Ltd.', '0.62', '0.00', '5 mg', 'Prednisolone'), 
('3961', 'Xe Fast   100 mg', '268-0078-64', 'Tablet', 'Desh Pharmaceuticals Ltd.', '3.00', '0.00', '100 mg', 'Aceclofenac'), 
('3962', 'Clarocin   500 mg', '268-0049-23', 'Tablet', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Clarithromycin'), 
('3963', 'Levocin   500 mg', '268-0050-23', 'Tablet', 'Desh Pharmaceuticals Ltd.', '13.00', '0.00', '500 mg', 'Levofloxacin'), 
('3964', 'Ora   250 mg', '268-0051-23', 'Tablet', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('3965', 'Sparfloxin      200 mg', '268-0053-23', 'Tablet', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Sparfloxacin'), 
('3966', 'Deflox   750 mg', '268-0069-23', 'Tablet', 'Desh Pharmaceuticals Ltd.', '15.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('3967', 'Naptodin   500 mg', '268-0091-64', 'Tablet', 'Desh Pharmaceuticals Ltd.', '9.00', '0.00', '500 mg', 'Naproxen'), 
('3968', 'Detolac   10 mg', '268-0096-064', 'Tablet', 'Desh Pharmaceuticals Ltd.', '8.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('3969', 'Detonix   20 mg', '268-0097-67', 'Tablet', 'Desh Pharmaceuticals Ltd.', '4.00', '0.00', '20 mg', 'Pantoprazole'), 
('3970', 'D-Lina   5 mg', '268-0109-015', 'Tablet', 'Desh Pharmaceuticals Ltd.', '16.00', '0.00', '5 mg', 'Linagliptin'), 
('3971', 'Rofin   90 mg', '268-0110-64', 'Tablet', 'Desh Pharmaceuticals Ltd.', '10.00', '0.00', '90 mg', 'Etoricoxib'), 
('3972', 'Rofin   120 mg', '268-0111-64', 'Tablet', 'Desh Pharmaceuticals Ltd.', '12.00', '0.00', '120 mg', 'Etoricoxib'), 
('3973', 'Nafex   120 mg', '268-0112-21', 'Tablet', 'Desh Pharmaceuticals Ltd.', '7.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('3974', 'Nafex80   180 mg', '268-0113-21', 'Tablet', 'Desh Pharmaceuticals Ltd.', '9.50', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('3975', 'Mon-X   10 mg', '268-0114-044', 'Tablet', 'Desh Pharmaceuticals Ltd.', '13.00', '0.00', '10 mg', 'Montelukast'), 
('3976', 'Metcure0   500 mg', '268-0115', 'Tablet', 'Desh Pharmaceuticals Ltd.', '3.80', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('3977', 'Metcure   850 mg', '268-0116', 'Tablet', 'Desh Pharmaceuticals Ltd.', '5.50', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('3978', 'Sulfozide   80 mg', '268-0117', 'Tablet', 'Desh Pharmaceuticals Ltd.', '6.00', '0.00', '80 mg', 'Gliclazide'), 
('3979', 'Achnil   200 mg', '268-0121-047', 'Tablet', 'Desh Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Tolfenamic Acid'), 
('3980', 'Remoxil   250 mg', '289-0008-023', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('3981', 'Reclox   500 mg', '289-0007-23', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cloxacillin'), 
('3982', 'Remoxil   500 mg', '289-0027-23', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('3983', 'Reflux   500 mg', '289-0032-23', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('3984', 'Celecox R     100 mg', '289-0020-064', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Celecoxib'), 
('3985', 'Cephra   500 mg', '289-0018-23', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('3986', 'Doxirem      100 mg', '289-0016-23', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('3987', 'Remexim   200 mg', '289-0039-23', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('3988', 'Neofen TR   100 mg', '289-0045-64', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('3989', 'I-Proton   20 mg', '289-0034-67', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('3990', 'E-Proton   20 mg', '289-0056-067', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('3991', 'Nifa   20 mg', '289-0066-22', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Nifedipine'), 
('3992', 'Fungifix   50 mg', '289-0068', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Fluconazole'), 
('3993', 'Flush   20 mg', '289-00714', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Fluoxetine'), 
('3994', 'Urocare   400 mcg', '289-00909', 'Capsule', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('3995', 'Remol   500 mg', '289-0001-006', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('3996', 'Remet   400 mg', '289-0003-27', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('3997', 'Remedon   10 mg', '289-00308', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('3998', 'Amlorem   10 mg', '289-0031-022', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Amlodipine'), 
('3999', 'Glucocare   80 mg', '289-0029', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '80 mg', 'Gliclazide'), 
('4000', 'Autoben   400 mg', '289-0024-008', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Albendazole'), 
('4001', 'Cetrol   10 mg', '289-0023-21', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '3.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('4002', 'Ciprotim   500 mg', '289-0019-23', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('4003', 'Neofen      50 mg', '289-0017-64', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('4004', 'Ranitidine R     150 mg', '289-00155', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('4005', 'E-medy0   500 mg', '289-0035-23', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('4006', 'My-Azi0   500 mg', '289-0038-23', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('4007', 'Hifenac   100 mg', '289-0041-64', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '3.00', '0.00', '100 mg', 'Aceclofenac'), 
('4008', 'Ketorolac   10 mg', '289-0043-064', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('4009', 'Tibeta   2.5 mg', '289-0046-22', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('4010', 'Stressnil 3   3 mg', '289-00477', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('4011', 'Reverse   2 mg', '289-0048-046', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Clonazepam'), 
('4012', 'Reverse.5   .5 mg', '289-0049-046', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '.5 mg', 'Clonazepam'), 
('4013', 'Losark   50 mg', '289-0051-022', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Losartan Potassium'), 
('4014', 'Nok   7.5 mg', '289-0052-057', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '7.5 mg', 'Midazolam'), 
('4015', 'Nok   15 mg', '289-0053-057', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Midazolam'), 
('4016', 'Flufex   120 mg', '289-0058-21', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('4017', 'P-Proton   20 mg', '289-0059-67', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Pantoprazole'), 
('4018', 'Montemax Orodispersile   5 mg', '289-0061-044', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Montelukast'), 
('4019', 'Montemax   10 mg', '289-0062-044', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Montelukast'), 
('4020', 'R-Proton   20 mg', '289-0065-67', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('4021', 'Levocare   500 mg', '289-0067-23', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('4022', 'Vascare   20 mg', '289-0070', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Trimetazidine Dihydrochloride'), 
('4023', 'Cope   25 mg', '289-00724', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Clozapine'), 
('4024', 'Cope0   100 mg', '289-00734', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Clozapine'), 
('4025', 'Holt   5 mg', '289-0074-28', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Haloperidol'), 
('4026', 'Rocy   5 mg', '289-0075-025', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Procyclidine Hydrochloride'), 
('4027', 'Gipix   5 mg', '289-0076', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Glipizide'), 
('4028', 'Jafa   8 mg', '289-00778', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '8 mg', 'Ondansetron'), 
('4029', 'Telmimax   20 mg', '289-0091-022', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Telmisartan'), 
('4030', 'Cefurino   250 mg', '289-0080-23', 'Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cefuroxime'), 
('4031', 'Trixotim IM   500 mg', '289-0082-23', 'IM Injection', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('4032', 'Trixotim gm IV   1 gm', '289-0081-23', 'IV Injection', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('4033', 'Fungicare-VT   100 mg', '289-0069', 'Vaginal Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Clotrimazole'), 
('4034', 'Neofen  SR    100 mg', '289-0026-64', 'Sr Tablet', 'Doctor Tims Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('4035', 'Auxil   250 mg', '029-0135-23', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('4036', 'Auxil   500 mg', '029-0123-23', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('4037', 'Cefex   250 mg', '029-0077-23', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '5.06', '0.00', '250 mg', 'Cephalexin'), 
('4038', 'Cloxil   500 mg', '029-0066-23', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '4.72', '0.00', '500 mg', 'Cloxacillin'), 
('4039', 'Lanzol   30 mg', '029-0116-67', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '5.00', '0.00', '30 mg', 'Lansoprazole'), 
('4040', 'Omaprin      20 mg', '029-0117-67', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '3.98', '0.00', '20 mg', 'Omeprazole'), 
('4041', 'Omaprin      40 mg', '029-0118-67', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '40 mg', 'Omeprazole'), 
('4042', 'Oxacin   250 mg', '029-0033-23', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '5.50', '0.00', '250 mg', 'Oxytetracycline'), 
('4043', 'Rifambin      150 mg', '029-0052-30', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '150 mg', 'Rifampicin'), 
('4044', 'Rifambin50   450 mg', '029-0062-30', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '450 mg', 'Rifampicin'), 
('4045', 'Septa   500 mg', '029-0100-23', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '12.36', '0.00', '500 mg', 'Cephradine'), 
('4046', 'Taracilin   250 mg', '029-0074-23', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('4047', 'Velacin      100 mg', '029-0098-23', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '1.02', '0.00', '100 mg', 'Doxycycline'), 
('4048', 'Amox   250 mg', '029-0050-023', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '3.50', '0.00', '250 mg', 'Amoxicillin'), 
('4049', 'Amox   500 mg', '029-0108-23', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '6.00', '0.00', '500 mg', 'Amoxicillin'), 
('4050', 'Duplocin   250 mg', '029-0034-23', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '250 mg', 'Ampicillin'), 
('4051', 'Cefex   500 mg', '029-0083-23', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('4052', 'Opan      50 mg', '029-0148-65', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('4053', 'Funga      150 mg', '029-0151', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '18.00', '0.00', '150 mg', 'Fluconazole'), 
('4054', 'Funga      50 mg', '029-0146', 'Capsule', 'Doctor\'s Chemicals Works Ltd.', '6.50', '0.00', '50 mg', 'Fluconazole'), 
('4055', 'Bentol%   1 %', '029-0095-23', 'Cream', 'Doctor\'s Chemicals Works Ltd.', '11.38', '0.00', '1 %', 'Silver Sulphadiazine'), 
('4056', 'Amlosin      5 mg', '029-0113-022', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '3.41', '0.00', '5 mg', 'Amlodipine'), 
('4057', 'Amobin      200 mg', '029-0035-27', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.53', '0.00', '200 mg', 'Metronidazole'), 
('4058', 'Amobin   400 mg', '029-0036-27', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '1.14', '0.00', '400 mg', 'Metronidazole'), 
('4059', 'Cetadol   500 mg', '029-0063-006', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.60', '0.00', '500 mg', 'Paracetamol'), 
('4060', 'Cloles   10 mg', '029-0138-061', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '8.00', '0.00', '10 mg', 'Atorvastatin'), 
('4061', 'D Butamol   2 mg', '029-00714', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '2 mg', 'Salbutamol'), 
('4062', 'D Cee   250 mg', '029-0054-78', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.80', '0.00', '250 mg', 'Vitamin C'), 
('4063', 'D Floxin   250 mg', '029-0080-23', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '4.55', '0.00', '250 mg', 'Ciprofloxacin'), 
('4064', 'D Floxin   500 mg', '029-0094-23', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '12.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('4065', 'D Lactate   300 mg', '029-0082-62', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '300 mg', 'Calcium Lactate'), 
('4066', 'Degram   500 mg', '029-0064-23', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '3.87', '0.00', '500 mg', 'Nalidixic Acid'), 
('4067', 'Deprofen      200 mg', '029-0072-64', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '200 mg', 'Ibuprofen'), 
('4068', 'Deprofen   400 mg', '029-0088-64', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.91', '0.00', '400 mg', 'Ibuprofen'), 
('4069', 'Distamin   4 mg', '029-0042-21', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.19', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('4070', 'Eradex   10 mg', '029-0115-21', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '2.73', '0.00', '10 mg', 'Loratadine'), 
('4071', 'Eridon   10 mg', '029-01208', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('4072', 'Ethamben   400 mg', '029-0057-30', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '400 mg', 'Ethambutol'), 
('4073', 'Famotin      20 mg', '029-00925', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '1.42', '0.00', '20 mg', 'Famotidine'), 
('4074', 'Famotin      40 mg', '029-00935', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '40 mg', 'Famotidine'), 
('4075', 'Fulvin G   500 mg', '029-0090', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '500 mg', 'Griseofulvin'), 
('4076', 'Glabin   5 mg', '029-0047', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '5 mg', 'Glibenclamide'), 
('4077', 'Helmin   40 mg', '029-0040-8', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '40 mg', 'Levamisole'), 
('4078', 'Isocal   1250 mg', '029-0114-62', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '4.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('4079', 'Lefex   250 mg', '029-0141-23', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '250 mg', 'Levofloxacin'), 
('4080', 'Lefex   500 mg', '029-0142-23', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '14.00', '0.00', '500 mg', 'Levofloxacin'), 
('4081', 'Mebendol      100 mg', '029-0044-8', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.70', '0.00', '100 mg', 'Mebendazole'), 
('4082', 'Metfen   500 mg', '029-0075', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '1.01', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('4083', 'Orinil      5 mg', '029-0038-057', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.21', '0.00', '5 mg', 'Diazepam'), 
('4084', 'Panprin      20 mg', '029-0136-67', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '3.00', '0.00', '20 mg', 'Pantoprazole'), 
('4085', 'Pantprin      40 mg', '029-0137-67', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '5.00', '0.00', '40 mg', 'Pantoprazole'), 
('4086', 'Piozon   15 mg', '029-0139', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '15 mg', 'Pioglitazone'), 
('4087', 'Precinol      50 mg', '029-0076-22', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.73', '0.00', '50 mg', 'Atenolol'), 
('4088', 'Riboflavine   5 mg', '029-0007-79', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '5 mg', 'Riboflavin'), 
('4089', 'Spasmin   10 mg', '029-00431', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '1.54', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('4090', 'Theonate   300 mg', '029-00284', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '1.31', '0.00', '300 mg', 'Theophylline'), 
('4091', 'Theonate  SR   300 mg', '029-00974', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '2.90', '0.00', '300 mg', 'Theophylline'), 
('4092', 'Uteric      40 mg', '029-00462', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '40 mg', 'Frusemide'), 
('4093', 'D Fenac      50 mg', '029-0085-64', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.80', '0.00', '50 mg', 'Diclofenac Sodium'), 
('4094', 'Danium   10 mg', '029-00686', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '2.85', '0.00', '10 mg', 'Clobazam'), 
('4095', 'Denitine      150 mg', '029-00695', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('4096', 'Evidon      200 mg', '029-0091-78', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '2.90', '0.00', '200 mg', 'Vitamin E'), 
('4097', 'D Aspirin0   300 mg', '029-0056-6', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '300 mg', 'Aspirin'), 
('4098', 'Losap      50 mg', '029-0011-022', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '5.97', '0.00', '50 mg', 'Losartan Potassium'), 
('4099', 'Metfen   850 mg', '029-0105', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '2.50', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('4100', 'Repro   250 mg', '029-0150-64', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '250 mg', 'Naproxen'), 
('4101', 'Repro   500 mg', '029-0149-64', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '7.00', '0.00', '500 mg', 'Naproxen'), 
('4102', 'D Butamol   4 mg', '029-01064', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.33', '0.00', '4 mg', 'Salbutamol'), 
('4103', 'Ilozin   500 mg', '029-0131-23', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('4104', 'Bronium   3 mg', '029-01257', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '3.00', '0.00', '3 mg', 'Bromazepam'), 
('4105', 'Dinaran   15 mg', '029-0145-21', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '15 mg', 'Cinnarizine'), 
('4106', 'Ilocin   500 mg', '029-0126-23', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '8.00', '0.00', '500 mg', 'Erythromycin'), 
('4107', 'Vasot   10 mg', '029-0147', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '10 mg', 'Isosorbide Dinitrate'), 
('4108', 'Ecosprin E/C   150 mg', '029-0546-26', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '150 mg', 'Aspirin'), 
('4109', 'Aldew0   400 mg', '029-0166-008', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '4.00', '0.00', '400 mg', 'Albendazole'), 
('4110', 'Delazide   80 mg', '029-0168', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '6.00', '0.00', '80 mg', 'Gliclazide'), 
('4111', 'Dexatil   250 mg', '029-0165-23', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('4112', 'Esru   20 mg', '029-0167-067', 'Tablet', 'Doctor\'s Chemicals Works Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('4113', 'Azimex   500 mg', '210-0173-23', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('4114', 'Azimex   250 mg', '210-0244-23', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('4115', 'Bufen  SR   300 mg', '210-0083-64', 'Capsule', 'Drug International Ltd.', '4.10', '0.00', '300 mg', 'Ibuprofen'), 
('4116', 'Cefalex   250 mg', '210-0019-23', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '250 mg', 'Cephalexin'), 
('4117', 'Cefalex   500 mg', '210-0094-23', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('4118', 'Cloxpen   500 mg', '210-0043-23', 'Capsule', 'Drug International Ltd.', '5.92', '0.00', '500 mg', 'Cloxacillin'), 
('4119', 'Cosec      20 mg', '210-0054-67', 'Capsule', 'Drug International Ltd.', '5.05', '0.00', '20 mg', 'Omeprazole'), 
('4120', 'Cosec      40 mg', '210-0109-67', 'Capsule', 'Drug International Ltd.', '8.05', '0.00', '40 mg', 'Omeprazole'), 
('4121', 'Dazol      100 mg', '210-02019', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '100 mg', 'Danazol'), 
('4122', 'Dazol      200 mg', '210-02029', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '200 mg', 'Danazol'), 
('4123', 'Demoxil   250 mg', '210-0012-023', 'Capsule', 'Drug International Ltd.', '3.52', '0.00', '250 mg', 'Amoxicillin'), 
('4124', 'Dicaltrol   .25 mcg', '210-0139-78', 'Capsule', 'Drug International Ltd.', '10.05', '0.00', '.25 mcg', 'Calcitriol'), 
('4125', 'Dicef   500 mg', '210-0099-23', 'Capsule', 'Drug International Ltd.', '13.05', '0.00', '500 mg', 'Cephradine'), 
('4126', 'Dicef   250 mg', '210-0098-023', 'Capsule', 'Drug International Ltd.', '7.05', '0.00', '250 mg', 'Cephradine'), 
('4127', 'Fenatrol      200 mg', '210-0254-61', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '200 mg', 'Fenofibrate'), 
('4128', 'Flunac      150 mg', '210-0207', 'Capsule', 'Drug International Ltd.', '20.10', '0.00', '150 mg', 'Fluconazole'), 
('4129', 'Flunac      50 mg', '210-0096', 'Capsule', 'Drug International Ltd.', '8.05', '0.00', '50 mg', 'Fluconazole'), 
('4130', 'Flupen   250 mg', '210-0200-23', 'Capsule', 'Drug International Ltd.', '5.05', '0.00', '250 mg', 'Flucloxacillin'), 
('4131', 'Flupen   500 mg', '210-0110-23', 'Capsule', 'Drug International Ltd.', '10.55', '0.00', '500 mg', 'Flucloxacillin'), 
('4132', 'Lansec   15 mg', '210-0194-67', 'Capsule', 'Drug International Ltd.', '3.55', '0.00', '15 mg', 'Lansoprazole'), 
('4133', 'Lansec   30 mg', '210-0142-67', 'Capsule', 'Drug International Ltd.', '6.05', '0.00', '30 mg', 'Lansoprazole'), 
('4134', 'Monocard  SR    50 mg', '210-0093', 'Capsule', 'Drug International Ltd.', '7.05', '0.00', '50 mg', 'Isosorbide Mononitrate'), 
('4135', 'Nifecap   10 mg', '210-0049-22', 'Capsule', 'Drug International Ltd.', '2.11', '0.00', '10 mg', 'Nifedipine'), 
('4136', 'Nifecap      5 mg', '210-0066-22', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '5 mg', 'Nifedipine'), 
('4137', 'Nizatid      150 mg', '210-01765', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '150 mg', 'Nizatidine'), 
('4138', 'Prostol   1 mg', '210-0262-22', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '1 mg', 'Terazosin'), 
('4139', 'Prostol   2 mg', '210-0299-22', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '2 mg', 'Terazosin'), 
('4140', 'Prostol      5 mg', '210-0263-22', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '5 mg', 'Terazosin'), 
('4141', 'Sefanid   500 mg', '210-0168-23', 'Capsule', 'Drug International Ltd.', '12.05', '0.00', '500 mg', 'Cefadroxil'), 
('4142', 'T Cef      200 mg', '210-0107-23', 'Capsule', 'Drug International Ltd.', '30.10', '0.00', '200 mg', 'Cefixime'), 
('4143', 'Theovent  SR   300 mg', '210-00504', 'Capsule', 'Drug International Ltd.', '3.00', '0.00', '300 mg', 'Theophylline'), 
('4144', 'Zipradon      40 mg', '210-0315-28', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '40 mg', 'Ziprasidone'), 
('4145', 'Zipradon      20 mg', '210-0314-28', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '20 mg', 'Ziprasidone'), 
('4146', 'Zipradon   60 mg', '210-0316-28', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '60 mg', 'Ziprasidone'), 
('4147', 'Zipradon   80 mg', '210-0317-28', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '80 mg', 'Ziprasidone'), 
('4148', 'Ceforan      200 mg', '210-0381-23', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '200 mg', 'Cefpodoxime'), 
('4149', 'Cardizem  SR    90 mg', '210-0169-22', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '90 mg', 'Diltiazem Hydrochloride'), 
('4150', 'Cardizem  SR    120 mg', '210-0085-22', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '120 mg', 'Diltiazem Hydrochloride'), 
('4151', 'I Cap   200 mg', '210-0095-62', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '200 mg', 'Iodine'), 
('4152', 'Nilocef0   300 mg', '210-0340-23', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '300 mg', 'Cefdinir'), 
('4153', 'Ceforan      100 mg', '210-0337-23', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '100 mg', 'Cefpodoxime'), 
('4154', 'Prostam   400 mcg', '210-03449', 'Capsule', 'Drug International Ltd.', '10.05', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('4155', 'Ascodil  SR   500 mg', '210-0382-78', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '500 mg', 'Vitamin C'), 
('4156', 'T Cef   400 mg', '210-0406-23', 'Capsule', 'Drug International Ltd.', '50.20', '0.00', '400 mg', 'Cefixime'), 
('4157', 'Mintek Soft Cap   .2 ml', '210-0423', 'Capsule', 'Drug International Ltd.', '6.05', '0.00', '.2 ml', 'Peppermint Oil'), 
('4158', 'Osevir   75 mg', '210-0455-32', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '75 mg', 'Oseltamivir'), 
('4159', 'Zidovir   100 mg', '210-0456-32', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '100 mg', 'Zidovudine'), 
('4160', 'Prelin   75 mg', '210-0492-046', 'Capsule', 'Drug International Ltd.', '16.05', '0.00', '75 mg', 'Pregabalin'), 
('4161', 'Prelin   150 mg', '210-0493-046', 'Capsule', 'Drug International Ltd.', '30.10', '0.00', '150 mg', 'Pregabalin'), 
('4162', 'Dalacin   300 mg', '210-0504-23', 'Capsule', 'Drug International Ltd.', '15.05', '0.00', '300 mg', 'Clindamycin'), 
('4163', 'Prelin   50 mg', '210-0511-046', 'Capsule', 'Drug International Ltd.', '11.05', '0.00', '50 mg', 'Pregabalin'), 
('4164', 'Prelin   100 mg', '210-0512-046', 'Capsule', 'Drug International Ltd.', '22.10', '0.00', '100 mg', 'Pregabalin'), 
('4165', 'Obitrol   120 mg', '210-0566', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '120 mg', 'Orlistat'), 
('4166', 'Cozyme Soft Capsule   30 mg', '210-0584', 'Capsule', 'Drug International Ltd.', '8.05', '0.00', '30 mg', 'Coenzyme Q10 (Ubidecarenone)'), 
('4167', 'Cozyme Soft Capsule   60 mg', '210-0585', 'Capsule', 'Drug International Ltd.', '15.05', '0.00', '60 mg', 'Coenzyme Q10 (Ubidecarenone)'), 
('4168', 'Prelin   25 mg', '210-0593-046', 'Capsule', 'Drug International Ltd.', '8.05', '0.00', '25 mg', 'Pregabalin'), 
('4169', 'Asta-King Soft   2 mg', '210-0595', 'Capsule', 'Drug International Ltd.', '10.05', '0.00', '2 mg', 'Astaxanthin'), 
('4170', 'Asta-King Soft   4 mg', '210-0596', 'Capsule', 'Drug International Ltd.', '20.10', '0.00', '4 mg', 'Astaxanthin'), 
('4171', 'Pronex   20 mg', '210-0619-067', 'Capsule', 'Drug International Ltd.', '6.00', '0.00', '20 mg', 'Esomeprazole'), 
('4172', 'Pronex   40 mg', '210-0620-067', 'Capsule', 'Drug International Ltd.', '8.00', '0.00', '40 mg', 'Esomeprazole'), 
('4173', 'Kingdol   50 mg', '210-0657-65', 'Capsule', 'Drug International Ltd.', '7.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('4174', 'Opegus   200 mg', '210-0659-32', 'Capsule', 'Drug International Ltd.', '25.00', '0.00', '200 mg', 'Ribavirin'), 
('4175', 'Paricap Soft Capsule   1 mcg', '210-0685-74', 'Capsule', 'Drug International Ltd.', '25.00', '0.00', '1 mcg', 'Paricalcitol'), 
('4176', 'Trolen   50 mg', '210-0695-70', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '50 mg', 'Dantrolene Sodium'), 
('4177', 'Trolen   25 mg', '210-0696-70', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '25 mg', 'Dantrolene Sodium'), 
('4178', 'D-Cap,000   40000 IU', '210-0715-78', 'Capsule', 'Drug International Ltd.', '35.00', '0.00', '40000 IU', 'Cholecalciferol (Vit. D3)'), 
('4179', 'D-Cap,000   20000 IU', '210-0714-78', 'Capsule', 'Drug International Ltd.', '20.00', '0.00', '20000 IU', 'Cholecalciferol (Vit. D3)'), 
('4180', 'Dsec   30 mg', '210-0734-067', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '30 mg', 'Dexlansoprazole'), 
('4181', 'Dsec-60   60 mg', '210-0735-067', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '60 mg', 'Dexlansoprazole'), 
('4182', 'Silofast   4 mg', '210-0736-049', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '4 mg', 'Silodosin'), 
('4183', 'Silofast-8   8 mg', '210-0737-049', 'Capsule', 'Drug International Ltd.', '0.00', '0.00', '8 mg', 'Silodosin'), 
('4184', 'Fintop   1 %', '210-0542-71', 'Cream', 'Drug International Ltd.', '40.15', '0.00', '1 %', 'Butenafine'), 
('4185', 'Silvec   1 %', '210-0677-23', 'Cream', 'Drug International Ltd.', '50.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('4186', 'Azimex   500 mg', '210-0155-23', 'Injection', 'Drug International Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('4187', 'Demoxil   500 mg', '210-0119-23', 'Injection', 'Drug International Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('4188', 'Demoxil   1 gm', '210-0152-023', 'Injection', 'Drug International Ltd.', '0.00', '0.00', '1 gm', 'Amoxicillin'), 
('4189', 'Demoxil   250 mg', '210-0118-023', 'Injection', 'Drug International Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('4190', 'Water For Injection   5 ml', '210-0133-79', 'Injection', 'Drug International Ltd.', '3.35', '0.00', '5 ml', 'Water For Injection'), 
('4191', 'Myokinase   15 Lac IU', '210-03312', 'Injection', 'Drug International Ltd.', '0.00', '0.00', '15 Lac IU', 'Streptokinase'), 
('4192', 'D-thiopental  IV   500 mg', '210-0393', 'Injection', 'Drug International Ltd.', '0.00', '0.00', '500 mg', 'Thiopentone Sodium'), 
('4193', 'Vancin0 IV   500 mg', '210-0520-23', 'Injection', 'Drug International Ltd.', '0.00', '0.00', '500 mg', 'Vancomycin'), 
('4194', 'Vancin gm IV   1 gm', '210-0521-23', 'Injection', 'Drug International Ltd.', '0.00', '0.00', '1 gm', 'Vancomycin'), 
('4195', 'D-Lac   68 %', '210-0092-60', 'Oral Solution', 'Drug International Ltd.', '70.25', '0.00', '68 %', 'Lactulose'), 
('4196', 'Laxoral   17 gm', '210-0279-60', 'Powder', 'Drug International Ltd.', '0.00', '0.00', '17 gm', 'Poly Ethylene Glycol 3350'), 
('4197', 'Laxadil   3.5 gm', '210-0039-60', 'Sachet', 'Drug International Ltd.', '0.00', '0.00', '3.5 gm', 'Ispaghula Husk'), 
('4198', 'Cod Liver Oil   85 IU', '210-0037', 'Soft Gelatin Capsule', 'Drug International Ltd.', '2.05', '0.00', '85 IU', 'Cod Liver Oil'), 
('4199', 'Digoxen .1   100 mcg', '210-0291-35', 'Soft Gelatin Capsule', 'Drug International Ltd.', '0.00', '0.00', '100 mcg', 'Digoxin'), 
('4200', 'Digoxen .2   200 mcg', '210-0292-35', 'Soft Gelatin Capsule', 'Drug International Ltd.', '0.00', '0.00', '200 mcg', 'Digoxin'), 
('4201', 'E-Cap      200 mg', '210-0057-78', 'Soft Gelatin Capsule', 'Drug International Ltd.', '4.05', '0.00', '200 mg', 'Vitamin E'), 
('4202', 'E-Cap   400 mg', '210-0137-78', 'Soft Gelatin Capsule', 'Drug International Ltd.', '6.05', '0.00', '400 mg', 'Vitamin E'), 
('4203', 'Ratinol   FORTE00 IU   50000 IU', '210-0047-78', 'Soft Gelatin Capsule', 'Drug International Ltd.', '1.93', '0.00', '50000 IU', 'Vitamin A'), 
('4204', 'Ratinol forte Lac IU   1 Lac IU', '210-0136-78', 'Soft Gelatin Capsule', 'Drug International Ltd.', '3.00', '0.00', '1 Lac IU', 'Vitamin A'), 
('4205', 'Ratinol Forte Lac IU   2 Lac IU', '210-0045-78', 'Soft Gelatin Capsule', 'Drug International Ltd.', '3.01', '0.00', '2 Lac IU', 'Vitamin A'), 
('4206', 'Dutamax   500 mcg', '210-04196', 'Soft Gelatin Capsule', 'Drug International Ltd.', '12.05', '0.00', '500 mcg', 'Dutasteride'), 
('4207', 'OMG-3 Soft Cap   1 gm', '210-0422-61', 'Soft Gelatin Capsule', 'Drug International Ltd.', '6.05', '0.00', '1 gm', 'Omega-3 Acid Ethyl Esters'), 
('4208', 'D-Cap   800 IU', '210-0707-78', 'Soft Gelatin Capsule', 'Drug International Ltd.', '4.00', '0.00', '800 IU', 'Cholecalciferol (Vit. D3)'), 
('4209', 'Dinakion Soft Capsule   1 mg', '210-0728-078', 'Soft Gelatin Capsule', 'Drug International Ltd.', '0.00', '0.00', '1 mg', 'Phytomenadione'), 
('4210', 'Acepril   10 mg', '210-0056-22', 'Tablet', 'Drug International Ltd.', '7.05', '0.00', '10 mg', 'Lisinopril'), 
('4211', 'Acepril   5 mg', '210-0055-22', 'Tablet', 'Drug International Ltd.', '4.05', '0.00', '5 mg', 'Lisinopril'), 
('4212', 'Acetor      25 mg', '210-0105-22', 'Tablet', 'Drug International Ltd.', '3.05', '0.00', '25 mg', 'Captopril'), 
('4213', 'Amlocard   10 mg', '210-0199-022', 'Tablet', 'Drug International Ltd.', '7.05', '0.00', '10 mg', 'Amlodipine'), 
('4214', 'Amlocard   5 mg', '210-0089-022', 'Tablet', 'Drug International Ltd.', '4.55', '0.00', '5 mg', 'Amlodipine'), 
('4215', 'Aslor   5 mg', '210-0269-21', 'Tablet', 'Drug International Ltd.', '2.55', '0.00', '5 mg', 'Desloratadine'), 
('4216', 'Azimex   500 mg', '210-0305-23', 'Tablet', 'Drug International Ltd.', '35.15', '0.00', '500 mg', 'Azithromycin'), 
('4217', 'Azimex   250 mg', '210-0304-23', 'Tablet', 'Drug International Ltd.', '25.10', '0.00', '250 mg', 'Azithromycin'), 
('4218', 'Betaloc      50 mg', '210-0044-22', 'Tablet', 'Drug International Ltd.', '2.05', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('4219', 'Breton   2 mg', '210-01434', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '2 mg', 'Tulobuterol Hydrochloride'), 
('4220', 'Broncomet   8 mg', '210-0288-031', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '8 mg', 'Bromhexine Hydrochloride'), 
('4221', 'Camiton      5 mg', '210-0058-36', 'Tablet', 'Drug International Ltd.', '4.05', '0.00', '5 mg', 'Vinpocetine'), 
('4222', 'Candiloc6   16 mg', '210-0272-22', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '16 mg', 'Candesartan Cilexetil'), 
('4223', 'Candiloc   8 mg', '210-0271-22', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '8 mg', 'Candesartan Cilexetil'), 
('4224', 'Cardiron      200 mg', '210-0247-9', 'Tablet', 'Drug International Ltd.', '7.05', '0.00', '200 mg', 'Amiodarone Hydrochloride'), 
('4225', 'Cardizem   30 mg', '210-0051-22', 'Tablet', 'Drug International Ltd.', '3.05', '0.00', '30 mg', 'Diltiazem Hydrochloride'), 
('4226', 'Cardizem   60 mg', '210-0048-22', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '60 mg', 'Diltiazem Hydrochloride'), 
('4227', 'Cardizem  SR    90 mg', '210-0306-22', 'Tablet', 'Drug International Ltd.', '6.05', '0.00', '90 mg', 'Diltiazem Hydrochloride'), 
('4228', 'Cardizem  SR    120 mg', '210-0307-22', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '120 mg', 'Diltiazem Hydrochloride'), 
('4229', 'Cavelon   6.25 mg', '210-0225-22', 'Tablet', 'Drug International Ltd.', '3.05', '0.00', '6.25 mg', 'Carvedilol'), 
('4230', 'Cavelon   12.5 mg', '210-0149-22', 'Tablet', 'Drug International Ltd.', '5.00', '0.00', '12.5 mg', 'Carvedilol'), 
('4231', 'Cetrin   10 mg', '210-0075-21', 'Tablet', 'Drug International Ltd.', '3.05', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('4232', 'Ciprozid   250 mg', '210-0071-23', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '250 mg', 'Ciprofloxacin'), 
('4233', 'Ciprozid  DS   500 mg', '210-0090-23', 'Tablet', 'Drug International Ltd.', '15.05', '0.00', '500 mg', 'Ciprofloxacin'), 
('4234', 'Ciprozid   750 mg', '210-0175-23', 'Tablet', 'Drug International Ltd.', '16.05', '0.00', '750 mg', 'Ciprofloxacin'), 
('4235', 'Ciprozid  OD   500 mg', '210-0296-23', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('4236', 'Clarigen   5 mg', '210-0270-21', 'Tablet', 'Drug International Ltd.', '2.05', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('4237', 'Clarin   250 mg', '210-0112-23', 'Tablet', 'Drug International Ltd.', '25.10', '0.00', '250 mg', 'Clarithromycin'), 
('4238', 'Clopid      75 mg', '210-0179-26', 'Tablet', 'Drug International Ltd.', '12.05', '0.00', '75 mg', 'Clopidogrel'), 
('4239', 'D Thia      100 mg', '210-0256-78', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('4240', 'Dimerol   80 mg', '210-0081', 'Tablet', 'Drug International Ltd.', '7.05', '0.00', '80 mg', 'Gliclazide'), 
('4241', 'Dimerol  MR   30 mg', '210-0287', 'Tablet', 'Drug International Ltd.', '6.05', '0.00', '30 mg', 'Gliclazide'), 
('4242', 'Diproxen   250 mg', '210-0052-64', 'Tablet', 'Drug International Ltd.', '4.30', '0.00', '250 mg', 'Naproxen'), 
('4243', 'Diproxen   500 mg', '210-0103-64', 'Tablet', 'Drug International Ltd.', '7.05', '0.00', '500 mg', 'Naproxen'), 
('4244', 'Divastin   10 mg', '210-0148-061', 'Tablet', 'Drug International Ltd.', '10.05', '0.00', '10 mg', 'Atorvastatin'), 
('4245', 'Dronet   10 mg', '210-01458', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '10 mg', 'Alendronic Acid'), 
('4246', 'Famotid      20 mg', '210-00645', 'Tablet', 'Drug International Ltd.', '2.05', '0.00', '20 mg', 'Famotidine'), 
('4247', 'Famotid      40 mg', '210-00655', 'Tablet', 'Drug International Ltd.', '4.05', '0.00', '40 mg', 'Famotidine'), 
('4248', 'Fenat   1 mg', '210-0076-21', 'Tablet', 'Drug International Ltd.', '2.05', '0.00', '1 mg', 'Ketotifen'), 
('4249', 'Fenaton   500 mg', '210-0151-64', 'Tablet', 'Drug International Ltd.', '1.55', '0.00', '500 mg', 'Mefenamic Acid'), 
('4250', 'Furex   250 mg', '210-0195-23', 'Tablet', 'Drug International Ltd.', '25.10', '0.00', '250 mg', 'Cefuroxime'), 
('4251', 'Glimerol      5 mg', '210-0286', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '5 mg', 'Glipizide'), 
('4252', 'Glimet   1 mg', '210-0157-015', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '1 mg', 'Repaglinide'), 
('4253', 'AH0 Chewable   400 mg', '210-0275-008', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '400 mg', 'Albendazole'), 
('4254', 'Limpet   1 mg', '210-0228', 'Tablet', 'Drug International Ltd.', '3.05', '0.00', '1 mg', 'Glimepiride'), 
('4255', 'Limpet   2 mg', '210-0159', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '2 mg', 'Glimepiride'), 
('4256', 'Lorat   10 mg', '210-0106-21', 'Tablet', 'Drug International Ltd.', '3.05', '0.00', '10 mg', 'Loratadine'), 
('4257', 'Losardil      50 mg', '210-0146-022', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '50 mg', 'Losartan Potassium'), 
('4258', 'Losardil      25 mg', '210-0206-022', 'Tablet', 'Drug International Ltd.', '4.55', '0.00', '25 mg', 'Losartan Potassium'), 
('4259', 'Luretic      5 mg', '210-02272', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '5 mg', 'Torasemide'), 
('4260', 'Luretic.5   2.5 mg', '210-02262', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '2.5 mg', 'Torasemide'), 
('4261', 'Mecolin   .5 mg', '210-0273-78', 'Tablet', 'Drug International Ltd.', '4.05', '0.00', '.5 mg', 'Mecobalamin'), 
('4262', 'Meverine   135 mg', '210-00871', 'Tablet', 'Drug International Ltd.', '6.05', '0.00', '135 mg', 'Mebeverine Hydrochloride'), 
('4263', 'Monocard   10 mg', '210-0080', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '10 mg', 'Isosorbide Mononitrate'), 
('4264', 'Neuropen0   300 mg', '210-0252-046', 'Tablet', 'Drug International Ltd.', '16.05', '0.00', '300 mg', 'Gabapentin'), 
('4265', 'Nidocard Retard 6.4   6.4 mg', '210-0243', 'Tablet', 'Drug International Ltd.', '7.05', '0.00', '6.4 mg', 'Glyceryl Trinitrate'), 
('4266', 'Angicard   .5 mg', '210-0162', 'Tablet', 'Drug International Ltd.', '3.05', '0.00', '.5 mg', 'Glyceryl Trinitrate'), 
('4267', 'Nidocard Retard   2.6 mg', '210-0161', 'Tablet', 'Drug International Ltd.', '4.05', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('4268', 'Nofenac   100 mg', '210-0264-64', 'Tablet', 'Drug International Ltd.', '4.05', '0.00', '100 mg', 'Aceclofenac'), 
('4269', 'Nomosic   50 mg', '210-02848', 'Tablet', 'Drug International Ltd.', '2.55', '0.00', '50 mg', 'Meclizine Hydrochloride'), 
('4270', 'Nopain      25 mg', '210-0078-64', 'Tablet', 'Drug International Ltd.', '2.05', '0.00', '25 mg', 'Diclofenac Sodium'), 
('4271', 'Nopain      50 mg', '210-0079-64', 'Tablet', 'Drug International Ltd.', '4.05', '0.00', '50 mg', 'Diclofenac Potassium'), 
('4272', 'Novastin   10 mg', '210-0138-61', 'Tablet', 'Drug International Ltd.', '11.05', '0.00', '10 mg', 'Simvastatin'), 
('4273', 'Novirax   400 mg', '210-0285-32', 'Tablet', 'Drug International Ltd.', '22.10', '0.00', '400 mg', 'Acyclovir'), 
('4274', 'Novirax      200 mg', '210-0150-32', 'Tablet', 'Drug International Ltd.', '14.50', '0.00', '200 mg', 'Acyclovir'), 
('4275', 'Oflacin      200 mg', '210-0060-23', 'Tablet', 'Drug International Ltd.', '12.05', '0.00', '200 mg', 'Ofloxacin'), 
('4276', 'Oflacin   400 mg', '210-0113-23', 'Tablet', 'Drug International Ltd.', '20.10', '0.00', '400 mg', 'Ofloxacin'), 
('4277', 'Oramet  SR   500 mg', '210-0235', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('4278', 'Ornid   500 mg', '210-0160-27', 'Tablet', 'Drug International Ltd.', '7.05', '0.00', '500 mg', 'Ornidazole'), 
('4279', 'Pansec      20 mg', '210-0180-67', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '20 mg', 'Pantoprazole'), 
('4280', 'Paridon   10 mg', '210-01408', 'Tablet', 'Drug International Ltd.', '2.05', '0.00', '10 mg', 'Domperidone'), 
('4281', 'Peflox   400 mg', '210-0073-23', 'Tablet', 'Drug International Ltd.', '11.05', '0.00', '400 mg', 'Pefloxacin'), 
('4282', 'Piozena   15 mg', '210-0224', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '15 mg', 'Pioglitazone'), 
('4283', 'Ramicard   10 mg', '210-0229-022', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '10 mg', 'Ramipril'), 
('4284', 'Ramicard.5   2.5 mg', '210-0208-022', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '2.5 mg', 'Ramipril'), 
('4285', 'Ramicard      5 mg', '210-0209-022', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '5 mg', 'Ramipril'), 
('4286', 'Resco   1 mg', '210-0248-28', 'Tablet', 'Drug International Ltd.', '1.55', '0.00', '1 mg', 'Risperidone'), 
('4287', 'Resco   2 mg', '210-0249-28', 'Tablet', 'Drug International Ltd.', '2.05', '0.00', '2 mg', 'Risperidone'), 
('4288', 'Sertal      50 mg', '210-01564', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '50 mg', 'Sertraline'), 
('4289', 'Sparoxen      200 mg', '210-0198-23', 'Tablet', 'Drug International Ltd.', '18.10', '0.00', '200 mg', 'Sparfloxacin'), 
('4290', 'Sumatan      50 mg', '210-02957', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '50 mg', 'Sumatriptan'), 
('4291', 'Tenatrol   3 mg', '210-01357', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('4292', 'Theovent RETARD   250 mg', '210-02774', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '250 mg', 'Theophylline'), 
('4293', 'Theovent  SR   400 mg', '210-02764', 'Tablet', 'Drug International Ltd.', '2.70', '0.00', '400 mg', 'Theophylline'), 
('4294', 'Ticlopid   250 mg', '210-0088-26', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '250 mg', 'Ticlopidine Hydrochloride'), 
('4295', 'Pair   30 mg', '210-0134-064', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '30 mg', 'Ketorolac Tromethamine'), 
('4296', 'Trimet   20 mg', '210-0300', 'Tablet', 'Drug International Ltd.', '3.05', '0.00', '20 mg', 'Trimetazidine Dihydrochloride'), 
('4297', 'Ulcar      150 mg', '210-00535', 'Tablet', 'Drug International Ltd.', '2.55', '0.00', '150 mg', 'Ranitidine'), 
('4298', 'Ulcar0   300 mg', '210-00745', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '300 mg', 'Ranitidine'), 
('4299', 'Varizil   400 mg', '210-0011-27', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('4300', 'Xinac0   300 mg', '210-0172-23', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '300 mg', 'Roxithromycin'), 
('4301', 'M Kast   4 mg', '210-0320-044', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '4 mg', 'Montelukast'), 
('4302', 'Indapa SR   1.5 mg', '210-03242', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '1.5 mg', 'Indapamide'), 
('4303', 'Diproxen  CR   500 mg', '210-0327-64', 'Tablet', 'Drug International Ltd.', '10.05', '0.00', '500 mg', 'Naproxen'), 
('4304', 'D-Fen.5   500 mcg', '210-03297', 'Tablet', 'Drug International Ltd.', '3.05', '0.00', '500 mcg', 'Pizotifen'), 
('4305', 'D-Fen.5   1.5 mg', '210-03307', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '1.5 mg', 'Pizotifen'), 
('4306', 'Telmicard   40 mg', '210-0377-022', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '40 mg', 'Telmisartan'), 
('4307', 'Erybac   250 mg', '210-0379-23', 'Tablet', 'Drug International Ltd.', '4.05', '0.00', '250 mg', 'Erythromycin'), 
('4308', 'Erybac   500 mg', '210-0380-23', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '500 mg', 'Erythromycin'), 
('4309', 'Caldil   1250 mg', '210-0255-62', 'Tablet', 'Drug International Ltd.', '3.05', '0.00', '1250 mg', 'Calcium Carbonate'), 
('4310', 'Levoflox   500 mg', '210-0182-23', 'Tablet', 'Drug International Ltd.', '15.05', '0.00', '500 mg', 'Levofloxacin'), 
('4311', 'Pronex      20 mg', '210-0197-067', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '20 mg', 'Esomeprazole'), 
('4312', 'Furex   500 mg', '210-0350-23', 'Tablet', 'Drug International Ltd.', '45.15', '0.00', '500 mg', 'Cefuroxime'), 
('4313', 'Clarin   500 mg', '210-0355-23', 'Tablet', 'Drug International Ltd.', '40.15', '0.00', '500 mg', 'Clarithromycin'), 
('4314', 'Spador   10 mg', '210-03614', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '10 mg', 'Escitalopram'), 
('4315', 'Spador      5 mg', '210-03604', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '5 mg', 'Escitalopram'), 
('4316', 'E Coxib   60 mg', '210-0365-64', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '60 mg', 'Etoricoxib'), 
('4317', 'E Coxib   90 mg', '210-0366-64', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '90 mg', 'Etoricoxib'), 
('4318', 'Carniten   330 mg', '210-0371', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '330 mg', 'Levocarnitine'), 
('4319', 'Linzo   400 mg', '210-0336-023', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '400 mg', 'Linezolid'), 
('4320', 'Oramet   500 mg', '210-0354', 'Tablet', 'Drug International Ltd.', '3.05', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('4321', 'Betaloc  XR    50 mg', '210-0345-22', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('4322', 'Betaloc XR   100 mg', '210-0346-22', 'Tablet', 'Drug International Ltd.', '6.05', '0.00', '100 mg', 'Metoprolol Tartrate'), 
('4323', 'M Kast      5 mg', '210-0321-044', 'Tablet', 'Drug International Ltd.', '7.05', '0.00', '5 mg', 'Montelukast'), 
('4324', 'Misopep      200 mcg', '210-02749', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '200 mcg', 'Misoprostol'), 
('4325', 'Cardival   80 mg', '210-0334-22', 'Tablet', 'Drug International Ltd.', '10.05', '0.00', '80 mg', 'Valsartan'), 
('4326', 'Miotrol.5   2.5 mg', '210-03357', 'Tablet', 'Drug International Ltd.', '15.05', '0.00', '2.5 mg', 'Zolmitriptan'), 
('4327', 'Lexaton      50 mg', '210-0342-70', 'Tablet', 'Drug International Ltd.', '3.05', '0.00', '50 mg', 'Tolperisone Hydrochloride'), 
('4328', 'Pansec      40 mg', '210-0357-67', 'Tablet', 'Drug International Ltd.', '7.05', '0.00', '40 mg', 'Pantoprazole'), 
('4329', 'Visonium   50 mg', '210-03621', 'Tablet', 'Drug International Ltd.', '5.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('4330', 'Monocard      20 mg', '210-0061', 'Tablet', 'Drug International Ltd.', '1.43', '0.00', '20 mg', 'Isosorbide Mononitrate'), 
('4331', 'Pronex      40 mg', '210-0358-67', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '40 mg', 'Esomeprazole'), 
('4332', 'Pair   10 mg', '210-0391-064', 'Tablet', 'Drug International Ltd.', '10.05', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('4333', 'Olapine      5 mg', '210-0397-28', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '5 mg', 'Olanzapine'), 
('4334', 'Olapin   10 mg', '210-0398-28', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '10 mg', 'Olanzapine'), 
('4335', 'Resco   4 mg', '210-0400-28', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '4 mg', 'Risperidone'), 
('4336', 'Sertal   25 mg', '210-04014', 'Tablet', 'Drug International Ltd.', '3.05', '0.00', '25 mg', 'Sertraline'), 
('4337', 'Sertal0   100 mg', '210-04024', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '100 mg', 'Sertraline'), 
('4338', 'M Kast   10 mg', '210-0404-044', 'Tablet', 'Drug International Ltd.', '12.05', '0.00', '10 mg', 'Montelukast'), 
('4339', 'Divastin      20 mg', '210-0405-061', 'Tablet', 'Drug International Ltd.', '18.10', '0.00', '20 mg', 'Atorvastatin'), 
('4340', 'Niapid   500 mg', '210-0409-78', 'Tablet', 'Drug International Ltd.', '6.05', '0.00', '500 mg', 'Niacin'), 
('4341', 'Levoflox   750 mg', '210-0415-23', 'Tablet', 'Drug International Ltd.', '20.10', '0.00', '750 mg', 'Levofloxacin'), 
('4342', 'Nitanid   500 mg', '210-0418-27', 'Tablet', 'Drug International Ltd.', '10.05', '0.00', '500 mg', 'Nitazoxanide'), 
('4343', 'Trimet MR   35 mg', '210-0421', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '35 mg', 'Trimetazidine Dihydrochloride'), 
('4344', 'Entavir.5   .5 mg', '210-0425-32', 'Tablet', 'Drug International Ltd.', '45.15', '0.00', '.5 mg', 'Entecavir'), 
('4345', 'Entavir   1 mg', '210-0426-32', 'Tablet', 'Drug International Ltd.', '90.30', '0.00', '1 mg', 'Entecavir'), 
('4346', 'Betaloc      25 mg', '210-0431-22', 'Tablet', 'Drug International Ltd.', '1.55', '0.00', '25 mg', 'Metoprolol Tartrate'), 
('4347', 'Purinol   100 mg', '210-0430-76', 'Tablet', 'Drug International Ltd.', '4.05', '0.00', '100 mg', 'Allopurinol'), 
('4348', 'L-Cardin   2 mg', '210-0436-22', 'Tablet', 'Drug International Ltd.', '3.05', '0.00', '2 mg', 'Lacidipine'), 
('4349', 'L-Cardin   4 mg', '210-0437-22', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '4 mg', 'Lacidipine'), 
('4350', 'Ondason 8   8 mg', '210-04428', 'Tablet', 'Drug International Ltd.', '10.05', '0.00', '8 mg', 'Ondansetron'), 
('4351', 'Tenobis   2.5 mg', '210-0446-22', 'Tablet', 'Drug International Ltd.', '6.05', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('4352', 'Tenobis   5 mg', '210-0447-22', 'Tablet', 'Drug International Ltd.', '10.05', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('4353', 'Cytivir   100 mg', '210-0451-32', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '100 mg', 'Lamivudine'), 
('4354', 'Sulfacol   500 mg', '210-0453-64', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '500 mg', 'Sulfasalazine'), 
('4355', 'Rostatin   10 mg', '210-0454-61', 'Tablet', 'Drug International Ltd.', '8.00', '0.00', '10 mg', 'Rosuvastatin'), 
('4356', 'Rabesec   20 mg', '210-0457-67', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('4357', 'Feripon   500 mg', '210-04585', 'Tablet', 'Drug International Ltd.', '18.10', '0.00', '500 mg', 'Deferiprone'), 
('4358', 'Spiretic   25 mg', '210-04612', 'Tablet', 'Drug International Ltd.', '5.05', '0.00', '25 mg', 'Spironolactone'), 
('4359', 'Limpet 3   3 mg', '210-0462', 'Tablet', 'Drug International Ltd.', '7.05', '0.00', '3 mg', 'Glimepiride'), 
('4360', 'Fexofast   120 mg', '210-0469-21', 'Tablet', 'Drug International Ltd.', '7.05', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('4361', 'Fexofast80   180 mg', '210-0470-21', 'Tablet', 'Drug International Ltd.', '9.05', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('4362', 'Ursolic   300 mg', '210-0483', 'Tablet', 'Drug International Ltd.', '20.10', '0.00', '300 mg', 'Ursodeoxycholic Acid'), 
('4363', 'Ursolic   150 mg', '210-0482', 'Tablet', 'Drug International Ltd.', '11.05', '0.00', '150 mg', 'Ursodeoxycholic Acid'), 
('4364', 'Divastin   40 mg', '210-0473-061', 'Tablet', 'Drug International Ltd.', '20.00', '0.00', '40 mg', 'Atorvastatin'), 
('4365', 'D-Toin   100 mg', '210-0475-046', 'Tablet', 'Drug International Ltd.', '2.05', '0.00', '100 mg', 'Phenytoin Sodium'), 
('4366', 'Losardil   100 mg', '210-0481-022', 'Tablet', 'Drug International Ltd.', '12.05', '0.00', '100 mg', 'Losartan Potassium'), 
('4367', 'Gelcin   320 mg', '210-0486-23', 'Tablet', 'Drug International Ltd.', '65.20', '0.00', '320 mg', 'Gemefloxacin'), 
('4368', 'Nefivir   250 mg', '210-0488-32', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '250 mg', 'Nelfinavir'), 
('4369', 'T-Fovir   300 mg', '210-0490-32', 'Tablet', 'Drug International Ltd.', '85.30', '0.00', '300 mg', 'Tenofovir Disoproxil Fumarate'), 
('4370', 'Dialiptin   50 mg', '210-0485', 'Tablet', 'Drug International Ltd.', '15.05', '0.00', '50 mg', 'Vildagliptin'), 
('4371', 'Sliptin   100 mg', '210-0495', 'Tablet', 'Drug International Ltd.', '28.10', '0.00', '100 mg', 'Sitagliptin'), 
('4372', 'Ceforan   100 mg', '210-0498-23', 'Tablet', 'Drug International Ltd.', '17.05', '0.00', '100 mg', 'Cefpodoxime'), 
('4373', 'Ceforan   200 mg', '210-0499-23', 'Tablet', 'Drug International Ltd.', '28.10', '0.00', '200 mg', 'Cefpodoxime'), 
('4374', 'Rostatin   20 mg', '210-0500-61', 'Tablet', 'Drug International Ltd.', '10.00', '0.00', '20 mg', 'Rosuvastatin'), 
('4375', 'Theovent SR   300 mg', '210-05014', 'Tablet', 'Drug International Ltd.', '2.05', '0.00', '300 mg', 'Theophylline'), 
('4376', 'Cytivir   150 mg', '210-0502-32', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '150 mg', 'Lamivudine'), 
('4377', 'Diamide   5 mg', '210-0508', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '5 mg', 'Glibenclamide'), 
('4378', 'Thalide   25 mg', '210-05092', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '25 mg', 'Chlorthalidone'), 
('4379', 'Limpet   4 mg', '210-0510', 'Tablet', 'Drug International Ltd.', '9.05', '0.00', '4 mg', 'Glimepiride'), 
('4380', 'Spiracin.5   1.5 MIU', '210-0516-23', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '1.5 MIU', 'Spiramycine'), 
('4381', 'Spiracin 3   3 MIU', '210-0517-23', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '3 MIU', 'Spiramycine'), 
('4382', 'Fenatrol45   145 mg', '210-0518-61', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '145 mg', 'Fenofibrate'), 
('4383', 'Olmetic   20 mg', '210-0519-22', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('4384', 'Toldin   2 mg', '210-05249', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '2 mg', 'Tolterodine Tartrate'), 
('4385', 'Nifetab SR   20 mg', '210-0525-22', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '20 mg', 'Nifedipine'), 
('4386', 'D-Zole   1 gm', '210-0526-27', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '1 gm', 'Secnidazole'), 
('4387', 'Prapid   5 mg', '210-0524-26', 'Tablet', 'Drug International Ltd.', '12.05', '0.00', '5 mg', 'Prasugrel'), 
('4388', 'Prapid   10 mg', '210-0529-26', 'Tablet', 'Drug International Ltd.', '20.10', '0.00', '10 mg', 'Prasugrel'), 
('4389', 'Dimerol   60 mg', '210-0530', 'Tablet', 'Drug International Ltd.', '10.00', '0.00', '60 mg', 'Gliclazide'), 
('4390', 'Granison   1 mg', '210-05318', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '1 mg', 'Granisetron'), 
('4391', 'Dipa   10 mg', '210-0536-21', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '10 mg', 'Rupatadine'), 
('4392', 'Theovent SR   200 mg', '210-05374', 'Tablet', 'Drug International Ltd.', '1.60', '0.00', '200 mg', 'Theophylline'), 
('4393', 'Lip Loss   2 mg', '210-0538-61', 'Tablet', 'Drug International Ltd.', '10.05', '0.00', '2 mg', 'Pitavastatin'), 
('4394', 'Ivaten   5 mg', '210-0539', 'Tablet', 'Drug International Ltd.', '16.00', '0.00', '5 mg', 'Ivabradine'), 
('4395', 'Ivaten   7.5 mg', '210-0540', 'Tablet', 'Drug International Ltd.', '25.00', '0.00', '7.5 mg', 'Ivabradine'), 
('4396', 'Rinis   10 mg', '210-0546-21', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '10 mg', 'Ebastine'), 
('4397', 'Rostatin   5 mg', '210-0548-61', 'Tablet', 'Drug International Ltd.', '6.00', '0.00', '5 mg', 'Rosuvastatin'), 
('4398', 'Sliptin   25 mg', '210-0554', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '25 mg', 'Sitagliptin'), 
('4399', 'Sliptin   50 mg', '210-0555', 'Tablet', 'Drug International Ltd.', '15.05', '0.00', '50 mg', 'Sitagliptin'), 
('4400', 'Faxan   200 mg', '210-0567-23', 'Tablet', 'Drug International Ltd.', '20.10', '0.00', '200 mg', 'Rifaximin'), 
('4401', 'Faxan50   550 mg', '210-0568-23', 'Tablet', 'Drug International Ltd.', '40.15', '0.00', '550 mg', 'Rifaximin'), 
('4402', 'Ramicard.25   1.25 mg', '210-0573-022', 'Tablet', 'Drug International Ltd.', '2.55', '0.00', '1.25 mg', 'Ramipril'), 
('4403', 'Neuropen   100 mg', '210-0574-046', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '100 mg', 'Gabapentin'), 
('4404', 'Tigarol   90 mg', '210-0576-26', 'Tablet', 'Drug International Ltd.', '75.00', '0.00', '90 mg', 'Ticagrelor'), 
('4405', 'Bacmax   5 mg', '210-0578-70', 'Tablet', 'Drug International Ltd.', '4.05', '0.00', '5 mg', 'Baclofen'), 
('4406', 'Bacmax   10 mg', '210-0579-70', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '10 mg', 'Baclofen'), 
('4407', 'Linarol   5 mg', '210-0586-015', 'Tablet', 'Drug International Ltd.', '15.05', '0.00', '5 mg', 'Linagliptin'), 
('4408', 'Rofumil   500 mcg', '210-05884', 'Tablet', 'Drug International Ltd.', '10.05', '0.00', '500 mcg', 'Roflumilast'), 
('4409', 'Caldil OT   400 mg', '210-0594-62', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '400 mg', 'Calcium Orotate'), 
('4410', 'Sudac   100 mg', '210-0603-64', 'Tablet', 'Drug International Ltd.', '5.00', '0.00', '100 mg', 'Sulindac'), 
('4411', 'Sudac   200 mg', '210-0604-64', 'Tablet', 'Drug International Ltd.', '9.00', '0.00', '200 mg', 'Sulindac'), 
('4412', 'Purinol   300 mg', '210-0606-76', 'Tablet', 'Drug International Ltd.', '8.05', '0.00', '300 mg', 'Allopurinol'), 
('4413', 'Ejalong   30 mg', '210-0621-014', 'Tablet', 'Drug International Ltd.', '20.00', '0.00', '30 mg', 'Dapoxetine'), 
('4414', 'Ejalong   60 mg', '210-0622-014', 'Tablet', 'Drug International Ltd.', '40.00', '0.00', '60 mg', 'Dapoxetine'), 
('4415', 'Mycofree   250 mg', '210-0623', 'Tablet', 'Drug International Ltd.', '25.00', '0.00', '250 mg', 'Terbinafine'), 
('4416', 'Floxalone0   400 mg', '210-0631-23', 'Tablet', 'Drug International Ltd.', '30.00', '0.00', '400 mg', 'Moxifloxacin'), 
('4417', 'Block-T0   500 mg', '210-06339', 'Tablet', 'Drug International Ltd.', '15.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('4418', 'Palnox.5   .5 mg', '210-06358', 'Tablet', 'Drug International Ltd.', '10.00', '0.00', '.5 mg', 'Palonosetron'), 
('4419', 'Doxoma   400 mg', '210-06374', 'Tablet', 'Drug International Ltd.', '6.00', '0.00', '400 mg', 'Doxophylline'), 
('4420', 'Fexofast   60 mg', '210-0639-21', 'Tablet', 'Drug International Ltd.', '3.50', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('4421', 'Fexofast   30 mg', '210-0640-21', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '30 mg', 'Fexofenadine Hydrochloride'), 
('4422', 'Ezitab   10 mg', '210-0642-61', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '10 mg', 'Ezetimibe'), 
('4423', 'Sixtin   2.5 mg', '210-0643', 'Tablet', 'Drug International Ltd.', '16.00', '0.00', '2.5 mg', 'Saxagliptin'), 
('4424', 'Sixtin   5 mg', '210-0644', 'Tablet', 'Drug International Ltd.', '30.00', '0.00', '5 mg', 'Saxagliptin'), 
('4425', 'D-Pira   800 mg', '210-0655', 'Tablet', 'Drug International Ltd.', '6.00', '0.00', '800 mg', 'Piracetam'), 
('4426', 'Anilic   200 mg', '210-06567', 'Tablet', 'Drug International Ltd.', '8.00', '0.00', '200 mg', 'Tolfenamic Acid'), 
('4427', 'HopSo   400 mg', '210-0658-32', 'Tablet', 'Drug International Ltd.', '450.00', '0.00', '400 mg', 'Sofosbuvir'), 
('4428', 'Cikolin0   500 mg', '210-0662-36', 'Tablet', 'Drug International Ltd.', '50.00', '0.00', '500 mg', 'Citicoline'), 
('4429', 'Canarol0   100 mg', '210-0663-', 'Tablet', 'Drug International Ltd.', '60.00', '0.00', '100 mg', 'Canagliflozin'), 
('4430', 'Daparol   5 mg', '210-0665-', 'Tablet', 'Drug International Ltd.', '15.00', '0.00', '5 mg', 'Dapagliflozin'), 
('4431', 'Migon   5 mg', '210-06677', 'Tablet', 'Drug International Ltd.', '3.00', '0.00', '5 mg', 'Flunarizine'), 
('4432', 'Migon   10 mg', '210-06687', 'Tablet', 'Drug International Ltd.', '5.00', '0.00', '10 mg', 'Flunarizine'), 
('4433', 'Resant   15 mg', '210-06704', 'Tablet', 'Drug International Ltd.', '6.00', '0.00', '15 mg', 'Mirtazapine'), 
('4434', 'Nalipsy   200 mg', '210-06716', 'Tablet', 'Drug International Ltd.', '3.00', '0.00', '200 mg', 'Sodium Valproate'), 
('4435', 'Pancil   100 mg', '210-0672-36', 'Tablet', 'Drug International Ltd.', '12.00', '0.00', '100 mg', 'Cilostazol'), 
('4436', 'Tanzil   40 mg', '210-0681-22', 'Tablet', 'Drug International Ltd.', '12.00', '0.00', '40 mg', 'Azilsartan Medoxomil'), 
('4437', 'Nebifast   2.5 mg', '210-0682-22', 'Tablet', 'Drug International Ltd.', '6.00', '0.00', '2.5 mg', 'Nebivolol'), 
('4438', 'Nebifast   5 mg', '210-0683-22', 'Tablet', 'Drug International Ltd.', '8.00', '0.00', '5 mg', 'Nebivolol'), 
('4439', 'Rantoin   100 mg', '210-0693-23', 'Tablet', 'Drug International Ltd.', '6.00', '0.00', '100 mg', 'Nitrofurantoin'), 
('4440', 'Cavelon 3.125   3.125 mg', '210-0694-22', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '3.125 mg', 'Carvedilol'), 
('4441', 'Doxoma   200 mg', '210-07024', 'Tablet', 'Drug International Ltd.', '4.00', '0.00', '200 mg', 'Doxophylline'), 
('4442', 'Nimoral   30 mg', '210-0704-22', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '30 mg', 'Nimodipine'), 
('4443', 'Irricol   10 mg', '210-07061', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '10 mg', 'Dicycloverine Hydrochloride'), 
('4444', 'Varox   2.5 mg', '210-07262', 'Tablet', 'Drug International Ltd.', '6.00', '0.00', '2.5 mg', 'Rivaroxaban'), 
('4445', 'Nabucox   500 mg', '210-0725-64', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '500 mg', 'Nabumetone'), 
('4446', 'Labetol   200 mg', '210-0721-22', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '200 mg', 'Labetalol Hydrochloride'), 
('4447', 'Labetol   100 mg', '210-0720-22', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '100 mg', 'Labetalol Hydrochloride'), 
('4448', 'Aria   10 mg', '210-0718-28', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '10 mg', 'Aripiprazole'), 
('4449', 'Aria   15 mg', '210-0719-28', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '15 mg', 'Aripiprazole'), 
('4450', 'Pednisol   20 mg', '210-005-07', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '20 mg', 'Prednisolone'), 
('4451', 'Aprila   30 mg', '210-0705-064', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '30 mg', 'Apremilast'), 
('4452', 'Tocit   5 mg', '210-0727-058', 'Tablet', 'Drug International Ltd.', '35.00', '0.00', '5 mg', 'Tofacitinib'), 
('4453', 'Foly   15 mg', '210-0729-045', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '15 mg', 'Folinic Acid'), 
('4454', 'Mydipin   5 mg', '210-0731-022', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '5 mg', 'Cilnidipine'), 
('4455', 'Mydipin   10 mg', '210-0732-022', 'Tablet', 'Drug International Ltd.', '0.00', '0.00', '10 mg', 'Cilnidipine'), 
('4456', 'Dicephin  IM   1 gm', '210-0126-23', 'IM Injection', 'Drug International Ltd.', '190.60', '0.00', '1 gm', 'Ceftriaxone'), 
('4457', 'Dicephin  IM   500 mg', '210-0123-23', 'IM Injection', 'Drug International Ltd.', '130.45', '0.00', '500 mg', 'Ceftriaxone'), 
('4458', 'Dicephin  IM  mg   250 mg', '210-0122-23', 'IM Injection', 'Drug International Ltd.', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('4459', 'Dicephin   IM   2 gm', '210-0349-23', 'IM Injection', 'Drug International Ltd.', '0.00', '0.00', '2 gm', 'Ceftriaxone'), 
('4460', 'Dicephin  IV   500 mg', '210-0125-23', 'IV Injection', 'Drug International Ltd.', '130.45', '0.00', '500 mg', 'Ceftriaxone'), 
('4461', 'Dicephin  IV   1 gm', '210-0127-23', 'IV Injection', 'Drug International Ltd.', '190.60', '0.00', '1 gm', 'Ceftriaxone'), 
('4462', 'Dicephin  IV  mg   250 mg', '210-0124-23', 'IV Injection', 'Drug International Ltd.', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('4463', 'Dicephin  IV  gm   2 gm', '210-0348-23', 'IV Injection', 'Drug International Ltd.', '301.00', '0.00', '2 gm', 'Ceftriaxone'), 
('4464', 'Nutris-S   5 %', '210-0432-3', 'IV Infusion', 'Drug International Ltd.', '0.00', '0.00', '5 %', 'Amino Acids (Essential)'), 
('4465', 'Liazol   .05 %', '210-06492', 'Nasal Drops', 'Drug International Ltd.', '0.00', '0.00', '.05 %', 'Oxymetazoline Hydrochloride'), 
('4466', 'Liazol   .025 %', '210-06502', 'Nasal Drops', 'Drug International Ltd.', '0.00', '0.00', '.025 %', 'Oxymetazoline Hydrochloride'), 
('4467', 'Non Pareil Seed   100 %', '210-0193-034', 'Raw Materials', 'Drug International Ltd.', '0.00', '0.00', '100 %', 'Non Pareil Seed'), 
('4468', 'Fenat .025%   .025 %', '210-03282', 'Eye Drops', 'Drug International Ltd.', '95.30', '0.00', '.025 %', 'Ketotifen'), 
('4469', 'Pilopes   2 %', '210-05692', 'Eye Drops', 'Drug International Ltd.', '0.00', '0.00', '2 %', 'Pilocarpine Hydrochloride'), 
('4470', 'F-Lon   .1 %', '210-06252', 'Eye Drops', 'Drug International Ltd.', '80.00', '0.00', '.1 %', 'Fluorometholone'), 
('4471', 'Meverine SR   200 mg', '210-05151', 'Sr Capsule', 'Drug International Ltd.', '10.05', '0.00', '200 mg', 'Mebeverine Hydrochloride'), 
('4472', 'Oramet SR gm   1 gm', '210-0547', 'Xr Tablet', 'Drug International Ltd.', '7.05', '0.00', '1 gm', 'Metformin Hydrochloride'), 
('4473', 'Iragon   25 mg', '210-0717-01', 'Er Tablet', 'Drug International Ltd.', '30.00', '0.00', '25 mg', 'Mirabegron'), 
('4474', 'Seravent HFA   25 mcg', '210-06144', 'Inhalation Aerosol', 'Drug International Ltd.', '200.00', '0.00', '25 mcg', 'Salmeterol'), 
('4475', 'Ondason ODT   4 mg', '210-05898', 'Orodispersible Tablet', 'Drug International Ltd.', '5.05', '0.00', '4 mg', 'Ondansetron'), 
('4476', 'Ondason ODT 8   8 mg', '210-05908', 'Orodispersible Tablet', 'Drug International Ltd.', '10.05', '0.00', '8 mg', 'Ondansetron'), 
('4477', 'Ciprozid  XR   1 gm', '210-0407-23', 'Sr Tablet', 'Drug International Ltd.', '20.10', '0.00', '1 gm', 'Ciprofloxacin'), 
('4478', 'Canasa   400 mg', '210-0651-64', 'Dr Tablet', 'Drug International Ltd.', '0.00', '0.00', '400 mg', 'Mesalamine'), 
('4479', 'Demoxil0   500 mg', '309-0001-23', 'Capsule', 'Drug International Ltd. Unit-2', '6.27', '0.00', '500 mg', 'Amoxicillin'), 
('4480', 'T-Cef   200 mg', '309-0005-23', 'Capsule', 'Drug International Ltd. Unit-2', '30.10', '0.00', '200 mg', 'Cefixime'), 
('4481', 'Dicef0   500 mg', '309-0011-23', 'Capsule', 'Drug International Ltd. Unit-2', '13.05', '0.00', '500 mg', 'Cephradine'), 
('4482', 'Demoxil   250 mg', '309-0017-023', 'Capsule', 'Drug International Ltd. Unit-2', '3.52', '0.00', '250 mg', 'Amoxicillin'), 
('4483', 'Flupen0   500 mg', '309-0019-23', 'Capsule', 'Drug International Ltd. Unit-2', '10.55', '0.00', '500 mg', 'Flucloxacillin'), 
('4484', 'Dicef   250 mg', '309-0021-023', 'Capsule', 'Drug International Ltd. Unit-2', '7.05', '0.00', '250 mg', 'Cephradine'), 
('4485', 'T-Cef0   400 mg', '309-0026-23', 'Capsule', 'Drug International Ltd. Unit-2', '50.20', '0.00', '400 mg', 'Cefixime'), 
('4486', 'Flupen   250 mg', '309-0036-23', 'Capsule', 'Drug International Ltd. Unit-2', '5.05', '0.00', '250 mg', 'Flucloxacillin'), 
('4487', 'Sefanid0   500 mg', '309-0037-23', 'Capsule', 'Drug International Ltd. Unit-2', '12.05', '0.00', '500 mg', 'Cefadroxil'), 
('4488', 'Butibac   400 mg', '309-0051-23', 'Capsule', 'Drug International Ltd. Unit-2', '120.00', '0.00', '400 mg', 'Ceftibuten'), 
('4489', 'Mylostat   500 mg', '309-0079-23', 'Capsule', 'Drug International Ltd. Unit-2', '14.00', '0.00', '500 mg', 'Hydroxyurea'), 
('4490', 'Toposar   50 mg', '309-0096-010', 'Capsule', 'Drug International Ltd. Unit-2', '0.00', '0.00', '50 mg', 'Etoposide'), 
('4491', 'Sutinib   50 mg', '309-0097-010', 'Capsule', 'Drug International Ltd. Unit-2', '0.00', '0.00', '50 mg', 'Sunitinib'), 
('4492', 'Water for Injection   10 ml', '309-0054-79', 'Injection', 'Drug International Ltd. Unit-2', '5.00', '0.00', '10 ml', 'Water For Injection'), 
('4493', 'Furex0   500 mg', '309-0007-23', 'Tablet', 'Drug International Ltd. Unit-2', '45.15', '0.00', '500 mg', 'Cefuroxime'), 
('4494', 'Furex   250 mg', '309-0022-23', 'Tablet', 'Drug International Ltd. Unit-2', '25.10', '0.00', '250 mg', 'Cefuroxime'), 
('4495', 'Ceforan   100 mg', '309-0041-23', 'Tablet', 'Drug International Ltd. Unit-2', '17.05', '0.00', '100 mg', 'Cefpodoxime'), 
('4496', 'Ceforan   200 mg', '309-0042-23', 'Tablet', 'Drug International Ltd. Unit-2', '28.10', '0.00', '200 mg', 'Cefpodoxime'), 
('4497', 'Meth   2.5 mg', '309-0082', 'Tablet', 'Drug International Ltd. Unit-2', '4.00', '0.00', '2.5 mg', 'Methotrexate'), 
('4498', 'Meth   10 mg', '309-0083', 'Tablet', 'Drug International Ltd. Unit-2', '12.00', '0.00', '10 mg', 'Methotrexate'), 
('4499', 'Bicalon   50 mg', '309-0078', 'Tablet', 'Drug International Ltd. Unit-2', '30.00', '0.00', '50 mg', 'Bicalutamide'), 
('4500', 'Pednisol   5 mg', '309-0084-72', 'Tablet', 'Drug International Ltd. Unit-2', '1.72', '0.00', '5 mg', 'Prednisolone'), 
('4501', 'Pednisol   20 mg', '309-0059-072', 'Tablet', 'Drug International Ltd. Unit-2', '6.27', '0.00', '20 mg', 'Prednisolone'), 
('4502', 'Cabita   500 mg', '309-0063-010', 'Tablet', 'Drug International Ltd. Unit-2', '100.00', '0.00', '500 mg', 'Capecitabine'), 
('4503', 'Depomed   4 mg', '309-0087-072', 'Tablet', 'Drug International Ltd. Unit-2', '0.00', '0.00', '4 mg', 'Methyl Prednisolone'), 
('4504', 'Pednisol   10 mg', '309-0088-072', 'Tablet', 'Drug International Ltd. Unit-2', '3.23', '0.00', '10 mg', 'Prednisolone'), 
('4505', 'Dezco   6 mg', '309-0089-072', 'Tablet', 'Drug International Ltd. Unit-2', '0.00', '0.00', '6 mg', 'Deflazacort'), 
('4506', 'Sonib   200 mg', '309-0091-010', 'Tablet', 'Drug International Ltd. Unit-2', '0.00', '0.00', '200 mg', 'Sorafenib'), 
('4507', 'Topocef   200 mg', '309-0092-023', 'Tablet', 'Drug International Ltd. Unit-2', '0.00', '0.00', '200 mg', 'Cefditoren'), 
('4508', 'Anacare   1 mg', '309-0101-010', 'Tablet', 'Drug International Ltd. Unit-2', '0.00', '0.00', '1 mg', 'Anastrozol'), 
('4509', 'Getinib   250 mg', '309-0098-010', 'Tablet', 'Drug International Ltd. Unit-2', '0.00', '0.00', '250 mg', 'Gefitinib'), 
('4510', 'Osinib   80 mg', '309-0099-010', 'Tablet', 'Drug International Ltd. Unit-2', '0.00', '0.00', '80 mg', 'Osimertinib'), 
('4511', 'Dicephin   250 mg', '309-0013-23', 'IM Injection', 'Drug International Ltd. Unit-2', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('4512', 'Dicephin0   500 mg', '309-0015-23', 'IM Injection', 'Drug International Ltd. Unit-2', '130.45', '0.00', '500 mg', 'Ceftriaxone'), 
('4513', 'Dicephin gm   1 gm', '309-0031-23', 'IM Injection', 'Drug International Ltd. Unit-2', '190.60', '0.00', '1 gm', 'Ceftriaxone'), 
('4514', 'Dicephin   250 mg', '309-0014-23', 'IV Injection', 'Drug International Ltd. Unit-2', '100.30', '0.00', '250 mg', 'Ceftriaxone'), 
('4515', 'Dicephin0   500 mg', '309-0016-23', 'IV Injection', 'Drug International Ltd. Unit-2', '130.45', '0.00', '500 mg', 'Ceftriaxone'), 
('4516', 'Dicephin gm   1 gm', '309-0032-23', 'IV Injection', 'Drug International Ltd. Unit-2', '190.60', '0.00', '1 gm', 'Ceftriaxone'), 
('4517', 'Dicephin gm   2 gm', '309-0033-23', 'IV Injection', 'Drug International Ltd. Unit-2', '301.00', '0.00', '2 gm', 'Ceftriaxone'), 
('4518', 'Amoxicillin Trihydrate   100 %', '309-0001-034', 'Raw Materials', 'Drug International Ltd. Unit-2', '0.00', '0.00', '100 %', 'Amoxicillin Trihydrate'), 
('4519', 'Ampicillin   100 %', '309-0004-034', 'Raw Materials', 'Drug International Ltd. Unit-2', '0.00', '0.00', '100 %', 'Ampicillin Trihydrate'), 
('4520', 'Cephalexin   100 %', '309-0002-034', 'Raw Materials', 'Drug International Ltd. Unit-2', '0.00', '0.00', '100 %', 'Cephalexin'), 
('4521', 'Cephradine   100 %', '309-0005-034', 'Raw Materials', 'Drug International Ltd. Unit-2', '0.00', '0.00', '100 %', 'Cephradine'), 
('4522', 'Cloxacillin   100 %', '309-0003-034', 'Raw Materials', 'Drug International Ltd. Unit-2', '0.00', '0.00', '100 %', 'Cloxacillin'), 
('4523', 'Flucloxacillin   100 %', '309-0006-034', 'Raw Materials', 'Drug International Ltd. Unit-2', '0.00', '0.00', '100 %', 'Flucloxacillin Sodium'), 
('4524', 'Indomethacin   25 mg', '234-0033-64', 'Capsule', 'EDCL (Bogra)', '0.69', '0.00', '25 mg', 'Indomethacin'), 
('4525', 'Aspirin0   300 mg', '234-0014-6', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '300 mg', 'Aspirin'), 
('4526', 'Chloroquine Phosphat   250 mg', '234-0017-24', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '250 mg', 'Chloroquine Phosphate'), 
('4527', 'Chlorpheniramine Maleate   4 mg', '234-0009-21', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('4528', 'Diazepam      5 mg', '234-0005-057', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '5 mg', 'Diazepam'), 
('4529', 'Ephedrine   30 mg', '234-0019', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '30 mg', 'Ephedrine Hydrochloride'), 
('4530', 'Ethambutol      400 mg', '234-0006-30', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '400 mg', 'Ethambutol'), 
('4531', 'Frusemide      40 mg', '234-00042', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '40 mg', 'Frusemide'), 
('4532', 'Levamisole      40 mg', '234-0001-8', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '40 mg', 'Levamisole'), 
('4533', 'Mebendazole      100 mg', '234-0002-8', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '100 mg', 'Mebendazole'), 
('4534', 'Metronidazole      200 mg', '234-0010-27', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '200 mg', 'Metronidazole'), 
('4535', 'Metronidazole   400 mg', '234-0011-27', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('4536', 'Paracetamol   500 mg', '234-0012-006', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('4537', 'Phenobarbitone   30 mg', '234-0018-046', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '30 mg', 'Phenobarbitone'), 
('4538', 'Propranolol   10 mg', '234-0007-23', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '10 mg', 'Propranolol Hydrochloride'), 
('4539', 'Calcium Carbonate   625 mg', '234-0046-62', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '625 mg', 'Calcium Carbonate'), 
('4540', 'Albendazole   400 mg', '234-0047-008', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '400 mg', 'Albendazole'), 
('4541', 'Salbutamol   4 mg', '234-00484', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '4 mg', 'Salbutamol'), 
('4542', 'Hyoscine Butyl Bromide   10 mg', '234-00501', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('4543', 'Diethylcarbamazine      100 mg', '234-0051-8', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '100 mg', 'Diethylcarbamazine Citrate'), 
('4544', 'Cetirizine   10 mg', '234-0235-21', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('4545', 'Lamivudine   150 mg', '234-0237-32', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '150 mg', 'Lamivudine'), 
('4546', 'Levofloxacin0   500 mg', '234-0070-23', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('4547', 'Pantoprazole   40 mg', '234-0068-67', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '40 mg', 'Pantoprazole'), 
('4548', 'Pantoprazole   20 mg', '234-0069-67', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '20 mg', 'Pantoprazole'), 
('4549', 'Azithromycin0   500 mg', '234-0071-23', 'Tablet', 'EDCL (Bogra)', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('4550', 'Amoxycillin   250 mg', '127-0116-023', 'Capsule', 'EDCL (Dhaka)', '2.59', '0.00', '250 mg', 'Amoxicillin'), 
('4551', 'Amoxycillin   500 mg', '127-0169-23', 'Capsule', 'EDCL (Dhaka)', '5.26', '0.00', '500 mg', 'Amoxicillin'), 
('4552', 'Ampicillin   250 mg', '127-0025-23', 'Capsule', 'EDCL (Dhaka)', '2.00', '0.00', '250 mg', 'Ampicillin'), 
('4553', 'Cephalexin   250 mg', '127-0150-23', 'Capsule', 'EDCL (Dhaka)', '4.42', '0.00', '250 mg', 'Cephalexin'), 
('4554', 'Cephradine   250 mg', '127-0139-023', 'Capsule', 'EDCL (Dhaka)', '5.46', '0.00', '250 mg', 'Cephradine'), 
('4555', 'Cephradine   500 mg', '127-0140-23', 'Capsule', 'EDCL (Dhaka)', '11.22', '0.00', '500 mg', 'Cephradine'), 
('4556', 'Cloxacillin   500 mg', '127-0093-23', 'Capsule', 'EDCL (Dhaka)', '3.27', '0.00', '500 mg', 'Cloxacillin'), 
('4557', 'Doxycycline      100 mg', '127-0138-23', 'Capsule', 'EDCL (Dhaka)', '1.83', '0.00', '100 mg', 'Doxycycline'), 
('4558', 'Indomethacin   25 mg', '127-0023-64', 'Capsule', 'EDCL (Dhaka)', '0.58', '0.00', '25 mg', 'Indomethacin'), 
('4559', 'Methyldopa   250 mg', '127-0131-22', 'Capsule', 'EDCL (Dhaka)', '0.00', '0.00', '250 mg', 'Methyldopa'), 
('4560', 'Rifampicin      150 mg', '127-010-30', 'Capsule', 'EDCL (Dhaka)', '2.30', '0.00', '150 mg', 'Rifampicin'), 
('4561', 'Rifampicin50   450 mg', '127-0102-30', 'Capsule', 'EDCL (Dhaka)', '4.23', '0.00', '450 mg', 'Rifampicin'), 
('4562', 'Tetracycline   250 mg', '127-0017-23', 'Capsule', 'EDCL (Dhaka)', '0.56', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('4563', 'Cephalexin   500 mg', '127-0186-23', 'Capsule', 'EDCL (Dhaka)', '7.63', '0.00', '500 mg', 'Cephalexin'), 
('4564', 'Ampicillin   500 mg', '127-0187-23', 'Capsule', 'EDCL (Dhaka)', '0.00', '0.00', '500 mg', 'Ampicillin'), 
('4565', 'Flucloxacillin   250 mg', '127-0191-23', 'Capsule', 'EDCL (Dhaka)', '3.35', '0.00', '250 mg', 'Flucloxacillin'), 
('4566', 'Flucloxacillin   500 mg', '127-0192-23', 'Capsule', 'EDCL (Dhaka)', '6.40', '0.00', '500 mg', 'Flucloxacillin'), 
('4567', 'Omeprazole      20 mg', '127-0200-67', 'Capsule', 'EDCL (Dhaka)', '2.00', '0.00', '20 mg', 'Omeprazole'), 
('4568', 'Oseltamivir   75 mg', '127-0216-32', 'Capsule', 'EDCL (Dhaka)', '94.80', '0.00', '75 mg', 'Oseltamivir'), 
('4569', 'Azithromycin   500 mg', '127-0234-23', 'Capsule', 'EDCL (Dhaka)', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('4570', 'Omeprazole   40 mg', '127-0223-67', 'Capsule', 'EDCL (Dhaka)', '2.41', '0.00', '40 mg', 'Omeprazole'), 
('4571', 'Azithromycin   250 mg', '127-0208-23', 'Capsule', 'EDCL (Dhaka)', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('4572', 'Cefpodoxime   200 mg', '127-0242-23', 'Capsule', 'EDCL (Dhaka)', '0.00', '0.00', '200 mg', 'Cefpodoxime'), 
('4573', 'Cefixime   200 mg', '127-0245-23', 'Capsule', 'EDCL (Dhaka)', '19.00', '0.00', '200 mg', 'Cefixime'), 
('4574', 'Cefpodoxime   100 mg', '127-0246-23', 'Capsule', 'EDCL (Dhaka)', '0.00', '0.00', '100 mg', 'Cefpodoxime'), 
('4575', 'Fluconazole   50 mg', '127-0253', 'Capsule', 'EDCL (Dhaka)', '3.50', '0.00', '50 mg', 'Fluconazole'), 
('4576', 'Fluconazole   150 mg', '127-0254', 'Capsule', 'EDCL (Dhaka)', '8.00', '0.00', '150 mg', 'Fluconazole'), 
('4577', 'Tetracycline   500 mg', '127-0269-23', 'Capsule', 'EDCL (Dhaka)', '0.00', '0.00', '500 mg', 'Tetracycline Hydrochloride'), 
('4578', 'Cefixime   400 mg', '127-0291-23', 'Capsule', 'EDCL (Dhaka)', '25.00', '0.00', '400 mg', 'Cefixime'), 
('4579', 'Esomeprazole   20 mg', '127-0304-067', 'Capsule', 'EDCL (Dhaka)', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('4580', 'Rifampicin Capsule   150 mg', '127-0038-030', 'Capsule', 'EDCL (Dhaka)', '0.00', '0.00', '150 mg', 'Rifampicin'), 
('4581', 'Silver Sulfadiazine   1 %', '127-0227-23', 'Cream', 'EDCL (Dhaka)', '0.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('4582', 'Water For Injection   5 ml', '127-0016-79', 'Injection', 'EDCL (Dhaka)', '4.49', '0.00', '5 ml', 'Water For Injection'), 
('4583', 'Gentian Violet   100 %', '127-0167-71', 'Powder', 'EDCL (Dhaka)', '0.00', '0.00', '100 %', 'Gentian Violet'), 
('4584', 'Retinol LAC   2 Lac IU', '127-0095-78', 'Soft Gelatin Capsule', 'EDCL (Dhaka)', '0.00', '0.00', '2 Lac IU', 'Vitamin A'), 
('4585', 'Albendazole      200 mg', '127-0128-008', 'Tablet', 'EDCL (Dhaka)', '1.15', '0.00', '200 mg', 'Albendazole'), 
('4586', 'Aminophylline      100 mg', '127-01754', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '100 mg', 'Aminophylline'), 
('4587', 'Calcium Carbonate   625 mg', '127-0180-62', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '625 mg', 'Calcium Carbonate'), 
('4588', 'Calcium Lactate   300 mg', '127-0176-62', 'Tablet', 'EDCL (Dhaka)', '0.18', '0.00', '300 mg', 'Calcium Lactate'), 
('4589', 'Chloroquine   250 mg', '127-0004-24', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '250 mg', 'Chloroquine Phosphate'), 
('4590', 'Chloropheniramine   4 mg', '127-0027-21', 'Tablet', 'EDCL (Dhaka)', '0.11', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('4591', 'Ciprofloxacin   250 mg', '127-0170-23', 'Tablet', 'EDCL (Dhaka)', '4.75', '0.00', '250 mg', 'Ciprofloxacin'), 
('4592', 'Ciprofloxacin   500 mg', '127-0171-23', 'Tablet', 'EDCL (Dhaka)', '8.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('4593', 'Diazepam      5 mg', '127-0031-057', 'Tablet', 'EDCL (Dhaka)', '0.12', '0.00', '5 mg', 'Diazepam'), 
('4594', 'Ephedrine   15 mg', '127-0091', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '15 mg', 'Ephedrine Hydrochloride'), 
('4595', 'Ephedrine   30 mg', '127-0006', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '30 mg', 'Ephedrine Hydrochloride'), 
('4596', 'Ergometrine   200 mcg', '127-00909', 'Tablet', 'EDCL (Dhaka)', '0.25', '0.00', '200 mcg', 'Ergometrine Maleate'), 
('4597', 'Erythromycin   250 mg', '127-0158-23', 'Tablet', 'EDCL (Dhaka)', '3.43', '0.00', '250 mg', 'Erythromycin'), 
('4598', 'Ethambutol   400 mg', '127-0032-30', 'Tablet', 'EDCL (Dhaka)', '1.52', '0.00', '400 mg', 'Ethambutol'), 
('4599', 'Folic Acid   5 mg', '127-01495', 'Tablet', 'EDCL (Dhaka)', '0.10', '0.00', '5 mg', 'Folic Acid'), 
('4600', 'Frusemide      40 mg', '127-00852', 'Tablet', 'EDCL (Dhaka)', '0.40', '0.00', '40 mg', 'Frusemide'), 
('4601', 'Grisofulvin   500 mg', '127-0088', 'Tablet', 'EDCL (Dhaka)', '5.00', '0.00', '500 mg', 'Griseofulvin'), 
('4602', 'Halazone   15 mg', '127-0107', 'Tablet', 'EDCL (Dhaka)', '0.23', '0.00', '15 mg', 'Halazone'), 
('4603', 'Hyoscine Butyl Bromide   10 mg', '127-00871', 'Tablet', 'EDCL (Dhaka)', '1.81', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('4604', 'Isoniazid      100 mg', '127-0097-30', 'Tablet', 'EDCL (Dhaka)', '0.31', '0.00', '100 mg', 'Isoniazid'), 
('4605', 'Isoniazid0   300 mg', '127-0098-30', 'Tablet', 'EDCL (Dhaka)', '0.92', '0.00', '300 mg', 'Isoniazid'), 
('4606', 'Levamisole   40 mg', '127-0035-8', 'Tablet', 'EDCL (Dhaka)', '0.22', '0.00', '40 mg', 'Levamisole'), 
('4607', 'Mebendazole      100 mg', '127-0036-8', 'Tablet', 'EDCL (Dhaka)', '0.49', '0.00', '100 mg', 'Mebendazole'), 
('4608', 'Mebendazole   500 mg', '127-0153-8', 'Tablet', 'EDCL (Dhaka)', '1.17', '0.00', '500 mg', 'Mebendazole'), 
('4609', 'Methyl Ergometrine   125 mcg', '127-01259', 'Tablet', 'EDCL (Dhaka)', '0.58', '0.00', '125 mcg', 'Methyl Ergometrine Maleate'), 
('4610', 'Metronidazole      200 mg', '127-0026-27', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '200 mg', 'Metronidazole'), 
('4611', 'Metronidazole   400 mg', '127-0020-27', 'Tablet', 'EDCL (Dhaka)', '0.56', '0.00', '400 mg', 'Metronidazole'), 
('4612', 'Nalidixic Acid   500 mg', '127-0122-23', 'Tablet', 'EDCL (Dhaka)', '3.41', '0.00', '500 mg', 'Nalidixic Acid'), 
('4613', 'Paracetamol   500 mg', '127-0019-006', 'Tablet', 'EDCL (Dhaka)', '0.30', '0.00', '500 mg', 'Paracetamol'), 
('4614', 'Phenoxymethylpenicillin   250 mg', '127-0022-23', 'Tablet', 'EDCL (Dhaka)', '1.48', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('4615', 'Phenobarbitone   30 mg', '127-0005-046', 'Tablet', 'EDCL (Dhaka)', '0.53', '0.00', '30 mg', 'Phenobarbitone'), 
('4616', 'Propranolol      40 mg', '127-0110-23', 'Tablet', 'EDCL (Dhaka)', '0.17', '0.00', '40 mg', 'Propranolol Hydrochloride'), 
('4617', 'Pyrazinamide   500 mg', '127-0099-30', 'Tablet', 'EDCL (Dhaka)', '1.97', '0.00', '500 mg', 'Pyrazinamide'), 
('4618', 'Pyridoxine      20 mg', '127-0111-78', 'Tablet', 'EDCL (Dhaka)', '0.13', '0.00', '20 mg', 'Pyridoxine Hydrochloride'), 
('4619', 'Ranitidine0   300 mg', '127-01735', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '300 mg', 'Ranitidine'), 
('4620', 'Riboflavine   5 mg', '127-0124-79', 'Tablet', 'EDCL (Dhaka)', '0.17', '0.00', '5 mg', 'Riboflavin'), 
('4621', 'Salbutamol   4 mg', '127-01214', 'Tablet', 'EDCL (Dhaka)', '0.15', '0.00', '4 mg', 'Salbutamol'), 
('4622', 'Sulphadimidine   500 mg', '127-0013-023', 'Tablet', 'EDCL (Dhaka)', '0.16', '0.00', '500 mg', 'Sulphadimidine'), 
('4623', 'Propanolol   10 mg', '127-0033-23', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '10 mg', 'Propranolol Hydrochloride'), 
('4624', 'Vitamin B1      100 mg', '127-0047-78', 'Tablet', 'EDCL (Dhaka)', '0.57', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('4625', 'Vitamin C   250 mg', '127-0144-78', 'Tablet', 'EDCL (Dhaka)', '1.25', '0.00', '250 mg', 'Vitamin C'), 
('4626', 'Dapsone      100 mg', '127-0136-030', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '100 mg', 'Dapsone'), 
('4627', 'Aspirin0   300 mg', '127-0001-6', 'Tablet', 'EDCL (Dhaka)', '1.00', '0.00', '300 mg', 'Aspirin'), 
('4628', 'Dapsone      50 mg', '127-0135-030', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '50 mg', 'Dapsone'), 
('4629', 'Diethyl Carbamazine   50 mg', '127-0036-8', 'Tablet', 'EDCL (Dhaka)', '0.39', '0.00', '50 mg', 'Diethylcarbamazine Citrate'), 
('4630', 'Albendazole   400 mg', '127-0153-008', 'Tablet', 'EDCL (Dhaka)', '2.80', '0.00', '400 mg', 'Albendazole'), 
('4631', 'Salbutamol   2 mg', '127-01204', 'Tablet', 'EDCL (Dhaka)', '0.18', '0.00', '2 mg', 'Salbutamol'), 
('4632', 'Ranitidine      150 mg', '127-01845', 'Tablet', 'EDCL (Dhaka)', '1.81', '0.00', '150 mg', 'Ranitidine'), 
('4633', 'Diclofenac      50 mg', '127-0183-64', 'Tablet', 'EDCL (Dhaka)', '0.42', '0.00', '50 mg', 'Diclofenac Sodium'), 
('4634', 'Ibuprofen   400 mg', '127-0185-64', 'Tablet', 'EDCL (Dhaka)', '1.32', '0.00', '400 mg', 'Ibuprofen'), 
('4635', 'Mefloquine Hydrochloride   250 mg', '127-0202-24', 'Tablet', 'EDCL (Dhaka)', '35.19', '0.00', '250 mg', 'Mefloquine'), 
('4636', 'Glimepiride   2 mg', '127-0228', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '2 mg', 'Glimepiride'), 
('4637', 'Gliclazide   80 mg', '127-0229', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '80 mg', 'Gliclazide'), 
('4638', 'Glibenclamide   5 mg', '127-0230', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '5 mg', 'Glibenclamide'), 
('4639', 'Amlodipine   10 mg', '127-0233-022', 'Tablet', 'EDCL (Dhaka)', '1.65', '0.00', '10 mg', 'Amlodipine'), 
('4640', 'Metronidazole   250 mg', '127-0089-27', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '250 mg', 'Metronidazole'), 
('4641', 'Drotaverine Tablet   40 mg', '12711', 'Tablet', 'EDCL (Dhaka)', '1.63', '0.00', '40 mg', 'Drotaverine Hydrochloride'), 
('4642', 'Cetrizine   10 mg', '127-0235-21', 'Tablet', 'EDCL (Dhaka)', '1.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('4643', 'Ibuprofen   200 mg', '127-0260-64', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '200 mg', 'Ibuprofen'), 
('4644', 'Loratadine   10 mg', '127-0261-21', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '10 mg', 'Loratadine'), 
('4645', 'Clobazam   10 mg', '127-02626', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '10 mg', 'Clobazam'), 
('4646', 'Domperidone   10 mg', '127-02638', 'Tablet', 'EDCL (Dhaka)', '1.50', '0.00', '10 mg', 'Domperidone'), 
('4647', 'Metoclopramide   10 mg', '127-02648', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '10 mg', 'Metoclopramide Hydrochloride'), 
('4648', 'Potassium Chloride   600 mg', '127-0265-62', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '600 mg', 'Potassium Chloride'), 
('4649', 'Pantoprazole   20 mg', '127-0292-67', 'Tablet', 'EDCL (Dhaka)', '2.40', '0.00', '20 mg', 'Pantoprazole'), 
('4650', 'Pantoprazole   40 mg', '127-0293-67', 'Tablet', 'EDCL (Dhaka)', '3.25', '0.00', '40 mg', 'Pantoprazole'), 
('4651', 'Morphine   15 mg', '127-0294-65', 'Tablet', 'EDCL (Dhaka)', '7.12', '0.00', '15 mg', 'Morphine Sulphate'), 
('4652', 'Azithromycin   500 mg', '127-0210-23', 'Tablet', 'EDCL (Dhaka)', '18.28', '0.00', '500 mg', 'Azithromycin'), 
('4653', 'Erythromycin Stearate   500 mg', '127-0212-23', 'Tablet', 'EDCL (Dhaka)', '7.92', '0.00', '500 mg', 'Erythromycin'), 
('4654', 'Ciprofloxacin   750 mg', '127-0213-23', 'Tablet', 'EDCL (Dhaka)', '5.71', '0.00', '750 mg', 'Ciprofloxacin'), 
('4655', 'Lamiudine   150 mg', '127-0237-32', 'Tablet', 'EDCL (Dhaka)', '0.00', '0.00', '150 mg', 'Lamivudine'), 
('4656', 'Levofloxacin   500 mg', '127-0248-23', 'Tablet', 'EDCL (Dhaka)', '10.73', '0.00', '500 mg', 'Levofloxacin'), 
('4657', 'Zinc Dispersible   20 mg', '127-0205-62', 'Tablet', 'EDCL (Dhaka)', '0.65', '0.00', '20 mg', 'Zinc'), 
('4658', 'Amlodipine   5 mg', '127-0215-022', 'Tablet', 'EDCL (Dhaka)', '0.96', '0.00', '5 mg', 'Amlodipine'), 
('4659', 'Misoprostol   200 mcg', '127-02909', 'Tablet', 'EDCL (Dhaka)', '6.00', '0.00', '200 mcg', 'Misoprostol'), 
('4660', 'Calcium0   1250 mg', '127-0299-62', 'Tablet', 'EDCL (Dhaka)', '1.70', '0.00', '1250 mg', 'Calcium Carbonate'), 
('4661', 'Naproxen   250 mg', '127-0300-64', 'Tablet', 'EDCL (Dhaka)', '4.00', '0.00', '250 mg', 'Naproxen'), 
('4662', 'Naproxen   500 mg', '127-0301-64', 'Tablet', 'EDCL (Dhaka)', '6.00', '0.00', '500 mg', 'Naproxen'), 
('4663', 'Ketorolac Tromethmine   10 mg', '127-0303-064', 'Tablet', 'EDCL (Dhaka)', '5.70', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('4664', 'Diethylocarbamazine   100 mg', '127-0203-008', 'Tablet', 'EDCL (Dhaka)', '0.39', '0.00', '100 mg', 'Diethylcarbamazine Citrate'), 
('4665', 'Ceftriaxone   250 mg', '127-0272-23', 'IM Injection', 'EDCL (Dhaka)', '80.00', '0.00', '250 mg', 'Ceftriaxone'), 
('4666', 'Ceftriaxone   500 mg', '127-0273-23', 'IM Injection', 'EDCL (Dhaka)', '115.00', '0.00', '500 mg', 'Ceftriaxone'), 
('4667', 'Ceftriaxone   1 gm', '127-0275-23', 'IM Injection', 'EDCL (Dhaka)', '134.00', '0.00', '1 gm', 'Ceftriaxone'), 
('4668', 'Ceftriaxone   250 mg', '127-0271-23', 'IV Injection', 'EDCL (Dhaka)', '80.00', '0.00', '250 mg', 'Ceftriaxone'), 
('4669', 'Ceftriaxone   500 mg', '127-0274-23', 'IV Injection', 'EDCL (Dhaka)', '98.00', '0.00', '500 mg', 'Ceftriaxone'), 
('4670', 'Ceftriaxone   2 gm', '127-0277-23', 'IV Injection', 'EDCL (Dhaka)', '175.00', '0.00', '2 gm', 'Ceftriaxone'), 
('4671', 'Dilti  SR    90 mg', '009-0134-22', 'Capsule', 'Edruc Ltd.', '0.00', '0.00', '90 mg', 'Diltiazem Hydrochloride'), 
('4672', 'E Doxy      100 mg', '009-0113-23', 'Capsule', 'Edruc Ltd.', '2.00', '0.00', '100 mg', 'Doxycycline'), 
('4673', 'Eflu   250 mg', '009-0107-23', 'Capsule', 'Edruc Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('4674', 'E Flu   500 mg', '009-0097-23', 'Capsule', 'Edruc Ltd.', '10.11', '0.00', '500 mg', 'Flucloxacillin'), 
('4675', 'E Mox   500 mg', '009-0095-23', 'Capsule', 'Edruc Ltd.', '5.00', '0.00', '500 mg', 'Amoxicillin'), 
('4676', 'Edicef   250 mg', '009-0085-23', 'Capsule', 'Edruc Ltd.', '6.50', '0.00', '250 mg', 'Cephalexin'), 
('4677', 'Edicef   500 mg', '009-0090-23', 'Capsule', 'Edruc Ltd.', '12.14', '0.00', '500 mg', 'Cephalexin'), 
('4678', 'Edifenac  TR    100 mg', '009-0128-64', 'Capsule', 'Edruc Ltd.', '1.80', '0.00', '100 mg', 'Diclofenac Sodium'), 
('4679', 'Edrumycetin   250 mg', '009-0039-23', 'Capsule', 'Edruc Ltd.', '0.00', '0.00', '250 mg', 'Chloramphenicol'), 
('4680', 'Efrad   500 mg', '009-0115-23', 'Capsule', 'Edruc Ltd.', '12.50', '0.00', '500 mg', 'Cephradine'), 
('4681', 'Emez      20 mg', '009-0105-67', 'Capsule', 'Edruc Ltd.', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('4682', 'Vetracin   500 mg', '009-0101-077', 'Capsule', 'Edruc Ltd.', '0.00', '0.00', '500 mg', 'Oxytetracycline'), 
('4683', 'E Mox   250 mg', '009-0060-023', 'Capsule', 'Edruc Ltd.', '3.00', '0.00', '250 mg', 'Amoxicillin'), 
('4684', 'Efrad   250 mg', '009-0125-023', 'Capsule', 'Edruc Ltd.', '6.50', '0.00', '250 mg', 'Cephradine'), 
('4685', 'C - 3      200 mg', '009-0160-23', 'Capsule', 'Edruc Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('4686', 'E - Pod      200 mg', '009-0165-23', 'Capsule', 'Edruc Ltd.', '40.00', '0.00', '200 mg', 'Cefpodoxime'), 
('4687', 'Emez   40 mg', '009-0229-67', 'Capsule', 'Edruc Ltd.', '0.00', '0.00', '40 mg', 'Omeprazole'), 
('4688', 'Xioclin   300 mg', '009-0239-23', 'Capsule', 'Edruc Ltd.', '0.00', '0.00', '300 mg', 'Clindamycin'), 
('4689', 'Dexzole   60 mg', '009-0248-67', 'Capsule', 'Edruc Ltd.', '12.00', '0.00', '60 mg', 'Dexlansoprazole'), 
('4690', 'Dexzole   30 mg', '009-0247-67', 'Capsule', 'Edruc Ltd.', '8.50', '0.00', '30 mg', 'Dexlansoprazole'), 
('4691', 'Urox   100 mg', '009-0251-23', 'Capsule', 'Edruc Ltd.', '18.00', '0.00', '100 mg', 'Nitrofurantoin'), 
('4692', 'Water For Injection   5 ml', '009-0037-79', 'Injection', 'Edruc Ltd.', '3.19', '0.00', '5 ml', 'Water For Injection'), 
('4693', 'E-Lax   68 %', '009-0174-60', 'Oral Solution', 'Edruc Ltd.', '90.00', '0.00', '68 %', 'Lactulose'), 
('4694', '3 F   500 mg', '009-0140-23', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('4695', 'Avastatin   10 mg', '009-0139-061', 'Tablet', 'Edruc Ltd.', '8.00', '0.00', '10 mg', 'Atorvastatin'), 
('4696', 'Cipron   500 mg', '009-0086-23', 'Tablet', 'Edruc Ltd.', '12.15', '0.00', '500 mg', 'Ciprofloxacin'), 
('4697', 'Cytapen V     250 mg', '009-0094-23', 'Tablet', 'Edruc Ltd.', '1.52', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('4698', 'E Ben  DS   400 mg', '009-0093-008', 'Tablet', 'Edruc Ltd.', '3.40', '0.00', '400 mg', 'Albendazole'), 
('4699', 'Ebazam   10 mg', '009-01296', 'Tablet', 'Edruc Ltd.', '2.70', '0.00', '10 mg', 'Clobazam'), 
('4700', 'Edical   1250 mg', '009-0104-62', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('4701', 'Edifenac      50 mg', '009-0084-64', 'Tablet', 'Edruc Ltd.', '0.85', '0.00', '50 mg', 'Diclofenac Sodium'), 
('4702', 'Editin R     150 mg', '009-00835', 'Tablet', 'Edruc Ltd.', '1.10', '0.00', '150 mg', 'Ranitidine'), 
('4703', 'Elo   10 mg', '009-0145-21', 'Tablet', 'Edruc Ltd.', '2.50', '0.00', '10 mg', 'Loratadine'), 
('4704', 'Enol      50 mg', '009-0116-22', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '50 mg', 'Atenolol'), 
('4705', 'Erofen   400 mg', '009-0135-64', 'Tablet', 'Edruc Ltd.', '1.35', '0.00', '400 mg', 'Ibuprofen'), 
('4706', 'Etan      50 mg', '009-0146-022', 'Tablet', 'Edruc Ltd.', '5.00', '0.00', '50 mg', 'Losartan Potassium'), 
('4707', 'Etizin   10 mg', '009-0092-21', 'Tablet', 'Edruc Ltd.', '2.52', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('4708', 'Ezide   80 mg', '009-0142', 'Tablet', 'Edruc Ltd.', '6.00', '0.00', '80 mg', 'Gliclazide'), 
('4709', 'Ezith   500 mg', '009-0133-23', 'Tablet', 'Edruc Ltd.', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('4710', 'Hysin   10 mg', '009-01311', 'Tablet', 'Edruc Ltd.', '3.44', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('4711', 'Lopin      5 mg', '009-0150-022', 'Tablet', 'Edruc Ltd.', '3.00', '0.00', '5 mg', 'Amlodipine'), 
('4712', 'Mega C     250 mg', '009-0011-78', 'Tablet', 'Edruc Ltd.', '0.82', '0.00', '250 mg', 'Vitamin C'), 
('4713', 'Neospin      75 mg', '009-0114-26', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '75 mg', 'Aspirin'), 
('4714', 'Saplox      200 mg', '009-0141-23', 'Tablet', 'Edruc Ltd.', '14.00', '0.00', '200 mg', 'Sparfloxacin'), 
('4715', 'Tricozyl   400 mg', '009-0055-27', 'Tablet', 'Edruc Ltd.', '1.03', '0.00', '400 mg', 'Metronidazole'), 
('4716', 'Tydenol   500 mg', '009-0061-006', 'Tablet', 'Edruc Ltd.', '0.51', '0.00', '500 mg', 'Paracetamol'), 
('4717', 'Vita E     200 mg', '009-0109-78', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '200 mg', 'Vitamin E'), 
('4718', 'Merin   10 mg', '009-01528', 'Tablet', 'Edruc Ltd.', '1.50', '0.00', '10 mg', 'Domperidone'), 
('4719', 'G Phase   850 mg', '009-0155', 'Tablet', 'Edruc Ltd.', '3.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('4720', 'E Ben   400 mg', '009-0154-008', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '400 mg', 'Albendazole'), 
('4721', 'Ecena   100 mg', '009-0157-64', 'Tablet', 'Edruc Ltd.', '3.00', '0.00', '100 mg', 'Aceclofenac'), 
('4722', 'Dex    300 mg', '009-0164-64', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '300 mg', 'Dexibuprofen (S Ibuprofen)'), 
('4723', 'Eket   10 mg', '009-0167-064', 'Tablet', 'Edruc Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('4724', 'Edruson   5 mg', '009-0181-72', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '5 mg', 'Prednisolone'), 
('4725', 'Nolargy   120 mg', '009-0184-21', 'Tablet', 'Edruc Ltd.', '6.50', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('4726', 'Nolargy   180 mg', '009-0185-21', 'Tablet', 'Edruc Ltd.', '9.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('4727', 'Timeth   50 mg', '009-01871', 'Tablet', 'Edruc Ltd.', '4.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('4728', 'Exopan   20 mg', '009-0188-67', 'Tablet', 'Edruc Ltd.', '5.50', '0.00', '20 mg', 'Pantoprazole'), 
('4729', 'Dexison   .5 mg', '009-0189-72', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '.5 mg', 'Dexamethasone'), 
('4730', 'Bactikil   250 mg', '009-0191-23', 'Tablet', 'Edruc Ltd.', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('4731', 'Bactikil0   500 mg', '009-0192-23', 'Tablet', 'Edruc Ltd.', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('4732', 'E-Clop   75 mg', '009-0194-26', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '75 mg', 'Clopidogrel'), 
('4733', 'Relaxil   3 mg', '009-02007', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('4734', 'Migranex   1.5 mg', '009-02017', 'Tablet', 'Edruc Ltd.', '7.00', '0.00', '1.5 mg', 'Pizotifen'), 
('4735', 'Migranex   500 mcg', '009-02027', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '500 mcg', 'Pizotifen'), 
('4736', 'Naproxen   250 mg', '009-0205-64', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '250 mg', 'Naproxen'), 
('4737', 'Naproxen00   500 mg', '009-0206-64', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '500 mg', 'Naproxen'), 
('4738', 'Ezith   250 mg', '009-0209-23', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('4739', 'Alprazolam   .5 mg', '009-02127', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '.5 mg', 'Alprazolam'), 
('4740', 'Amtylin   10 mg', '009-02134', 'Tablet', 'Edruc Ltd.', '0.50', '0.00', '10 mg', 'Amitriptyline Hydrochloride'), 
('4741', 'Amtylin   25 mg', '009-02144', 'Tablet', 'Edruc Ltd.', '1.00', '0.00', '25 mg', 'Amitriptyline Hydrochloride'), 
('4742', 'Grow   20 mg', '009-0216-62', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '20 mg', 'Zinc'), 
('4743', 'Midazam   7.5 mg', '009-0217-057', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '7.5 mg', 'Midazolam'), 
('4744', 'Clonazam   .5 mg', '009-0218-046', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '.5 mg', 'Clonazepam'), 
('4745', 'Esom-E   20 mg', '009-0221-067', 'Tablet', 'Edruc Ltd.', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('4746', 'E-Set   50 mg', '009-02204', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '50 mg', 'Sertraline'), 
('4747', 'Edron   10 mg', '009-0219-044', 'Tablet', 'Edruc Ltd.', '15.00', '0.00', '10 mg', 'Montelukast'), 
('4748', 'Exopan   40 mg', '009-0238-67', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '40 mg', 'Pantoprazole'), 
('4749', 'Etan   100 mg', '009-0237-022', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '100 mg', 'Losartan Potassium'), 
('4750', 'Esom-E   40 mg', '009-0236-67', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '40 mg', 'Esomeprazole'), 
('4751', '3-F0   750 mg', '009-0235-23', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '750 mg', 'Levofloxacin'), 
('4752', '3-C0   400 mg', '009-0230-23', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '400 mg', 'Cefixime'), 
('4753', 'Enol   100 mg', '009-0228-22', 'Tablet', 'Edruc Ltd.', '0.77', '0.00', '100 mg', 'Atenolol'), 
('4754', 'Hysin   20 mg', '009-02271', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '20 mg', 'Hyoscine Butyl Bromide'), 
('4755', 'Editin-R   300 mg', '009-02265', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '300 mg', 'Ranitidine'), 
('4756', 'Lopin   10 mg', '009-0225-022', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '10 mg', 'Amlodipine'), 
('4757', 'Cipron0   750 mg', '009-0224-23', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('4758', 'Bisten   10 mg', '009-0243-22', 'Tablet', 'Edruc Ltd.', '14.00', '0.00', '10 mg', 'Bisoprolol Hemifumarate'), 
('4759', 'Spinax   10 mg', '009-0250-70', 'Tablet', 'Edruc Ltd.', '7.00', '0.00', '10 mg', 'Baclofen'), 
('4760', 'Bisten   2.5 mg', '009-0241-22', 'Tablet', 'Edruc Ltd.', '5.00', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('4761', 'Bisoprolol   5 mg', '009-0242-22', 'Tablet', 'Edruc Ltd.', '0.00', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('4762', 'Kriminash   100 %', '131-0002-077', 'Powder', 'Eon Pharmaceuticals Ltd.', '84.08', '0.00', '100 %', 'Piperazine'), 
('4763', 'Suni-Vet   100 %', '131-0016-077', 'Powder', 'Eon Pharmaceuticals Ltd.', '0.00', '0.00', '100 %', 'Sulphanilamide'), 
('4764', 'Sulcox Powder (Vet)   30 %', '131-0032-077', 'Powder', 'Eon Pharmaceuticals Ltd.', '0.00', '0.00', '30 %', 'Sulfaclozine'), 
('4765', 'TolVet   2 gm', '131-0017-077', 'Bolus', 'Eon Pharmaceuticals Ltd.', '0.00', '0.00', '2 gm', 'Paracetamol'), 
('4766', 'Ovet   500 mg', '131-0018-077', 'Bolus', 'Eon Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Oxytetracycline'), 
('4767', 'Kynol  TR    200 mg', '308-0082-64', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '200 mg', 'Ketoprofen'), 
('4768', 'Kynol  TR    100 mg', '308-0081-64', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '7.00', '0.00', '100 mg', 'Ketoprofen'), 
('4769', 'Losectil      20 mg', '308-0083-67', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '4.00', '0.00', '20 mg', 'Omeprazole'), 
('4770', 'Amboten  SR   75 mg', '308-0108-31', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '75 mg', 'Ambroxol'), 
('4771', 'Sk Flu   75 mg', '308-0153-32', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '55.00', '0.00', '75 mg', 'Oseltamivir'), 
('4772', 'Volmax  SR    100 mg', '308-0267-64', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('4773', 'Deloxi   30 mg', '308-02404', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '30 mg', 'Duloxetine'), 
('4774', 'Deloxi      20 mg', '308-02394', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '20 mg', 'Duloxetine'), 
('4775', 'Deloxi   60 mg', '308-02414', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '60 mg', 'Duloxetine'), 
('4776', 'Urosin   400 mcg', '308-02049', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('4777', 'Losectil      40 mg', '308-0096-67', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '7.00', '0.00', '40 mg', 'Omeprazole'), 
('4778', 'Losectil   10 mg', '308-0095-67', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '2.00', '0.00', '10 mg', 'Omeprazole'), 
('4779', 'Arocef   500 mg', '308-0304-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '15.00', '0.00', '500 mg', 'Cefadroxil'), 
('4780', 'Ceflon   250 mg', '308-0305-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '16.00', '0.00', '250 mg', 'Cefaclor'), 
('4781', 'Ceflon   500 mg', '308-0306-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '30.00', '0.00', '500 mg', 'Cefaclor'), 
('4782', 'Roxim      200 mg', '308-0309-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '35.00', '0.00', '200 mg', 'Cefixime'), 
('4783', 'Roxim   400 mg', '308-0310-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '50.00', '0.00', '400 mg', 'Cefixime'), 
('4784', 'SK-Cef   250 mg', '308-0311-023', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '6.57', '0.00', '250 mg', 'Cephradine'), 
('4785', 'SK-Cef   500 mg', '308-0312-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '13.00', '0.00', '500 mg', 'Cephradine'), 
('4786', 'Starin      100 mg', '308-0313-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '100 mg', 'Cefpodoxime'), 
('4787', 'Starin      200 mg', '308-0314-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '40.00', '0.00', '200 mg', 'Cefpodoxime'), 
('4788', 'Pathozil   500 mg', '308-0315-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '55.00', '0.00', '500 mg', 'Cefprozil'), 
('4789', 'Neorex   250 mg', '308-0308-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '6.60', '0.00', '250 mg', 'Cephalexin'), 
('4790', 'Neorex   500 mg', '308-0307-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '12.50', '0.00', '500 mg', 'Cephalexin'), 
('4791', 'Noficon   200 mg', '308-0378-61', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '7.00', '0.00', '200 mg', 'Fenofibrate'), 
('4792', 'Cednir   300 mg', '308-0374-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '40.00', '0.00', '300 mg', 'Cefdinir'), 
('4793', 'Fibrino   500 mg', '308-04019', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '15.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('4794', 'Lindamax   300 mg', '308-0419-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '15.00', '0.00', '300 mg', 'Clindamycin'), 
('4795', 'Lindamax   150 mg', '308-0418-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '8.00', '0.00', '150 mg', 'Clindamycin'), 
('4796', 'Esoral   40 mg', '308-0428-067', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '9.00', '0.00', '40 mg', 'Esomeprazole'), 
('4797', 'Esoral   20 mg', '308-0427-067', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('4798', 'PG   150 mg', '308-0454-046', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '30.00', '0.00', '150 mg', 'Pregabalin'), 
('4799', 'PG   75 mg', '308-0453-046', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '16.00', '0.00', '75 mg', 'Pregabalin'), 
('4800', 'PG   50 mg', '308-0503-046', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '11.00', '0.00', '50 mg', 'Pregabalin'), 
('4801', 'PG   100 mg', '308-0504-046', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '100 mg', 'Pregabalin'), 
('4802', 'Cefaten   400 mg', '308-0611-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '400 mg', 'Ceftibuten'), 
('4803', 'Palosis   500 mcg', '308-06368', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '20.00', '0.00', '500 mcg', 'Palonosetron'), 
('4804', 'Furantin SR   100 mg', '308-0667-23', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '100 mg', 'Nitrofurantoin'), 
('4805', 'Vomend   40 mg', '308-0679-018', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '40 mg', 'Aprepitant'), 
('4806', 'Flucoder   150 mg', '308-0703-020', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '150 mg', 'Fluconazole'), 
('4807', 'Flucoder   200 mg', '308-0704-020', 'Capsule', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '200 mg', 'Fluconazole'), 
('4808', 'Water for Injection   1 ml', '308-0357-79', 'Injection', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '1 ml', 'Water For Injection'), 
('4809', 'Zithrox IV   500 mg', '308-0405-23', 'Injection', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('4810', '68 %', '308--60', 'Oral Solution', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '68 %', 'Lactulose'), 
('4811', 'Tulac   68 %', '308-0197-60', 'Oral Solution', 'Eskayef Bangladesh Ltd., Tongi', '230.00', '0.00', '68 %', 'Lactulose'), 
('4812', 'Amprol   20 %', '308-0037-077', 'Powder', 'Eskayef Bangladesh Ltd., Tongi', '213.00', '0.00', '20 %', 'Amprolium'), 
('4813', 'Coccino   30 %', '308-0043-077', 'Powder', 'Eskayef Bangladesh Ltd., Tongi', '213.44', '0.00', '30 %', 'Sulfaclozine'), 
('4814', 'Eskamox   20 %', '308-0045-077', 'Powder', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '20 %', 'Amoxicillin'), 
('4815', 'Eskapar0   100 %', '308-0039-077', 'Powder', 'Eskayef Bangladesh Ltd., Tongi', '173.42', '0.00', '100 %', 'Piperazine'), 
('4816', 'Eskcolis   1000 Lac IU', '308-0059-077', 'Powder', 'Eskayef Bangladesh Ltd., Tongi', '153.41', '0.00', '1000 Lac IU', 'Colistin Sulphate'), 
('4817', 'Tialin   45 %', '308-0063-077', 'Powder', 'Eskayef Bangladesh Ltd., Tongi', '1103.06', '0.00', '45 %', 'Tiamulin Hydrogen Fumerate'), 
('4818', 'NRG   100 %', '308-0124-79', 'Powder', 'Eskayef Bangladesh Ltd., Tongi', '5.00', '0.00', '100 %', 'Dextrose'), 
('4819', 'Ridon EG   10 mg', '308-02078', 'Sachet', 'Eskayef Bangladesh Ltd., Tongi', '6.00', '0.00', '10 mg', 'Domperidone'), 
('4820', 'Nelate   2 gm', '308-01948', 'Sachet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '2 gm', 'Strontium Renalate'), 
('4821', 'Ciproflox   10 gm', '308-0061-077', 'Solution', 'Eskayef Bangladesh Ltd., Tongi', '232.58', '0.00', '10 gm', 'Ciprofloxacin'), 
('4822', 'Tamen   250 mg', '308-0257-006', 'Suppository', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '250 mg', 'Paracetamol'), 
('4823', 'Tamen   500 mg', '308-0258-006', 'Suppository', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('4824', 'Nortid   12.5 mg', '308-0259-64', 'Suppository', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '12.5 mg', 'Diclofenac Sodium'), 
('4825', 'Nortid     50 mg', '308-0260-64', 'Suppository', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('4826', 'Dorin   40 mg', '308-00301', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '40 mg', 'Drotaverine Hydrochloride'), 
('4827', 'Ostomaz   70 mg', '308-01588', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '25.00', '0.00', '70 mg', 'Alendronic Acid'), 
('4828', 'Oradin  FT   10 mg', '308-0156-21', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '4.00', '0.00', '10 mg', 'Loratadine'), 
('4829', 'Ostomax   10 mg', '308-01578', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '5.00', '0.00', '10 mg', 'Alendronic Acid'), 
('4830', 'Cardon      25 mg', '308-0145-022', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '25 mg', 'Losartan Potassium'), 
('4831', 'Cardon     50 mg', '308-0146-022', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '50 mg', 'Losartan Potassium'), 
('4832', 'Restol   3 mg', '308-01237', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('4833', 'Ontin  F/C    10 mg', '308-0119-21', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '2.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('4834', 'Reomen     50 mg', '308-01233', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '50 mg', 'Clomiphene Citrate'), 
('4835', 'Cloron   .5 mg', '308-0116-046', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '.5 mg', 'Clonazepam'), 
('4836', 'Cloron   2 mg', '308-0115-046', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '2 mg', 'Clonazepam'), 
('4837', 'Anapril   10 mg', '308-0122-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '10 mg', 'Enalapril Maleate'), 
('4838', 'Anapril      5 mg', '308-0111-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '5 mg', 'Enalapril Maleate'), 
('4839', 'Bromid   10 mg', '308-01141', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '3.41', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('4840', 'Bromid      20 mg', '308-01131', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '3.51', '0.00', '20 mg', 'Hyoscine Butyl Bromide'), 
('4841', 'Ketonic   10 mg', '308-0144-064', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('4842', 'Kynol0   100 mg', '308-0121-64', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '100 mg', 'Ketoprofen'), 
('4843', 'Kynol     50 mg', '308-0120-64', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '50 mg', 'Ketoprofen'), 
('4844', 'Toti   1 mg', '308-0109-21', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '1.50', '0.00', '1 mg', 'Ketotifen'), 
('4845', 'Oradin   10 mg', '308-0129-21', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '10 mg', 'Loratadine'), 
('4846', 'Cardon   100 mg', '308-0141-022', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '100 mg', 'Losartan Potassium'), 
('4847', 'Lumona   10 mg', '308-0130-044', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '12.00', '0.00', '10 mg', 'Montelukast'), 
('4848', 'Naprox   500 mg', '308-0142-64', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '9.00', '0.00', '500 mg', 'Naproxen'), 
('4849', 'Telazine   1 mg', '308-0117-28', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '3.00', '0.00', '1 mg', 'Trifluoperazine'), 
('4850', 'Telazine      5 mg', '308-0118-28', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '4.00', '0.00', '5 mg', 'Trifluoperazine'), 
('4851', 'Sidopin      5 mg', '308-0121-022', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '5 mg', 'Amlodipine'), 
('4852', 'Lipicon   10 mg', '308-0131-061', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('4853', 'Lipicon      20 mg', '308-0132-061', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '18.00', '0.00', '20 mg', 'Atorvastatin'), 
('4854', 'Efopam   30 mg', '308-0249-006', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '3.00', '0.00', '30 mg', 'Nefopam Hydrochloride'), 
('4855', 'Tufnil   200 mg', '308-02617', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '200 mg', 'Tolfenamic Acid'), 
('4856', 'Xinc  ET    20 mg', '308-0275-62', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '20 mg', 'Zinc'), 
('4857', 'Nimodi   30 mg', '308-0271-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '30 mg', 'Nimodipine'), 
('4858', 'Ropison   .25 mg', '308-0265-025', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '.25 mg', 'Ropinirole'), 
('4859', 'Ropison   2 mg', '308-0266-025', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '2 mg', 'Ropinirole'), 
('4860', 'Pred   ODT   15 mg', '308-0250-72', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '15 mg', 'Prednisolone'), 
('4861', 'Pred      5 mg', '308-0251-72', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '5 mg', 'Prednisolone'), 
('4862', 'Pred      20 mg', '308-0252-72', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '20 mg', 'Prednisolone'), 
('4863', 'GTN.6  SR   2.6 mg', '308-0242', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '4.00', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('4864', 'Tamen DT   120 mg', '308-0233-006', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '120 mg', 'Paracetamol'), 
('4865', 'Ovis   50 mg', '308-02301', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('4866', 'Brizy   2 mg', '308-02264', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '2.00', '0.00', '2 mg', 'Levosalbutamol'), 
('4867', 'Brizy   1 mg', '308-02254', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '1.00', '0.00', '1 mg', 'Levosalbutamol'), 
('4868', 'Kynol D   25 mg', '308-0223-64', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '4.00', '0.00', '25 mg', 'Dexketoprofen'), 
('4869', 'Carbazin  CR   200 mg', '308-0222-046', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '4.50', '0.00', '200 mg', 'Carbamazepine'), 
('4870', 'Toperin     50 mg', '308-0224-70', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '3.00', '0.00', '50 mg', 'Tolperisone Hydrochloride'), 
('4871', 'Losita      5 mg', '308-02164', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '6.00', '0.00', '5 mg', 'Escitalopram'), 
('4872', 'Losita   10 mg', '308-02174', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '10 mg', 'Escitalopram'), 
('4873', 'Sominex   1 mg', '308-0218-057', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '2.00', '0.00', '1 mg', 'Eszopiclone'), 
('4874', 'Sominex   2 mg', '308-0219-057', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '3.00', '0.00', '2 mg', 'Eszopiclone'), 
('4875', 'Dialon   1 mg', '308-0198', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '1 mg', 'Glimepiride'), 
('4876', 'Dialon   2 mg', '308-0199', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '2 mg', 'Glimepiride'), 
('4877', 'Dialon   4 mg', '308-0200', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '4 mg', 'Glimepiride'), 
('4878', 'Uritol   1 mg', '308-02019', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '2.00', '0.00', '1 mg', 'Tolterodine Tartrate'), 
('4879', 'Uritol   2 mg', '308-02029', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '3.00', '0.00', '2 mg', 'Tolterodine Tartrate'), 
('4880', 'Panoral      20 mg', '308-0185-67', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '4.00', '0.00', '20 mg', 'Pantoprazole'), 
('4881', 'Panoral   40 mg', '308-0186-67', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '6.00', '0.00', '40 mg', 'Pantoprazole'), 
('4882', 'Lumona   4 mg', '308-0195-044', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '4 mg', 'Montelukast'), 
('4883', 'Dayprox   600 mg', '308-0196-64', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '7.00', '0.00', '600 mg', 'Oxaprozin'), 
('4884', 'Lumona      5 mg', '308-0183-044', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '7.00', '0.00', '5 mg', 'Montelukast'), 
('4885', 'Sulidac   100 mg', '308-0184-64', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '5.00', '0.00', '100 mg', 'Sulindac'), 
('4886', 'Toperin     50 mg', '308-0164-70', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '50 mg', 'Tolperisone Hydrochloride'), 
('4887', 'Desodin   5 mg', '308-0165-21', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '3.00', '0.00', '5 mg', 'Desloratadine'), 
('4888', 'Lamidin   100 mg', '308-0160-32', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '100 mg', 'Lamivudine'), 
('4889', 'EZY Xinc      20 mg', '308-0282-62', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '1.75', '0.00', '20 mg', 'Zinc'), 
('4890', 'Vaset     200 mg', '308-02836', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '200 mg', 'Sodium Valproate'), 
('4891', 'Fenobac   10 mg', '308-0285-70', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '8.00', '0.00', '10 mg', 'Baclofen'), 
('4892', 'Angicure   10 mg', '308-0290', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '10 mg', 'Isosorbide Mononitrate'), 
('4893', 'Angicure      20 mg', '308-0291', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '20 mg', 'Isosorbide Mononitrate'), 
('4894', 'Topress     50 mg', '308-0294-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '2.00', '0.00', '50 mg', 'Metoprolol Tartrate'), 
('4895', 'Topress0   100 mg', '308-0295-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '100 mg', 'Metoprolol Tartrate'), 
('4896', 'Furosemide   40 mg', '308-03032', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '40 mg', 'Frusemide'), 
('4897', 'Alben  DS   400 mg', '308-0302-008', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '5.00', '0.00', '400 mg', 'Albendazole'), 
('4898', 'Tamen   500 mg', '308-0301-006', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('4899', 'Furosemide      20 mg', '308-03472', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '20 mg', 'Frusemide'), 
('4900', 'Ropison   1 mg', '308-0352-025', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '1 mg', 'Ropinirole'), 
('4901', 'Fibrino   500 mg', '308-03519', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('4902', 'Kilmax   125 mg', '308-0331-23', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '15.00', '0.00', '125 mg', 'Cefuroxime'), 
('4903', 'Kilmax   250 mg', '308-0332-23', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('4904', 'Kilmax   500 mg', '308-0333-23', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('4905', 'Mypril   2.5 mg', '308-0361-022', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '5.00', '0.00', '2.5 mg', 'Ramipril'), 
('4906', 'Mypril      5 mg', '308-0362-022', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '8.00', '0.00', '5 mg', 'Ramipril'), 
('4907', 'Mypril   10 mg', '308-0363-022', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '10 mg', 'Ramipril'), 
('4908', 'Vedilol   25 mg', '308-0373-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '8.00', '0.00', '25 mg', 'Carvedilol'), 
('4909', 'Vedilol   12.5 mg', '308-0372-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '5.00', '0.00', '12.5 mg', 'Carvedilol'), 
('4910', 'Vedilol   6.25 mg', '308-0371-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '3.00', '0.00', '6.25 mg', 'Carvedilol'), 
('4911', 'HI-C   1 gm', '308-0369-78', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '1 gm', 'Vitamin C'), 
('4912', 'Juci Chewable   250 mg', '308-0368-78', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('4913', 'Ostocal   1250 mg', '308-0367-62', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('4914', 'Fenobac   5 mg', '308-0384-70', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '4.50', '0.00', '5 mg', 'Baclofen'), 
('4915', 'Fenobac   25 mg', '308-0385-70', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '25 mg', 'Baclofen'), 
('4916', 'Foslo   667 mg', '308-0387-62', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '667 mg', 'Calcium Acetate'), 
('4917', 'Dorenta   50 mg', '308-0400-21', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '50 mg', 'Diphenhydramine Hydrochloride'), 
('4918', 'Dinafex   60 mg', '308-0407-21', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '3.50', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('4919', 'Dinafex   120 mg', '308-0408-21', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '6.50', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('4920', 'Dinafex   180 mg', '308-0409-21', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '8.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('4921', 'Nepsy   300 mg', '308-0412-046', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '16.00', '0.00', '300 mg', 'Gabapentin'), 
('4922', 'nepsy   600 mg', '308-0413-046', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '600 mg', 'Gabapentin'), 
('4923', 'Zithrox   500 mg', '308-0416-23', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('4924', 'Levomax   500 mg', '308-0421-23', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '15.00', '0.00', '500 mg', 'Levofloxacin'), 
('4925', 'Kalfree   8 mg', '308-0423', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '8 mg', 'Sucralose'), 
('4926', 'Peptil-H   150 mg', '308-04305', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('4927', 'Vastarel MR   35 mg', '308-0434', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '8.83', '0.00', '35 mg', 'Trimetazidine Dihydrochloride'), 
('4928', 'Ethinor   5 mg', '308-0437-39', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '5 mg', 'Norethisterone'), 
('4929', 'Tibonor   2.5 mg', '308-04386', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '20.00', '0.00', '2.5 mg', 'Tibolone'), 
('4930', 'Thynor   50 mcg', '308-0439-74', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '1.50', '0.00', '50 mcg', 'Levothyroxine Sodium'), 
('4931', 'Gliclazide   80 mg', '308-0441', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '5.00', '0.00', '80 mg', 'Gliclazide'), 
('4932', 'Roxim   200 mg', '308-0435-23', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '30.00', '0.00', '200 mg', 'Cefixime'), 
('4933', 'Roxim   400 mg', '308-0436-23', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '50.00', '0.00', '400 mg', 'Cefixime'), 
('4934', 'Mycofin   250 mg', '308-0444', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '40.00', '0.00', '250 mg', 'Terbinafine'), 
('4935', 'Noclog   75 mg', '308-0443-26', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '75 mg', 'Clopidogrel'), 
('4936', 'Norium   10 mg', '308-04427', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '5.00', '0.00', '10 mg', 'Flunarizine'), 
('4937', 'Prasu   5 mg', '308-0451-26', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '5 mg', 'Prasugrel'), 
('4938', 'Prasu   10 mg', '308-0452-26', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '10 mg', 'Prasugrel'), 
('4939', 'Etorix   60 mg', '308-0457-64', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '7.00', '0.00', '60 mg', 'Etoricoxib'), 
('4940', 'Etorix   90 mg', '308-0458-64', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('4941', 'Quinox   750 mg', '308-0465-23', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '18.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('4942', 'Quinox   500 mg', '308-0464-23', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('4943', 'Quinox   250 mg', '308-0463-23', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '8.50', '0.00', '250 mg', 'Ciprofloxacin'), 
('4944', 'Geminox   320 mg', '308-0462-23', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '65.00', '0.00', '320 mg', 'Gemefloxacin'), 
('4945', 'Coversyl   4 mg', '308-0466-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '16.50', '0.00', '4 mg', 'Perindopril Erbumine'), 
('4946', 'Coversyl   8 mg', '308-0467-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '25.00', '0.00', '8 mg', 'Perindopril Erbumine'), 
('4947', 'Sentix   1 mg', '308-0471-28', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '1 mg', 'Flupenthixol'), 
('4948', 'Sentix   .5 mg', '308-0472-28', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '.5 mg', 'Flupenthixol'), 
('4949', 'Provenor   10 mg', '308-0480-039', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '10 mg', 'Medroxyprogesterone Acetate'), 
('4950', 'Provenor   5 mg', '308-0479-39', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '5.00', '0.00', '5 mg', 'Medroxyprogesterone Acetate'), 
('4951', 'Lenor   2.5 mg', '308-0481', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '40.00', '0.00', '2.5 mg', 'Letrozole'), 
('4952', 'Aggra   25 mg', '308-0243-043', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '25 mg', 'Sildenafil'), 
('4953', 'Aggra   50 mg', '308-0244-043', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '30.00', '0.00', '50 mg', 'Sildenafil'), 
('4954', 'Aggra   100 mg', '308-0245-043', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '50.00', '0.00', '100 mg', 'Sildenafil'), 
('4955', 'Virenta   .5 mg', '308-0495-32', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '48.00', '0.00', '.5 mg', 'Entecavir'), 
('4956', 'Virenta   1 mg', '308-0496-32', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '1 mg', 'Entecavir'), 
('4957', 'Stiba   10 mg', '308-0487-21', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '6.00', '0.00', '10 mg', 'Ebastine'), 
('4958', 'Tapenta   50 mg', '308-0505-065', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '12.00', '0.00', '50 mg', 'Tapentadol'), 
('4959', 'Tapenta   75 mg', '308-0506-065', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '17.00', '0.00', '75 mg', 'Tapentadol'), 
('4960', 'Tapenta   100 mg', '308-0507-065', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '20.00', '0.00', '100 mg', 'Tapentadol'), 
('4961', 'Creston   10 mg', '308-0508-61', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '20.00', '0.00', '10 mg', 'Rosuvastatin'), 
('4962', 'Zeromig   500 mcg', '308-05327', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '3.00', '0.00', '500 mcg', 'Pizotifen'), 
('4963', 'Zeromig   1.5 mg', '308-05337', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '7.00', '0.00', '1.5 mg', 'Pizotifen'), 
('4964', 'Rivarox   10 mg', '308-05372', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '25.00', '0.00', '10 mg', 'Rivaroxaban'), 
('4965', 'Rivarox   15 mg', '308-05382', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '15 mg', 'Rivaroxaban'), 
('4966', 'Vigatin   50 mg', '308-0552', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '20.00', '0.00', '50 mg', 'Vildagliptin'), 
('4967', 'Cardobis   2.5 mg', '308-0543-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('4968', 'Cardobis   5 mg', '308-0544-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('4969', 'Calofast   400 mg', '308-0338-62', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '400 mg', 'Calcium Orotate'), 
('4970', 'Tada   20 mg', '308-0561-043', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '60.00', '0.00', '20 mg', 'Tadalafil'), 
('4971', 'Tada   10 mg', '308-0560-043', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '35.00', '0.00', '10 mg', 'Tadalafil'), 
('4972', 'Zithrox   250 mg', '308-0559-23', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('4973', 'Sulidac   200 mg', '308-0566-64', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '9.50', '0.00', '200 mg', 'Sulindac'), 
('4974', 'Dumax   30 mg', '308-0568-014', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '30.00', '0.00', '30 mg', 'Dapoxetine'), 
('4975', 'Dumax   60 mg', '308-0569-014', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '50.00', '0.00', '60 mg', 'Dapoxetine'), 
('4976', 'Glikazid MR   60 mg', '308-0573', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '60 mg', 'Gliclazide'), 
('4977', 'Rupaday   10 mg', '308-0577-21', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '10 mg', 'Rupatadine'), 
('4978', 'Ligatin   5 mg', '308-0584-015', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '15.00', '0.00', '5 mg', 'Linagliptin'), 
('4979', 'Goutil   40 mg', '308-0589-76', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '12.00', '0.00', '40 mg', 'Febuxostat'), 
('4980', 'Goutil   80 mg', '308-0590-76', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '22.00', '0.00', '80 mg', 'Febuxostat'), 
('4981', 'Olmesta   10 mg', '308-0602-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '5.00', '0.00', '10 mg', 'Olmesartan Medoxomil'), 
('4982', 'Olmesta   20 mg', '308-0601-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '8.00', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('4983', 'Olmesta   40 mg', '308-0600-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '15.00', '0.00', '40 mg', 'Olmesartan Medoxomil'), 
('4984', 'Valenty   10 mg', '308-0603-', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '10 mg', 'Vardenafil Hydrochloride'), 
('4985', 'Valenty   20 mg', '308-0604-', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '20 mg', 'Vardenafil Hydrochloride'), 
('4986', 'Soventa   400 mg', '308-0612-32', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '400 mg', 'Sofosbuvir'), 
('4987', 'Salomax   4 mg', '308-06144', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '4 mg', 'Salbutamol'), 
('4988', 'Tenoxim   20 mg', '308-0619-64', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '8.00', '0.00', '20 mg', 'Tenoxicam'), 
('4989', 'Sertraline   50 mg', '308-06174', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '50 mg', 'Sertraline'), 
('4990', 'Sertraline   100 mg', '308-06184', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '100 mg', 'Sertraline'), 
('4991', 'TADA   5 mg', '308-0570-043', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '5 mg', 'Tadalafil'), 
('4992', 'Rivarox   2.5 mg', '308-06272', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '8.00', '0.00', '2.5 mg', 'Rivaroxaban'), 
('4993', 'Rivarox   20 mg', '308-06282', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '45.00', '0.00', '20 mg', 'Rivaroxaban'), 
('4994', 'Palosis   .5 mg', '308-06358', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '20.00', '0.00', '.5 mg', 'Palonosetron'), 
('4995', 'Ventofil   200 mg', '308-06394', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '6.00', '0.00', '200 mg', 'Doxophylline'), 
('4996', 'Ventofil   400 mg', '308-06404', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '400 mg', 'Doxophylline'), 
('4997', 'Urokit   1080 mg', '308-0641-62', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '1080 mg', 'Potassium Citrate'), 
('4998', 'Facid   250 mg', '308-0644-23', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '65.00', '0.00', '250 mg', 'Sodium Fusidate'), 
('4999', 'Cardovan   160 mg', '308-0651-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '16.00', '0.00', '160 mg', 'Valsartan'), 
('5000', 'Cardovan   80 mg', '308-0650-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '80 mg', 'Valsartan'), 
('5001', 'Xinc OT   10 mg', '308-0648-62', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '10 mg', 'Zinc'), 
('5002', 'Etorix   120 mg', '308-0662-64', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '14.00', '0.00', '120 mg', 'Etoricoxib'), 
('5003', 'Norium   5 mg', '308-06617', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '3.50', '0.00', '5 mg', 'Flunarizine'), 
('5004', 'Naprox   250 mg', '308-0659-64', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '5.00', '0.00', '250 mg', 'Naproxen'), 
('5005', 'Milam   15 mg', '308-0658-057', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '15 mg', 'Midazolam'), 
('5006', 'Milam   7.5 mg', '308-0657-057', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '7.5 mg', 'Midazolam'), 
('5007', 'Cardoneb   2.5 mg', '308-0655-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '2.5 mg', 'Nebivolol'), 
('5008', 'Cardoneb   5 mg', '308-0656-22', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '5 mg', 'Nebivolol'), 
('5009', 'Losectil Mups   40 mg', '308-0666-67', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '40 mg', 'Omeprazole'), 
('5010', 'Sitazid   100 mg', '308-0670', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '25.00', '0.00', '100 mg', 'Sitagliptin'), 
('5011', 'Sitazid   50 mg', '308-0669', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '13.00', '0.00', '50 mg', 'Sitagliptin'), 
('5012', 'Sitazid   25 mg', '308-0668', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '25 mg', 'Sitagliptin'), 
('5013', 'Sizofree   25 mg', '308-0673-28', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '25 mg', 'Quetiapine'), 
('5014', 'Sizofree   100 mg', '308-0674-28', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '100 mg', 'Quetiapine'), 
('5015', 'Misoprost   200 mcg', '308-0683-049', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '200 mcg', 'Misoprostol'), 
('5016', 'Mifeprist   200 mg', '308-0682-049', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '200 mg', 'Mifepristone'), 
('5017', 'Ulicon   30 mg', '308-0681-039', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '195.00', '0.00', '30 mg', 'Ulipristal Acetate'), 
('5018', 'Suvo   10 mg', '308-0684-057', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '35.00', '0.00', '10 mg', 'Suvorexant'), 
('5019', 'Irbes   75 mg', '308-0701-022', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '75 mg', 'Irbesartan'), 
('5020', 'Irbes   150 mg', '308-0702-022', 'Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '150 mg', 'Irbesartan'), 
('5021', 'Eskamycin   500 mg', '308-0050-077', 'Bolus', 'Eskayef Bangladesh Ltd., Tongi', '3.40', '0.00', '500 mg', 'Oxytetracycline'), 
('5022', 'Eskazol   600 mg', '308-0040-077', 'Bolus', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '600 mg', 'Albendazole'), 
('5023', 'Tufnil Vet Bolus   200 mg', '308-0688-077', 'Bolus', 'Eskayef Bangladesh Ltd., Tongi', '20.00', '0.00', '200 mg', 'Tolfenamic Acid'), 
('5024', 'Triject  IM   500 mg', '308-0342-23', 'IM Injection', 'Eskayef Bangladesh Ltd., Tongi', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('5025', 'Triject  IM   1 gm', '308-0344-23', 'IM Injection', 'Eskayef Bangladesh Ltd., Tongi', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('5026', 'Triject  IV   250 mg', '308-0341-23', 'IV Injection', 'Eskayef Bangladesh Ltd., Tongi', '100.00', '0.00', '250 mg', 'Ceftriaxone'), 
('5027', 'Triject  IV   500 mg', '308-0343-23', 'IV Injection', 'Eskayef Bangladesh Ltd., Tongi', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('5028', 'Triject  IV   1 gm', '308-0345-23', 'IV Injection', 'Eskayef Bangladesh Ltd., Tongi', '143.97', '0.00', '1 gm', 'Ceftriaxone'), 
('5029', 'Triject   2 gm', '308-0346-23', 'IV Injection', 'Eskayef Bangladesh Ltd., Tongi', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('5030', 'Triject  IV/IM   250 mg', '308-0340-23', 'IV/IM Injection', 'Eskayef Bangladesh Ltd., Tongi', '100.00', '0.00', '250 mg', 'Ceftriaxone'), 
('5031', 'Protinex   5 %', '308-0432-3', 'IV Infusion', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '5 %', 'Amino Acids (Essential)'), 
('5032', 'Losectil   40 mg', '308-0159-67', 'Sached Powder', 'Eskayef Bangladesh Ltd., Tongi', '8.00', '0.00', '40 mg', 'Omeprazole'), 
('5033', 'Losectil   20 mg', '308-0155-67', 'Sached Powder', 'Eskayef Bangladesh Ltd., Tongi', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('5034', 'Fluflam   .1 %', '308-05532', 'Eye Drops', 'Eskayef Bangladesh Ltd., Tongi', '100.00', '0.00', '.1 %', 'Fluorometholone'), 
('5035', 'Lumona Chewable   4 mg', '308-0571-044', 'Chewable Tablet', 'Eskayef Bangladesh Ltd., Tongi', '6.00', '0.00', '4 mg', 'Montelukast'), 
('5036', 'Kulair   5 mg', '308-0638-044', 'Chewable Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '5 mg', 'Montelukast'), 
('5037', 'Tamen XR   665 mg', '308-0522-6', 'Xr Tablet', 'Eskayef Bangladesh Ltd., Tongi', '1.50', '0.00', '665 mg', 'Paracetamol'), 
('5038', 'Zatral   10 mg', '308-0203-', 'Er Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '10 mg', 'Alfuzosin Hydrochloride'), 
('5039', 'Hapytab ER   50 mg', '308-06334', 'Er Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '50 mg', 'Desvenlafaxine'), 
('5040', 'Miraflo Extented Release   25 mg', '308-0686-001', 'Er Tablet', 'Eskayef Bangladesh Ltd., Tongi', '0.00', '0.00', '25 mg', 'Mirabegron'), 
('5041', 'Zofra ODT   4 mg', '308-02548', 'Orodispersible Tablet', 'Eskayef Bangladesh Ltd., Tongi', '5.00', '0.00', '4 mg', 'Ondansetron'), 
('5042', 'Zofra  DT   8 mg', '308-02538', 'Orodispersible Tablet', 'Eskayef Bangladesh Ltd., Tongi', '10.00', '0.00', '8 mg', 'Ondansetron'), 
('5043', 'Losectil Mups   20 mg', '308-0665', 'Sr Tablet', 'Eskayef Bangladesh Ltd., Tongi', '7.00', '0.00', '20 mg', 'Omeprazole'), 
('5044', 'Amboten  SR   75 mg', '188-0226-31', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '75 mg', 'Ambroxol'), 
('5045', 'Arocef   500 mg', '188-0122-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '500 mg', 'Cefadroxil'), 
('5046', 'Betaclox   125 mg', '188-0071-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '125 mg', 'Dicloxacillin'), 
('5047', 'Betaclox   500 mg', '188-0070-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '500 mg', 'Dicloxacillin'), 
('5048', 'Betaclox   250 mg', '188-0059-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '250 mg', 'Dicloxacillin'), 
('5049', 'Carbolin   375 mg', '188-0156-31', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '2.50', '0.00', '375 mg', 'Carbocisteine'), 
('5050', 'Ezy   100 mg', '188-0099-064', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '100 mg', 'Celecoxib'), 
('5051', 'Ceflon  DS    250 mg', '188-0120-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '250 mg', 'Cefaclor'), 
('5052', 'Ceflon   500 mg', '188-0121-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '500 mg', 'Cefaclor'), 
('5053', 'Coracten  TR   20 mg', '188-0015-22', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '20 mg', 'Nifedipine'), 
('5054', 'Danamet   100 mg', '188-01259', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '20.00', '0.00', '100 mg', 'Danazol'), 
('5055', 'Danamet     200 mg', '188-01269', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '38.00', '0.00', '200 mg', 'Danazol'), 
('5056', 'Ezy     200 mg', '188-0100-064', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '200 mg', 'Celecoxib'), 
('5057', 'Flucloxin   250 mg', '188-0035-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '5.77', '0.00', '250 mg', 'Flucloxacillin'), 
('5058', 'Flucloxin   500 mg', '188-0093-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '10.50', '0.00', '500 mg', 'Flucloxacillin'), 
('5059', 'Flucoder   150 mg', '188-0084', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('5060', 'Flucoder     50 mg', '188-0056', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '8.10', '0.00', '50 mg', 'Fluconazole'), 
('5061', 'Gelicon   300 mg', '188-0182-61', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '300 mg', 'Gemfibrozil'), 
('5062', 'Kynol  TR   100 mg', '188-0101-64', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '7.00', '0.00', '100 mg', 'Ketoprofen'), 
('5063', 'Kynol  TR   200 mg', '188-0102-64', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '10.00', '0.00', '200 mg', 'Ketoprofen'), 
('5064', 'Losectil   10 mg', '188-0089-67', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '10 mg', 'Omeprazole'), 
('5065', 'Losectil V   20 mg', '188-0031-67', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('5066', 'Losectil V   40 mg', '188-0092-67', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '8.00', '0.00', '40 mg', 'Omeprazole'), 
('5067', 'Neorex   500 mg', '188-0087-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('5068', 'Neorex   250 mg', '188-0086-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '250 mg', 'Cephalexin'), 
('5069', 'Roxim     200 mg', '188-0095-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('5070', 'Roxim   400 mg', '188-0218-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '400 mg', 'Cefixime'), 
('5071', 'Sk Cef   250 mg', '188-0018-023', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '250 mg', 'Cephradine'), 
('5072', 'Sk Cef   500 mg', '188-0017-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('5073', 'Sk Cillin   250 mg', '188-0005-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '250 mg', 'Ampicillin'), 
('5074', 'Sk Mox   250 mg', '188-0012-023', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.55', '0.00', '250 mg', 'Amoxicillin'), 
('5075', 'Sk Mox   500 mg', '188-0094-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '6.09', '0.00', '500 mg', 'Amoxicillin'), 
('5076', 'Starin   100 mg', '188-0149-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '100 mg', 'Cefpodoxime'), 
('5077', 'Starin     200 mg', '188-0184-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '200 mg', 'Cefpodoxime'), 
('5078', 'Zithrox   250 mg', '188-0047-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('5079', 'Pathozil   500 mg', '188-0258-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '500 mg', 'Cefprozil'), 
('5080', 'Cednir   300 mg', '188-0245-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '300 mg', 'Cefdinir'), 
('5081', 'Rifanol   450 mg', '188-0010-30', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '450 mg', 'Rifampicin'), 
('5082', 'Cardimet  CR   60 mg', '188-0257', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '60 mg', 'Trimetazidine Hydrochloride'), 
('5083', 'Flucoder   200 mg', '188-0331', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '25.00', '0.00', '200 mg', 'Fluconazole'), 
('5084', 'Volmax SR   100 mg', '188-0267-64', 'Capsule', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('5085', 'Eskamox   20 %', '188-0291-077', 'Powder', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '47.60', '0.00', '20 %', 'Amoxicillin'), 
('5086', 'Eskamox Vet   30 %', '188-0298-077', 'Powder', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '30 %', 'Amoxicillin'), 
('5087', 'Alben     200 mg', '188-0009-008', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '200 mg', 'Albendazole'), 
('5088', 'Alben  DS   400 mg', '188-0054-008', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '5.00', '0.00', '400 mg', 'Albendazole'), 
('5089', 'Ambunol   400 mg', '188-0006-30', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '400 mg', 'Ethambutol'), 
('5090', 'Anapril   10 mg', '188-0067-22', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '2.70', '0.00', '10 mg', 'Enalapril Maleate'), 
('5091', 'Anapril      20 mg', '188-0066-22', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '20 mg', 'Enalapril Maleate'), 
('5092', 'Anapril      5 mg', '188-0068-22', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '1.51', '0.00', '5 mg', 'Enalapril Maleate'), 
('5093', 'Bromid      20 mg', '188-01811', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.53', '0.00', '20 mg', 'Hyoscine Butyl Bromide'), 
('5094', 'Bromid   10 mg', '188-01451', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.45', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('5095', 'Carbazin     200 mg', '188-0097-046', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '200 mg', 'Carbamazepine'), 
('5096', 'Carbazin  TR   200 mg', '188-0098-046', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '4.00', '0.00', '200 mg', 'Carbamazepine'), 
('5097', 'Nipen   10 mg', '188-0052-22', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '10 mg', 'Nifedipine'), 
('5098', 'Cloron   2 mg', '188-0173-046', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '6.00', '0.00', '2 mg', 'Clonazepam'), 
('5099', 'Cloron   .5 mg', '188-0172-046', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '5.00', '0.00', '.5 mg', 'Clonazepam'), 
('5100', 'Creston   10 mg', '188-0213-61', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '10 mg', 'Rosuvastatin'), 
('5101', 'Desodin   5 mg', '188-0163-21', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.00', '0.00', '5 mg', 'Desloratadine'), 
('5102', 'Dialon   1 mg', '188-0160', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.00', '0.00', '1 mg', 'Glimepiride'), 
('5103', 'Dialon   2 mg', '188-0161', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '5.00', '0.00', '2 mg', 'Glimepiride'), 
('5104', 'Dialon   4 mg', '188-0183', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '8.00', '0.00', '4 mg', 'Glimepiride'), 
('5105', 'Dilator   10 mg', '188-01534', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.00', '0.00', '10 mg', 'Bambuterol Hydrochloride'), 
('5106', 'Dilator      20 mg', '188-01744', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '4.00', '0.00', '20 mg', 'Bambuterol Hydrochloride'), 
('5107', 'Esoral      20 mg', '188-0146-067', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '5.00', '0.00', '20 mg', 'Esomeprazole'), 
('5108', 'Esoral   40 mg', '188-0147-67', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '8.00', '0.00', '40 mg', 'Esomeprazole'), 
('5109', 'Etorix   120 mg', '188-0222-64', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '14.00', '0.00', '120 mg', 'Etoricoxib'), 
('5110', 'Etorix   90 mg', '188-0221-64', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('5111', 'Etorix   60 mg', '188-0220-64', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '7.00', '0.00', '60 mg', 'Etoricoxib'), 
('5112', 'Glunor   500 mg', '188-0201', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('5113', 'Glunor   850 mg', '188-0202', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '4.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('5114', 'HI-C   250 mg', '188-0021-78', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('5115', 'Irbes   150 mg', '188-0152-22', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '9.00', '0.00', '150 mg', 'Irbesartan'), 
('5116', 'Irbes      75 mg', '188-0151-22', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '5.00', '0.00', '75 mg', 'Irbesartan'), 
('5117', 'Ketofen  TR   100 mg', '188-0078-64', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '100 mg', 'Ketoprofen'), 
('5118', 'Kynol  TR   100 mg', '188-0077-64', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '100 mg', 'Ketoprofen'), 
('5119', 'Kynol     50 mg', '188-0076-64', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '50 mg', 'Ketoprofen'), 
('5120', 'Lamidin   100 mg', '188-0108-32', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '25.30', '0.00', '100 mg', 'Lamivudine'), 
('5121', 'Lipicon   10 mg', '188-0109-061', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('5122', 'Lipicon      20 mg', '188-0110-061', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '18.00', '0.00', '20 mg', 'Atorvastatin'), 
('5123', 'Lukast      20 mg', '188-01484', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '20 mg', 'Zafirlukast'), 
('5124', 'Mebidal   50 mg', '188-0024-21', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.00', '0.00', '50 mg', 'Mebhydrolin'), 
('5125', 'Metco   400 mg', '188-0025-27', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '1.26', '0.00', '400 mg', 'Metronidazole'), 
('5126', 'Milam   15 mg', '188-0144-057', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '20.00', '0.00', '15 mg', 'Midazolam'), 
('5127', 'Milam      7.5 mg', '188-0143-057', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '10.00', '0.00', '7.5 mg', 'Midazolam'), 
('5128', 'Mycofin   250 mg', '188-0129', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '40.00', '0.00', '250 mg', 'Terbinafine'), 
('5129', 'Naprox   250 mg', '188-0038-64', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '5.00', '0.00', '250 mg', 'Naproxen'), 
('5130', 'Norfen     200 mg', '188-0041-64', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '200 mg', 'Ibuprofen'), 
('5131', 'Norfen   400 mg', '188-0042-64', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '400 mg', 'Ibuprofen'), 
('5132', 'Norium   10 mg', '188-01647', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '5.00', '0.00', '10 mg', 'Flunarizine'), 
('5133', 'Norium      5 mg', '188-01627', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.50', '0.00', '5 mg', 'Flunarizine'), 
('5134', 'Nortid      25 mg', '188-0026-64', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '25 mg', 'Diclofenac Sodium'), 
('5135', 'Nortid     50 mg', '188-0027-64', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('5136', 'Ontin   10 mg', '188-0135-21', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('5137', 'Oradin   10 mg', '188-0080-21', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '4.00', '0.00', '10 mg', 'Loratadine'), 
('5138', 'Ostocal   1250 mg', '188-0085-62', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '4.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('5139', 'Ostocal  JR    625 mg', '188-0104-62', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '625 mg', 'Calcium Carbonate'), 
('5140', 'Parlox     200 mg', '188-0116-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '15.00', '0.00', '200 mg', 'Sparfloxacin'), 
('5141', 'Peptil H   150 mg', '188-00285', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('5142', 'Peptil H    300 mg', '188-00345', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '300 mg', 'Ranitidine'), 
('5143', 'Kilmax   250 mg', '188-0282-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '250 mg', 'Cefuroxime'), 
('5144', 'Priocin   250 mg', '188-0140-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '4.81', '0.00', '250 mg', 'Erythromycin'), 
('5145', 'Priocin   500 mg', '188-0139-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('5146', 'Quinox   500 mg', '188-0060-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('5147', 'Quinox      750 mg', '188-0113-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '18.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('5148', 'Reomen     50 mg', '188-01423', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '10.00', '0.00', '50 mg', 'Clomiphene Citrate'), 
('5149', 'Restol   3 mg', '188-01697', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '5.00', '0.00', '3 mg', 'Bromazepam'), 
('5150', 'Ridon   10 mg', '188-01148', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '2.50', '0.00', '10 mg', 'Domperidone'), 
('5151', 'Sentix   .5 mg', '188-0224-28', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.50', '0.00', '.5 mg', 'Flupenthixol'), 
('5152', 'Sentix   1 mg', '188-0225-28', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '5.00', '0.00', '1 mg', 'Flupenthixol'), 
('5153', 'Sidopin   10 mg', '188-0082-022', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '10 mg', 'Amlodipine'), 
('5154', 'Sidopin      5 mg', '188-0081-022', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '5 mg', 'Amlodipine'), 
('5155', 'Tamen   500 mg', '188-0003-006', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('5156', 'Telazine   1 mg', '188-0010-28', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '2.00', '0.00', '1 mg', 'Trifluoperazine'), 
('5157', 'Telazine      5 mg', '188-0011-28', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.00', '0.00', '5 mg', 'Trifluoperazine'), 
('5158', 'Toperin     50 mg', '188-0170-70', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.00', '0.00', '50 mg', 'Tolperisone Hydrochloride'), 
('5159', 'Paino   100 mg', '188-0199-64', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '4.00', '0.00', '100 mg', 'Aceclofenac'), 
('5160', 'Vincet   5 mg', '188-0171-36', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '4.00', '0.00', '5 mg', 'Vinpocetine'), 
('5161', 'Levomax   250 mg', '188-0133-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '250 mg', 'Levofloxacin'), 
('5162', 'Levomax   500 mg', '188-0134-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '15.00', '0.00', '500 mg', 'Levofloxacin'), 
('5163', 'Zithrox   500 mg', '188-0112-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('5164', 'Quinox   250 mg', '188-0032-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '8.50', '0.00', '250 mg', 'Ciprofloxacin'), 
('5165', 'Cardon      25 mg', '188-0117-022', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '4.50', '0.00', '25 mg', 'Losartan Potassium'), 
('5166', 'Cardon     50 mg', '188-0118-022', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '8.00', '0.00', '50 mg', 'Losartan Potassium'), 
('5167', 'Celipress     200 mg', '188-0233-22', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '200 mg', 'Celiprolol Hydrochloride'), 
('5168', 'Celipress   400 mg', '188-0234-22', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '400 mg', 'Celiprolol Hydrochloride'), 
('5169', 'Glunor  XR0   500 mg', '188-0235', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '4.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('5170', 'Veron   135 mg', '158-00691', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '6.08', '0.00', '135 mg', 'Mebeverine Hydrochloride'), 
('5171', 'Xinc      20 mg', '188-0251-62', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '20 mg', 'Zinc'), 
('5172', 'Quinox  XR0   500 mg', '188-0241-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('5173', 'Noclog      75 mg', '188-0250-26', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '12.00', '0.00', '75 mg', 'Clopidogrel'), 
('5174', 'Levomax   750 mg', '188-0254-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '20.00', '0.00', '750 mg', 'Levofloxacin'), 
('5175', 'Emezin   50 mg', '188-02378', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '2.50', '0.00', '50 mg', 'Meclizine Hydrochloride'), 
('5176', 'Mecopen  F/C   .5 mg', '188-0244-78', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '4.00', '0.00', '.5 mg', 'Mecobalamin'), 
('5177', 'Nipen  TR   20 mg', '188-0053-22', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '20 mg', 'Nifedipine'), 
('5178', 'Naprox   500 mg', '188-0079-64', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '9.00', '0.00', '500 mg', 'Naproxen'), 
('5179', 'Mucoten   8 mg', '188-0083-031', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '8 mg', 'Bromhexine Hydrochloride'), 
('5180', 'Zithrox   250 mg', '188-0287-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '20.00', '0.00', '250 mg', 'Azithromycin'), 
('5181', 'Kilmax   125 mg', '188-0281-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '125 mg', 'Cefuroxime'), 
('5182', 'Kilmax   500 mg', '188-0283-23', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '500 mg', 'Cefuroxime'), 
('5183', 'Urokit ER    540 mg', '188-0274-62', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '540 mg', 'Potassium Citrate'), 
('5184', 'Dayprox   600 mg', '188-0272-64', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '600 mg', 'Oxaprozin'), 
('5185', 'Reomen      25 mg', '188-02733', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '25 mg', 'Clomiphene Citrate'), 
('5186', 'Viroxi   200 mg', '188-0270-32', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '14.00', '0.00', '200 mg', 'Acyclovir'), 
('5187', 'Toza   500 mg', '188-0267-27', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '10.00', '0.00', '500 mg', 'Nitazoxanide'), 
('5188', 'Reomen0   100 mg', '188-02713', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '100 mg', 'Clomiphene Citrate'), 
('5189', 'Aldorin   50 mg', '188-0260-76', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '8.00', '0.00', '50 mg', 'Epalrestat'), 
('5190', 'Tumy   625 mg', '188-0262-62', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '625 mg', 'Calcium Carbonate'), 
('5191', 'Urokit80   1080 mg', '188-0265-62', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '1080 mg', 'Potassium Citrate'), 
('5192', 'Furosemide      20 mg', '188-03472', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '20 mg', 'Frusemide'), 
('5193', 'Cantor   330 mg', '188-0157', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '330 mg', 'Levocarnitine'), 
('5194', 'Tufnil   200 mg', '188-02927', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '200 mg', 'Tolfenamic Acid'), 
('5195', 'Vanila   200 mg', '188-0299-78', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '200 mg', 'Vitamin E'), 
('5196', 'Lipicon0   40 mg', '188-0300-061', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '24.00', '0.00', '40 mg', 'Atorvastatin'), 
('5197', 'Pred   20 mg', '188-0313-72', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '6.27', '0.00', '20 mg', 'Prednisolone'), 
('5198', 'Pred   10 mg', '188-0311-72', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '3.23', '0.00', '10 mg', 'Prednisolone'), 
('5199', 'Pred   5 mg', '188-0312-72', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '1.72', '0.00', '5 mg', 'Prednisolone'), 
('5200', 'Dextor   .5 mg', '188-0317-72', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '1.00', '0.00', '.5 mg', 'Dexamethasone'), 
('5201', 'Cloron   1 mg', '188-03366', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '5.00', '0.00', '1 mg', 'Clonazepam'), 
('5202', 'Pivasta   2 mg', '188-0332-61', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '2 mg', 'Pitavastatin'), 
('5203', 'Dialon 3   3 mg', '188-0345', 'Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '10.00', '0.00', '3 mg', 'Glimepiride'), 
('5204', 'Triject  IM   1 gm', '188-0195-23', 'IM Injection', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('5205', 'Triject  IM  mg   250 mg', '188-0193-23', 'IM Injection', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('5206', 'Triject  IM0   500 mg', '188-0194-23', 'IM Injection', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('5207', 'Triject  IV  mg   250 mg', '188-0190-23', 'IV Injection', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('5208', 'Triject  IV   1 gm', '188-0192-23', 'IV Injection', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('5209', 'Triject  IV0   500 mg', '188-0191-23', 'IV Injection', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('5210', 'Nortid  TR    100 mg', '188-0048-64', 'Sr Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('5211', 'Quinox  XR   1 gm', '188-0275-23', 'Sr Tablet', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '0.00', '0.00', '1 gm', 'Ciprofloxacin'), 
('5212', 'Flucloxin   250 mg', '387-0025-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd., Narayanganj', '5.77', '0.00', '250 mg', 'Flucloxacillin'), 
('5213', 'Flucloxin00   500 mg', '387-0026-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd., Narayanganj', '10.50', '0.00', '500 mg', 'Flucloxacillin'), 
('5214', 'SK-Mox   250 mg', '387-0028-023', 'Capsule', 'Eskayef Pharmaceuticals Ltd., Narayanganj', '3.55', '0.00', '250 mg', 'Amoxicillin'), 
('5215', 'SK-Mox00   500 mg', '387-0029-23', 'Capsule', 'Eskayef Pharmaceuticals Ltd., Narayanganj', '6.09', '0.00', '500 mg', 'Amoxicillin'), 
('5216', 'Water for Injection   10 ml', '387-0033-079', 'Injection', 'Eskayef Pharmaceuticals Ltd., Narayanganj', '0.00', '0.00', '10 ml', 'Water For Injection'), 
('5217', 'Tialin5% Powder (Vet)   45 %', '387-0002-077', 'Powder', 'Eskayef Pharmaceuticals Ltd., Narayanganj', '1103.06', '0.00', '45 %', 'Tiamulin Hydrogen Fumerate'), 
('5218', 'Amprol%   20 %', '387-0008-077', 'Powder', 'Eskayef Pharmaceuticals Ltd., Narayanganj', '213.44', '0.00', '20 %', 'Amprolium'), 
('5219', 'Eskapar0% Powder (Vet)   100 %', '387-0010-077', 'Powder', 'Eskayef Pharmaceuticals Ltd., Narayanganj', '173.42', '0.00', '100 %', 'Piperazine'), 
('5220', 'Eskamox (Vet) Powder   30 %', '387-0037-077', 'Powder', 'Eskayef Pharmaceuticals Ltd., Narayanganj', '0.00', '0.00', '30 %', 'Amoxicillin'), 
('5221', 'Isobgul Powder   3.5 gm', '387-0021-60', 'Sachet', 'Eskayef Pharmaceuticals Ltd., Narayanganj', '0.00', '0.00', '3.5 gm', 'Ispaghula Husk'), 
('5222', 'Supoxim0   100 mg', '078-0097-23', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '100 mg', 'Cefpodoxime'), 
('5223', 'Doxy0   100 mg', '078-0051-23', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('5224', 'Emoxil   500 mg', '078-0049-23', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('5225', 'Flunid   500 mg', '078-0070-23', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('5226', 'Gastril      20 mg', '078-0073-67', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('5227', 'Tetrac   250 mg', '078-0023-23', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '250 mg', 'Oxytetracycline'), 
('5228', 'Trimix     200 mg', '078-0091-23', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('5229', 'Urodox   500 mg', '078-0094-23', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '500 mg', 'Cefadroxil'), 
('5230', 'Elocef   500 mg', '078-0055-23', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('5231', 'Elocef   250 mg', '078-0054-023', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '250 mg', 'Cephradine'), 
('5232', 'Flunid   250 mg', '078-0082-23', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('5233', 'Emoxil   250 mg', '078-0013-023', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('5234', 'Gaspro      20 mg', '078-0087-067', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '20 mg', 'Esomeprazole'), 
('5235', 'Ambeet   75 mg', '078-0177-31', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '75 mg', 'Ambroxol'), 
('5236', 'Trixim00   400 mg', '078-0192-23', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '400 mg', 'Cefixime'), 
('5237', 'Gaspro0   40 mg', '078-0194-067', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '40 mg', 'Esomeprazole'), 
('5238', 'Rispain SR   100 mg', '078-0196-64', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('5239', 'Maclid   250 mg', '276-0230-23', 'Capsule', 'Ethical Drug Ltd.', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('5240', 'Water For Inejction   1 ml', '078-0158-79', 'Injection', 'Ethical Drug Ltd.', '0.00', '0.00', '1 ml', 'Water For Injection'), 
('5241', 'Ulose   68 %', '078-0101-60', 'Oral Solution', 'Ethical Drug Ltd.', '0.00', '0.00', '68 %', 'Lactulose'), 
('5242', 'Metrifon   100 %', '078-0059-077', 'Powder', 'Ethical Drug Ltd.', '0.00', '0.00', '100 %', 'Metriphonate'), 
('5243', 'Moxipen   20 %', '078-0077-077', 'Powder', 'Ethical Drug Ltd.', '0.00', '0.00', '20 %', 'Amoxicillin'), 
('5244', 'Nalcin   100 %', '078-0058-077', 'Powder', 'Ethical Drug Ltd.', '0.00', '0.00', '100 %', 'Nalidixic Acid'), 
('5245', 'Therazin0   100 %', '078-0019-077', 'Powder', 'Ethical Drug Ltd.', '0.00', '0.00', '100 %', 'Piperazine'), 
('5246', 'Warmex0   100 %', '078-0062-077', 'Powder', 'Ethical Drug Ltd.', '0.00', '0.00', '100 %', 'Piperazine'), 
('5247', 'Etracin%   20 %', '078-0197-077', 'Powder', 'Ethical Drug Ltd.', '0.00', '0.00', '20 %', 'Oxytetracycline'), 
('5248', 'Moxipen%   30 %', '078-0207-077', 'Powder', 'Ethical Drug Ltd.', '0.00', '0.00', '30 %', 'Amoxicillin'), 
('5249', 'Dimes   80 mg', '078-0084', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '80 mg', 'Gliclazide'), 
('5250', 'Dremex   3 mg', '078-00907', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('5251', 'E Hexin   16 mg', '078-0046-031', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '16 mg', 'Bromhexine Hydrochloride'), 
('5252', 'Efloxin   500 mg', '078-0048-23', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('5253', 'Efloxin   250 mg', '078-0022-23', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('5254', 'Shigno     200 mg', '078-0085-23', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '200 mg', 'Pivmecillinam'), 
('5255', 'Ethidin0   150 mg', '078-00125', 'Tablet', 'Ethical Drug Ltd.', '1.50', '0.00', '150 mg', 'Ranitidine'), 
('5256', 'Sugacon   850 mg', '078-0086', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('5257', 'Urix   125 mg', '078-0095-23', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '125 mg', 'Cefuroxime'), 
('5258', 'Urix   250 mg', '078-0096-23', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '250 mg', 'Cefuroxime'), 
('5259', 'Metrid00   400 mg', '078-0003-27', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('5260', 'Nebs   500 mg', '078-0001-006', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('5261', 'Rispain     50 mg', '078-0045-64', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('5262', 'Gaspain0   40 mg', '078-0098-67', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '40 mg', 'Pantoprazole'), 
('5263', 'Lavin   500 mg', '078-0109-23', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('5264', 'Sugacon   500 mg', '078-0087', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('5265', 'Klac   10 mg', '078-0112-064', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('5266', 'Cal Aid   1250 mg', '078-0108-62', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('5267', 'Albol  DS   400 mg', '078-0116-008', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '400 mg', 'Albendazole'), 
('5268', 'Alargol   10 mg', '078-0107-21', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('5269', 'Evit C     250 mg', '078-0053-78', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('5270', 'Eltocin   500 mg', '078-0074-23', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('5271', 'NIZ   500 mg', '078-0166-27', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '500 mg', 'Nitazoxanide'), 
('5272', 'Gaspain   20 mg', '078-0162-67', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '20 mg', 'Pantoprazole'), 
('5273', 'Eurix00   500 mg', '078-0193-23', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '500 mg', 'Cefuroxime'), 
('5274', 'Motilium   10 mg', '078-01998', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('5275', 'Tyvas   50 mg', '078-02101', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('5276', 'L-Sol   2 mg', '078-02134', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '2 mg', 'Levosalbutamol'), 
('5277', 'Ventair   10 mg', '078-0216-044', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '10 mg', 'Montelukast'), 
('5278', 'Ethifenmg   1 mg', '078-0223-21', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '1 mg', 'Ketotifen'), 
('5279', 'E-Reb   20 mg', '078-0224-67', 'Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('5280', 'Alzol   600 mg', '078-0034-077', 'Bolus', 'Ethical Drug Ltd.', '0.00', '0.00', '600 mg', 'Albendazole'), 
('5281', 'Ebenda   750 mg', '078-0042-077', 'Bolus', 'Ethical Drug Ltd.', '0.00', '0.00', '750 mg', 'Mebendazole'), 
('5282', 'Emitrex   600 mg', '078-0031-077', 'Bolus', 'Ethical Drug Ltd.', '0.00', '0.00', '600 mg', 'Levamisole'), 
('5283', 'Etratab   500 mg', '078-0024-077', 'Bolus', 'Ethical Drug Ltd.', '0.00', '0.00', '500 mg', 'Oxytetracycline'), 
('5284', 'Etrazol   600 mg', '078-0035-077', 'Bolus', 'Ethical Drug Ltd.', '0.00', '0.00', '600 mg', 'Tetramisole'), 
('5285', 'Fenzol   250 mg', '078-0037-077', 'Bolus', 'Ethical Drug Ltd.', '0.00', '0.00', '250 mg', 'Fenbendazole'), 
('5286', 'Morentel   446 mg', '078-0080-077', 'Bolus', 'Ethical Drug Ltd.', '0.00', '0.00', '446 mg', 'Morantel'), 
('5287', 'Oxyben   2 gm', '078-0027-077', 'Bolus', 'Ethical Drug Ltd.', '0.00', '0.00', '2 gm', 'Oxybendazole'), 
('5288', 'Bactidin Vet   5 gm', '078-0180-077', 'Bolus', 'Ethical Drug Ltd.', '0.00', '0.00', '5 gm', 'Sulphadimidine'), 
('5289', 'Efloxin Vet   1 gm', '078-0218-077', 'Bolus', 'Ethical Drug Ltd.', '0.00', '0.00', '1 gm', 'Ciprofloxacin'), 
('5290', 'Nilcon IM   250 mg', '078-0183-23', 'IM Injection', 'Ethical Drug Ltd.', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('5291', 'Nilicon IM00   500 mg', '078-0184-23', 'IM Injection', 'Ethical Drug Ltd.', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('5292', 'Nilicon IM G   1 gm', '078-0185-23', 'IM Injection', 'Ethical Drug Ltd.', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('5293', 'Nilicon IV00   500 mg', '078-0153-23', 'IV Injection', 'Ethical Drug Ltd.', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('5294', 'Nilicon  Gm   1 gm', '078-0172-23', 'IV Injection', 'Ethical Drug Ltd.', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('5295', 'Nilicon IV   250 mg', '078-0179-23', 'IV Injection', 'Ethical Drug Ltd.', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('5296', 'Ventair   5 mg', '078-0217-044', 'Chewable Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '5 mg', 'Montelukast'), 
('5297', 'Rispain  SR    100 mg', '078-0117-64', 'Sr Tablet', 'Ethical Drug Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('5298', 'Gap   20 mg', '337-0012-67', 'Capsule', 'Euro Pharma Ltd.', '4.00', '0.00', '20 mg', 'Omeprazole'), 
('5299', 'Cephracap   500 mg', '337-0033-23', 'Capsule', 'Euro Pharma Ltd.', '12.50', '0.00', '500 mg', 'Cephradine'), 
('5300', 'Ceficap   400 mg', '337-0035-23', 'Capsule', 'Euro Pharma Ltd.', '50.00', '0.00', '400 mg', 'Cefixime'), 
('5301', 'Ceficap   200 mg', '337-0036-23', 'Capsule', 'Euro Pharma Ltd.', '30.00', '0.00', '200 mg', 'Cefixime'), 
('5302', 'Flumyc0   150 mg', '337-0039', 'Capsule', 'Euro Pharma Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('5303', 'Alterin TR   100 mg', '337-0057-64', 'Capsule', 'Euro Pharma Ltd.', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('5304', 'Flumyc0   50 mg', '337-0062', 'Capsule', 'Euro Pharma Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('5305', 'Opalgic   50 mg', '337-0070-65', 'Capsule', 'Euro Pharma Ltd.', '8.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('5306', 'GAP   40 mg', '337-0083-67', 'Capsule', 'Euro Pharma Ltd.', '8.00', '0.00', '40 mg', 'Omeprazole'), 
('5307', 'Endamycin   300 mg', '337-0084-23', 'Capsule', 'Euro Pharma Ltd.', '15.00', '0.00', '300 mg', 'Clindamycin'), 
('5308', 'Endamycin0   150 mg', '337-0085-23', 'Capsule', 'Euro Pharma Ltd.', '8.00', '0.00', '150 mg', 'Clindamycin'), 
('5309', 'Flucocin00   500 mg', '337-0100-23', 'Capsule', 'Euro Pharma Ltd.', '10.52', '0.00', '500 mg', 'Flucloxacillin'), 
('5310', 'ADIZ   250 mg', '337-0107-23', 'Capsule', 'Euro Pharma Ltd.', '25.00', '0.00', '250 mg', 'Azithromycin'), 
('5311', 'Water for Injection   10 ml', '337-0118-79', 'Injection', 'Euro Pharma Ltd.', '0.00', '0.00', '10 ml', 'Water For Injection'), 
('5312', 'Laxive   68 %', '337-0056-60', 'Oral Solution', 'Euro Pharma Ltd.', '90.00', '0.00', '68 %', 'Lactulose'), 
('5313', 'Enyl   500 mg', '337-0004-006', 'Tablet', 'Euro Pharma Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('5314', 'Alterin     50 mg', '337-0006-64', 'Tablet', 'Euro Pharma Ltd.', '0.50', '0.00', '50 mg', 'Diclofenac Sodium'), 
('5315', 'EGYL00   400 mg', '337-0007-27', 'Tablet', 'Euro Pharma Ltd.', '1.14', '0.00', '400 mg', 'Metronidazole'), 
('5316', 'Renete0   150 mg', '337-00095', 'Tablet', 'Euro Pharma Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('5317', 'Fixonac0   100 mg', '337-0017-64', 'Tablet', 'Euro Pharma Ltd.', '3.00', '0.00', '100 mg', 'Aceclofenac'), 
('5318', 'Parnil DS   400 mg', '337-0018-008', 'Tablet', 'Euro Pharma Ltd.', '5.00', '0.00', '400 mg', 'Albendazole'), 
('5319', 'Obemet00   500 mg', '337-0019', 'Tablet', 'Euro Pharma Ltd.', '2.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('5320', 'Obemet   850 mg', '337-0020', 'Tablet', 'Euro Pharma Ltd.', '4.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('5321', 'Adiz   500 mg', '337-0031-23', 'Tablet', 'Euro Pharma Ltd.', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('5322', 'Eprox   500 mg', '337-0028-64', 'Tablet', 'Euro Pharma Ltd.', '8.00', '0.00', '500 mg', 'Naproxen'), 
('5323', 'Tiz   10 mg', '337-0027-21', 'Tablet', 'Euro Pharma Ltd.', '2.75', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('5324', 'Egut   10 mg', '337-00248', 'Tablet', 'Euro Pharma Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('5325', 'Eurolac   10 mg', '337-0021-064', 'Tablet', 'Euro Pharma Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('5326', 'Cibact00   500 mg', '337-0011-23', 'Tablet', 'Euro Pharma Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('5327', 'Lopoten   25 mg', '337-0040-022', 'Tablet', 'Euro Pharma Ltd.', '3.50', '0.00', '25 mg', 'Losartan Potassium'), 
('5328', 'Lopoten0   50 mg', '337-0041-022', 'Tablet', 'Euro Pharma Ltd.', '6.00', '0.00', '50 mg', 'Losartan Potassium'), 
('5329', 'Anolol0   50 mg', '337-0042-22', 'Tablet', 'Euro Pharma Ltd.', '0.77', '0.00', '50 mg', 'Atenolol'), 
('5330', 'Anolol0   100 mg', '337-0043-22', 'Tablet', 'Euro Pharma Ltd.', '1.38', '0.00', '100 mg', 'Atenolol'), 
('5331', 'Lezon00   500 mg', '337-0045-23', 'Tablet', 'Euro Pharma Ltd.', '15.00', '0.00', '500 mg', 'Levofloxacin'), 
('5332', 'Esogap   20 mg', '337-0046-067', 'Tablet', 'Euro Pharma Ltd.', '4.00', '0.00', '20 mg', 'Esomeprazole'), 
('5333', 'Desmin   5 mg', '337-0047-21', 'Tablet', 'Euro Pharma Ltd.', '2.50', '0.00', '5 mg', 'Desloratadine'), 
('5334', 'Azmarel   2 mg', '337-00494', 'Tablet', 'Euro Pharma Ltd.', '0.26', '0.00', '2 mg', 'Salbutamol'), 
('5335', 'Azmarel   4 mg', '337-00504', 'Tablet', 'Euro Pharma Ltd.', '0.34', '0.00', '4 mg', 'Salbutamol'), 
('5336', 'Amtinol   5 mg', '337-0052-022', 'Tablet', 'Euro Pharma Ltd.', '4.00', '0.00', '5 mg', 'Amlodipine'), 
('5337', 'Xiopam   3 mg', '337-00537', 'Tablet', 'Euro Pharma Ltd.', '5.00', '0.00', '3 mg', 'Bromazepam'), 
('5338', 'Protozin0   40 mg', '337-0055-67', 'Tablet', 'Euro Pharma Ltd.', '5.00', '0.00', '40 mg', 'Pantoprazole'), 
('5339', 'Eurocal   1250 mg', '337-0061-62', 'Tablet', 'Euro Pharma Ltd.', '3.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('5340', 'Protozin   20 mg', '337-0063-67', 'Tablet', 'Euro Pharma Ltd.', '3.00', '0.00', '20 mg', 'Pantoprazole'), 
('5341', 'Esogap0   40 mg', '337-0064-67', 'Tablet', 'Euro Pharma Ltd.', '7.00', '0.00', '40 mg', 'Esomeprazole'), 
('5342', 'Aster   10 mg', '337-0065-061', 'Tablet', 'Euro Pharma Ltd.', '8.00', '0.00', '10 mg', 'Atorvastatin'), 
('5343', 'Aster   20 mg', '337-0066-061', 'Tablet', 'Euro Pharma Ltd.', '15.00', '0.00', '20 mg', 'Atorvastatin'), 
('5344', 'Spazin   50 mg', '337-00671', 'Tablet', 'Euro Pharma Ltd.', '4.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('5345', 'Misotab   200 mcg', '337-00689', 'Tablet', 'Euro Pharma Ltd.', '15.00', '0.00', '200 mcg', 'Misoprostol'), 
('5346', 'Levotiz   5 mg', '337-0069-21', 'Tablet', 'Euro Pharma Ltd.', '2.50', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('5347', 'Montica   5 mg', '337-0074-044', 'Tablet', 'Euro Pharma Ltd.', '8.00', '0.00', '5 mg', 'Montelukast'), 
('5348', 'Montica   10 mg', '337-0075-044', 'Tablet', 'Euro Pharma Ltd.', '12.00', '0.00', '10 mg', 'Montelukast'), 
('5349', 'Rabepra   20 mg', '337-0078-67', 'Tablet', 'Euro Pharma Ltd.', '5.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('5350', 'Topup   10 mg', '337-0080-043', 'Tablet', 'Euro Pharma Ltd.', '25.00', '0.00', '10 mg', 'Tadalafil'), 
('5351', 'Topup   20 mg', '337-0081-043', 'Tablet', 'Euro Pharma Ltd.', '40.00', '0.00', '20 mg', 'Tadalafil'), 
('5352', 'Mifetab   200 mg', '337-0082-049', 'Tablet', 'Euro Pharma Ltd.', '240.00', '0.00', '200 mg', 'Mifepristone'), 
('5353', 'Osedan   8 mg', '337-00868', 'Tablet', 'Euro Pharma Ltd.', '10.00', '0.00', '8 mg', 'Ondansetron'), 
('5354', 'Easybak   10 mg', '337-0087-70', 'Tablet', 'Euro Pharma Ltd.', '8.00', '0.00', '10 mg', 'Baclofen'), 
('5355', 'Cofof   50 mg', '337-0088-31', 'Tablet', 'Euro Pharma Ltd.', '10.00', '0.00', '50 mg', 'Butamirate Citrate'), 
('5356', 'Ebtin   10 mg', '337-0089-21', 'Tablet', 'Euro Pharma Ltd.', '6.00', '0.00', '10 mg', 'Ebastine'), 
('5357', 'Clepam   2 mg', '337-0090-046', 'Tablet', 'Euro Pharma Ltd.', '0.00', '0.00', '2 mg', 'Clonazepam'), 
('5358', 'Uroxime00   500 mg', '337-0098-23', 'Tablet', 'Euro Pharma Ltd.', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('5359', 'Nixamid00   500 mg', '337-0093-27', 'Tablet', 'Euro Pharma Ltd.', '10.00', '0.00', '500 mg', 'Nitazoxanide'), 
('5360', 'Torbi   90 mg', '337-0094-64', 'Tablet', 'Euro Pharma Ltd.', '12.00', '0.00', '90 mg', 'Etoricoxib'), 
('5361', 'Torbi   120 mg', '337-0095-64', 'Tablet', 'Euro Pharma Ltd.', '14.00', '0.00', '120 mg', 'Etoricoxib'), 
('5362', 'Vegara0   50 mg', '337-0096-043', 'Tablet', 'Euro Pharma Ltd.', '30.00', '0.00', '50 mg', 'Sildenafil'), 
('5363', 'Geloxin   320 mg', '337-0102-23', 'Tablet', 'Euro Pharma Ltd.', '65.00', '0.00', '320 mg', 'Gemefloxacin'), 
('5364', 'Vegara0   100 mg', '337-0105-043', 'Tablet', 'Euro Pharma Ltd.', '50.00', '0.00', '100 mg', 'Sildenafil'), 
('5365', 'Daporex   30 mg', '337-0108-014', 'Tablet', 'Euro Pharma Ltd.', '30.00', '0.00', '30 mg', 'Dapoxetine'), 
('5366', 'Daporex   60 mg', '337-0109-014', 'Tablet', 'Euro Pharma Ltd.', '50.00', '0.00', '60 mg', 'Dapoxetine'), 
('5367', 'Rupita   10 mg', '337-0113-21', 'Tablet', 'Euro Pharma Ltd.', '10.00', '0.00', '10 mg', 'Rupatadine'), 
('5368', 'Cefokid0   100 mg', '337-0119-23', 'Tablet', 'Euro Pharma Ltd.', '17.00', '0.00', '100 mg', 'Cefpodoxime'), 
('5369', 'Cefokid0   200 mg', '337-0120-23', 'Tablet', 'Euro Pharma Ltd.', '28.00', '0.00', '200 mg', 'Cefpodoxime'), 
('5370', 'Eucron   80 mg', '337-0016', 'Tablet', 'Euro Pharma Ltd.', '6.00', '0.00', '80 mg', 'Gliclazide'), 
('5371', 'Arazin   15 mg', '337-0071-21', 'Tablet', 'Euro Pharma Ltd.', '1.00', '0.00', '15 mg', 'Cinnarizine'), 
('5372', 'Uroxime25   125 mg', '337-0058-23', 'Tablet', 'Euro Pharma Ltd.', '15.00', '0.00', '125 mg', 'Cefuroxime'), 
('5373', 'Uroxime   250 mg', '337-0059-23', 'Tablet', 'Euro Pharma Ltd.', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('5374', 'Cetaxone IM   1 gm', '337-0092-23', 'IM Injection', 'Euro Pharma Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('5375', 'Cetaxone IM   250 mg', '337-0124-23', 'IM Injection', 'Euro Pharma Ltd.', '100.00', '0.00', '250 mg', 'Ceftriaxone'), 
('5376', 'Cetaxone00 IM   500 mg', '337-0125-23', 'IM Injection', 'Euro Pharma Ltd.', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('5377', 'Cetaxone IV Injection   1 gm', '337-0091-23', 'IV Injection', 'Euro Pharma Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('5378', 'Cetaxone IV   2 gm', '337-0123-23', 'IV Injection', 'Euro Pharma Ltd.', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('5379', 'Cetaxone00 IV   500 mg', '337-0126-23', 'IV Injection', 'Euro Pharma Ltd.', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('5380', 'Montica Chewable   4 mg', '337-0073-044', 'Chewable Tablet', 'Euro Pharma Ltd.', '6.00', '0.00', '4 mg', 'Montelukast'), 
('5381', 'Evecef   500 mg', '157-0036-23', 'Capsule', 'Everest Pharmaceuticals Ltd.', '11.00', '0.00', '500 mg', 'Cephradine'), 
('5382', 'Zoom      20 mg', '157-0037-67', 'Capsule', 'Everest Pharmaceuticals Ltd.', '3.50', '0.00', '20 mg', 'Omeprazole'), 
('5383', 'Evexim     200 mg', '157-0051-23', 'Capsule', 'Everest Pharmaceuticals Ltd.', '24.00', '0.00', '200 mg', 'Cefixime'), 
('5384', 'Evedoxim0   100 mg', '157-0052-23', 'Capsule', 'Everest Pharmaceuticals Ltd.', '22.00', '0.00', '100 mg', 'Cefpodoxime'), 
('5385', 'Incin   25 mg', '157-0057-64', 'Capsule', 'Everest Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Indomethacin'), 
('5386', 'TX00   500 mg', '157-00609', 'Capsule', 'Everest Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('5387', 'Niro TR   100 mg', '157-0098-64', 'Capsule', 'Everest Pharmaceuticals Ltd.', '2.50', '0.00', '100 mg', 'Diclofenac Sodium'), 
('5388', 'Zoom0   40 mg', '157-0096-67', 'Capsule', 'Everest Pharmaceuticals Ltd.', '7.00', '0.00', '40 mg', 'Omeprazole'), 
('5389', 'Evexim00   400 mg', '157-0107-23', 'Capsule', 'Everest Pharmaceuticals Ltd.', '45.00', '0.00', '400 mg', 'Cefixime'), 
('5390', 'Derban   1 %', '157-0089-23', 'Cream', 'Everest Pharmaceuticals Ltd.', '0.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('5391', 'Colac   68 %', '157-0039-60', 'Oral Solution', 'Everest Pharmaceuticals Ltd.', '0.00', '0.00', '68 %', 'Lactulose'), 
('5392', 'Evran0   150 mg', '157-00255', 'Tablet', 'Everest Pharmaceuticals Ltd.', '1.50', '0.00', '150 mg', 'Ranitidine'), 
('5393', 'Nam   250 mg', '157-0027-64', 'Tablet', 'Everest Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Mefenamic Acid'), 
('5394', 'Pankil   100 mg', '157-0028-64', 'Tablet', 'Everest Pharmaceuticals Ltd.', '3.00', '0.00', '100 mg', 'Aceclofenac'), 
('5395', 'Al00   400 mg', '157-0029-008', 'Tablet', 'Everest Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Albendazole'), 
('5396', 'ATM   500 mg', '157-0030-23', 'Tablet', 'Everest Pharmaceuticals Ltd.', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('5397', 'Evecal   1250 mg', '157-0031-62', 'Tablet', 'Everest Pharmaceuticals Ltd.', '0.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('5398', 'Ciptec   500 mg', '157-0033-23', 'Tablet', 'Everest Pharmaceuticals Ltd.', '12.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('5399', 'Ciptec      750 mg', '157-0034-23', 'Tablet', 'Everest Pharmaceuticals Ltd.', '14.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('5400', 'Nam   500 mg', '157-0047-64', 'Tablet', 'Everest Pharmaceuticals Ltd.', '3.00', '0.00', '500 mg', 'Mefenamic Acid'), 
('5401', 'Zicat   20 mg', '157-0048-62', 'Tablet', 'Everest Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Zinc'), 
('5402', 'Evdom   10 mg', '157-00448', 'Tablet', 'Everest Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('5403', 'Thylin  SR   300 mg', '157-00564', 'Tablet', 'Everest Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Theophylline'), 
('5404', 'Loce   500 mg', '157-0055-23', 'Tablet', 'Everest Pharmaceuticals Ltd.', '12.00', '0.00', '500 mg', 'Levofloxacin'), 
('5405', 'OS   10 mg', '157-0054-061', 'Tablet', 'Everest Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Atorvastatin'), 
('5406', 'Zinatil   250 mg', '157-0068-23', 'Tablet', 'Everest Pharmaceuticals Ltd.', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('5407', 'PAM   500 mg', '157-0069-006', 'Tablet', 'Everest Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('5408', 'Fcon0   150 mg', '157-0075', 'Tablet', 'Everest Pharmaceuticals Ltd.', '20.00', '0.00', '150 mg', 'Fluconazole'), 
('5409', 'Lacer   5 mg', '157-0078-21', 'Tablet', 'Everest Pharmaceuticals Ltd.', '2.00', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('5410', 'Noxen   500 mg', '157-0079-64', 'Tablet', 'Everest Pharmaceuticals Ltd.', '7.00', '0.00', '500 mg', 'Naproxen'), 
('5411', 'Oltum   10 mg', '157-00861', 'Tablet', 'Everest Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('5412', 'Ezoom   20 mg', '157-0003-067', 'Tablet', 'Everest Pharmaceuticals Ltd.', '4.50', '0.00', '20 mg', 'Esomeprazole'), 
('5413', 'Zinatil00   500 mg', '157-0095-23', 'Tablet', 'Everest Pharmaceuticals Ltd.', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('5414', 'Eres00   500 mg', '157-0097-23', 'Tablet', 'Everest Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('5415', 'Panzum   20 mg', '157-0099-67', 'Tablet', 'Everest Pharmaceuticals Ltd.', '3.00', '0.00', '20 mg', 'Pantoprazole'), 
('5416', 'Ecolac   10 mg', '157-0109-064', 'Tablet', 'Everest Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('5417', 'Panzum0   40 mg', '157-0108-67', 'Tablet', 'Everest Pharmaceuticals Ltd.', '5.00', '0.00', '40 mg', 'Pantoprazole'), 
('5418', 'Sinafil0   50 mg', '157-0111-043', 'Tablet', 'Everest Pharmaceuticals Ltd.', '30.00', '0.00', '50 mg', 'Sildenafil'), 
('5419', 'Sinafil0   100 mg', '157-0112-043', 'Tablet', 'Everest Pharmaceuticals Ltd.', '50.00', '0.00', '100 mg', 'Sildenafil'), 
('5420', 'Niro  SR   100 mg', '157-0074-64', 'Sr Tablet', 'Everest Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('5421', 'AxF   500 mg', '327-0027-23', 'Capsule', 'FnF Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('5422', 'Neome      20 mg', '327-0029-67', 'Capsule', 'FnF Pharmaceuticals Ltd.', '4.00', '0.00', '20 mg', 'Omeprazole'), 
('5423', 'Depain0   100 mg', '327-0064-64', 'Capsule', 'FnF Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('5424', 'Debac   500 mg', '327-0049-23', 'Capsule', 'FnF Pharmaceuticals Ltd.', '10.00', '0.00', '500 mg', 'Flucloxacillin'), 
('5425', 'CRN00   500 mg', '327-0069-23', 'Capsule', 'FnF Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('5426', 'Nuxim   200 mg', '327-0071-23', 'Capsule', 'FnF Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Cefixime'), 
('5427', 'AxF   PLUS%   20 %', '327-0012-077', 'Powder', 'FnF Pharmaceuticals Ltd.', '35.00', '0.00', '20 %', 'Amoxicillin'), 
('5428', 'Cfcin Vet   10 %', '327-0010-077', 'Powder', 'FnF Pharmaceuticals Ltd.', '40.00', '0.00', '10 %', 'Ciprofloxacin'), 
('5429', 'Nucip   500 mg', '327-0026-23', 'Tablet', 'FnF Pharmaceuticals Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('5430', 'Numet00   400 mg', '327-0028-27', 'Tablet', 'FnF Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('5431', 'Nuceta   500 mg', '327-0024-006', 'Tablet', 'FnF Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('5432', 'Nuzith   500 mg', '327-0065-23', 'Tablet', 'FnF Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Azithromycin'), 
('5433', 'Cerzin   10 mg', '327-0050-21', 'Tablet', 'FnF Pharmaceuticals Ltd.', '2.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('5434', 'Delerg   10 mg', '327-0051-21', 'Tablet', 'FnF Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Loratadine'), 
('5435', 'Nunap   250 mg', '327-0053-64', 'Tablet', 'FnF Pharmaceuticals Ltd.', '4.00', '0.00', '250 mg', 'Naproxen'), 
('5436', 'Nudom   10 mg', '327-00558', 'Tablet', 'FnF Pharmaceuticals Ltd.', '2.00', '0.00', '10 mg', 'Domperidone'), 
('5437', 'Ranitidine0   150 mg', '327-00735', 'Tablet', 'FnF Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('5438', 'Alvet   600 mg', '327-0004-077', 'Bolus', 'FnF Pharmaceuticals Ltd.', '6.00', '0.00', '600 mg', 'Albendazole'), 
('5439', 'Antibac   500 mg', '327-0007-077', 'Bolus', 'FnF Pharmaceuticals Ltd.', '3.00', '0.00', '500 mg', 'Oxytetracycline'), 
('5440', 'Antibac P   500 mg', '327-0018-077', 'Bolus', 'FnF Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Oxytetracycline'), 
('5441', 'Niclovet   1 gm', '327-0017-077', 'Bolus', 'FnF Pharmaceuticals Ltd.', '10.00', '0.00', '1 gm', 'Niclosamide'), 
('5442', 'Paravet   2 gm', '327-0001-077', 'Bolus', 'FnF Pharmaceuticals Ltd.', '2.26', '0.00', '2 gm', 'Paracetamol'), 
('5443', 'Promevet   150 mg', '327-0003-077', 'Bolus', 'FnF Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Promethazine Hydrochloride'), 
('5444', 'Safvet   250 mg', '327-0006-077', 'Bolus', 'FnF Pharmaceuticals Ltd.', '6.00', '0.00', '250 mg', 'Fenbendazole'), 
('5445', 'Fenben   250 mg', '327-0023-077', 'Bolus', 'FnF Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Fenbendazole'), 
('5446', 'Flucide   900 mg', '327-0040-077', 'Bolus', 'FnF Pharmaceuticals Ltd.', '0.00', '0.00', '900 mg', 'Triclabendazole'), 
('5447', 'Antibac  DS   1 gm', '327-0038-077', 'Bolus', 'FnF Pharmaceuticals Ltd.', '0.00', '0.00', '1 gm', 'Oxytetracycline'), 
('5448', 'Fcx   250 mg', '015-0500-23', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Flucloxacillin'), 
('5449', 'Fcx   500 mg', '015-0501-23', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('5450', 'Methocid   25 mg', '015-0122-64', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '25 mg', 'Indomethacin'), 
('5451', 'Omitac      20 mg', '015-0373-67', 'Capsule', 'G. A. Company Ltd.', '4.01', '0.00', '20 mg', 'Omeprazole'), 
('5452', 'Phental   250 mg', '015-0033-64', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Mefenamic Acid'), 
('5453', 'Phentin   50 mg', '015-0201-046', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '50 mg', 'Phenytoin Sodium'), 
('5454', 'Rheudene   10 mg', '015-0183-64', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '10 mg', 'Piroxicam'), 
('5455', 'Simpiclox   500 mg', '015-0349-23', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '500 mg', 'Cloxacillin'), 
('5456', 'Unimox   250 mg', '015-0110-023', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('5457', 'Unimox   500 mg', '015-0472-23', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('5458', 'Vitavit Lac   2 Lac IU', '015-0127-78', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '2 Lac IU', 'Vitamin A'), 
('5459', 'Zecef   250 mg', '015-0498-023', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Cephradine'), 
('5460', 'Furamane   15 mg', '015-0214-057', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '15 mg', 'Flurazepam'), 
('5461', 'G Fix     200 mg', '015-0503-23', 'Capsule', 'G. A. Company Ltd.', '35.11', '0.00', '200 mg', 'Cefixime'), 
('5462', 'Lomid   2 mg', '015-02086', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '2 mg', 'Loperamide'), 
('5463', 'Zecef   500 mg', '015-0364-23', 'Capsule', 'G. A. Company Ltd.', '12.54', '0.00', '500 mg', 'Cephradine'), 
('5464', 'Supraphen   250 mg', '015-0050-23', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Chloramphenicol'), 
('5465', 'Subramycin0   100 mg', '015-0126-23', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('5466', 'Hilox   500 mg', '015-0449-23', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '500 mg', 'Dicloxacillin'), 
('5467', 'Taracycline   250 mg', '015-0051-23', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('5468', 'Rifatan50   450 mg', '015-0344-30', 'Capsule', 'G. A. Company Ltd.', '0.00', '0.00', '450 mg', 'Rifampicin'), 
('5469', 'G-Fix00   400 mg', '015-0552-023', 'Capsule', 'G. A. Company Ltd.', '48.00', '0.00', '400 mg', 'Cefixime'), 
('5470', 'Silverzine%   1 %', '015-0227-23', 'Cream', 'G. A. Company Ltd.', '40.12', '0.00', '1 %', 'Silver Sulphadiazine'), 
('5471', 'Gaco Water For Injection   5 ml', '015-0067-79', 'Injection', 'G. A. Company Ltd.', '5.02', '0.00', '5 ml', 'Water For Injection'), 
('5472', 'Unimox   500 mg', '015-0401-23', 'Injection', 'G. A. Company Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('5473', 'Erapen    LAC   5 Lac Unit', '015-0236-23', 'Injection', 'G. A. Company Ltd.', '0.00', '0.00', '5 Lac Unit', 'Benzyl Penicillin'), 
('5474', 'Bactol   4.8 %', '015-0022-29', 'Liquid', 'G. A. Company Ltd.', '0.00', '0.00', '4.8 %', 'Chloroxylenol'), 
('5475', 'Mydripine   1 %', '015-0351-71', 'Ointment', 'G. A. Company Ltd.', '0.00', '0.00', '1 %', 'Atropine Sulphate'), 
('5476', 'Lactil   10 gm', '015-0509-60', 'Powder', 'G. A. Company Ltd.', '0.00', '0.00', '10 gm', 'Lactitol'), 
('5477', 'Glycerin   1.035 gm', '015-0037-060', 'Suppository', 'G. A. Company Ltd.', '0.00', '0.00', '1.035 gm', 'Glycerol'), 
('5478', 'Anil   5 mg', '015-04031', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '5 mg', 'Oxyphenonium Bromide'), 
('5479', 'Bendex0   100 mg', '015-0120-8', 'Tablet', 'G. A. Company Ltd.', '0.75', '0.00', '100 mg', 'Mebendazole'), 
('5480', 'Berdinal   30 mg', '015-0012-046', 'Tablet', 'G. A. Company Ltd.', '0.78', '0.00', '30 mg', 'Phenobarbitone'), 
('5481', 'Brodrine   30 mg', '015-0010', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '30 mg', 'Ephedrine Hydrochloride'), 
('5482', 'Brospan   10 mg', '015-01781', 'Tablet', 'G. A. Company Ltd.', '1.83', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('5483', 'Calcifil   1250 mg', '015-0455-62', 'Tablet', 'G. A. Company Ltd.', '3.27', '0.00', '1250 mg', 'Calcium Carbonate'), 
('5484', 'Calkid   Chewable   625 mg', '015-0484-62', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '625 mg', 'Calcium Carbonate'), 
('5485', 'Caltate   300 mg', '015-0008-62', 'Tablet', 'G. A. Company Ltd.', '0.71', '0.00', '300 mg', 'Calcium Lactate'), 
('5486', 'Carnocide   50 mg', '015-0150-8', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '50 mg', 'Diethylcarbamazine Citrate'), 
('5487', 'Cero   250 mg', '015-0392-23', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('5488', 'Cero   500 mg', '015-0428-23', 'Tablet', 'G. A. Company Ltd.', '14.05', '0.00', '500 mg', 'Ciprofloxacin'), 
('5489', 'Daosin   5 mg', '015-0119', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '5 mg', 'Glibenclamide'), 
('5490', 'Diabex   850 mg', '015-0456', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('5491', 'Diabex   500 mg', '015-0435', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('5492', 'Ecin  DS0   500 mg', '015-0474-23', 'Tablet', 'G. A. Company Ltd.', '75.23', '0.00', '500 mg', 'Erythromycin'), 
('5493', 'Edimox   250 mg', '015-01762', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Acetazolamide'), 
('5494', 'Emomine   25 mg', '015-0190-21', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '25 mg', 'Promethazine Theoclate'), 
('5495', 'Eracillin K     250 mg', '015-0104-23', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('5496', 'Expilin   4 mg', '015-0083-21', 'Tablet', 'G. A. Company Ltd.', '0.20', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('5497', 'Famo      20 mg', '015-03785', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '20 mg', 'Famotidine'), 
('5498', 'Famo0   40 mg', '015-03795', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '40 mg', 'Famotidine'), 
('5499', 'Farevan      5 mg', '015-02152', 'Tablet', 'G. A. Company Ltd.', '3.05', '0.00', '5 mg', 'Warfarin Sodium'), 
('5500', 'Fastril   10 mg', '015-0437-22', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '10 mg', 'Lisinopril'), 
('5501', 'Fermid     50 mg', '015-01973', 'Tablet', 'G. A. Company Ltd.', '10.03', '0.00', '50 mg', 'Clomiphene Citrate'), 
('5502', 'Frusix0   40 mg', '015-01142', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '40 mg', 'Frusemide'), 
('5503', 'Gacopyrin0   300 mg', '015-0006-6', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '300 mg', 'Aspirin'), 
('5504', 'Grifulvin   500 mg', '015-0235', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '500 mg', 'Griseofulvin'), 
('5505', 'Helmisole   40 mg', '015-0106-8', 'Tablet', 'G. A. Company Ltd.', '0.41', '0.00', '40 mg', 'Levamisole'), 
('5506', 'Hemergin   200 mcg', '015-04079', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '200 mcg', 'Methyl Ergometrine Maleate'), 
('5507', 'Hexin   250 mg', '015-0460-23', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Cephalexin'), 
('5508', 'Hexin   500 mg', '015-0459-23', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('5509', 'Katen   1 mg', '015-0465-21', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '1 mg', 'Ketotifen'), 
('5510', 'Keezole   200 mg', '015-0418', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '200 mg', 'Ketoconazole'), 
('5511', 'Lemon C CHEWABLE    250 mg', '015-0137-78', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('5512', 'Lepsone0   100 mg', '015-0175-030', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '100 mg', 'Dapsone'), 
('5513', 'Manil   135 mg', '015-04301', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '135 mg', 'Mebeverine Hydrochloride'), 
('5514', 'Melatil   5 mg', '015-01808', 'Tablet', 'G. A. Company Ltd.', '0.45', '0.00', '5 mg', 'Prochlorperazine Maleate'), 
('5515', 'Meradexon   .5 mg', '015-0154-72', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '.5 mg', 'Dexamethasone'), 
('5516', 'Movain   10 mg', '015-01778', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '10 mg', 'Metoclopramide Hydrochloride'), 
('5517', 'Naprocid   500 mg', '015-0464-64', 'Tablet', 'G. A. Company Ltd.', '7.02', '0.00', '500 mg', 'Naproxen'), 
('5518', 'Naprocid   250 mg', '015-0436-64', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Naproxen'), 
('5519', 'Negaron   25 mg', '015-0416-21', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '25 mg', 'Cinnarizine'), 
('5520', 'Octon      5 mg', '015-0444-057', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '5 mg', 'Nitrazepam'), 
('5521', 'Pancrestal   325 mg', '015-04081', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '325 mg', 'Pancreatin'), 
('5522', 'Peldol      5 mg', '015-0417-28', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '5 mg', 'Haloperidol'), 
('5523', 'Peldol.5   1.5 mg', '015-0155-28', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '1.5 mg', 'Haloperidol'), 
('5524', 'Prednicortil      5 mg', '015-0153-72', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '5 mg', 'Prednisolone'), 
('5525', 'Propanthene   15 mg', '015-01161', 'Tablet', 'G. A. Company Ltd.', '1.31', '0.00', '15 mg', 'Propantheline Bromide'), 
('5526', 'Pyroxin   25 mg', '015-0442-78', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '25 mg', 'Pyridoxine Hydrochloride'), 
('5527', 'Restophylline0   100 mg', '015-01214', 'Tablet', 'G. A. Company Ltd.', '0.38', '0.00', '100 mg', 'Aminophylline'), 
('5528', 'Reufen00   400 mg', '015-0238-64', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '400 mg', 'Ibuprofen'), 
('5529', 'Reutren     50 mg', '015-0357-64', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('5530', 'Reutren      25 mg', '015-0343-64', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '25 mg', 'Diclofenac Sodium'), 
('5531', 'Ribovit   5 mg', '015-0045-79', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '5 mg', 'Riboflavin'), 
('5532', 'Rizin   10 mg', '015-0452-21', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('5533', 'Sedopam      5 mg', '015-0091-057', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '5 mg', 'Diazepam'), 
('5534', 'Stomolax   300 mg', '015-0211-60', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '300 mg', 'Sennosides'), 
('5535', 'Terovit   5 mg', '015-01685', 'Tablet', 'G. A. Company Ltd.', '0.31', '0.00', '5 mg', 'Folic Acid'), 
('5536', 'Timidal   500 mg', '015-0092-006', 'Tablet', 'G. A. Company Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('5537', 'Fastril      5 mg', '015-0447-22', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '5 mg', 'Lisinopril'), 
('5538', 'Unitac0   150 mg', '015-02265', 'Tablet', 'G. A. Company Ltd.', '1.81', '0.00', '150 mg', 'Ranitidine'), 
('5539', 'Venol  SR   8 mg', '015-04884', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '8 mg', 'Salbutamol'), 
('5540', 'Vitavit   50000 IU', '015-0389-78', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '50000 IU', 'Vitamin A'), 
('5541', 'Zemycin   500 mg', '015-0473-23', 'Tablet', 'G. A. Company Ltd.', '30.09', '0.00', '500 mg', 'Azithromycin'), 
('5542', 'Aldex  DS   400 mg', '015-0481-008', 'Tablet', 'G. A. Company Ltd.', '4.02', '0.00', '400 mg', 'Albendazole'), 
('5543', 'Bendex   500 mg', '015-0493-8', 'Tablet', 'G. A. Company Ltd.', '2.76', '0.00', '500 mg', 'Mebendazole'), 
('5544', 'Cardopyrin      75 mg', '015-0518-26', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '75 mg', 'Aspirin'), 
('5545', 'Esmotac0   40 mg', '015-0519-67', 'Tablet', 'G. A. Company Ltd.', '7.03', '0.00', '40 mg', 'Esomeprazole'), 
('5546', 'Esmotac      20 mg', '015-0520-067', 'Tablet', 'G. A. Company Ltd.', '4.02', '0.00', '20 mg', 'Esomeprazole'), 
('5547', 'Aloric0   100 mg', '015-0175-76', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '100 mg', 'Allopurinol'), 
('5548', 'Livacin   500 mg', '015-0521-23', 'Tablet', 'G. A. Company Ltd.', '15.05', '0.00', '500 mg', 'Levofloxacin'), 
('5549', 'Mulyt   8 mg', '015-0524-031', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '8 mg', 'Bromhexine Hydrochloride'), 
('5550', 'Nelagyl00   400 mg', '015-0475-27', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('5551', 'Promergan      25 mg', '015-0184-21', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '25 mg', 'Promethazine Hydrochloride'), 
('5552', 'Cardopyrin0   100 mg', '015-0451-26', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '100 mg', 'Aspirin'), 
('5553', 'Venol   4 mg', '015-04254', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '4 mg', 'Salbutamol'), 
('5554', 'Ecin   250 mg', '015-0066-23', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Erythromycin'), 
('5555', 'Nequine   250 mg', '015-0100-24', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Chloroquine Phosphate'), 
('5556', 'Cero      750 mg', '015-0492-23', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('5557', 'Lexomide   500 mg', '015-0352-27', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '500 mg', 'Diloxanide Furoate'), 
('5558', 'Unidon   10 mg', '015-8', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '10 mg', 'Domperidone'), 
('5559', 'Thural   400 mg', '015-0194-30', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '400 mg', 'Ethambutol'), 
('5560', 'Feton     200 mg', '015-01085', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '200 mg', 'Ferrous Sulphate'), 
('5561', 'Reufen     200 mg', '015-0171-64', 'Tablet', 'G. A. Company Ltd.', '0.40', '0.00', '200 mg', 'Ibuprofen'), 
('5562', 'Isonid0   300 mg', '015--30', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '300 mg', 'Isoniazid'), 
('5563', 'Mebcidal   50 mg', '015-0414-21', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '50 mg', 'Mebhydrolin'), 
('5564', 'Nelagyl     200 mg', '015-0093-27', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '200 mg', 'Metronidazole'), 
('5565', 'Delcard   60 mg', '015-0434-22', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '60 mg', 'Diltiazem Hydrochloride'), 
('5566', 'Presoral0   40 mg', '015-0136-23', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '40 mg', 'Propranolol Hydrochloride'), 
('5567', 'Venol   2 mg', '015-01494', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '2 mg', 'Salbutamol'), 
('5568', 'Pyramide   500 mg', '015-0193-30', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '500 mg', 'Pyrazinamide'), 
('5569', 'Costatin   5 Lac Unit', '015-0369', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '5 Lac Unit', 'Nystatin'), 
('5570', 'Kiltel     200 mg', '015-0372-008', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '200 mg', 'Albendazole'), 
('5571', 'Pantozol      20 mg', '015-0494-67', 'Tablet', 'G. A. Company Ltd.', '3.01', '0.00', '20 mg', 'Pantoprazole'), 
('5572', 'Pantozol0   40 mg', '015-0495-67', 'Tablet', 'G. A. Company Ltd.', '5.02', '0.00', '40 mg', 'Pantoprazole'), 
('5573', 'Oflin     200 mg', '015-0507-23', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '200 mg', 'Ofloxacin'), 
('5574', 'Levogic  F/C   5 mg', '015-0536-21', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('5575', 'Xpain   100 mg', '015-0537-64', 'Tablet', 'G. A. Company Ltd.', '13.50', '0.00', '100 mg', 'Aceclofenac'), 
('5576', 'Kerolac   10 mg', '015-0523-064', 'Tablet', 'G. A. Company Ltd.', '10.03', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('5577', 'Cematil   250 mg', '015-054-23', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '250 mg', 'Cefuroxime'), 
('5578', 'Oxylin   500 mg', '015-0530-23', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '500 mg', 'Oxytetracycline'), 
('5579', 'FD-60   60 mg', '015-0549-21', 'Tablet', 'G. A. Company Ltd.', '3.50', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('5580', 'FD20   120 mg', '015-0550-21', 'Tablet', 'G. A. Company Ltd.', '7.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('5581', 'Dozy   3 mg', '015-05517', 'Tablet', 'G. A. Company Ltd.', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('5582', 'Brocef00   500 mg', '015-0554-023', 'Tablet', 'G. A. Company Ltd.', '43.00', '0.00', '500 mg', 'Cefuroxime'), 
('5583', 'Brocef   250 mg', '015-0553-023', 'Tablet', 'G. A. Company Ltd.', '24.00', '0.00', '250 mg', 'Cefuroxime'), 
('5584', 'Synex Nasal Drops .05%   .05 %', '015-05292', 'Nasal Drops', 'G. A. Company Ltd.', '0.00', '0.00', '.05 %', 'Oxymetazoline Hydrochloride'), 
('5585', 'Meloptol%   .25 %', '015-03542', 'Eye Drops', 'G. A. Company Ltd.', '0.00', '0.00', '.25 %', 'Timolol Maleate'), 
('5586', 'Meloptol%   .5 %', '015-03552', 'Eye Drops', 'G. A. Company Ltd.', '0.00', '0.00', '.5 %', 'Timolol Maleate'), 
('5587', 'Tear%   .5 %', '015-04272', 'Eye Drops', 'G. A. Company Ltd.', '90.27', '0.00', '.5 %', 'Hypromellose'), 
('5588', 'Flucort   .1 %', '015-04432', 'Eye Drops', 'G. A. Company Ltd.', '90.27', '0.00', '.1 %', 'Fluorometholone'), 
('5589', 'Miocarpine%   1 %', '015-2', 'Eye Drops', 'G. A. Company Ltd.', '0.00', '0.00', '1 %', 'Pilocarpine Hydrochloride'), 
('5590', 'Miocarpine%   2 %', '015-2', 'Eye Drops', 'G. A. Company Ltd.', '0.00', '0.00', '2 %', 'Pilocarpine Hydrochloride'), 
('5591', 'Rocular   .2 %', '015-05422', 'Eye Drops', 'G. A. Company Ltd.', '80.24', '0.00', '.2 %', 'Brimonidine Tartrate'), 
('5592', 'Reutren  SR    100 mg', '015-0385-64', 'Sr Tablet', 'G. A. Company Ltd.', '3.01', '0.00', '100 mg', 'Diclofenac Sodium'), 
('5593', 'Water for Injection   1 ml', '362-0107-79', 'Injection', 'General Pharmaceuticals Ltd, Unit-2', '0.00', '0.00', '1 ml', 'Water For Injection'), 
('5594', 'Imacef IM   1 gm', '362-0104-23', 'IM Injection', 'General Pharmaceuticals Ltd, Unit-2', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('5595', 'Imacef00 IM   500 mg', '362-0105-23', 'IM Injection', 'General Pharmaceuticals Ltd, Unit-2', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('5596', 'Imacef IV   2 gm', '362-0102-23', 'IV Injection', 'General Pharmaceuticals Ltd, Unit-2', '302.04', '0.00', '2 gm', 'Ceftriaxone'), 
('5597', 'Imacef IV   1 gm', '362-0103-23', 'IV Injection', 'General Pharmaceuticals Ltd, Unit-2', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('5598', 'Powersol IV   5 %', '362-0032-3', 'IV Infusion', 'General Pharmaceuticals Ltd, Unit-2', '351.06', '0.00', '5 %', 'Amino Acids (Essential)'), 
('5599', 'Nasalox.025%   .025 %', '362-00722', 'Nasal Drops', 'General Pharmaceuticals Ltd, Unit-2', '40.12', '0.00', '.025 %', 'Oxymetazoline Hydrochloride'), 
('5600', 'Nasalox.05%   .05 %', '362-00732', 'Nasal Drops', 'General Pharmaceuticals Ltd, Unit-2', '45.13', '0.00', '.05 %', 'Oxymetazoline Hydrochloride'), 
('5601', 'Ocutifen   .025 %', '362-00202', 'Eye Drops', 'General Pharmaceuticals Ltd, Unit-2', '95.29', '0.00', '.025 %', 'Ketotifen'), 
('5602', 'Flurolon   .1 %', '362-00362', 'Eye Drops', 'General Pharmaceuticals Ltd, Unit-2', '100.30', '0.00', '.1 %', 'Fluorometholone'), 
('5603', 'Gemolol   .5 %', '362-00392', 'Eye Drops', 'General Pharmaceuticals Ltd, Unit-2', '70.21', '0.00', '.5 %', 'Timolol Maleate'), 
('5604', 'Homatogen   2 %', '362-00612', 'Eye Drops', 'General Pharmaceuticals Ltd, Unit-2', '0.00', '0.00', '2 %', 'Homatropine Hydrobromide'), 
('5605', 'Doxigen0   100 mg', '240-0019-23', 'Capsule', 'General Pharmaceuticals Ltd.', '2.16', '0.00', '100 mg', 'Doxycycline'), 
('5606', 'Fenolid     200 mg', '240-0132-61', 'Capsule', 'General Pharmaceuticals Ltd.', '7.05', '0.00', '200 mg', 'Fenofibrate'), 
('5607', 'Floxapen   500 mg', '240-0069-23', 'Capsule', 'General Pharmaceuticals Ltd.', '10.57', '0.00', '500 mg', 'Flucloxacillin'), 
('5608', 'Floxapen   250 mg', '240-0030-23', 'Capsule', 'General Pharmaceuticals Ltd.', '5.78', '0.00', '250 mg', 'Flucloxacillin'), 
('5609', 'Genamox   500 mg', '240-0045-23', 'Capsule', 'General Pharmaceuticals Ltd.', '6.76', '0.00', '500 mg', 'Amoxicillin'), 
('5610', 'Ketofen0   100 mg', '240-0061-64', 'Capsule', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Ketoprofen'), 
('5611', 'Mucolex   375 mg', '240-0120-31', 'Capsule', 'General Pharmaceuticals Ltd.', '2.52', '0.00', '375 mg', 'Carbocisteine'), 
('5612', 'Trumen     50 mg', '240-0036-65', 'Capsule', 'General Pharmaceuticals Ltd.', '6.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('5613', 'Prevas      20 mg', '240-0121-67', 'Capsule', 'General Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('5614', 'Prevas0   40 mg', '240-0122-67', 'Capsule', 'General Pharmaceuticals Ltd.', '7.05', '0.00', '40 mg', 'Omeprazole'), 
('5615', 'Ronac  TR    100 mg', '240-0047-64', 'Capsule', 'General Pharmaceuticals Ltd.', '3.02', '0.00', '100 mg', 'Diclofenac Sodium'), 
('5616', 'Tetragen   250 mg', '240-0014-23', 'Capsule', 'General Pharmaceuticals Ltd.', '1.36', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('5617', 'Tocef     200 mg', '240-0074-23', 'Capsule', 'General Pharmaceuticals Ltd.', '30.20', '0.00', '200 mg', 'Cefixime'), 
('5618', 'Velogen   250 mg', '240-0021-023', 'Capsule', 'General Pharmaceuticals Ltd.', '6.54', '0.00', '250 mg', 'Cephradine'), 
('5619', 'Velogen   500 mg', '240-0039-23', 'Capsule', 'General Pharmaceuticals Ltd.', '12.59', '0.00', '500 mg', 'Cephradine'), 
('5620', 'Zoton   15 mg', '240-0052-67', 'Capsule', 'General Pharmaceuticals Ltd.', '3.52', '0.00', '15 mg', 'Lansoprazole'), 
('5621', 'Zoton   30 mg', '240-0051-67', 'Capsule', 'General Pharmaceuticals Ltd.', '6.04', '0.00', '30 mg', 'Lansoprazole'), 
('5622', 'Galfin     50 mg', '240-0178', 'Capsule', 'General Pharmaceuticals Ltd.', '8.05', '0.00', '50 mg', 'Fluconazole'), 
('5623', 'Desbac0   100 mg', '240-0226-23', 'Capsule', 'General Pharmaceuticals Ltd.', '22.13', '0.00', '100 mg', 'Cefpodoxime'), 
('5624', 'Nufex   500 mg', '240-0041-23', 'Capsule', 'General Pharmaceuticals Ltd.', '9.06', '0.00', '500 mg', 'Cephalexin'), 
('5625', 'Nodep   20 mg', '240-00604', 'Capsule', 'General Pharmaceuticals Ltd.', '2.81', '0.00', '20 mg', 'Fluoxetine'), 
('5626', 'Genamox   250 mg', '240-0015-023', 'Capsule', 'General Pharmaceuticals Ltd.', '3.61', '0.00', '250 mg', 'Amoxicillin'), 
('5627', 'Galfin0   150 mg', '240-0264', 'Capsule', 'General Pharmaceuticals Ltd.', '22.15', '0.00', '150 mg', 'Fluconazole'), 
('5628', 'Prebalin     50 mg', '240-0278-046', 'Capsule', 'General Pharmaceuticals Ltd.', '12.04', '0.00', '50 mg', 'Pregabalin'), 
('5629', 'Prebalin0   100 mg', '240-0279-046', 'Capsule', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Pregabalin'), 
('5630', 'Pandolac0   300 mg', '240-0308-64', 'Capsule', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Etodolac'), 
('5631', 'Slipam   15 mg', '240-0304-057', 'Capsule', 'General Pharmaceuticals Ltd.', '4.51', '0.00', '15 mg', 'Flurazepam'), 
('5632', 'Slipam   30 mg', '240-0305-057', 'Capsule', 'General Pharmaceuticals Ltd.', '8.03', '0.00', '30 mg', 'Flurazepam'), 
('5633', 'Tocef00   400 mg', '240-0328-23', 'Capsule', 'General Pharmaceuticals Ltd.', '50.34', '0.00', '400 mg', 'Cefixime'), 
('5634', 'E-Fill0   200 mg', '240-0341-78', 'Capsule', 'General Pharmaceuticals Ltd.', '4.04', '0.00', '200 mg', 'Vitamin E'), 
('5635', 'E-Fill00   400 mg', '240-0342-78', 'Capsule', 'General Pharmaceuticals Ltd.', '6.04', '0.00', '400 mg', 'Vitamin E'), 
('5636', 'Mintol   .2 ml', '240-0346', 'Capsule', 'General Pharmaceuticals Ltd.', '7.05', '0.00', '.2 ml', 'Peppermint Oil'), 
('5637', 'Desbac0   200 mg', '240-0345-23', 'Capsule', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Cefpodoxime'), 
('5638', 'Multiseas   300 mg', '240-0352', 'Capsule', 'General Pharmaceuticals Ltd.', '3.01', '0.00', '300 mg', 'Cod Liver Oil'), 
('5639', 'Prebalin   75 mg', '240-0349-046', 'Capsule', 'General Pharmaceuticals Ltd.', '16.11', '0.00', '75 mg', 'Pregabalin'), 
('5640', 'Prebalin0   150 mg', '240-0350-046', 'Capsule', 'General Pharmaceuticals Ltd.', '30.20', '0.00', '150 mg', 'Pregabalin'), 
('5641', 'Cleodin0   150 mg', '240-0374-23', 'Capsule', 'General Pharmaceuticals Ltd.', '6.00', '0.00', '150 mg', 'Clindamycin'), 
('5642', 'Cleodin   300 mg', '240-0375-23', 'Capsule', 'General Pharmaceuticals Ltd.', '15.04', '0.00', '300 mg', 'Clindamycin'), 
('5643', 'Rose00   500 mg', '240-0402-71', 'Capsule', 'General Pharmaceuticals Ltd.', '8.03', '0.00', '500 mg', 'Primrose Oil'), 
('5644', 'Q10 -   30 mg', '240-0398', 'Capsule', 'General Pharmaceuticals Ltd.', '8.03', '0.00', '30 mg', 'Coenzyme Q10 (Ubidecarenone)'), 
('5645', 'Q10 -   60 mg', '240-0399', 'Capsule', 'General Pharmaceuticals Ltd.', '15.04', '0.00', '60 mg', 'Coenzyme Q10 (Ubidecarenone)'), 
('5646', 'Astagen   2 mg', '240-0403', 'Capsule', 'General Pharmaceuticals Ltd.', '12.04', '0.00', '2 mg', 'Astaxanthin'), 
('5647', 'Astagen   4 mg', '240-0404', 'Capsule', 'General Pharmaceuticals Ltd.', '22.07', '0.00', '4 mg', 'Astaxanthin'), 
('5648', 'Cebumax00   400 mg', '240-0453-23', 'Capsule', 'General Pharmaceuticals Ltd.', '120.00', '0.00', '400 mg', 'Ceftibuten'), 
('5649', 'Prebalin   25 mg', '240-0463-046', 'Capsule', 'General Pharmaceuticals Ltd.', '8.00', '0.00', '25 mg', 'Pregabalin'), 
('5650', 'Healburn   1 %', '240-0384-23', 'Cream', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('5651', 'Water for Injection   10 ml', '240-0359-79', 'Injection', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '10 ml', 'Water For Injection'), 
('5652', 'Regulose   68 %', '240-0033-60', 'Oral Solution', 'General Pharmaceuticals Ltd.', '10.07', '0.00', '68 %', 'Lactulose'), 
('5653', 'Alzed00   400 mg', '240-0029-008', 'Tablet', 'General Pharmaceuticals Ltd.', '3.32', '0.00', '400 mg', 'Albendazole'), 
('5654', 'Amit   10 mg', '240-01804', 'Tablet', 'General Pharmaceuticals Ltd.', '0.85', '0.00', '10 mg', 'Amitriptyline Hydrochloride'), 
('5655', 'Amit      25 mg', '240-01794', 'Tablet', 'General Pharmaceuticals Ltd.', '1.76', '0.00', '25 mg', 'Amitriptyline Hydrochloride'), 
('5656', 'Anquil   15 mg', '240-0076-057', 'Tablet', 'General Pharmaceuticals Ltd.', '15.11', '0.00', '15 mg', 'Midazolam'), 
('5657', 'Anquil      7.5 mg', '240-0046-057', 'Tablet', 'General Pharmaceuticals Ltd.', '8.05', '0.00', '7.5 mg', 'Midazolam'), 
('5658', 'Anreb      25 mg', '240-0163-022', 'Tablet', 'General Pharmaceuticals Ltd.', '4.51', '0.00', '25 mg', 'Losartan Potassium'), 
('5659', 'Anreb     50 mg', '240-0162-022', 'Tablet', 'General Pharmaceuticals Ltd.', '8.03', '0.00', '50 mg', 'Losartan Potassium'), 
('5660', 'Antilid   600 mg', '240-0136-023', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '600 mg', 'Linezolid'), 
('5661', 'Antilid00   400 mg', '240-0137-023', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Linezolid'), 
('5662', 'Arolef0   100 mg', '240-0080-64', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Leflunomide'), 
('5663', 'Arolef      20 mg', '240-0095-64', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Leflunomide'), 
('5664', 'Azomac   500 mg', '240-0158-23', 'Tablet', 'General Pharmaceuticals Ltd.', '35.00', '0.00', '500 mg', 'Azithromycin'), 
('5665', 'Broxine   8 mg', '240-0169-031', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '8 mg', 'Bromhexine Hydrochloride'), 
('5666', 'Calchek      5 mg', '240-0034-022', 'Tablet', 'General Pharmaceuticals Ltd.', '5.01', '0.00', '5 mg', 'Amlodipine'), 
('5667', 'Candesa   4 mg', '240-0129-22', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Candesartan Cilexetil'), 
('5668', 'Candesa   8 mg', '240-0130-22', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '8 mg', 'Candesartan Cilexetil'), 
('5669', 'Cereton   5 mg', '240-0028-36', 'Tablet', 'General Pharmaceuticals Ltd.', '4.04', '0.00', '5 mg', 'Vinpocetine'), 
('5670', 'Citapram      20 mg', '240-01164', 'Tablet', 'General Pharmaceuticals Ltd.', '8.05', '0.00', '20 mg', 'Citalopram Hydrobromide'), 
('5671', 'Clotab     50 mg', '240-0037-64', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('5672', 'Costin   1250 mg', '240-0110-62', 'Tablet', 'General Pharmaceuticals Ltd.', '3.01', '0.00', '1250 mg', 'Calcium Carbonate'), 
('5673', 'Depixol   .5 mg', '240-0161-28', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '.5 mg', 'Flupenthixol'), 
('5674', 'Depixol   1 mg', '240-0160-28', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '1 mg', 'Flupenthixol'), 
('5675', 'Dilgard   12.5 mg', '240-0089-22', 'Tablet', 'General Pharmaceuticals Ltd.', '5.04', '0.00', '12.5 mg', 'Carvedilol'), 
('5676', 'Dilgard      25 mg', '240-0088-22', 'Tablet', 'General Pharmaceuticals Ltd.', '8.05', '0.00', '25 mg', 'Carvedilol'), 
('5677', 'Dilgard   6.25 mg', '240-0090-22', 'Tablet', 'General Pharmaceuticals Ltd.', '3.02', '0.00', '6.25 mg', 'Carvedilol'), 
('5678', 'Domilin   10 mg', '240-00538', 'Tablet', 'General Pharmaceuticals Ltd.', '2.01', '0.00', '10 mg', 'Domperidone'), 
('5679', 'Epiclon   .5 mg', '240-0112-046', 'Tablet', 'General Pharmaceuticals Ltd.', '4.01', '0.00', '.5 mg', 'Clonazepam'), 
('5680', 'Epiclon   2 mg', '240-0111-046', 'Tablet', 'General Pharmaceuticals Ltd.', '7.03', '0.00', '2 mg', 'Clonazepam'), 
('5681', 'Ermet   125 mcg', '240-01859', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '125 mcg', 'Methyl Ergometrine Maleate'), 
('5682', 'Extranil   5 mg', '240-0174-025', 'Tablet', 'General Pharmaceuticals Ltd.', '0.76', '0.00', '5 mg', 'Procyclidine Hydrochloride'), 
('5683', 'Geflox   500 mg', '240-0032-23', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('5684', 'Geflox   250 mg', '240-0025-23', 'Tablet', 'General Pharmaceuticals Ltd.', '8.52', '0.00', '250 mg', 'Ciprofloxacin'), 
('5685', 'Gepin0   150 mg', '240-00235', 'Tablet', 'General Pharmaceuticals Ltd.', '2.01', '0.00', '150 mg', 'Ranitidine'), 
('5686', 'Glustin   500 mg', '240-0114-64', 'Tablet', 'General Pharmaceuticals Ltd.', '3.52', '0.00', '500 mg', 'Glucosamine'), 
('5687', 'Hitagen   4 mg', '240-0010-21', 'Tablet', 'General Pharmaceuticals Ltd.', '0.30', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('5688', 'Hytis      25 mg', '240-0078-21', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Hydroxyzine Hydrochloride'), 
('5689', 'Infud   250 mg', '240-0102', 'Tablet', 'General Pharmaceuticals Ltd.', '50.00', '0.00', '250 mg', 'Terbinafine'), 
('5690', 'Genolev   250 mg', '240-0100-23', 'Tablet', 'General Pharmaceuticals Ltd.', '8.05', '0.00', '250 mg', 'Levofloxacin'), 
('5691', 'Genolev00   500 mg', '240-0101-23', 'Tablet', 'General Pharmaceuticals Ltd.', '15.11', '0.00', '500 mg', 'Levofloxacin'), 
('5692', 'Lipitin   10 mg', '240-0055-061', 'Tablet', 'General Pharmaceuticals Ltd.', '10.07', '0.00', '10 mg', 'Atorvastatin'), 
('5693', 'Lipitin      20 mg', '240-0056-061', 'Tablet', 'General Pharmaceuticals Ltd.', '18.12', '0.00', '20 mg', 'Atorvastatin'), 
('5694', 'Lorin   10 mg', '240-0050-21', 'Tablet', 'General Pharmaceuticals Ltd.', '3.02', '0.00', '10 mg', 'Loratadine'), 
('5695', 'Macrobid   500 mg', '240-0048-23', 'Tablet', 'General Pharmaceuticals Ltd.', '50.34', '0.00', '500 mg', 'Clarithromycin'), 
('5696', 'Mecobal   .5 mg', '240-0168-78', 'Tablet', 'General Pharmaceuticals Ltd.', '4.04', '0.00', '.5 mg', 'Mecobalamin'), 
('5697', 'Metrion00   400 mg', '240-0002-27', 'Tablet', 'General Pharmaceuticals Ltd.', '1.14', '0.00', '400 mg', 'Metronidazole'), 
('5698', 'Mitrazin   15 mg', '240-01264', 'Tablet', 'General Pharmaceuticals Ltd.', '8.05', '0.00', '15 mg', 'Mirtazapine'), 
('5699', 'Nicoral      5 mg', '240-0127', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Nicorandil'), 
('5700', 'Nicoral   10 mg', '240-0128', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Nicorandil'), 
('5701', 'Pantogen      20 mg', '240-0172-67', 'Tablet', 'General Pharmaceuticals Ltd.', '5.01', '0.00', '20 mg', 'Pantoprazole'), 
('5702', 'Pantogen0   40 mg', '240-0171-67', 'Tablet', 'General Pharmaceuticals Ltd.', '7.03', '0.00', '40 mg', 'Pantoprazole'), 
('5703', 'Pentabid      20 mg', '240-0059', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Isosorbide Mononitrate'), 
('5704', 'Perigen      5 mg', '240-0131-28', 'Tablet', 'General Pharmaceuticals Ltd.', '1.00', '0.00', '5 mg', 'Haloperidol'), 
('5705', 'Phylin0   100 mg', '240-01834', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Aminophylline'), 
('5706', 'Pivicil     200 mg', '240-0141-23', 'Tablet', 'General Pharmaceuticals Ltd.', '12.09', '0.00', '200 mg', 'Pivmecillinam'), 
('5707', 'Ramipro      5 mg', '240-0106-022', 'Tablet', 'General Pharmaceuticals Ltd.', '8.05', '0.00', '5 mg', 'Ramipril'), 
('5708', 'Ramipro.5   2.5 mg', '240-0109-022', 'Tablet', 'General Pharmaceuticals Ltd.', '5.04', '0.00', '2.5 mg', 'Ramipril'), 
('5709', 'Recol   10 mg', '240-0049-61', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Simvastatin'), 
('5710', 'Relafin   50 mg', '240-01664', 'Tablet', 'General Pharmaceuticals Ltd.', '15.11', '0.00', '50 mg', 'Fluvoxamine Maleate'), 
('5711', 'Releve   500 mg', '240-0176-64', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Naproxen'), 
('5712', 'Resopan   10 mg', '240-01841', 'Tablet', 'General Pharmaceuticals Ltd.', '3.43', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('5713', 'Riscord   4 mg', '240-0118-28', 'Tablet', 'General Pharmaceuticals Ltd.', '5.52', '0.00', '4 mg', 'Risperidone'), 
('5714', 'Riscord   2 mg', '240-0119-28', 'Tablet', 'General Pharmaceuticals Ltd.', '3.01', '0.00', '2 mg', 'Risperidone'), 
('5715', 'Salbut   4 mg', '240-01474', 'Tablet', 'General Pharmaceuticals Ltd.', '0.34', '0.00', '4 mg', 'Salbutamol'), 
('5716', 'Serelam   .25 mg', '240-01537', 'Tablet', 'General Pharmaceuticals Ltd.', '1.00', '0.00', '.25 mg', 'Alprazolam'), 
('5717', 'Serelam   .5 mg', '240-01547', 'Tablet', 'General Pharmaceuticals Ltd.', '2.01', '0.00', '.5 mg', 'Alprazolam'), 
('5718', 'Setra      25 mg', '240-01674', 'Tablet', 'General Pharmaceuticals Ltd.', '3.02', '0.00', '25 mg', 'Sertraline'), 
('5719', 'Setra0   100 mg', '240-00714', 'Tablet', 'General Pharmaceuticals Ltd.', '10.07', '0.00', '100 mg', 'Sertraline'), 
('5720', 'Setra     50 mg', '240-00704', 'Tablet', 'General Pharmaceuticals Ltd.', '6.04', '0.00', '50 mg', 'Sertraline'), 
('5721', 'Sugamet   850 mg', '240-0079', 'Tablet', 'General Pharmaceuticals Ltd.', '4.51', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('5722', 'Sumigran     50 mg', '240-01577', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Sumatriptan'), 
('5723', 'Tamoxen      20 mg', '240-0134', 'Tablet', 'General Pharmaceuticals Ltd.', '16.11', '0.00', '20 mg', 'Tamoxifen'), 
('5724', 'Tamoxen   10 mg', '240-0135', 'Tablet', 'General Pharmaceuticals Ltd.', '10.07', '0.00', '10 mg', 'Tamoxifen'), 
('5725', 'Tenapam   3 mg', '240-00977', 'Tablet', 'General Pharmaceuticals Ltd.', '5.01', '0.00', '3 mg', 'Bromazepam'), 
('5726', 'Tolcalm     50 mg', '240-0094-70', 'Tablet', 'General Pharmaceuticals Ltd.', '4.01', '0.00', '50 mg', 'Tolperisone Hydrochloride'), 
('5727', 'Tolorin   2 mg', '240-01829', 'Tablet', 'General Pharmaceuticals Ltd.', '3.02', '0.00', '2 mg', 'Tolterodine Tartrate'), 
('5728', 'ATP   500 mg', '240-0001-006', 'Tablet', 'General Pharmaceuticals Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('5729', 'Urolosin   400 mcg', '240-01819', 'Tablet', 'General Pharmaceuticals Ltd.', '10.07', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('5730', 'Venlax      75 mg', '240-01054', 'Tablet', 'General Pharmaceuticals Ltd.', '10.07', '0.00', '75 mg', 'Venlafaxine'), 
('5731', 'Venlax7.5   37.5 mg', '240-01254', 'Tablet', 'General Pharmaceuticals Ltd.', '5.54', '0.00', '37.5 mg', 'Venlafaxine'), 
('5732', 'Costin   625 mg', '240-0113-62', 'Tablet', 'General Pharmaceuticals Ltd.', '2.01', '0.00', '625 mg', 'Calcium Carbonate'), 
('5733', 'Candesa6   16 mg', '240-0175-22', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '16 mg', 'Candesartan Cilexetil'), 
('5734', 'Etocox   60 mg', '240-0206-64', 'Tablet', 'General Pharmaceuticals Ltd.', '7.05', '0.00', '60 mg', 'Etoricoxib'), 
('5735', 'Etocox   90 mg', '240-0207-64', 'Tablet', 'General Pharmaceuticals Ltd.', '12.09', '0.00', '90 mg', 'Etoricoxib'), 
('5736', 'Etocox20   120 mg', '240-0208-64', 'Tablet', 'General Pharmaceuticals Ltd.', '14.09', '0.00', '120 mg', 'Etoricoxib'), 
('5737', 'Aloten      20 mg', '240-0200-067', 'Tablet', 'General Pharmaceuticals Ltd.', '5.01', '0.00', '20 mg', 'Esomeprazole'), 
('5738', 'Alton0   40 mg', '240-0201-67', 'Tablet', 'General Pharmaceuticals Ltd.', '8.03', '0.00', '40 mg', 'Esomeprazole'), 
('5739', 'Relergy   5 mg', '240-0204-21', 'Tablet', 'General Pharmaceuticals Ltd.', '2.52', '0.00', '5 mg', 'Desloratadine'), 
('5740', 'Eromac   500 mg', '240-0198-23', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('5741', 'Eromac   250 mg', '240-0199-23', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Erythromycin'), 
('5742', 'Releve   250 mg', '240-0194-64', 'Tablet', 'General Pharmaceuticals Ltd.', '8.00', '0.00', '250 mg', 'Naproxen'), 
('5743', 'Methyphen      5 mg', '240-01934', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Methylphenidate Hydrochloride'), 
('5744', 'Methyphen   10 mg', '240-01924', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Methylphenidate Hydrochloride'), 
('5745', 'Geflox  XR   500 mg', '240-0245-23', 'Tablet', 'General Pharmaceuticals Ltd.', '14.09', '0.00', '500 mg', 'Ciprofloxacin'), 
('5746', 'Sedron5   35 mg', '240-0205-048', 'Tablet', 'General Pharmaceuticals Ltd.', '35.25', '0.00', '35 mg', 'Risedronate Sodium'), 
('5747', 'Ferosul     200 mg', '240-02715', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Ferrous Sulphate'), 
('5748', 'Genafen     200 mg', '240-0273-64', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Ibuprofen'), 
('5749', 'Carbapin     200 mg', '240-0275-046', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Carbamazepine'), 
('5750', 'Verapil   40 mg', '240-0274-22', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Verapamil Hydrochloride'), 
('5751', 'Citapram   10 mg', '240-01174', 'Tablet', 'General Pharmaceuticals Ltd.', '5.04', '0.00', '10 mg', 'Citalopram Hydrobromide'), 
('5752', 'Lopez      5 mg', '240-0086-28', 'Tablet', 'General Pharmaceuticals Ltd.', '2.52', '0.00', '5 mg', 'Olanzapine'), 
('5753', 'Lopez   10 mg', '240-0087-28', 'Tablet', 'General Pharmaceuticals Ltd.', '4.53', '0.00', '10 mg', 'Olanzapine'), 
('5754', 'Sugamet   500 mg', '240-0096', 'Tablet', 'General Pharmaceuticals Ltd.', '3.01', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('5755', 'Zafnil      20 mg', '240-00834', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Zafirlukast'), 
('5756', 'Ariprazole   10 mg', '240-0240-28', 'Tablet', 'General Pharmaceuticals Ltd.', '5.04', '0.00', '10 mg', 'Aripiprazole'), 
('5757', 'Ariprazole   15 mg', '240-0241-28', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Aripiprazole'), 
('5758', 'Ariprazole      5 mg', '240-0239-28', 'Tablet', 'General Pharmaceuticals Ltd.', '3.52', '0.00', '5 mg', 'Aripiprazole'), 
('5759', 'Betachek0   100 mg', '240-0212-22', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Atenolol'), 
('5760', 'Betachek     50 mg', '240-0213-22', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Atenolol'), 
('5761', 'Dorel      75 mg', '240-0228-26', 'Tablet', 'General Pharmaceuticals Ltd.', '10.07', '0.00', '75 mg', 'Clopidogrel'), 
('5762', 'D Pam      5 mg', '240-0218-057', 'Tablet', 'General Pharmaceuticals Ltd.', '0.68', '0.00', '5 mg', 'Diazepam'), 
('5763', 'Gored  MR   30 mg', '240-0210', 'Tablet', 'General Pharmaceuticals Ltd.', '8.86', '0.00', '30 mg', 'Gliclazide'), 
('5764', 'Inositin   500 mg', '240-0237', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Inositol'), 
('5765', 'Inositin      750 mg', '240-0238', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '750 mg', 'Inositol'), 
('5766', 'L - Carni   330 mg', '240-0231', 'Tablet', 'General Pharmaceuticals Ltd.', '5.04', '0.00', '330 mg', 'Levocarnitine'), 
('5767', 'Zico      20 mg', '240-0234-62', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Zinc'), 
('5768', 'Sugamet  SR0   500 mg', '240-0209', 'Tablet', 'General Pharmaceuticals Ltd.', '3.01', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('5769', 'Zolpid   10 mg', '240-02167', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Zolpidem Tartrate'), 
('5770', 'Zolpid      5 mg', '240-02177', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Zolpidem Tartrate'), 
('5771', 'Penigen   250 mg', '240-0152-23', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('5772', 'Pizograin.5   1.5 mg', '240-02147', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '1.5 mg', 'Pizotifen'), 
('5773', 'Salbut   2 mg', '240-00934', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Salbutamol'), 
('5774', 'Pizograin   500 mcg', '240-02157', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '500 mcg', 'Pizotifen'), 
('5775', 'Acefenac   100 mg', '240-0222-64', 'Tablet', 'General Pharmaceuticals Ltd.', '4.01', '0.00', '100 mg', 'Aceclofenac'), 
('5776', 'Reglin   .5 mg', '240-0223-015', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '.5 mg', 'Repaglinide'), 
('5777', 'Reglin   1 mg', '240-0224-015', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '1 mg', 'Repaglinide'), 
('5778', 'Reglin   2 mg', '240-0225-015', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Repaglinide'), 
('5779', 'Anginox   20 mg', '240-0230', 'Tablet', 'General Pharmaceuticals Ltd.', '3.01', '0.00', '20 mg', 'Trimetazidine Dihydrochloride'), 
('5780', 'Ursodil0   150 mg', '240-0232', 'Tablet', 'General Pharmaceuticals Ltd.', '15.00', '0.00', '150 mg', 'Ursodeoxycholic Acid'), 
('5781', 'Ursodil0   300 mg', '240-0233', 'Tablet', 'General Pharmaceuticals Ltd.', '20.13', '0.00', '300 mg', 'Ursodeoxycholic Acid'), 
('5782', 'Adpas   15 mg', '240-0082', 'Tablet', 'General Pharmaceuticals Ltd.', '8.05', '0.00', '15 mg', 'Pioglitazone'), 
('5783', 'Gored   80 mg', '240-0035', 'Tablet', 'General Pharmaceuticals Ltd.', '7.03', '0.00', '80 mg', 'Gliclazide'), 
('5784', 'Carmazol      20 mg', '240-0296-74', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Carbimazole'), 
('5785', 'Carmazol      5 mg', '240-0297-74', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Carbimazole'), 
('5786', 'Dulin      20 mg', '240-02614', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Duloxetine'), 
('5787', 'Dulin   30 mg', '240-02624', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '30 mg', 'Duloxetine'), 
('5788', 'Dulin   60 mg', '240-02634', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '60 mg', 'Duloxetine'), 
('5789', 'Dexibu     200 mg', '240-0287-64', 'Tablet', 'General Pharmaceuticals Ltd.', '3.02', '0.00', '200 mg', 'Dexibuprofen (S Ibuprofen)'), 
('5790', 'Dexibu0   300 mg', '240-0288-64', 'Tablet', 'General Pharmaceuticals Ltd.', '4.04', '0.00', '300 mg', 'Dexibuprofen (S Ibuprofen)'), 
('5791', 'Dexibu00   400 mg', '240-0289-64', 'Tablet', 'General Pharmaceuticals Ltd.', '5.04', '0.00', '400 mg', 'Dexibuprofen (S Ibuprofen)'), 
('5792', 'Lavair   1 mg', '240-02934', 'Tablet', 'General Pharmaceuticals Ltd.', '0.91', '0.00', '1 mg', 'Levosalbutamol'), 
('5793', 'Lavair   2 mg', '240-02944', 'Tablet', 'General Pharmaceuticals Ltd.', '1.71', '0.00', '2 mg', 'Levosalbutamol'), 
('5794', 'Mitrazin   30 mg', '240-02804', 'Tablet', 'General Pharmaceuticals Ltd.', '15.04', '0.00', '30 mg', 'Mirtazapine'), 
('5795', 'Previp   50 mg', '240-02661', 'Tablet', 'General Pharmaceuticals Ltd.', '4.04', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('5796', 'Proval     200 mg', '240-02766', 'Tablet', 'General Pharmaceuticals Ltd.', '2.52', '0.00', '200 mg', 'Sodium Valproate'), 
('5797', 'Pandolac  XR    600 mg', '240-0307-64', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '600 mg', 'Etodolac'), 
('5798', 'Resmus      5 mg', '240-0289-70', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Baclofen'), 
('5799', 'Sedron      5 mg', '240-0259-048', 'Tablet', 'General Pharmaceuticals Ltd.', '8.05', '0.00', '5 mg', 'Risedronate Sodium'), 
('5800', 'Spaverin   60 mg', '240-02851', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '60 mg', 'Alverine Citrate'), 
('5801', 'Tolcalm0   100 mg', '240-0286-70', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Tolperisone Hydrochloride'), 
('5802', 'Uro K    1080 mg', '240-0300-62', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '1080 mg', 'Potassium Citrate'), 
('5803', 'Urbifen   50 mg', '240-0312-64', 'Tablet', 'General Pharmaceuticals Ltd.', '3.50', '0.00', '50 mg', 'Flurbiprofen'), 
('5804', 'Vertizin   50 mg', '240-02998', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Meclizine Hydrochloride'), 
('5805', 'Salate   500 mg', '240-0317-64', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Salsalate'), 
('5806', 'Salate   750 mg', '240-0318-64', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '750 mg', 'Salsalate'), 
('5807', 'Dianide   500 mg', '240-0314-27', 'Tablet', 'General Pharmaceuticals Ltd.', '10.07', '0.00', '500 mg', 'Nitazoxanide'), 
('5808', 'S-Citapram   10 mg', '240-03164', 'Tablet', 'General Pharmaceuticals Ltd.', '10.07', '0.00', '10 mg', 'Escitalopram'), 
('5809', 'S-Citapram      5 mg', '240-03154', 'Tablet', 'General Pharmaceuticals Ltd.', '7.03', '0.00', '5 mg', 'Escitalopram'), 
('5810', 'Glirid   1 mg', '240-0321', 'Tablet', 'General Pharmaceuticals Ltd.', '3.02', '0.00', '1 mg', 'Glimepiride'), 
('5811', 'Glirid   2 mg', '240-0322', 'Tablet', 'General Pharmaceuticals Ltd.', '5.04', '0.00', '2 mg', 'Glimepiride'), 
('5812', 'Glirid   3 mg', '240-0323', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '3 mg', 'Glimepiride'), 
('5813', 'Glirid   4 mg', '240-0324', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Glimepiride'), 
('5814', 'Secomax   500 mg', '240-0329-23', 'Tablet', 'General Pharmaceuticals Ltd.', '45.31', '0.00', '500 mg', 'Cefuroxime'), 
('5815', 'Secomax   250 mg', '240-0330-23', 'Tablet', 'General Pharmaceuticals Ltd.', '25.16', '0.00', '250 mg', 'Cefuroxime'), 
('5816', 'Tiapine      25 mg', '240-0332-28', 'Tablet', 'General Pharmaceuticals Ltd.', '3.01', '0.00', '25 mg', 'Quetiapine'), 
('5817', 'Restobac   10 mg', '240-0343-70', 'Tablet', 'General Pharmaceuticals Ltd.', '8.05', '0.00', '10 mg', 'Baclofen'), 
('5818', 'Restobac   25 mg', '240-0344-70', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Baclofen'), 
('5819', 'Telukast   10 mg', '240-0348-044', 'Tablet', 'General Pharmaceuticals Ltd.', '10.03', '0.00', '10 mg', 'Montelukast'), 
('5820', 'Telukast   5 mg', '240-0347-044', 'Tablet', 'General Pharmaceuticals Ltd.', '7.56', '0.00', '5 mg', 'Montelukast'), 
('5821', 'Piratam0   800 mg', '240-0363', 'Tablet', 'General Pharmaceuticals Ltd.', '4.00', '0.00', '800 mg', 'Piracetam'), 
('5822', 'Telukast   4 mg', '240-0356-044', 'Tablet', 'General Pharmaceuticals Ltd.', '5.52', '0.00', '4 mg', 'Montelukast'), 
('5823', 'Celeste   20 mg', '240-0360-043', 'Tablet', 'General Pharmaceuticals Ltd.', '40.00', '0.00', '20 mg', 'Tadalafil'), 
('5824', 'Urostat   40 mg', '240-0365-76', 'Tablet', 'General Pharmaceuticals Ltd.', '12.04', '0.00', '40 mg', 'Febuxostat'), 
('5825', 'Urostat   80 mg', '240-0366-76', 'Tablet', 'General Pharmaceuticals Ltd.', '22.07', '0.00', '80 mg', 'Febuxostat'), 
('5826', 'Toroaid   10 mg', '240-0370-064', 'Tablet', 'General Pharmaceuticals Ltd.', '10.03', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('5827', 'Voricon0   50 mg', '240-0376', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Voriconazole'), 
('5828', 'Voricon0   200 mg', '240-0377', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Voriconazole'), 
('5829', 'Lipitin0   40 mg', '240-0379-061', 'Tablet', 'General Pharmaceuticals Ltd.', '24.07', '0.00', '40 mg', 'Atorvastatin'), 
('5830', 'Rosugen   5 mg', '240-0380-61', 'Tablet', 'General Pharmaceuticals Ltd.', '10.03', '0.00', '5 mg', 'Rosuvastatin'), 
('5831', 'Rosugen   10 mg', '240-0381-61', 'Tablet', 'General Pharmaceuticals Ltd.', '20.06', '0.00', '10 mg', 'Rosuvastatin'), 
('5832', 'Riscord   1 mg', '240-0383-28', 'Tablet', 'General Pharmaceuticals Ltd.', '2.00', '0.00', '1 mg', 'Risperidone'), 
('5833', 'Genacort   10 mg', '240-0391-72', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Hydrocortisone'), 
('5834', 'Betagen.5   500 mcg', '240-0390-72', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '500 mcg', 'Betamethasone'), 
('5835', 'Predflam   5 mg', '240-0387-72', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Prednisolone'), 
('5836', 'Predflam   10 mg', '240-0388-72', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Prednisolone'), 
('5837', 'Predflam   20 mg', '240-0289-72', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Prednisolone'), 
('5838', 'Viptin   50 mg', '240-0385', 'Tablet', 'General Pharmaceuticals Ltd.', '20.06', '0.00', '50 mg', 'Vildagliptin'), 
('5839', 'Peak   100 mg', '240-0369-043', 'Tablet', 'General Pharmaceuticals Ltd.', '50.15', '0.00', '100 mg', 'Sildenafil'), 
('5840', 'Spacef0   200 mg', '240-0392-23', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Cefditoren'), 
('5841', 'Spacef00   400 mg', '240-0393-23', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Cefditoren'), 
('5842', 'Dexagen.5   .5 mg', '240-0394-72', 'Tablet', 'General Pharmaceuticals Ltd.', '1.00', '0.00', '.5 mg', 'Dexamethasone'), 
('5843', 'Methipred   2 mg', '240-0396-72', 'Tablet', 'General Pharmaceuticals Ltd.', '3.01', '0.00', '2 mg', 'Methyl Prednisolone'), 
('5844', 'Genacort   20 mg', '240-0397-72', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Hydrocortisone'), 
('5845', 'Epiclon   1 mg', '240-04096', 'Tablet', 'General Pharmaceuticals Ltd.', '6.02', '0.00', '1 mg', 'Clonazepam'), 
('5846', 'Myocard   2.5 mg', '240-0406-22', 'Tablet', 'General Pharmaceuticals Ltd.', '6.02', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('5847', 'Myocard   5 mg', '240-0407-22', 'Tablet', 'General Pharmaceuticals Ltd.', '10.03', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('5848', 'Myocard   10 mg', '240-0408-22', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Bisoprolol Hemifumarate'), 
('5849', 'Celeste   5 mg', '240-0413-043', 'Tablet', 'General Pharmaceuticals Ltd.', '18.06', '0.00', '5 mg', 'Tadalafil'), 
('5850', 'Celeste   10 mg', '240-0414-043', 'Tablet', 'General Pharmaceuticals Ltd.', '35.11', '0.00', '10 mg', 'Tadalafil'), 
('5851', 'Peak   20 mg', '240-0410-043', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Sildenafil'), 
('5852', 'Peak   25 mg', '240-0411-043', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Sildenafil'), 
('5853', 'Peak0   50 mg', '240-0412-043', 'Tablet', 'General Pharmaceuticals Ltd.', '20.00', '0.00', '50 mg', 'Sildenafil'), 
('5854', 'Roxaban   10 mg', '240-04182', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Rivaroxaban'), 
('5855', 'Methipred   4 mg', '240-0417-72', 'Tablet', 'General Pharmaceuticals Ltd.', '5.01', '0.00', '4 mg', 'Methyl Prednisolone'), 
('5856', 'Ondagen 8   8 mg', '240-04198', 'Tablet', 'General Pharmaceuticals Ltd.', '7.00', '0.00', '8 mg', 'Ondansetron'), 
('5857', 'Orotifen   1 mg', '240-0420-21', 'Tablet', 'General Pharmaceuticals Ltd.', '1.51', '0.00', '1 mg', 'Ketotifen'), 
('5858', 'Genevir.5   .5 mg', '240-0424-32', 'Tablet', 'General Pharmaceuticals Ltd.', '48.14', '0.00', '.5 mg', 'Entecavir'), 
('5859', 'Genevir   1 mg', '240-0425-32', 'Tablet', 'General Pharmaceuticals Ltd.', '90.27', '0.00', '1 mg', 'Entecavir'), 
('5860', 'Methipred 8   8 mg', '240-0430-72', 'Tablet', 'General Pharmaceuticals Ltd.', '10.03', '0.00', '8 mg', 'Methyl Prednisolone'), 
('5861', 'Methipred6   16 mg', '240-0431-072', 'Tablet', 'General Pharmaceuticals Ltd.', '20.06', '0.00', '16 mg', 'Methyl Prednisolone'), 
('5862', 'Linaptin   5 mg', '240-0432-015', 'Tablet', 'General Pharmaceuticals Ltd.', '18.00', '0.00', '5 mg', 'Linagliptin'), 
('5863', 'Paincure0   50 mg', '240-0436-065', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Tapentadol'), 
('5864', 'Paincure   75 mg', '240-0437-065', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '75 mg', 'Tapentadol'), 
('5865', 'Olempres   20 mg', '240-0442-22', 'Tablet', 'General Pharmaceuticals Ltd.', '8.00', '0.00', '20 mg', 'Olmesartan Medoxomil'), 
('5866', 'Olmepres0   40 mg', '240-0443-22', 'Tablet', 'General Pharmaceuticals Ltd.', '15.00', '0.00', '40 mg', 'Olmesartan Medoxomil'), 
('5867', 'Rabemax   20 mg', '240-0446-67', 'Tablet', 'General Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('5868', 'Ticagen   90 mg', '240-0445-26', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '90 mg', 'Ticagrelor'), 
('5869', 'Placidin0   200 mg', '240-0451-28', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Quetiapine'), 
('5870', 'Moxigen00   400 mg', '240-0452-23', 'Tablet', 'General Pharmaceuticals Ltd.', '40.00', '0.00', '400 mg', 'Moxifloxacin'), 
('5871', 'Anginox MR   35 mg', '240-0460', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '35 mg', 'Trimetazidine Dihydrochloride'), 
('5872', 'Misopil   200 mcg', '240-04589', 'Tablet', 'General Pharmaceuticals Ltd.', '15.00', '0.00', '200 mcg', 'Misoprostol'), 
('5873', 'MTY   200 mg', '240-0459-049', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Mifepristone'), 
('5874', 'Rupoma   10 mg', '240-0465-21', 'Tablet', 'General Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Rupatadine'), 
('5875', 'Tiapine0   100 mg', '240-0325-028', 'Tablet', 'General Pharmaceuticals Ltd.', '10.07', '0.00', '100 mg', 'Quetiapine'), 
('5876', 'Bonheal   150 mg', '240-0469-048', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Ibandronic Acid'), 
('5877', 'Caltrate00   400 mg', '240-0467-062', 'Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Calcium Orotate'), 
('5878', 'Mitrazin   7.5 mg', '240-0470-014', 'Tablet', 'General Pharmaceuticals Ltd.', '6.50', '0.00', '7.5 mg', 'Mirtazapine'), 
('5879', 'Imacef  IM   1 gm', '240-0257-23', 'IM Injection', 'General Pharmaceuticals Ltd.', '161.08', '0.00', '1 gm', 'Ceftriaxone'), 
('5880', 'Imacef  IM  mg   250 mg', '240-0253-23', 'IM Injection', 'General Pharmaceuticals Ltd.', '90.61', '0.00', '250 mg', 'Ceftriaxone'), 
('5881', 'Imacef  IM0   500 mg', '240-0255-23', 'IM Injection', 'General Pharmaceuticals Ltd.', '120.00', '0.00', '500 mg', 'Ceftriaxone'), 
('5882', 'Imacef  IV   1 gm', '240-0256-23', 'IV Injection', 'General Pharmaceuticals Ltd.', '161.08', '0.00', '1 gm', 'Ceftriaxone'), 
('5883', 'Imacef  IV  mg   250 mg', '240-0252-23', 'IV Injection', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Ceftriaxone'), 
('5884', 'Imacef  IV0   500 mg', '240-0254-23', 'IV Injection', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ceftriaxone'), 
('5885', 'Imacefgm IV   2 gm', '240-0362-23', 'IV Injection', 'General Pharmaceuticals Ltd.', '302.04', '0.00', '2 gm', 'Ceftriaxone'), 
('5886', 'Alzed00   400 mg', '240-0423-008', 'Dispersible Tablet', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Albendazole'), 
('5887', 'Trumen  SR    100 mg', '240-0062-65', 'Sr Capsule', 'General Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Tramadol Hydrochloride'), 
('5888', 'Ranola ER   500 mg', '240-0367', 'Er Tablet', 'General Pharmaceuticals Ltd.', '16.05', '0.00', '500 mg', 'Ranolazine'), 
('5889', 'Tiapine0 XR   50 mg', '240-0456-28', 'Xr Tablet', 'General Pharmaceuticals Ltd.', '7.00', '0.00', '50 mg', 'Quetiapine'), 
('5890', 'Tiapine0 XR   200 mg', '240-0457-28', 'Xr Tablet', 'General Pharmaceuticals Ltd.', '20.00', '0.00', '200 mg', 'Quetiapine'), 
('5891', 'Mirabeg   25 mg', '240-0447-', 'Er Tablet', 'General Pharmaceuticals Ltd.', '30.00', '0.00', '25 mg', 'Mirabegron'), 
('5892', 'Mirabeg0 ER   50 mg', '240-0464-01', 'Er Tablet', 'General Pharmaceuticals Ltd.', '55.00', '0.00', '50 mg', 'Mirabegron'), 
('5893', 'Maxgard   45 %', '040-0056-077', 'Powder', 'Gentry Pharmaceuticals Ltd.', '225.67', '0.00', '45 %', 'Tiamulin Hydrogen Fumerate'), 
('5894', 'Colipol   50 Lac IU', '040-0049-', 'Powder', 'Gentry Pharmaceuticals Ltd.', '722.16', '0.00', '50 Lac IU', 'Colistin Sulphate'), 
('5895', 'Pyroba Vet   2 gm', '040-0039-077', 'Bolus', 'Gentry Pharmaceuticals Ltd.', '2.26', '0.00', '2 gm', 'Paracetamol'), 
('5896', 'Metoba Vet   2 gm', '040-0040-077', 'Bolus', 'Gentry Pharmaceuticals Ltd.', '4.46', '0.00', '2 gm', 'Metronidazole'), 
('5897', 'Oxyba Vet   500 mg', '040-0041-077', 'Bolus', 'Gentry Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Oxytetracycline'), 
('5898', 'Alrex Vet   600 mg', '040-0042-077', 'Bolus', 'Gentry Pharmaceuticals Ltd.', '7.57', '0.00', '600 mg', 'Albendazole'), 
('5899', 'Polflox Vet   750 mg', '040-0057-077', 'Bolus', 'Gentry Pharmaceuticals Ltd.', '15.05', '0.00', '750 mg', 'Ciprofloxacin'), 
('5900', 'Promigen Vet   150 mg', '040-0068-077', 'Bolus', 'Gentry Pharmaceuticals Ltd.', '3.30', '0.00', '150 mg', 'Promethazine Hydrochloride'), 
('5901', 'Gfen Vet   400 mg', '040-0069-077', 'Bolus', 'Gentry Pharmaceuticals Ltd.', '10.00', '0.00', '400 mg', 'Ketoprofen'), 
('5902', 'Doxler00   500 mg', '393-0004-023', 'Capsule', 'Genvio Pharma Ltd.', '0.00', '0.00', '500 mg', 'Hydroxyurea'), 
('5903', 'Tysinor0   150 mg', '393-0001', 'Tablet', 'Genvio Pharma Ltd.', '60.00', '0.00', '150 mg', 'Capecitabine'), 
('5904', 'Tysinor00   500 mg', '393-0002', 'Tablet', 'Genvio Pharma Ltd.', '120.00', '0.00', '500 mg', 'Capecitabine'), 
('5905', 'Intez   2.5 mg', '393-0003', 'Tablet', 'Genvio Pharma Ltd.', '40.00', '0.00', '2.5 mg', 'Letrozole'), 
('5906', 'Apnasin   1 mg', '393-0005-010', 'Tablet', 'Genvio Pharma Ltd.', '0.00', '0.00', '1 mg', 'Anastrozol'), 
('5907', 'Cefiget0   200 mg', '384-0010-23', 'Capsule', 'Get Well Limited', '34.00', '0.00', '200 mg', 'Cefixime'), 
('5908', 'Cefiget00   400 mg', '384-0011-23', 'Capsule', 'Get Well Limited', '49.00', '0.00', '400 mg', 'Cefixime'), 
('5909', 'Aziget00   500 mg', '384-0006-23', 'Tablet', 'Get Well Limited', '34.00', '0.00', '500 mg', 'Azithromycin'), 
('5910', 'Cipwell00   500 mg', '384-0008-23', 'Tablet', 'Get Well Limited', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('5911', 'Floxaget00   500 mg', '384-0014-23', 'Tablet', 'Get Well Limited', '0.00', '0.00', '500 mg', 'Levofloxacin'), 
('5912', 'Furoget   250 mg', '384-0015-23', 'Tablet', 'Get Well Limited', '24.00', '0.00', '250 mg', 'Cefuroxime'), 
('5913', 'Furoget00   500 mg', '384-0016-23', 'Tablet', 'Get Well Limited', '15.00', '0.00', '500 mg', 'Cefuroxime'), 
('5914', 'Getwell 3 ml Disposable Syring   3 ml', '384-00011', 'Syringe', 'Get Well Limited', '0.00', '0.00', '3 ml', 'Disposable Syringe'), 
('5915', 'Getwell ml Disposable Syring   5 ml', '384-00021', 'Syringe', 'Get Well Limited', '0.00', '0.00', '5 ml', 'Disposable Syringe'), 
('5916', 'Getwellml Disposible Syring   10 ml', '384-00031', 'Syringe', 'Get Well Limited', '0.00', '0.00', '10 ml', 'Disposable Syringe'), 
('5917', 'Getwell ml Disposable Syrin   20 ml', '384-00041', 'Syringe', 'Get Well Limited', '0.00', '0.00', '20 ml', 'Disposable Syringe'), 
('5918', 'Amoxil   250 mg', '001-0094-023', 'Capsule', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('5919', 'Amoxil   500 mg', '001-0149-23', 'Capsule', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('5920', 'Ceporex   250 mg', '001-0081-23', 'Capsule', 'GlaxoSmithKline Bangladesh Ltd.', '6.90', '0.00', '250 mg', 'Cephalexin'), 
('5921', 'Ceporex   500 mg', '001-0103-23', 'Capsule', 'GlaxoSmithKline Bangladesh Ltd.', '12.73', '0.00', '500 mg', 'Cephalexin'), 
('5922', 'Kefdrin   250 mg', '001-0132-023', 'Capsule', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '250 mg', 'Cephradine'), 
('5923', 'Kefdrin   500 mg', '001-0131-23', 'Capsule', 'GlaxoSmithKline Bangladesh Ltd.', '13.65', '0.00', '500 mg', 'Cephradine'), 
('5924', 'Pentacillin   250 mg', '001-0100-23', 'Capsule', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '250 mg', 'Ampicillin'), 
('5925', 'Lysiclox   500 mg', '001-0115-23', 'Capsule', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '500 mg', 'Cloxacillin'), 
('5926', 'Cexime   200 mg', '001-0166-23', 'Capsule', 'GlaxoSmithKline Bangladesh Ltd.', '35.11', '0.00', '200 mg', 'Cefixime'), 
('5927', 'Norain   20 mg', '001-0163-067', 'Capsule', 'GlaxoSmithKline Bangladesh Ltd.', '5.01', '0.00', '20 mg', 'Omeprazole'), 
('5928', 'Berin0   100 mg', '001-0129-78', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.74', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('5929', 'Betnelan   500 mcg', '001-0020-72', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.76', '0.00', '500 mcg', 'Betamethasone'), 
('5930', 'Celin   250 mg', '001-0121-78', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '250 mg', 'Vitamin C'), 
('5931', 'Crystapen V     250 mg', '001-0080-23', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('5932', 'Fluvin  OD    150 mg', '001-0145', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '20.13', '0.00', '150 mg', 'Fluconazole'), 
('5933', 'Fluvin  OD   50 mg', '001-0144', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '8.06', '0.00', '50 mg', 'Fluconazole'), 
('5934', 'Grisovin  FP   500 mg', '001-0090', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '5.60', '0.00', '500 mg', 'Griseofulvin'), 
('5935', 'Laxenna   95 mg', '001-0007-60', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '1.26', '0.00', '95 mg', 'Sennosides'), 
('5936', 'Lonac     50 mg', '001-0125-64', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('5937', 'Lorten     50 mg', '001-0111-22', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '50 mg', 'Atenolol'), 
('5938', 'Monoben00   400 mg', '001-0143-008', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '400 mg', 'Albendazole'), 
('5939', 'Noflam00   400 mg', '001-0118-64', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '400 mg', 'Ibuprofen'), 
('5940', 'Parapyrol   500 mg', '001-0091-006', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.72', '0.00', '500 mg', 'Paracetamol'), 
('5941', 'Peflon   400 mg', '001-0136-23', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '400 mg', 'Pefloxacin'), 
('5942', 'Piriton   4 mg', '001-0005-21', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.20', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('5943', 'Prednisolone      5 mg', '001-0138-72', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '1.71', '0.00', '5 mg', 'Prednisolone'), 
('5944', 'Ventolin   4 mg', '001-00884', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.46', '0.00', '4 mg', 'Salbutamol'), 
('5945', 'Ventolin   2 mg', '001-00094', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.26', '0.00', '2 mg', 'Salbutamol'), 
('5946', 'Ventolin  SR   8 mg', '001-01204', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.79', '0.00', '8 mg', 'Salbutamol'), 
('5947', 'Zantac0   150 mg', '001-01065', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '4.07', '0.00', '150 mg', 'Ranitidine'), 
('5948', 'Zinnat   500 mg', '001-0154-23', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '45.13', '0.00', '500 mg', 'Cefuroxime'), 
('5949', 'Kemadrin   5 mg', '001-0148-025', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '1.87', '0.00', '5 mg', 'Procyclidine Hydrochloride'), 
('5950', 'Antispam   10 mg', '001-01121', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('5951', 'Zinnat   125 mg', '001-0152-23', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '15.05', '0.00', '125 mg', 'Cefuroxime'), 
('5952', 'Zinnat   250 mg', '001-0150-23', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '25.08', '0.00', '250 mg', 'Cefuroxime'), 
('5953', 'Lorten0   100 mg', '001-0119-22', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '100 mg', 'Atenolol'), 
('5954', 'Dyapam      5 mg', '001-0096-057', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '5 mg', 'Diazepam'), 
('5955', 'Noflam     200 mg', '001-0039-64', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '200 mg', 'Ibuprofen'), 
('5956', 'Amitriptyline      25 mg', '001-00964', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.81', '0.00', '25 mg', 'Amitriptyline Hydrochloride'), 
('5957', 'Zeffix   100 mg', '001-0156-32', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '100 mg', 'Lamivudine'), 
('5958', 'Lanoxin   250 mcg', '001--35', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '250 mcg', 'Digoxin'), 
('5959', 'Amitriptyline   10 mg', '001-01604', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '10 mg', 'Amitriptyline Hydrochloride'), 
('5960', 'Glaxipro   500 mg', '001-0157-23', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '14.09', '0.00', '500 mg', 'Ciprofloxacin'), 
('5961', 'Prednelan      20 mg', '001-0158-72', 'Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '3.21', '0.00', '20 mg', 'Prednisolone'), 
('5962', 'Lonac  SR   100 mg', '001-0112-64', 'Sr Tablet', 'GlaxoSmithKline Bangladesh Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('5963', 'Empty Hard Gelatine Capsules Size #   0 Size', '228-0006-034', 'Raw Materials', 'Global Capsules Ltd.', '0.00', '0.00', '0 Size', 'Empty Hard Gelatin Capsule'), 
('5964', 'Empty Hard Gelatine Capsules Size #   1 Size', '228-0002-034', 'Raw Materials', 'Global Capsules Ltd.', '0.00', '0.00', '1 Size', 'Empty Hard Gelatin Capsule'), 
('5965', 'Empty Hard Gelatine Capsules Size #   2 Size', '228-0003-034', 'Raw Materials', 'Global Capsules Ltd.', '0.00', '0.00', '2 Size', 'Empty Hard Gelatin Capsule'), 
('5966', 'Empty Hard Gelatine Capsules Size # 3   3 Size', '228-0004-034', 'Raw Materials', 'Global Capsules Ltd.', '0.00', '0.00', '3 Size', 'Empty Hard Gelatin Capsule'), 
('5967', 'Empty Hard Gelatine Capsule Size #   4 Size', '228-0005-034', 'Raw Materials', 'Global Capsules Ltd.', '0.00', '0.00', '4 Size', 'Empty Hard Gelatin Capsule'), 
('5968', 'Empty Hard Gelatine Capsules, Size #   0 Size', '228-0001-034', 'Raw Materials', 'Global Capsules Ltd.', '0.00', '0.00', '0 Size', 'Empty Hard Gelatin Capsule'), 
('5969', 'Empty Hard Gelatin Cap. EL   140 mg', '228-0007-34', 'Raw Materials', 'Global Capsules Ltd.', '0.00', '0.00', '140 mg', 'Empty Hard Gelatin Capsule'), 
('5970', 'Gelatin BP (B Type)   100%', '305-0001-034', 'Raw Materials', 'Global Capsules Ltd., Gelatin Division', '0.00', '0.00', '100%', 'Gelatin'), 
('5971', 'Custic   100 %', '330-0001-034', 'Raw Materials', 'Global Heavy Chemicals Ltd.', '0.00', '0.00', '100 %', 'Sodium Hydroxide'), 
('5972', 'Ade Cap   300 mg', '083-0121', 'Capsule', 'Globe Pharmaceuticals Ltd.', '1.00', '0.00', '300 mg', 'Cod Liver Oil'), 
('5973', 'Cefix     200 mg', '083-0122-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '30.00', '0.00', '200 mg', 'Cefixime'), 
('5974', 'Cepa   500 mg', '083-0058-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('5975', 'Cepa   250 mg', '083-0081-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cephalexin'), 
('5976', 'Dirocap   2 mg', '083-00656', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Loperamide'), 
('5977', 'Eusef   500 mg', '083-0090-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '12.00', '0.00', '500 mg', 'Cephradine'), 
('5978', 'Genac  TR   100 mg', '083-0123-64', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('5979', 'Harmonix   150 mg', '083-0215-9', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Disopyramide'), 
('5980', 'Indocap   25 mg', '083-0066-64', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Indomethacin'), 
('5981', 'Isoclox   250 mg', '083-0091-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '5.50', '0.00', '250 mg', 'Flucloxacillin'), 
('5982', 'Isoclox   500 mg', '083-0134-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '10.00', '0.00', '500 mg', 'Flucloxacillin'), 
('5983', 'LP   30 mg', '083-0153-67', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '30 mg', 'Lansoprazole'), 
('5984', 'Nortip      25 mg', '083-01204', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Nortriptyline'), 
('5985', 'Op      20 mg', '083-0110-67', 'Capsule', 'Globe Pharmaceuticals Ltd.', '4.75', '0.00', '20 mg', 'Omeprazole'), 
('5986', 'Oxycap   250 mg', '083-0076-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Oxytetracycline'), 
('5987', 'Tetrafen   250 mg', '083-0068-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('5988', 'Ultracillin   250 mg', '083-0039-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Ampicillin'), 
('5989', 'Ultramox   500 mg', '083-0115-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '6.07', '0.00', '500 mg', 'Amoxicillin'), 
('5990', 'Ultramox   250 mg', '083-0038-023', 'Capsule', 'Globe Pharmaceuticals Ltd.', '3.50', '0.00', '250 mg', 'Amoxicillin'), 
('5991', 'Unidox0   100 mg', '083-0057-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '2.50', '0.00', '100 mg', 'Doxycycline'), 
('5992', 'Ultraclox   500 mg', '083-0158-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '5.25', '0.00', '500 mg', 'Cloxacillin'), 
('5993', 'Zycin   250 mg', '083-0220-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Azithromycin'), 
('5994', 'Encatrol   Soft Gelatine   .25 mcg', '083-0241-78', 'Capsule', 'Globe Pharmaceuticals Ltd.', '10.00', '0.00', '.25 mcg', 'Calcitriol'), 
('5995', 'Cefadrox   500 mg', '083-0224-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cefadroxil'), 
('5996', 'Epozil   500 mg', '083-0244-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cefprozil'), 
('5997', 'Ecovit S  Soft Gelatine0   200 mg', '083-0238-78', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Vitamin E'), 
('5998', 'Cefix00   400 mg', '083-0299-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '50.00', '0.00', '400 mg', 'Cefixime'), 
('5999', 'Op0   40 mg', '083-0302-67', 'Capsule', 'Globe Pharmaceuticals Ltd.', '8.00', '0.00', '40 mg', 'Omeprazole'), 
('6000', 'Reladol   50 mg', '083-0349-65', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('6001', 'Zedoxim0   200 mg', '083-0377-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '40.00', '0.00', '200 mg', 'Cefpodoxime'), 
('6002', 'Zedoxim0   100 mg', '083-0376-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '18.00', '0.00', '100 mg', 'Cefpodoxime'), 
('6003', 'Fibrostat   500 mg', '083-03749', 'Capsule', 'Globe Pharmaceuticals Ltd.', '15.00', '0.00', '500 mg', 'Tranexamic Acid'), 
('6004', 'Anobac   300 mg', '083-0409-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '15.00', '0.00', '300 mg', 'Clindamycin'), 
('6005', 'Anobac0   150 mg', '083-0435-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '8.00', '0.00', '150 mg', 'Clindamycin'), 
('6006', 'Ema   20 mg', '083-0460-067', 'Capsule', 'Globe Pharmaceuticals Ltd.', '7.00', '0.00', '20 mg', 'Esomeprazole'), 
('6007', 'Ema   40 mg', '083-0461-067', 'Capsule', 'Globe Pharmaceuticals Ltd.', '9.00', '0.00', '40 mg', 'Esomeprazole'), 
('6008', 'Neurica   75 mg', '083-0485-046', 'Capsule', 'Globe Pharmaceuticals Ltd.', '16.00', '0.00', '75 mg', 'Pregabalin'), 
('6009', 'Neurica0   150 mg', '083-0486-046', 'Capsule', 'Globe Pharmaceuticals Ltd.', '30.00', '0.00', '150 mg', 'Pregabalin'), 
('6010', 'Tibucef   400 mg', '083-0523-23', 'Capsule', 'Globe Pharmaceuticals Ltd.', '120.00', '0.00', '400 mg', 'Ceftibuten'), 
('6011', 'Neurica0   50 mg', '083-0546-046', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Pregabalin'), 
('6012', 'Tamurin   400 mcg', '083-0445-049', 'Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('6013', 'Burnrid   1 %', '083-0538-71', 'Cream', 'Globe Pharmaceuticals Ltd.', '40.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('6014', 'Water for Injection   5 ml', '083-0282-79', 'Injection', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '5 ml', 'Water For Injection'), 
('6015', 'Laxolac0   68 %', '083-0240-60', 'Oral Solution', 'Globe Pharmaceuticals Ltd.', '115.00', '0.00', '68 %', 'Lactulose'), 
('6016', 'Dextrose   100 %', '083-0036-79', 'Powder', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '100 %', 'Dextrose'), 
('6017', 'Oxyvet   25 %', '083-0062-077', 'Powder', 'Globe Pharmaceuticals Ltd.', '15.00', '0.00', '25 %', 'Oxytetracycline'), 
('6018', 'Ultramox VET   10 %', '083-0145-077', 'Powder', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '10 %', 'Amoxicillin'), 
('6019', 'Pc Vet   100 %', '083-0167-077', 'Powder', 'Globe Pharmaceuticals Ltd.', '100.00', '0.00', '100 %', 'Piperazine'), 
('6020', 'Levs   30 %', '083-0171-077', 'Powder', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '30 %', 'Levamisole'), 
('6021', 'Sulid   100 %', '083-0168-077', 'Powder', 'Globe Pharmaceuticals Ltd.', '9.50', '0.00', '100 %', 'Sulphanilamide'), 
('6022', 'Coxina   30 %', '083-0369-077', 'Powder', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '30 %', 'Sulfaclozine'), 
('6023', 'A FORTE0 IU   50000 IU', '083-0125-78', 'Soft Gelatin Capsule', 'Globe Pharmaceuticals Ltd.', '1.90', '0.00', '50000 IU', 'Vitamin A'), 
('6024', 'A Vit LAC   1 Lac IU', '083-0132-78', 'Soft Gelatin Capsule', 'Globe Pharmaceuticals Ltd.', '2.83', '0.00', '1 Lac IU', 'Vitamin A'), 
('6025', 'A Vit LAC   2 Lac IU', '083-0133-78', 'Soft Gelatin Capsule', 'Globe Pharmaceuticals Ltd.', '4.04', '0.00', '2 Lac IU', 'Vitamin A'), 
('6026', 'Ecovit S   200 mg', '083-0116-78', 'Soft Gelatin Capsule', 'Globe Pharmaceuticals Ltd.', '4.00', '0.00', '200 mg', 'Vitamin E'), 
('6027', 'Seas Plus   85 IU', '083-0471', 'Soft Gelatin Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '85 IU', 'Cod Liver Oil'), 
('6028', 'Glomeg   1 gm', '083-0470-61', 'Soft Gelatin Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '1 gm', 'Omega-3 Acid Ethyl Esters'), 
('6029', 'KayOn   1 mg', '083-0518-', 'Soft Gelatin Capsule', 'Globe Pharmaceuticals Ltd.', '15.00', '0.00', '1 mg', 'Phytomenadione'), 
('6030', 'Ecovit0   400 mg', '083-0238-078', 'Soft Gelatin Capsule', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Vitamin E'), 
('6031', 'Kaprovet   10 gm', '083-0172-077', 'Solution', 'Globe Pharmaceuticals Ltd.', '260.00', '0.00', '10 gm', 'Ciprofloxacin'), 
('6032', 'Aros   100 mg', '083-0201-64', 'Tablet', 'Globe Pharmaceuticals Ltd.', '3.00', '0.00', '100 mg', 'Aceclofenac'), 
('6033', 'Actolin   4 mg', '083-00714', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.40', '0.00', '4 mg', 'Salbutamol'), 
('6034', 'Al  DS   400 mg', '083-0078-008', 'Tablet', 'Globe Pharmaceuticals Ltd.', '5.00', '0.00', '400 mg', 'Albendazole'), 
('6035', 'Anlet      75 mg', '083-0200-26', 'Tablet', 'Globe Pharmaceuticals Ltd.', '10.00', '0.00', '75 mg', 'Clopidogrel'), 
('6036', 'Xiotic   .5 mg', '083-01817', 'Tablet', 'Globe Pharmaceuticals Ltd.', '2.00', '0.00', '.5 mg', 'Alprazolam'), 
('6037', 'Calpin      5 mg', '083-0146-022', 'Tablet', 'Globe Pharmaceuticals Ltd.', '4.25', '0.00', '5 mg', 'Amlodipine'), 
('6038', 'Calvit   300 mg', '083-0053-62', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.70', '0.00', '300 mg', 'Calcium Lactate'), 
('6039', 'Cis      20 mg', '083-01994', 'Tablet', 'Globe Pharmaceuticals Ltd.', '7.00', '0.00', '20 mg', 'Citalopram Hydrobromide'), 
('6040', 'Ecopril      5 mg', '083-0092-22', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Lisinopril'), 
('6041', 'Ecopril   10 mg', '083-0087-22', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Lisinopril'), 
('6042', 'Ecovit     200 mg', '083-0074-78', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Vitamin E'), 
('6043', 'Ema      20 mg', '083-0206-067', 'Tablet', 'Globe Pharmaceuticals Ltd.', '4.75', '0.00', '20 mg', 'Esomeprazole'), 
('6044', 'Flamic   250 mg', '083-0042-64', 'Tablet', 'Globe Pharmaceuticals Ltd.', '1.25', '0.00', '250 mg', 'Mefenamic Acid'), 
('6045', 'Fluzole0   150 mg', '083-0127', 'Tablet', 'Globe Pharmaceuticals Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('6046', 'Fluzole     50 mg', '083-0126', 'Tablet', 'Globe Pharmaceuticals Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('6047', 'Genac     50 mg', '083-0046-64', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.80', '0.00', '50 mg', 'Diclofenac Sodium'), 
('6048', 'Genarin   15 mg', '083-0054-21', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Cinnarizine'), 
('6049', 'Gevit   250 mg', '083-0031-78', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.81', '0.00', '250 mg', 'Vitamin C'), 
('6050', 'Kanaprim   15 mg', '083-0070-24', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.62', '0.00', '15 mg', 'Primaquine'), 
('6051', 'Kanaquine   300 mg', '083-0050-24', 'Tablet', 'Globe Pharmaceuticals Ltd.', '6.40', '0.00', '300 mg', 'Quinine Sulphate'), 
('6052', 'Kapron   250 mg', '083-0055-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '8.00', '0.00', '250 mg', 'Ciprofloxacin'), 
('6053', 'Kapron   500 mg', '083-0080-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '15.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('6054', 'Lera0   100 mg', '083-0178-64', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Leflunomide'), 
('6055', 'Lera      20 mg', '083-0177-64', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Leflunomide'), 
('6056', 'Levatrax   40 mg', '083-0072-8', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Levamisole'), 
('6057', 'Liz00   400 mg', '083-0192-023', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Linezolid'), 
('6058', 'Liz   600 mg', '083-0193-023', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '600 mg', 'Linezolid'), 
('6059', 'Locin   250 mg', '083-0156-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '11.00', '0.00', '250 mg', 'Levofloxacin'), 
('6060', 'Locin   500 mg', '083-0157-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '12.00', '0.00', '500 mg', 'Levofloxacin'), 
('6061', 'Micogyl00   400 mg', '083-0028-27', 'Tablet', 'Globe Pharmaceuticals Ltd.', '1.00', '0.00', '400 mg', 'Metronidazole'), 
('6062', 'Migrafen   500 mcg', '083-01307', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '500 mcg', 'Pizotifen'), 
('6063', 'Migrafen  TS   1.5 mg', '083-01807', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '1.5 mg', 'Pizotifen'), 
('6064', 'Nebium   10 mg', '083-00696', 'Tablet', 'Globe Pharmaceuticals Ltd.', '2.55', '0.00', '10 mg', 'Clobazam'), 
('6065', 'Neomide   500 mg', '083-0027-27', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Diloxanide Furoate'), 
('6066', 'Neorofen00   400 mg', '083-0056-64', 'Tablet', 'Globe Pharmaceuticals Ltd.', '1.42', '0.00', '400 mg', 'Ibuprofen'), 
('6067', 'Nortip   10 mg', '083-01194', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Nortriptyline'), 
('6068', 'Perion   10 mg', '083-01368', 'Tablet', 'Globe Pharmaceuticals Ltd.', '1.80', '0.00', '10 mg', 'Domperidone'), 
('6069', 'Piv     200 mg', '083-0210-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Pivmecillinam'), 
('6070', 'Pol   500 mg', '083-0022-006', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.80', '0.00', '500 mg', 'Paracetamol'), 
('6071', 'Polan   5 mg', '083-0209-21', 'Tablet', 'Globe Pharmaceuticals Ltd.', '3.00', '0.00', '5 mg', 'Levocetirizine Hydrochloride'), 
('6072', 'Proxen   250 mg', '083-009-64', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Naproxen'), 
('6073', 'Quinolex   250 mg', '083-0044-24', 'Tablet', 'Globe Pharmaceuticals Ltd.', '1.00', '0.00', '250 mg', 'Chloroquine Phosphate'), 
('6074', 'Rebolex   5 mg', '083-0052-79', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Riboflavin'), 
('6075', 'Lok     50 mg', '083-0176-022', 'Tablet', 'Globe Pharmaceuticals Ltd.', '8.00', '0.00', '50 mg', 'Losartan Potassium'), 
('6076', 'Spar     200 mg', '083-0150-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '15.00', '0.00', '200 mg', 'Sparfloxacin'), 
('6077', 'Sucomet   500 mg', '083-0185', 'Tablet', 'Globe Pharmaceuticals Ltd.', '3.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('6078', 'Sucomet   850 mg', '083-0184', 'Tablet', 'Globe Pharmaceuticals Ltd.', '4.50', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('6079', 'Sucotab   80 mg', '083-0129', 'Tablet', 'Globe Pharmaceuticals Ltd.', '7.00', '0.00', '80 mg', 'Gliclazide'), 
('6080', 'Thiolex0   100 mg', '083-0051-78', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('6081', 'Throcin   250 mg', '083-0097-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Erythromycin'), 
('6082', 'Throcin   500 mg', '083-0149-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '8.00', '0.00', '500 mg', 'Erythromycin'), 
('6083', 'Ultradin0   150 mg', '083-00345', 'Tablet', 'Globe Pharmaceuticals Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('6084', 'Ultradin0   300 mg', '083-00345', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Ranitidine'), 
('6085', 'Ultragram   500 mg', '083-0035-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Nalidixic Acid'), 
('6086', 'Vexam   250 mg', '083-0183-24', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Mefloquine'), 
('6087', 'Winkol   4 mg', '083-0029-21', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.18', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('6088', 'Panto0   40 mg', '083-0162-67', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Pantoprazole'), 
('6089', 'Trin   10 mg', '083-0109-21', 'Tablet', 'Globe Pharmaceuticals Ltd.', '2.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('6090', 'Carbocal   1250 mg', '083-0105-62', 'Tablet', 'Globe Pharmaceuticals Ltd.', '2.20', '0.00', '1250 mg', 'Calcium Carbonate'), 
('6091', 'Caplin   10 mg', '083-0163-022', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Amlodipine'), 
('6092', 'D Cort   .5 mg', '083-0229-72', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.75', '0.00', '.5 mg', 'Dexamethasone'), 
('6093', 'Liplo   10 mg', '083-0174-061', 'Tablet', 'Globe Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Atorvastatin'), 
('6094', 'Pedial   .5 mg', '083-0228-78', 'Tablet', 'Globe Pharmaceuticals Ltd.', '4.00', '0.00', '.5 mg', 'Mecobalamin'), 
('6095', 'Kapron      750 mg', '083-0173-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '18.00', '0.00', '750 mg', 'Ciprofloxacin'), 
('6096', 'Rolid0   150 mg', '083-0164-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '7.00', '0.00', '150 mg', 'Roxithromycin'), 
('6097', 'Zycin   500 mg', '083-0221-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('6098', 'Epozil   500 mg', '083-0243-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cefprozil'), 
('6099', 'Ximetil   125 mg', '083-0232-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '125 mg', 'Cefuroxime'), 
('6100', 'Ximetil   250 mg', '083-0233-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('6101', 'Clon   .5 mg', '083-0251-046', 'Tablet', 'Globe Pharmaceuticals Ltd.', '3.50', '0.00', '.5 mg', 'Clonazepam'), 
('6102', 'Hylon .1   100 mcg', '083-0235-22', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '100 mcg', 'Clonidine Hydrochloride'), 
('6103', 'Hylon .3   300 mcg', '083-0236-22', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '300 mcg', 'Clonidine Hydrochloride'), 
('6104', 'Pure   15 mg', '083-0254', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Halazone'), 
('6105', 'Anvir   150 mg', '083-0160-32', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Lamivudine'), 
('6106', 'Zikid      20 mg', '083-0249-62', 'Tablet', 'Globe Pharmaceuticals Ltd.', '2.00', '0.00', '20 mg', 'Zinc'), 
('6107', 'Flamic   500 mg', '083-0250-64', 'Tablet', 'Globe Pharmaceuticals Ltd.', '2.50', '0.00', '500 mg', 'Mefenamic Acid'), 
('6108', 'Rolid0   300 mg', '083-0165-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '14.00', '0.00', '300 mg', 'Roxithromycin'), 
('6109', 'P-Gut   20 mg', '083-0161-67', 'Tablet', 'Globe Pharmaceuticals Ltd.', '4.00', '0.00', '20 mg', 'Pantoprazole'), 
('6110', 'P-Gut0   40 mg', '083-0162-67', 'Tablet', 'Globe Pharmaceuticals Ltd.', '6.00', '0.00', '40 mg', 'Pantoprazole'), 
('6111', 'Gat   500 mg', '083-0179-27', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ornidazole'), 
('6112', 'RP   20 mg', '083-0194-67', 'Tablet', 'Globe Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Rabeprazole Sodium'), 
('6113', 'Temazin   10 mg', '083-02347', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Temazepam'), 
('6114', 'Vispazin   50 mg', '083-02731', 'Tablet', 'Globe Pharmaceuticals Ltd.', '5.00', '0.00', '50 mg', 'Tiemonium Methylsulphate'), 
('6115', 'Xanide   500 mg', '083-0296-27', 'Tablet', 'Globe Pharmaceuticals Ltd.', '10.00', '0.00', '500 mg', 'Nitazoxanide'), 
('6116', 'Roket   10 mg', '083-0294-064', 'Tablet', 'Globe Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('6117', 'Lipol   20 mg', '083-0312-061', 'Tablet', 'Globe Pharmaceuticals Ltd.', '15.00', '0.00', '20 mg', 'Atorvastatin'), 
('6118', 'Tizanac   2 mg', '083-0325-70', 'Tablet', 'Globe Pharmaceuticals Ltd.', '5.00', '0.00', '2 mg', 'Tizanidine'), 
('6119', 'Kpine   200 mg', '083-0324-046', 'Tablet', 'Globe Pharmaceuticals Ltd.', '3.50', '0.00', '200 mg', 'Carbamazepine'), 
('6120', 'Asmafen   1 mg', '083-0321-21', 'Tablet', 'Globe Pharmaceuticals Ltd.', '1.50', '0.00', '1 mg', 'Ketotifen'), 
('6121', 'Spinafen   10 mg', '083-0326-70', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Baclofen'), 
('6122', 'Spinafen   25 mg', '083-0327-70', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Baclofen'), 
('6123', 'Betamic   2.5 mg', '083-03304', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '2.5 mg', 'Terbutaline Sulphate'), 
('6124', 'Fexona   60 mg', '083-0333-21', 'Tablet', 'Globe Pharmaceuticals Ltd.', '3.50', '0.00', '60 mg', 'Fexofenadine Hydrochloride'), 
('6125', 'Fexona   120 mg', '083-0334-21', 'Tablet', 'Globe Pharmaceuticals Ltd.', '6.50', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('6126', 'Fexona80   180 mg', '083-0335-21', 'Tablet', 'Globe Pharmaceuticals Ltd.', '8.00', '0.00', '180 mg', 'Fexofenadine Hydrochloride'), 
('6127', 'Montifast   10 mg', '083-0337-044', 'Tablet', 'Globe Pharmaceuticals Ltd.', '15.00', '0.00', '10 mg', 'Montelukast'), 
('6128', 'Montifast   4 mg', '083-0338-044', 'Tablet', 'Globe Pharmaceuticals Ltd.', '7.00', '0.00', '4 mg', 'Montelukast'), 
('6129', 'Hypnoquick   15 mg', '083-0329-057', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '15 mg', 'Midazolam'), 
('6130', 'Letol   2 mg', '083-03504', 'Tablet', 'Globe Pharmaceuticals Ltd.', '1.70', '0.00', '2 mg', 'Levosalbutamol'), 
('6131', 'Flubifen   50 mg', '083-0342-64', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Flurbiprofen'), 
('6132', 'Oxana   600 mg', '083-0348-64', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '600 mg', 'Oxaprozin'), 
('6133', 'Duxtin   20 mg', '083-03414', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Duloxetine'), 
('6134', 'Duxtin   30 mg', '083-03404', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '30 mg', 'Duloxetine'), 
('6135', 'Tensfree   3 mg', '083-03567', 'Tablet', 'Globe Pharmaceuticals Ltd.', '4.50', '0.00', '3 mg', 'Bromazepam'), 
('6136', 'Gloxen00   500 mg', '083-0366-64', 'Tablet', 'Globe Pharmaceuticals Ltd.', '7.00', '0.00', '500 mg', 'Naproxen'), 
('6137', 'Gepril   5 mg', '083-0378-022', 'Tablet', 'Globe Pharmaceuticals Ltd.', '8.00', '0.00', '5 mg', 'Ramipril'), 
('6138', 'Myoxan0   100 mg', '083-0373-70', 'Tablet', 'Globe Pharmaceuticals Ltd.', '7.00', '0.00', '100 mg', 'Tolperisone Hydrochloride'), 
('6139', 'Myoxan0   50 mg', '083-0372-70', 'Tablet', 'Globe Pharmaceuticals Ltd.', '3.00', '0.00', '50 mg', 'Tolperisone Hydrochloride'), 
('6140', 'Deslona   5 mg', '083-0370-21', 'Tablet', 'Globe Pharmaceuticals Ltd.', '2.25', '0.00', '5 mg', 'Desloratadine'), 
('6141', 'Montifast   5 mg', '083-0379-044', 'Tablet', 'Globe Pharmaceuticals Ltd.', '7.50', '0.00', '5 mg', 'Montelukast'), 
('6142', 'Clon   2 mg', '083-0382-046', 'Tablet', 'Globe Pharmaceuticals Ltd.', '6.00', '0.00', '2 mg', 'Clonazepam'), 
('6143', 'Premesis   4 mg', '083-03838', 'Tablet', 'Globe Pharmaceuticals Ltd.', '4.50', '0.00', '4 mg', 'Ondansetron'), 
('6144', 'Premesis 8   8 mg', '083-03848', 'Tablet', 'Globe Pharmaceuticals Ltd.', '8.00', '0.00', '8 mg', 'Ondansetron'), 
('6145', 'Stallion   10 mg', '083-0388-043', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Tadalafil'), 
('6146', 'Stallion DS   20 mg', '083-0389-043', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Tadalafil'), 
('6147', 'Trigger   50 mg', '083-0390-043', 'Tablet', 'Globe Pharmaceuticals Ltd.', '25.00', '0.00', '50 mg', 'Sildenafil'), 
('6148', 'Trigger DS   100 mg', '083-0391-043', 'Tablet', 'Globe Pharmaceuticals Ltd.', '50.00', '0.00', '100 mg', 'Sildenafil'), 
('6149', 'Proticid   500 mg', '083-0403-27', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Tinidazole'), 
('6150', 'Maxbac   250 mg', '083-0399-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Clarithromycin'), 
('6151', 'Rofagyl0   200 mg', '083-0405-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '20.00', '0.00', '200 mg', 'Rifaximin'), 
('6152', 'Rofagyl50   550 mg', '083-0406-23', 'Tablet', 'Globe Pharmaceuticals Ltd.', '45.00', '0.00', '550 mg', 'Rifaximin'), 
('6153', 'Ema0   40 mg', '083-0407-67', 'Tablet', 'Globe Pharmaceuticals Ltd.', '8.00', '0.00', '40 mg', 'Esomeprazole'), 
('6154', 'Sucorid   2 mg', '083-0410', 'Tablet', 'Globe Pharmaceuticals Ltd.', '5.00', '0.00', '2 mg', 'Glimepiride'), 
('6155', 'Sucorid   4 mg', '083-0411', 'Tablet', 'Globe Pharmaceuticals Ltd.', '8.00', '0.00', '4 mg', 'Glimepiride'), 
('6156', 'Misocon   200 mcg', '083-04669', 'Tablet', 'Globe Pharmaceuticals Ltd.', '15.00', '0.00', '200 mcg', 'Misoprostol'), 
('6157', 'Mifecon   200 mg', '083-0467-049', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Mifepristone'), 
('6158', 'P-Cort   5 mg', '083-0468-72', 'Tablet', 'Globe Pharmaceuticals Ltd.', '1.70', '0.00', '5 mg', 'Prednisolone'), 
('6159', 'Virunil0   200 mg', '083-0477-32', 'Tablet', 'Globe Pharmaceuticals Ltd.', '14.00', '0.00', '200 mg', 'Acyclovir'), 
('6160', 'Virunil0   400 mg', '083-0478-32', 'Tablet', 'Globe Pharmaceuticals Ltd.', '22.00', '0.00', '400 mg', 'Acyclovir'), 
('6161', 'Ebahist   10 mg', '083-0480-21', 'Tablet', 'Globe Pharmaceuticals Ltd.', '6.00', '0.00', '10 mg', 'Ebastine'), 
('6162', 'Effical   400 mg', '083-0484-62', 'Tablet', 'Globe Pharmaceuticals Ltd.', '8.00', '0.00', '400 mg', 'Calcium Orotate'), 
('6163', 'Tapexia   75 mg', '083-0487-065', 'Tablet', 'Globe Pharmaceuticals Ltd.', '17.00', '0.00', '75 mg', 'Tapentadol'), 
('6164', 'Tapexia0   50 mg', '083-0488-065', 'Tablet', 'Globe Pharmaceuticals Ltd.', '12.00', '0.00', '50 mg', 'Tapentadol'), 
('6165', 'Dejac   30 mg', '083-0489-014', 'Tablet', 'Globe Pharmaceuticals Ltd.', '30.00', '0.00', '30 mg', 'Dapoxetine'), 
('6166', 'Dejac   60 mg', '083-0490-014', 'Tablet', 'Globe Pharmaceuticals Ltd.', '50.00', '0.00', '60 mg', 'Dapoxetine'), 
('6167', 'Myobis   2.5 mg', '083-0501-22', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '2.5 mg', 'Bisoprolol Hemifumarate'), 
('6168', 'Myobis   5 mg', '083-0502-22', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Bisoprolol Hemifumarate'), 
('6169', 'Theofast0 CR   200 mg', '083-05034', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Theophylline'), 
('6170', 'Theofast CR   300 mg', '083-05044', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Theophylline'), 
('6171', 'Theofast00 CR   400 mg', '083-05054', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Theophylline'), 
('6172', 'Sucovil   50 mg', '083-0519', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Vildagliptin'), 
('6173', 'Sucosit0   50 mg', '083-0521', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Sitagliptin'), 
('6174', 'Sucosit0   100 mg', '083-0522', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Sitagliptin'), 
('6175', 'Angitrim   20 mg', '083-0513', 'Tablet', 'Globe Pharmaceuticals Ltd.', '3.00', '0.00', '20 mg', 'Trimetazidine Dihydrochloride'), 
('6176', 'Miganil   5 mg', '083-05157', 'Tablet', 'Globe Pharmaceuticals Ltd.', '3.00', '0.00', '5 mg', 'Flunarizine'), 
('6177', 'Miganil   10 mg', '083-05167', 'Tablet', 'Globe Pharmaceuticals Ltd.', '5.00', '0.00', '10 mg', 'Flunarizine'), 
('6178', 'Angitrim MR   35 mg', '083-0539', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '35 mg', 'Trimetazidine Dihydrochloride'), 
('6179', 'Mepcort   2 mg', '083-0525-72', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Methyl Prednisolone'), 
('6180', 'Mepcort   4 mg', '083-0526-72', 'Tablet', 'Globe Pharmaceuticals Ltd.', '5.00', '0.00', '4 mg', 'Methyl Prednisolone'), 
('6181', 'Mepcort 8   8 mg', '083-0527-72', 'Tablet', 'Globe Pharmaceuticals Ltd.', '10.00', '0.00', '8 mg', 'Methyl Prednisolone'), 
('6182', 'Mepcort6   16 mg', '083-0528-072', 'Tablet', 'Globe Pharmaceuticals Ltd.', '18.00', '0.00', '16 mg', 'Methyl Prednisolone'), 
('6183', 'Decolic   10 mg', '083-05291', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Dicycloverine Hydrochloride'), 
('6184', 'NG Care.6 SR   2.6 mg', '083-0540', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '2.6 mg', 'Glyceryl Trinitrate'), 
('6185', 'Tofanib   5 mg', '083-05418', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Tofacitinib'), 
('6186', 'Rosulip   10 mg', '083-0543-61', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Rosuvastatin'), 
('6187', 'Rosulip   20 mg', '083-0544-61', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Rosuvastatin'), 
('6188', 'Bredox0   200 mg', '083-05514', 'Tablet', 'Globe Pharmaceuticals Ltd.', '5.00', '0.00', '200 mg', 'Doxophylline'), 
('6189', 'Bredox00   400 mg', '083-05524', 'Tablet', 'Globe Pharmaceuticals Ltd.', '8.00', '0.00', '400 mg', 'Doxophylline'), 
('6190', 'Narco   5 mg', '083-0553-65', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Oxymorphone Hydrochloride'), 
('6191', 'Narco   10 mg', '083-0554-65', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Oxymorphone Hydrochloride'), 
('6192', 'Bonmax   150 mg', '083-0560-048', 'Tablet', 'Globe Pharmaceuticals Ltd.', '510.00', '0.00', '150 mg', 'Ibandronic Acid'), 
('6193', 'Serotal   5 mg', '083-05574', 'Tablet', 'Globe Pharmaceuticals Ltd.', '5.50', '0.00', '5 mg', 'Escitalopram'), 
('6194', 'Vardena   20 mg', '083-05693', 'Tablet', 'Globe Pharmaceuticals Ltd.', '58.00', '0.00', '20 mg', 'Vardenafil Hydrochloride'), 
('6195', 'Serotal   10 mg', '083-05584', 'Tablet', 'Globe Pharmaceuticals Ltd.', '10.00', '0.00', '10 mg', 'Escitalopram'), 
('6196', 'Insoma   10 mg', '083-05647', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Suvorexant'), 
('6197', 'Vardena   10 mg', '083-05683', 'Tablet', 'Globe Pharmaceuticals Ltd.', '32.00', '0.00', '10 mg', 'Vardenafil Hydrochloride'), 
('6198', 'Rupana   10 mg', '083-0570-21', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Rupatadine'), 
('6199', 'Exypar   2 mg', '083-0572', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Trihexyphenidyl Hydrochloride'), 
('6200', 'Dezert   6 mg', '083-0577-72', 'Tablet', 'Globe Pharmaceuticals Ltd.', '8.00', '0.00', '6 mg', 'Deflazacort'), 
('6201', 'Etoxib-60   60 mg', '083-0292-064', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '60 mg', 'Etoricoxib'), 
('6202', 'Etoxib   90 mg', '083-0293-064', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '90 mg', 'Etoricoxib'), 
('6203', 'Gloxen   250 mg', '083-0365-064', 'Tablet', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Naproxen'), 
('6204', 'Almavet   600 mg', '083-0141-077', 'Bolus', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '600 mg', 'Albendazole'), 
('6205', 'Claben   900 mg', '083-0100-077', 'Bolus', 'Globe Pharmaceuticals Ltd.', '14.25', '0.00', '900 mg', 'Triclabendazole'), 
('6206', 'Fenvet   250 mg', '083-0073-077', 'Bolus', 'Globe Pharmaceuticals Ltd.', '4.00', '0.00', '250 mg', 'Fenbendazole'), 
('6207', 'Helmavet   750 mg', '083-0059-077', 'Bolus', 'Globe Pharmaceuticals Ltd.', '4.60', '0.00', '750 mg', 'Mebendazole'), 
('6208', 'Micovet g   2 gm', '083-0099-077', 'Bolus', 'Globe Pharmaceuticals Ltd.', '4.13', '0.00', '2 gm', 'Metronidazole'), 
('6209', 'Oxyvet   500 mg', '083-0061-077', 'Bolus', 'Globe Pharmaceuticals Ltd.', '2.75', '0.00', '500 mg', 'Oxytetracycline'), 
('6210', 'Ultramox   500 mg', '083-0084-077', 'Bolus', 'Globe Pharmaceuticals Ltd.', '6.00', '0.00', '500 mg', 'Amoxicillin'), 
('6211', 'Chemodine (Vet)   5 gm', '083-0425-077', 'Bolus', 'Globe Pharmaceuticals Ltd.', '10.00', '0.00', '5 gm', 'Sulphadimidine'), 
('6212', 'Promin Bolus Vet   150 mg', '083-0450-077', 'Bolus', 'Globe Pharmaceuticals Ltd.', '3.30', '0.00', '150 mg', 'Promethazine Hydrochloride'), 
('6213', 'Gloket Bolus Vet   400 mg', '083-0449-077', 'Bolus', 'Globe Pharmaceuticals Ltd.', '10.00', '0.00', '400 mg', 'Ketoprofen'), 
('6214', 'Kaprovet Bolus   1 gm', '083-0580-077', 'Bolus', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '1 gm', 'Ciprofloxacin'), 
('6215', 'Pol Vet Bolus   2 gm', '083-0260-077', 'Bolus', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '2 gm', 'Paracetamol'), 
('6216', 'Tribac  IM0   500 mg', '083-0275-23', 'IM Injection', 'Globe Pharmaceuticals Ltd.', '120.00', '0.00', '500 mg', 'Ceftriaxone'), 
('6217', 'Tribac  IM  mg   250 mg', '083-0274-23', 'IM Injection', 'Globe Pharmaceuticals Ltd.', '90.00', '0.00', '250 mg', 'Ceftriaxone'), 
('6218', 'Tribac  IM   1 gm', '083-0276-23', 'IM Injection', 'Globe Pharmaceuticals Ltd.', '180.00', '0.00', '1 gm', 'Ceftriaxone'), 
('6219', 'Tribac  IV0   500 mg', '083-0278-23', 'IV Injection', 'Globe Pharmaceuticals Ltd.', '120.00', '0.00', '500 mg', 'Ceftriaxone'), 
('6220', 'Tribac  IV  mg   250 mg', '083-0277-23', 'IV Injection', 'Globe Pharmaceuticals Ltd.', '90.00', '0.00', '250 mg', 'Ceftriaxone'), 
('6221', 'Tribac  IV   1 gm', '083-0279-23', 'IV Injection', 'Globe Pharmaceuticals Ltd.', '180.00', '0.00', '1 gm', 'Ceftriaxone'), 
('6222', 'Tribac  IV  gm   2 gm', '083-0280-23', 'IV Injection', 'Globe Pharmaceuticals Ltd.', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('6223', 'Aminomax Gold   5 %', '083-0380-3', 'IV Infusion', 'Globe Pharmaceuticals Ltd.', '400.00', '0.00', '5 %', 'Amino Acids (Essential)'), 
('6224', 'Oxrin.05%   .05 %', '083-05752', 'Nasal Drops', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '.05 %', 'Oxymetazoline Hydrochloride'), 
('6225', 'Oxrin   .025 %', '083-05762', 'Nasal Drops', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '.025 %', 'Oxymetazoline Hydrochloride'), 
('6226', 'OP   20 mg', '083-0402-67', 'Sached Powder', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '20 mg', 'Omeprazole'), 
('6227', 'OP   40 mg', '083-0401-67', 'Sached Powder', 'Globe Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Omeprazole'), 
('6228', 'Glumol   .25 %', '083-04212', 'Eye Drops', 'Globe Pharmaceuticals Ltd.', '70.00', '0.00', '.25 %', 'Timolol Maleate'), 
('6229', 'F-Cort   .1 %', '083-04422', 'Eye Drops', 'Globe Pharmaceuticals Ltd.', '90.00', '0.00', '.1 %', 'Fluorometholone'), 
('6230', 'Cleareye   .3 %', '083-04522', 'Eye Drops', 'Globe Pharmaceuticals Ltd.', '70.00', '0.00', '.3 %', 'Hypromellose'), 
('6231', 'Asmafen   .025 %', '083-04572', 'Eye Drops', 'Globe Pharmaceuticals Ltd.', '95.00', '0.00', '.025 %', 'Ketotifen'), 
('6232', 'Tofanib XR   11 mg', '083-05798', 'Xr Tablet', 'Globe Pharmaceuticals Ltd.', '80.00', '0.00', '11 mg', 'Tofacitinib'), 
('6233', 'Ponoxyl   250 mg', '180-0029-023', 'Capsule', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Amoxicillin'), 
('6234', 'Piazol      20 mg', '180-0042-67', 'Capsule', 'Globex Pharmaceuticals Ltd.', '5.00', '0.00', '20 mg', 'Omeprazole'), 
('6235', 'Piazol0   40 mg', '180-0043-67', 'Capsule', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '40 mg', 'Omeprazole'), 
('6236', 'Panoxyl   500 mg', '180-0037-23', 'Capsule', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Amoxicillin'), 
('6237', 'Tolfenac  SR   100 mg', '180-0036-64', 'Capsule', 'Globex Pharmaceuticals Ltd.', '3.00', '0.00', '100 mg', 'Diclofenac Sodium'), 
('6238', 'Candiflu0   50 mg', '180-0060', 'Capsule', 'Globex Pharmaceuticals Ltd.', '8.00', '0.00', '50 mg', 'Fluconazole'), 
('6239', 'Esoking0   20 mg', '180-0059-067', 'Capsule', 'Globex Pharmaceuticals Ltd.', '6.00', '0.00', '20 mg', 'Esomeprazole'), 
('6240', 'Esoking   40 mg', '180-0058-067', 'Capsule', 'Globex Pharmaceuticals Ltd.', '9.00', '0.00', '40 mg', 'Esomeprazole'), 
('6241', 'Globexim   200 mg', '180-0081-23', 'Capsule', 'Globex Pharmaceuticals Ltd.', '30.00', '0.00', '200 mg', 'Cefixime'), 
('6242', 'Glovocef00   500 mg', '180-0084-23', 'Capsule', 'Globex Pharmaceuticals Ltd.', '12.50', '0.00', '500 mg', 'Cephradine'), 
('6243', 'Tridol0   50 mg', '180-0075-65', 'Capsule', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('6244', 'Water for Injection   1 ml', '180-0098-79', 'Injection', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '1 ml', 'Water For Injection'), 
('6245', 'Glovolac   68 %', '180-0038-60', 'Oral Solution', 'Globex Pharmaceuticals Ltd.', '120.00', '0.00', '68 %', 'Lactulose'), 
('6246', 'Antamine   4 mg', '180-0025-21', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('6247', 'Falciquin   300 mg', '180-0011-24', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Quinine Sulphate'), 
('6248', 'Ispha   500 mg', '180-0013-006', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('6249', 'Mabendol0   100 mg', '180-0014-8', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Mebendazole'), 
('6250', 'Pancipro   500 mg', '180-0016-23', 'Tablet', 'Globex Pharmaceuticals Ltd.', '14.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('6251', 'Pantrocin   500 mg', '180-0020-23', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('6252', 'Protec R0   150 mg', '180-00175', 'Tablet', 'Globex Pharmaceuticals Ltd.', '2.00', '0.00', '150 mg', 'Ranitidine'), 
('6253', 'Tolfenac     50 mg', '180-0021-64', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('6254', 'Viomet00   400 mg', '180-0030-27', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('6255', 'Albendol00   400 mg', '180-0019-008', 'Tablet', 'Globex Pharmaceuticals Ltd.', '3.50', '0.00', '400 mg', 'Albendazole'), 
('6256', 'Caltonic   1250 mg', '180-0046-62', 'Tablet', 'Globex Pharmaceuticals Ltd.', '4.00', '0.00', '1250 mg', 'Calcium Carbonate'), 
('6257', 'Lexa   500 mg', '180-0034-23', 'Tablet', 'Globex Pharmaceuticals Ltd.', '15.00', '0.00', '500 mg', 'Levofloxacin'), 
('6258', 'Megamet   500 mg', '180-0044', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('6259', 'Mylora   10 mg', '180-0032-21', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Loratadine'), 
('6260', 'Rinzin   10 mg', '180-0040-21', 'Tablet', 'Globex Pharmaceuticals Ltd.', '3.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('6261', 'Serentil   3 mg', '180-00537', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '3 mg', 'Bromazepam'), 
('6262', 'Amynil   2 mg', '180-0052', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Glimepiride'), 
('6263', 'Amynil   1 mg', '180-0051', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '1 mg', 'Glimepiride'), 
('6264', 'Tomipril      5 mg', '180-0050-022', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Ramipril'), 
('6265', 'Tomipril.5   2.5 mg', '180-0049-022', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '2.5 mg', 'Ramipril'), 
('6266', 'Azithral00   500 mg', '180-0054-23', 'Tablet', 'Globex Pharmaceuticals Ltd.', '30.00', '0.00', '500 mg', 'Azithromycin'), 
('6267', 'Motistat   10 mg', '180-00578', 'Tablet', 'Globex Pharmaceuticals Ltd.', '2.50', '0.00', '10 mg', 'Domperidone'), 
('6268', 'Ezemove   100 mg', '180-0056-64', 'Tablet', 'Globex Pharmaceuticals Ltd.', '4.00', '0.00', '100 mg', 'Aceclofenac'), 
('6269', 'Gimrox   250 mg', '180-0077-23', 'Tablet', 'Globex Pharmaceuticals Ltd.', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('6270', 'Gimrox00   500 mg', '180-0078-23', 'Tablet', 'Globex Pharmaceuticals Ltd.', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('6271', 'Fastact   120 mg', '180-0067-21', 'Tablet', 'Globex Pharmaceuticals Ltd.', '0.00', '0.00', '120 mg', 'Fexofenadine Hydrochloride'), 
('6272', 'Seroset   8 mg', '180-00738', 'Tablet', 'Globex Pharmaceuticals Ltd.', '7.00', '0.00', '8 mg', 'Ondansetron'), 
('6273', 'Surgidol   10 mg', '180-0074-064', 'Tablet', 'Globex Pharmaceuticals Ltd.', '45.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('6274', 'Seftimax gm IV   1 gm', '180-0087-23', 'IM Injection', 'Globex Pharmaceuticals Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('6275', 'Seftimax IM   250 mg', '180-0090-23', 'IM Injection', 'Globex Pharmaceuticals Ltd.', '90.00', '0.00', '250 mg', 'Ceftriaxone'), 
('6276', 'Seftimax00 IM   500 mg', '180-0091-23', 'IM Injection', 'Globex Pharmaceuticals Ltd.', '130.00', '0.00', '500 mg', 'Ceftriaxone'), 
('6277', 'Seftimax gm   1 gm', '180-0088-23', 'IV Injection', 'Globex Pharmaceuticals Ltd.', '190.00', '0.00', '1 gm', 'Ceftriaxone'), 
('6278', 'Seftimax gm   2 gm', '180-0089-23', 'IV Injection', 'Globex Pharmaceuticals Ltd.', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('6279', 'Amoxicillin Trihydrate   100 %', '319-0004-034', 'Raw Materials', 'Gonoshasthaya Antibiotic Ltd.', '0.00', '0.00', '100 %', 'Amoxicillin Trihydrate'), 
('6280', 'Cloxacillin Sodium   100 %', '319-0002-034', 'Raw Materials', 'Gonoshasthaya Antibiotic Ltd.', '0.00', '0.00', '100 %', 'Cloxacillin'), 
('6281', 'Cephalexin   100 %', '319-0003-034', 'Raw Materials', 'Gonoshasthaya Antibiotic Ltd.', '0.00', '0.00', '100 %', 'Cephalexin'), 
('6282', 'Ampicillin Trihydrat   100 %', '319-0005-034', 'Raw Materials', 'Gonoshasthaya Antibiotic Ltd.', '0.00', '0.00', '100 %', 'Ampicillin Trihydrate'), 
('6283', 'Flucloxacillin   100 %', '319-0006-034', 'Raw Materials', 'Gonoshasthaya Antibiotic Ltd.', '0.00', '0.00', '100 %', 'Flucloxacillin Sodium'), 
('6284', 'Ciprofloxacin   100 %', '319-0008-034', 'Raw Materials', 'Gonoshasthaya Antibiotic Ltd.', '0.00', '0.00', '100 %', 'Ciprofloxacin Hydrochloride'), 
('6285', 'Cefradine   100 %', '319-0007-034', 'Raw Materials', 'Gonoshasthaya Antibiotic Ltd.', '0.00', '0.00', '100 %', 'Cephradine'), 
('6286', 'Diclofenac Potassium   100 %', '312-0003-034', 'Raw Materials', 'Gonoshasthaya Chemical Ltd.', '0.00', '0.00', '100 %', 'Diclofenac Potassium'), 
('6287', 'Paracetamol   100 %', '312-0002-034', 'Raw Materials', 'Gonoshasthaya Chemical Ltd.', '0.00', '0.00', '100 %', 'Paracetamol'), 
('6288', 'G Amoxicillin   250 mg', '185-0018-023', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '3.00', '0.00', '250 mg', 'Amoxicillin'), 
('6289', 'G Amoxycillin   500 mg', '185-0185-23', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '6.00', '0.00', '500 mg', 'Amoxicillin'), 
('6290', 'G Ampicillin   500 mg', '185-0195-23', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ampicillin'), 
('6291', 'G Ampicillin   250 mg', '185-0198-23', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Ampicillin'), 
('6292', 'G Cefradine   500 mg', '185-0186-23', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '10.00', '0.00', '500 mg', 'Cephradine'), 
('6293', 'G Cephalexin   250 mg', '185-0027-23', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '4.00', '0.00', '250 mg', 'Cephalexin'), 
('6294', 'G Cephalexin   500 mg', '185-0196-23', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('6295', 'G Cloxacillin   500 mg', '185-0080-23', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '4.50', '0.00', '500 mg', 'Cloxacillin'), 
('6296', 'G Doxacycline0   100 mg', '185-0124-23', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Doxycycline'), 
('6297', 'G Rifampicin50   450 mg', '185-0045-30', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '6.00', '0.00', '450 mg', 'Rifampicin'), 
('6298', 'G Tetracycline   250 mg', '185-0006-23', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '1.00', '0.00', '250 mg', 'Tetracycline Hydrochloride'), 
('6299', 'G Chloramphenicol   250 mg', '185-0199-23', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Chloramphenicol'), 
('6300', 'G-Lomustin   10 mg', '185-0232', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '60.00', '0.00', '10 mg', 'Lomustine'), 
('6301', 'G-Omeprazole   20 mg', '185-0221-67', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '3.00', '0.00', '20 mg', 'Omeprazole'), 
('6302', 'G-Cefixime   200 mg', '185-0237-23', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '20.00', '0.00', '200 mg', 'Cefixime'), 
('6303', 'G-Flucloxacillin00mg   500 mg', '185-0215-023', 'Capsule', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Flucloxacillin'), 
('6304', 'G Silver Sulphadiazine%   1 %', '185-0184-23', 'Cream', 'Gonoshasthaya Pharmaceuticals Ltd.', '30.00', '0.00', '1 %', 'Silver Sulphadiazine'), 
('6305', 'G Water For Injection   5 ml', '185-0036-79', 'Injection', 'Gonoshasthaya Pharmaceuticals Ltd.', '4.00', '0.00', '5 ml', 'Water For Injection'), 
('6306', 'G Amoxicillin   500 mg', '185-0114-23', 'Injection', 'Gonoshasthaya Pharmaceuticals Ltd.', '25.00', '0.00', '500 mg', 'Amoxicillin'), 
('6307', 'G Thiopentone  IV   500 mg', '185-0131', 'Injection', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Thiopentone Sodium'), 
('6308', 'G Thiopentone  IV   1 gm', '185-0130', 'Injection', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '1 gm', 'Thiopentone Sodium'), 
('6309', 'G-Lactulose Solution   68 %', '185-0269-60', 'Oral Solution', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '68 %', 'Lactulose'), 
('6310', 'G Morphine  SR   15 mg', '185-0183-65', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '14.00', '0.00', '15 mg', 'Morphine Sulphate'), 
('6311', 'G Propranolol0   40 mg', '185-0044-23', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '16.00', '0.00', '40 mg', 'Propranolol Hydrochloride'), 
('6312', 'G Albendazole     200 mg', '185-0120-008', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '2.20', '0.00', '200 mg', 'Albendazole'), 
('6313', 'G Aspirin0   100 mg', '185-0118-26', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.60', '0.00', '100 mg', 'Aspirin'), 
('6314', 'G Aspirin0   300 mg', '185-0001-6', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.20', '0.00', '300 mg', 'Aspirin'), 
('6315', 'G Calcium Lactate   300 mg', '185-0145-62', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.40', '0.00', '300 mg', 'Calcium Lactate'), 
('6316', 'G Chloroquine   250 mg', '185-0110-24', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Chloroquine Phosphate'), 
('6317', 'G Cimetidine   400 mg', '185-00525', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Cimetidine'), 
('6318', 'G-Cipro00   500 mg', '185-0197-23', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('6319', 'G Diazepam      5 mg', '185-0003-057', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.15', '0.00', '5 mg', 'Diazepam'), 
('6320', 'G Diclofenac     50 mg', '185-0119-64', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.60', '0.00', '50 mg', 'Diclofenac Sodium'), 
('6321', 'G Frusemide0   40 mg', '185-00082', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.50', '0.00', '40 mg', 'Frusemide'), 
('6322', 'G G G  Vin   500 mg', '185-0068', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '4.00', '0.00', '500 mg', 'Griseofulvin'), 
('6323', 'G Hyoscine   10 mg', '185-00391', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '3.50', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('6324', 'G Ibuprofen00   400 mg', '185-0122-64', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '1.20', '0.00', '400 mg', 'Ibuprofen'), 
('6325', 'G Isoniazide0   300 mg', '185-0060-30', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Isoniazid'), 
('6326', 'G Lisinopril      5 mg', '185-0175-22', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '2.00', '0.00', '5 mg', 'Lisinopril'), 
('6327', 'G Mebendazole0   100 mg', '185-0025-8', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '100 mg', 'Mebendazole'), 
('6328', 'G Mebendazole   500 mg', '185-0126-8', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Mebendazole'), 
('6329', 'G Metronidazole00   400 mg', '185-0048-27', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '1.00', '0.00', '400 mg', 'Metronidazole'), 
('6330', 'G Metronidazole     200 mg', '185-0079-27', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Metronidazole'), 
('6331', 'G Nifedipine   10 mg', '185-0102-22', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Nifedipine'), 
('6332', 'G Paracetamol   500 mg', '185-0002-006', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.35', '0.00', '500 mg', 'Paracetamol'), 
('6333', 'G Pefloxacin   400 mg', '185-0051-23', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '5.00', '0.00', '400 mg', 'Pefloxacin'), 
('6334', 'G Penicillin V     250 mg', '185-0062-23', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '2.28', '0.00', '250 mg', 'Phenoxymethyl Penicillin'), 
('6335', 'G Phenobarbitone   30 mg', '185-0181-046', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.75', '0.00', '30 mg', 'Phenobarbitone'), 
('6336', 'G Ranitidin0   150 mg', '185-01475', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '1.50', '0.00', '150 mg', 'Ranitidine'), 
('6337', 'G Salbutamol   4 mg', '185-00544', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '4 mg', 'Salbutamol'), 
('6338', 'G Soluable Aspirin0   300 mg', '185-0094-6', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '300 mg', 'Aspirin'), 
('6339', 'G Tamoxifen   10 mg', '185-0179', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '6.00', '0.00', '10 mg', 'Tamoxifen'), 
('6340', 'G Tamoxifen      20 mg', '185-0180', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '10.00', '0.00', '20 mg', 'Tamoxifen'), 
('6341', 'G Theophylline   300 mg', '185-00334', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '1.20', '0.00', '300 mg', 'Theophylline'), 
('6342', 'G Vitamin  B2   5 mg', '185-0128-79', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.20', '0.00', '5 mg', 'Riboflavin'), 
('6343', 'G Vitamin  B1    100 mg', '185-0127-78', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.56', '0.00', '100 mg', 'Thiamine Hydrochloride'), 
('6344', 'G Vitamin  B6   25 mg', '185-0129-78', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.14', '0.00', '25 mg', 'Pyridoxine Hydrochloride'), 
('6345', 'G Vitamin C     250 mg', '185-0076-78', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '1.30', '0.00', '250 mg', 'Vitamin C'), 
('6346', 'G Salbutamol   2 mg', '185-00554', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '2 mg', 'Salbutamol'), 
('6347', 'G Sorbide   10 mg', '185-0137', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Isosorbide Dinitrate'), 
('6348', 'G Zinc      20 mg', '185-0204-62', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '1.00', '0.00', '20 mg', 'Zinc'), 
('6349', 'G Antihistamine   4 mg', '185-0013-21', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.07', '0.00', '4 mg', 'Chlorpheniramine Maleate'), 
('6350', 'G Diclofenac      25 mg', '185-0115-64', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Diclofenac Sodium'), 
('6351', 'G Ibuprofen     200 mg', '185-0121-64', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Ibuprofen'), 
('6352', 'G Warfarin   5 mg', '185-01382', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Warfarin Sodium'), 
('6353', 'G Erythromycin   500 mg', '185-0193-23', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Erythromycin'), 
('6354', 'G Methyl Ergometrine   125 mcg', '185-01429', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.55', '0.00', '125 mcg', 'Methyl Ergometrine Maleate'), 
('6355', 'G Amitriptyline   10 mg', '185-01394', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Amitriptyline Hydrochloride'), 
('6356', 'G Amitriptyline      25 mg', '185-01404', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Amitriptyline Hydrochloride'), 
('6357', 'G - Haloperidol      5 mg', '185-0233-28', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.49', '0.00', '5 mg', 'Haloperidol'), 
('6358', 'G-Atorvastatin   10 mg', '185-0231-061', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '7.00', '0.00', '10 mg', 'Atorvastatin'), 
('6359', 'G-Atorvastatin   20 mg', '185-0230-061', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '12.50', '0.00', '20 mg', 'Atorvastatin'), 
('6360', 'G-Tamsulosin   400 mcg', '185-02689', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '400 mcg', 'Tamsulosin Hydrochloride'), 
('6361', 'G-Amlo   5 mg', '185-0216-022', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '2.50', '0.00', '5 mg', 'Amlodipine'), 
('6362', 'G-Amlo   10 mg', '185-0217-022', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '4.00', '0.00', '10 mg', 'Amlodipine'), 
('6363', 'G-Misoprostol   200 mcg', '185-01919', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '12.00', '0.00', '200 mcg', 'Misoprostol'), 
('6364', 'G-Azathioprine   50 mg', '185-0232-', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '8.00', '0.00', '50 mg', 'Azathioprine'), 
('6365', 'G-Prednisolone   5 mg', '185-0220-72', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '1.72', '0.00', '5 mg', 'Prednisolone'), 
('6366', 'G-Prazosin   1 mg', '185-0270-22', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '2.00', '0.00', '1 mg', 'Prazosin'), 
('6367', 'G-Prazosin   2 mg', '185-0271-22', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '3.00', '0.00', '2 mg', 'Prazosin'), 
('6368', 'G-Albendazole   400 mg', '185-0173-008', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '1.60', '0.00', '400 mg', 'Albendazole'), 
('6369', 'G-Methotrexate   2.5 mg', '185-0229', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '4.00', '0.00', '2.5 mg', 'Methotrexate'), 
('6370', 'G-Cyclophosphamide   50 mg', '185-0230', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Cyclophosphamide'), 
('6371', 'G-Losartan0   50 mg', '185-0250-022', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Losartan Potassium'), 
('6372', 'G-Cetrizine   10 mg', '185-0254-021', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('6373', 'G-Ramipril. mg   5 mg', '185-0235-022', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Ramipril'), 
('6374', 'G-Metformin   500 mg', '185-0241-015', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('6375', 'G-Metformin   850 mg', '185-0245-015', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '850 mg', 'Metformin Hydrochloride'), 
('6376', 'G-Gliclazide   80 mg', '185-0255-015', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '80 mg', 'Gliclazide'), 
('6377', 'G-Losartan   25 mg', '185-0249-022', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '25 mg', 'Losartan Potassium'), 
('6378', 'G-Hypophos   667 mg', '185-0282-062', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '667 mg', 'Calcium Acetate'), 
('6379', 'G-Morphine MR Tablet   10 mg', '185-0284-065', 'Tablet', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Morphine Sulphate'), 
('6380', 'G Ceftriax  IM  mg   250 mg', '185-0167-23', 'IM Injection', 'Gonoshasthaya Pharmaceuticals Ltd.', '50.00', '0.00', '250 mg', 'Ceftriaxone'), 
('6381', 'G Ceftriax  IM   1 gm', '185-0172-23', 'IM Injection', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '1 gm', 'Ceftriaxone'), 
('6382', 'G Ceftriax  IM0   500 mg', '185-0166-23', 'IM Injection', 'Gonoshasthaya Pharmaceuticals Ltd.', '80.00', '0.00', '500 mg', 'Ceftriaxone'), 
('6383', 'G Ceftriax  IV  mg   250 mg', '185-0163-23', 'IV Injection', 'Gonoshasthaya Pharmaceuticals Ltd.', '50.00', '0.00', '250 mg', 'Ceftriaxone'), 
('6384', 'G Ceftriax  IV   1 gm', '185-0162-23', 'IV Injection', 'Gonoshasthaya Pharmaceuticals Ltd.', '120.00', '0.00', '1 gm', 'Ceftriaxone'), 
('6385', 'G Ceftriax  IV0   500 mg', '185-0161-23', 'IV Injection', 'Gonoshasthaya Pharmaceuticals Ltd.', '80.00', '0.00', '500 mg', 'Ceftriaxone'), 
('6386', 'G-Ceftriax (IV)   2 gm', '185-0224-23', 'IV Injection', 'Gonoshasthaya Pharmaceuticals Ltd.', '150.00', '0.00', '2 gm', 'Ceftriaxone'), 
('6387', 'G Ampicillin   500 mg', '185-0037-23', 'IV/IM Injection', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ampicillin'), 
('6388', 'Ampicillin   100 %', '185-0084-034', 'Raw Materials', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '100 %', 'Ampicillin Trihydrate'), 
('6389', 'Crystal Violet   2 %', '185-00782', 'Eye Drops', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '2 %', 'Homatropine Hydrobromide'), 
('6390', 'G Timolol%   .25 %', '185-01422', 'Eye Drops', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '.25 %', 'Timolol Maleate'), 
('6391', 'G Homatropine%   2 %', '185-00992', 'Eye Drops', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '2 %', 'Homatropine Hydrobromide'), 
('6392', 'G Pilocarpine%   2 %', '185-00912', 'Eye Drops', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '2 %', 'Pilocarpine Hydrochloride'), 
('6393', 'G-Hypromellose Eye Drops.3%   .3 %', '185-0261-052', 'Eye Drops', 'Gonoshasthaya Pharmaceuticals Ltd.', '0.00', '0.00', '.3 %', 'Hypromellose'), 
('6394', 'Bacticell00   500 mg', '338-0005-23', 'Capsule', 'Goodman Pharmaceuticals Ltd', '0.00', '0.00', '500 mg', 'Cephradine'), 
('6395', 'G-Cefixime   200 mg', '338-023-23', 'Capsule', 'Goodman Pharmaceuticals Ltd', '0.00', '0.00', '200 mg', 'Cefixime'), 
('6396', 'Contilos0 ml   68 %', '338-0003-60', 'Oral Solution', 'Goodman Pharmaceuticals Ltd', '0.00', '0.00', '68 %', 'Lactulose'), 
('6397', 'Ranigen0   150 mg', '338-00085', 'Tablet', 'Goodman Pharmaceuticals Ltd', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('6398', 'Sentrol   10 mg', '338-0009-21', 'Tablet', 'Goodman Pharmaceuticals Ltd', '0.00', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('6399', 'G-Methotrexate   2.5 mg', '338-022', 'Tablet', 'Goodman Pharmaceuticals Ltd', '0.00', '0.00', '2.5 mg', 'Methotrexate'), 
('6400', 'G-Cyclophosphamide   50 mg', '338-023', 'Tablet', 'Goodman Pharmaceuticals Ltd', '0.00', '0.00', '50 mg', 'Cyclophosphamide'), 
('6401', 'Gefenac     50 mg', '053-0024-64', 'Tablet', 'Greenland Pharmaceuticals Ltd.', '0.00', '0.00', '50 mg', 'Diclofenac Sodium'), 
('6402', 'Gefloxin   500 mg', '053-0025-23', 'Tablet', 'Greenland Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Ciprofloxacin'), 
('6403', 'Gentid0   150 mg', '053-00225', 'Tablet', 'Greenland Pharmaceuticals Ltd.', '0.00', '0.00', '150 mg', 'Ranitidine'), 
('6404', 'Getamol   500 mg', '053-0015-006', 'Tablet', 'Greenland Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Paracetamol'), 
('6405', 'Getapan   10 mg', '053-00191', 'Tablet', 'Greenland Pharmaceuticals Ltd.', '0.00', '0.00', '10 mg', 'Hyoscine Butyl Bromide'), 
('6406', 'Gemetrol00   400 mg', '053-0023-27', 'Tablet', 'Greenland Pharmaceuticals Ltd.', '0.00', '0.00', '400 mg', 'Metronidazole'), 
('6407', 'Gentil   5 mg', '053-00208', 'Tablet', 'Greenland Pharmaceuticals Ltd.', '0.00', '0.00', '5 mg', 'Prochlorperazine Maleate'), 
('6408', 'Gevian     200 mg', '053-0028-78', 'Tablet', 'Greenland Pharmaceuticals Ltd.', '0.00', '0.00', '200 mg', 'Vitamin E'), 
('6409', 'Omilant   20 mg', '346-0012-67', 'Capsule', 'Guardian Healthcare Ltd.', '5.02', '0.00', '20 mg', 'Omeprazole'), 
('6410', 'Cemaxi   200 mg', '346-0048-23', 'Capsule', 'Guardian Healthcare Ltd.', '30.00', '0.00', '200 mg', 'Cefixime'), 
('6411', 'Nurela   50 mg', '346-0047-046', 'Capsule', 'Guardian Healthcare Ltd.', '12.00', '0.00', '50 mg', 'Pregabalin'), 
('6412', 'Itchnil   150 mg', '346-0055', 'Capsule', 'Guardian Healthcare Ltd.', '22.00', '0.00', '150 mg', 'Fluconazole'), 
('6413', 'Amoxguard00   500 mg', '346-0058-23', 'Capsule', 'Guardian Healthcare Ltd.', '6.00', '0.00', '500 mg', 'Amoxicillin'), 
('6414', 'Flubion00   500 mg', '346-0059-23', 'Capsule', 'Guardian Healthcare Ltd.', '10.50', '0.00', '500 mg', 'Flucloxacillin'), 
('6415', 'Velodin00   500 mg', '346-0061-23', 'Capsule', 'Guardian Healthcare Ltd.', '13.00', '0.00', '500 mg', 'Cephradine'), 
('6416', 'Esoflux   20 mg', '346-0083-067', 'Capsule', 'Guardian Healthcare Ltd.', '6.00', '0.00', '20 mg', 'Esomeprazole'), 
('6417', 'WFI   10 ml', '346-0043-79', 'Injection', 'Guardian Healthcare Ltd.', '0.00', '0.00', '10 ml', 'Water For Injection'), 
('6418', 'WFI   1 ml', '346-0068-79', 'Injection', 'Guardian Healthcare Ltd.', '0.00', '0.00', '1 ml', 'Water For Injection'), 
('6419', 'Amoxgard   30 %', '346-0030-077', 'Powder', 'Guardian Healthcare Ltd.', '267.80', '0.00', '30 %', 'Amoxicillin'), 
('6420', 'Ciproguard   500 mg', '346-0014-23', 'Tablet', 'Guardian Healthcare Ltd.', '14.05', '0.00', '500 mg', 'Ciprofloxacin'), 
('6421', 'Azee00   500 mg', '346-0035-23', 'Tablet', 'Guardian Healthcare Ltd.', '30.10', '0.00', '500 mg', 'Azithromycin'), 
('6422', 'Metguard   500 mg', '346-0049', 'Tablet', 'Guardian Healthcare Ltd.', '3.00', '0.00', '500 mg', 'Metformin Hydrochloride'), 
('6423', 'Pantoflux   20 mg', '346-0051-67', 'Tablet', 'Guardian Healthcare Ltd.', '4.00', '0.00', '20 mg', 'Pantoprazole'), 
('6424', 'Ranigut   150 mg', '346-00525', 'Tablet', 'Guardian Healthcare Ltd.', '2.50', '0.00', '150 mg', 'Ranitidine'), 
('6425', 'Naproxen   500 mg', '346-0053-64', 'Tablet', 'Guardian Healthcare Ltd.', '7.00', '0.00', '500 mg', 'Naproxen'), 
('6426', 'Metronidazole   400 mg', '346-0054-27', 'Tablet', 'Guardian Healthcare Ltd.', '1.26', '0.00', '400 mg', 'Metronidazole'), 
('6427', 'Tramamax   50 mg', '346-0056-65', 'Tablet', 'Guardian Healthcare Ltd.', '10.00', '0.00', '50 mg', 'Tramadol Hydrochloride'), 
('6428', 'Deslex   5 mg', '346-0077-21', 'Tablet', 'Guardian Healthcare Ltd.', '3.00', '0.00', '5 mg', 'Desloratadine'), 
('6429', 'Fightex   250 mg', '346-0062-23', 'Tablet', 'Guardian Healthcare Ltd.', '25.00', '0.00', '250 mg', 'Cefuroxime'), 
('6430', 'Fightex00   500 mg', '346-0063-23', 'Tablet', 'Guardian Healthcare Ltd.', '45.00', '0.00', '500 mg', 'Cefuroxime'), 
('6431', 'Cetirizine   10 mg', '346-0078-21', 'Tablet', 'Guardian Healthcare Ltd.', '2.50', '0.00', '10 mg', 'Cetirizine Dihydrochloride'), 
('6432', 'Maxpain   100 mg', '346-0080-64', 'Tablet', 'Guardian Healthcare Ltd.', '3.50', '0.00', '100 mg', 'Aceclofenac'), 
('6433', 'Domigut   10 mg', '346-00818', 'Tablet', 'Guardian Healthcare Ltd.', '2.50', '0.00', '10 mg', 'Domperidone'), 
('6434', 'Ketoxguard   10 mg', '346-0082-064', 'Tablet', 'Guardian Healthcare Ltd.', '8.00', '0.00', '10 mg', 'Ketorolac Tromethamine'), 
('6435', 'Gulben Vet   600 mg', '346-0002-077', 'Bolus', 'Guardian Healthcare Ltd.', '7.52', '0.00', '600 mg', 'Albendazole'), 
('6436', 'Ciprogurad Vet   750 mg', '346-0003-077', 'Bolus', 'Guardian Healthcare Ltd.', '20.06', '0.00', '750 mg', 'Ciprofloxacin'), 
('6437', 'Gcyclin Vet   500 mg', '346-0007-077', 'Bolus', 'Guardian Healthcare Ltd.', '3.01', '0.00', '500 mg', 'Oxytetracycline'), 
('6438', 'Metrogard   2 gm', '346-0017-077', 'Bolus', 'Guardian Healthcare Ltd.', '4.42', '0.00', '2 gm', 'Metronidazole'), 
('6439', 'Ciproguard   1 gm', '346-0036-077', 'Bolus', 'Guardian Healthcare Ltd.', '20.06', '0.00', '1 gm', 'Ciprofloxacin'), 
('6440', 'Melgard   100 mg', '346-0040-077', 'Bolus', 'Guardian Healthcare Ltd.', '10.03', '0.00', '100 mg', 'Meloxicam'), 
('6441', 'Promigard   150 mg', '346-0041-077', 'Bolus', 'Guardian Healthcare Ltd.', '3.25', '0.00', '150 mg', 'Promethazine Hydrochloride'), 
('6442', 'Cefoxguard IM   500 mg', '346-0074-23', 'IM Injection', 'Guardian Healthcare Ltd.', '120.00', '0.00', '500 mg', 'Ceftriaxone'), 
('6443', 'Cofoxguard IV   500 mg', '346-0071-23', 'IV Injection', 'Guardian Healthcare Ltd.', '120.00', '0.00', '500 mg', 'Ceftriaxone'), 
('6444', 'Cefoxguard IV   2 gm', '346-0073-23', 'IV Injection', 'Guardian Healthcare Ltd.', '300.00', '0.00', '2 gm', 'Ceftriaxone'), 
('6445', 'Brace   250 mg', '043-0059-023', 'Capsule', 'Hallmark Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cephradine'), 
('6446', 'Brace   500 mg', '043-0060-23', 'Capsule', 'Hallmark Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cephradine'), 
('6447', 'Docep   500 mg', '043-0027-23', 'Capsule', 'Hallmark Pharmaceuticals Ltd.', '0.00', '0.00', '500 mg', 'Cephalexin'), 
('6448', 'Docep   250 mg', '043-0026-23', 'Capsule', 'Hallmark Pharmaceuticals Ltd.', '0.00', '0.00', '250 mg', 'Cephalexin');  



 



INSERT INTO `meta_info` ( `id`, `meta_key`, `meta_value`, `meta_status`) VALUES 
('2', 'vat', '30', '');  



INSERT INTO `opening_balance` ( `id`, `date`, `opening_amount`, `initial_invest`, `closing_amount`, `status`, `trash`) VALUES 
('1', '2020-06-15', '50000.00', '4000.00', '50000.00', '1st', '0'), 
('2', '2019-01-22', '0.00', '0.00', '4500.00', '', '0'), 
('3', '2019-02-18', '0.00', '0.00', '0.00', '', '0'), 
('4', '2019-02-01', '0.00', '0.00', '0.00', '', '0');  



INSERT INTO `outstock` ( `id`, `date`, `voucher_no`, `stock_voucher_no`, `reagent`, `quantity`) VALUES 
('1', '2018-08-09', '0001', '103010', 'Disposable Gloves', '10'), 
('2', '2018-08-09', '0001', '103010', 'Syringes', '10'), 
('3', '2018-08-09', '000003', '00003', 'Disposable Gloves', '10'), 
('4', '2018-08-09', '000003', '00003', 'Glass Flask', '10'), 
('5', '2018-08-09', '000005', '00003', 'Glass Flask', '90'), 
('6', '2018-08-09', '000005', '00003', 'Disposable Gloves', '10'), 
('7', '2018-08-09', '000005', '00003', 'Syringes', '20'), 
('8', '2018-08-09', '000008', '00003', 'Glass Flask', '50'), 
('9', '2018-08-09', '000009', '00003', 'Glass Flask', '10'), 
('10', '2018-08-09', '000009', '103010', 'Disposable Gloves', '10'), 
('11', '2018-08-09', '000011', '103010', 'Syringes', '10'), 
('12', '2018-08-09', '000011', '103010', 'Disposable Gloves', '10'), 
('13', '2018-08-09', '000013', '103010', 'Syringes', '10'), 
('14', '2018-08-09', '000013', '103010', 'Disposable Gloves', '10'), 
('15', '2018-08-09', '000015', '103010', 'Syringes', '70'), 
('16', '2018-08-11', '000016', '00003', 'Glass Flask', '40'), 
('17', '2018-08-11', '000017', '00003', 'Glass Flask', '100'), 
('18', '2018-08-13', '000018', '00003', 'Glass Flask', '200'), 
('19', '2018-08-13', '000018', '103010', 'Disposable Gloves', '60'), 
('20', '2018-08-13', '000019', '00008', 'Glass Flask', '100'), 
('21', '2018-08-13', '000020', '00003', 'Glass Flask', '50');  



INSERT INTO `patients` ( `id`, `date`, `pid`, `name`, `guardian`, `gender`, `age`, `address`, `contact`) VALUES 
('1', '2018-08-11', '00001', 'Judith Carson', 'unset', 'Male', '21', 'Test', '25544558484'), 
('2', '2018-08-11', '00002', 'Khairul vai', 'unset', 'Male', '26', 'Test', '012345678'), 
('3', '0000-00-00', '00003', 'Desh medical', '', 'Male', '25', 'Jamalpur', '0123456789'), 
('4', '0000-00-00', '00004', 'Test', '', 'Male', '55', 'asdasd', '123456789'), 
('5', '0000-00-00', '00005', 'SOhel', '', 'Male', '28', 'Gangkanda', '01839973100'), 
('6', '0000-00-00', '00006', 'Mustafizur Rahman', '', 'Male', '30', 'KHulna', '01839973100'), 
('7', '0000-00-00', '00007', 'etrfdt', '', 'Male', '20', 'uu', 'yuyi'), 
('9', '0000-00-00', '00008', 'test', '', 'Male', '45', 'jbuvyv', '63219587'), 
('10', '0000-00-00', '00009', 'rr', '', 'Male', '20', '-', '-'), 
('12', '0000-00-00', '00010', 'test 2', '', 'Male', '25', '', ''), 
('16', '0000-00-00', '00011', '222', '', '0', '22', '22', '22'), 
('17', '0000-00-00', '00012', '33', '', '0', '33', '33', '33'), 
('18', '0000-00-00', '00013', '44', '', '0', '0', '', ''), 
('19', '0000-00-00', '00014', 'Shamim', '', 'Male', '22', 'Isorganj', '0160000000045'), 
('20', '0000-00-00', '00015', 'Shamim', '', 'Male', '22', 'Voluptate tempor est', '4545798854564'), 
('21', '0000-00-00', '00016', 'Jaman', '', 'Male', '30', 'Mym', '01820147153'), 
('29', '0000-00-00', '00017', '', '', '0', '0', '', ''), 
('33', '2020-06-23', '0030', 'Shamim', 'unset', 'Male', '22', 'Voluptate tempor est', '4545798854564');  



 



INSERT INTO `prescription` ( `id`, `prescription_id`, `date`, `symptoms`, `diagnosis`, `patient_name`, `medicine`, `test`) VALUES 
('1', '0001', '2018-01-03', 'Headache', 'Take sound sleep', 'sheam', '[{"medicine_type":"Tablet","medicine":"Moxilin   15 %","duration":"25 days","rules":"1+1+0","note":"After take Breakfast"},{"medicine_type":"Syrup","medicine":"Indo-A SR   75 mg","duration":"1 month","rules":"1+1+0","note":"Before take Dinner"}]', '[{"test":"R3WNVR","note":""}]'), 
('2', '0002', '2018-01-03', 'Pain ', 'No', 'sheam', '[{"medicine_type":"Tablet","medicine":"A Fenac      50 mg","duration":"7 days","rules":"0+0+1","note":"Before take Breakfast"},{"medicine_type":"Syrup","medicine":"Azin   500 mg","duration":"10 days","rules":"0+0+1","note":"After take Breakfast"}]', '[{"test":"R3WNVR","note":"Take immediatly"},{"test":"HeartWZRT","note":"Take immediatly"},{"test":"sadasd","note":"Take immediatly"}]'), 
('4', '0003', '2018-07-19', '', '', 'sheam', '[{"medicine_type":"Tablet","medicine":"Alin Vet   45 %","duration":"7 days","rules":"1\/2+1\/2+1\/2","note":"Before take Breakfast"},{"medicine_type":"Tablet","medicine":"A Fenac      50 mg","duration":"7 days","rules":"1+1+1","note":"After take Lunch"},{"medicine_type":"Cream","medicine":"Nigofon Vet   100 %","duration":"20 days","rules":"1\/2+0+1\/2","note":"Before take Dinner"}]', '[{"test":"R3WNVR","note":"asdasd"},{"test":"R3WNVR","note":"asdasd"},{"test":"R3WNVR","note":"asdasd"},{"test":"HeartWZRT","note":"asdasd"},{"test":"HeartWZRT","note":"asdasd"}]'), 
('5', '', '2018-07-23', '', '', 'sheam', '[{"medicine_type":"Tablet","medicine":"A Fenac   12.5 mg","duration":"10 days","rules":"1\/2+1\/2+1\/2","note":"Before take Breakfast"},{"medicine_type":"Tablet","medicine":"A Fenac   12.5 mg","duration":"7 days","rules":"1+1+0","note":"Before take Lunch"}]', 'null');  



INSERT INTO `privileges` ( `id`, `date`, `privilege_name`, `user_id`, `access`) VALUES 
('1', '2018-12-19', 'admin', '30', '{"dashboard":["doctors","todays_investigation","total_due","total_cost"],"doctor-menu":["add","all","commission","payment","details"],"investigation-menu":["group","test","addMenu","all"],"diagnosis-menu":["add","all"],"test_report":[],"cost_menu":["field","new","all"],"income_menu":["field","new","all"],"report_menu":["cost","drCom","diagnosis","patientReport"],"balance_menu":[],"reagent_menu":["add-new","all"],"reagent_stock_menu":["add-new","outstock","all"],"sms_menu":["send-sms","custom-sms","sms-report"],"privilege-menu":[],"theme_menu":["logo","tools"],"backup_menu":["add-new","all"]}'), 
('2', '2020-06-22', 'user', '44', '{"doctor-menu":["add","all","commission","payment","details"],"investigation-menu":["group","test","addMenu","all"]}');  



INSERT INTO `procedures` ( `id`, `test_id`, `parameter`, `referral_value`, `created_at`, `updated_at`, `deleted_at`) VALUES 
('7', '45', 'Maris Dorsey', 'Tiger Whitfield', '2020-06-21 08:17:00', '2020-06-21 08:17:00', '2020-06-22 09:17:08'), 
('6', '59', 'Regan Hall', 'Chava Patterson', '2020-06-21 08:01:02', '2020-06-21 08:01:02', '2020-06-21 18:01:08'), 
('12', '18', 'Charity ttk', '50cc >=', '2020-06-21 23:51:23', '2020-06-21 23:51:23', ''), 
('10', '62', 'Odette Mathews', 'Quincy Stone <', '2020-06-21 23:43:21', '2020-06-21 23:43:21', '2020-06-22 09:51:02'), 
('11', '18', 'Charity Trevino', '50cc >=', '2020-06-21 23:51:23', '2020-06-21 23:51:23', ''), 
('13', '3', '3.5', '4.2', '2020-06-22 05:35:16', '2020-06-22 05:35:16', ''), 
('14', '1', 'CVC', '12', '2020-06-22 05:51:23', '2020-06-22 05:51:23', '');  



INSERT INTO `products` ( `id`, `date`, `name`, `code`, `brand`, `category`, `model`, `subcategory`, `purchase_price`, `sale_price`, `unit`, `remarks`, `trash`) VALUES 
('1', '2018-07-23', 'Enhancement Capsules', '00001', 'Square', 'dextrose_anhydrous_bp', ' Enhancement Capsules - 60p', '', '110.00', '150.00', 'pcs', 'none', 'false'), 
('2', '2018-07-22', 'Enhancement Capsules', '00002', 'Square', 'dextrose_anhydrous_bp', ' Enhancement Capsules - 100 ', '', '1500.00', '2000.00', 'pcs', 'none', 'false'), 
('3', '2018-07-22', 'Asrodexn', '00003', 'ACME', 'anhydrous', 'Asrodexn 10', '', '140.00', '150.00', 'pcs', 'none', 'false'), 
('4', '2018-07-23', '', '00004', 'Square', 'anhydrous', 'Go 10', '', '100.00', '120.00', 'pcs', 'none', 'false');  



INSERT INTO `purchase` ( `id`, `date`, `voucher_no`, `category`, `subcategory`, `brand`, `code`, `product_name`, `purchase_price`, `quantity`, `discount`, `subtotal`, `total`, `total_discount`, `transport_cost`, `grand_total`, `paid`, `due`, `final_due`, `status`) VALUES 
('6', '2018-07-22', '124563', 'dextrose_anhydrous_bp', '', '', '00001', 'Enhancement Capsules', '110.00', '12', '0.00', '1320.00', '1320.00', '0.00', '0.00', '1320.00', '0.00', '1320.00', '', 'available'), 
('7', '2018-07-22', '45879', 'dextrose_anhydrous_bp', '', '', '00001', 'Enhancement Capsules', '110.00', '10', '0.00', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '0.00', '1100.00', '', 'available'), 
('8', '2018-07-22', '14564501', 'dextrose_anhydrous_bp', '', '', '00001', 'Enhancement Capsules', '110.00', '10', '0.00', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '0.00', '1100.00', '', 'available'), 
('9', '2018-07-22', '145645', 'dextrose_anhydrous_bp', '', '', '00002', 'Enhancement Capsules', '1500.00', '10', '0.00', '15000.00', '15000.00', '0.00', '0.00', '15000.00', '0.00', '15000.00', '', 'available'), 
('11', '2018-07-22', '145645140', 'anhydrous', '', '', '00003', 'Asrodexn', '140.00', '100', '0.00', '14000.00', '14000.00', '0.00', '0.00', '14000.00', '14000.00', '0.00', '', 'available'), 
('12', '2018-07-23', '14564501', '', ' Enhancement Capsules - 60p', '', '00001', ' Enhancement Capsules - 60p', '110.00', '1', '0.00', '110.00', '1610.00', '0.00', '0.00', '1610.00', '0.00', '1610.00', '', 'available'), 
('13', '2018-07-23', '14564501', '', ' Enhancement Capsules - 100 ', '', '00002', ' Enhancement Capsules - 100 ', '1500.00', '1', '0.00', '1500.00', '1610.00', '0.00', '0.00', '1610.00', '0.00', '1610.00', '', 'available'), 
('14', '2018-07-23', '1456457', '', ' Enhancement Capsules - 60p', '', '00001', ' Enhancement Capsules - 60p', '110.00', '1', '0.00', '110.00', '210.00', '0.00', '0.00', '210.00', '20.00', '190.00', '', 'available'), 
('15', '2018-07-23', '1456457', '', 'Go 10', '', '00004', 'Go 10', '100.00', '1', '0.00', '100.00', '210.00', '0.00', '0.00', '210.00', '20.00', '190.00', '', 'available'), 
('16', '2018-07-23', '7891045', 'dextrose_anhydrous_bp', ' Enhancement Capsules - 100 ', '', '00002', ' Enhancement Capsules - 100 ', '1500.00', '4', '0.00', '6000.00', '6000.00', '0.00', '0.00', '6000.00', '0.00', '6000.00', '', 'available'), 
('17', '2018-07-23', '145645000', 'dextrose_anhydrous_bp', ' Enhancement Capsules - 100 ', 'Square', '00002', ' Enhancement Capsules - 100 ', '1500.00', '2', '0.00', '3000.00', '3000.00', '0.00', '0.00', '3000.00', '0.00', '3000.00', '', 'available');  



INSERT INTO `reagent` ( `id`, `date`, `reagent`, `slug`) VALUES 
('1', '2018-08-08', 'Syringes', 'syringes'), 
('2', '2018-08-08', 'Glass flask', 'glass_flask'), 
('3', '2018-08-08', 'Disposable gloves', 'disposable_gloves'), 
('4', '2018-09-04', 'Reagent One', 'reagent_one'), 
('5', '2018-12-18', 'Test tube', 'test_tube');  



INSERT INTO `reagent_stock` ( `id`, `date`, `voucher_no`, `reagent`, `quantity`, `expire_date`, `status`) VALUES 
('1', '2018-08-09', '103010', 'Syringes', '0', '2018-08-09', 'available'), 
('2', '2018-08-09', '103010', 'Disposable Gloves', '900', '2018-08-09', 'available'), 
('3', '2018-08-09', '00003', 'Syringes', '80', '2018-08-09', 'available'), 
('4', '2018-08-09', '00003', 'Disposable Gloves', '80', '2018-08-09', 'available'), 
('5', '2018-08-09', '00003', 'Glass Flask', '450', '2018-08-09', 'available'), 
('6', '2018-08-09', '00006', 'Syringes', '10', '2018-08-09', 'available'), 
('7', '2018-08-09', '00006', 'Disposable Gloves', '100', '2018-08-09', 'available'), 
('8', '2018-08-11', '00008', 'Glass Flask', '100', '2018-08-11', 'available'), 
('9', '2018-08-13', '00009', 'Disposable Gloves', '10', '2018-08-13', 'available'), 
('10', '2018-08-13', '00009', 'Syringes', '10', '2018-08-13', 'available'), 
('11', '2018-08-13', '00010', 'Syringes', '1000', '2018-08-13', 'available'), 
('12', '2018-08-13', '00010', 'Disposable Gloves', '1000', '2018-08-13', 'available'), 
('13', '2018-08-13', '00011', 'Syringes', '55500', '2018-08-13', 'available'), 
('14', '2018-12-18', '00012', 'Syringes', '3', '2018-12-18', 'available');  



INSERT INTO `recharge_sms` ( `id`, `date`, `amount`, `sms`) VALUES 
('2', '2020-06-22', '5', '10');  



INSERT INTO `registrations` ( `id`, `date`, `pid`, `type`, `status`) VALUES 
('1', '2018-05-07', '1804090055', 'diagnosis', 'diagnosis'), 
('2', '2018-04-17', '1804090002', 'consultancy', 'consultancy'), 
('3', '2018-06-26', '1804090056', 'diagnosis', 'diagnosis'), 
('4', '2018-04-17', '1804090070', 'diagnosis', 'diagnosis'), 
('5', '0000-00-00', '1705150099', 'admitted', 'admitted'), 
('6', '0000-00-00', '1804090088', 'consultancy', 'consultancy'), 
('7', '0000-00-00', '1705150040', 'consultancy', 'consultancy'), 
('8', '0000-00-00', '1804090077', 'consultancy', 'consultancy'), 
('9', '2018-05-07', '1804090044', 'diagnosis', 'diagnosis'), 
('10', '2018-04-11', '789654', 'consultancy', 'consultancy'), 
('11', '2018-08-11', '00001', 'diagnosis', 'diagnosis'), 
('12', '2018-06-26', '125478', 'consultancy', 'consultancy'), 
('13', '2018-04-12', '47854', 'diagnosis', 'diagnosis'), 
('14', '2018-04-12', '15214', 'diagnosis', 'diagnosis'), 
('15', '2018-05-07', '4785', 'diagnosis', 'diagnosis'), 
('16', '2018-04-25', '47855', 'admitted', 'admitted'), 
('17', '2018-04-30', '47856', 'admitted', 'admitted'), 
('18', '2018-05-06', '47857', 'admitted', 'admitted'), 
('19', '2018-05-07', '141521', 'consultancy', 'consultancy'), 
('20', '2018-05-07', '4544444', 'consultancy', 'consultancy'), 
('21', '2018-05-07', '458741', 'diagnosis', 'diagnosis'), 
('22', '2018-05-07', '999999', 'diagnosis', 'diagnosis'), 
('23', '2018-05-07', '8888', 'diagnosis', 'diagnosis'), 
('24', '2018-05-07', '7777', 'diagnosis', 'diagnosis'), 
('25', '2018-06-26', '47856', 'admitted', 'admitted'), 
('26', '2018-07-10', '47857', 'admitted', 'admitted'), 
('27', '2018-07-10', '47857', 'admitted', 'admitted'), 
('28', '2018-08-11', '00001', 'diagnosis', 'diagnosis'), 
('29', '2018-08-11', '00002', 'diagnosis', 'diagnosis'), 
('45', '2020-06-23', '0030', 'consultancy', 'consultancy');  



INSERT INTO `remark` ( `id`, `remark`, `remark_id`) VALUES 
('1', 'Remark Not Set', '');  



 



INSERT INTO `salary_records` ( `id`, `date`, `eid`, `fields`, `amounts`, `remarks`, `status`) VALUES 
('1', '2018-04-19', '0001', 'basic', '100.00', 'basic', ''), 
('2', '2018-04-19', '0001', 'HRA', '10.00', 'insentive', ''), 
('3', '2018-04-19', '0001', 'DA', '10.00', 'insentive', ''), 
('4', '2018-04-19', '0001', 'TA', '10.00', 'insentive', ''), 
('5', '2018-04-19', '0001', 'CCA', '10.00', 'insentive', ''), 
('6', '2018-04-19', '0001', 'Medical', '10.00', 'insentive', ''), 
('7', '2018-04-19', '0001', 'Extra', '0.00', 'insentive', ''), 
('8', '2018-04-19', '0001', 'Advanced Pay', '10.00', 'deduction', ''), 
('9', '2018-04-19', '0001', 'Professional Tax ', '10.00', 'deduction', ''), 
('10', '2018-04-19', '0001', 'Loan', '10.00', 'deduction', ''), 
('11', '2018-04-19', '0001', 'Provisional Fund', '10.00', 'deduction', ''), 
('12', '2018-04-19', '0001', 'Extra', '2.00', 'deduction', ''), 
('13', '2018-04-19', '0001', 'Eid', '20.00', 'bonus', ''), 
('14', '2018-04-19', '0001', 'Extra', '2.00', 'bonus', ''), 
('15', '2018-04-19', '0002', 'basic', '4500.00', 'basic', ''), 
('16', '2018-04-19', '0002', 'HRA', '450.00', 'insentive', ''), 
('17', '2018-04-19', '0002', 'DA', '450.00', 'insentive', ''), 
('18', '2018-04-19', '0002', 'TA', '450.00', 'insentive', ''), 
('19', '2018-04-19', '0002', 'CCA', '450.00', 'insentive', ''), 
('20', '2018-04-19', '0002', 'Medical', '225.00', 'insentive', ''), 
('21', '2018-04-19', '0002', 'Extra', '10.00', 'insentive', ''), 
('22', '2018-04-19', '0002', 'Advanced Pay', '12.00', 'deduction', ''), 
('23', '2018-04-19', '0002', 'Professional Tax ', '12.00', 'deduction', ''), 
('24', '2018-04-19', '0002', 'Loan', '12.00', 'deduction', ''), 
('25', '2018-04-19', '0002', 'Provisional Fund', '12.00', 'deduction', ''), 
('26', '2018-04-19', '0002', 'Extra', '10.00', 'deduction', ''), 
('27', '2018-04-19', '0002', 'Eid', '675.00', 'bonus', ''), 
('28', '2018-04-19', '0002', 'Extra', '0.00', 'bonus', ''), 
('29', '2018-05-05', '0001', 'basic', '30000.00', 'basic', ''), 
('30', '2018-05-05', '0001', 'HRA', '3000.00', 'insentive', ''), 
('31', '2018-05-05', '0001', 'DA', '3000.00', 'insentive', ''), 
('32', '2018-05-05', '0001', 'TA', '3000.00', 'insentive', ''), 
('33', '2018-05-05', '0001', 'CCA', '3000.00', 'insentive', ''), 
('34', '2018-05-05', '0001', 'Medical', '3000.00', 'insentive', ''), 
('35', '2018-05-05', '0001', 'Extra', '0.00', 'insentive', ''), 
('36', '2018-05-05', '0001', 'Advanced Pay', '10.00', 'deduction', ''), 
('37', '2018-05-05', '0001', 'Professional Tax ', '10.00', 'deduction', ''), 
('38', '2018-05-05', '0001', 'Loan', '10.00', 'deduction', ''), 
('39', '2018-05-05', '0001', 'Provisional Fund', '10.00', 'deduction', ''), 
('40', '2018-05-05', '0001', 'Extra', '0.00', 'deduction', ''), 
('41', '2018-05-05', '0001', 'Eid', '15000.00', 'bonus', ''), 
('42', '2018-05-05', '0001', 'Extra', '0.00', 'bonus', ''), 
('43', '2018-07-12', '0002', 'basic', '5000.00', 'basic', ''), 
('44', '2018-07-12', '0002', 'HRA', '50.00', 'insentive', ''), 
('45', '2018-07-12', '0002', 'DA', '50.00', 'insentive', ''), 
('46', '2018-07-12', '0002', 'TA', '0.00', 'insentive', ''), 
('47', '2018-07-12', '0002', 'CCA', '0.00', 'insentive', ''), 
('48', '2018-07-12', '0002', 'Medical', '50.00', 'insentive', ''), 
('49', '2018-07-12', '0002', 'Extra', '0.00', 'insentive', ''), 
('50', '2018-07-12', '0002', 'Advanced Pay', '1000.00', 'deduction', ''), 
('51', '2018-07-12', '0002', 'Professional Tax ', '0.00', 'deduction', ''), 
('52', '2018-07-12', '0002', 'Loan', '0.00', 'deduction', ''), 
('53', '2018-07-12', '0002', 'Provisional Fund', '0.00', 'deduction', ''), 
('54', '2018-07-12', '0002', 'Extra', '0.00', 'deduction', ''), 
('55', '2018-07-12', '0002', 'Festival ', '50.00', 'bonus', ''), 
('56', '2018-07-12', '0002', 'Extra', '1000.00', 'bonus', '');  



INSERT INTO `salary_structure` ( `id`, `eid`, `basic`, `incentive`, `deduction`, `bonus`) VALUES 
('1', '0002', '5000.00', 'yes', 'yes', 'yes'), 
('2', '0002', '5000.00', 'yes', 'yes', 'yes');  



INSERT INTO `sale` ( `id`, `date`, `time`, `voucher_number`, `category`, `code`, `model`, `product`, `price`, `quantity`, `subtotal`, `total`, `discount`, `grand_total`, `paid`, `due`, `remission`, `name`, `mobile`, `status`) VALUES 
('4', '2018-07-22', '05:41:18 PM', '1807220004', '', '00001', 'Enhancement Capsules', '', '150.00', '1', '150.00', '150.00', '0.00', '150.00', '120.00', '0.00', '30.00', '', '', 'sale'), 
('5', '2018-07-22', '05:42:43 PM', '1807220005', '', '00002', ' Enhancement Capsules - 100 ', '', '2000.00', '5', '10000.00', '10150.00', '0.00', '10150.00', '0.00', '10150.00', '0.00', '', '', 'sale'), 
('6', '2018-07-22', '05:42:43 PM', '1807220005', '', '00001', 'Enhancement Capsules', '', '150.00', '1', '150.00', '10150.00', '0.00', '10150.00', '0.00', '10150.00', '0.00', '', '', 'sale'), 
('7', '2018-07-22', '05:44:23 PM', '1807220005', '', '00002', ' Enhancement Capsules - 100 ', '', '2000.00', '5', '10000.00', '10150.00', '0.00', '10150.00', '0.00', '10150.00', '0.00', '', '', 'sale'), 
('8', '2018-07-22', '05:44:23 PM', '1807220005', '', '00001', 'Enhancement Capsules', '', '150.00', '1', '150.00', '10150.00', '0.00', '10150.00', '0.00', '10150.00', '0.00', '', '', 'sale'), 
('9', '2018-07-22', '06:09:38 PM', '1807220009', '', '00001', 'Enhancement Capsules', '', '150.00', '1', '150.00', '150.00', '0.00', '150.00', '0.00', '150.00', '0.00', 'Tufayal Hossin ', '01931552620', 'sale'), 
('10', '2018-07-23', '02:20:54 PM', '1807230010', '', '00002', ' Enhancement Capsules - 100 ', '', '2000.00', '1', '2000.00', '2000.00', '0.00', '2000.00', '0.00', '2000.00', '0.00', 'Tufayal Hossin ', '01931552620', 'sale');  



INSERT INTO `sessions` ( `session_id`, `ip_address`, `user_agent`, `last_activity`, `user_data`) VALUES 
('24a70916b8fff4c8092b6ddfe8556d94', '203.89.120.5', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.106 Safari/537.36', '1592887654', 'a:12:{s:9:"user_data";s:0:"";s:7:"user_id";s:2:"45";s:12:"login_period";s:22:"2020-06-23 10:06:51 am";s:4:"name";s:10:"Rasel Alam";s:5:"email";s:20:"39alamindc@gmail.com";s:8:"username";s:9:"alamin124";s:6:"mobile";s:11:"01611926073";s:9:"privilege";s:5:"super";s:5:"image";s:29:"public/profiles/alamin124.JPG";s:6:"branch";s:0:"";s:6:"holder";s:5:"super";s:8:"loggedin";b:1;}'), 
('270a4312572dfda75b558cf6e28c39be', '203.89.120.5', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.116 Safari/537.36', '1592887581', 'a:12:{s:9:"user_data";s:0:"";s:7:"user_id";i:1001;s:12:"login_period";s:22:"2020-06-23 10:41:24 am";s:4:"name";s:16:"Freelance IT Lab";s:5:"email";s:19:"mrskuet08@gmail.com";s:8:"username";s:14:"freelanceitlab";s:6:"mobile";s:11:"01937476716";s:9:"privilege";s:5:"super";s:5:"image";s:27:"private/images/pic-male.png";s:6:"branch";s:10:"Mymensingh";s:6:"holder";s:5:"super";s:8:"loggedin";b:1;}'), 
('4290d4a105a35ab801121e4bc68f96ad', '27.123.255.174', 'Mozilla/5.0 (Windows NT 10.0; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.106 Safari/537.36', '1592889718', ''), 
('4922911407e12a1b52f51169b4cb6dca', '27.123.255.174', 'Mozilla/5.0 (Windows NT 10.0; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.106 Safari/537.36', '1592885737', 'a:11:{s:7:"user_id";s:2:"45";s:12:"login_period";s:22:"2020-06-23 10:09:18 am";s:4:"name";s:10:"Rasel Alam";s:5:"email";s:20:"39alamindc@gmail.com";s:8:"username";s:9:"alamin124";s:6:"mobile";s:11:"01611926073";s:9:"privilege";s:5:"super";s:5:"image";s:29:"public/profiles/alamin124.JPG";s:6:"branch";s:0:"";s:6:"holder";s:5:"super";s:8:"loggedin";b:1;}'), 
('63d04cb31b51af0b86fa4f318299ed56', '203.89.120.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.106 Safari/537.36', '1592889752', 'a:12:{s:9:"user_data";s:0:"";s:7:"user_id";i:1001;s:12:"login_period";s:22:"2020-06-23 09:00:54 am";s:4:"name";s:16:"Freelance IT Lab";s:5:"email";s:19:"mrskuet08@gmail.com";s:8:"username";s:14:"freelanceitlab";s:6:"mobile";s:11:"01937476716";s:9:"privilege";s:5:"super";s:5:"image";s:27:"private/images/pic-male.png";s:6:"branch";s:10:"Mymensingh";s:6:"holder";s:5:"super";s:8:"loggedin";b:1;}'), 
('7f83ef4b06e7eaf5abf813c108e57424', '198.16.70.28', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.106 Safari/537.36', '1592890794', 'a:12:{s:9:"user_data";s:0:"";s:7:"user_id";i:1001;s:12:"login_period";s:22:"2020-06-23 09:04:12 am";s:4:"name";s:16:"Freelance IT Lab";s:5:"email";s:19:"mrskuet08@gmail.com";s:8:"username";s:14:"freelanceitlab";s:6:"mobile";s:11:"01937476716";s:9:"privilege";s:5:"super";s:5:"image";s:27:"private/images/pic-male.png";s:6:"branch";s:10:"Mymensingh";s:6:"holder";s:5:"super";s:8:"loggedin";b:1;}'), 
('8566b69850ea4d7eb68e5f91b93d8a5e', '198.16.70.28', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.106 Safari/537.36', '1592891180', 'a:12:{s:9:"user_data";s:0:"";s:7:"user_id";i:1001;s:12:"login_period";s:22:"2020-06-23 11:39:59 am";s:4:"name";s:16:"Freelance IT Lab";s:5:"email";s:19:"mrskuet08@gmail.com";s:8:"username";s:14:"freelanceitlab";s:6:"mobile";s:11:"01937476716";s:9:"privilege";s:5:"super";s:5:"image";s:27:"private/images/pic-male.png";s:6:"branch";s:10:"Mymensingh";s:6:"holder";s:5:"super";s:8:"loggedin";b:1;}'), 
('90750e5e4712ebd0d0e6c5642af90dd8', '203.89.120.5', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.116 Safari/537.36', '1592887581', 'a:12:{s:9:"user_data";s:0:"";s:7:"user_id";i:1001;s:12:"login_period";s:22:"2020-06-23 10:47:11 am";s:4:"name";s:16:"Freelance IT Lab";s:5:"email";s:19:"mrskuet08@gmail.com";s:8:"username";s:14:"freelanceitlab";s:6:"mobile";s:11:"01937476716";s:9:"privilege";s:5:"super";s:5:"image";s:27:"private/images/pic-male.png";s:6:"branch";s:10:"Mymensingh";s:6:"holder";s:5:"super";s:8:"loggedin";b:1;}'), 
('ac7126bfe77a01e35242cf9d1a0402fb', '27.123.255.174', 'Mozilla/5.0 (Windows NT 10.0; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.106 Safari/537.36', '1592889122', 'a:12:{s:9:"user_data";s:0:"";s:7:"user_id";s:2:"45";s:12:"login_period";s:22:"2020-06-23 11:12:14 am";s:4:"name";s:10:"Rasel Alam";s:5:"email";s:20:"39alamindc@gmail.com";s:8:"username";s:9:"alamin124";s:6:"mobile";s:11:"01611926073";s:9:"privilege";s:5:"super";s:5:"image";s:29:"public/profiles/alamin124.JPG";s:6:"branch";s:0:"";s:6:"holder";s:5:"super";s:8:"loggedin";b:1;}'), 
('b0c8dca9bac9cd12edac931e4a8aef02', '116.58.201.119', 'Mozilla/5.0 (Linux; Android 9; Redmi Y3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.106 Mobile Safari/537.3', '1592884685', ''), 
('c2425e81d25847cd1bf6f5bcbfdca1c7', '27.123.255.174', 'Mozilla/5.0 (Windows NT 10.0; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.106 Safari/537.36', '1592885001', 'a:12:{s:9:"user_data";s:0:"";s:7:"user_id";s:2:"45";s:12:"login_period";s:22:"2020-06-23 09:23:21 am";s:4:"name";s:10:"Rasel Alam";s:5:"email";s:20:"39alamindc@gmail.com";s:8:"username";s:9:"alamin124";s:6:"mobile";s:11:"01611926073";s:9:"privilege";s:5:"super";s:5:"image";s:29:"public/profiles/alamin124.JPG";s:6:"branch";s:0:"";s:6:"holder";s:5:"super";s:8:"loggedin";b:1;}'), 
('e24e9e2a0fdc446ac2317aecbd5f974a', '203.89.120.5', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 UBrowser/6.0.1308.1016 ', '1592891301', 'a:12:{s:9:"user_data";s:0:"";s:7:"user_id";i:1001;s:12:"login_period";s:22:"2020-06-23 11:44:23 am";s:4:"name";s:16:"Freelance IT Lab";s:5:"email";s:19:"mrskuet08@gmail.com";s:8:"username";s:14:"freelanceitlab";s:6:"mobile";s:11:"01937476716";s:9:"privilege";s:5:"super";s:5:"image";s:27:"private/images/pic-male.png";s:6:"branch";s:10:"Mymensingh";s:6:"holder";s:5:"super";s:8:"loggedin";b:1;}'), 
('e775ab807e57cc2c8fcbb072e310dabc', '27.123.255.174', 'Mozilla/5.0 (Windows NT 10.0; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.106 Safari/537.36', '1592890638', 'a:12:{s:9:"user_data";s:0:"";s:7:"user_id";s:2:"45";s:12:"login_period";s:22:"2020-06-23 11:39:56 am";s:4:"name";s:10:"Rasel Alam";s:5:"email";s:20:"39alamindc@gmail.com";s:8:"username";s:9:"alamin124";s:6:"mobile";s:11:"01611926073";s:9:"privilege";s:5:"super";s:5:"image";s:29:"public/profiles/alamin124.JPG";s:6:"branch";s:0:"";s:6:"holder";s:5:"super";s:8:"loggedin";b:1;}'), 
('ee79a7a0ba1e8ae5752b56e19033fd88', '203.89.120.5', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.106 Safari/537.36', '1592889474', 'a:12:{s:9:"user_data";s:0:"";s:7:"user_id";s:2:"45";s:12:"login_period";s:22:"2020-06-23 11:10:36 am";s:4:"name";s:10:"Rasel Alam";s:5:"email";s:20:"39alamindc@gmail.com";s:8:"username";s:9:"alamin124";s:6:"mobile";s:11:"01611926073";s:9:"privilege";s:5:"super";s:5:"image";s:29:"public/profiles/alamin124.JPG";s:6:"branch";s:0:"";s:6:"holder";s:5:"super";s:8:"loggedin";b:1;}'), 
('fbbd3743aa6fdc09bacf504581fcfc9f', '203.89.120.5', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.106 Safari/537.36', '1592891371', 'a:12:{s:9:"user_data";s:0:"";s:7:"user_id";i:1001;s:12:"login_period";s:22:"2020-06-23 11:49:38 am";s:4:"name";s:16:"Freelance IT Lab";s:5:"email";s:19:"mrskuet08@gmail.com";s:8:"username";s:14:"freelanceitlab";s:6:"mobile";s:11:"01937476716";s:9:"privilege";s:5:"super";s:5:"image";s:27:"private/images/pic-male.png";s:6:"branch";s:10:"Mymensingh";s:6:"holder";s:5:"super";s:8:"loggedin";b:1;}');  



 



 



INSERT INTO `stock` ( `id`, `code`, `name`, `quantity`, `unit`, `purchase_price`, `sell_price`, `type`) VALUES 
('2', '00003', 'Asrodexn', '100', 'pcs', '140.00', '150.00', ''), 
('3', '00001', 'Enhancement Capsules', '30', 'pcs', '110.00', '150.00', ''), 
('4', '00002', ' Enhancement Capsules - 100 ', '6', 'pcs', '1500.00', '2000.00', ''), 
('5', '00004', 'Go 10', '1', 'pcs', '100.00', '120.00', '');  



INSERT INTO `test` ( `id`, `date`, `test_group`, `test_name`) VALUES 
('1', '2018-12-06', 'HAEMATOLOGY', 'TC/DC/ESR/HB%MP C/E'), 
('2', '2018-12-06', 'HAEMATOLOGY', 'Platelet Count'), 
('3', '2018-12-06', 'HAEMATOLOGY', 'BT/CT'), 
('4', '2018-12-06', 'HAEMATOLOGY', 'PBF'), 
('5', '2018-12-06', 'HAEMATOLOGY', 'Reticulacytes Count'), 
('6', '2018-12-06', 'BIOCHEMISTRY', 'Fasting/Randam'), 
('7', '2018-12-06', 'BIOCHEMISTRY', '2Hour After 75 Gram, Glucose'), 
('8', '2018-12-06', 'BIOCHEMISTRY', 'G.T.T/P.P.B.S'), 
('9', '2018-12-06', 'BIOCHEMISTRY', 'S. Bilirubin'), 
('10', '2018-12-06', 'BIOCHEMISTRY', 'S.G.P.T.(ALT)'), 
('11', '2018-12-06', 'BIOCHEMISTRY', 'S.G.O.T.(AST)'), 
('12', '2018-12-06', 'BIOCHEMISTRY', 'AIK Phos'), 
('13', '2018-12-06', 'BIOCHEMISTRY', 'S.Protin'), 
('14', '2018-12-06', 'BIOCHEMISTRY', 'S.Albomin'), 
('15', '2018-12-06', 'BIOCHEMISTRY', 'S.Cholesterol'), 
('16', '2018-12-06', 'BIOCHEMISTRY', 'S Uric Acid'), 
('17', '2018-12-06', 'BIOCHEMISTRY', 'Urea Level/ Bun'), 
('18', '2018-12-06', 'BIOCHEMISTRY', 'S. Creatinine'), 
('19', '2018-12-06', 'BIOCHEMISTRY', 'Lipid Profile'), 
('20', '2018-12-06', 'BIOCHEMISTRY', 'Prothombin Time'), 
('21', '2018-12-06', 'SEROLOGY', 'Blood For Grouping'), 
('22', '2018-12-06', 'SEROLOGY', 'A.S.O Titre'), 
('23', '2018-12-06', 'SEROLOGY', 'R/A Test'), 
('24', '2018-12-06', 'SEROLOGY', 'TPHA'), 
('25', '2018-12-06', 'SEROLOGY', 'V.D.R.L'), 
('26', '2018-12-06', 'SEROLOGY', 'Widal Test'), 
('27', '2018-12-06', 'SEROLOGY', 'Hbs Ag'), 
('28', '2018-12-06', 'SEROLOGY', 'Hbe Ag'), 
('29', '2018-12-06', 'SEROLOGY', 'Anti HCV'), 
('30', '2018-12-06', 'SEROLOGY', 'HIV'), 
('31', '2018-12-06', 'SEROLOGY', 'CRP'), 
('32', '2018-12-06', 'SEROLOGY', 'CFT For Failaria'), 
('33', '2018-12-06', 'HORMON', 'T3.T4.TSH'), 
('34', '2018-12-06', 'HORMON', 'S. Prolacten'), 
('35', '2018-12-06', 'URINE', 'R/E M/E'), 
('36', '2018-12-06', 'URINE', 'Pregnancy Test'), 
('37', '2018-12-06', 'STOOL', 'R/E M/E O BT'), 
('38', '2018-12-06', 'STOOL', 'Reducing Substasnces'), 
('39', '2018-12-06', 'STOOL', 'Others'), 
('40', '2018-12-06', 'DIGITAL X-RAY', 'Chest P/A View'), 
('41', '2018-12-06', 'DIGITAL X-RAY', 'Ba-Meal-Stomach & Duodenum'), 
('42', '2018-12-06', 'DIGITAL X-RAY', 'Ba-Swallow Oesophagus'), 
('43', '2018-12-06', 'DIGITAL X-RAY', 'K.U.B'), 
('44', '2018-12-06', 'DIGITAL X-RAY', 'Skull B V / P.N.S'), 
('45', '2018-12-06', 'DIGITAL X-RAY', 'Plain X-Ray Abdomen / C.P.D'), 
('46', '2018-12-06', 'DIGITAL X-RAY', 'Cervical Spine B.V'), 
('47', '2018-12-06', 'DIGITAL X-RAY', 'Lumbo-Sacral B.V'), 
('48', '2018-12-06', 'DIGITAL X-RAY', 'Others'), 
('49', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'HBS'), 
('50', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Thyroid'), 
('51', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Brdast'), 
('52', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Testis'), 
('53', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'K.U.B'), 
('54', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Lower Abdomen'), 
('55', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Pelvic Organs'), 
('56', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Pregnancy Profile'), 
('57', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Whole Abdomen'), 
('58', '2018-12-06', 'DIGITAL ULTRASONOGRAPHY', 'Others'), 
('59', '2018-12-06', 'OTHERS', 'Semen Analysis'), 
('60', '2018-12-06', 'OTHERS', 'MT Tuberculin Test'), 
('61', '2018-12-06', 'OTHERS', 'Haxagon T.B'), 
('62', '2018-12-06', 'OTHERS', 'IGE T.B'), 
('63', '2018-12-06', 'OTHERS', 'IGG T.B'), 
('64', '2018-12-06', 'OTHERS', 'IGM T.B'), 
('65', '2018-12-06', 'OTHERS', 'H.V.S. G/S'), 
('66', '2018-12-06', 'OTHERS', 'P/S G/S'), 
('67', '2018-12-06', 'OTHERS', 'Sputem For A.F.B');  



 



INSERT INTO `test_name` ( `id`, `group_name`, `test_name`) VALUES 
('1', 'HAEMATOLOGY', 'CBC'), 
('2', 'HAEMATOLOGY', 'Platelet Count'), 
('3', 'HAEMATOLOGY', 'BT/CT'), 
('4', 'HAEMATOLOGY', 'PBF'), 
('5', 'HAEMATOLOGY', 'Reticulacytes Count'), 
('6', 'BIOCHEMISTRY', 'Fasting/Randam'), 
('7', 'BIOCHEMISTRY', '2Hour After 75 Gram, Glucose'), 
('8', 'BIOCHEMISTRY', 'G.T.T/P.P.B.S'), 
('9', 'BIOCHEMISTRY', 'S. Bilirubin'), 
('10', 'BIOCHEMISTRY', 'S.G.P.T.(ALT)'), 
('11', 'BIOCHEMISTRY', 'S.G.O.T.(AST)'), 
('12', 'BIOCHEMISTRY', 'AIK Phos'), 
('13', 'BIOCHEMISTRY', 'S.Protin'), 
('14', 'BIOCHEMISTRY', 'S.Albomin'), 
('15', 'BIOCHEMISTRY', 'S.Cholesterol'), 
('16', 'BIOCHEMISTRY', 'S Uric Acid'), 
('17', 'BIOCHEMISTRY', 'Urea Level/ Bun'), 
('18', 'BIOCHEMISTRY', 'S. Creatinine'), 
('19', 'BIOCHEMISTRY', 'Lipid Profile'), 
('20', 'BIOCHEMISTRY', 'Prothombin Time'), 
('21', 'SEROLOGY', 'Blood For Grouping'), 
('22', 'SEROLOGY', 'A.S.O Titre'), 
('23', 'SEROLOGY', 'R/A Test'), 
('24', 'SEROLOGY', 'TPHA'), 
('25', 'SEROLOGY', 'V.D.R.L'), 
('26', 'SEROLOGY', 'Widal Test'), 
('27', 'SEROLOGY', 'Hbs Ag'), 
('28', 'SEROLOGY', 'Hbe Ag'), 
('29', 'SEROLOGY', 'Anti HCV'), 
('30', 'SEROLOGY', 'HIV'), 
('31', 'SEROLOGY', 'CRP'), 
('32', 'SEROLOGY', 'CFT For Failaria'), 
('33', 'HORMON', 'T3.T4.TSH'), 
('34', 'HORMON', 'S. Prolacten'), 
('35', 'URINE', 'R/E M/E'), 
('36', 'URINE', 'Pregnancy Test'), 
('37', 'STOOL', 'R/E M/E O BT'), 
('38', 'STOOL', 'Reducing Substasnces'), 
('39', 'STOOL', 'Others'), 
('40', 'DIGITAL X-RAY', 'Chest P/A View'), 
('41', 'DIGITAL X-RAY', 'Ba-Meal-Stomach & Duodenum'), 
('42', 'DIGITAL X-RAY', 'Ba-Swallow Oesophagus'), 
('43', 'DIGITAL X-RAY', 'K.U.B'), 
('44', 'DIGITAL X-RAY', 'Skull B V / P.N.S'), 
('45', 'DIGITAL X-RAY', 'Plain X-Ray Abdomen / C.P.D'), 
('46', 'DIGITAL X-RAY', 'Cervical Spine B.V'), 
('47', 'DIGITAL X-RAY', 'Lumbo-Sacral B.V'), 
('48', 'DIGITAL X-RAY', 'Others'), 
('49', 'DIGITAL ULTRASONOGRAPHY', 'HBS'), 
('50', 'DIGITAL ULTRASONOGRAPHY', 'Thyroid'), 
('51', 'DIGITAL ULTRASONOGRAPHY', 'Brdast'), 
('52', 'DIGITAL ULTRASONOGRAPHY', 'Testis'), 
('53', 'DIGITAL ULTRASONOGRAPHY', 'K.U.B'), 
('54', 'DIGITAL ULTRASONOGRAPHY', 'Lower Abdomen'), 
('55', 'DIGITAL ULTRASONOGRAPHY', 'Pelvic Organs'), 
('56', 'DIGITAL ULTRASONOGRAPHY', 'Pregnancy Profile'), 
('57', 'DIGITAL ULTRASONOGRAPHY', 'Whole Abdomen'), 
('58', 'DIGITAL ULTRASONOGRAPHY', 'Others'), 
('59', 'OTHERS', 'Semen Analysis'), 
('60', 'OTHERS', 'MT Tuberculin Test'), 
('61', 'OTHERS', 'Haxagon T.B'), 
('62', 'OTHERS', 'IGE T.B'), 
('63', 'OTHERS', 'IGG T.B'), 
('64', 'OTHERS', 'IGM T.B'), 
('65', 'OTHERS', 'H.V.S. G/S'), 
('66', 'OTHERS', 'P/S G/S'), 
('67', 'OTHERS', 'Sputem For A.F.B'), 
('68', 'DIGITAL ULTRASONOGRAPHY', 'Usg'), 
('69', 'HAEMATOLOGY', 'Esr'), 
('70', 'URINE', 'CUS');  



INSERT INTO `theme_setting` ( `id`, `theme_color`, `background_pattern`, `login_background`, `google_map`, `footer`, `header`, `logo`, `menu_icon`, `social_icon`, `language`) VALUES 
('1', '#00695c', 'public/img/background459623386.png', 'private/images/background24018.jpg', '<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3091.148925420826!2d89.51161527507686!3d22.87585642054873!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x39ff9a4b7a54139f%3A0x1a72740d1989f91c!2sHorticulture+Centre%2C+Doulatpur%2C+Khulna!5e0!3m2!1sen!2s!4v1488304602841" width="600" height="450" frameborder="0" style="border:0" allowfullscreen></iframe>', '{"l_footer_text":"","addr_moblile":"+8801718926673","addr_email":"contact@info.com","addr_address":"Old Dhaka Bus Stand,Muktagacha","footer_img":"public\/img\/footer_484510.jpg"}', '{"site_name":"Al Amin Diagnostics","place_name":"Muktagacha","addr_moblile":"01723926073"}', '{"logo":"public\/img\/logo_768491.jpg","faveicon":"public\/img\/favicon_672727.jpg"}', '{"aside_menu":"fa fa-angle-right","footer_menu":"fa fa-caret-right"}', '{"s_facebook":"https:\/\/facebook.com","s_twitter":"https:\/\/twitter.com","s_gplus":"https:\/\/plus.google.com","s_pinterest":"https:\/\/www.pinterest.com\/"}', 'en');  



 



INSERT INTO `users` ( `id`, `opening`, `name`, `l_name`, `gender`, `birthday`, `maritial_status`, `position`, `about`, `website`, `facecbook`, `twitter`, `email`, `username`, `password`, `privilege`, `image`, `mobile`, `branch`) VALUES 
('43', '2020-06-20 03:03:42', 'Al Amin DC', '', '', '', '', '', '', '', '', '', 'contact@alamindc.xyz', 'rasel124', '6a0b636d41f160ad5ce71b42934a8b4f', 'super', 'public/profiles/rasel124.png', '01723926073', ''), 
('44', '2020-06-22 08:45:39', 'Rajon', '', '', '', '', '', '', '', '', '', 'rajon@gmail.com', 'rajon124', 'd09aad927971b4fe091b40e8479447fd', 'user', 'public/profiles/rajon124.jpg', '01710102030', ''), 
('45', '2020-06-22 09:33:24', 'Rasel Alam', '', '', '', '', '', '', '', '', '', '39alamindc@gmail.com', 'alamin124', '42feeac3d82987bf94cb4c4a882279f7', 'super', 'public/profiles/alamin124.JPG', '01611926073', '');  



INSERT INTO `vat` ( `id`, `percentage`, `vat_id`) VALUES 
('1', '0', ''); 